\name{RangeTrack-class}
\Rdversion{1.1}
\docType{class}
\alias{RangeTrack-class}
\alias{RangeTrack}
\alias{[,RangeTrack-method}
\alias{[}
\alias{[,RangeTrack,ANY,ANY-method}
\alias{[,RangeTrack,ANY,ANY,ANY-method}
\alias{chromosome,RangeTrack-method}
\alias{chromosome}
\alias{chromosome<-,RangeTrack-method}
\alias{chromosome<-}
\alias{isActiveSeq,RangeTrack-method}
\alias{coerce,RangeTrack,data.frame-method}
\alias{end,RangeTrack-method}
\alias{end<-,RangeTrack-method}
\alias{subset,RangeTrack-method}
\alias{feature}
\alias{feature,RangeTrack-method}
\alias{feature<-}
\alias{feature<-,RangeTrack,character-method}
\alias{genome,RangeTrack-method}
\alias{genome<-,RangeTrack-method}
\alias{initialize,RangeTrack-method}
\alias{length,RangeTrack-method}
\alias{position}
\alias{range}
\alias{position,RangeTrack-method}
\alias{range,RangeTrack-method}
\alias{ranges,RangeTrack-method}
\alias{ranges<-,RangeTrack-method}
\alias{seqnames,RangeTrack-method}
\alias{seqlevels,RangeTrack-method}
\alias{seqinfo,RangeTrack-method}
\alias{split,RangeTrack,ANY-method}
\alias{split,RangeTrack-method}
\alias{start,RangeTrack-method}
\alias{start<-,RangeTrack-method}
\alias{strand,RangeTrack-method}
\alias{strand<-,RangeTrack,ANY-method}
\alias{values,RangeTrack-method}
\alias{width,RangeTrack-method}
\alias{width<-,RangeTrack-method}
\alias{min,RangeTrack-method}
\alias{max,RangeTrack-method}
\alias{consolidateTrack,RangeTrack-method}

\title{RangeTrack class and methods}

\description{

  The virtual parent class for all track items in the Gviz
  package that contain some form of genomic ranges.

}

\section{Objects from the class}{

  A virtual class: No objects may be created from it.

}

\section{Slots}{

  \describe{

    \item{\code{range}:}{Object of class \code{\linkS4class{GRanges}},
      the genomic ranges of the track items as well as additional
      annotation information in its \code{elementMetaData} slot. Please
      not that the slot is actually implemented as a class union between
      \code{GRanges} and \code{\linkS4class{IRanges}} to increase
      efficiency, for instance for \code{\linkS4class{DataTrack}}
      objects. This usualy does not concern the user.}

    \item{\code{chromosome}:}{Object of class \code{"character"}, the
      chromosome on which the track is defined. There can only be a
      single chromosome for one track. For certain subclasses, the space
      of allowed chromosome names is limited (e.g., only those
      chromosomes that exist for a particular genome). Throughout the
      package, chromosome name have to be entered either as a single
      integer scalar or as a character scalar of the form
      \code{chrXYZ}, where \emph{XYZ} may be an arbitrary
      character string.}

    \item{\code{genome}:}{Object of class \code{"character"}, the genome
      for which the track is defined. For most sub-classes this has to
      be valid UCSC genome identifier, however this may not always be
      formally checked upon object instantiation.}

    \item{\code{dp}:}{Object of class
      \code{\linkS4class{DisplayPars}}, inherited from class
      \code{\linkS4class{GdObject}}.}

    \item{\code{name}:}{Object of class \code{"character"}, inherited
      from class \code{\linkS4class{GdObject}} }

    \item{\code{imageMap}:}{Object of class
      \code{\linkS4class{ImageMap}}, inherited from class
      \code{\linkS4class{GdObject}}}

  }

}

\section{Extends}{

  Class \code{"\linkS4class{GdObject}"}, directly.

}

\section{Methods}{

  In the following code chunks, \code{obj} is considered to be an object
  of class \code{RangeTrack}.

  \bold{\emph{Exported in the name space:}}

  \describe{

    \item{[}{\code{signature(x="RangeTrack", i="ANY", j="ANY",
	drop="ANY")}: subset the items in the \code{RangeTrack}
	object. This is essentially similar to subsetting of the
	\code{\linkS4class{GRanges}} object in the \code{range}
	slot. For most applications, the \code{subset} method may be
	more appropriate.

	\emph{Additional Arguments:}

	\describe{

	  \item{}{\code{i}, \code{j}: subsetting indices, \code{j} is
	    ignored.}

	  \item{}{\code{drop}: argument is ignored.}

	}

	\emph{Examples:}

	\describe{

	  \item{}{\code{obj[1:5]}}

	}
      }


      \item{chromosome}{\code{signature(GdObject="RangeTrack")}:
	return the chromosome for which the track is defined.

	\emph{Usage:}

	\code{chromosome(GdObject)}

        \emph{Examples:}

	\describe{

	  \item{}{\code{chromosome(obj)}}

	}
      }

      \item{chromosome<-}{\code{signature(GdObject="RangeTrack")}:
	replace the value of the track's chromosome. This has to be a
	valid UCSC chromosome identifier or an integer or character
	scalar that can be reasonably coerced into one.

	\emph{Usage:}

	\code{chromosome<-(GdObject, value)}

	\emph{Additional Arguments:}

	\describe{

	  \item{}{\code{value}: replacement value.}

	}

        \emph{Examples:}

	\describe{

	  \item{}{\code{chromosome(obj) <- "chr12"}}

	}
      }

    \item{start, end, width}{\code{signature(x="RangeTrack")}: the
      start or end coordinates of the track items, or their width in
      genomic coordinates.

      \emph{Usage:}

      \code{start(x)}

      \code{end(x)}

      \code{width(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{start(obj)}}

	\item{}{\code{end(obj)}}

	\item{}{\code{width(obj)}}

      }
    }

    \item{start<-, end<-, width<-}{\code{signature(x="RangeTrack")}:
      replace the start or end coordinates of the track items, or their
      width.

      \emph{Usage:}

      \code{start<-(x, value)}

      \code{end<-(x, value)}

      \code{width<-(x, value)}

      \emph{Additional Arguments:}

	\describe{

	  \item{}{\code{value}: replacement value.}

	}

      \emph{Examples:}

      \describe{

	\item{}{\code{start(obj) <- 1:10}}

	\item{}{\code{end(obj) <- 20:30}}

	\item{}{\code{width(obj) <- 1}}

      }
    }

    \item{position}{\code{signature(GdObject="RangeTrack")}: the
      arithmetic mean of the track item's coordionates, i.e.,
      \code{(end(obj)-start(obj))/2}.

      \emph{Usage:}

      \code{position(GdObject)}

      \emph{Examples:}

      \describe{

	\item{}{\code{position(obj)}}

      }
    }

    \item{feature}{\code{signature(GdObject="RangeTrack")}: return the
      grouping information for track items. For certain sub-classes,
      groups may be indicated by different color schemes when
      plotting. See \code{\link{grouping}} or
      \code{\linkS4class{AnnotationTrack}} and
      \code{\linkS4class{GeneRegionTrack}} for details.

      \emph{Usage:}

      \code{feature(GdObject)}

      \emph{Examples:}

      \describe{

	\item{}{\code{feature(obj)}}

      }
    }

    \item{feature<-}{\code{signature(gdObject="RangeTrack",
      value="character")}: set the grouping information for track
      items. This has to be a factor vector (or another type of vector
      that can be coerced into one) of the same length as the number of
      items in the \code{RangeTrack}. See \code{\link{grouping}} or
      \code{\linkS4class{AnnotationTrack}} and
      \code{\linkS4class{GeneRegionTrack}} for details.

      \emph{Usage:}

      \code{feature<-(GdObject, value)}

      \emph{Additional Arguments:}

      \describe{

	\item{}{\code{value}: replacement value.}

      }

      \emph{Examples:}

      \describe{

	\item{}{\code{feature(obj) <- c("a", "a", "b", "c", "a")}}

      }
    }

    \item{genome}{\code{signature(x="RangeTrack")}: return the track's genome.

      \emph{Usage:}

      \code{genome(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{genome(obj)}}

      }
    }

    \item{genome<-}{\code{signature(x="RangeTrack")}: set the track's
      genome. Usually this has to be a valid UCSC identifier, however
      this is not formally enforced here.

      \emph{Usage:}

      \code{genome<-(x, value)}

      \emph{Additional Arguments:}

      \describe{

	\item{}{\code{value}: replacement value.}

      }

      \emph{Examples:}

      \describe{

	\item{}{\code{genome(obj) <- "mm9"}}

      }
    }

    \item{length}{\code{signature(x="RangeTrack")}: return the number
      of items in the track.

      \emph{Usage:}

      \code{length(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{length(obj)}}

      }
    }

    \item{range}{\code{signature(x="RangeTrack")}: return the genomic
      coordinates for the track as an object of class
      \code{\linkS4class{IRanges}}.

      \emph{Usage:}

      \code{range(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{range(obj)}}

      }
    }

    \item{ranges}{\code{signature(x="RangeTrack")}: return the genomic
      coordinates for the track along with all additional annotation
      information as an object of class \code{\linkS4class{GRanges}}.

      \emph{Usage:}

      \code{ranges(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{ranges(obj)}}

      }
    }

    \item{split}{\code{signature(x="RangeTrack")}: split a
      \code{RangeTrack} object by an appropriate factor vector (or
      another vector that can be coerced into one). The output of this
      operation is a list of objects of the same class as the input
      object, all inheriting from class \code{RangeTrack}.

      \emph{Usage:}

      \code{split(x, f, ...)}

      \emph{Additional Arguments:}

      \describe{

	\item{}{\code{f}: the splitting factor.}

	\item{}{\code{\dots}: all further arguments are ignored.}

      }

      \emph{Examples:}

      \describe{

	\item{}{\code{split(obj, c("a", "a", "b", "c", "a"))}}

      }
    }

    \item{strand}{\code{signature(x="RangeTrack")}: return a vector of
      strand specifiers for all track items, in the form '+' for the
      Watson strand, '-' for the Crick strand or '*' for either of the
      two.

      \emph{Usage:}

      \code{strand(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{strand(obj)}}

      }
    }

    \item{strand<-}{\code{signature(x="RangeTrack")}: replace the
      strand information for the track items. The replacement value
      needs to be an appropriate scalar or vector of strand values.

      \emph{Usage:}

      \code{strand<-(x, value)}

      \emph{Additional Arguments:}

      \describe{

	\item{}{\code{value}: replacement value.}

      }

      \emph{Examples:}

      \describe{

	\item{}{\code{strand(obj) <- "+"}}

      }
    }

    \item{values}{\code{signature(x="RangeTrack")}: return all
      additional annotation information except for the genomic coordinates
      for the track items as a data.frame.

      \emph{Usage:}

      \code{values(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{values(obj)}}

      }
    }

    \item{min}{\code{signature(...="RangeTrack")}:
	return the start position for the leftmost range item.

       \emph{Examples:}

      \describe{

	\item{}{\code{min(obj)}}

      }
    }


    \item{max}{\code{signature(...="RangeTrack")}:
	return the end position for the rightmost range item.

       \emph{Examples:}

      \describe{

	\item{}{\code{max(obj)}}

      }
    }

    \item{coerce}{\code{signature(from="RangeTrack", to="data.frame")}:
	coerce the \code{\linkS4class{GRanges}} object in the
	\code{range} slot into a regular data.frame.

       \emph{Examples:}

      \describe{

	\item{}{\code{as(obj, "data.frame")}}

      }
    }

    \item{subset}{\code{signature(x="RangeTrack")}: subset a
      \code{RangeTrack} by coordinates and sort if necessary.

      \emph{Usage:}

      \code{subset(x, from, to, sort=FALSE, ...)}

      \emph{Additional Arguments:}

      \describe{

	\item{}{\code{from}, \code{to}: the coordinates range to subset
	  to.}

	\item{}{\code{sort}: sort the object after subsetting. Usually
	  not necessary.}

	\item{}{\code{\dots}: additional arguments are ignored.}

      }

      \emph{Examples:}

      \describe{

	\item{}{\code{subset(obj, from=10, to=20, sort=TRUE)}}

      }
    }
  }

  \bold{\emph{Internal methods:}}

  \describe{

    \item{initialize}{\code{signature(.Object="RangeTrack")}:
      initialize the object. }
  }

   \bold{\emph{Inherited methods:}}

   \describe{

     \item{displayPars}{\code{signature(x="RangeTrack",
      name="character")}: list the value of the display parameter
      \code{name}. See \code{\link{settings}} for details on display
      parameters and customization.

      \emph{Usage:}

      \code{displayPars(x, name)}

      \emph{Examples:}

      \describe{

	\item{}{\code{displayPars(obj, "col")}}

      }
    }


    \item{displayPars}{\code{signature(x="RangeTrack", name="missing")}:
      list the value of all available display parameters. See
      \code{\link{settings}} for details on display parameters and
      customization.

      \emph{Examples:}

      \describe{

	\item{}{\code{displayPars(obj)}}

      }
    }

    \item{getPar}{\code{signature(x="RangeTrack", name="character")}:
      alias for the \code{displayPars} method. See
      \code{\link{settings}} for details on display parameters and
      customization.

      \emph{Usage:}

      \code{getPar(x, name)}

      \emph{Examples:}

      \describe{

	\item{}{\code{getPar(obj, "col")}}

      }
    }

    \item{getPar}{\code{signature(x="RangeTrack", name="missing")}:
      alias for the \code{displayPars} method. See
      \code{\link{settings}} for details on display parameters and
      customization.

      \emph{Examples:}

      \describe{

	\item{}{\code{getPar(obj)}}

      }
    }

    \item{displayPars<-}{\code{signature(x="RangeTrack", value="list")}:
      set display parameters using the values of the named list in
      \code{value}. See \code{\link{settings}} for details on display
      parameters and customization.

      \emph{Usage:}

      \code{displayPars<-(x, value)}

      \emph{Examples:}

      \describe{

	\item{}{\code{displayPars(obj) <- list(col="red", lwd=2)}}

      }
    }

    \item{setPar}{\code{signature(x="RangeTrack", value="character")}:
      set the single display parameter \code{name} to \code{value}. Note
      that display parameters in the \code{RangeTrack} class are
      pass-by-reference, so no re-assignmnet to the symbol \code{obj} is
      necessary. See \code{\link{settings}} for details on display
      parameters and customization.

      \emph{Usage:}

      \code{setPar(x, name, value)}

      \emph{Additional Arguments:}

      \describe{

	\item{}{\code{name}: the name of the display parameter to set.}

      }

      \emph{Examples:}

      \describe{

	\item{}{\code{setPar(obj, "col", "red")}}

      }
    }

    \item{setPar}{\code{signature(x="RangeTrack", value="list")}: set
      display parameters by the values of the named list in
      \code{value}.  Note that display parameters in the
      \code{RangeTrack} class are pass-by-reference, so no re-assignmnet
      to the symbol \code{obj} is necessary. See \code{\link{settings}}
      for details on display parameters and customization.


      \emph{Examples:}

      \describe{

	\item{}{\code{setPar(obj, list(col="red", lwd=2))}}

      }
    }

    \item{group}{\code{signature(GdObject="RangeTrack")}: return
      grouping information for the individual items in the track. Unless
      overwritten in one of the sub-classes, this usualy returns
      \code{NULL}.

      \emph{Usage:}

      \code{group(GdObject)}

      \emph{Examples:}

      \describe{

	\item{}{\code{group(obj)}}

      }
    }

    \item{names}{\code{signature(x="RangeTrack")}: return the value of
      the \code{name} slot.

      \emph{Usage:}

      \code{names(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{names(obj)}}

      }
    }

    \item{names<-}{\code{signature(x="RangeTrack", value="character")}:
      set the value of the \code{name} slot.

      \emph{Usage:}

      \code{names<-(x, value)}

      \emph{Examples:}

      \describe{

	\item{}{\code{names(obj) <- "foo"}}

      }
    }

    \item{coords}{\code{signature(ImageMap="RangeTrack")}: return the
      coordinates from the internal image map.

      \emph{Usage:}

      \code{coords(ImageMap)}

      \emph{Examples:}

      \describe{

	\item{}{\code{coords(obj)}}

      }
    }

    \item{tags}{\code{signature(x="RangeTrack")}: return the tags from the
      internal image map.

      \emph{Usage:}

      \code{tags(x)}

      \emph{Examples:}

      \describe{

	\item{}{\code{tags(obj)}}

      }
    }

    \item{drawAxis}{\code{signature(GdObject="RangeTrack")}: add a
      y-axis to the title panel of a track if necessary. Unless
      overwritten in one of the sub-classes this usualy does not plot
      anything and returns \code{NULL}.

      \emph{Usage:}

      \code{drawAxis(x, ...)}

      \emph{Additional Arguments:}

      \describe{

	\item{}{\code{\dots}: all further arguments are ignored.}

      }

      \emph{Examples:}

      \describe{

	\item{}{\code{Gviz:::drawAxis(obj)}}

      }
    }

    \item{drawGrid}{\code{signature(GdObject="RangeTrack")}: superpose a
      grid on top of a track if necessary. Unless overwritten in one of
      the sub-classes this usualy does not plot anything and returns
      \code{NULL}.

      \emph{Usage:}

      \code{drawGrid(GdObject, ...)}


      \emph{Additional Arguments:}

      \describe{

	\item{}{\code{\dots}: additional arguments are ignored.}

      }

      \emph{Examples:}

      \describe{

	\item{}{\code{Gviz:::drawGrid(obj)}}

      }
    }
  }
}


\section{Display Parameters}{ 

  No formal display parameters are defined for objects of class
  \code{RangeTrack}. 

  Additional display parameters are being inherited from the respective
  parent classes. Note that not all of them may have an effect on the
  plotting of \code{RangeTrack} objects. 

    \describe{ 

    \item{}{\code{\linkS4class{GdObject}}: 

      \describe{ 

        \item{}{\code{alpha=1}: Numeric scalar. The transparency for
          all track items.} 

        \item{}{\code{alpha.title=NULL}: Numeric scalar. The transparency
          for the title panel.} 

        \item{}{\code{background.legend="transparent"}: Integer or
          character scalar. The background color for the legend.} 

        \item{}{\code{background.panel="transparent"}: Integer or
          character scalar. The background color of the content panel.} 

        \item{}{\code{background.title="lightgray"}: Integer or character
          scalar. The background color for the title panel.} 

        \item{}{\code{cex=1}: Numeric scalar. The overall font expansion
          factor for all text and glyphs, unless a more specific
          definition exists.} 

        \item{}{\code{cex.axis=NULL}: Numeric scalar. The expansion
          factor for the axis annotation. Defaults to \code{NULL}, in
          which case it is automatically determined based on the
          available space.} 

        \item{}{\code{cex.title=NULL}: Numeric scalar. The expansion
          factor for the title panel. This effects the fontsize of both
          the title and the axis, if any. Defaults to \code{NULL},
          which means that the text size is automatically adjusted to
          the available space.} 

        \item{}{\code{col="#0080FF"}: Integer or character scalar.
          Default line color setting for all plotting elements, unless
          there is a more specific control defined elsewhere.} 

        \item{}{\code{col.axis="white"}: Integer or character scalar.
          The font and line color for the y axis, if any.} 

        \item{}{\code{col.border.title="white"}: Integer or character
          scalar. The border color for the title panels.} 

        \item{}{\code{col.frame="lightgray"}: Integer or character
          scalar. The line color used for the panel frame, if
          \code{frame==TRUE}} 

        \item{}{\code{col.grid="#808080"}: Integer or character scalar.
          Default line color for grid lines, both when \code{type=="g"}
          in \code{\link{DataTrack}}s and when display parameter
          \code{grid==TRUE}.} 

        \item{}{\code{col.line=NULL}: Integer or character scalar.
          Default colors for plot lines. Usually the same as the global
          \code{col} parameter.} 

        \item{}{\code{col.symbol=NULL}: Integer or character scalar.
          Default colors for plot symbols. Usually the same as the
          global \code{col} parameter.} 

        \item{}{\code{col.title="white"} \code{(Aliases: fontcolor.title)}:
          Integer or character scalar. The border color for the title panels} 

        \item{}{\code{collapse=TRUE}: Boolean controlling whether to
          collapse the content of the track to accomodate the minimum
          current device resolution. See \code{\link{collapsing}} for
          details.} 

        \item{}{\code{fill="lightgray"}: Integer or character scalar.
          Default fill color setting for all plotting elements, unless
          there is a more specific control defined elsewhere.} 

        \item{}{\code{fontcolor="black"}: Integer or character scalar.
          The font color for all text, unless a more specific definition
          exists.} 

        \item{}{\code{fontface=1}: Integer or character scalar. The
          font face for all text, unless a more specific definition exists.} 

        \item{}{\code{fontface.title=2}: Integer or character scalar.
          The font face for the title panels.} 

        \item{}{\code{fontfamily="sans"}: Integer or character scalar.
          The font family for all text, unless a more specific definition
          exists.} 

        \item{}{\code{fontfamily.title="sans"}: Integer or character
          scalar. The font family for the title panels.} 

        \item{}{\code{fontsize=12}: Numeric scalar. The font size for
          all text, unless a more specific definition exists.} 

        \item{}{\code{frame=FALSE}: Boolean. Draw a frame around the
          track when plotting.} 

        \item{}{\code{grid=FALSE}: Boolean, switching on/off the plotting
          of a grid.} 

        \item{}{\code{h=-1}: Integer scalar. Parameter controlling the
          number of horizontal grid lines, see \code{\link{panel.grid}}
          for details.} 

        \item{}{\code{lineheight=1}: Numeric scalar. The font line
          height for all text, unless a more specific definition exists.} 

        \item{}{\code{lty="solid"}: Numeric scalar. Default line type
          setting for all plotting elements, unless there is a more
          specific control defined elsewhere.} 

        \item{}{\code{lty.grid="solid"}: Integer or character scalar.
          Default line type for grid lines, both when \code{type=="g"}
          in \code{\link{DataTrack}}s and when display parameter
          \code{grid==TRUE}.} 

        \item{}{\code{lwd=1}: Numeric scalar. Default line width setting
          for all plotting elements, unless there is a more specific
          control defined elsewhere.} 

        \item{}{\code{lwd.border.title=1}: Integer scalar. The border
          width for the title panels.} 

        \item{}{\code{lwd.grid=1}: Numeric scalar. Default line width
          for grid lines, both when \code{type=="g"} in \code{\link{DataTrack}}s
          and when display parameter \code{grid==TRUE}.} 

        \item{}{\code{lwd.title=1}: Integer scalar. The border width
          for the title panels} 

        \item{}{\code{min.distance=1}: Numeric scalar. The minimum
          pixel distance before collapsing range items, only if
          \code{collapse==TRUE}. See \code{\link{collapsing}} for details.} 

        \item{}{\code{min.height=3}: Numeric scalar. The minimum range
          height in pixels to display. All ranges are expanded to this
          size in order to avoid rendering issues. See \code{\link{collapsing}}
          for details.} 

        \item{}{\code{min.width=1}: Numeric scalar. The minimum range
          width in pixels to display. All ranges are expanded to this
          size in order to avoid rendering issues. See \code{\link{collapsing}}
          for details.} 

        \item{}{\code{reverseStrand=FALSE}: Logical scalar. Set up the
          plotting coordinates in 3' -> 5' direction if \code{TRUE}.
          This will effectively mirror the plot on the vertical axis.} 

        \item{}{\code{rotation=0}: The rotation angle for all text
          unless a more specific definiton exists.} 

        \item{}{\code{rotation.title=90} \code{(Aliases: rotation.title)}:
          The rotation angle for the text in the title panel. Even
          though this can be adjusted, the automatic resizing of the
          title panel will currently not work, so use at own risk.} 

        \item{}{\code{showAxis=TRUE}: Boolean controlling whether to
          plot a y axis (only applies to track types where axes are
          implemented).} 

        \item{}{\code{showTitle=TRUE}: Boolean controlling whether to
          plot a title panel. Although this can be set individually
          for each track, in multi-track plots as created by
          \code{\link{plotTracks}} there will still be an empty
          placeholder in case any of the other tracks include a title.
          The same holds true for axes. Note that the the title panel
          background color could be set to transparent in order to
          completely hide it.} 

        \item{}{\code{size=1}: Numeric scalar. The relative size of
          the track. Can be overridden in the \code{\link{plotTracks}}
          function.} 

        \item{}{\code{v=-1}: Integer scalar. Parameter controlling the
          number of vertical grid lines, see \code{\link{panel.grid}}
          for details.} 

      } 

    } 

  } 

}



\author{Florian Hahne}

\seealso{

  \code{\linkS4class{AnnotationTrack}}

  \code{\linkS4class{DataTrack}}

  \code{\linkS4class{DisplayPars}}

  \code{\linkS4class{GRanges}}

  \code{\linkS4class{GdObject}}

  \code{\linkS4class{GeneRegionTrack}}

  \code{\linkS4class{IRanges}}

  \code{\linkS4class{ImageMap}}

  \code{\link{collapsing}}

  \code{\link{grouping}}

  \code{\link{panel.grid}}

  \code{\link{plotTracks}}

  \code{\link{settings}}

}

\keyword{classes}









































