/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OWCQUTECOM_H
#define OWCQUTECOM_H

#include <control/Control.h>

class ContactInfo;
class PQuteCom;
class QuteCom;
class Presentation;
class CUserProfileHandler;
class DtmfThemeManager;
class CDtmfThemeManager;

/**
 * @ingroup control
 * @author Tanguy Krotoff
 * @author Philippe Bernery
 * @author Mathieu Stute
 */
class CQuteCom : public Control {
public:

	CQuteCom(QuteCom & qutecomPhone, bool runInBackground);

	~CQuteCom();

	Presentation * getPresentation() const;

	CQuteCom & getCQuteCom() const;

	CDtmfThemeManager & getCDtmfThemeManager() const;

	/** FIXME should be removed. */
	QuteCom & getQuteCom() const;

	/**
	 * Entry point of the application, equivalent to main().
	 *
	 * Starts the object QuteCom thus almost everything.
	 * Starts the model component thread (the thread QuteCom).
	 *
	 * @see QuteCom::init()
	 * @see QuteCom::run()
	 */
	void start();

	/**
	 * @see QuteCom::terminate()
	 */
	void terminate();

	/**
	 * Gets the CUserProfileHandler
	 */
	CUserProfileHandler & getCUserProfileHandler() const;

	/**
	 * @see QuteCom::enableSerialization.
	 */
	void enableSerialization(bool enable);

private:

	void initPresentationThreadSafe();

	void initFinishedEventHandler(QuteCom & sender);

	void showAddContactEventHandler(ContactInfo contactInfo);

	void showAddContactEventHandlerThreadSafe(ContactInfo contactInfo);

	void bringMainWindowToFrontEventHandler();

	void bringMainWindowToFrontEventHandlerThreadSafe();

	void exitEventHandler();

	void exitEventHandlerThreadSafe();

	void dtmfThemeManagerCreatedEventHandler(QuteCom & sender, DtmfThemeManager & dtmfThemeManager);

	/** Direct link to the model. */
	QuteCom & _qutecomPhone;

	/** Direct link to the presentation via an interface. */
	PQuteCom * _pQuteCom;

	CUserProfileHandler * _cUserProfileHandler;

	/** DtmfThemeManager */
	CDtmfThemeManager * _cDtmfThemeManager;
};

#endif	//OWCQUTECOM_H
