// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Multiply-included file, hence no include guard.
// This file defines all font scripts in a manner that can be re-used to
// generate the various data tables required in RO memory, and it can not
// contain any header guards. Callers need to
// #define EXPAND_SCRIPT_FONTS to their needs and call ALL_FONT_SCRIPTS.

#define ALL_FONT_SCRIPTS(x)     \
  EXPAND_SCRIPT_FONT(x, "Afak") \
  EXPAND_SCRIPT_FONT(x, "Arab") \
  EXPAND_SCRIPT_FONT(x, "Armi") \
  EXPAND_SCRIPT_FONT(x, "Armn") \
  EXPAND_SCRIPT_FONT(x, "Avst") \
  EXPAND_SCRIPT_FONT(x, "Bali") \
  EXPAND_SCRIPT_FONT(x, "Bamu") \
  EXPAND_SCRIPT_FONT(x, "Bass") \
  EXPAND_SCRIPT_FONT(x, "Batk") \
  EXPAND_SCRIPT_FONT(x, "Beng") \
  EXPAND_SCRIPT_FONT(x, "Blis") \
  EXPAND_SCRIPT_FONT(x, "Bopo") \
  EXPAND_SCRIPT_FONT(x, "Brah") \
  EXPAND_SCRIPT_FONT(x, "Brai") \
  EXPAND_SCRIPT_FONT(x, "Bugi") \
  EXPAND_SCRIPT_FONT(x, "Buhd") \
  EXPAND_SCRIPT_FONT(x, "Cakm") \
  EXPAND_SCRIPT_FONT(x, "Cans") \
  EXPAND_SCRIPT_FONT(x, "Cari") \
  EXPAND_SCRIPT_FONT(x, "Cham") \
  EXPAND_SCRIPT_FONT(x, "Cher") \
  EXPAND_SCRIPT_FONT(x, "Cirt") \
  EXPAND_SCRIPT_FONT(x, "Copt") \
  EXPAND_SCRIPT_FONT(x, "Cprt") \
  EXPAND_SCRIPT_FONT(x, "Cyrl") \
  EXPAND_SCRIPT_FONT(x, "Cyrs") \
  EXPAND_SCRIPT_FONT(x, "Deva") \
  EXPAND_SCRIPT_FONT(x, "Dsrt") \
  EXPAND_SCRIPT_FONT(x, "Dupl") \
  EXPAND_SCRIPT_FONT(x, "Egyd") \
  EXPAND_SCRIPT_FONT(x, "Egyh") \
  EXPAND_SCRIPT_FONT(x, "Egyp") \
  EXPAND_SCRIPT_FONT(x, "Elba") \
  EXPAND_SCRIPT_FONT(x, "Ethi") \
  EXPAND_SCRIPT_FONT(x, "Geor") \
  EXPAND_SCRIPT_FONT(x, "Geok") \
  EXPAND_SCRIPT_FONT(x, "Glag") \
  EXPAND_SCRIPT_FONT(x, "Goth") \
  EXPAND_SCRIPT_FONT(x, "Gran") \
  EXPAND_SCRIPT_FONT(x, "Grek") \
  EXPAND_SCRIPT_FONT(x, "Gujr") \
  EXPAND_SCRIPT_FONT(x, "Guru") \
  EXPAND_SCRIPT_FONT(x, "Hang") \
  EXPAND_SCRIPT_FONT(x, "Hani") \
  EXPAND_SCRIPT_FONT(x, "Hano") \
  EXPAND_SCRIPT_FONT(x, "Hans") \
  EXPAND_SCRIPT_FONT(x, "Hant") \
  EXPAND_SCRIPT_FONT(x, "Hebr") \
  EXPAND_SCRIPT_FONT(x, "Hluw") \
  EXPAND_SCRIPT_FONT(x, "Hmng") \
  EXPAND_SCRIPT_FONT(x, "Hung") \
  EXPAND_SCRIPT_FONT(x, "Inds") \
  EXPAND_SCRIPT_FONT(x, "Ital") \
  EXPAND_SCRIPT_FONT(x, "Java") \
  EXPAND_SCRIPT_FONT(x, "Jpan") \
  EXPAND_SCRIPT_FONT(x, "Jurc") \
  EXPAND_SCRIPT_FONT(x, "Kali") \
  EXPAND_SCRIPT_FONT(x, "Khar") \
  EXPAND_SCRIPT_FONT(x, "Khmr") \
  EXPAND_SCRIPT_FONT(x, "Khoj") \
  EXPAND_SCRIPT_FONT(x, "Knda") \
  EXPAND_SCRIPT_FONT(x, "Kpel") \
  EXPAND_SCRIPT_FONT(x, "Kthi") \
  EXPAND_SCRIPT_FONT(x, "Lana") \
  EXPAND_SCRIPT_FONT(x, "Laoo") \
  EXPAND_SCRIPT_FONT(x, "Latf") \
  EXPAND_SCRIPT_FONT(x, "Latg") \
  EXPAND_SCRIPT_FONT(x, "Latn") \
  EXPAND_SCRIPT_FONT(x, "Lepc") \
  EXPAND_SCRIPT_FONT(x, "Limb") \
  EXPAND_SCRIPT_FONT(x, "Lina") \
  EXPAND_SCRIPT_FONT(x, "Linb") \
  EXPAND_SCRIPT_FONT(x, "Lisu") \
  EXPAND_SCRIPT_FONT(x, "Loma") \
  EXPAND_SCRIPT_FONT(x, "Lyci") \
  EXPAND_SCRIPT_FONT(x, "Lydi") \
  EXPAND_SCRIPT_FONT(x, "Mand") \
  EXPAND_SCRIPT_FONT(x, "Mani") \
  EXPAND_SCRIPT_FONT(x, "Maya") \
  EXPAND_SCRIPT_FONT(x, "Mend") \
  EXPAND_SCRIPT_FONT(x, "Merc") \
  EXPAND_SCRIPT_FONT(x, "Mero") \
  EXPAND_SCRIPT_FONT(x, "Mlym") \
  EXPAND_SCRIPT_FONT(x, "Moon") \
  EXPAND_SCRIPT_FONT(x, "Mong") \
  EXPAND_SCRIPT_FONT(x, "Mroo") \
  EXPAND_SCRIPT_FONT(x, "Mtei") \
  EXPAND_SCRIPT_FONT(x, "Mymr") \
  EXPAND_SCRIPT_FONT(x, "Narb") \
  EXPAND_SCRIPT_FONT(x, "Nbat") \
  EXPAND_SCRIPT_FONT(x, "Nkgb") \
  EXPAND_SCRIPT_FONT(x, "Nkoo") \
  EXPAND_SCRIPT_FONT(x, "Nshu") \
  EXPAND_SCRIPT_FONT(x, "Ogam") \
  EXPAND_SCRIPT_FONT(x, "Olck") \
  EXPAND_SCRIPT_FONT(x, "Orkh") \
  EXPAND_SCRIPT_FONT(x, "Orya") \
  EXPAND_SCRIPT_FONT(x, "Osma") \
  EXPAND_SCRIPT_FONT(x, "Palm") \
  EXPAND_SCRIPT_FONT(x, "Perm") \
  EXPAND_SCRIPT_FONT(x, "Phag") \
  EXPAND_SCRIPT_FONT(x, "Phli") \
  EXPAND_SCRIPT_FONT(x, "Phlp") \
  EXPAND_SCRIPT_FONT(x, "Phlv") \
  EXPAND_SCRIPT_FONT(x, "Phnx") \
  EXPAND_SCRIPT_FONT(x, "Plrd") \
  EXPAND_SCRIPT_FONT(x, "Prti") \
  EXPAND_SCRIPT_FONT(x, "Rjng") \
  EXPAND_SCRIPT_FONT(x, "Roro") \
  EXPAND_SCRIPT_FONT(x, "Runr") \
  EXPAND_SCRIPT_FONT(x, "Samr") \
  EXPAND_SCRIPT_FONT(x, "Sara") \
  EXPAND_SCRIPT_FONT(x, "Sarb") \
  EXPAND_SCRIPT_FONT(x, "Saur") \
  EXPAND_SCRIPT_FONT(x, "Sgnw") \
  EXPAND_SCRIPT_FONT(x, "Shaw") \
  EXPAND_SCRIPT_FONT(x, "Shrd") \
  EXPAND_SCRIPT_FONT(x, "Sind") \
  EXPAND_SCRIPT_FONT(x, "Sinh") \
  EXPAND_SCRIPT_FONT(x, "Sora") \
  EXPAND_SCRIPT_FONT(x, "Sund") \
  EXPAND_SCRIPT_FONT(x, "Sylo") \
  EXPAND_SCRIPT_FONT(x, "Syrc") \
  EXPAND_SCRIPT_FONT(x, "Syre") \
  EXPAND_SCRIPT_FONT(x, "Syrj") \
  EXPAND_SCRIPT_FONT(x, "Syrn") \
  EXPAND_SCRIPT_FONT(x, "Tagb") \
  EXPAND_SCRIPT_FONT(x, "Takr") \
  EXPAND_SCRIPT_FONT(x, "Tale") \
  EXPAND_SCRIPT_FONT(x, "Talu") \
  EXPAND_SCRIPT_FONT(x, "Taml") \
  EXPAND_SCRIPT_FONT(x, "Tang") \
  EXPAND_SCRIPT_FONT(x, "Tavt") \
  EXPAND_SCRIPT_FONT(x, "Telu") \
  EXPAND_SCRIPT_FONT(x, "Teng") \
  EXPAND_SCRIPT_FONT(x, "Tfng") \
  EXPAND_SCRIPT_FONT(x, "Tglg") \
  EXPAND_SCRIPT_FONT(x, "Thaa") \
  EXPAND_SCRIPT_FONT(x, "Thai") \
  EXPAND_SCRIPT_FONT(x, "Tibt") \
  EXPAND_SCRIPT_FONT(x, "Tirh") \
  EXPAND_SCRIPT_FONT(x, "Ugar") \
  EXPAND_SCRIPT_FONT(x, "Vaii") \
  EXPAND_SCRIPT_FONT(x, "Visp") \
  EXPAND_SCRIPT_FONT(x, "Wara") \
  EXPAND_SCRIPT_FONT(x, "Wole") \
  EXPAND_SCRIPT_FONT(x, "Xpeo") \
  EXPAND_SCRIPT_FONT(x, "Xsux") \
  EXPAND_SCRIPT_FONT(x, "Yiii") \
  EXPAND_SCRIPT_FONT(x, "Zmth") \
  EXPAND_SCRIPT_FONT(x, "Zsym") \
  EXPAND_SCRIPT_FONT(x, "Zyyy")
