# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._peering_management_client_operations import build_check_service_provider_availability_request
from .._vendor import PeeringManagementClientMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class PeeringManagementClientOperationsMixin(PeeringManagementClientMixinABC):
    @overload
    async def check_service_provider_availability(
        self,
        check_service_provider_availability_input: _models.CheckServiceProviderAvailabilityInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[str, _models.Enum0]:
        """Checks if the peering service provider is present within 1000 miles of customer's location.

        :param check_service_provider_availability_input: The CheckServiceProviderAvailabilityInput
         indicating customer location and service provider. Required.
        :type check_service_provider_availability_input:
         ~azure.mgmt.peering.models.CheckServiceProviderAvailabilityInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Enum0 or the result of cls(response)
        :rtype: str or ~azure.mgmt.peering.models.Enum0
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_service_provider_availability(
        self, check_service_provider_availability_input: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> Union[str, _models.Enum0]:
        """Checks if the peering service provider is present within 1000 miles of customer's location.

        :param check_service_provider_availability_input: The CheckServiceProviderAvailabilityInput
         indicating customer location and service provider. Required.
        :type check_service_provider_availability_input: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Enum0 or the result of cls(response)
        :rtype: str or ~azure.mgmt.peering.models.Enum0
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def check_service_provider_availability(
        self,
        check_service_provider_availability_input: Union[_models.CheckServiceProviderAvailabilityInput, IO],
        **kwargs: Any
    ) -> Union[str, _models.Enum0]:
        """Checks if the peering service provider is present within 1000 miles of customer's location.

        :param check_service_provider_availability_input: The CheckServiceProviderAvailabilityInput
         indicating customer location and service provider. Is either a model type or a IO type.
         Required.
        :type check_service_provider_availability_input:
         ~azure.mgmt.peering.models.CheckServiceProviderAvailabilityInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Enum0 or the result of cls(response)
        :rtype: str or ~azure.mgmt.peering.models.Enum0
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2022-10-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Union[str, _models.Enum0]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(check_service_provider_availability_input, (IO, bytes)):
            _content = check_service_provider_availability_input
        else:
            _json = self._serialize.body(
                check_service_provider_availability_input, "CheckServiceProviderAvailabilityInput"
            )

        request = build_check_service_provider_availability_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.check_service_provider_availability.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("str", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_service_provider_availability.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Peering/checkServiceProviderAvailability"}  # type: ignore
