# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class IpAddress(Model):
    """IP address for the container group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param ports: The list of ports exposed on the container group.
    :type ports: list of :class:`Port
     <azure.mgmt.containerinstance.models.Port>`
    :ivar type: Specifies if the IP is exposed to the public internet. Default
     value: "Public" .
    :vartype type: str
    :param ip: The IP exposed to the public internet.
    :type ip: str
    """

    _validation = {
        'ports': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'ports': {'key': 'ports', 'type': '[Port]'},
        'type': {'key': 'type', 'type': 'str'},
        'ip': {'key': 'ip', 'type': 'str'},
    }

    type = "Public"

    def __init__(self, ports, ip=None):
        self.ports = ports
        self.ip = ip
