dnl $Id: config.m4,v 1.2 2004/01/23 08:34:28 jon Exp $
dnl vim: expandtab

PHP_ARG_WITH(sasl, whether to enable SASL functions,
[  --with-sasl[=DIR]   Enable support for SASL functions])

if test "$PHP_SASL" != "no"; then
  SEARCH_DIRS="/usr/local /usr"
  SEARCH_SUBS="sasl sasl1 sasl2"
  SEARCH_LIBS="sasl2 sasl"

  if test -r $PHP_SASL; then
     SASL_DIR=$PHP_SASL;
  else
     AC_MSG_CHECKING(for SASL files in default path)
     for i in $SEARCH_DIRS; do
        for j in $SEARCH_SUBS; do
           if test -r $i/include/$j/sasl.h; then
              SASL_DIR=$i
              SASL_SUB=$j
              AC_MSG_RESULT(found in $i)
           fi
        done
     done
  fi

  if test -z "$SASL_DIR"; then
     AC_MSG_RESULT(not found)
     AC_MSG_ERROR(Please specify path to SASL installation)
  fi

  AC_MSG_CHECKING(for SASL library in $SASL_DIR/lib)
  for i in $SEARCH_LIBS; do
    if test -r $SASL_DIR/lib/lib$i.a; then
      SASL_LIB=$i
      AC_MSG_RESULT(found -l$i)
    fi
  done

  if test -z "$SASL_LIB"; then
     AC_MSG_RESULT(not found)
     AC_MSG_ERROR(Failed to locate a compatible SASL library in $SASL_DIR/lib)
  fi

  LIBSYMBOL=sasl_server_init
  old_LIBS=$LIBS
  LIBS="$LIBS -L$SASL_DIR/lib"
  AC_CHECK_LIB($SASL_LIB, $LIBSYMBOL, [AC_DEFINE(HAVE_SASL_LIB,1,[ ])],
               [AC_MSG_ERROR(unknown SASL library or library not found)])
  LIBS=$old_LIBS

  AC_DEFINE(HAVE_SASL,1,[ ])
  PHP_SUBST(SASL_SHARED_LIBADD)
  PHP_ADD_LIBRARY_WITH_PATH($SASL_LIB, $SASL_DIR/lib, SASL_SHARED_LIBADD)
  PHP_ADD_INCLUDE($SASL_DIR/include/$SASL_SUB)
  PHP_NEW_EXTENSION(sasl, sasl.c, $ext_shared)
fi
