# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 535-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53225);
 script_cve_id("CVE-2004-0519", "CVE-2004-0520", "CVE-2004-0521", "CVE-2004-0639");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 535-1 (squirrelmail)";
 script_name(name);

 desc = "The remote host is missing an update to squirrelmail
announced via advisory DSA 535-1.

Four vulnerabilities were discovered in squirrelmail:

CVE-2004-0519 - Multiple cross-site scripting (XSS) vulnerabilities
in SquirrelMail 1.4.2 allow remote attackers to execute arbitrary
script as other users and possibly steal authentication information
via multiple attack vectors, including the mailbox parameter in
compose.php.

CVE-2004-0520 - Cross-site scripting (XSS) vulnerability in mime.php
for SquirrelMail before 1.4.3 allows remote attackers to insert
arbitrary HTML and script via the content-type mail header, as
demonstrated using read_body.php.

CVE-2004-0521 - SQL injection vulnerability in SquirrelMail before
1.4.3 RC1 allows remote attackers to execute unauthorized SQL
statements, with unknown impact, probably via abook_database.php.

CVE-2004-0639 - Multiple cross-site scripting (XSS) vulnerabilities
in Squirrelmail 1.2.10 and earlier allow remote attackers to inject
arbitrary HTML or script via (1) the $mailer variable in
read_body.php, (2) the $senderNames_part variable in
mailbox_display.php, and possibly other vectors including (3) the
$event_title variable or (4) the $event_text variable.

For the current stable distribution (woody), these problems have been
fixed in version 1:1.2.6-1.4.

For the unstable distribution (sid), these problems have been fixed in
2:1.4.3a-0.1 and earlier versions.

We recommend that you update your squirrelmail package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20535-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 535-1 (squirrelmail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.2.6-1.4", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
