char terrain_displacement_mapping_vert[] = "#version 120\n"
                                           "\n"
                                           "#pragma import_defines ( HEIGHTFIELD_LAYER, COMPUTE_DIAGONALS, LIGHTING )\n"
                                           "\n"
                                           "#ifdef COMPUTE_DIAGONALS\n"
                                           "#extension GL_EXT_geometry_shader4 : enable\n"
                                           "#endif\n"
                                           "\n"
                                           "#ifdef HEIGHTFIELD_LAYER\n"
                                           "uniform sampler2D terrainTexture;\n"
                                           "#endif\n"
                                           "\n"
                                           "#ifdef COMPUTE_DIAGONALS\n"
                                           "varying vec2 texcoord_in;\n"
                                           "varying vec3 normals_in;\n"
                                           "varying vec4 basecolor_in;\n"
                                           "#else\n"
                                           "varying vec2 texcoord;\n"
                                           "varying vec4 basecolor;\n"
                                           "#endif\n"
                                           "\n"
                                           "\n"
                                           "#ifdef LIGHTING\n"
                                           "// forward declare lighting computation, provided by lighting.vert shader\n"
                                           "void directionalLight( int lightNum, vec3 normal, inout vec4 color );\n"
                                           "#endif\n"
                                           "\n"
                                           "void main(void)\n"
                                           "{\n"
                                           "    vec2 texcoord_center = gl_MultiTexCoord0.xy;\n"
                                           "\n"
                                           "#ifdef HEIGHTFIELD_LAYER\n"
                                           "    float height_center = texture2D(terrainTexture, texcoord_center).r;\n"
                                           "#else\n"
                                           "    float height_center = 0.0;\n"
                                           "#endif\n"
                                           "\n"
                                           "#if defined(LIGHTING) && defined(HEIGHTFIELD_LAYER)\n"
                                           "    vec2 texelWorldRatio = gl_MultiTexCoord0.zw;\n"
                                           "    vec2 texelTexcoordSize = gl_Color.xy;\n"
                                           "\n"
                                           "    vec2 texcoord_right = vec2(texcoord_center.x+texelTexcoordSize.x, texcoord_center.y);\n"
                                           "    vec2 texcoord_left = vec2(texcoord_center.x-texelTexcoordSize.x, texcoord_center.y);\n"
                                           "    vec2 texcoord_up = vec2(texcoord_center.x, texcoord_center.y+texelTexcoordSize.y);\n"
                                           "    vec2 texcoord_down = vec2(texcoord_center.x, texcoord_center.y-texelTexcoordSize.y);\n"
                                           "\n"
                                           "    float dz_dx = 0.0;\n"
                                           "    float dx = 0.0;\n"
                                           "    if (texcoord_left.x>=0.0)\n"
                                           "    {\n"
                                           "        float height = texture2D(terrainTexture, texcoord_left).r;\n"
                                           "        dz_dx += (height_center-height)*texelWorldRatio.x;\n"
                                           "        dx += 1.0;\n"
                                           "    }\n"
                                           "\n"
                                           "    if (texcoord_right.x<=1.0)\n"
                                           "    {\n"
                                           "        float height = texture2D(terrainTexture, texcoord_right).r;\n"
                                           "        dz_dx += (height-height_center)*texelWorldRatio.x;\n"
                                           "        dx += 1.0;\n"
                                           "    }\n"
                                           "\n"
                                           "    //dz_dx = 0.0;\n"
                                           "\n"
                                           "    float dx_denominator = 1.0 / sqrt(dx*dx + dz_dx*dz_dx);\n"
                                           "    float sin_rx = -dz_dx * dx_denominator;\n"
                                           "    float cos_rx = 1.0 / (dx * dx_denominator);\n"
                                           "\n"
                                           "    mat3 rotate_x_mat = mat3(cos_rx, 0.0, -sin_rx,\n"
                                           "                             0.0,    1.0,  0.0,\n"
                                           "                             sin_rx, 0.0, cos_rx);\n"
                                           "\n"
                                           "\n"
                                           "    float dz_dy = 0.0;\n"
                                           "    float dy = 0.0;\n"
                                           "    if (texcoord_down.y>=0.0)\n"
                                           "    {\n"
                                           "        float height = texture2D(terrainTexture, texcoord_down).r;\n"
                                           "        dz_dy += (height_center-height)*texelWorldRatio.y;\n"
                                           "        dy += 1.0;\n"
                                           "    }\n"
                                           "\n"
                                           "    if (texcoord_up.y<=1.0)\n"
                                           "    {\n"
                                           "        float height = texture2D(terrainTexture, texcoord_up).r;\n"
                                           "        dz_dy += (height-height_center)*texelWorldRatio.y;\n"
                                           "        dy += 1.0;\n"
                                           "    }\n"
                                           "\n"
                                           "    //dz_dy = 0.0;\n"
                                           "\n"
                                           "    float dy_denominator = 1.0 / sqrt(dy*dy + dz_dy*dz_dy);\n"
                                           "    float sin_ry = -dz_dy * dy_denominator;\n"
                                           "    float cos_ry = 1.0 / (dy_denominator*dy);\n"
                                           "\n"
                                           "    mat3 rotate_y_mat = mat3(1.0,    0.0,  0.0,\n"
                                           "                             0.0, cos_ry, -sin_ry,\n"
                                           "                             0.0, sin_ry, cos_ry);\n"
                                           "\n"
                                           "\n"
                                           "    vec3 normal = normalize(rotate_x_mat * (rotate_y_mat * gl_Normal.xyz));\n"
                                           "    //vec3 normal = normalize(gl_Normal.xyz);\n"
                                           "    vec4 color = vec4(1.0,1.0,1.0,1.0);\n"
                                           "    directionalLight( 0, normal, color);\n"
                                           "\n"
                                           "#elif defined(LIGHTING)\n"
                                           "    vec3 normal = gl_Normal.xyz;\n"
                                           "    vec4 color = vec4(1.0, 1.0, 1.0, 1.0);\n"
                                           "    directionalLight( 0, normal, color);\n"
                                           "#else\n"
                                           "    vec3 normal = gl_Normal.xyz;\n"
                                           "    vec4 color = vec4(1.0, 1.0, 1.0, 1.0);\n"
                                           "#endif\n"
                                           "\n"
                                           "\n"
                                           "#ifdef COMPUTE_DIAGONALS\n"
                                           "    normals_in = normal;\n"
                                           "    texcoord_in = texcoord_center;\n"
                                           "    basecolor_in = color;\n"
                                           "#else\n"
                                           "    texcoord = texcoord_center;\n"
                                           "    basecolor = color;\n"
                                           "#endif\n"
                                           "\n"
                                           "    vec3 position = gl_Vertex.xyz + gl_Normal.xyz * height_center;\n"
                                           "    gl_Position   = gl_ModelViewProjectionMatrix * vec4(position,1.0);\n"
                                           "\n"
                                           "}\n"
                                           "\n";
