/*
 * Copyright (c) 1998, 2006, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * Contains the collections framework, legacy collection classes,
 * event model, date and time facilities, internationalization, and
 * miscellaneous utility classes (a string tokenizer, a random-number
 * generator, and a bit array).
 *
 * <h2>Package Specification</h2>
 * <ul>
 *   <li><a href="../../../technotes/guides/collections/overview.html"><b>Collections Framework Overview</b></a>
 *   <li><a href="../../../technotes/guides/collections/reference.html"><b>
 *        Collections Framework Annotated Outline</b></a>
 * </ul>
 *
 * <h2>Related Documentation</h2>
 * For overviews, tutorials, examples, guides, and tool documentation,
 * please see:
 * <ul>
 *     <li><a href="http://docs.oracle.com/javase/tutorial/collections/index.html">
 *        <b>Collections Framework Tutorial</b></a>
 *     <li><a
 *     href="../../../technotes/guides/collections/designfaq.html"><b>Collections
 *     Framework Design FAQ</b></a>
 * </ul>
 *
 * @since 1.0
 */
package java.util;
