/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_ABSTRACT_FILLER_H_
#define _OPENRIJN_ABSTRACT_FILLER_H_

#include <OpenRijn/Export.h>

namespace GTLCore {
  class RegionI;
  class RegionF;
}

namespace OpenRijn {
  class DrawingPoint;
  class Path;
  /**
   * @ingroup OpenRijn
   *
   * This represent algorithm to fill the inside of a polygon
   */
  class OPENRIJN_EXPORT AbstractFiller {
      GTL_NO_COPY(AbstractFiller)
    public:
      AbstractFiller();
      virtual ~AbstractFiller();
      virtual void fillAt(const DrawingPoint&, float _opacity = 1.0) = 0;
      virtual void fillRegion(const GTLCore::RegionI& _region, float _opacity = 1.0 );
      virtual void fillRegion(const GTLCore::RegionF& _region, float _opacity = 1.0 );
      virtual void fillPath(const Path& _polyLine, float _opacity = 1.0 );
    private:
      struct Private;
      Private* const d;
  };
}

#endif
