/*
    This file is part of the Kasten Framework, made within the KDE community.

    Copyright 2008-2009,2011 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) version 3, or any
    later version accepted by the membership of KDE e.V. (or its
    successor approved by the membership of KDE e.V.), which shall
    act as a proxy defined in Section 6 of version 3 of the license.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef KASTEN_ABSTRACTFILESYSTEMLOADJOB_P_HPP
#define KASTEN_ABSTRACTFILESYSTEMLOADJOB_P_HPP

// lib
#include "abstractfilesystemloadjob.hpp"
#include <abstractloadjob_p.hpp>

#include <QUrl>

namespace Kasten {

class AbstractFileSystemLoadJobPrivate : public AbstractLoadJobPrivate
{
public:
    AbstractFileSystemLoadJobPrivate(AbstractFileSystemLoadJob* parent, AbstractModelFileSystemSynchronizer* synchronizer, const QUrl& url);
    AbstractFileSystemLoadJobPrivate() = delete;

    ~AbstractFileSystemLoadJobPrivate() override;

public: // KJob API
    void start();

public: // AbstractLoadJob API
    void setDocument(AbstractDocument* document);

public:
    AbstractModelFileSystemSynchronizer* synchronizer() const;
    const QUrl& url() const;
    QFile* file() const;

public: // slots
    void load();

protected:
    AbstractModelFileSystemSynchronizer* const mSynchronizer;
    const QUrl mUrl;
    QFile* mFile = nullptr;
    QString mWorkFilePath;
    QString mTempFilePath;

private:
    Q_DECLARE_PUBLIC(AbstractFileSystemLoadJob)
};

inline AbstractFileSystemLoadJobPrivate::AbstractFileSystemLoadJobPrivate(AbstractFileSystemLoadJob* parent,
                                                                          AbstractModelFileSystemSynchronizer* synchronizer, const QUrl& url)
    : AbstractLoadJobPrivate(parent)
    , mSynchronizer(synchronizer)
    , mUrl(url)
{}

inline AbstractFileSystemLoadJobPrivate::~AbstractFileSystemLoadJobPrivate() = default;

inline AbstractModelFileSystemSynchronizer* AbstractFileSystemLoadJobPrivate::synchronizer() const
{
    return mSynchronizer;
}
inline const QUrl& AbstractFileSystemLoadJobPrivate::url() const { return mUrl; }

inline QFile* AbstractFileSystemLoadJobPrivate::file()     const { return mFile; }
// TODO: setup a notification system

inline void AbstractFileSystemLoadJobPrivate::start()
{
    Q_Q(AbstractFileSystemLoadJob);

    QMetaObject::invokeMethod(q, "load", Qt::QueuedConnection);
}

}

#endif
