/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.DAVConnection;
import com.sourceforge.knecs.dsm.resourceobject.RISConnection;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.notification.ris.Lock;
import com.sourceforge.knecs.notification.ris.TimeoutHandler;
import com.sourceforge.knecs.notification.util.JMSTCPConnection;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;

public class JMSRISService
extends RISConnection
implements MessageListener {
    protected Logger mLogger = null;
    private static final String LIKE = " LIKE ";
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String OPENGROUP = " ( ";
    private static final String CLOSEGROUP = " ) ";
    protected JMSTCPConnection mConnection = null;
    protected TopicSession mSession = null;
    protected Hashtable mCacheByClassOwnerId;
    protected Hashtable mCacheById;
    protected boolean mUseCache = true;
    protected boolean mUseNotification = false;
    protected Vector mResourceClassNames;
    protected Hashtable mLocks = new Hashtable();

    public JMSRISService(String serviceURL, Vector resourceClassNames) {
        super(new DAVConnection(serviceURL));
        this.mLogger = LoggerUtils.getLogger(this);
        this.mResourceClassNames = resourceClassNames;
    }

    public void useNotification(boolean notificationOK) {
        this.mUseNotification = notificationOK;
    }

    public void useCache(boolean cacheOK) {
        this.mUseCache = cacheOK;
    }

    public Lock getLock(String resourceId) throws IOException {
        return this.getLock(resourceId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getLock(String resourceId, TimeoutHandler timeoutHandler) throws IOException {
        this.mLogger.fine("getting lock for: " + resourceId);
        Lock ret = null;
        Hashtable hashtable = this.mLocks;
        synchronized (hashtable) {
            ResourceObject ro = this.getResourceObjectById(resourceId, (String)this.mResourceClassNames.get(0));
            if (ro != null) {
                Lock lock = (Lock)this.mLocks.get(resourceId);
                if (lock == null) {
                    this.mLogger.fine("No lock exists - creating new one");
                    lock = new Lock(resourceId, timeoutHandler);
                    this.mLogger.fine("new lock = " + lock);
                    this.mLocks.put(resourceId, lock);
                    ret = lock;
                } else if (lock.hasTimedOut()) {
                    this.mLogger.fine("Lock timed out - creating new one");
                    lock.notifyOwner();
                    lock = new Lock(resourceId, timeoutHandler);
                    this.mLogger.fine("new lock = " + lock);
                    this.mLocks.put(resourceId, lock);
                    ret = lock;
                }
            }
        }
        this.mLogger.fine("result of lock = " + ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String id) throws IOException {
        Hashtable hashtable = this.mLocks;
        synchronized (hashtable) {
            this.mLocks.remove(id);
        }
    }

    public boolean isLocked(String id) {
        return this.mLocks.containsKey(id);
    }

    public boolean isLockValid(Lock lock) {
        this.mLogger.fine(this + ".isLockValid()");
        this.mLogger.fine("lock = " + lock);
        boolean ret = false;
        if (lock != null) {
            Lock cachedLock = (Lock)this.mLocks.get(lock.getLockedResourceId());
            this.mLogger.fine("lock in cache = " + cachedLock);
            if (cachedLock == lock) {
                ret = true;
            }
        }
        this.mLogger.fine("lock valid = " + ret);
        return ret;
    }

    public void connect(String aUserID, String anAuthToken) {
        super.connect(aUserID, anAuthToken);
        if (this.mUseCache) {
            this.mCacheByClassOwnerId = new Hashtable();
            this.mCacheById = new Hashtable();
            String className = null;
            try {
                for (int j = 0; j < this.mResourceClassNames.size(); ++j) {
                    Hashtable<String, Hashtable<String, ResourceObject>> classResources = new Hashtable<String, Hashtable<String, ResourceObject>>();
                    className = (String)this.mResourceClassNames.elementAt(j);
                    this.mCacheByClassOwnerId.put(className, classResources);
                    ResourceObject[] tmp = this.getResourceObjects(Class.forName(className), (QueryPredicate)null);
                    if (tmp == null) continue;
                    for (int i = 0; i < tmp.length; ++i) {
                        String owner = tmp[i].getOwnerId();
                        String id = tmp[i].getId();
                        Hashtable<String, ResourceObject> ownerResources = (Hashtable<String, ResourceObject>)classResources.get(owner);
                        if (ownerResources == null) {
                            ownerResources = new Hashtable<String, ResourceObject>();
                            classResources.put(owner, ownerResources);
                        }
                        ownerResources.put(id, tmp[i]);
                        this.mCacheById.put(id, tmp[i]);
                    }
                }
            }
            catch (ClassNotFoundException nfex) {
                this.mLogger.severe("Class not found: " + className);
            }
            catch (RISException risex) {
                this.mLogger.severe("Unable to get resource objects for " + className + "\n" + risex.getMessage());
            }
            catch (Exception e) {
                this.mLogger.severe("Problem loading ResourceObjects" + e.toString());
                this.mLogger.severe("Stack" + LoggerUtils.getStackTrace(e));
            }
        } else {
            this.mCacheByClassOwnerId = null;
        }
    }

    public void establishJMSConnection() throws JMSException {
        this.mConnection = new JMSTCPConnection();
        this.mConnection.startConnection();
        this.mSession = this.mConnection.getConnection().createTopicSession(false, 1);
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        Topic topic = this.mSession.createTopic(props.getProperty("samchangenotify"));
        String filter = this.buildFilter();
        TopicSubscriber subscriber = this.mSession.createSubscriber(topic, filter, false);
        subscriber.setMessageListener((MessageListener)this);
    }

    public TopicConnection getConnection() {
        return this.mConnection.getConnection();
    }

    public void closeJMSConnection() throws JMSException {
        try {
            if (this.mConnection != null) {
                this.mConnection.closeConnection();
                this.mConnection = null;
            }
        }
        catch (Exception e) {
            this.mLogger.severe("Exception closing JMS Connection " + e.getMessage());
        }
    }

    public synchronized Vector getURLFilters() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String path = props.getProperty("portalobjects");
        Vector<String> ret = new Vector<String>();
        ret.add("%" + path + "%");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        block23: {
            if (!this.mUseNotification) {
                return;
            }
            CMCSProperties props = CMCSProperties.getCMCSProperties();
            String url = null;
            String method = null;
            try {
                url = msg.getStringProperty(props.getProperty("samurl"));
                this.mLogger.info("\nJMS UPDATE MESSAGE RECIEVED FOR FILE: " + url + "\n");
                method = msg.getStringProperty(props.getProperty("sammethod"));
                this.mLogger.info("JMS Update " + url + " " + method);
                if (method.equals("PROPPATCH")) {
                    try {
                        ResourceObject obj = this.getResourceObject(url);
                        obj.log();
                        if (this.mUseCache) {
                            Hashtable hashtable = this.mCacheById;
                            synchronized (hashtable) {
                                String id = obj.getId();
                                String owner = obj.getOwnerId();
                                String className = obj.getClass().getName();
                                this.mLogger.fine("Trying to ADD RESOURCE in MessageHandler: " + className + ":" + id + ":" + owner);
                                this.mCacheById.put(id, obj);
                                Hashtable classResources = (Hashtable)this.mCacheByClassOwnerId.get(className);
                                if (classResources != null) {
                                    Hashtable<String, ResourceObject> ownerResources = (Hashtable<String, ResourceObject>)classResources.get(owner);
                                    if (ownerResources == null) {
                                        ownerResources = new Hashtable<String, ResourceObject>();
                                        classResources.put(owner, ownerResources);
                                    }
                                    ownerResources.put(id, obj);
                                } else {
                                    this.mLogger.severe("Trying to save object for unregistered class " + className);
                                }
                            }
                        }
                        this.fireDataSaveEvent(obj);
                    }
                    catch (RISException ex) {
                        this.mLogger.severe("JMS Update received, but failed: " + url);
                    }
                    break block23;
                }
                if (!method.equals("DELETE")) break block23;
                if (this.mUseCache) {
                    Hashtable ex = this.mCacheById;
                    synchronized (ex) {
                        String id = this.mRisNaming.getName(url);
                        ResourceObject obj = (ResourceObject)this.mCacheById.get(id);
                        if (obj != null) {
                            String owner = obj.getOwnerId();
                            String className = obj.getClass().getName();
                            this.mLogger.fine("\nTrying to REMOVE RESOURCE in MessageHandler: " + className + ":" + id + ":" + owner + "\n");
                            this.mCacheById.remove(id);
                            Hashtable classResources = (Hashtable)this.mCacheByClassOwnerId.get(className);
                            if (classResources != null) {
                                Hashtable ownerResources = (Hashtable)classResources.get(owner);
                                if (ownerResources != null) {
                                    ownerResources.remove(id);
                                } else {
                                    this.mLogger.severe("Trying to remove object for unregistered owner " + owner);
                                }
                            } else {
                                this.mLogger.severe("Trying to remove object for unregistered class " + className);
                            }
                        } else {
                            this.mLogger.warning("Trying to delete: " + url + " but it was not in the cache.");
                        }
                    }
                }
                String uniqueId = this.mRisNaming.getName(url);
                this.fireDataRemoveEvent(uniqueId);
            }
            catch (JMSException ex) {
                this.mLogger.severe("Error getting properties" + ex.getMessage());
            }
        }
    }

    protected synchronized String buildFilter() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        StringBuffer buf = new StringBuffer();
        Vector urls = this.getURLFilters();
        buf.append(OPENGROUP);
        for (int i = 0; i < urls.size(); ++i) {
            if (i != 0) {
                buf.append(OR);
            }
            buf.append(props.getProperty("samurl"));
            buf.append(LIKE);
            buf.append("'");
            buf.append((String)urls.elementAt(i));
            buf.append("'");
        }
        buf.append(CLOSEGROUP);
        buf.append(AND);
        buf.append(OPENGROUP);
        buf.append(props.getProperty("sammethod"));
        buf.append(LIKE);
        buf.append("'");
        buf.append("PROPPATCH");
        buf.append("'");
        buf.append(OR);
        buf.append(props.getProperty("sammethod"));
        buf.append(LIKE);
        buf.append("'");
        buf.append("DELETE");
        buf.append("'");
        buf.append(CLOSEGROUP);
        return new String(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceObject getResourceObjectById(String uniqueId, String className) {
        ResourceObject ret = null;
        if (this.mUseCache) {
            Hashtable hashtable = this.mCacheById;
            synchronized (hashtable) {
                ret = (ResourceObject)this.mCacheById.get(uniqueId);
            }
        }
        this.mLogger.info("Getting ResourceObject for " + uniqueId);
        try {
            QueryPredicate qp = new QueryPredicate(new NSProperty("http://purl.org/dc/elements/1.1/:identifier"), uniqueId, "==", true);
            ResourceObject[] tmp = this.getResourceObjects(Class.forName(className), qp);
            if (tmp != null && tmp.length > 0) {
                ret = tmp[0];
            }
        }
        catch (ClassNotFoundException nfex) {
            this.mLogger.severe("Class not found: " + className);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to get resource for" + className + ": " + risex.getMessage());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getResourceObjectsByOwner(String owner, String className) {
        Collection<Object> ret = null;
        if (this.mUseCache) {
            Hashtable hashtable = this.mCacheById;
            synchronized (hashtable) {
                Hashtable classResources = (Hashtable)this.mCacheByClassOwnerId.get(className);
                if (classResources != null) {
                    Hashtable ownerResources = (Hashtable)classResources.get(owner);
                    if (ownerResources == null) {
                        ownerResources = new Hashtable();
                        this.mCacheByClassOwnerId.put(owner, ownerResources);
                    }
                    ret = ownerResources.values();
                } else {
                    ret = new Vector();
                    this.mLogger.severe("Trying to get portal objects for unregistered class " + className);
                }
            }
        }
        this.mLogger.info("Getting className  for " + owner);
        try {
            QueryPredicate qp = new QueryPredicate(new NSProperty("http://purl.oclc.org/NET/cmcs/internal/schema/:ownerid"), owner, "==", true);
            ResourceObject[] tmp = this.getResourceObjects(Class.forName(className), qp);
            if (tmp != null) {
                ret = new Vector();
                for (int i = 0; i < tmp.length; ++i) {
                    ret.add(tmp[i]);
                }
            } else {
                ret = new Vector();
            }
        }
        catch (ClassNotFoundException nfex) {
            this.mLogger.severe("Class not found: " + className);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to get resource for" + className + ": " + risex.getMessage());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllResourceObjects(String className) {
        Vector<ResourceObject> ret = null;
        if (this.mUseCache) {
            Hashtable hashtable = this.mCacheById;
            synchronized (hashtable) {
                Hashtable classCache = (Hashtable)this.mCacheByClassOwnerId.get(className);
                if (classCache != null) {
                    Vector objects = new Vector();
                    for (Hashtable ownerResources : classCache.values()) {
                        objects.addAll(ownerResources.values());
                    }
                    ret = objects;
                } else {
                    ret = new Vector<ResourceObject>();
                    this.mLogger.severe("Trying to get portal objects for unregistered class " + className);
                }
            }
        }
        this.mLogger.info("Getting className  for all owners");
        try {
            ResourceObject[] tmp = this.getResourceObjects(Class.forName(className), (QueryPredicate)null);
            if (tmp != null) {
                ret = new Vector();
                for (int i = 0; i < tmp.length; ++i) {
                    ret.add(tmp[i]);
                }
            } else {
                ret = new Vector();
            }
        }
        catch (ClassNotFoundException nfex) {
            this.mLogger.severe("Class not found: " + className);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to get resource for" + className + ": " + risex.getMessage());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(ResourceObject obj) throws RISException {
        String id;
        String ret = null;
        ResourceObject cachedObj = null;
        if (this.mUseCache && (id = obj.getId()) != null) {
            Hashtable hashtable = this.mCacheById;
            synchronized (hashtable) {
                cachedObj = (ResourceObject)this.mCacheById.get(obj.getId());
            }
        }
        ret = cachedObj != null && cachedObj != obj ? super.replace(cachedObj, obj) : super.save(obj);
        if (this.mUseCache) {
            Hashtable hashtable = this.mCacheById;
            synchronized (hashtable) {
                String id2 = obj.getId();
                String owner = obj.getOwnerId();
                if (owner == null) {
                    owner = "";
                }
                String className = obj.getClass().getName();
                this.mLogger.info("Trying to ADD RESOURCE: " + className + ":" + id2 + ":" + owner);
                this.mCacheById.put(id2, obj);
                Hashtable classResources = (Hashtable)this.mCacheByClassOwnerId.get(className);
                if (classResources != null) {
                    Hashtable<String, ResourceObject> ownerResources = (Hashtable<String, ResourceObject>)classResources.get(owner);
                    if (ownerResources == null) {
                        ownerResources = new Hashtable<String, ResourceObject>();
                        classResources.put(owner, ownerResources);
                    }
                    ownerResources.put(id2, obj);
                } else {
                    this.mLogger.severe("Trying to save object for unregistered class " + className);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeResourceObjectsByOwner(String owner, String className) throws IOException {
        int ret = 0;
        String failedResources = "";
        if (this.mUseCache) {
            Hashtable hashtable = this.mCacheById;
            synchronized (hashtable) {
                Hashtable classResources = (Hashtable)this.mCacheByClassOwnerId.get(className);
                if (classResources != null) {
                    Hashtable ownerResources = (Hashtable)classResources.get(owner);
                    if (ownerResources != null) {
                        Enumeration it = ownerResources.elements();
                        while (it.hasMoreElements()) {
                            ResourceObject tmp = (ResourceObject)it.nextElement();
                            String id = tmp.getId();
                            try {
                                this.mCacheById.remove(id);
                                super.remove(tmp);
                                ++ret;
                            }
                            catch (Exception e) {
                                this.mLogger.severe("Could not remove " + id);
                                this.mLogger.severe(e.toString() + "\n" + LoggerUtils.getStackTrace(e));
                                failedResources = failedResources + id + "\n";
                            }
                        }
                        ownerResources.clear();
                    } else {
                        this.mLogger.info("Owner " + owner + " has no " + className + " in cache ");
                    }
                } else {
                    this.mLogger.severe("Trying to get portal objects for unregistered class " + className);
                }
            }
        }
        try {
            QueryPredicate qp = new QueryPredicate(new NSProperty("http://purl.oclc.org/NET/cmcs/internal/schema/:ownerid"), owner, "==", true);
            ResourceObject[] tmp = this.getResourceObjects(Class.forName(className), qp);
            for (int i = 0; i < tmp.length; ++i) {
                String id = tmp[i].getId();
                try {
                    this.mCacheById.remove(id);
                    super.remove(tmp[i]);
                    ++ret;
                    continue;
                }
                catch (Exception e) {
                    this.mLogger.severe("Could not remove " + id);
                    this.mLogger.severe(e.toString() + "\n" + LoggerUtils.getStackTrace(e));
                    failedResources = failedResources + id + "\n";
                }
            }
        }
        catch (ClassNotFoundException nfex) {
            this.mLogger.severe("Class not found: " + className);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to get resources for" + className + ": " + risex.getMessage());
        }
        if (!failedResources.equals("")) {
            throw new IOException("An error occured while trying to remove the following resources from the SAM server:\n" + failedResources);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(ResourceObject obj) throws RISException {
        String id = obj.getId();
        String owner = obj.getOwnerId();
        String className = obj.getClass().getName();
        if (id == null || owner == null || className == null) {
            this.mLogger.severe("Can't delete " + className + ":" + id + ":" + owner + " - Incomplete ResourceObject!");
            throw new RISException("Can't delete " + className + ":" + id + ":" + owner + " - Incomplete ResourceObject!");
        }
        String ret = super.remove(obj);
        if (this.mUseCache) {
            Hashtable hashtable = this.mCacheById;
            synchronized (hashtable) {
                this.mLogger.info("Trying to REMOVE RESOURCE: " + className + ":" + id + ":" + owner);
                this.mCacheById.remove(id);
                Hashtable classResources = (Hashtable)this.mCacheByClassOwnerId.get(className);
                if (classResources != null) {
                    Hashtable ownerResources = (Hashtable)classResources.get(owner);
                    if (ownerResources != null) {
                        ownerResources.remove(id);
                    } else {
                        this.mLogger.severe("Trying to remove object for unregistered owner " + owner);
                    }
                } else {
                    this.mLogger.severe("Trying to remove object for unregistered class " + className);
                }
            }
        }
        return ret;
    }

    public static String getContentFromElement(Element el) throws IOException {
        String ret = "";
        StringWriter sw = new StringWriter();
        XMLSerializer serializer = new XMLSerializer(sw, new OutputFormat("XML", "UTF-8", true));
        serializer.serialize(el);
        return sw.toString();
    }

    public static void main(String[] args) {
        Logger logger = LoggerUtils.getLogger();
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String pop = props.getProperty("portalobjects");
        logger.info("Starting service");
        JMSRISService ris = new JMSRISService(svr + pop, new Vector());
        try {
            ris.establishJMSConnection();
        }
        catch (JMSException ex) {
            logger.info("Error establishing connection " + ex.getMessage());
        }
    }
}

