/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Hashtable;
import org.apache.jetspeed.modules.actions.JetspeedAccessController;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.actions.ActionTeamlet;
import org.chefproject.core.User;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.util.MyPortalsTool;

public class ChefJetspeedAccessController
extends JetspeedAccessController {
    private static Hashtable M_redirects = new Hashtable();

    public void doPerform(RunData data) throws Exception {
        String userId;
        super.doPerform(data);
        Profile profile = ((JetspeedRunData)data).getProfile();
        String redirectUrl = (String)M_redirects.get(data.getSession().getId());
        User user = UsageSessionService.getSessionUser();
        boolean loggedIn = !user.equals(UserDirectoryService.getAnonymousUser());
        boolean containerAuthentication = "true".equals(JetspeedResources.getString((String)"container.auth"));
        if (!loggedIn && containerAuthentication && (userId = data.getRequest().getRemoteUser()) != null) {
            Log.info("chef", (Object)((Object)this) + ": Logging in from remoteUser: " + userId);
            JetspeedUser juser = null;
            try {
                juser = JetspeedSecurity.login((String)userId, null);
                user = UsageSessionService.getSessionUser();
                boolean bl = loggedIn = !user.equals(UserDirectoryService.getAnonymousUser());
                if (loggedIn) {
                    String link = ServerConfigurationService.getPortalUrl();
                    data.setRedirectURI(link);
                }
            }
            catch (LoginException e) {
                Log.warn("chef", (Object)((Object)this) + ": login exception with remoteUser: " + (Object)((Object)e));
            }
        }
        if (!loggedIn) {
            boolean floating = MyPortalsTool.getFloating((JetspeedRunData)data);
            if (floating) {
                data.getTemplateInfo().setScreenTemplate("close");
                data.setAction(null);
            } else if (profile != null && !profile.getAnonymous()) {
                if (redirectUrl == null) {
                    M_redirects.put(data.getSession().getId(), ActionTeamlet.computeRedirectUrl((JetspeedRunData)data));
                }
                data.getTemplateInfo().setScreenTemplate("TopRedirectLogin");
                data.setAction(null);
            }
        } else if (redirectUrl != null) {
            M_redirects.remove(data.getSession().getId());
            data.setRedirectURI(redirectUrl);
            if (Log.getLogger("chef").isInfoEnabled()) {
                Log.info("chef", (Object)((Object)this) + " redirect to url: " + redirectUrl + " from profile: " + (profile == null ? "null" : profile.getId()));
            }
        }
    }
}

