# io.js TC Meeting 2015-04-22

## Links

* **Public YouTube feed**: http://www.youtube.com/watch?v=s7LIMsTFaps
* **Google Plus Event page**: https://plus.google.com/events/co7i7pv2a51270jat7jvkfcue64
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/1502
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1G4aJ2OwiW2WphW7Vz2OW56VRot8xRBFitluKsuYPxk0

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

* [#1130](https://github.com/nodejs/io.js/issues/1130) Nominating Jeremiah Senkpiel @Fishrock123 to the TC
* [#1481](https://github.com/nodejs/io.js/issues/1481) Nominating @mikeal to the TC
* [#1500](https://github.com/nodejs/io.js/issues/1500) Nominating Brian White @mscdex to the TC
* [#1501](https://github.com/nodejs/io.js/issues/1501) Nominating Shigeki Ohtsu @shigeki to the TC
* [#1393](https://github.com/nodejs/io.js/issues/1393) Ready to upgrade to V8 4.2?
* [#1413](https://github.com/nodejs/io.js/issues/1413) Combined node.js/io.js TC/Core Call
* [#1416](https://github.com/nodejs/io.js/issues/1416) Diffing io.js and the Node.js Foundation

### Present

* Ben (TC)
* Bert (TC)
* Brian
* Chris (TC)
* Domenic
* Fedor (TC)
* Jeremiah
* Shigeki
* Trevor (TC)
* Rod (TC)

### Review of last meeting

* [#1393](https://github.com/nodejs/io.js/issues/1393) Ready to upgrade to V8 4.2?
* [#1413](https://github.com/nodejs/io.js/issues/1413) combining TC and Node core call
* [#1416](https://github.com/nodejs/io.js/issues/1416) io.js diff node.js foundation

### Quick stand-up

* Ben: Not much, company stuff
* Bert: Playing with clang and FFI, FluentConf
* Brian: JS HTTP parser, optimising and messing with regex
* Chris: URL changes, looking for breakage, checked on newSession/resumeSession, 1.8.x release
* Domenic: Not much, some work on V8 extensions with possible news next weeks
* Fedor: Looking at the “debugger is slow” in WebStorm issue, possible fix to V8 soon, working on using the OpenSSL 1.0.2 hello parser, HTTP parser patch review
* Jeremiah: Not so much work on io.js, helped get 1.8.1 out and looking into moving npm out of our git repo.
* Rod: CI cluster dramas around 1.8.x release, new Raspberry Pis
* Shigeki: OpenSSL upgrade, ALPM enabling PR coming this week
* Trevor: Has been testing re-implementing Buffers using ES6 and TypedArrays. Some trickiness but seems doable and with patches that avoid zero-filling, performant.

## Minutes

### [#1130](https://github.com/nodejs/io.js/issues/1130) Nominating Jeremiah Senkpiel @Fishrock123 to the TC

Voted:

* Ben: +1
* Bert: +1
* Chris: +1
* Fedor: +1
* Rod: +1
* Trevor: +1

**Action: Jeremiah Senkpiel is now a member of the io.js Technical Committee!**

### [#1481](https://github.com/nodejs/io.js/issues/1481) Nominating @mikeal to the TC

* Bert, Rod: Discussion regarding the potential consequences of expanding the TC and how that might work if a merger with node happens.

Discussed consequences of expansion for merger and for the practicalities of meeting.

### [#1500](https://github.com/nodejs/io.js/issues/1500) Nominating Brian White @mscdex to the TC

_See above_

### [#1501](https://github.com/nodejs/io.js/issues/1501) Nominating Shigeki Ohtsu @shigeki to the TC

_See above_

### [#1393](https://github.com/nodejs/io.js/issues/1393) Ready to upgrade to V8 4.2?

Rod: no formal “RC” builds yet but master is now going out on nightlies, they have a 2.0.0-pre version string now. Discussed whether we want formal RC builds or not. No strong opinions.

Chris: `master` should be active for dev now, `next` should be used for ongoing V8 upgrade builds. Asked if the V8 changes were ready in `next` to merge - Ben confirmed - Chris to merge.

Trevor: would like to get started on the upcoming V8 Buffer-related breakage and whether we should go to a 2.x branch and work on `master`.

Chris: we should work on new stuff on `next` instead and leave `master` intact for now.

Rod: status of URL parser changes?

Chris: would like to test against candidate modules in npm that may cause breakage but otherwise seems good to merge.

Domenic: would like there to be getters and setters for all data properties for completeness and future-proofing - still to be done

Rod: any other breaking changes worth discussing?

Ben: process.send() ready but not merged, any objections? - no objections.

Chris: https://github.com/nodejs/io.js/milestones/2.0.0 new label “land-on-master” to indicate PRs that are still targeting the v1.x branch.

Ben & Bert discussed Ben’s possible timers rewrite - Ben implemented a heap and red-black tree in JS, turned out to be a bit faster but not complete yet and Ben has been distracted on other projects. **

### [#1413](https://github.com/nodejs/io.js/issues/1413) Combined node.js/io.js TC/Core Call

Bert: probably not this week, intent is for next week.

Jeremiah: there had been discussion around forming a convergence WG to handle some of this so as to not require everyone’s time except when necessary.

### [#1416](https://github.com/nodejs/io.js/issues/1416) Diffing io.js and the Node.js Foundation

_Nothing new to discuss_

## Open QA on Freenode/#io.js

Discussion on merger and how the possibility of merging may hold up progress in io.js. Generally agreed that we shouldn’t stop doing what we are doing, nor slow down progress. Bert would like us to be conscious of activities in the Foundation and how they may impact on what we are doing.

Discussion about “production ready” - recommendation is to use latest, we follow semver so that should be enough information. Rod suggested not jumping straight on to 2.0 when it lands, just because of potential edge-cases around internal changes like the url parser.

Discussed module integration testing to test certain modules that we would test with each release - Chris working on some tooling around being able to inspect what modules are impacted by changes - no specific work on actually running tests on modules but this could be a TODO for Build WG (Rod to make an issue for this).

## Next meeting

* 2015-04-29, UTC 20:00
