// TemplateExtensionNodeLoader.cs
//
// Author:
//   Mike Krüger <mkrueger@novell.com>
//
// Copyright (c) 2008 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

using System;
using Mono.TextEditor.Highlighting;
using Mono.Addins;

namespace MonoDevelop.SourceEditor.Extension
{
	public static class TemplateExtensionNodeLoader
	{
		static bool initialized = false;
		
		public static void Init ()
		{
			if (initialized)
				return;
			initialized = true;
			AddinManager.AddExtensionNodeHandler ("/MonoDevelop/SourceEditor2/SyntaxModes", OnSyntaxModeExtensionChanged);
			AddinManager.AddExtensionNodeHandler ("/MonoDevelop/SourceEditor2/Styles", OnStylesExtensionChanged);
		}

		static void OnSyntaxModeExtensionChanged (object s, ExtensionNodeEventArgs args)
		{
			TemplateCodon codon = (TemplateCodon)args.ExtensionNode;
			if (args.Change == ExtensionChange.Add) {
				Mono.TextEditor.Highlighting.SyntaxModeService.AddSyntaxMode (codon);
			} else {
				Mono.TextEditor.Highlighting.SyntaxModeService.RemoveSyntaxMode (codon);
			}
		}
		
		static void OnStylesExtensionChanged (object s, ExtensionNodeEventArgs args)
		{
			TemplateCodon codon = (TemplateCodon)args.ExtensionNode;
			if (args.Change == ExtensionChange.Add) {
				Mono.TextEditor.Highlighting.SyntaxModeService.AddStyle (codon);
			} else {
				Mono.TextEditor.Highlighting.SyntaxModeService.RemoveStyle (codon);
			}
		}
		
	}
}
