/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sharpen.core.csharp.ast.CSBlock;
import sharpen.core.csharp.ast.CSMember;
import sharpen.core.csharp.ast.CSParameterized;
import sharpen.core.csharp.ast.CSTypeReferenceExpression;
import sharpen.core.csharp.ast.CSVariableDeclaration;

public abstract class CSMethodBase
extends CSMember
implements CSParameterized {
    private List<CSVariableDeclaration> _parameters = new ArrayList<CSVariableDeclaration>();
    private CSBlock _body = new CSBlock();
    private boolean _isVarArgs;

    public CSMethodBase(String name) {
        super(name);
    }

    @Override
    public void addParameter(CSVariableDeclaration parameter) {
        this._parameters.add(parameter);
    }

    public void addParameter(int index, CSVariableDeclaration parameter) {
        this._parameters.add(index, parameter);
    }

    public void addParameter(String name, CSTypeReferenceExpression type) {
        this.addParameter(new CSVariableDeclaration(name, type));
    }

    public void removeParameter(int index) {
        this._parameters.remove(index);
    }

    public List<CSVariableDeclaration> parameters() {
        return Collections.unmodifiableList(this._parameters);
    }

    public CSBlock body() {
        return this._body;
    }

    @Override
    public String signature() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name());
        buffer.append("(");
        boolean first = true;
        for (CSVariableDeclaration p : this._parameters) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(p.type());
            first = false;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public void isVarArgs(boolean value) {
        this._isVarArgs = value;
    }

    public boolean isVarArgs() {
        return this._isVarArgs;
    }
}

