/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef Editor_H
#include "Editor.h"
#endif

#ifndef ReplyObserver_H
#include "ReplyObserver.h"
#endif

#ifndef QtScmEditor_H
#include "QtScmEditor.h"
#endif


QtScmEditor::QtScmEditor(const IconClass& name,const string& kind):
    Editor(name,kind)
{
}

QtScmEditor::~QtScmEditor()
{
}



// -----------------------------------------------------------------
// QtScmEditor::edit
// Called to start editing a macro. We call the macroedit service to
// bring up the Qt macro editor.

void QtScmEditor::edit(void)
{
    string path = current_->path().str();

    replyObserver_ = new ScmEditorObserver(*this, path);
    replyObserver_->start();


//    replyObserver_->callService("macroedit", r);


//    task_->start();


}




//=================================================================

ScmEditorObserver::ScmEditorObserver(QtScmEditor &editor, string &path) :
    editor_(editor), path_(path)
{
}

ScmEditorObserver::~ScmEditorObserver()
{
}


void ScmEditorObserver::start()
{
    // Editor::edit will already have set up the path that we need
    	MvRequest r("SCM_INPUT_DATA");

	r("PATH")=path_.c_str();
    	r("_NAME")=path_.c_str();
    	r("_CLASS")="SCM_INPUT_DATA";
    	r("_ACTION")="edit";
    	r("_SERVICE")="ScmDataEditor";
	r.print();

	callService("ScmDataEditor", r);
}


void ScmEditorObserver::reply(const Request& r,int err)
{

    editor_.notifyObserverApply();
    editor_.Editor::done();

}

void ScmEditorObserver::progress(const Request& r)
{
}

void ScmEditorObserver::message(const string& msg)
{
}


void ScmEditorObserver::print(ostream& s) const
{
}





static EditorMaker<QtScmEditor> editorMaker("QtScmDataEditor");

