use strict;
use warnings;
use Test::More;
use Test::Needs ();

my @try = (
  [ '5'           => '5.000000' ],
  [ 'v5'          => '5.000000' ],
  [ '"5"'         => '5.000000' ],
  [ '"v5"'        => '5.000000' ],

  [ '5.008000'    => '5.008000' ],
  [ '5.8.0'       => '5.008000' ],
  [ 'v5.8.0'      => '5.008000' ],
  [ '"5.8.0"'     => '5.008000' ],
  [ '"v5.8.0"'    => '5.008000' ],

  [ '5.010'       => '5.010000' ],
  [ 'v5.10'       => '5.010000' ],
  [ '"v5.10"'     => '5.010000' ],

  [ '5.999000'    => '5.999000' ],
  [ '5.999.0'     => '5.999000' ],
  [ 'v5.999.0'    => '5.999000' ],
  [ '"5.999.0"'   => '5.999000' ],
  [ '"v5.999.0"'  => '5.999000' ],

  [ '6'           => '6.000000' ],
  [ 'v6'          => '6.000000' ],
  [ '"6"'         => '6.000000' ],
  [ '"v6"'        => '6.000000' ],

  [ '6.999000'    => '6.999000' ],
  [ '6.999.0'     => '6.999000' ],
  [ 'v6.999.0'    => '6.999000' ],
  [ '"6.999.0"'   => '6.999000' ],
  [ '"v6.999.0"'  => '6.999000' ],

  [ '7'           => '7.000000' ],
  [ 'v7'          => '7.000000' ],
  [ '"7"'         => '7.000000' ],
  [ '"v7"'        => '7.000000' ],

  [ '7.999000'    => '7.999000' ],
  [ '7.999.0'     => '7.999000' ],
  [ 'v7.999.0'    => '7.999000' ],
  [ '"7.999.0"'   => '7.999000' ],
  [ '"v7.999.0"'  => '7.999000' ],
);

plan tests => 1 + scalar @try;

my @warnings;
local $SIG{__WARN__} = sub { push @warnings, @_; warn @_ };

for (@try) {
  my ($in, $want) = @$_;
  SKIP: {
    my $evaled = eval $in;
    skip "$in is unsupported syntax on perl $]", 1
      if $@;
    my $got = Test::Needs::_numify_version($evaled);
    is $got, $want, sprintf "%10s parses correctly as %s", $in, $want;
  }
}

is scalar @warnings, 0, "no warnings";
