/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.PrintWriter;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeAssemblerPrinter;
import org.cojen.classfile.CodeDisassembler;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.DisassemblyTool;
import org.cojen.classfile.FieldInfo;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.constant.ConstantDoubleInfo;
import org.cojen.classfile.constant.ConstantFloatInfo;
import org.cojen.classfile.constant.ConstantIntegerInfo;
import org.cojen.classfile.constant.ConstantLongInfo;
import org.cojen.classfile.constant.ConstantStringInfo;

class BuilderStylePrinter
implements DisassemblyTool.Printer {
    private PrintWriter mOut;
    private int mIndent = 0;
    private boolean mNeedIndent = true;

    public void disassemble(ClassFile cf, PrintWriter out) {
        this.mOut = out;
        this.println("import java.io.BufferedOutputStream;");
        this.println("import java.io.File;");
        this.println("import java.io.FileOutputStream;");
        this.println("import java.io.OutputStream;");
        this.println();
        this.println("import org.cojen.classfile.ClassFile;");
        this.println("import org.cojen.classfile.CodeBuilder;");
        this.println("import org.cojen.classfile.FieldInfo;");
        this.println("import org.cojen.classfile.Label;");
        this.println("import org.cojen.classfile.LocalVariable;");
        this.println("import org.cojen.classfile.Location;");
        this.println("import org.cojen.classfile.MethodInfo;");
        this.println("import org.cojen.classfile.Modifiers;");
        this.println("import org.cojen.classfile.Opcode;");
        this.println("import org.cojen.classfile.TypeDesc;");
        this.disassemble(cf, (String)null);
    }

    private void disassemble(ClassFile cf, String innerClassSuffix) {
        int i;
        int i2;
        this.println();
        if (innerClassSuffix == null) {
            this.println("/**");
            this.println(" * Builds ClassFile for " + cf.getClassName());
            this.println(" *");
            this.println(" * @author auto-generated");
            this.println(" */");
            this.println("public class ClassFileBuilder {");
        } else {
            this.println("/**");
            this.println(" * Builds ClassFile for " + cf.getClassName());
            this.println(" */");
            this.println("private static class InnerBuilder" + innerClassSuffix + " {");
        }
        this.mIndent += 4;
        if (innerClassSuffix == null) {
            this.println("public static void main(String[] args) throws Exception {");
            this.mIndent += 4;
            this.println("// " + cf);
            this.println("ClassFile cf = createClassFile();");
            this.println();
            this.println("if (args.length > 0) {");
            this.mIndent += 4;
            this.println("File file = new File(args[0]);");
            this.println("if (file.isDirectory()) {");
            this.mIndent += 4;
            this.println("writeClassFiles(cf, file);");
            this.mIndent -= 4;
            this.println("} else {");
            this.mIndent += 4;
            this.println("OutputStream out = new BufferedOutputStream(new FileOutputStream(file));");
            this.println("cf.writeTo(out);");
            this.println("out.close();");
            this.mIndent -= 4;
            this.println("}");
            this.mIndent -= 4;
            this.println("}");
            this.mIndent -= 4;
            this.println("}");
            this.println();
            this.println("private static void writeClassFiles(ClassFile cf, File dir) throws Exception {");
            this.mIndent += 4;
            this.println("File file = new File(dir, cf.getClassName().replace('.', '/') + \".class\");");
            this.println("file.getParentFile().mkdirs();");
            this.println("OutputStream out = new BufferedOutputStream(new FileOutputStream(file));");
            this.println("cf.writeTo(out);");
            this.println("out.close();");
            this.println();
            this.println("ClassFile[] innerClasses = cf.getInnerClasses();");
            this.println("for (int i=0; i<innerClasses.length; i++) {");
            this.mIndent += 4;
            this.println("writeClassFiles(innerClasses[i], dir);");
            this.mIndent -= 4;
            this.println("}");
            this.mIndent -= 4;
            this.println("}");
            this.println();
        }
        if (innerClassSuffix == null) {
            this.println("public static ClassFile createClassFile() {");
            this.mIndent += 4;
            this.println("ClassFile cf = new ClassFile(\"" + this.escape(cf.getClassName()) + "\", \"" + this.escape(cf.getSuperClassName()) + "\");");
        } else {
            this.println("static ClassFile createClassFile(ClassFile cf) {");
            this.mIndent += 4;
        }
        if (cf.getTarget() != null) {
            this.println("cf.setTarget(\"" + this.escape(cf.getTarget()) + "\");");
        }
        this.println("cf.setSourceFile(\"" + this.escape(cf.getSourceFile()) + "\");");
        if (cf.isSynthetic()) {
            this.println("cf.markSynthetic();");
        }
        if (cf.isDeprecated()) {
            this.println("cf.markDeprecated();");
        }
        if (!cf.getModifiers().equals(Modifiers.PUBLIC)) {
            this.print("cf.setModifiers(");
            this.printModifiers(cf);
            this.println(");");
        }
        String[] interfaces = cf.getInterfaces();
        for (int i3 = 0; i3 < interfaces.length; ++i3) {
            this.println("cf.addInterface(\"" + this.escape(interfaces[i3]) + "\");");
        }
        if (cf.getInitializer() != null) {
            this.println();
            this.println("createStaticInitializer(cf);");
        }
        FieldInfo[] fields = cf.getFields();
        boolean createdFieldVariable = false;
        for (int i4 = 0; i4 < fields.length; ++i4) {
            if (i4 == 0) {
                this.println();
                this.println("//");
                this.println("// Create fields");
                this.println("//");
            }
            this.println();
            FieldInfo fi = fields[i4];
            if (fi.isSynthetic() || fi.isDeprecated() || fi.getConstantValue() != null) {
                if (!createdFieldVariable) {
                    this.print("FieldInfo ");
                    createdFieldVariable = true;
                }
                this.print("fi = ");
            }
            this.print("cf.addField(");
            this.printModifiers(fi);
            this.print(", ");
            this.print('\"' + this.escape(fi.getName()) + "\", ");
            this.print(fi.getType());
            this.println(");");
            if (fi.getConstantValue() != null) {
                ConstantInfo constant = fi.getConstantValue();
                this.print("fi.setConstantValue(");
                if (constant instanceof ConstantStringInfo) {
                    this.print("\"");
                    String value = ((ConstantStringInfo)constant).getValue();
                    this.print(this.escape(value));
                    this.print("\"");
                } else if (constant instanceof ConstantIntegerInfo) {
                    this.print(String.valueOf(((ConstantIntegerInfo)constant).getValue()));
                } else if (constant instanceof ConstantLongInfo) {
                    this.print(String.valueOf(((ConstantLongInfo)constant).getValue()));
                    this.print("L");
                } else if (constant instanceof ConstantFloatInfo) {
                    float value = ((ConstantFloatInfo)constant).getValue();
                    if (value != value) {
                        this.print("0.0f/0.0f");
                    } else if (value == Float.NEGATIVE_INFINITY) {
                        this.print("-1.0f/0.0f");
                    } else if (value == Float.POSITIVE_INFINITY) {
                        this.print("1.0f/0.0f");
                    } else {
                        this.print(String.valueOf(value));
                        this.print("f");
                    }
                } else if (constant instanceof ConstantDoubleInfo) {
                    double value = ((ConstantDoubleInfo)constant).getValue();
                    if (value != value) {
                        this.print("0.0d/0.0d");
                    } else if (value == Double.NEGATIVE_INFINITY) {
                        this.print("-1.0d/0.0d");
                    } else if (value == Double.POSITIVE_INFINITY) {
                        this.print("1.0d/0.0d");
                    } else {
                        this.print(String.valueOf(value));
                        this.print("d");
                    }
                }
                this.println(");");
            }
            if (fi.isSynthetic()) {
                this.println("fi.markSynthetic();");
            }
            if (!fi.isDeprecated()) continue;
            this.println("fi.markDeprecated();");
        }
        MethodInfo[] methods = cf.getConstructors();
        for (i2 = 0; i2 < methods.length; ++i2) {
            if (i2 == 0) {
                this.println();
                this.println("//");
                this.println("// Create constructors");
                this.println("//");
            }
            this.println();
            this.println("// " + methods[i2]);
            this.println("createConstructor_" + (i2 + 1) + "(cf);");
        }
        methods = cf.getMethods();
        for (i2 = 0; i2 < methods.length; ++i2) {
            if (i2 == 0) {
                this.println();
                this.println("//");
                this.println("// Create methods");
                this.println("//");
            }
            this.println();
            this.println("// " + methods[i2]);
            this.println("createMethod_" + (i2 + 1) + "(cf);");
        }
        ClassFile[] innerClasses = cf.getInnerClasses();
        for (i = 0; i < innerClasses.length; ++i) {
            if (i == 0) {
                this.println();
                this.println("//");
                this.println("// Create inner classes");
                this.println("//");
            }
            this.println();
            this.println("// " + innerClasses[i]);
            if (i == 0) {
                this.print("ClassFile ");
            }
            this.print("innerClass = ");
            String name = innerClasses[i].getClassName();
            String innerName = innerClasses[i].getInnerClassName();
            if (innerName != null) {
                if ((cf.getClassName() + '$' + innerName).equals(name)) {
                    name = null;
                }
                innerName = '\"' + this.escape(innerName) + '\"';
            }
            if (name != null) {
                name = '\"' + this.escape(name) + '\"';
            }
            this.println("cf.addInnerClass(" + name + ", " + innerName + ", \"" + this.escape(innerClasses[i].getSuperClassName()) + "\");");
            String suffix = "_" + (i + 1);
            if (innerClassSuffix != null) {
                suffix = innerClassSuffix + suffix;
            }
            this.println("InnerBuilder" + suffix + ".createClassFile(innerClass);");
        }
        this.println();
        this.println("return cf;");
        this.mIndent -= 4;
        this.println("}");
        if (cf.getInitializer() != null) {
            this.println();
            this.println("private static void createStaticInitializer(ClassFile cf) {");
            this.mIndent += 4;
            this.disassemble(cf.getInitializer());
            this.mIndent -= 4;
            this.println("}");
        }
        methods = cf.getConstructors();
        for (i = 0; i < methods.length; ++i) {
            this.println();
            this.println("// " + methods[i]);
            this.println("private static void createConstructor_" + (i + 1) + "(ClassFile cf) {");
            this.mIndent += 4;
            this.disassemble(methods[i]);
            this.mIndent -= 4;
            this.println("}");
        }
        methods = cf.getMethods();
        for (i = 0; i < methods.length; ++i) {
            this.println();
            this.println("// " + methods[i]);
            this.println("private static void createMethod_" + (i + 1) + "(ClassFile cf) {");
            this.mIndent += 4;
            this.disassemble(methods[i]);
            this.mIndent -= 4;
            this.println("}");
        }
        for (i = 0; i < innerClasses.length; ++i) {
            String suffix = "_" + (i + 1);
            if (innerClassSuffix != null) {
                suffix = innerClassSuffix + suffix;
            }
            this.disassemble(innerClasses[i], suffix);
        }
        this.mIndent -= 4;
        this.println("}");
    }

    private void disassemble(MethodInfo mi) {
        this.print("MethodInfo mi = cf.add");
        if (mi.getName().equals("<clinit>")) {
            this.println("Initializer();");
        } else if (mi.getName().equals("<init>")) {
            this.print("Constructor(");
            this.printModifiers(mi);
            this.print(", ");
            this.print(mi.getMethodDescriptor().getParameterTypes());
            this.println(");");
        } else {
            this.print("Method(");
            this.printModifiers(mi);
            this.print(", ");
            this.print("\"" + this.escape(mi.getName()) + "\", ");
            this.print(mi.getMethodDescriptor().getReturnType());
            this.print(", ");
            this.print(mi.getMethodDescriptor().getParameterTypes());
            this.println(");");
        }
        if (mi.isSynthetic()) {
            this.println("mi.markSynthetic();");
        }
        if (mi.isDeprecated()) {
            this.println("mi.markDeprecated();");
        }
        TypeDesc[] exceptions = mi.getExceptions();
        for (int j = 0; j < exceptions.length; ++j) {
            this.print("mi.addException(");
            this.print(exceptions[j]);
            this.println(");");
        }
        if (mi.getCodeAttr() != null) {
            this.println("CodeBuilder b = new CodeBuilder(mi);");
            this.println();
            TypeDesc[] paramTypes = mi.getMethodDescriptor().getParameterTypes();
            boolean isStatic = mi.getModifiers().isStatic();
            String indentStr = this.generateIndent(this.mIndent);
            new CodeDisassembler(mi).disassemble(new CodeAssemblerPrinter(paramTypes, isStatic, this.mOut, indentStr, ";", "b."));
        }
    }

    private String escape(String str) {
        return CodeAssemblerPrinter.escape(str);
    }

    private void printModifiers(ClassFile cf) {
        this.printModifiers(cf.getModifiers());
    }

    private void printModifiers(FieldInfo fi) {
        this.printModifiers(fi.getModifiers());
    }

    private void printModifiers(MethodInfo mi) {
        this.printModifiers(mi.getModifiers());
    }

    private void printModifiers(Modifiers modifiers) {
        this.print("Modifiers.");
        if (modifiers.isPublic()) {
            if (modifiers.isAbstract()) {
                this.print("PUBLIC_ABSTRACT");
                modifiers = modifiers.toAbstract(false);
            } else if (modifiers.isStatic()) {
                this.print("PUBLIC_STATIC");
                modifiers = modifiers.toStatic(false);
            } else {
                this.print("PUBLIC");
            }
            modifiers = modifiers.toPublic(false);
        } else if (modifiers.isProtected()) {
            this.print("PROTECTED");
            modifiers = modifiers.toProtected(false);
        } else if (modifiers.isPrivate()) {
            this.print("PRIVATE");
            modifiers = modifiers.toPrivate(false);
        } else {
            this.print("NONE");
        }
        if (modifiers.isStatic()) {
            this.print(".toStatic(true)");
        }
        if (modifiers.isFinal()) {
            this.print(".toFinal(true)");
        }
        if (modifiers.isSynchronized()) {
            this.print(".toSynchronized(true)");
        }
        if (modifiers.isVolatile()) {
            this.print(".toVolatile(true)");
        }
        if (modifiers.isTransient()) {
            this.print(".toTransient(true)");
        }
        if (modifiers.isNative()) {
            this.print(".toNative(true)");
        }
        if (modifiers.isInterface()) {
            this.print(".toInterface(true)");
        }
        if (modifiers.isAbstract() && !modifiers.isInterface()) {
            this.print(".toAbstract(true)");
        }
        if (modifiers.isStrict()) {
            this.print(".toStrict(true)");
        }
    }

    private void print(TypeDesc type) {
        if (type == null || type == TypeDesc.VOID) {
            this.print("null");
            return;
        }
        if (type.isPrimitive()) {
            this.print("TypeDesc.".concat(type.getFullName().toUpperCase()));
            return;
        }
        if (type == TypeDesc.OBJECT) {
            this.print("TypeDesc.OBJECT");
            return;
        }
        if (type == TypeDesc.STRING) {
            this.print("TypeDesc.STRING");
            return;
        }
        TypeDesc componentType = type.getComponentType();
        if (componentType != null) {
            this.print(componentType);
            this.print(".toArrayType()");
        } else {
            this.print("TypeDesc.forClass(\"");
            this.print(this.escape(type.getRootName()));
            this.print("\")");
        }
    }

    private void print(TypeDesc[] params) {
        if (params == null || params.length == 0) {
            this.print("null");
            return;
        }
        this.print("new TypeDesc[] {");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                this.print(", ");
            }
            this.print(params[i]);
        }
        this.print("}");
    }

    private void print(String text) {
        this.indent();
        this.mOut.print(text);
    }

    private void println(String text) {
        this.print(text);
        this.println();
    }

    private void println() {
        this.mOut.println();
        this.mNeedIndent = true;
    }

    private void indent() {
        if (this.mNeedIndent) {
            int i = this.mIndent;
            while (--i >= 0) {
                this.mOut.print(' ');
            }
            this.mNeedIndent = false;
        }
    }

    private String generateIndent(int amount) {
        StringBuffer buf = new StringBuffer(amount);
        for (int i = 0; i < amount; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }
}

