/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.providers.http.LightweightHttpWagon;
import org.apache.maven.wagon.proxy.ProxyInfo;

public class LightweightHttpsWagon
extends LightweightHttpWagon {
    private String previousHttpsProxyHost;
    private String previousHttpsProxyPort;

    public void openConnection() throws ConnectionException, AuthenticationException {
        this.previousHttpsProxyHost = System.getProperty("https.proxyHost");
        this.previousHttpsProxyPort = System.getProperty("https.proxyPort");
        ProxyInfo proxyInfo = this.getProxyInfo("https", this.getRepository().getHost());
        if (proxyInfo != null) {
            System.setProperty("https.proxyHost", proxyInfo.getHost());
            System.setProperty("https.proxyPort", String.valueOf(proxyInfo.getPort()));
        }
        super.openConnection();
    }

    public void closeConnection() throws ConnectionException {
        super.closeConnection();
        if (this.previousHttpsProxyHost != null) {
            System.setProperty("https.proxyHost", this.previousHttpsProxyHost);
        }
        if (this.previousHttpsProxyPort != null) {
            System.setProperty("https.proxyPort", this.previousHttpsProxyPort);
        }
    }
}

