; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S -data-layout="E" | FileCheck %s --check-prefixes=CHECK,BIGENDIAN
; RUN: opt < %s -passes=instsimplify -S -data-layout="e" | FileCheck %s --check-prefixes=CHECK,LITTLEENDIAN

; If any bits of the shift amount are known to make it exceed or equal
; the number of bits in the type, the shift causes undefined behavior.

define i32 @shl_amount_is_known_bogus(i32 %a, i32 %b) {
; CHECK-LABEL: @shl_amount_is_known_bogus(
; CHECK-NEXT:    ret i32 poison
;
  %or = or i32 %b, 32
  %shl = shl i32 %a, %or
  ret i32 %shl
}

define i32 @shl_amount_is_known_bogus_range_attr(i32 %a, i32 range(i32 32, 64) %b) {
; CHECK-LABEL: @shl_amount_is_known_bogus_range_attr(
; CHECK-NEXT:    ret i32 poison
;
  %shl = shl i32 %a, %b
  ret i32 %shl
}

define i32 @neg_shl_amount_is_known_bogus_range_attr(i32 %a, i32 range(i32 0, 32) %b) {
; CHECK-LABEL: @neg_shl_amount_is_known_bogus_range_attr(
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i32 [[SHL]]
;
  %shl = shl i32 %a, %b
  ret i32 %shl
}

declare range(i32 32, 64) i32 @returns_out_of_range_helper()
declare range(i32 0, 32) i32 @returns_in_range_helper()

define i32 @shl_amount_is_known_bogus_range_return(i32 %a) {
; CHECK-LABEL: @shl_amount_is_known_bogus_range_return(
; CHECK-NEXT:    [[B:%.*]] = call i32 @returns_out_of_range_helper()
; CHECK-NEXT:    ret i32 poison
;
  %b = call i32 @returns_out_of_range_helper()
  %shl = shl i32 %a, %b
  ret i32 %shl
}

define i32 @neg_shl_amount_is_known_bogus_range_return(i32 %a) {
; CHECK-LABEL: @neg_shl_amount_is_known_bogus_range_return(
; CHECK-NEXT:    [[B:%.*]] = call i32 @returns_in_range_helper()
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[A:%.*]], [[B]]
; CHECK-NEXT:    ret i32 [[SHL]]
;
  %b = call i32 @returns_in_range_helper()
  %shl = shl i32 %a, %b
  ret i32 %shl
}

declare i32 @returns_i32_helper()

define i32 @shl_amount_is_known_bogus_range_call(i32 %a) {
; CHECK-LABEL: @shl_amount_is_known_bogus_range_call(
; CHECK-NEXT:    [[B:%.*]] = call range(i32 32, 64) i32 @returns_i32_helper()
; CHECK-NEXT:    ret i32 poison
;
  %b = call range(i32 32, 64) i32 @returns_i32_helper()
  %shl = shl i32 %a, %b
  ret i32 %shl
}

define i32 @neg_shl_amount_is_known_bogus_range_call(i32 %a) {
; CHECK-LABEL: @neg_shl_amount_is_known_bogus_range_call(
; CHECK-NEXT:    [[B:%.*]] = call range(i32 0, 32) i32 @returns_i32_helper()
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[A:%.*]], [[B]]
; CHECK-NEXT:    ret i32 [[SHL]]
;
  %b = call range(i32 0, 32) i32 @returns_i32_helper()
  %shl = shl i32 %a, %b
  ret i32 %shl
}

define <2 x i32> @shl_amount_is_known_bogus_range_attr_vec(<2 x i32> %a, <2 x i32> range(i32 32, 64) %b) {
; CHECK-LABEL: @shl_amount_is_known_bogus_range_attr_vec(
; CHECK-NEXT:    ret <2 x i32> poison
;
  %shl = shl <2 x i32> %a, %b
  ret <2 x i32> %shl
}

define <2 x i32> @neg_shl_amount_is_known_bogus_range_attr_vec(<2 x i32> %a, <2 x i32> range(i32 0, 32) %b) {
; CHECK-LABEL: @neg_shl_amount_is_known_bogus_range_attr_vec(
; CHECK-NEXT:    [[SHL:%.*]] = shl <2 x i32> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret <2 x i32> [[SHL]]
;
  %shl = shl <2 x i32> %a, %b
  ret <2 x i32> %shl
}

declare range(i32 32, 64) <2 x i32> @returns_out_of_range_helper_vec()
declare range(i32 0, 32) <2 x i32> @returns_in_range_helper_vec()

define <2 x i32> @shl_amount_is_known_bogus_range_return_vec(<2 x i32> %a) {
; CHECK-LABEL: @shl_amount_is_known_bogus_range_return_vec(
; CHECK-NEXT:    [[B:%.*]] = call <2 x i32> @returns_out_of_range_helper_vec()
; CHECK-NEXT:    ret <2 x i32> poison
;
  %b = call <2 x i32> @returns_out_of_range_helper_vec()
  %shl = shl <2 x i32> %a, %b
  ret <2 x i32> %shl
}

define <2 x i32> @neg_shl_amount_is_known_bogus_range_return_vec(<2 x i32> %a) {
; CHECK-LABEL: @neg_shl_amount_is_known_bogus_range_return_vec(
; CHECK-NEXT:    [[B:%.*]] = call <2 x i32> @returns_in_range_helper_vec()
; CHECK-NEXT:    [[SHL:%.*]] = shl <2 x i32> [[A:%.*]], [[B]]
; CHECK-NEXT:    ret <2 x i32> [[SHL]]
;
  %b = call <2 x i32> @returns_in_range_helper_vec()
  %shl = shl <2 x i32> %a, %b
  ret <2 x i32> %shl
}

declare <2 x i32> @returns_i32_helper_vec()

define <2 x i32> @shl_amount_is_known_bogus_range_call_vec(<2 x i32> %a) {
; CHECK-LABEL: @shl_amount_is_known_bogus_range_call_vec(
; CHECK-NEXT:    [[B:%.*]] = call range(i32 32, 64) <2 x i32> @returns_i32_helper_vec()
; CHECK-NEXT:    ret <2 x i32> poison
;
  %b = call range(i32 32, 64) <2 x i32> @returns_i32_helper_vec()
  %shl = shl <2 x i32> %a, %b
  ret <2 x i32> %shl
}

define <2 x i32> @neg_shl_amount_is_known_bogus_range_call_vec(<2 x i32> %a) {
; CHECK-LABEL: @neg_shl_amount_is_known_bogus_range_call_vec(
; CHECK-NEXT:    [[B:%.*]] = call range(i32 0, 32) <2 x i32> @returns_i32_helper_vec()
; CHECK-NEXT:    [[SHL:%.*]] = shl <2 x i32> [[A:%.*]], [[B]]
; CHECK-NEXT:    ret <2 x i32> [[SHL]]
;
  %b = call range(i32 0, 32) <2 x i32> @returns_i32_helper_vec()
  %shl = shl <2 x i32> %a, %b
  ret <2 x i32> %shl
}

define i32 @shl_amount_is_not_known_bogus_range_call_and_range_metadata(i32 %a) {
; CHECK-LABEL: @shl_amount_is_not_known_bogus_range_call_and_range_metadata(
; CHECK-NEXT:    [[B:%.*]] = call range(i32 0, 32) i32 @returns_i32_helper(), !range [[RNG0:![0-9]+]]
; CHECK-NEXT:    [[SHL:%.*]] = shl i32 [[A:%.*]], [[B]]
; CHECK-NEXT:    ret i32 [[SHL]]
;
  %b = call range(i32 0, 32) i32 @returns_i32_helper(), !range !{ i32 32, i32 64 }
  %shl = shl i32 %a, %b
  ret i32 %shl
}

; Check some weird types and the other shift ops.

define i31 @lshr_amount_is_known_bogus(i31 %a, i31 %b) {
; CHECK-LABEL: @lshr_amount_is_known_bogus(
; CHECK-NEXT:    ret i31 poison
;
  %or = or i31 %b, 31
  %shr = lshr i31 %a, %or
  ret i31 %shr
}

define i33 @ashr_amount_is_known_bogus(i33 %a, i33 %b) {
; CHECK-LABEL: @ashr_amount_is_known_bogus(
; CHECK-NEXT:    ret i33 poison
;
  %or = or i33 %b, 33
  %shr = ashr i33 %a, %or
  ret i33 %shr
}


; If all valid bits of the shift amount are known 0, there's no shift.
; It doesn't matter if high bits are set because that would be undefined.
; Therefore, the only possible valid result of these shifts is %a.

define i16 @ashr_amount_is_zero(i16 %a, i16 %b) {
; CHECK-LABEL: @ashr_amount_is_zero(
; CHECK-NEXT:    ret i16 [[A:%.*]]
;
  %and = and i16 %b, 65520 ; 0xfff0
  %shr = ashr i16 %a, %and
  ret i16 %shr
}

define i300 @lshr_amount_is_zero(i300 %a, i300 %b) {
; CHECK-LABEL: @lshr_amount_is_zero(
; CHECK-NEXT:    ret i300 [[A:%.*]]
;
  %and = and i300 %b, 2048
  %shr = lshr i300 %a, %and
  ret i300 %shr
}

define i9 @shl_amount_is_zero(i9 %a, i9 %b) {
; CHECK-LABEL: @shl_amount_is_zero(
; CHECK-NEXT:    ret i9 [[A:%.*]]
;
  %and = and i9 %b, 496 ; 0x1f0
  %shl = shl i9 %a, %and
  ret i9 %shl
}


; Verify that we've calculated the log2 boundary of valid bits correctly for a weird type.

define i9 @shl_amount_is_not_known_zero(i9 %a, i9 %b) {
; CHECK-LABEL: @shl_amount_is_not_known_zero(
; CHECK-NEXT:    [[AND:%.*]] = and i9 [[B:%.*]], -8
; CHECK-NEXT:    [[SHL:%.*]] = shl i9 [[A:%.*]], [[AND]]
; CHECK-NEXT:    ret i9 [[SHL]]
;
  %and = and i9 %b, 504 ; 0x1f8
  %shl = shl i9 %a, %and
  ret i9 %shl
}


; For vectors, we need all scalar elements to meet the requirements to optimize.

define <2 x i32> @ashr_vector_bogus(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: @ashr_vector_bogus(
; CHECK-NEXT:    ret <2 x i32> poison
;
  %or = or <2 x i32> %b, <i32 32, i32 32>
  %shr = ashr <2 x i32> %a, %or
  ret <2 x i32> %shr
}

; FIXME: This is undef, but computeKnownBits doesn't handle the union.
define <2 x i32> @shl_vector_bogus(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: @shl_vector_bogus(
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i32> [[B:%.*]], <i32 32, i32 64>
; CHECK-NEXT:    [[SHL:%.*]] = shl <2 x i32> [[A:%.*]], [[OR]]
; CHECK-NEXT:    ret <2 x i32> [[SHL]]
;
  %or = or <2 x i32> %b, <i32 32, i32 64>
  %shl = shl <2 x i32> %a, %or
  ret <2 x i32> %shl
}

define <2 x i32> @lshr_vector_zero(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: @lshr_vector_zero(
; CHECK-NEXT:    ret <2 x i32> [[A:%.*]]
;
  %and = and <2 x i32> %b, <i32 64, i32 256>
  %shr = lshr <2 x i32> %a, %and
  ret <2 x i32> %shr
}

; Make sure that weird vector types work too.
define <2 x i15> @shl_vector_zero(<2 x i15> %a, <2 x i15> %b) {
; CHECK-LABEL: @shl_vector_zero(
; CHECK-NEXT:    ret <2 x i15> [[A:%.*]]
;
  %and = and <2 x i15> %b, <i15 1024, i15 1024>
  %shl = shl <2 x i15> %a, %and
  ret <2 x i15> %shl
}

define <2 x i32> @shl_vector_for_real(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: @shl_vector_for_real(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i32> [[B:%.*]], <i32 3, i32 3>
; CHECK-NEXT:    [[SHL:%.*]] = shl <2 x i32> [[A:%.*]], [[AND]]
; CHECK-NEXT:    ret <2 x i32> [[SHL]]
;
  %and = and <2 x i32> %b, <i32 3, i32 3> ; a necessary mask op
  %shl = shl <2 x i32> %a, %and
  ret <2 x i32> %shl
}


; We calculate the valid bits of the shift using log2, and log2 of 1 (the type width) is 0.
; That should be ok. Either the shift amount is 0 or invalid (1), so we can always return %a.

define i1 @shl_i1(i1 %a, i1 %b) {
; CHECK-LABEL: @shl_i1(
; CHECK-NEXT:    ret i1 [[A:%.*]]
;
  %shl = shl i1 %a, %b
  ret i1 %shl
}

; The following cases only get folded by InstCombine,
; see InstCombine/lshr.ll.

declare i32 @llvm.cttz.i32(i32, i1) nounwind readnone
declare i32 @llvm.ctlz.i32(i32, i1) nounwind readnone
declare <2 x i8> @llvm.cttz.v2i8(<2 x i8>, i1) nounwind readnone
declare <2 x i8> @llvm.ctlz.v2i8(<2 x i8>, i1) nounwind readnone

define i32 @lshr_ctlz_zero_is_undef(i32 %x) {
; CHECK-LABEL: @lshr_ctlz_zero_is_undef(
; CHECK-NEXT:    [[CT:%.*]] = call i32 @llvm.ctlz.i32(i32 [[X:%.*]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = lshr i32 [[CT]], 5
; CHECK-NEXT:    ret i32 [[SH]]
;
  %ct = call i32 @llvm.ctlz.i32(i32 %x, i1 true)
  %sh = lshr i32 %ct, 5
  ret i32 %sh
}

define i32 @lshr_cttz_zero_is_undef(i32 %x) {
; CHECK-LABEL: @lshr_cttz_zero_is_undef(
; CHECK-NEXT:    [[CT:%.*]] = call i32 @llvm.cttz.i32(i32 [[X:%.*]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = lshr i32 [[CT]], 5
; CHECK-NEXT:    ret i32 [[SH]]
;
  %ct = call i32 @llvm.cttz.i32(i32 %x, i1 true)
  %sh = lshr i32 %ct, 5
  ret i32 %sh
}

define <2 x i8> @lshr_ctlz_zero_is_undef_splat_vec(<2 x i8> %x) {
; CHECK-LABEL: @lshr_ctlz_zero_is_undef_splat_vec(
; CHECK-NEXT:    [[CT:%.*]] = call <2 x i8> @llvm.ctlz.v2i8(<2 x i8> [[X:%.*]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = lshr <2 x i8> [[CT]], <i8 3, i8 3>
; CHECK-NEXT:    ret <2 x i8> [[SH]]
;
  %ct = call <2 x i8> @llvm.ctlz.v2i8(<2 x i8> %x, i1 true)
  %sh = lshr <2 x i8> %ct, <i8 3, i8 3>
  ret <2 x i8> %sh
}

define i8 @lshr_ctlz_zero_is_undef_vec(<2 x i8> %x) {
; CHECK-LABEL: @lshr_ctlz_zero_is_undef_vec(
; CHECK-NEXT:    [[CT:%.*]] = call <2 x i8> @llvm.ctlz.v2i8(<2 x i8> [[X:%.*]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = lshr <2 x i8> [[CT]], <i8 3, i8 0>
; CHECK-NEXT:    [[EX:%.*]] = extractelement <2 x i8> [[SH]], i32 0
; CHECK-NEXT:    ret i8 [[EX]]
;
  %ct = call <2 x i8> @llvm.ctlz.v2i8(<2 x i8> %x, i1 true)
  %sh = lshr <2 x i8> %ct, <i8 3, i8 0>
  %ex = extractelement <2 x i8> %sh, i32 0
  ret i8 %ex
}

define <2 x i8> @lshr_cttz_zero_is_undef_splat_vec(<2 x i8> %x) {
; CHECK-LABEL: @lshr_cttz_zero_is_undef_splat_vec(
; CHECK-NEXT:    [[CT:%.*]] = call <2 x i8> @llvm.cttz.v2i8(<2 x i8> [[X:%.*]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = lshr <2 x i8> [[CT]], <i8 3, i8 3>
; CHECK-NEXT:    ret <2 x i8> [[SH]]
;
  %ct = call <2 x i8> @llvm.cttz.v2i8(<2 x i8> %x, i1 true)
  %sh = lshr <2 x i8> %ct, <i8 3, i8 3>
  ret <2 x i8> %sh
}

define i8 @lshr_cttz_zero_is_undef_vec(<2 x i8> %x) {
; CHECK-LABEL: @lshr_cttz_zero_is_undef_vec(
; CHECK-NEXT:    [[CT:%.*]] = call <2 x i8> @llvm.cttz.v2i8(<2 x i8> [[X:%.*]], i1 true)
; CHECK-NEXT:    [[SH:%.*]] = lshr <2 x i8> [[CT]], <i8 3, i8 0>
; CHECK-NEXT:    [[EX:%.*]] = extractelement <2 x i8> [[SH]], i32 0
; CHECK-NEXT:    ret i8 [[EX]]
;
  %ct = call <2 x i8> @llvm.cttz.v2i8(<2 x i8> %x, i1 true)
  %sh = lshr <2 x i8> %ct, <i8 3, i8 0>
  %ex = extractelement <2 x i8> %sh, i32 0
  ret i8 %ex
}

; The shift amount is 0 on either of high/low bytes. The middle byte doesn't matter.

define i24 @bitcast_noshift_scalar(<3 x i8> %v1, i24 %v2) {
; CHECK-LABEL: @bitcast_noshift_scalar(
; CHECK-NEXT:    ret i24 [[V2:%.*]]
;
  %c = insertelement <3 x i8> poison, i8 0, i64 0
  %s = shufflevector <3 x i8> %v1, <3 x i8> %c, <3 x i32> <i32 3, i32 1, i32 3>
  %b = bitcast <3 x i8> %s to i24
  %r = shl i24 %v2, %b
  ret i24 %r
}

; The shift amount is 0 on low byte of big-endian and unknown on little-endian.

define i24 @bitcast_noshift_scalar_bigend(<3 x i8> %v1, i24 %v2) {
; BIGENDIAN-LABEL: @bitcast_noshift_scalar_bigend(
; BIGENDIAN-NEXT:    ret i24 [[V2:%.*]]
;
; LITTLEENDIAN-LABEL: @bitcast_noshift_scalar_bigend(
; LITTLEENDIAN-NEXT:    [[S:%.*]] = shufflevector <3 x i8> [[V1:%.*]], <3 x i8> <i8 0, i8 poison, i8 poison>, <3 x i32> <i32 0, i32 1, i32 3>
; LITTLEENDIAN-NEXT:    [[B:%.*]] = bitcast <3 x i8> [[S]] to i24
; LITTLEENDIAN-NEXT:    [[R:%.*]] = shl i24 [[V2:%.*]], [[B]]
; LITTLEENDIAN-NEXT:    ret i24 [[R]]
;
  %c = insertelement <3 x i8> poison, i8 0, i64 0
  %s = shufflevector <3 x i8> %v1, <3 x i8> %c, <3 x i32> <i32 0, i32 1, i32 3>
  %b = bitcast <3 x i8> %s to i24
  %r = shl i24 %v2, %b
  ret i24 %r
}

; The shift amount is 0 on low byte of little-endian and unknown on big-endian.

define i24 @bitcast_noshift_scalar_littleend(<3 x i8> %v1, i24 %v2) {
; BIGENDIAN-LABEL: @bitcast_noshift_scalar_littleend(
; BIGENDIAN-NEXT:    [[S:%.*]] = shufflevector <3 x i8> [[V1:%.*]], <3 x i8> <i8 0, i8 poison, i8 poison>, <3 x i32> <i32 3, i32 1, i32 2>
; BIGENDIAN-NEXT:    [[B:%.*]] = bitcast <3 x i8> [[S]] to i24
; BIGENDIAN-NEXT:    [[R:%.*]] = shl i24 [[V2:%.*]], [[B]]
; BIGENDIAN-NEXT:    ret i24 [[R]]
;
; LITTLEENDIAN-LABEL: @bitcast_noshift_scalar_littleend(
; LITTLEENDIAN-NEXT:    ret i24 [[V2:%.*]]
;
  %c = insertelement <3 x i8> poison, i8 0, i64 0
  %s = shufflevector <3 x i8> %v1, <3 x i8> %c, <3 x i32> <i32 3, i32 1, i32 2>
  %b = bitcast <3 x i8> %s to i24
  %r = shl i24 %v2, %b
  ret i24 %r
}

; The shift amount is known 24 on little-endian and known 24<<16 on big-endian
; across all vector elements, so it's an overshift either way.

define <3 x i24> @bitcast_overshift_vector(<9 x i8> %v1, <3 x i24> %v2) {
; CHECK-LABEL: @bitcast_overshift_vector(
; CHECK-NEXT:    ret <3 x i24> poison
;
  %c = insertelement <9 x i8> poison, i8 24, i64 0
  %s = shufflevector <9 x i8> %v1, <9 x i8> %c, <9 x i32> <i32 9, i32 1, i32 2, i32 9, i32 4, i32 5, i32 9, i32 7, i32 8>
  %b = bitcast <9 x i8> %s to <3 x i24>
  %r = shl <3 x i24> %v2, %b
  ret <3 x i24> %r
}

; The shift amount is known 23 on little-endian and known 23<<16 on big-endian
; across all vector elements, so it's an overshift for big-endian.

define <3 x i24> @bitcast_overshift_vector_bigend(<9 x i8> %v1, <3 x i24> %v2) {
; BIGENDIAN-LABEL: @bitcast_overshift_vector_bigend(
; BIGENDIAN-NEXT:    ret <3 x i24> poison
;
; LITTLEENDIAN-LABEL: @bitcast_overshift_vector_bigend(
; LITTLEENDIAN-NEXT:    [[S:%.*]] = shufflevector <9 x i8> [[V1:%.*]], <9 x i8> <i8 23, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison>, <9 x i32> <i32 9, i32 1, i32 2, i32 9, i32 4, i32 5, i32 9, i32 7, i32 8>
; LITTLEENDIAN-NEXT:    [[B:%.*]] = bitcast <9 x i8> [[S]] to <3 x i24>
; LITTLEENDIAN-NEXT:    [[R:%.*]] = shl <3 x i24> [[V2:%.*]], [[B]]
; LITTLEENDIAN-NEXT:    ret <3 x i24> [[R]]
;
  %c = insertelement <9 x i8> poison, i8 23, i64 0
  %s = shufflevector <9 x i8> %v1, <9 x i8> %c, <9 x i32> <i32 9, i32 1, i32 2, i32 9, i32 4, i32 5, i32 9, i32 7, i32 8>
  %b = bitcast <9 x i8> %s to <3 x i24>
  %r = shl <3 x i24> %v2, %b
  ret <3 x i24> %r
}

; The shift amount is known 23 on big-endian and known 23<<16 on little-endian
; across all vector elements, so it's an overshift for little-endian.

define <3 x i24> @bitcast_overshift_vector_littleend(<9 x i8> %v1, <3 x i24> %v2) {
; BIGENDIAN-LABEL: @bitcast_overshift_vector_littleend(
; BIGENDIAN-NEXT:    [[S:%.*]] = shufflevector <9 x i8> [[V1:%.*]], <9 x i8> <i8 23, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison>, <9 x i32> <i32 0, i32 1, i32 9, i32 3, i32 4, i32 9, i32 6, i32 7, i32 9>
; BIGENDIAN-NEXT:    [[B:%.*]] = bitcast <9 x i8> [[S]] to <3 x i24>
; BIGENDIAN-NEXT:    [[R:%.*]] = shl <3 x i24> [[V2:%.*]], [[B]]
; BIGENDIAN-NEXT:    ret <3 x i24> [[R]]
;
; LITTLEENDIAN-LABEL: @bitcast_overshift_vector_littleend(
; LITTLEENDIAN-NEXT:    ret <3 x i24> poison
;
  %c = insertelement <9 x i8> poison, i8 23, i64 0
  %s = shufflevector <9 x i8> %v1, <9 x i8> %c, <9 x i32> <i32 0, i32 1, i32 9, i32 3, i32 4, i32 9, i32 6, i32 7, i32 9>
  %b = bitcast <9 x i8> %s to <3 x i24>
  %r = shl <3 x i24> %v2, %b
  ret <3 x i24> %r
}

; Negative test - the shift amount is known 24 or 24<<16 on only 2 out of 3 elements.

define <3 x i24> @bitcast_partial_overshift_vector(<9 x i8> %v1, <3 x i24> %v2) {
; CHECK-LABEL: @bitcast_partial_overshift_vector(
; CHECK-NEXT:    [[S:%.*]] = shufflevector <9 x i8> [[V1:%.*]], <9 x i8> <i8 24, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison, i8 poison>, <9 x i32> <i32 9, i32 1, i32 2, i32 9, i32 4, i32 5, i32 6, i32 7, i32 8>
; CHECK-NEXT:    [[B:%.*]] = bitcast <9 x i8> [[S]] to <3 x i24>
; CHECK-NEXT:    [[R:%.*]] = shl <3 x i24> [[V2:%.*]], [[B]]
; CHECK-NEXT:    ret <3 x i24> [[R]]
;
  %c = insertelement <9 x i8> poison, i8 24, i64 0
  %s = shufflevector <9 x i8> %v1, <9 x i8> %c, <9 x i32> <i32 9, i32 1, i32 2, i32 9, i32 4, i32 5, i32 6, i32 7, i32 8>
  %b = bitcast <9 x i8> %s to <3 x i24>
  %r = shl <3 x i24> %v2, %b
  ret <3 x i24> %r
}

; Negative test - don't know how to look through a cast with non-integer type (but we could handle this...).

define <1 x i64> @bitcast_noshift_vector_wrong_type(<2 x float> %v1, <1 x i64> %v2) {
; CHECK-LABEL: @bitcast_noshift_vector_wrong_type(
; CHECK-NEXT:    [[S:%.*]] = shufflevector <2 x float> [[V1:%.*]], <2 x float> <float 0.000000e+00, float poison>, <2 x i32> <i32 2, i32 1>
; CHECK-NEXT:    [[B:%.*]] = bitcast <2 x float> [[S]] to <1 x i64>
; CHECK-NEXT:    [[R:%.*]] = shl <1 x i64> [[V2:%.*]], [[B]]
; CHECK-NEXT:    ret <1 x i64> [[R]]
;
  %c = insertelement <2 x float> poison, float 0.0, i64 0
  %s = shufflevector <2 x float> %v1, <2 x float> %c, <2 x i32> <i32 2, i32 1>
  %b = bitcast <2 x float> %s to <1 x i64>
  %r = shl <1 x i64> %v2, %b
  ret <1 x i64> %r
}
