/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
* This program is free software; you can redistribute it and/or           *
* modify it either under the terms of the GNU Lesser General Public       *
* License version 3 as published by the Free Software Foundation          *
* (the "LGPL") or, at your option, any later version.                     *
* If you do not alter this notice, a recipient may use your version       *
* of this file under the LGPL.                                            *
*                                                                         *
* You should have received a copy of the LGPL along with this library     *
* in the file COPYING; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                         *
* This software is distributed on an "AS IS" basis, WITHOUT WARRANTY      *
* OF ANY KIND, either express or implied. See the LGPL for                *
* the specific language governing rights and limitations.                 *
**************************************************************************/

#ifndef HEADER_SESSION_AUTH
#define HEADER_SESSION_AUTH

#include <QObject>
#include <QtNetwork>
#include <QApplication>
#include <QStringList>
#include <openssl/rsa.h>
#include <openssl/pem.h>
#include <openssl/engine.h>
#include <openssl/evp.h>
#include <openssl/aes.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <stdexcept>
#include <stdio.h>
#include <stdlib.h>
#include "../crypto/rsa_utils.h"
#include "../xml/xml.h"
#include "../xml/xml_parser.h"
#include "../crypto/aes_utils.h"
#include "../utils/b64_utils.h"
#include "auth_commons.h"

using namespace std;

class auth_session : public QObject
{
    Q_OBJECT

public:
    auth_session(QTcpSocket *socket,
                 int client_nbr,
                 QString server_password,
                 QObject *parent);
    void set_socket(QTcpSocket* tcp_socket);
    QTcpSocket* get_socket();
    QString get_data_from_socket();
    void write_data_to_socket(QString data);
    void handle_crypted_auth();
    QString auth_aes_decrypt(QString message);
    int nbr;
    void send_error();
    QString auth_aes_encrypt(char* message);
    int auth_status;

signals:
    void emit_tcp_state(int state, int client_nbr);
    void emit_error(int client_nbr);
    void auth_suceeded(int nbr);
    void received_stream(QString message, int client_nbr);
    void remove_client(int client_nbr);
    void update_progress_size(int current, int total);

public slots:
    void read_results();
    void disconnected_client();
    void socket_error(QAbstractSocket::SocketError socketError);

private:
    QTcpSocket *tcp_socket;
    RSA *rsa_client_pub;
    char *client_pub_key;
    char *b64_hashed_password;
    char *b64_hashed_password_from_client;
    char* token;
    char* xml;
    QString password;
    char aes_key[32];
    int current_size;
    int packet_size;
    QByteArray *current_bytes;
    bool receiving;
    int progress;
};

#endif
