
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQImageIOHandler.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QImageIOHandler>
#include <QIODevice>
#include <QImage>
#include <QRect>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QImageIOHandler

// bool QImageIOHandler::canRead()


static void _init_f_canRead_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canRead_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->canRead ());
}


// int QImageIOHandler::currentImageNumber()


static void _init_f_currentImageNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentImageNumber_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageIOHandler *)cls)->currentImageNumber ());
}


// QRect QImageIOHandler::currentImageRect()


static void _init_f_currentImageRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_currentImageRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QImageIOHandler *)cls)->currentImageRect ());
}


// QIODevice *QImageIOHandler::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QImageIOHandler *)cls)->device ());
}


// QByteArray QImageIOHandler::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QImageIOHandler *)cls)->format ());
}


// int QImageIOHandler::imageCount()


static void _init_f_imageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_imageCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageIOHandler *)cls)->imageCount ());
}


// bool QImageIOHandler::jumpToImage(int imageNumber)


static void _init_f_jumpToImage_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("imageNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_jumpToImage_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->jumpToImage (arg1));
}


// bool QImageIOHandler::jumpToNextImage()


static void _init_f_jumpToNextImage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_jumpToNextImage_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->jumpToNextImage ());
}


// int QImageIOHandler::loopCount()


static void _init_f_loopCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_loopCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageIOHandler *)cls)->loopCount ());
}


// QByteArray QImageIOHandler::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QImageIOHandler *)cls)->name ());
}


// int QImageIOHandler::nextImageDelay()


static void _init_f_nextImageDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_nextImageDelay_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageIOHandler *)cls)->nextImageDelay ());
}


// QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)


static void _init_f_option_c3086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_option_c3086 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QImageIOHandler *)cls)->option (qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(arg1).cref()));
}


// bool QImageIOHandler::read(QImage *image)


static void _init_f_read_1186 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<QImage * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_read_1186 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QImage *arg1 = gsi::arg_reader<QImage * >() (args, heap);
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->read (arg1));
}


// void QImageIOHandler::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageIOHandler *)cls)->setDevice (arg1);
}


// void QImageIOHandler::setFormat(const QByteArray &format)


static void _init_f_setFormat_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageIOHandler *)cls)->setFormat (arg1);
}


// void QImageIOHandler::setFormat(const QByteArray &format)


static void _init_f_setFormat_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_c2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageIOHandler *)cls)->setFormat (arg1);
}


// void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)


static void _init_f_setOption_5097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_5097 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageIOHandler *)cls)->setOption (qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(arg1).cref(), arg2);
}


// bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)


static void _init_f_supportsOption_c3086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_supportsOption_c3086 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->supportsOption (qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(arg1).cref()));
}


// bool QImageIOHandler::write(const QImage &image)


static void _init_f_write_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_write_1877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  ret.write<bool > ((bool)((QImageIOHandler *)cls)->write (arg1));
}


namespace gsi
{

static gsi::Methods methods_QImageIOHandler () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("canRead", "@brief Method bool QImageIOHandler::canRead()\n", true, &_init_f_canRead_c0, &_call_f_canRead_c0);
  methods += new qt_gsi::GenericMethod ("currentImageNumber", "@brief Method int QImageIOHandler::currentImageNumber()\n", true, &_init_f_currentImageNumber_c0, &_call_f_currentImageNumber_c0);
  methods += new qt_gsi::GenericMethod ("currentImageRect", "@brief Method QRect QImageIOHandler::currentImageRect()\n", true, &_init_f_currentImageRect_c0, &_call_f_currentImageRect_c0);
  methods += new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QImageIOHandler::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
  methods += new qt_gsi::GenericMethod (":format", "@brief Method QByteArray QImageIOHandler::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
  methods += new qt_gsi::GenericMethod ("imageCount", "@brief Method int QImageIOHandler::imageCount()\n", true, &_init_f_imageCount_c0, &_call_f_imageCount_c0);
  methods += new qt_gsi::GenericMethod ("jumpToImage", "@brief Method bool QImageIOHandler::jumpToImage(int imageNumber)\n", false, &_init_f_jumpToImage_767, &_call_f_jumpToImage_767);
  methods += new qt_gsi::GenericMethod ("jumpToNextImage", "@brief Method bool QImageIOHandler::jumpToNextImage()\n", false, &_init_f_jumpToNextImage_0, &_call_f_jumpToNextImage_0);
  methods += new qt_gsi::GenericMethod ("loopCount", "@brief Method int QImageIOHandler::loopCount()\n", true, &_init_f_loopCount_c0, &_call_f_loopCount_c0);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QByteArray QImageIOHandler::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("nextImageDelay", "@brief Method int QImageIOHandler::nextImageDelay()\n", true, &_init_f_nextImageDelay_c0, &_call_f_nextImageDelay_c0);
  methods += new qt_gsi::GenericMethod ("option", "@brief Method QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)\n", true, &_init_f_option_c3086, &_call_f_option_c3086);
  methods += new qt_gsi::GenericMethod ("read", "@brief Method bool QImageIOHandler::read(QImage *image)\n", false, &_init_f_read_1186, &_call_f_read_1186);
  methods += new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QImageIOHandler::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
  methods += new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QImageIOHandler::setFormat(const QByteArray &format)\n", false, &_init_f_setFormat_2309, &_call_f_setFormat_2309);
  methods += new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QImageIOHandler::setFormat(const QByteArray &format)\n", true, &_init_f_setFormat_c2309, &_call_f_setFormat_c2309);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)\n", false, &_init_f_setOption_5097, &_call_f_setOption_5097);
  methods += new qt_gsi::GenericMethod ("supportsOption", "@brief Method bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)\n", true, &_init_f_supportsOption_c3086, &_call_f_supportsOption_c3086);
  methods += new qt_gsi::GenericMethod ("write", "@brief Method bool QImageIOHandler::write(const QImage &image)\n", false, &_init_f_write_1877, &_call_f_write_1877);
  return methods;
}

gsi::Class<QImageIOHandler> decl_QImageIOHandler ("QtGui", "QImageIOHandler_Native",
  methods_QImageIOHandler (),
  "@hide\n@alias QImageIOHandler");

GSI_QTGUI_PUBLIC gsi::Class<QImageIOHandler> &qtdecl_QImageIOHandler () { return decl_QImageIOHandler; }

}


class QImageIOHandler_Adaptor : public QImageIOHandler, public qt_gsi::QtObjectBase
{
public:

  virtual ~QImageIOHandler_Adaptor();

  //  [adaptor ctor] QImageIOHandler::QImageIOHandler()
  QImageIOHandler_Adaptor() : QImageIOHandler()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] bool QImageIOHandler::canRead()
  bool cbs_canRead_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("canRead");
  }

  virtual bool canRead() const
  {
    if (cb_canRead_c0_0.can_issue()) {
      return cb_canRead_c0_0.issue<QImageIOHandler_Adaptor, bool>(&QImageIOHandler_Adaptor::cbs_canRead_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("canRead");
    }
  }

  //  [adaptor impl] int QImageIOHandler::currentImageNumber()
  int cbs_currentImageNumber_c0_0() const
  {
    return QImageIOHandler::currentImageNumber();
  }

  virtual int currentImageNumber() const
  {
    if (cb_currentImageNumber_c0_0.can_issue()) {
      return cb_currentImageNumber_c0_0.issue<QImageIOHandler_Adaptor, int>(&QImageIOHandler_Adaptor::cbs_currentImageNumber_c0_0);
    } else {
      return QImageIOHandler::currentImageNumber();
    }
  }

  //  [adaptor impl] QRect QImageIOHandler::currentImageRect()
  QRect cbs_currentImageRect_c0_0() const
  {
    return QImageIOHandler::currentImageRect();
  }

  virtual QRect currentImageRect() const
  {
    if (cb_currentImageRect_c0_0.can_issue()) {
      return cb_currentImageRect_c0_0.issue<QImageIOHandler_Adaptor, QRect>(&QImageIOHandler_Adaptor::cbs_currentImageRect_c0_0);
    } else {
      return QImageIOHandler::currentImageRect();
    }
  }

  //  [adaptor impl] int QImageIOHandler::imageCount()
  int cbs_imageCount_c0_0() const
  {
    return QImageIOHandler::imageCount();
  }

  virtual int imageCount() const
  {
    if (cb_imageCount_c0_0.can_issue()) {
      return cb_imageCount_c0_0.issue<QImageIOHandler_Adaptor, int>(&QImageIOHandler_Adaptor::cbs_imageCount_c0_0);
    } else {
      return QImageIOHandler::imageCount();
    }
  }

  //  [adaptor impl] bool QImageIOHandler::jumpToImage(int imageNumber)
  bool cbs_jumpToImage_767_0(int imageNumber)
  {
    return QImageIOHandler::jumpToImage(imageNumber);
  }

  virtual bool jumpToImage(int imageNumber)
  {
    if (cb_jumpToImage_767_0.can_issue()) {
      return cb_jumpToImage_767_0.issue<QImageIOHandler_Adaptor, bool, int>(&QImageIOHandler_Adaptor::cbs_jumpToImage_767_0, imageNumber);
    } else {
      return QImageIOHandler::jumpToImage(imageNumber);
    }
  }

  //  [adaptor impl] bool QImageIOHandler::jumpToNextImage()
  bool cbs_jumpToNextImage_0_0()
  {
    return QImageIOHandler::jumpToNextImage();
  }

  virtual bool jumpToNextImage()
  {
    if (cb_jumpToNextImage_0_0.can_issue()) {
      return cb_jumpToNextImage_0_0.issue<QImageIOHandler_Adaptor, bool>(&QImageIOHandler_Adaptor::cbs_jumpToNextImage_0_0);
    } else {
      return QImageIOHandler::jumpToNextImage();
    }
  }

  //  [adaptor impl] int QImageIOHandler::loopCount()
  int cbs_loopCount_c0_0() const
  {
    return QImageIOHandler::loopCount();
  }

  virtual int loopCount() const
  {
    if (cb_loopCount_c0_0.can_issue()) {
      return cb_loopCount_c0_0.issue<QImageIOHandler_Adaptor, int>(&QImageIOHandler_Adaptor::cbs_loopCount_c0_0);
    } else {
      return QImageIOHandler::loopCount();
    }
  }

  //  [adaptor impl] QByteArray QImageIOHandler::name()
  QByteArray cbs_name_c0_0() const
  {
    return QImageIOHandler::name();
  }

  virtual QByteArray name() const
  {
    if (cb_name_c0_0.can_issue()) {
      return cb_name_c0_0.issue<QImageIOHandler_Adaptor, QByteArray>(&QImageIOHandler_Adaptor::cbs_name_c0_0);
    } else {
      return QImageIOHandler::name();
    }
  }

  //  [adaptor impl] int QImageIOHandler::nextImageDelay()
  int cbs_nextImageDelay_c0_0() const
  {
    return QImageIOHandler::nextImageDelay();
  }

  virtual int nextImageDelay() const
  {
    if (cb_nextImageDelay_c0_0.can_issue()) {
      return cb_nextImageDelay_c0_0.issue<QImageIOHandler_Adaptor, int>(&QImageIOHandler_Adaptor::cbs_nextImageDelay_c0_0);
    } else {
      return QImageIOHandler::nextImageDelay();
    }
  }

  //  [adaptor impl] QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)
  QVariant cbs_option_c3086_0(const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & _option) const
  {
    return QImageIOHandler::option(qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(_option).cref());
  }

  virtual QVariant option(QImageIOHandler::ImageOption _option) const
  {
    if (cb_option_c3086_0.can_issue()) {
      return cb_option_c3086_0.issue<QImageIOHandler_Adaptor, QVariant, const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type &>(&QImageIOHandler_Adaptor::cbs_option_c3086_0, qt_gsi::CppToQtAdaptor<QImageIOHandler::ImageOption>(_option));
    } else {
      return QImageIOHandler::option(_option);
    }
  }

  //  [adaptor impl] bool QImageIOHandler::read(QImage *image)
  bool cbs_read_1186_0(QImage *image)
  {
    __SUPPRESS_UNUSED_WARNING (image);
    throw qt_gsi::AbstractMethodCalledException("read");
  }

  virtual bool read(QImage *image)
  {
    if (cb_read_1186_0.can_issue()) {
      return cb_read_1186_0.issue<QImageIOHandler_Adaptor, bool, QImage *>(&QImageIOHandler_Adaptor::cbs_read_1186_0, image);
    } else {
      throw qt_gsi::AbstractMethodCalledException("read");
    }
  }

  //  [adaptor impl] void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)
  void cbs_setOption_5097_0(const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & option, const QVariant &value)
  {
    QImageIOHandler::setOption(qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(option).cref(), value);
  }

  virtual void setOption(QImageIOHandler::ImageOption option, const QVariant &value)
  {
    if (cb_setOption_5097_0.can_issue()) {
      cb_setOption_5097_0.issue<QImageIOHandler_Adaptor, const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type &, const QVariant &>(&QImageIOHandler_Adaptor::cbs_setOption_5097_0, qt_gsi::CppToQtAdaptor<QImageIOHandler::ImageOption>(option), value);
    } else {
      QImageIOHandler::setOption(option, value);
    }
  }

  //  [adaptor impl] bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)
  bool cbs_supportsOption_c3086_0(const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & option) const
  {
    return QImageIOHandler::supportsOption(qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(option).cref());
  }

  virtual bool supportsOption(QImageIOHandler::ImageOption option) const
  {
    if (cb_supportsOption_c3086_0.can_issue()) {
      return cb_supportsOption_c3086_0.issue<QImageIOHandler_Adaptor, bool, const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type &>(&QImageIOHandler_Adaptor::cbs_supportsOption_c3086_0, qt_gsi::CppToQtAdaptor<QImageIOHandler::ImageOption>(option));
    } else {
      return QImageIOHandler::supportsOption(option);
    }
  }

  //  [adaptor impl] bool QImageIOHandler::write(const QImage &image)
  bool cbs_write_1877_0(const QImage &image)
  {
    return QImageIOHandler::write(image);
  }

  virtual bool write(const QImage &image)
  {
    if (cb_write_1877_0.can_issue()) {
      return cb_write_1877_0.issue<QImageIOHandler_Adaptor, bool, const QImage &>(&QImageIOHandler_Adaptor::cbs_write_1877_0, image);
    } else {
      return QImageIOHandler::write(image);
    }
  }

  gsi::Callback cb_canRead_c0_0;
  gsi::Callback cb_currentImageNumber_c0_0;
  gsi::Callback cb_currentImageRect_c0_0;
  gsi::Callback cb_imageCount_c0_0;
  gsi::Callback cb_jumpToImage_767_0;
  gsi::Callback cb_jumpToNextImage_0_0;
  gsi::Callback cb_loopCount_c0_0;
  gsi::Callback cb_name_c0_0;
  gsi::Callback cb_nextImageDelay_c0_0;
  gsi::Callback cb_option_c3086_0;
  gsi::Callback cb_read_1186_0;
  gsi::Callback cb_setOption_5097_0;
  gsi::Callback cb_supportsOption_c3086_0;
  gsi::Callback cb_write_1877_0;
};

QImageIOHandler_Adaptor::~QImageIOHandler_Adaptor() { }

//  Constructor QImageIOHandler::QImageIOHandler() (adaptor class)

static void _init_ctor_QImageIOHandler_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QImageIOHandler_Adaptor> ();
}

static void _call_ctor_QImageIOHandler_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImageIOHandler_Adaptor *> (new QImageIOHandler_Adaptor ());
}


// bool QImageIOHandler::canRead()

static void _init_cbs_canRead_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_canRead_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_canRead_c0_0 ());
}

static void _set_callback_cbs_canRead_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_canRead_c0_0 = cb;
}


// int QImageIOHandler::currentImageNumber()

static void _init_cbs_currentImageNumber_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_currentImageNumber_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageIOHandler_Adaptor *)cls)->cbs_currentImageNumber_c0_0 ());
}

static void _set_callback_cbs_currentImageNumber_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_currentImageNumber_c0_0 = cb;
}


// QRect QImageIOHandler::currentImageRect()

static void _init_cbs_currentImageRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_currentImageRect_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QImageIOHandler_Adaptor *)cls)->cbs_currentImageRect_c0_0 ());
}

static void _set_callback_cbs_currentImageRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_currentImageRect_c0_0 = cb;
}


// int QImageIOHandler::imageCount()

static void _init_cbs_imageCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_imageCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageIOHandler_Adaptor *)cls)->cbs_imageCount_c0_0 ());
}

static void _set_callback_cbs_imageCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_imageCount_c0_0 = cb;
}


// bool QImageIOHandler::jumpToImage(int imageNumber)

static void _init_cbs_jumpToImage_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("imageNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_jumpToImage_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_jumpToImage_767_0 (arg1));
}

static void _set_callback_cbs_jumpToImage_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_jumpToImage_767_0 = cb;
}


// bool QImageIOHandler::jumpToNextImage()

static void _init_cbs_jumpToNextImage_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_jumpToNextImage_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_jumpToNextImage_0_0 ());
}

static void _set_callback_cbs_jumpToNextImage_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_jumpToNextImage_0_0 = cb;
}


// int QImageIOHandler::loopCount()

static void _init_cbs_loopCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_loopCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageIOHandler_Adaptor *)cls)->cbs_loopCount_c0_0 ());
}

static void _set_callback_cbs_loopCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_loopCount_c0_0 = cb;
}


// QByteArray QImageIOHandler::name()

static void _init_cbs_name_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_cbs_name_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QImageIOHandler_Adaptor *)cls)->cbs_name_c0_0 ());
}

static void _set_callback_cbs_name_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_name_c0_0 = cb;
}


// int QImageIOHandler::nextImageDelay()

static void _init_cbs_nextImageDelay_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_nextImageDelay_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageIOHandler_Adaptor *)cls)->cbs_nextImageDelay_c0_0 ());
}

static void _set_callback_cbs_nextImageDelay_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_nextImageDelay_c0_0 = cb;
}


// QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)

static void _init_cbs_option_c3086_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_option_c3086_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QImageIOHandler_Adaptor *)cls)->cbs_option_c3086_0 (arg1));
}

static void _set_callback_cbs_option_c3086_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_option_c3086_0 = cb;
}


// bool QImageIOHandler::read(QImage *image)

static void _init_cbs_read_1186_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<QImage * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_read_1186_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QImage *arg1 = args.read<QImage * > (heap);
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_read_1186_0 (arg1));
}

static void _set_callback_cbs_read_1186_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_read_1186_0 = cb;
}


// void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)

static void _init_cbs_setOption_5097_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setOption_5097_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageIOHandler_Adaptor *)cls)->cbs_setOption_5097_0 (arg1, arg2);
}

static void _set_callback_cbs_setOption_5097_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_setOption_5097_0 = cb;
}


// bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)

static void _init_cbs_supportsOption_c3086_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsOption_c3086_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (heap);
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_supportsOption_c3086_0 (arg1));
}

static void _set_callback_cbs_supportsOption_c3086_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_supportsOption_c3086_0 = cb;
}


// bool QImageIOHandler::write(const QImage &image)

static void _init_cbs_write_1877_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_write_1877_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = args.read<const QImage & > (heap);
  ret.write<bool > ((bool)((QImageIOHandler_Adaptor *)cls)->cbs_write_1877_0 (arg1));
}

static void _set_callback_cbs_write_1877_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageIOHandler_Adaptor *)cls)->cb_write_1877_0 = cb;
}


namespace gsi
{

gsi::Class<QImageIOHandler> &qtdecl_QImageIOHandler ();

static gsi::Methods methods_QImageIOHandler_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageIOHandler::QImageIOHandler()\nThis method creates an object of class QImageIOHandler.", &_init_ctor_QImageIOHandler_Adaptor_0, &_call_ctor_QImageIOHandler_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("canRead", "@brief Virtual method bool QImageIOHandler::canRead()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canRead_c0_0, &_call_cbs_canRead_c0_0);
  methods += new qt_gsi::GenericMethod ("canRead", "@hide", true, &_init_cbs_canRead_c0_0, &_call_cbs_canRead_c0_0, &_set_callback_cbs_canRead_c0_0);
  methods += new qt_gsi::GenericMethod ("currentImageNumber", "@brief Virtual method int QImageIOHandler::currentImageNumber()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_currentImageNumber_c0_0, &_call_cbs_currentImageNumber_c0_0);
  methods += new qt_gsi::GenericMethod ("currentImageNumber", "@hide", true, &_init_cbs_currentImageNumber_c0_0, &_call_cbs_currentImageNumber_c0_0, &_set_callback_cbs_currentImageNumber_c0_0);
  methods += new qt_gsi::GenericMethod ("currentImageRect", "@brief Virtual method QRect QImageIOHandler::currentImageRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_currentImageRect_c0_0, &_call_cbs_currentImageRect_c0_0);
  methods += new qt_gsi::GenericMethod ("currentImageRect", "@hide", true, &_init_cbs_currentImageRect_c0_0, &_call_cbs_currentImageRect_c0_0, &_set_callback_cbs_currentImageRect_c0_0);
  methods += new qt_gsi::GenericMethod ("imageCount", "@brief Virtual method int QImageIOHandler::imageCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_imageCount_c0_0, &_call_cbs_imageCount_c0_0);
  methods += new qt_gsi::GenericMethod ("imageCount", "@hide", true, &_init_cbs_imageCount_c0_0, &_call_cbs_imageCount_c0_0, &_set_callback_cbs_imageCount_c0_0);
  methods += new qt_gsi::GenericMethod ("jumpToImage", "@brief Virtual method bool QImageIOHandler::jumpToImage(int imageNumber)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_jumpToImage_767_0, &_call_cbs_jumpToImage_767_0);
  methods += new qt_gsi::GenericMethod ("jumpToImage", "@hide", false, &_init_cbs_jumpToImage_767_0, &_call_cbs_jumpToImage_767_0, &_set_callback_cbs_jumpToImage_767_0);
  methods += new qt_gsi::GenericMethod ("jumpToNextImage", "@brief Virtual method bool QImageIOHandler::jumpToNextImage()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_jumpToNextImage_0_0, &_call_cbs_jumpToNextImage_0_0);
  methods += new qt_gsi::GenericMethod ("jumpToNextImage", "@hide", false, &_init_cbs_jumpToNextImage_0_0, &_call_cbs_jumpToNextImage_0_0, &_set_callback_cbs_jumpToNextImage_0_0);
  methods += new qt_gsi::GenericMethod ("loopCount", "@brief Virtual method int QImageIOHandler::loopCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_loopCount_c0_0, &_call_cbs_loopCount_c0_0);
  methods += new qt_gsi::GenericMethod ("loopCount", "@hide", true, &_init_cbs_loopCount_c0_0, &_call_cbs_loopCount_c0_0, &_set_callback_cbs_loopCount_c0_0);
  methods += new qt_gsi::GenericMethod ("name", "@brief Virtual method QByteArray QImageIOHandler::name()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_name_c0_0, &_call_cbs_name_c0_0);
  methods += new qt_gsi::GenericMethod ("name", "@hide", true, &_init_cbs_name_c0_0, &_call_cbs_name_c0_0, &_set_callback_cbs_name_c0_0);
  methods += new qt_gsi::GenericMethod ("nextImageDelay", "@brief Virtual method int QImageIOHandler::nextImageDelay()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_nextImageDelay_c0_0, &_call_cbs_nextImageDelay_c0_0);
  methods += new qt_gsi::GenericMethod ("nextImageDelay", "@hide", true, &_init_cbs_nextImageDelay_c0_0, &_call_cbs_nextImageDelay_c0_0, &_set_callback_cbs_nextImageDelay_c0_0);
  methods += new qt_gsi::GenericMethod ("option", "@brief Virtual method QVariant QImageIOHandler::option(QImageIOHandler::ImageOption option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_option_c3086_0, &_call_cbs_option_c3086_0);
  methods += new qt_gsi::GenericMethod ("option", "@hide", true, &_init_cbs_option_c3086_0, &_call_cbs_option_c3086_0, &_set_callback_cbs_option_c3086_0);
  methods += new qt_gsi::GenericMethod ("read", "@brief Virtual method bool QImageIOHandler::read(QImage *image)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_read_1186_0, &_call_cbs_read_1186_0);
  methods += new qt_gsi::GenericMethod ("read", "@hide", false, &_init_cbs_read_1186_0, &_call_cbs_read_1186_0, &_set_callback_cbs_read_1186_0);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Virtual method void QImageIOHandler::setOption(QImageIOHandler::ImageOption option, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOption_5097_0, &_call_cbs_setOption_5097_0);
  methods += new qt_gsi::GenericMethod ("setOption", "@hide", false, &_init_cbs_setOption_5097_0, &_call_cbs_setOption_5097_0, &_set_callback_cbs_setOption_5097_0);
  methods += new qt_gsi::GenericMethod ("supportsOption", "@brief Virtual method bool QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsOption_c3086_0, &_call_cbs_supportsOption_c3086_0);
  methods += new qt_gsi::GenericMethod ("supportsOption", "@hide", true, &_init_cbs_supportsOption_c3086_0, &_call_cbs_supportsOption_c3086_0, &_set_callback_cbs_supportsOption_c3086_0);
  methods += new qt_gsi::GenericMethod ("write", "@brief Virtual method bool QImageIOHandler::write(const QImage &image)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_write_1877_0, &_call_cbs_write_1877_0);
  methods += new qt_gsi::GenericMethod ("write", "@hide", false, &_init_cbs_write_1877_0, &_call_cbs_write_1877_0, &_set_callback_cbs_write_1877_0);
  return methods;
}

gsi::Class<QImageIOHandler_Adaptor> decl_QImageIOHandler_Adaptor (qtdecl_QImageIOHandler (), "QtGui", "QImageIOHandler",
  methods_QImageIOHandler_Adaptor (),
  "@qt\n@brief Binding of QImageIOHandler");

}


//  Implementation of the enum wrapper class for QImageIOHandler::ImageOption
namespace qt_gsi
{

static gsi::Enum<QImageIOHandler::ImageOption> decl_QImageIOHandler_ImageOption_Enum ("QtGui", "QImageIOHandler_ImageOption",
    gsi::enum_const ("Size", QImageIOHandler::Size, "@brief Enum constant QImageIOHandler::Size") +
    gsi::enum_const ("ClipRect", QImageIOHandler::ClipRect, "@brief Enum constant QImageIOHandler::ClipRect") +
    gsi::enum_const ("Description", QImageIOHandler::Description, "@brief Enum constant QImageIOHandler::Description") +
    gsi::enum_const ("ScaledClipRect", QImageIOHandler::ScaledClipRect, "@brief Enum constant QImageIOHandler::ScaledClipRect") +
    gsi::enum_const ("ScaledSize", QImageIOHandler::ScaledSize, "@brief Enum constant QImageIOHandler::ScaledSize") +
    gsi::enum_const ("CompressionRatio", QImageIOHandler::CompressionRatio, "@brief Enum constant QImageIOHandler::CompressionRatio") +
    gsi::enum_const ("Gamma", QImageIOHandler::Gamma, "@brief Enum constant QImageIOHandler::Gamma") +
    gsi::enum_const ("Quality", QImageIOHandler::Quality, "@brief Enum constant QImageIOHandler::Quality") +
    gsi::enum_const ("Name", QImageIOHandler::Name, "@brief Enum constant QImageIOHandler::Name") +
    gsi::enum_const ("SubType", QImageIOHandler::SubType, "@brief Enum constant QImageIOHandler::SubType") +
    gsi::enum_const ("IncrementalReading", QImageIOHandler::IncrementalReading, "@brief Enum constant QImageIOHandler::IncrementalReading") +
    gsi::enum_const ("Endianness", QImageIOHandler::Endianness, "@brief Enum constant QImageIOHandler::Endianness") +
    gsi::enum_const ("Animation", QImageIOHandler::Animation, "@brief Enum constant QImageIOHandler::Animation") +
    gsi::enum_const ("BackgroundColor", QImageIOHandler::BackgroundColor, "@brief Enum constant QImageIOHandler::BackgroundColor") +
    gsi::enum_const ("ImageFormat", QImageIOHandler::ImageFormat, "@brief Enum constant QImageIOHandler::ImageFormat"),
  "@qt\n@brief This class represents the QImageIOHandler::ImageOption enum");

static gsi::QFlagsClass<QImageIOHandler::ImageOption > decl_QImageIOHandler_ImageOption_Enums ("QtGui", "QImageIOHandler_QFlags_ImageOption",
  "@qt\n@brief This class represents the QFlags<QImageIOHandler::ImageOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QImageIOHandler> inject_QImageIOHandler_ImageOption_Enum_in_parent (decl_QImageIOHandler_ImageOption_Enum.defs ());
static gsi::ClassExt<QImageIOHandler> decl_QImageIOHandler_ImageOption_Enum_as_child (decl_QImageIOHandler_ImageOption_Enum, "ImageOption");
static gsi::ClassExt<QImageIOHandler> decl_QImageIOHandler_ImageOption_Enums_as_child (decl_QImageIOHandler_ImageOption_Enums, "QFlags_ImageOption");

}

