Kivy
====

<img align="right" height="256" src="https://raw.githubusercontent.com/kivy/kivy/master/kivy/data/logo/kivy-icon-256.png"/>

Innovative user interfaces made easy.

Kivy is an open source, cross-platform [Python](https://www.python.org)
framework for the development of applications that make use of innovative,
multi-touch user interfaces.
The aim is to allow for quick and easy interaction design and rapid prototyping
whilst making your code reusable and deployable.

Kivy is written in Python and [Cython](http://cython.org/), based on OpenGL ES
2, supports various input devices and has an extensive widget library. With the
same codebase, you can target Windows, OS X, Linux, Android and iOS. All Kivy
widgets are built with multitouch support.

Kivy is MIT licensed, actively developed by a great community and is supported
by many projects managed by the [Kivy Organization](http://kivy.org/#organization).

[![Coverage Status](https://coveralls.io/repos/kivy/kivy/badge.svg?branch=master)](https://coveralls.io/r/kivy/kivy?branch=master)
[![Build Status](https://travis-ci.org/kivy/kivy.svg?branch=master)](https://travis-ci.org/kivy/kivy)
[![Build status](https://ci.appveyor.com/api/projects/status/pkmu22lyw4i2bscy/branch/master?svg=true)](https://ci.appveyor.com/project/matham/kivy/branch/master)
[![Bountysource](https://www.bountysource.com/badge/tracker?tracker_id=42681)](https://www.bountysource.com/trackers/42681-kivy?utm_source=42681&utm_medium=shield&utm_campaign=TRACKER_BADGE)

Installation, Documentation and Examples
----------------------------------------

Extensive installation instructions as well as tutorials and general
documentation, including an API reference, can be found at http://kivy.org/docs.
A [PDF version](http://kivy.org/docs/pdf/Kivy-latest.pdf) is also available.

Kivy ships with many examples which can be found in the `examples` folder.

Support
-------

If you need assistance, you can ask for help on our mailing list:

* User Group : https://groups.google.com/group/kivy-users
* Email      : kivy-users@googlegroups.com

We also have an IRC channel:

* Server  : irc.freenode.net
* Port    : 6667, 6697 (SSL only)
* Channel : #kivy

Contributing
------------

We love pull requests and discussing novel ideas. Check out our
[contribution guide](http://kivy.org/docs/contribute.html) and
feel free to improve Kivy.

The following mailing list and IRC channel are used exclusively for
discussions about developing the Kivy framework and its sister projects:

* Dev Group : https://groups.google.com/group/kivy-dev
* Email     : kivy-dev@googlegroups.com

IRC channel:

* Server  : irc.freenode.net
* Port    : 6667, 6697 (SSL only)
* Channel : #kivy-dev

Sister projects
---------------

- [Buildozer](http://github.com/kivy/buildozer): generic Python packager
  for Android and iOS.
- [Plyer](http://github.com/kivy/plyer): platform-independent Python wrapper
  for platform-dependent APIs.
- [Pyjnius](http://github.com/kivy/pyjnius): dynamic access to the Java/Android
  API from Python.
- [Pyobjus](http://github.com/kivy/pyobjus): dynamic access to the
  Objective-C/iOS API from Python.
- [Python for Android](http://github.com/kivy/python-for-android): toolchain
  for building and packaging Python applications for Android.
- [Kivy iOS](http://github.com/kivy/kivy-ios): toolchain for building and
  packaging Kivy applications for iOS.
- [Audiostream](http://github.com/kivy/audiostream): library for direct access
  to the microphone and speaker.
- [Kivy Designer](http://github.com/kivy/kivy-designer): UI designer for Kivy.
- [KivEnt](http://github.com/kivy/kivent): entity-based game engine for Kivy.
- [Garden](http://github.com/kivy-garden): widgets and libraries created and 
  maintained by users.

Licenses
--------

- Kivy is released under the terms of the MIT License. Please refer to the
  LICENSE file.
- The provided fonts Roboto and Roboto Mono are licensed and
  distributed under the terms of the
  [Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0).
  The DejaVuSans (used for the virtual keyboard) license can be viewed
  [here](http://dejavu-fonts.org/wiki/License).
- The current UI design has been adapted from Moblintouch theme's SVGs
  and is licensed under the terms of the
  [LGPLv2.1](http://www.gnu.org/licenses/old-licenses/lgpl-2.1).
