#include <config.h>
#include <stdio.h>

#include "GImage.h"

/* Abstract class for describing a generalized RGB image.  Images have
 * width, height, aspect ratio, comments, and RGB pixels stored as int
 * with values typically in the range [-16384,16383], but may be outside
 * this range.
 * 
 * Written by:  Chris Studholme
 * Last Update: 2-December-1999
 * Copyright:   GPL (http://www.fsf.org/copyleft/gpl.html)
 */


/* ================ GImage methods  ================ */

/* must have y1<y2
 */
void GImage::getScanLineHorz(short* red, short* green, short* blue,
			     float x1, float y1, 
			     float x2, float y2, int npixels) {
  float delta=(x2-x1)/npixels;
  float start=x1;
  if (delta>0)
    for (int i=0; i<npixels; ++i) {
      float end=start+delta;
      getPixel(red[i],green[i],blue[i],start,y1,end,y2);
      start=end;
    }
  else
    for (int i=0; i<npixels; ++i) {
      float end=start+delta;
      getPixel(red[i],green[i],blue[i],end,y1,start,y2);
      start=end;
    }
}

/* must have x1<x2
 */
void GImage::getScanLineVert(short* red, short* green, short* blue,
			     float x1, float y1, 
			     float x2, float y2, int npixels) {
  float delta=(y2-y1)/npixels;
  float start=y1;
  if (delta>0)
    for (int i=0; i<npixels; ++i) {
      float end=start+delta;
      getPixel(red[i],green[i],blue[i],x1,start,x2,end);
      start=end;
    }
  else
    for (int i=0; i<npixels; ++i) {
      float end=start+delta;
      getPixel(red[i],green[i],blue[i],x1,end,x2,start);
      start=end;
    }
}

