package CParse::StructDeclaration;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $specifiers = shift;
    my $declarators = shift;
    my $self = {specifiers => $specifiers,
                declarators => $declarators,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $specifiers = join(' ', grep {$_} map {$_->dump_c} @{$self->{specifiers}});
    my $declarators = join(', ', map {$_->dump_c} @{$self->{declarators}});

    return "$specifiers $declarators;\n";
  }

sub get_members
  {
    my $self = shift;

    my $namespace = shift;

    my @attributes;
    my @specifiers;

    foreach my $specifier (@{$self->{specifiers}})
      {
        if ($specifier->isa('CParse::AttributeList'))
          {
            push @attributes, $specifier->attributes;
          }
        elsif ($specifier->isa('CParse::Struct') or $specifier->isa('CParse::Union') or $specifier->isa('CParse::Enum'))
          {
            $specifier->process($namespace);
            push @specifiers, $specifier;
          }
        else
          {
            push @specifiers, $specifier;
          }
      }

    return map {$_->get_member($namespace, \@specifiers, \@attributes)} @{$self->{declarators}};
  }

1;
