--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.GL.PixelRectangles
-- Copyright   :  (c) Sven Panne 2002-2019
-- License     :  BSD3
-- 
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- This module corresponds to section 3.6 (Pixel Rectangles) of the OpenGL 2.1
-- specs.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.GL.PixelRectangles (
   module Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelStorage,
   module Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelTransfer,
   module Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelMap,
   module Graphics.Rendering.OpenGL.GL.PixelRectangles.ColorTable,
   module Graphics.Rendering.OpenGL.GL.PixelRectangles.Convolution,
   module Graphics.Rendering.OpenGL.GL.PixelRectangles.Histogram,
   module Graphics.Rendering.OpenGL.GL.PixelRectangles.Minmax,
   module Graphics.Rendering.OpenGL.GL.PixelRectangles.Rasterization
) where

import Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelStorage
import Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelTransfer
import Graphics.Rendering.OpenGL.GL.PixelRectangles.PixelMap
import Graphics.Rendering.OpenGL.GL.PixelRectangles.ColorTable
import Graphics.Rendering.OpenGL.GL.PixelRectangles.Convolution
import Graphics.Rendering.OpenGL.GL.PixelRectangles.Histogram
import Graphics.Rendering.OpenGL.GL.PixelRectangles.Minmax
import Graphics.Rendering.OpenGL.GL.PixelRectangles.Rasterization
