/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.util.concurrent;
public class TrustedInputFutureTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.util.concurrent.testModule";
}
public void testCanceled() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testCanceled();
}

public void testFailed() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testFailed();
}

public void testInterrupted() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testInterrupted();
}

public void testListenLaterCancelled() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterCancelled();
}

public void testListenLaterFailed() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterFailed();
}

public void testListenLaterInterrupted() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterInterrupted();
}

public void testListenLaterSetAsynchronously() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterSetAsynchronously();
}

public void testListenLaterSetAsynchronouslyLaterDelegateCancelled() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterSetAsynchronouslyLaterDelegateCancelled();
}

public void testListenLaterSetAsynchronouslyLaterDelegateFailed() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterSetAsynchronouslyLaterDelegateFailed();
}

public void testListenLaterSetAsynchronouslyLaterDelegateInterrupted() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterSetAsynchronouslyLaterDelegateInterrupted();
}

public void testListenLaterSetAsynchronouslyLaterDelegateSuccessful() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterSetAsynchronouslyLaterDelegateSuccessful();
}

public void testListenLaterSetAsynchronouslyLaterSelfCancelled() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterSetAsynchronouslyLaterSelfCancelled();
}

public void testListenLaterSetAsynchronouslyLaterSelfInterrupted() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterSetAsynchronouslyLaterSelfInterrupted();
}

public void testListenLaterSuccessful() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testListenLaterSuccessful();
}

public void testMisbehavingListenerAlreadyDone() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testMisbehavingListenerAlreadyDone();
}

public void testMisbehavingListenerLaterDone() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testMisbehavingListenerLaterDone();
}

public void testNegativeTimeout() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testNegativeTimeout();
}

public void testNullExecutor() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testNullExecutor();
}

public void testNullListener() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testNullListener();
}

public void testNullTimeUnit() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testNullTimeUnit();
}

public void testPending() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testPending();
}

public void testSetExceptionNull() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetExceptionNull();
}

public void testSetFutureDelegateAlreadyCancelled() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureDelegateAlreadyCancelled();
}

public void testSetFutureDelegateAlreadyInterrupted() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureDelegateAlreadyInterrupted();
}

public void testSetFutureDelegateAlreadySuccessful() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureDelegateAlreadySuccessful();
}

public void testSetFutureDelegateLaterCancelled() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureDelegateLaterCancelled();
}

public void testSetFutureDelegateLaterInterrupted() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureDelegateLaterInterrupted();
}

public void testSetFutureDelegateLaterSuccessful() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureDelegateLaterSuccessful();
}

public void testSetFutureNull() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureNull();
}

public void testSetFuturePending() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFuturePending();
}

public void testSetFutureThenCancel() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureThenCancel();
}

public void testSetFutureThenInterrupt() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetFutureThenInterrupt();
}

public void testSetNull() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSetNull();
}

public void testSuccessful() throws Exception {
  com.google.common.util.concurrent.TrustedInputFutureTest testCase = new com.google.common.util.concurrent.TrustedInputFutureTest();
  testCase.setUp();
  testCase.testSuccessful();
}
}
