package dtl

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CostPropertyType enumerates the values for cost property type.
type CostPropertyType string

const (
	// Projected ...
	Projected CostPropertyType = "Projected"
	// Reported ...
	Reported CostPropertyType = "Reported"
	// Unavailable ...
	Unavailable CostPropertyType = "Unavailable"
)

// PossibleCostPropertyTypeValues returns an array of possible values for the CostPropertyType const type.
func PossibleCostPropertyTypeValues() []CostPropertyType {
	return []CostPropertyType{Projected, Reported, Unavailable}
}

// CustomImageOsType enumerates the values for custom image os type.
type CustomImageOsType string

const (
	// Linux ...
	Linux CustomImageOsType = "Linux"
	// None ...
	None CustomImageOsType = "None"
	// Windows ...
	Windows CustomImageOsType = "Windows"
)

// PossibleCustomImageOsTypeValues returns an array of possible values for the CustomImageOsType const type.
func PossibleCustomImageOsTypeValues() []CustomImageOsType {
	return []CustomImageOsType{Linux, None, Windows}
}

// EnableStatus enumerates the values for enable status.
type EnableStatus string

const (
	// Disabled ...
	Disabled EnableStatus = "Disabled"
	// Enabled ...
	Enabled EnableStatus = "Enabled"
)

// PossibleEnableStatusValues returns an array of possible values for the EnableStatus const type.
func PossibleEnableStatusValues() []EnableStatus {
	return []EnableStatus{Disabled, Enabled}
}

// LabStorageType enumerates the values for lab storage type.
type LabStorageType string

const (
	// Premium ...
	Premium LabStorageType = "Premium"
	// Standard ...
	Standard LabStorageType = "Standard"
)

// PossibleLabStorageTypeValues returns an array of possible values for the LabStorageType const type.
func PossibleLabStorageTypeValues() []LabStorageType {
	return []LabStorageType{Premium, Standard}
}

// LinuxOsState enumerates the values for linux os state.
type LinuxOsState string

const (
	// DeprovisionApplied ...
	DeprovisionApplied LinuxOsState = "DeprovisionApplied"
	// DeprovisionRequested ...
	DeprovisionRequested LinuxOsState = "DeprovisionRequested"
	// NonDeprovisioned ...
	NonDeprovisioned LinuxOsState = "NonDeprovisioned"
)

// PossibleLinuxOsStateValues returns an array of possible values for the LinuxOsState const type.
func PossibleLinuxOsStateValues() []LinuxOsState {
	return []LinuxOsState{DeprovisionApplied, DeprovisionRequested, NonDeprovisioned}
}

// PolicyEvaluatorType enumerates the values for policy evaluator type.
type PolicyEvaluatorType string

const (
	// AllowedValuesPolicy ...
	AllowedValuesPolicy PolicyEvaluatorType = "AllowedValuesPolicy"
	// MaxValuePolicy ...
	MaxValuePolicy PolicyEvaluatorType = "MaxValuePolicy"
)

// PossiblePolicyEvaluatorTypeValues returns an array of possible values for the PolicyEvaluatorType const type.
func PossiblePolicyEvaluatorTypeValues() []PolicyEvaluatorType {
	return []PolicyEvaluatorType{AllowedValuesPolicy, MaxValuePolicy}
}

// PolicyFactName enumerates the values for policy fact name.
type PolicyFactName string

const (
	// PolicyFactNameGalleryImage ...
	PolicyFactNameGalleryImage PolicyFactName = "GalleryImage"
	// PolicyFactNameLabVMCount ...
	PolicyFactNameLabVMCount PolicyFactName = "LabVmCount"
	// PolicyFactNameLabVMSize ...
	PolicyFactNameLabVMSize PolicyFactName = "LabVmSize"
	// PolicyFactNameUserOwnedLabVMCount ...
	PolicyFactNameUserOwnedLabVMCount PolicyFactName = "UserOwnedLabVmCount"
	// PolicyFactNameUserOwnedLabVMCountInSubnet ...
	PolicyFactNameUserOwnedLabVMCountInSubnet PolicyFactName = "UserOwnedLabVmCountInSubnet"
)

// PossiblePolicyFactNameValues returns an array of possible values for the PolicyFactName const type.
func PossiblePolicyFactNameValues() []PolicyFactName {
	return []PolicyFactName{PolicyFactNameGalleryImage, PolicyFactNameLabVMCount, PolicyFactNameLabVMSize, PolicyFactNameUserOwnedLabVMCount, PolicyFactNameUserOwnedLabVMCountInSubnet}
}

// PolicyStatus enumerates the values for policy status.
type PolicyStatus string

const (
	// PolicyStatusDisabled ...
	PolicyStatusDisabled PolicyStatus = "Disabled"
	// PolicyStatusEnabled ...
	PolicyStatusEnabled PolicyStatus = "Enabled"
)

// PossiblePolicyStatusValues returns an array of possible values for the PolicyStatus const type.
func PossiblePolicyStatusValues() []PolicyStatus {
	return []PolicyStatus{PolicyStatusDisabled, PolicyStatusEnabled}
}

// SourceControlType enumerates the values for source control type.
type SourceControlType string

const (
	// GitHub ...
	GitHub SourceControlType = "GitHub"
	// VsoGit ...
	VsoGit SourceControlType = "VsoGit"
)

// PossibleSourceControlTypeValues returns an array of possible values for the SourceControlType const type.
func PossibleSourceControlTypeValues() []SourceControlType {
	return []SourceControlType{GitHub, VsoGit}
}

// SubscriptionNotificationState enumerates the values for subscription notification state.
type SubscriptionNotificationState string

const (
	// Deleted ...
	Deleted SubscriptionNotificationState = "Deleted"
	// NotDefined ...
	NotDefined SubscriptionNotificationState = "NotDefined"
	// Registered ...
	Registered SubscriptionNotificationState = "Registered"
	// Suspended ...
	Suspended SubscriptionNotificationState = "Suspended"
	// Unregistered ...
	Unregistered SubscriptionNotificationState = "Unregistered"
	// Warned ...
	Warned SubscriptionNotificationState = "Warned"
)

// PossibleSubscriptionNotificationStateValues returns an array of possible values for the SubscriptionNotificationState const type.
func PossibleSubscriptionNotificationStateValues() []SubscriptionNotificationState {
	return []SubscriptionNotificationState{Deleted, NotDefined, Registered, Suspended, Unregistered, Warned}
}

// TaskType enumerates the values for task type.
type TaskType string

const (
	// LabBillingTask ...
	LabBillingTask TaskType = "LabBillingTask"
	// LabVmsShutdownTask ...
	LabVmsShutdownTask TaskType = "LabVmsShutdownTask"
	// LabVmsStartupTask ...
	LabVmsStartupTask TaskType = "LabVmsStartupTask"
)

// PossibleTaskTypeValues returns an array of possible values for the TaskType const type.
func PossibleTaskTypeValues() []TaskType {
	return []TaskType{LabBillingTask, LabVmsShutdownTask, LabVmsStartupTask}
}

// UsagePermissionType enumerates the values for usage permission type.
type UsagePermissionType string

const (
	// Allow ...
	Allow UsagePermissionType = "Allow"
	// Default ...
	Default UsagePermissionType = "Default"
	// Deny ...
	Deny UsagePermissionType = "Deny"
)

// PossibleUsagePermissionTypeValues returns an array of possible values for the UsagePermissionType const type.
func PossibleUsagePermissionTypeValues() []UsagePermissionType {
	return []UsagePermissionType{Allow, Default, Deny}
}

// WindowsOsState enumerates the values for windows os state.
type WindowsOsState string

const (
	// NonSysprepped ...
	NonSysprepped WindowsOsState = "NonSysprepped"
	// SysprepApplied ...
	SysprepApplied WindowsOsState = "SysprepApplied"
	// SysprepRequested ...
	SysprepRequested WindowsOsState = "SysprepRequested"
)

// PossibleWindowsOsStateValues returns an array of possible values for the WindowsOsState const type.
func PossibleWindowsOsStateValues() []WindowsOsState {
	return []WindowsOsState{NonSysprepped, SysprepApplied, SysprepRequested}
}
