// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediapackagev2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateChannel = "CreateChannel"

// CreateChannelRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannel for more information on using the CreateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelRequest method.
//	req, resp := client.CreateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannel
func (c *MediaPackageV2) CreateChannelRequest(input *CreateChannelInput) (req *request.Request, output *CreateChannelOutput) {
	op := &request.Operation{
		Name:       opCreateChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel",
	}

	if input == nil {
		input = &CreateChannelInput{}
	}

	output = &CreateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannel API operation for AWS Elemental MediaPackage v2.
//
// Create a channel to start receiving content streams. The channel represents
// the input to MediaPackage for incoming live content from an encoder such
// as AWS Elemental MediaLive. The channel receives content, and after packaging
// it, outputs it through an origin endpoint to downstream devices (such as
// video players or CDNs) that request the content. You can create only one
// channel with each request. We recommend that you spread out channels between
// channel groups, such as putting redundant channels in the same AWS Region
// in different channel groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation CreateChannel for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannel
func (c *MediaPackageV2) CreateChannel(input *CreateChannelInput) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	return out, req.Send()
}

// CreateChannelWithContext is the same as CreateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) CreateChannelWithContext(ctx aws.Context, input *CreateChannelInput, opts ...request.Option) (*CreateChannelOutput, error) {
	req, out := c.CreateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateChannelGroup = "CreateChannelGroup"

// CreateChannelGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateChannelGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateChannelGroup for more information on using the CreateChannelGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateChannelGroupRequest method.
//	req, resp := client.CreateChannelGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannelGroup
func (c *MediaPackageV2) CreateChannelGroupRequest(input *CreateChannelGroupInput) (req *request.Request, output *CreateChannelGroupOutput) {
	op := &request.Operation{
		Name:       opCreateChannelGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/channelGroup",
	}

	if input == nil {
		input = &CreateChannelGroupInput{}
	}

	output = &CreateChannelGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateChannelGroup API operation for AWS Elemental MediaPackage v2.
//
// Create a channel group to group your channels and origin endpoints. A channel
// group is the top-level resource that consists of channels and origin endpoints
// that are associated with it and that provides predictable URLs for stream
// delivery. All channels and origin endpoints within the channel group are
// guaranteed to share the DNS. You can create only one channel group with each
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation CreateChannelGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateChannelGroup
func (c *MediaPackageV2) CreateChannelGroup(input *CreateChannelGroupInput) (*CreateChannelGroupOutput, error) {
	req, out := c.CreateChannelGroupRequest(input)
	return out, req.Send()
}

// CreateChannelGroupWithContext is the same as CreateChannelGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateChannelGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) CreateChannelGroupWithContext(ctx aws.Context, input *CreateChannelGroupInput, opts ...request.Option) (*CreateChannelGroupOutput, error) {
	req, out := c.CreateChannelGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOriginEndpoint = "CreateOriginEndpoint"

// CreateOriginEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateOriginEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOriginEndpoint for more information on using the CreateOriginEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateOriginEndpointRequest method.
//	req, resp := client.CreateOriginEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateOriginEndpoint
func (c *MediaPackageV2) CreateOriginEndpointRequest(input *CreateOriginEndpointInput) (req *request.Request, output *CreateOriginEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateOriginEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint",
	}

	if input == nil {
		input = &CreateOriginEndpointInput{}
	}

	output = &CreateOriginEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOriginEndpoint API operation for AWS Elemental MediaPackage v2.
//
// The endpoint is attached to a channel, and represents the output of the live
// content. You can associate multiple endpoints to a single channel. Each endpoint
// gives players and downstream CDNs (such as Amazon CloudFront) access to the
// content for playback. Content can't be served from a channel until it has
// an endpoint. You can create only one endpoint with each request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation CreateOriginEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/CreateOriginEndpoint
func (c *MediaPackageV2) CreateOriginEndpoint(input *CreateOriginEndpointInput) (*CreateOriginEndpointOutput, error) {
	req, out := c.CreateOriginEndpointRequest(input)
	return out, req.Send()
}

// CreateOriginEndpointWithContext is the same as CreateOriginEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOriginEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) CreateOriginEndpointWithContext(ctx aws.Context, input *CreateOriginEndpointInput, opts ...request.Option) (*CreateOriginEndpointOutput, error) {
	req, out := c.CreateOriginEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannel = "DeleteChannel"

// DeleteChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannel for more information on using the DeleteChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelRequest method.
//	req, resp := client.DeleteChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannel
func (c *MediaPackageV2) DeleteChannelRequest(input *DeleteChannelInput) (req *request.Request, output *DeleteChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/",
	}

	if input == nil {
		input = &DeleteChannelInput{}
	}

	output = &DeleteChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannel API operation for AWS Elemental MediaPackage v2.
//
// Delete a channel to stop AWS Elemental MediaPackage from receiving further
// content. You must delete the channel's origin endpoints before you can delete
// the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation DeleteChannel for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannel
func (c *MediaPackageV2) DeleteChannel(input *DeleteChannelInput) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	return out, req.Send()
}

// DeleteChannelWithContext is the same as DeleteChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) DeleteChannelWithContext(ctx aws.Context, input *DeleteChannelInput, opts ...request.Option) (*DeleteChannelOutput, error) {
	req, out := c.DeleteChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelGroup = "DeleteChannelGroup"

// DeleteChannelGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelGroup for more information on using the DeleteChannelGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelGroupRequest method.
//	req, resp := client.DeleteChannelGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelGroup
func (c *MediaPackageV2) DeleteChannelGroupRequest(input *DeleteChannelGroupInput) (req *request.Request, output *DeleteChannelGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channelGroup/{ChannelGroupName}",
	}

	if input == nil {
		input = &DeleteChannelGroupInput{}
	}

	output = &DeleteChannelGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelGroup API operation for AWS Elemental MediaPackage v2.
//
// Delete a channel group. You must delete the channel group's channels and
// origin endpoints before you can delete the channel group. If you delete a
// channel group, you'll lose access to the egress domain and will have to create
// a new channel group to replace it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation DeleteChannelGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelGroup
func (c *MediaPackageV2) DeleteChannelGroup(input *DeleteChannelGroupInput) (*DeleteChannelGroupOutput, error) {
	req, out := c.DeleteChannelGroupRequest(input)
	return out, req.Send()
}

// DeleteChannelGroupWithContext is the same as DeleteChannelGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) DeleteChannelGroupWithContext(ctx aws.Context, input *DeleteChannelGroupInput, opts ...request.Option) (*DeleteChannelGroupOutput, error) {
	req, out := c.DeleteChannelGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChannelPolicy = "DeleteChannelPolicy"

// DeleteChannelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChannelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteChannelPolicy for more information on using the DeleteChannelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteChannelPolicyRequest method.
//	req, resp := client.DeleteChannelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelPolicy
func (c *MediaPackageV2) DeleteChannelPolicyRequest(input *DeleteChannelPolicyInput) (req *request.Request, output *DeleteChannelPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteChannelPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/policy",
	}

	if input == nil {
		input = &DeleteChannelPolicyInput{}
	}

	output = &DeleteChannelPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteChannelPolicy API operation for AWS Elemental MediaPackage v2.
//
// Delete a channel policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation DeleteChannelPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteChannelPolicy
func (c *MediaPackageV2) DeleteChannelPolicy(input *DeleteChannelPolicyInput) (*DeleteChannelPolicyOutput, error) {
	req, out := c.DeleteChannelPolicyRequest(input)
	return out, req.Send()
}

// DeleteChannelPolicyWithContext is the same as DeleteChannelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChannelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) DeleteChannelPolicyWithContext(ctx aws.Context, input *DeleteChannelPolicyInput, opts ...request.Option) (*DeleteChannelPolicyOutput, error) {
	req, out := c.DeleteChannelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOriginEndpoint = "DeleteOriginEndpoint"

// DeleteOriginEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOriginEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOriginEndpoint for more information on using the DeleteOriginEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteOriginEndpointRequest method.
//	req, resp := client.DeleteOriginEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpoint
func (c *MediaPackageV2) DeleteOriginEndpointRequest(input *DeleteOriginEndpointInput) (req *request.Request, output *DeleteOriginEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteOriginEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}",
	}

	if input == nil {
		input = &DeleteOriginEndpointInput{}
	}

	output = &DeleteOriginEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOriginEndpoint API operation for AWS Elemental MediaPackage v2.
//
// Origin endpoints can serve content until they're deleted. Delete the endpoint
// if it should no longer respond to playback requests. You must delete all
// endpoints from a channel before you can delete the channel.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation DeleteOriginEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpoint
func (c *MediaPackageV2) DeleteOriginEndpoint(input *DeleteOriginEndpointInput) (*DeleteOriginEndpointOutput, error) {
	req, out := c.DeleteOriginEndpointRequest(input)
	return out, req.Send()
}

// DeleteOriginEndpointWithContext is the same as DeleteOriginEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOriginEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) DeleteOriginEndpointWithContext(ctx aws.Context, input *DeleteOriginEndpointInput, opts ...request.Option) (*DeleteOriginEndpointOutput, error) {
	req, out := c.DeleteOriginEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOriginEndpointPolicy = "DeleteOriginEndpointPolicy"

// DeleteOriginEndpointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOriginEndpointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOriginEndpointPolicy for more information on using the DeleteOriginEndpointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteOriginEndpointPolicyRequest method.
//	req, resp := client.DeleteOriginEndpointPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpointPolicy
func (c *MediaPackageV2) DeleteOriginEndpointPolicyRequest(input *DeleteOriginEndpointPolicyInput) (req *request.Request, output *DeleteOriginEndpointPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteOriginEndpointPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}/policy",
	}

	if input == nil {
		input = &DeleteOriginEndpointPolicyInput{}
	}

	output = &DeleteOriginEndpointPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOriginEndpointPolicy API operation for AWS Elemental MediaPackage v2.
//
// Delete an origin endpoint policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation DeleteOriginEndpointPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/DeleteOriginEndpointPolicy
func (c *MediaPackageV2) DeleteOriginEndpointPolicy(input *DeleteOriginEndpointPolicyInput) (*DeleteOriginEndpointPolicyOutput, error) {
	req, out := c.DeleteOriginEndpointPolicyRequest(input)
	return out, req.Send()
}

// DeleteOriginEndpointPolicyWithContext is the same as DeleteOriginEndpointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOriginEndpointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) DeleteOriginEndpointPolicyWithContext(ctx aws.Context, input *DeleteOriginEndpointPolicyInput, opts ...request.Option) (*DeleteOriginEndpointPolicyOutput, error) {
	req, out := c.DeleteOriginEndpointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannel = "GetChannel"

// GetChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannel for more information on using the GetChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelRequest method.
//	req, resp := client.GetChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannel
func (c *MediaPackageV2) GetChannelRequest(input *GetChannelInput) (req *request.Request, output *GetChannelOutput) {
	op := &request.Operation{
		Name:       opGetChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/",
	}

	if input == nil {
		input = &GetChannelInput{}
	}

	output = &GetChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannel API operation for AWS Elemental MediaPackage v2.
//
// Retrieves the specified channel that's configured in AWS Elemental MediaPackage,
// including the origin endpoints that are associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation GetChannel for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannel
func (c *MediaPackageV2) GetChannel(input *GetChannelInput) (*GetChannelOutput, error) {
	req, out := c.GetChannelRequest(input)
	return out, req.Send()
}

// GetChannelWithContext is the same as GetChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) GetChannelWithContext(ctx aws.Context, input *GetChannelInput, opts ...request.Option) (*GetChannelOutput, error) {
	req, out := c.GetChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelGroup = "GetChannelGroup"

// GetChannelGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelGroup for more information on using the GetChannelGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelGroupRequest method.
//	req, resp := client.GetChannelGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelGroup
func (c *MediaPackageV2) GetChannelGroupRequest(input *GetChannelGroupInput) (req *request.Request, output *GetChannelGroupOutput) {
	op := &request.Operation{
		Name:       opGetChannelGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/channelGroup/{ChannelGroupName}",
	}

	if input == nil {
		input = &GetChannelGroupInput{}
	}

	output = &GetChannelGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannelGroup API operation for AWS Elemental MediaPackage v2.
//
// Retrieves the specified channel group that's configured in AWS Elemental
// MediaPackage, including the channels and origin endpoints that are associated
// with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation GetChannelGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelGroup
func (c *MediaPackageV2) GetChannelGroup(input *GetChannelGroupInput) (*GetChannelGroupOutput, error) {
	req, out := c.GetChannelGroupRequest(input)
	return out, req.Send()
}

// GetChannelGroupWithContext is the same as GetChannelGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) GetChannelGroupWithContext(ctx aws.Context, input *GetChannelGroupInput, opts ...request.Option) (*GetChannelGroupOutput, error) {
	req, out := c.GetChannelGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChannelPolicy = "GetChannelPolicy"

// GetChannelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetChannelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChannelPolicy for more information on using the GetChannelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetChannelPolicyRequest method.
//	req, resp := client.GetChannelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelPolicy
func (c *MediaPackageV2) GetChannelPolicyRequest(input *GetChannelPolicyInput) (req *request.Request, output *GetChannelPolicyOutput) {
	op := &request.Operation{
		Name:       opGetChannelPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/policy",
	}

	if input == nil {
		input = &GetChannelPolicyInput{}
	}

	output = &GetChannelPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChannelPolicy API operation for AWS Elemental MediaPackage v2.
//
// Retrieves the specified channel policy that's configured in AWS Elemental
// MediaPackage. With policies, you can specify who has access to AWS resources
// and what actions they can perform on those resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation GetChannelPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetChannelPolicy
func (c *MediaPackageV2) GetChannelPolicy(input *GetChannelPolicyInput) (*GetChannelPolicyOutput, error) {
	req, out := c.GetChannelPolicyRequest(input)
	return out, req.Send()
}

// GetChannelPolicyWithContext is the same as GetChannelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetChannelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) GetChannelPolicyWithContext(ctx aws.Context, input *GetChannelPolicyInput, opts ...request.Option) (*GetChannelPolicyOutput, error) {
	req, out := c.GetChannelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOriginEndpoint = "GetOriginEndpoint"

// GetOriginEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetOriginEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOriginEndpoint for more information on using the GetOriginEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOriginEndpointRequest method.
//	req, resp := client.GetOriginEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpoint
func (c *MediaPackageV2) GetOriginEndpointRequest(input *GetOriginEndpointInput) (req *request.Request, output *GetOriginEndpointOutput) {
	op := &request.Operation{
		Name:       opGetOriginEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}",
	}

	if input == nil {
		input = &GetOriginEndpointInput{}
	}

	output = &GetOriginEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOriginEndpoint API operation for AWS Elemental MediaPackage v2.
//
// Retrieves the specified origin endpoint that's configured in AWS Elemental
// MediaPackage to obtain its playback URL and to view the packaging settings
// that it's currently using.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation GetOriginEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpoint
func (c *MediaPackageV2) GetOriginEndpoint(input *GetOriginEndpointInput) (*GetOriginEndpointOutput, error) {
	req, out := c.GetOriginEndpointRequest(input)
	return out, req.Send()
}

// GetOriginEndpointWithContext is the same as GetOriginEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetOriginEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) GetOriginEndpointWithContext(ctx aws.Context, input *GetOriginEndpointInput, opts ...request.Option) (*GetOriginEndpointOutput, error) {
	req, out := c.GetOriginEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOriginEndpointPolicy = "GetOriginEndpointPolicy"

// GetOriginEndpointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetOriginEndpointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOriginEndpointPolicy for more information on using the GetOriginEndpointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOriginEndpointPolicyRequest method.
//	req, resp := client.GetOriginEndpointPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpointPolicy
func (c *MediaPackageV2) GetOriginEndpointPolicyRequest(input *GetOriginEndpointPolicyInput) (req *request.Request, output *GetOriginEndpointPolicyOutput) {
	op := &request.Operation{
		Name:       opGetOriginEndpointPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}/policy",
	}

	if input == nil {
		input = &GetOriginEndpointPolicyInput{}
	}

	output = &GetOriginEndpointPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOriginEndpointPolicy API operation for AWS Elemental MediaPackage v2.
//
// Retrieves the specified origin endpoint policy that's configured in AWS Elemental
// MediaPackage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation GetOriginEndpointPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/GetOriginEndpointPolicy
func (c *MediaPackageV2) GetOriginEndpointPolicy(input *GetOriginEndpointPolicyInput) (*GetOriginEndpointPolicyOutput, error) {
	req, out := c.GetOriginEndpointPolicyRequest(input)
	return out, req.Send()
}

// GetOriginEndpointPolicyWithContext is the same as GetOriginEndpointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetOriginEndpointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) GetOriginEndpointPolicyWithContext(ctx aws.Context, input *GetOriginEndpointPolicyInput, opts ...request.Option) (*GetOriginEndpointPolicyOutput, error) {
	req, out := c.GetOriginEndpointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListChannelGroups = "ListChannelGroups"

// ListChannelGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannelGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannelGroups for more information on using the ListChannelGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelGroupsRequest method.
//	req, resp := client.ListChannelGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups
func (c *MediaPackageV2) ListChannelGroupsRequest(input *ListChannelGroupsInput) (req *request.Request, output *ListChannelGroupsOutput) {
	op := &request.Operation{
		Name:       opListChannelGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/channelGroup",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelGroupsInput{}
	}

	output = &ListChannelGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannelGroups API operation for AWS Elemental MediaPackage v2.
//
// Retrieves all channel groups that are configured in AWS Elemental MediaPackage,
// including the channels and origin endpoints that are associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation ListChannelGroups for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannelGroups
func (c *MediaPackageV2) ListChannelGroups(input *ListChannelGroupsInput) (*ListChannelGroupsOutput, error) {
	req, out := c.ListChannelGroupsRequest(input)
	return out, req.Send()
}

// ListChannelGroupsWithContext is the same as ListChannelGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannelGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) ListChannelGroupsWithContext(ctx aws.Context, input *ListChannelGroupsInput, opts ...request.Option) (*ListChannelGroupsOutput, error) {
	req, out := c.ListChannelGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelGroupsPages iterates over the pages of a ListChannelGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannelGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannelGroups operation.
//	pageNum := 0
//	err := client.ListChannelGroupsPages(params,
//	    func(page *mediapackagev2.ListChannelGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaPackageV2) ListChannelGroupsPages(input *ListChannelGroupsInput, fn func(*ListChannelGroupsOutput, bool) bool) error {
	return c.ListChannelGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelGroupsPagesWithContext same as ListChannelGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) ListChannelGroupsPagesWithContext(ctx aws.Context, input *ListChannelGroupsInput, fn func(*ListChannelGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListChannels = "ListChannels"

// ListChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListChannels for more information on using the ListChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListChannelsRequest method.
//	req, resp := client.ListChannelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels
func (c *MediaPackageV2) ListChannelsRequest(input *ListChannelsInput) (req *request.Request, output *ListChannelsOutput) {
	op := &request.Operation{
		Name:       opListChannels,
		HTTPMethod: "GET",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListChannelsInput{}
	}

	output = &ListChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListChannels API operation for AWS Elemental MediaPackage v2.
//
// Retrieves all channels in a specific channel group that are configured in
// AWS Elemental MediaPackage, including the origin endpoints that are associated
// with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation ListChannels for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListChannels
func (c *MediaPackageV2) ListChannels(input *ListChannelsInput) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	return out, req.Send()
}

// ListChannelsWithContext is the same as ListChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) ListChannelsWithContext(ctx aws.Context, input *ListChannelsInput, opts ...request.Option) (*ListChannelsOutput, error) {
	req, out := c.ListChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListChannelsPages iterates over the pages of a ListChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListChannels operation.
//	pageNum := 0
//	err := client.ListChannelsPages(params,
//	    func(page *mediapackagev2.ListChannelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaPackageV2) ListChannelsPages(input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool) error {
	return c.ListChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListChannelsPagesWithContext same as ListChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) ListChannelsPagesWithContext(ctx aws.Context, input *ListChannelsInput, fn func(*ListChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOriginEndpoints = "ListOriginEndpoints"

// ListOriginEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListOriginEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOriginEndpoints for more information on using the ListOriginEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOriginEndpointsRequest method.
//	req, resp := client.ListOriginEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints
func (c *MediaPackageV2) ListOriginEndpointsRequest(input *ListOriginEndpointsInput) (req *request.Request, output *ListOriginEndpointsOutput) {
	op := &request.Operation{
		Name:       opListOriginEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOriginEndpointsInput{}
	}

	output = &ListOriginEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOriginEndpoints API operation for AWS Elemental MediaPackage v2.
//
// Retrieves all origin endpoints in a specific channel that are configured
// in AWS Elemental MediaPackage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation ListOriginEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListOriginEndpoints
func (c *MediaPackageV2) ListOriginEndpoints(input *ListOriginEndpointsInput) (*ListOriginEndpointsOutput, error) {
	req, out := c.ListOriginEndpointsRequest(input)
	return out, req.Send()
}

// ListOriginEndpointsWithContext is the same as ListOriginEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListOriginEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) ListOriginEndpointsWithContext(ctx aws.Context, input *ListOriginEndpointsInput, opts ...request.Option) (*ListOriginEndpointsOutput, error) {
	req, out := c.ListOriginEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOriginEndpointsPages iterates over the pages of a ListOriginEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOriginEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOriginEndpoints operation.
//	pageNum := 0
//	err := client.ListOriginEndpointsPages(params,
//	    func(page *mediapackagev2.ListOriginEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *MediaPackageV2) ListOriginEndpointsPages(input *ListOriginEndpointsInput, fn func(*ListOriginEndpointsOutput, bool) bool) error {
	return c.ListOriginEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOriginEndpointsPagesWithContext same as ListOriginEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) ListOriginEndpointsPagesWithContext(ctx aws.Context, input *ListOriginEndpointsInput, fn func(*ListOriginEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOriginEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOriginEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOriginEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListTagsForResource
func (c *MediaPackageV2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Elemental MediaPackage v2.
//
// Lists the tags assigned to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/ListTagsForResource
func (c *MediaPackageV2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutChannelPolicy = "PutChannelPolicy"

// PutChannelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutChannelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutChannelPolicy for more information on using the PutChannelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutChannelPolicyRequest method.
//	req, resp := client.PutChannelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutChannelPolicy
func (c *MediaPackageV2) PutChannelPolicyRequest(input *PutChannelPolicyInput) (req *request.Request, output *PutChannelPolicyOutput) {
	op := &request.Operation{
		Name:       opPutChannelPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/policy",
	}

	if input == nil {
		input = &PutChannelPolicyInput{}
	}

	output = &PutChannelPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutChannelPolicy API operation for AWS Elemental MediaPackage v2.
//
// Attaches an IAM policy to the specified channel. With policies, you can specify
// who has access to AWS resources and what actions they can perform on those
// resources. You can attach only one policy with each request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation PutChannelPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutChannelPolicy
func (c *MediaPackageV2) PutChannelPolicy(input *PutChannelPolicyInput) (*PutChannelPolicyOutput, error) {
	req, out := c.PutChannelPolicyRequest(input)
	return out, req.Send()
}

// PutChannelPolicyWithContext is the same as PutChannelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutChannelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) PutChannelPolicyWithContext(ctx aws.Context, input *PutChannelPolicyInput, opts ...request.Option) (*PutChannelPolicyOutput, error) {
	req, out := c.PutChannelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOriginEndpointPolicy = "PutOriginEndpointPolicy"

// PutOriginEndpointPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutOriginEndpointPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOriginEndpointPolicy for more information on using the PutOriginEndpointPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutOriginEndpointPolicyRequest method.
//	req, resp := client.PutOriginEndpointPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutOriginEndpointPolicy
func (c *MediaPackageV2) PutOriginEndpointPolicyRequest(input *PutOriginEndpointPolicyInput) (req *request.Request, output *PutOriginEndpointPolicyOutput) {
	op := &request.Operation{
		Name:       opPutOriginEndpointPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}/policy",
	}

	if input == nil {
		input = &PutOriginEndpointPolicyInput{}
	}

	output = &PutOriginEndpointPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutOriginEndpointPolicy API operation for AWS Elemental MediaPackage v2.
//
// Attaches an IAM policy to the specified origin endpoint. You can attach only
// one policy with each request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation PutOriginEndpointPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/PutOriginEndpointPolicy
func (c *MediaPackageV2) PutOriginEndpointPolicy(input *PutOriginEndpointPolicyInput) (*PutOriginEndpointPolicyOutput, error) {
	req, out := c.PutOriginEndpointPolicyRequest(input)
	return out, req.Send()
}

// PutOriginEndpointPolicyWithContext is the same as PutOriginEndpointPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutOriginEndpointPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) PutOriginEndpointPolicyWithContext(ctx aws.Context, input *PutOriginEndpointPolicyInput, opts ...request.Option) (*PutOriginEndpointPolicyOutput, error) {
	req, out := c.PutOriginEndpointPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/TagResource
func (c *MediaPackageV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Elemental MediaPackage v2.
//
// Assigns one of more tags (key-value pairs) to the specified MediaPackage
// resource.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions, by granting a user permission to access or
// change only resources with certain tag values. You can use the TagResource
// operation with a resource that already has tags. If you specify a new tag
// key for the resource, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/TagResource
func (c *MediaPackageV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UntagResource
func (c *MediaPackageV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Elemental MediaPackage v2.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UntagResource
func (c *MediaPackageV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannel = "UpdateChannel"

// UpdateChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannel for more information on using the UpdateChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelRequest method.
//	req, resp := client.UpdateChannelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannel
func (c *MediaPackageV2) UpdateChannelRequest(input *UpdateChannelInput) (req *request.Request, output *UpdateChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/",
	}

	if input == nil {
		input = &UpdateChannelInput{}
	}

	output = &UpdateChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannel API operation for AWS Elemental MediaPackage v2.
//
// Update the specified channel. You can edit if MediaPackage sends ingest or
// egress access logs to the CloudWatch log group, if content will be encrypted,
// the description on a channel, and your channel's policy settings. You can't
// edit the name of the channel or CloudFront distribution details.
//
// Any edits you make that impact the video output may not be reflected for
// a few minutes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation UpdateChannel for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannel
func (c *MediaPackageV2) UpdateChannel(input *UpdateChannelInput) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	return out, req.Send()
}

// UpdateChannelWithContext is the same as UpdateChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) UpdateChannelWithContext(ctx aws.Context, input *UpdateChannelInput, opts ...request.Option) (*UpdateChannelOutput, error) {
	req, out := c.UpdateChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChannelGroup = "UpdateChannelGroup"

// UpdateChannelGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChannelGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateChannelGroup for more information on using the UpdateChannelGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateChannelGroupRequest method.
//	req, resp := client.UpdateChannelGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannelGroup
func (c *MediaPackageV2) UpdateChannelGroupRequest(input *UpdateChannelGroupInput) (req *request.Request, output *UpdateChannelGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateChannelGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/channelGroup/{ChannelGroupName}",
	}

	if input == nil {
		input = &UpdateChannelGroupInput{}
	}

	output = &UpdateChannelGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChannelGroup API operation for AWS Elemental MediaPackage v2.
//
// Update the specified channel group. You can edit the description on a channel
// group for easier identification later from the AWS Elemental MediaPackage
// console. You can't edit the name of the channel group.
//
// Any edits you make that impact the video output may not be reflected for
// a few minutes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation UpdateChannelGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateChannelGroup
func (c *MediaPackageV2) UpdateChannelGroup(input *UpdateChannelGroupInput) (*UpdateChannelGroupOutput, error) {
	req, out := c.UpdateChannelGroupRequest(input)
	return out, req.Send()
}

// UpdateChannelGroupWithContext is the same as UpdateChannelGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChannelGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) UpdateChannelGroupWithContext(ctx aws.Context, input *UpdateChannelGroupInput, opts ...request.Option) (*UpdateChannelGroupOutput, error) {
	req, out := c.UpdateChannelGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOriginEndpoint = "UpdateOriginEndpoint"

// UpdateOriginEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOriginEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOriginEndpoint for more information on using the UpdateOriginEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOriginEndpointRequest method.
//	req, resp := client.UpdateOriginEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateOriginEndpoint
func (c *MediaPackageV2) UpdateOriginEndpointRequest(input *UpdateOriginEndpointInput) (req *request.Request, output *UpdateOriginEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateOriginEndpoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/channelGroup/{ChannelGroupName}/channel/{ChannelName}/originEndpoint/{OriginEndpointName}",
	}

	if input == nil {
		input = &UpdateOriginEndpointInput{}
	}

	output = &UpdateOriginEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateOriginEndpoint API operation for AWS Elemental MediaPackage v2.
//
// Update the specified origin endpoint. Edit the packaging preferences on an
// endpoint to optimize the viewing experience. You can't edit the name of the
// endpoint.
//
// Any edits you make that impact the video output may not be reflected for
// a few minutes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Elemental MediaPackage v2's
// API operation UpdateOriginEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request throughput limit was exceeded.
//
//   - ConflictException
//     Updating or deleting this resource can cause an inconsistent state.
//
//   - InternalServerException
//     Indicates that an error from the service occurred while trying to process
//     a request.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The user or
//     role that is making the request must have at least one IAM permissions policy
//     attached that grants the required permissions. For more information, see
//     Access Management in the IAM User Guide.
//
//   - ValidationException
//     The input failed to meet the constraints specified by the AWS service.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediapackagev2-2022-12-25/UpdateOriginEndpoint
func (c *MediaPackageV2) UpdateOriginEndpoint(input *UpdateOriginEndpointInput) (*UpdateOriginEndpointOutput, error) {
	req, out := c.UpdateOriginEndpointRequest(input)
	return out, req.Send()
}

// UpdateOriginEndpointWithContext is the same as UpdateOriginEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOriginEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaPackageV2) UpdateOriginEndpointWithContext(ctx aws.Context, input *UpdateOriginEndpointInput, opts ...request.Option) (*UpdateOriginEndpointOutput, error) {
	req, out := c.UpdateOriginEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permissions to perform the requested operation. The user or
// role that is making the request must have at least one IAM permissions policy
// attached that grants the required permissions. For more information, see
// Access Management in the IAM User Guide.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration of the channel group.
type ChannelGroupListConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The date and time the channel group was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// Any descriptive information that you want to add to the channel group for
	// future identification purposes.
	Description *string `type:"string"`

	// The date and time the channel group was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelGroupListConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelGroupListConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChannelGroupListConfiguration) SetArn(v string) *ChannelGroupListConfiguration {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *ChannelGroupListConfiguration) SetChannelGroupName(v string) *ChannelGroupListConfiguration {
	s.ChannelGroupName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ChannelGroupListConfiguration) SetCreatedAt(v time.Time) *ChannelGroupListConfiguration {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ChannelGroupListConfiguration) SetDescription(v string) *ChannelGroupListConfiguration {
	s.Description = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *ChannelGroupListConfiguration) SetModifiedAt(v time.Time) *ChannelGroupListConfiguration {
	s.ModifiedAt = &v
	return s
}

// The configuration of the channel.
type ChannelListConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `type:"string" required:"true"`

	// The date and time the channel was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// Any descriptive information that you want to add to the channel for future
	// identification purposes.
	Description *string `type:"string"`

	// The date and time the channel was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelListConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelListConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ChannelListConfiguration) SetArn(v string) *ChannelListConfiguration {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *ChannelListConfiguration) SetChannelGroupName(v string) *ChannelListConfiguration {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *ChannelListConfiguration) SetChannelName(v string) *ChannelListConfiguration {
	s.ChannelName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ChannelListConfiguration) SetCreatedAt(v time.Time) *ChannelListConfiguration {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ChannelListConfiguration) SetDescription(v string) *ChannelListConfiguration {
	s.Description = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *ChannelListConfiguration) SetModifiedAt(v time.Time) *ChannelListConfiguration {
	s.ModifiedAt = &v
	return s
}

// Updating or deleting this resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The type of ConflictException.
	ConflictExceptionType *string `type:"string" enum:"ConflictExceptionType"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateChannelGroupInput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	// You can't use spaces in the name. You can't change the name after you create
	// the channel group.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `min:"1" type:"string" required:"true"`

	// A unique, case-sensitive token that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `location:"header" locationName:"x-amzn-client-token" min:"1" type:"string" idempotencyToken:"true"`

	// Enter any descriptive text that helps you to identify the channel group.
	Description *string `type:"string"`

	// A comma-separated list of tag key:value pairs that you define. For example:
	//
	// "Key1": "Value1",
	//
	// "Key2": "Value2"
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelGroupInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *CreateChannelGroupInput) SetChannelGroupName(v string) *CreateChannelGroupInput {
	s.ChannelGroupName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateChannelGroupInput) SetClientToken(v string) *CreateChannelGroupInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateChannelGroupInput) SetDescription(v string) *CreateChannelGroupInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelGroupInput) SetTags(v map[string]*string) *CreateChannelGroupInput {
	s.Tags = v
	return s
}

type CreateChannelGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The date and time the channel group was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description for your channel group.
	Description *string `type:"string"`

	// The output domain where the source stream should be sent. Integrate the egress
	// domain with a downstream CDN (such as Amazon CloudFront) or playback device.
	//
	// EgressDomain is a required field
	EgressDomain *string `type:"string" required:"true"`

	// The date and time the channel group was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The comma-separated list of tag key:value pairs assigned to the channel group.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateChannelGroupOutput) SetArn(v string) *CreateChannelGroupOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *CreateChannelGroupOutput) SetChannelGroupName(v string) *CreateChannelGroupOutput {
	s.ChannelGroupName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateChannelGroupOutput) SetCreatedAt(v time.Time) *CreateChannelGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateChannelGroupOutput) SetDescription(v string) *CreateChannelGroupOutput {
	s.Description = &v
	return s
}

// SetEgressDomain sets the EgressDomain field's value.
func (s *CreateChannelGroupOutput) SetEgressDomain(v string) *CreateChannelGroupOutput {
	s.EgressDomain = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateChannelGroupOutput) SetModifiedAt(v time.Time) *CreateChannelGroupOutput {
	s.ModifiedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelGroupOutput) SetTags(v map[string]*string) *CreateChannelGroupOutput {
	s.Tags = v
	return s
}

type CreateChannelInput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group. You can't change the name after you create the channel.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// A unique, case-sensitive token that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `location:"header" locationName:"x-amzn-client-token" min:"1" type:"string" idempotencyToken:"true"`

	// Enter any descriptive text that helps you to identify the channel.
	Description *string `type:"string"`

	// A comma-separated list of tag key:value pairs that you define. For example:
	//
	// "Key1": "Value1",
	//
	// "Key2": "Value2"
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateChannelInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *CreateChannelInput) SetChannelGroupName(v string) *CreateChannelInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateChannelInput) SetChannelName(v string) *CreateChannelInput {
	s.ChannelName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateChannelInput) SetClientToken(v string) *CreateChannelInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateChannelInput) SetDescription(v string) *CreateChannelInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelInput) SetTags(v map[string]*string) *CreateChannelInput {
	s.Tags = v
	return s
}

type CreateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `type:"string" required:"true"`

	// The date and time the channel was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description for your channel.
	Description *string `type:"string"`

	// The list of ingest endpoints.
	IngestEndpoints []*IngestEndpoint `type:"list"`

	// The date and time the channel was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The comma-separated list of tag key:value pairs assigned to the channel.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateChannelOutput) SetArn(v string) *CreateChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *CreateChannelOutput) SetChannelGroupName(v string) *CreateChannelOutput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateChannelOutput) SetChannelName(v string) *CreateChannelOutput {
	s.ChannelName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateChannelOutput) SetCreatedAt(v time.Time) *CreateChannelOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateChannelOutput) SetDescription(v string) *CreateChannelOutput {
	s.Description = &v
	return s
}

// SetIngestEndpoints sets the IngestEndpoints field's value.
func (s *CreateChannelOutput) SetIngestEndpoints(v []*IngestEndpoint) *CreateChannelOutput {
	s.IngestEndpoints = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateChannelOutput) SetModifiedAt(v time.Time) *CreateChannelOutput {
	s.ModifiedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateChannelOutput) SetTags(v map[string]*string) *CreateChannelOutput {
	s.Tags = v
	return s
}

// Create an HTTP live streaming (HLS) manifest configuration.
type CreateHlsManifestConfiguration struct {
	_ struct{} `type:"structure"`

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index, with an added suffix to distinguish
	// it from the manifest name. The manifestName on the HLSManifest object overrides
	// the manifestName you provided on the originEndpoint object.
	ChildManifestName *string `min:"1" type:"string"`

	// Filter configuration includes settings for manifest filtering, start and
	// end times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration `type:"structure"`

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts
	// the format extension, such as .m3u8. You can't use the same manifest name
	// if you use HLS manifest and low-latency HLS manifest. The manifestName on
	// the HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	//
	// ManifestName is a required field
	ManifestName *string `min:"1" type:"string" required:"true"`

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int64 `min:"30" type:"integer"`

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME
	// tags aren't included in the manifest. The tags sync the stream to the wall
	// clock so that viewers can seek to a specific time in the playback timeline
	// on the player. ID3Timed metadata messages generate every 5 seconds whenever
	// the content is ingested.
	//
	// Irrespective of this parameter, if any ID3Timed metadata is in the HLS input,
	// it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int64 `min:"1" type:"integer"`

	// The SCTE configuration.
	ScteHls *ScteHls `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHlsManifestConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHlsManifestConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHlsManifestConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHlsManifestConfiguration"}
	if s.ChildManifestName != nil && len(*s.ChildManifestName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChildManifestName", 1))
	}
	if s.ManifestName == nil {
		invalidParams.Add(request.NewErrParamRequired("ManifestName"))
	}
	if s.ManifestName != nil && len(*s.ManifestName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManifestName", 1))
	}
	if s.ManifestWindowSeconds != nil && *s.ManifestWindowSeconds < 30 {
		invalidParams.Add(request.NewErrParamMinValue("ManifestWindowSeconds", 30))
	}
	if s.ProgramDateTimeIntervalSeconds != nil && *s.ProgramDateTimeIntervalSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ProgramDateTimeIntervalSeconds", 1))
	}
	if s.FilterConfiguration != nil {
		if err := s.FilterConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FilterConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildManifestName sets the ChildManifestName field's value.
func (s *CreateHlsManifestConfiguration) SetChildManifestName(v string) *CreateHlsManifestConfiguration {
	s.ChildManifestName = &v
	return s
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *CreateHlsManifestConfiguration) SetFilterConfiguration(v *FilterConfiguration) *CreateHlsManifestConfiguration {
	s.FilterConfiguration = v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *CreateHlsManifestConfiguration) SetManifestName(v string) *CreateHlsManifestConfiguration {
	s.ManifestName = &v
	return s
}

// SetManifestWindowSeconds sets the ManifestWindowSeconds field's value.
func (s *CreateHlsManifestConfiguration) SetManifestWindowSeconds(v int64) *CreateHlsManifestConfiguration {
	s.ManifestWindowSeconds = &v
	return s
}

// SetProgramDateTimeIntervalSeconds sets the ProgramDateTimeIntervalSeconds field's value.
func (s *CreateHlsManifestConfiguration) SetProgramDateTimeIntervalSeconds(v int64) *CreateHlsManifestConfiguration {
	s.ProgramDateTimeIntervalSeconds = &v
	return s
}

// SetScteHls sets the ScteHls field's value.
func (s *CreateHlsManifestConfiguration) SetScteHls(v *ScteHls) *CreateHlsManifestConfiguration {
	s.ScteHls = v
	return s
}

// Create a low-latency HTTP live streaming (HLS) manifest configuration.
type CreateLowLatencyHlsManifestConfiguration struct {
	_ struct{} `type:"structure"`

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index, with an added suffix to distinguish
	// it from the manifest name. The manifestName on the HLSManifest object overrides
	// the manifestName you provided on the originEndpoint object.
	ChildManifestName *string `min:"1" type:"string"`

	// Filter configuration includes settings for manifest filtering, start and
	// end times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration `type:"structure"`

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts
	// the format extension, such as .m3u8. You can't use the same manifest name
	// if you use HLS manifest and low-latency HLS manifest. The manifestName on
	// the HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	//
	// ManifestName is a required field
	ManifestName *string `min:"1" type:"string" required:"true"`

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int64 `min:"30" type:"integer"`

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME
	// tags aren't included in the manifest. The tags sync the stream to the wall
	// clock so that viewers can seek to a specific time in the playback timeline
	// on the player. ID3Timed metadata messages generate every 5 seconds whenever
	// the content is ingested.
	//
	// Irrespective of this parameter, if any ID3Timed metadata is in the HLS input,
	// it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int64 `min:"1" type:"integer"`

	// The SCTE configuration.
	ScteHls *ScteHls `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLowLatencyHlsManifestConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLowLatencyHlsManifestConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLowLatencyHlsManifestConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLowLatencyHlsManifestConfiguration"}
	if s.ChildManifestName != nil && len(*s.ChildManifestName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChildManifestName", 1))
	}
	if s.ManifestName == nil {
		invalidParams.Add(request.NewErrParamRequired("ManifestName"))
	}
	if s.ManifestName != nil && len(*s.ManifestName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManifestName", 1))
	}
	if s.ManifestWindowSeconds != nil && *s.ManifestWindowSeconds < 30 {
		invalidParams.Add(request.NewErrParamMinValue("ManifestWindowSeconds", 30))
	}
	if s.ProgramDateTimeIntervalSeconds != nil && *s.ProgramDateTimeIntervalSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ProgramDateTimeIntervalSeconds", 1))
	}
	if s.FilterConfiguration != nil {
		if err := s.FilterConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FilterConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildManifestName sets the ChildManifestName field's value.
func (s *CreateLowLatencyHlsManifestConfiguration) SetChildManifestName(v string) *CreateLowLatencyHlsManifestConfiguration {
	s.ChildManifestName = &v
	return s
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *CreateLowLatencyHlsManifestConfiguration) SetFilterConfiguration(v *FilterConfiguration) *CreateLowLatencyHlsManifestConfiguration {
	s.FilterConfiguration = v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *CreateLowLatencyHlsManifestConfiguration) SetManifestName(v string) *CreateLowLatencyHlsManifestConfiguration {
	s.ManifestName = &v
	return s
}

// SetManifestWindowSeconds sets the ManifestWindowSeconds field's value.
func (s *CreateLowLatencyHlsManifestConfiguration) SetManifestWindowSeconds(v int64) *CreateLowLatencyHlsManifestConfiguration {
	s.ManifestWindowSeconds = &v
	return s
}

// SetProgramDateTimeIntervalSeconds sets the ProgramDateTimeIntervalSeconds field's value.
func (s *CreateLowLatencyHlsManifestConfiguration) SetProgramDateTimeIntervalSeconds(v int64) *CreateLowLatencyHlsManifestConfiguration {
	s.ProgramDateTimeIntervalSeconds = &v
	return s
}

// SetScteHls sets the ScteHls field's value.
func (s *CreateLowLatencyHlsManifestConfiguration) SetScteHls(v *ScteHls) *CreateLowLatencyHlsManifestConfiguration {
	s.ScteHls = v
	return s
}

type CreateOriginEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// A unique, case-sensitive token that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `location:"header" locationName:"x-amzn-client-token" min:"1" type:"string" idempotencyToken:"true"`

	// The type of container to attach to this origin endpoint. A container type
	// is a file format that encapsulates one or more media streams, such as audio
	// and video, into a single file. You can't change the container type after
	// you create the endpoint.
	//
	// ContainerType is a required field
	ContainerType *string `type:"string" required:"true" enum:"ContainerType"`

	// Enter any descriptive text that helps you to identify the origin endpoint.
	Description *string `type:"string"`

	// An HTTP live streaming (HLS) manifest configuration.
	HlsManifests []*CreateHlsManifestConfiguration `type:"list"`

	// A low-latency HLS manifest configuration.
	LowLatencyHlsManifests []*CreateLowLatencyHlsManifestConfiguration `type:"list"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and must be unique for your account in the AWS Region
	// and channel. You can't use spaces in the name. You can't change the name
	// after you create the endpoint.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `min:"1" type:"string" required:"true"`

	// The segment configuration, including the segment name, duration, and other
	// configuration values.
	Segment *Segment `type:"structure"`

	// The size of the window (in seconds) to create a window of the live stream
	// that's available for on-demand viewing. Viewers can start-over or catch-up
	// on content that falls within the window. The maximum startover window is
	// 1,209,600 seconds (14 days).
	StartoverWindowSeconds *int64 `min:"60" type:"integer"`

	// A comma-separated list of tag key:value pairs that you define. For example:
	//
	// "Key1": "Value1",
	//
	// "Key2": "Value2"
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOriginEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOriginEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOriginEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOriginEndpointInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ContainerType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerType"))
	}
	if s.OriginEndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginEndpointName"))
	}
	if s.OriginEndpointName != nil && len(*s.OriginEndpointName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginEndpointName", 1))
	}
	if s.StartoverWindowSeconds != nil && *s.StartoverWindowSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("StartoverWindowSeconds", 60))
	}
	if s.HlsManifests != nil {
		for i, v := range s.HlsManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HlsManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LowLatencyHlsManifests != nil {
		for i, v := range s.LowLatencyHlsManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LowLatencyHlsManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Segment != nil {
		if err := s.Segment.Validate(); err != nil {
			invalidParams.AddNested("Segment", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *CreateOriginEndpointInput) SetChannelGroupName(v string) *CreateOriginEndpointInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateOriginEndpointInput) SetChannelName(v string) *CreateOriginEndpointInput {
	s.ChannelName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateOriginEndpointInput) SetClientToken(v string) *CreateOriginEndpointInput {
	s.ClientToken = &v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *CreateOriginEndpointInput) SetContainerType(v string) *CreateOriginEndpointInput {
	s.ContainerType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateOriginEndpointInput) SetDescription(v string) *CreateOriginEndpointInput {
	s.Description = &v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *CreateOriginEndpointInput) SetHlsManifests(v []*CreateHlsManifestConfiguration) *CreateOriginEndpointInput {
	s.HlsManifests = v
	return s
}

// SetLowLatencyHlsManifests sets the LowLatencyHlsManifests field's value.
func (s *CreateOriginEndpointInput) SetLowLatencyHlsManifests(v []*CreateLowLatencyHlsManifestConfiguration) *CreateOriginEndpointInput {
	s.LowLatencyHlsManifests = v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *CreateOriginEndpointInput) SetOriginEndpointName(v string) *CreateOriginEndpointInput {
	s.OriginEndpointName = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *CreateOriginEndpointInput) SetSegment(v *Segment) *CreateOriginEndpointInput {
	s.Segment = v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *CreateOriginEndpointInput) SetStartoverWindowSeconds(v int64) *CreateOriginEndpointInput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOriginEndpointInput) SetTags(v map[string]*string) *CreateOriginEndpointInput {
	s.Tags = v
	return s
}

type CreateOriginEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// The type of container attached to this origin endpoint.
	//
	// ContainerType is a required field
	ContainerType *string `type:"string" required:"true" enum:"ContainerType"`

	// The date and time the origin endpoint was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description for your origin endpoint.
	Description *string `type:"string"`

	// An HTTP live streaming (HLS) manifest configuration.
	HlsManifests []*GetHlsManifestConfiguration `type:"list"`

	// A low-latency HLS manifest configuration.
	LowLatencyHlsManifests []*GetLowLatencyHlsManifestConfiguration `type:"list"`

	// The date and time the origin endpoint was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `min:"1" type:"string" required:"true"`

	// The segment configuration, including the segment name, duration, and other
	// configuration values.
	//
	// Segment is a required field
	Segment *Segment `type:"structure" required:"true"`

	// The size of the window (in seconds) to create a window of the live stream
	// that's available for on-demand viewing. Viewers can start-over or catch-up
	// on content that falls within the window.
	StartoverWindowSeconds *int64 `type:"integer"`

	// The comma-separated list of tag key:value pairs assigned to the origin endpoint.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOriginEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOriginEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateOriginEndpointOutput) SetArn(v string) *CreateOriginEndpointOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *CreateOriginEndpointOutput) SetChannelGroupName(v string) *CreateOriginEndpointOutput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *CreateOriginEndpointOutput) SetChannelName(v string) *CreateOriginEndpointOutput {
	s.ChannelName = &v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *CreateOriginEndpointOutput) SetContainerType(v string) *CreateOriginEndpointOutput {
	s.ContainerType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateOriginEndpointOutput) SetCreatedAt(v time.Time) *CreateOriginEndpointOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateOriginEndpointOutput) SetDescription(v string) *CreateOriginEndpointOutput {
	s.Description = &v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *CreateOriginEndpointOutput) SetHlsManifests(v []*GetHlsManifestConfiguration) *CreateOriginEndpointOutput {
	s.HlsManifests = v
	return s
}

// SetLowLatencyHlsManifests sets the LowLatencyHlsManifests field's value.
func (s *CreateOriginEndpointOutput) SetLowLatencyHlsManifests(v []*GetLowLatencyHlsManifestConfiguration) *CreateOriginEndpointOutput {
	s.LowLatencyHlsManifests = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateOriginEndpointOutput) SetModifiedAt(v time.Time) *CreateOriginEndpointOutput {
	s.ModifiedAt = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *CreateOriginEndpointOutput) SetOriginEndpointName(v string) *CreateOriginEndpointOutput {
	s.OriginEndpointName = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *CreateOriginEndpointOutput) SetSegment(v *Segment) *CreateOriginEndpointOutput {
	s.Segment = v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *CreateOriginEndpointOutput) SetStartoverWindowSeconds(v int64) *CreateOriginEndpointOutput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOriginEndpointOutput) SetTags(v map[string]*string) *CreateOriginEndpointOutput {
	s.Tags = v
	return s
}

type DeleteChannelGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelGroupInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *DeleteChannelGroupInput) SetChannelGroupName(v string) *DeleteChannelGroupInput {
	s.ChannelGroupName = &v
	return s
}

type DeleteChannelGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelGroupOutput) GoString() string {
	return s.String()
}

type DeleteChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *DeleteChannelInput) SetChannelGroupName(v string) *DeleteChannelInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *DeleteChannelInput) SetChannelName(v string) *DeleteChannelInput {
	s.ChannelName = &v
	return s
}

type DeleteChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelOutput) GoString() string {
	return s.String()
}

type DeleteChannelPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChannelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChannelPolicyInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *DeleteChannelPolicyInput) SetChannelGroupName(v string) *DeleteChannelPolicyInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *DeleteChannelPolicyInput) SetChannelName(v string) *DeleteChannelPolicyInput {
	s.ChannelName = &v
	return s
}

type DeleteChannelPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteChannelPolicyOutput) GoString() string {
	return s.String()
}

type DeleteOriginEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `location:"uri" locationName:"OriginEndpointName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOriginEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOriginEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOriginEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOriginEndpointInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.OriginEndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginEndpointName"))
	}
	if s.OriginEndpointName != nil && len(*s.OriginEndpointName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginEndpointName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *DeleteOriginEndpointInput) SetChannelGroupName(v string) *DeleteOriginEndpointInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *DeleteOriginEndpointInput) SetChannelName(v string) *DeleteOriginEndpointInput {
	s.ChannelName = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *DeleteOriginEndpointInput) SetOriginEndpointName(v string) *DeleteOriginEndpointInput {
	s.OriginEndpointName = &v
	return s
}

type DeleteOriginEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOriginEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOriginEndpointOutput) GoString() string {
	return s.String()
}

type DeleteOriginEndpointPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `location:"uri" locationName:"OriginEndpointName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOriginEndpointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOriginEndpointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOriginEndpointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOriginEndpointPolicyInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.OriginEndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginEndpointName"))
	}
	if s.OriginEndpointName != nil && len(*s.OriginEndpointName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginEndpointName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *DeleteOriginEndpointPolicyInput) SetChannelGroupName(v string) *DeleteOriginEndpointPolicyInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *DeleteOriginEndpointPolicyInput) SetChannelName(v string) *DeleteOriginEndpointPolicyInput {
	s.ChannelName = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *DeleteOriginEndpointPolicyInput) SetOriginEndpointName(v string) *DeleteOriginEndpointPolicyInput {
	s.OriginEndpointName = &v
	return s
}

type DeleteOriginEndpointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOriginEndpointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOriginEndpointPolicyOutput) GoString() string {
	return s.String()
}

// The parameters for encrypting content.
type Encryption struct {
	_ struct{} `type:"structure"`

	// A 128-bit, 16-byte hex value represented by a 32-character string, used in
	// conjunction with the key for encrypting content. If you don't specify a value,
	// then MediaPackage creates the constant initialization vector (IV).
	ConstantInitializationVector *string `min:"32" type:"string"`

	// The encryption method to use.
	//
	// EncryptionMethod is a required field
	EncryptionMethod *EncryptionMethod `type:"structure" required:"true"`

	// The frequency (in seconds) of key changes for live workflows, in which content
	// is streamed real time. The service retrieves content keys before the live
	// content begins streaming, and then retrieves them as needed over the lifetime
	// of the workflow. By default, key rotation is set to 300 seconds (5 minutes),
	// the minimum rotation interval, which is equivalent to setting it to 300.
	// If you don't enter an interval, content keys aren't rotated.
	//
	// The following example setting causes the service to rotate keys every thirty
	// minutes: 1800
	KeyRotationIntervalSeconds *int64 `min:"300" type:"integer"`

	// The parameters for the SPEKE key provider.
	//
	// SpekeKeyProvider is a required field
	SpekeKeyProvider *SpekeKeyProvider `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Encryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Encryption"}
	if s.ConstantInitializationVector != nil && len(*s.ConstantInitializationVector) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ConstantInitializationVector", 32))
	}
	if s.EncryptionMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionMethod"))
	}
	if s.KeyRotationIntervalSeconds != nil && *s.KeyRotationIntervalSeconds < 300 {
		invalidParams.Add(request.NewErrParamMinValue("KeyRotationIntervalSeconds", 300))
	}
	if s.SpekeKeyProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("SpekeKeyProvider"))
	}
	if s.SpekeKeyProvider != nil {
		if err := s.SpekeKeyProvider.Validate(); err != nil {
			invalidParams.AddNested("SpekeKeyProvider", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConstantInitializationVector sets the ConstantInitializationVector field's value.
func (s *Encryption) SetConstantInitializationVector(v string) *Encryption {
	s.ConstantInitializationVector = &v
	return s
}

// SetEncryptionMethod sets the EncryptionMethod field's value.
func (s *Encryption) SetEncryptionMethod(v *EncryptionMethod) *Encryption {
	s.EncryptionMethod = v
	return s
}

// SetKeyRotationIntervalSeconds sets the KeyRotationIntervalSeconds field's value.
func (s *Encryption) SetKeyRotationIntervalSeconds(v int64) *Encryption {
	s.KeyRotationIntervalSeconds = &v
	return s
}

// SetSpekeKeyProvider sets the SpekeKeyProvider field's value.
func (s *Encryption) SetSpekeKeyProvider(v *SpekeKeyProvider) *Encryption {
	s.SpekeKeyProvider = v
	return s
}

// Configure one or more content encryption keys for your endpoints that use
// SPEKE Version 2.0. The encryption contract defines which content keys are
// used to encrypt the audio and video tracks in your stream. To configure the
// encryption contract, specify which audio and video encryption presets to
// use.
type EncryptionContractConfiguration struct {
	_ struct{} `type:"structure"`

	// A collection of audio encryption presets.
	//
	// Value description:
	//
	//    * PRESET-AUDIO-1 - Use one content key to encrypt all of the audio tracks
	//    in your stream.
	//
	//    * PRESET-AUDIO-2 - Use one content key to encrypt all of the stereo audio
	//    tracks and one content key to encrypt all of the multichannel audio tracks.
	//
	//    * PRESET-AUDIO-3 - Use one content key to encrypt all of the stereo audio
	//    tracks, one content key to encrypt all of the multichannel audio tracks
	//    with 3 to 6 channels, and one content key to encrypt all of the multichannel
	//    audio tracks with more than 6 channels.
	//
	//    * SHARED - Use the same content key for all of the audio and video tracks
	//    in your stream.
	//
	//    * UNENCRYPTED - Don't encrypt any of the audio tracks in your stream.
	//
	// PresetSpeke20Audio is a required field
	PresetSpeke20Audio *string `type:"string" required:"true" enum:"PresetSpeke20Audio"`

	// A collection of video encryption presets.
	//
	// Value description:
	//
	//    * PRESET-VIDEO-1 - Use one content key to encrypt all of the video tracks
	//    in your stream.
	//
	//    * PRESET-VIDEO-2 - Use one content key to encrypt all of the SD video
	//    tracks and one content key for all HD and higher resolutions video tracks.
	//
	//    * PRESET-VIDEO-3 - Use one content key to encrypt all of the SD video
	//    tracks, one content key for HD video tracks and one content key for all
	//    UHD video tracks.
	//
	//    * PRESET-VIDEO-4 - Use one content key to encrypt all of the SD video
	//    tracks, one content key for HD video tracks, one content key for all UHD1
	//    video tracks and one content key for all UHD2 video tracks.
	//
	//    * PRESET-VIDEO-5 - Use one content key to encrypt all of the SD video
	//    tracks, one content key for HD1 video tracks, one content key for HD2
	//    video tracks, one content key for all UHD1 video tracks and one content
	//    key for all UHD2 video tracks.
	//
	//    * PRESET-VIDEO-6 - Use one content key to encrypt all of the SD video
	//    tracks, one content key for HD1 video tracks, one content key for HD2
	//    video tracks and one content key for all UHD video tracks.
	//
	//    * PRESET-VIDEO-7 - Use one content key to encrypt all of the SD+HD1 video
	//    tracks, one content key for HD2 video tracks and one content key for all
	//    UHD video tracks.
	//
	//    * PRESET-VIDEO-8 - Use one content key to encrypt all of the SD+HD1 video
	//    tracks, one content key for HD2 video tracks, one content key for all
	//    UHD1 video tracks and one content key for all UHD2 video tracks.
	//
	//    * SHARED - Use the same content key for all of the video and audio tracks
	//    in your stream.
	//
	//    * UNENCRYPTED - Don't encrypt any of the video tracks in your stream.
	//
	// PresetSpeke20Video is a required field
	PresetSpeke20Video *string `type:"string" required:"true" enum:"PresetSpeke20Video"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionContractConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionContractConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionContractConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionContractConfiguration"}
	if s.PresetSpeke20Audio == nil {
		invalidParams.Add(request.NewErrParamRequired("PresetSpeke20Audio"))
	}
	if s.PresetSpeke20Video == nil {
		invalidParams.Add(request.NewErrParamRequired("PresetSpeke20Video"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPresetSpeke20Audio sets the PresetSpeke20Audio field's value.
func (s *EncryptionContractConfiguration) SetPresetSpeke20Audio(v string) *EncryptionContractConfiguration {
	s.PresetSpeke20Audio = &v
	return s
}

// SetPresetSpeke20Video sets the PresetSpeke20Video field's value.
func (s *EncryptionContractConfiguration) SetPresetSpeke20Video(v string) *EncryptionContractConfiguration {
	s.PresetSpeke20Video = &v
	return s
}

// The encryption type.
type EncryptionMethod struct {
	_ struct{} `type:"structure"`

	// The encryption method to use.
	CmafEncryptionMethod *string `type:"string" enum:"CmafEncryptionMethod"`

	// The encryption method to use.
	TsEncryptionMethod *string `type:"string" enum:"TsEncryptionMethod"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionMethod) GoString() string {
	return s.String()
}

// SetCmafEncryptionMethod sets the CmafEncryptionMethod field's value.
func (s *EncryptionMethod) SetCmafEncryptionMethod(v string) *EncryptionMethod {
	s.CmafEncryptionMethod = &v
	return s
}

// SetTsEncryptionMethod sets the TsEncryptionMethod field's value.
func (s *EncryptionMethod) SetTsEncryptionMethod(v string) *EncryptionMethod {
	s.TsEncryptionMethod = &v
	return s
}

// Filter configuration includes settings for manifest filtering, start and
// end times, and time delay that apply to all of your egress requests for this
// manifest.
type FilterConfiguration struct {
	_ struct{} `type:"structure"`

	// Optionally specify the end time for all of your manifest egress requests.
	// When you include end time, note that you cannot use end time query parameters
	// for this manifest's endpoint URL.
	End *time.Time `type:"timestamp"`

	// Optionally specify one or more manifest filters for all of your manifest
	// egress requests. When you include a manifest filter, note that you cannot
	// use an identical manifest filter query parameter for this manifest's endpoint
	// URL.
	ManifestFilter *string `min:"1" type:"string"`

	// Optionally specify the start time for all of your manifest egress requests.
	// When you include start time, note that you cannot use start time query parameters
	// for this manifest's endpoint URL.
	Start *time.Time `type:"timestamp"`

	// Optionally specify the time delay for all of your manifest egress requests.
	// Enter a value that is smaller than your endpoint's startover window. When
	// you include time delay, note that you cannot use time delay query parameters
	// for this manifest's endpoint URL.
	TimeDelaySeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FilterConfiguration"}
	if s.ManifestFilter != nil && len(*s.ManifestFilter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ManifestFilter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnd sets the End field's value.
func (s *FilterConfiguration) SetEnd(v time.Time) *FilterConfiguration {
	s.End = &v
	return s
}

// SetManifestFilter sets the ManifestFilter field's value.
func (s *FilterConfiguration) SetManifestFilter(v string) *FilterConfiguration {
	s.ManifestFilter = &v
	return s
}

// SetStart sets the Start field's value.
func (s *FilterConfiguration) SetStart(v time.Time) *FilterConfiguration {
	s.Start = &v
	return s
}

// SetTimeDelaySeconds sets the TimeDelaySeconds field's value.
func (s *FilterConfiguration) SetTimeDelaySeconds(v int64) *FilterConfiguration {
	s.TimeDelaySeconds = &v
	return s
}

type GetChannelGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelGroupInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetChannelGroupInput) SetChannelGroupName(v string) *GetChannelGroupInput {
	s.ChannelGroupName = &v
	return s
}

type GetChannelGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The date and time the channel group was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description for your channel group.
	Description *string `type:"string"`

	// The output domain where the source stream should be sent. Integrate the domain
	// with a downstream CDN (such as Amazon CloudFront) or playback device.
	//
	// EgressDomain is a required field
	EgressDomain *string `type:"string" required:"true"`

	// The date and time the channel group was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The comma-separated list of tag key:value pairs assigned to the channel group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetChannelGroupOutput) SetArn(v string) *GetChannelGroupOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetChannelGroupOutput) SetChannelGroupName(v string) *GetChannelGroupOutput {
	s.ChannelGroupName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetChannelGroupOutput) SetCreatedAt(v time.Time) *GetChannelGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetChannelGroupOutput) SetDescription(v string) *GetChannelGroupOutput {
	s.Description = &v
	return s
}

// SetEgressDomain sets the EgressDomain field's value.
func (s *GetChannelGroupOutput) SetEgressDomain(v string) *GetChannelGroupOutput {
	s.EgressDomain = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetChannelGroupOutput) SetModifiedAt(v time.Time) *GetChannelGroupOutput {
	s.ModifiedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetChannelGroupOutput) SetTags(v map[string]*string) *GetChannelGroupOutput {
	s.Tags = v
	return s
}

type GetChannelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetChannelInput) SetChannelGroupName(v string) *GetChannelInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *GetChannelInput) SetChannelName(v string) *GetChannelInput {
	s.ChannelName = &v
	return s
}

type GetChannelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `type:"string" required:"true"`

	// The date and time the channel was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description for your channel.
	Description *string `type:"string"`

	// The list of ingest endpoints.
	IngestEndpoints []*IngestEndpoint `type:"list"`

	// The date and time the channel was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The comma-separated list of tag key:value pairs assigned to the channel.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetChannelOutput) SetArn(v string) *GetChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetChannelOutput) SetChannelGroupName(v string) *GetChannelOutput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *GetChannelOutput) SetChannelName(v string) *GetChannelOutput {
	s.ChannelName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetChannelOutput) SetCreatedAt(v time.Time) *GetChannelOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetChannelOutput) SetDescription(v string) *GetChannelOutput {
	s.Description = &v
	return s
}

// SetIngestEndpoints sets the IngestEndpoints field's value.
func (s *GetChannelOutput) SetIngestEndpoints(v []*IngestEndpoint) *GetChannelOutput {
	s.IngestEndpoints = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetChannelOutput) SetModifiedAt(v time.Time) *GetChannelOutput {
	s.ModifiedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetChannelOutput) SetTags(v map[string]*string) *GetChannelOutput {
	s.Tags = v
	return s
}

type GetChannelPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChannelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChannelPolicyInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetChannelPolicyInput) SetChannelGroupName(v string) *GetChannelPolicyInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *GetChannelPolicyInput) SetChannelName(v string) *GetChannelPolicyInput {
	s.ChannelName = &v
	return s
}

type GetChannelPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `type:"string" required:"true"`

	// The policy assigned to the channel.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetChannelPolicyOutput) GoString() string {
	return s.String()
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetChannelPolicyOutput) SetChannelGroupName(v string) *GetChannelPolicyOutput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *GetChannelPolicyOutput) SetChannelName(v string) *GetChannelPolicyOutput {
	s.ChannelName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetChannelPolicyOutput) SetPolicy(v string) *GetChannelPolicyOutput {
	s.Policy = &v
	return s
}

// Retrieve the HTTP live streaming (HLS) manifest configuration.
type GetHlsManifestConfiguration struct {
	_ struct{} `type:"structure"`

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	ChildManifestName *string `min:"1" type:"string"`

	// Filter configuration includes settings for manifest filtering, start and
	// end times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration `type:"structure"`

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts
	// the format extension, such as .m3u8. You can't use the same manifest name
	// if you use HLS manifest and low-latency HLS manifest. The manifestName on
	// the HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	//
	// ManifestName is a required field
	ManifestName *string `min:"1" type:"string" required:"true"`

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int64 `type:"integer"`

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME
	// tags aren't included in the manifest. The tags sync the stream to the wall
	// clock so that viewers can seek to a specific time in the playback timeline
	// on the player. ID3Timed metadata messages generate every 5 seconds whenever
	// the content is ingested.
	//
	// Irrespective of this parameter, if any ID3Timed metadata is in the HLS input,
	// it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int64 `type:"integer"`

	// The SCTE configuration.
	ScteHls *ScteHls `type:"structure"`

	// The egress domain URL for stream delivery from MediaPackage.
	//
	// Url is a required field
	Url *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHlsManifestConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetHlsManifestConfiguration) GoString() string {
	return s.String()
}

// SetChildManifestName sets the ChildManifestName field's value.
func (s *GetHlsManifestConfiguration) SetChildManifestName(v string) *GetHlsManifestConfiguration {
	s.ChildManifestName = &v
	return s
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *GetHlsManifestConfiguration) SetFilterConfiguration(v *FilterConfiguration) *GetHlsManifestConfiguration {
	s.FilterConfiguration = v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *GetHlsManifestConfiguration) SetManifestName(v string) *GetHlsManifestConfiguration {
	s.ManifestName = &v
	return s
}

// SetManifestWindowSeconds sets the ManifestWindowSeconds field's value.
func (s *GetHlsManifestConfiguration) SetManifestWindowSeconds(v int64) *GetHlsManifestConfiguration {
	s.ManifestWindowSeconds = &v
	return s
}

// SetProgramDateTimeIntervalSeconds sets the ProgramDateTimeIntervalSeconds field's value.
func (s *GetHlsManifestConfiguration) SetProgramDateTimeIntervalSeconds(v int64) *GetHlsManifestConfiguration {
	s.ProgramDateTimeIntervalSeconds = &v
	return s
}

// SetScteHls sets the ScteHls field's value.
func (s *GetHlsManifestConfiguration) SetScteHls(v *ScteHls) *GetHlsManifestConfiguration {
	s.ScteHls = v
	return s
}

// SetUrl sets the Url field's value.
func (s *GetHlsManifestConfiguration) SetUrl(v string) *GetHlsManifestConfiguration {
	s.Url = &v
	return s
}

// Retrieve the low-latency HTTP live streaming (HLS) manifest configuration.
type GetLowLatencyHlsManifestConfiguration struct {
	_ struct{} `type:"structure"`

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	ChildManifestName *string `min:"1" type:"string"`

	// Filter configuration includes settings for manifest filtering, start and
	// end times, and time delay that apply to all of your egress requests for this
	// manifest.
	FilterConfiguration *FilterConfiguration `type:"structure"`

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts
	// the format extension, such as .m3u8. You can't use the same manifest name
	// if you use HLS manifest and low-latency HLS manifest. The manifestName on
	// the HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	//
	// ManifestName is a required field
	ManifestName *string `min:"1" type:"string" required:"true"`

	// The total duration (in seconds) of the manifest's content.
	ManifestWindowSeconds *int64 `type:"integer"`

	// Inserts EXT-X-PROGRAM-DATE-TIME tags in the output manifest at the interval
	// that you specify. If you don't enter an interval, EXT-X-PROGRAM-DATE-TIME
	// tags aren't included in the manifest. The tags sync the stream to the wall
	// clock so that viewers can seek to a specific time in the playback timeline
	// on the player. ID3Timed metadata messages generate every 5 seconds whenever
	// the content is ingested.
	//
	// Irrespective of this parameter, if any ID3Timed metadata is in the HLS input,
	// it is passed through to the HLS output.
	ProgramDateTimeIntervalSeconds *int64 `type:"integer"`

	// The SCTE configuration.
	ScteHls *ScteHls `type:"structure"`

	// The egress domain URL for stream delivery from MediaPackage.
	//
	// Url is a required field
	Url *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLowLatencyHlsManifestConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLowLatencyHlsManifestConfiguration) GoString() string {
	return s.String()
}

// SetChildManifestName sets the ChildManifestName field's value.
func (s *GetLowLatencyHlsManifestConfiguration) SetChildManifestName(v string) *GetLowLatencyHlsManifestConfiguration {
	s.ChildManifestName = &v
	return s
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *GetLowLatencyHlsManifestConfiguration) SetFilterConfiguration(v *FilterConfiguration) *GetLowLatencyHlsManifestConfiguration {
	s.FilterConfiguration = v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *GetLowLatencyHlsManifestConfiguration) SetManifestName(v string) *GetLowLatencyHlsManifestConfiguration {
	s.ManifestName = &v
	return s
}

// SetManifestWindowSeconds sets the ManifestWindowSeconds field's value.
func (s *GetLowLatencyHlsManifestConfiguration) SetManifestWindowSeconds(v int64) *GetLowLatencyHlsManifestConfiguration {
	s.ManifestWindowSeconds = &v
	return s
}

// SetProgramDateTimeIntervalSeconds sets the ProgramDateTimeIntervalSeconds field's value.
func (s *GetLowLatencyHlsManifestConfiguration) SetProgramDateTimeIntervalSeconds(v int64) *GetLowLatencyHlsManifestConfiguration {
	s.ProgramDateTimeIntervalSeconds = &v
	return s
}

// SetScteHls sets the ScteHls field's value.
func (s *GetLowLatencyHlsManifestConfiguration) SetScteHls(v *ScteHls) *GetLowLatencyHlsManifestConfiguration {
	s.ScteHls = v
	return s
}

// SetUrl sets the Url field's value.
func (s *GetLowLatencyHlsManifestConfiguration) SetUrl(v string) *GetLowLatencyHlsManifestConfiguration {
	s.Url = &v
	return s
}

type GetOriginEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `location:"uri" locationName:"OriginEndpointName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOriginEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOriginEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOriginEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOriginEndpointInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.OriginEndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginEndpointName"))
	}
	if s.OriginEndpointName != nil && len(*s.OriginEndpointName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginEndpointName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetOriginEndpointInput) SetChannelGroupName(v string) *GetOriginEndpointInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *GetOriginEndpointInput) SetChannelName(v string) *GetOriginEndpointInput {
	s.ChannelName = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *GetOriginEndpointInput) SetOriginEndpointName(v string) *GetOriginEndpointInput {
	s.OriginEndpointName = &v
	return s
}

type GetOriginEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// The type of container attached to this origin endpoint.
	//
	// ContainerType is a required field
	ContainerType *string `type:"string" required:"true" enum:"ContainerType"`

	// The date and time the origin endpoint was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description for your origin endpoint.
	Description *string `type:"string"`

	// An HTTP live streaming (HLS) manifest configuration.
	HlsManifests []*GetHlsManifestConfiguration `type:"list"`

	// A low-latency HLS manifest configuration.
	LowLatencyHlsManifests []*GetLowLatencyHlsManifestConfiguration `type:"list"`

	// The date and time the origin endpoint was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `min:"1" type:"string" required:"true"`

	// The segment configuration, including the segment name, duration, and other
	// configuration values.
	//
	// Segment is a required field
	Segment *Segment `type:"structure" required:"true"`

	// The size of the window (in seconds) to create a window of the live stream
	// that's available for on-demand viewing. Viewers can start-over or catch-up
	// on content that falls within the window.
	StartoverWindowSeconds *int64 `type:"integer"`

	// The comma-separated list of tag key:value pairs assigned to the origin endpoint.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOriginEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOriginEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetOriginEndpointOutput) SetArn(v string) *GetOriginEndpointOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetOriginEndpointOutput) SetChannelGroupName(v string) *GetOriginEndpointOutput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *GetOriginEndpointOutput) SetChannelName(v string) *GetOriginEndpointOutput {
	s.ChannelName = &v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *GetOriginEndpointOutput) SetContainerType(v string) *GetOriginEndpointOutput {
	s.ContainerType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetOriginEndpointOutput) SetCreatedAt(v time.Time) *GetOriginEndpointOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetOriginEndpointOutput) SetDescription(v string) *GetOriginEndpointOutput {
	s.Description = &v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *GetOriginEndpointOutput) SetHlsManifests(v []*GetHlsManifestConfiguration) *GetOriginEndpointOutput {
	s.HlsManifests = v
	return s
}

// SetLowLatencyHlsManifests sets the LowLatencyHlsManifests field's value.
func (s *GetOriginEndpointOutput) SetLowLatencyHlsManifests(v []*GetLowLatencyHlsManifestConfiguration) *GetOriginEndpointOutput {
	s.LowLatencyHlsManifests = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetOriginEndpointOutput) SetModifiedAt(v time.Time) *GetOriginEndpointOutput {
	s.ModifiedAt = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *GetOriginEndpointOutput) SetOriginEndpointName(v string) *GetOriginEndpointOutput {
	s.OriginEndpointName = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *GetOriginEndpointOutput) SetSegment(v *Segment) *GetOriginEndpointOutput {
	s.Segment = v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *GetOriginEndpointOutput) SetStartoverWindowSeconds(v int64) *GetOriginEndpointOutput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetOriginEndpointOutput) SetTags(v map[string]*string) *GetOriginEndpointOutput {
	s.Tags = v
	return s
}

type GetOriginEndpointPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `location:"uri" locationName:"OriginEndpointName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOriginEndpointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOriginEndpointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOriginEndpointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOriginEndpointPolicyInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.OriginEndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginEndpointName"))
	}
	if s.OriginEndpointName != nil && len(*s.OriginEndpointName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginEndpointName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetOriginEndpointPolicyInput) SetChannelGroupName(v string) *GetOriginEndpointPolicyInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *GetOriginEndpointPolicyInput) SetChannelName(v string) *GetOriginEndpointPolicyInput {
	s.ChannelName = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *GetOriginEndpointPolicyInput) SetOriginEndpointName(v string) *GetOriginEndpointPolicyInput {
	s.OriginEndpointName = &v
	return s
}

type GetOriginEndpointPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `min:"1" type:"string" required:"true"`

	// The policy assigned to the origin endpoint.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOriginEndpointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOriginEndpointPolicyOutput) GoString() string {
	return s.String()
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *GetOriginEndpointPolicyOutput) SetChannelGroupName(v string) *GetOriginEndpointPolicyOutput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *GetOriginEndpointPolicyOutput) SetChannelName(v string) *GetOriginEndpointPolicyOutput {
	s.ChannelName = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *GetOriginEndpointPolicyOutput) SetOriginEndpointName(v string) *GetOriginEndpointPolicyOutput {
	s.OriginEndpointName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetOriginEndpointPolicyOutput) SetPolicy(v string) *GetOriginEndpointPolicyOutput {
	s.Policy = &v
	return s
}

// The ingest domain URL where the source stream should be sent.
type IngestEndpoint struct {
	_ struct{} `type:"structure"`

	// The system-generated unique identifier for the IngestEndpoint.
	Id *string `type:"string"`

	// The ingest domain URL where the source stream should be sent.
	Url *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestEndpoint) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *IngestEndpoint) SetId(v string) *IngestEndpoint {
	s.Id = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *IngestEndpoint) SetUrl(v string) *IngestEndpoint {
	s.Url = &v
	return s
}

// Indicates that an error from the service occurred while trying to process
// a request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListChannelGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from the GET list request. Use the token to fetch the
	// next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelGroupsInput) SetMaxResults(v int64) *ListChannelGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelGroupsInput) SetNextToken(v string) *ListChannelGroupsInput {
	s.NextToken = &v
	return s
}

type ListChannelGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The objects being returned.
	Items []*ChannelGroupListConfiguration `type:"list"`

	// The pagination token from the GET list request. Use the token to fetch the
	// next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelGroupsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListChannelGroupsOutput) SetItems(v []*ChannelGroupListConfiguration) *ListChannelGroupsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelGroupsOutput) SetNextToken(v string) *ListChannelGroupsOutput {
	s.NextToken = &v
	return s
}

type ListChannelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from the GET list request. Use the token to fetch the
	// next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListChannelsInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *ListChannelsInput) SetChannelGroupName(v string) *ListChannelsInput {
	s.ChannelGroupName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListChannelsInput) SetMaxResults(v int64) *ListChannelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsInput) SetNextToken(v string) *ListChannelsInput {
	s.NextToken = &v
	return s
}

type ListChannelsOutput struct {
	_ struct{} `type:"structure"`

	// The objects being returned.
	Items []*ChannelListConfiguration `type:"list"`

	// The pagination token from the GET list request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListChannelsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListChannelsOutput) SetItems(v []*ChannelListConfiguration) *ListChannelsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListChannelsOutput) SetNextToken(v string) *ListChannelsOutput {
	s.NextToken = &v
	return s
}

// List the HTTP live streaming (HLS) manifest configuration.
type ListHlsManifestConfiguration struct {
	_ struct{} `type:"structure"`

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	ChildManifestName *string `min:"1" type:"string"`

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts
	// the format extension, such as .m3u8. You can't use the same manifest name
	// if you use HLS manifest and low-latency HLS manifest. The manifestName on
	// the HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	//
	// ManifestName is a required field
	ManifestName *string `min:"1" type:"string" required:"true"`

	// The egress domain URL for stream delivery from MediaPackage.
	Url *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHlsManifestConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListHlsManifestConfiguration) GoString() string {
	return s.String()
}

// SetChildManifestName sets the ChildManifestName field's value.
func (s *ListHlsManifestConfiguration) SetChildManifestName(v string) *ListHlsManifestConfiguration {
	s.ChildManifestName = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *ListHlsManifestConfiguration) SetManifestName(v string) *ListHlsManifestConfiguration {
	s.ManifestName = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ListHlsManifestConfiguration) SetUrl(v string) *ListHlsManifestConfiguration {
	s.Url = &v
	return s
}

// List the low-latency HTTP live streaming (HLS) manifest configuration.
type ListLowLatencyHlsManifestConfiguration struct {
	_ struct{} `type:"structure"`

	// A short string that's appended to the endpoint URL. The child manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default child manifest name, index_1. The manifestName on the HLSManifest
	// object overrides the manifestName you provided on the originEndpoint object.
	ChildManifestName *string `min:"1" type:"string"`

	// A short short string that's appended to the endpoint URL. The manifest name
	// creates a unique path to this endpoint. If you don't enter a value, MediaPackage
	// uses the default manifest name, index. MediaPackage automatically inserts
	// the format extension, such as .m3u8. You can't use the same manifest name
	// if you use HLS manifest and low-latency HLS manifest. The manifestName on
	// the HLSManifest object overrides the manifestName you provided on the originEndpoint
	// object.
	//
	// ManifestName is a required field
	ManifestName *string `min:"1" type:"string" required:"true"`

	// The egress domain URL for stream delivery from MediaPackage.
	Url *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLowLatencyHlsManifestConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLowLatencyHlsManifestConfiguration) GoString() string {
	return s.String()
}

// SetChildManifestName sets the ChildManifestName field's value.
func (s *ListLowLatencyHlsManifestConfiguration) SetChildManifestName(v string) *ListLowLatencyHlsManifestConfiguration {
	s.ChildManifestName = &v
	return s
}

// SetManifestName sets the ManifestName field's value.
func (s *ListLowLatencyHlsManifestConfiguration) SetManifestName(v string) *ListLowLatencyHlsManifestConfiguration {
	s.ManifestName = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ListLowLatencyHlsManifestConfiguration) SetUrl(v string) *ListLowLatencyHlsManifestConfiguration {
	s.Url = &v
	return s
}

type ListOriginEndpointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token from the GET list request. Use the token to fetch the
	// next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOriginEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOriginEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOriginEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOriginEndpointsInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *ListOriginEndpointsInput) SetChannelGroupName(v string) *ListOriginEndpointsInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *ListOriginEndpointsInput) SetChannelName(v string) *ListOriginEndpointsInput {
	s.ChannelName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOriginEndpointsInput) SetMaxResults(v int64) *ListOriginEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOriginEndpointsInput) SetNextToken(v string) *ListOriginEndpointsInput {
	s.NextToken = &v
	return s
}

type ListOriginEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The objects being returned.
	Items []*OriginEndpointListConfiguration `type:"list"`

	// The pagination token from the GET list request. Use the token to fetch the
	// next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOriginEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOriginEndpointsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListOriginEndpointsOutput) SetItems(v []*OriginEndpointListConfiguration) *ListOriginEndpointsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOriginEndpointsOutput) SetNextToken(v string) *ListOriginEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the CloudWatch resource that you want to view tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The configuration of the origin endpoint.
type OriginEndpointListConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// The type of container attached to this origin endpoint. A container type
	// is a file format that encapsulates one or more media streams, such as audio
	// and video, into a single file.
	//
	// ContainerType is a required field
	ContainerType *string `type:"string" required:"true" enum:"ContainerType"`

	// The date and time the origin endpoint was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Any descriptive information that you want to add to the origin endpoint for
	// future identification purposes.
	Description *string `type:"string"`

	// An HTTP live streaming (HLS) manifest configuration.
	HlsManifests []*ListHlsManifestConfiguration `type:"list"`

	// A low-latency HLS manifest configuration.
	LowLatencyHlsManifests []*ListLowLatencyHlsManifestConfiguration `type:"list"`

	// The date and time the origin endpoint was modified.
	ModifiedAt *time.Time `type:"timestamp"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OriginEndpointListConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OriginEndpointListConfiguration) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *OriginEndpointListConfiguration) SetArn(v string) *OriginEndpointListConfiguration {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *OriginEndpointListConfiguration) SetChannelGroupName(v string) *OriginEndpointListConfiguration {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *OriginEndpointListConfiguration) SetChannelName(v string) *OriginEndpointListConfiguration {
	s.ChannelName = &v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *OriginEndpointListConfiguration) SetContainerType(v string) *OriginEndpointListConfiguration {
	s.ContainerType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *OriginEndpointListConfiguration) SetCreatedAt(v time.Time) *OriginEndpointListConfiguration {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *OriginEndpointListConfiguration) SetDescription(v string) *OriginEndpointListConfiguration {
	s.Description = &v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *OriginEndpointListConfiguration) SetHlsManifests(v []*ListHlsManifestConfiguration) *OriginEndpointListConfiguration {
	s.HlsManifests = v
	return s
}

// SetLowLatencyHlsManifests sets the LowLatencyHlsManifests field's value.
func (s *OriginEndpointListConfiguration) SetLowLatencyHlsManifests(v []*ListLowLatencyHlsManifestConfiguration) *OriginEndpointListConfiguration {
	s.LowLatencyHlsManifests = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *OriginEndpointListConfiguration) SetModifiedAt(v time.Time) *OriginEndpointListConfiguration {
	s.ModifiedAt = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *OriginEndpointListConfiguration) SetOriginEndpointName(v string) *OriginEndpointListConfiguration {
	s.OriginEndpointName = &v
	return s
}

type PutChannelPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// The policy to attach to the specified channel.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutChannelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutChannelPolicyInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *PutChannelPolicyInput) SetChannelGroupName(v string) *PutChannelPolicyInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *PutChannelPolicyInput) SetChannelName(v string) *PutChannelPolicyInput {
	s.ChannelName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutChannelPolicyInput) SetPolicy(v string) *PutChannelPolicyInput {
	s.Policy = &v
	return s
}

type PutChannelPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutChannelPolicyOutput) GoString() string {
	return s.String()
}

type PutOriginEndpointPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `location:"uri" locationName:"OriginEndpointName" min:"1" type:"string" required:"true"`

	// The policy to attach to the specified origin endpoint.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOriginEndpointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOriginEndpointPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOriginEndpointPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutOriginEndpointPolicyInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.OriginEndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginEndpointName"))
	}
	if s.OriginEndpointName != nil && len(*s.OriginEndpointName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginEndpointName", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *PutOriginEndpointPolicyInput) SetChannelGroupName(v string) *PutOriginEndpointPolicyInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *PutOriginEndpointPolicyInput) SetChannelName(v string) *PutOriginEndpointPolicyInput {
	s.ChannelName = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *PutOriginEndpointPolicyInput) SetOriginEndpointName(v string) *PutOriginEndpointPolicyInput {
	s.OriginEndpointName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutOriginEndpointPolicyInput) SetPolicy(v string) *PutOriginEndpointPolicyInput {
	s.Policy = &v
	return s
}

type PutOriginEndpointPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOriginEndpointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutOriginEndpointPolicyOutput) GoString() string {
	return s.String()
}

// The specified resource doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The specified resource type wasn't found.
	ResourceTypeNotFound *string `type:"string" enum:"ResourceTypeNotFound"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The SCTE configuration.
type Scte struct {
	_ struct{} `type:"structure"`

	// The SCTE-35 message types that you want to be treated as ad markers in the
	// output.
	ScteFilter []*string `type:"list" enum:"ScteFilter"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Scte) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Scte) GoString() string {
	return s.String()
}

// SetScteFilter sets the ScteFilter field's value.
func (s *Scte) SetScteFilter(v []*string) *Scte {
	s.ScteFilter = v
	return s
}

// The SCTE configuration.
type ScteHls struct {
	_ struct{} `type:"structure"`

	// Ad markers indicate when ads should be inserted during playback. If you include
	// ad markers in the content stream in your upstream encoders, then you need
	// to inform MediaPackage what to do with the ad markers in the output. Choose
	// what you want MediaPackage to do with the ad markers.
	//
	// Value description:
	//
	//    * DATERANGE - Insert EXT-X-DATERANGE tags to signal ad and program transition
	//    events in TS and CMAF manifests. If you use DATERANGE, you must set a
	//    programDateTimeIntervalSeconds value of 1 or higher. To learn more about
	//    DATERANGE, see SCTE-35 Ad Marker EXT-X-DATERANGE (http://docs.aws.amazon.com/mediapackage/latest/ug/scte-35-ad-marker-ext-x-daterange.html).
	AdMarkerHls *string `type:"string" enum:"AdMarkerHls"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScteHls) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScteHls) GoString() string {
	return s.String()
}

// SetAdMarkerHls sets the AdMarkerHls field's value.
func (s *ScteHls) SetAdMarkerHls(v string) *ScteHls {
	s.AdMarkerHls = &v
	return s
}

// The segment configuration, including the segment name, duration, and other
// configuration values.
type Segment struct {
	_ struct{} `type:"structure"`

	// The parameters for encrypting content.
	Encryption *Encryption `type:"structure"`

	// When selected, the stream set includes an additional I-frame only stream,
	// along with the other tracks. If false, this extra stream is not included.
	// MediaPackage generates an I-frame only stream from the first rendition in
	// the manifest. The service inserts EXT-I-FRAMES-ONLY tags in the output manifest,
	// and then generates and includes an I-frames only playlist in the stream.
	// This playlist permits player functionality like fast forward and rewind.
	IncludeIframeOnlyStreams *bool `type:"boolean"`

	// The SCTE configuration options in the segment settings.
	Scte *Scte `type:"structure"`

	// The duration (in seconds) of each segment. Enter a value equal to, or a multiple
	// of, the input segment duration. If the value that you enter is different
	// from the input segment duration, MediaPackage rounds segments to the nearest
	// multiple of the input segment duration.
	SegmentDurationSeconds *int64 `min:"1" type:"integer"`

	// The name that describes the segment. The name is the base name of the segment
	// used in all content manifests inside of the endpoint. You can't use spaces
	// in the name.
	SegmentName *string `min:"1" type:"string"`

	// By default, MediaPackage excludes all digital video broadcasting (DVB) subtitles
	// from the output. When selected, MediaPackage passes through DVB subtitles
	// into the output.
	TsIncludeDvbSubtitles *bool `type:"boolean"`

	// When selected, MediaPackage bundles all audio tracks in a rendition group.
	// All other tracks in the stream can be used with any audio rendition from
	// the group.
	TsUseAudioRenditionGroup *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Segment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Segment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Segment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Segment"}
	if s.SegmentDurationSeconds != nil && *s.SegmentDurationSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SegmentDurationSeconds", 1))
	}
	if s.SegmentName != nil && len(*s.SegmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentName", 1))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *Segment) SetEncryption(v *Encryption) *Segment {
	s.Encryption = v
	return s
}

// SetIncludeIframeOnlyStreams sets the IncludeIframeOnlyStreams field's value.
func (s *Segment) SetIncludeIframeOnlyStreams(v bool) *Segment {
	s.IncludeIframeOnlyStreams = &v
	return s
}

// SetScte sets the Scte field's value.
func (s *Segment) SetScte(v *Scte) *Segment {
	s.Scte = v
	return s
}

// SetSegmentDurationSeconds sets the SegmentDurationSeconds field's value.
func (s *Segment) SetSegmentDurationSeconds(v int64) *Segment {
	s.SegmentDurationSeconds = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *Segment) SetSegmentName(v string) *Segment {
	s.SegmentName = &v
	return s
}

// SetTsIncludeDvbSubtitles sets the TsIncludeDvbSubtitles field's value.
func (s *Segment) SetTsIncludeDvbSubtitles(v bool) *Segment {
	s.TsIncludeDvbSubtitles = &v
	return s
}

// SetTsUseAudioRenditionGroup sets the TsUseAudioRenditionGroup field's value.
func (s *Segment) SetTsUseAudioRenditionGroup(v bool) *Segment {
	s.TsUseAudioRenditionGroup = &v
	return s
}

// The request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The parameters for the SPEKE key provider.
type SpekeKeyProvider struct {
	_ struct{} `type:"structure"`

	// The DRM solution provider you're using to protect your content during distribution.
	//
	// DrmSystems is a required field
	DrmSystems []*string `min:"1" type:"list" required:"true" enum:"DrmSystem"`

	// Configure one or more content encryption keys for your endpoints that use
	// SPEKE Version 2.0. The encryption contract defines which content keys are
	// used to encrypt the audio and video tracks in your stream. To configure the
	// encryption contract, specify which audio and video encryption presets to
	// use.
	//
	// EncryptionContractConfiguration is a required field
	EncryptionContractConfiguration *EncryptionContractConfiguration `type:"structure" required:"true"`

	// The unique identifier for the content. The service sends this to the key
	// server to identify the current endpoint. How unique you make this depends
	// on how fine-grained you want access controls to be. The service does not
	// permit you to use the same ID for two simultaneous encryption processes.
	// The resource ID is also known as the content ID.
	//
	// The following example shows a resource ID: MovieNight20171126093045
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The ARN for the IAM role granted by the key provider that provides access
	// to the key provider API. This role must have a trust policy that allows MediaPackage
	// to assume the role, and it must have a sufficient permissions policy to allow
	// access to the specific key retrieval URL. Get this from your DRM solution
	// provider.
	//
	// Valid format: arn:aws:iam::{accountID}:role/{name}. The following example
	// shows a role ARN: arn:aws:iam::444455556666:role/SpekeAccess
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The URL of the API Gateway proxy that you set up to talk to your key server.
	// The API Gateway proxy must reside in the same AWS Region as MediaPackage
	// and must start with https://.
	//
	// The following example shows a URL: https://1wm2dx1f33.execute-api.us-west-2.amazonaws.com/SpekeSample/copyProtection
	//
	// Url is a required field
	Url *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpekeKeyProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SpekeKeyProvider) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpekeKeyProvider) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SpekeKeyProvider"}
	if s.DrmSystems == nil {
		invalidParams.Add(request.NewErrParamRequired("DrmSystems"))
	}
	if s.DrmSystems != nil && len(s.DrmSystems) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DrmSystems", 1))
	}
	if s.EncryptionContractConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionContractConfiguration"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Url == nil {
		invalidParams.Add(request.NewErrParamRequired("Url"))
	}
	if s.Url != nil && len(*s.Url) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Url", 1))
	}
	if s.EncryptionContractConfiguration != nil {
		if err := s.EncryptionContractConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionContractConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDrmSystems sets the DrmSystems field's value.
func (s *SpekeKeyProvider) SetDrmSystems(v []*string) *SpekeKeyProvider {
	s.DrmSystems = v
	return s
}

// SetEncryptionContractConfiguration sets the EncryptionContractConfiguration field's value.
func (s *SpekeKeyProvider) SetEncryptionContractConfiguration(v *EncryptionContractConfiguration) *SpekeKeyProvider {
	s.EncryptionContractConfiguration = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *SpekeKeyProvider) SetResourceId(v string) *SpekeKeyProvider {
	s.ResourceId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SpekeKeyProvider) SetRoleArn(v string) *SpekeKeyProvider {
	s.RoleArn = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *SpekeKeyProvider) SetUrl(v string) *SpekeKeyProvider {
	s.Url = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the MediaPackage resource that you're adding tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// Contains a map of the key-value pairs for the resource tag or tags assigned
	// to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request throughput limit was exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the MediaPackage resource that you're removing tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateChannelGroupInput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// Any descriptive information that you want to add to the channel group for
	// future identification purposes.
	Description *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelGroupInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *UpdateChannelGroupInput) SetChannelGroupName(v string) *UpdateChannelGroupInput {
	s.ChannelGroupName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateChannelGroupInput) SetDescription(v string) *UpdateChannelGroupInput {
	s.Description = &v
	return s
}

type UpdateChannelGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The date and time the channel group was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description for your channel group.
	Description *string `type:"string"`

	// The output domain where the source stream is sent. Integrate the domain with
	// a downstream CDN (such as Amazon CloudFront) or playback device.
	//
	// EgressDomain is a required field
	EgressDomain *string `type:"string" required:"true"`

	// The date and time the channel group was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The comma-separated list of tag key:value pairs assigned to the channel group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateChannelGroupOutput) SetArn(v string) *UpdateChannelGroupOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *UpdateChannelGroupOutput) SetChannelGroupName(v string) *UpdateChannelGroupOutput {
	s.ChannelGroupName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateChannelGroupOutput) SetCreatedAt(v time.Time) *UpdateChannelGroupOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateChannelGroupOutput) SetDescription(v string) *UpdateChannelGroupOutput {
	s.Description = &v
	return s
}

// SetEgressDomain sets the EgressDomain field's value.
func (s *UpdateChannelGroupOutput) SetEgressDomain(v string) *UpdateChannelGroupOutput {
	s.EgressDomain = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *UpdateChannelGroupOutput) SetModifiedAt(v time.Time) *UpdateChannelGroupOutput {
	s.ModifiedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateChannelGroupOutput) SetTags(v map[string]*string) *UpdateChannelGroupOutput {
	s.Tags = v
	return s
}

type UpdateChannelInput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// Any descriptive information that you want to add to the channel for future
	// identification purposes.
	Description *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChannelInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *UpdateChannelInput) SetChannelGroupName(v string) *UpdateChannelInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateChannelInput) SetChannelName(v string) *UpdateChannelInput {
	s.ChannelName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateChannelInput) SetDescription(v string) *UpdateChannelInput {
	s.Description = &v
	return s
}

type UpdateChannelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `type:"string" required:"true"`

	// The date and time the channel was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description for your channel.
	Description *string `type:"string"`

	// The list of ingest endpoints.
	IngestEndpoints []*IngestEndpoint `type:"list"`

	// The date and time the channel was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The comma-separated list of tag key:value pairs assigned to the channel.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateChannelOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateChannelOutput) SetArn(v string) *UpdateChannelOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *UpdateChannelOutput) SetChannelGroupName(v string) *UpdateChannelOutput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateChannelOutput) SetChannelName(v string) *UpdateChannelOutput {
	s.ChannelName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateChannelOutput) SetCreatedAt(v time.Time) *UpdateChannelOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateChannelOutput) SetDescription(v string) *UpdateChannelOutput {
	s.Description = &v
	return s
}

// SetIngestEndpoints sets the IngestEndpoints field's value.
func (s *UpdateChannelOutput) SetIngestEndpoints(v []*IngestEndpoint) *UpdateChannelOutput {
	s.IngestEndpoints = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *UpdateChannelOutput) SetModifiedAt(v time.Time) *UpdateChannelOutput {
	s.ModifiedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateChannelOutput) SetTags(v map[string]*string) *UpdateChannelOutput {
	s.Tags = v
	return s
}

type UpdateOriginEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `location:"uri" locationName:"ChannelGroupName" min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `location:"uri" locationName:"ChannelName" min:"1" type:"string" required:"true"`

	// The type of container attached to this origin endpoint. A container type
	// is a file format that encapsulates one or more media streams, such as audio
	// and video, into a single file.
	//
	// ContainerType is a required field
	ContainerType *string `type:"string" required:"true" enum:"ContainerType"`

	// Any descriptive information that you want to add to the origin endpoint for
	// future identification purposes.
	Description *string `type:"string"`

	// An HTTP live streaming (HLS) manifest configuration.
	HlsManifests []*CreateHlsManifestConfiguration `type:"list"`

	// A low-latency HLS manifest configuration.
	LowLatencyHlsManifests []*CreateLowLatencyHlsManifestConfiguration `type:"list"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `location:"uri" locationName:"OriginEndpointName" min:"1" type:"string" required:"true"`

	// The segment configuration, including the segment name, duration, and other
	// configuration values.
	Segment *Segment `type:"structure"`

	// The size of the window (in seconds) to create a window of the live stream
	// that's available for on-demand viewing. Viewers can start-over or catch-up
	// on content that falls within the window. The maximum startover window is
	// 1,209,600 seconds (14 days).
	StartoverWindowSeconds *int64 `min:"60" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOriginEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOriginEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOriginEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOriginEndpointInput"}
	if s.ChannelGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelGroupName"))
	}
	if s.ChannelGroupName != nil && len(*s.ChannelGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelGroupName", 1))
	}
	if s.ChannelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelName", 1))
	}
	if s.ContainerType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContainerType"))
	}
	if s.OriginEndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginEndpointName"))
	}
	if s.OriginEndpointName != nil && len(*s.OriginEndpointName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OriginEndpointName", 1))
	}
	if s.StartoverWindowSeconds != nil && *s.StartoverWindowSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("StartoverWindowSeconds", 60))
	}
	if s.HlsManifests != nil {
		for i, v := range s.HlsManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HlsManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LowLatencyHlsManifests != nil {
		for i, v := range s.LowLatencyHlsManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LowLatencyHlsManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Segment != nil {
		if err := s.Segment.Validate(); err != nil {
			invalidParams.AddNested("Segment", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *UpdateOriginEndpointInput) SetChannelGroupName(v string) *UpdateOriginEndpointInput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateOriginEndpointInput) SetChannelName(v string) *UpdateOriginEndpointInput {
	s.ChannelName = &v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *UpdateOriginEndpointInput) SetContainerType(v string) *UpdateOriginEndpointInput {
	s.ContainerType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateOriginEndpointInput) SetDescription(v string) *UpdateOriginEndpointInput {
	s.Description = &v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *UpdateOriginEndpointInput) SetHlsManifests(v []*CreateHlsManifestConfiguration) *UpdateOriginEndpointInput {
	s.HlsManifests = v
	return s
}

// SetLowLatencyHlsManifests sets the LowLatencyHlsManifests field's value.
func (s *UpdateOriginEndpointInput) SetLowLatencyHlsManifests(v []*CreateLowLatencyHlsManifestConfiguration) *UpdateOriginEndpointInput {
	s.LowLatencyHlsManifests = v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *UpdateOriginEndpointInput) SetOriginEndpointName(v string) *UpdateOriginEndpointInput {
	s.OriginEndpointName = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *UpdateOriginEndpointInput) SetSegment(v *Segment) *UpdateOriginEndpointInput {
	s.Segment = v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *UpdateOriginEndpointInput) SetStartoverWindowSeconds(v int64) *UpdateOriginEndpointInput {
	s.StartoverWindowSeconds = &v
	return s
}

type UpdateOriginEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the resource.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The name that describes the channel group. The name is the primary identifier
	// for the channel group, and must be unique for your account in the AWS Region.
	//
	// ChannelGroupName is a required field
	ChannelGroupName *string `min:"1" type:"string" required:"true"`

	// The name that describes the channel. The name is the primary identifier for
	// the channel, and must be unique for your account in the AWS Region and channel
	// group.
	//
	// ChannelName is a required field
	ChannelName *string `min:"1" type:"string" required:"true"`

	// The type of container attached to this origin endpoint.
	//
	// ContainerType is a required field
	ContainerType *string `type:"string" required:"true" enum:"ContainerType"`

	// The date and time the origin endpoint was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The description of the origin endpoint.
	Description *string `type:"string"`

	// An HTTP live streaming (HLS) manifest configuration.
	HlsManifests []*GetHlsManifestConfiguration `type:"list"`

	// A low-latency HLS manifest configuration.
	LowLatencyHlsManifests []*GetLowLatencyHlsManifestConfiguration `type:"list"`

	// The date and time the origin endpoint was modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `type:"timestamp" required:"true"`

	// The name that describes the origin endpoint. The name is the primary identifier
	// for the origin endpoint, and and must be unique for your account in the AWS
	// Region and channel.
	//
	// OriginEndpointName is a required field
	OriginEndpointName *string `min:"1" type:"string" required:"true"`

	// The segment configuration, including the segment name, duration, and other
	// configuration values.
	//
	// Segment is a required field
	Segment *Segment `type:"structure" required:"true"`

	// The size of the window (in seconds) to create a window of the live stream
	// that's available for on-demand viewing. Viewers can start-over or catch-up
	// on content that falls within the window.
	StartoverWindowSeconds *int64 `type:"integer"`

	// The comma-separated list of tag key:value pairs assigned to the origin endpoint.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOriginEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOriginEndpointOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateOriginEndpointOutput) SetArn(v string) *UpdateOriginEndpointOutput {
	s.Arn = &v
	return s
}

// SetChannelGroupName sets the ChannelGroupName field's value.
func (s *UpdateOriginEndpointOutput) SetChannelGroupName(v string) *UpdateOriginEndpointOutput {
	s.ChannelGroupName = &v
	return s
}

// SetChannelName sets the ChannelName field's value.
func (s *UpdateOriginEndpointOutput) SetChannelName(v string) *UpdateOriginEndpointOutput {
	s.ChannelName = &v
	return s
}

// SetContainerType sets the ContainerType field's value.
func (s *UpdateOriginEndpointOutput) SetContainerType(v string) *UpdateOriginEndpointOutput {
	s.ContainerType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateOriginEndpointOutput) SetCreatedAt(v time.Time) *UpdateOriginEndpointOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateOriginEndpointOutput) SetDescription(v string) *UpdateOriginEndpointOutput {
	s.Description = &v
	return s
}

// SetHlsManifests sets the HlsManifests field's value.
func (s *UpdateOriginEndpointOutput) SetHlsManifests(v []*GetHlsManifestConfiguration) *UpdateOriginEndpointOutput {
	s.HlsManifests = v
	return s
}

// SetLowLatencyHlsManifests sets the LowLatencyHlsManifests field's value.
func (s *UpdateOriginEndpointOutput) SetLowLatencyHlsManifests(v []*GetLowLatencyHlsManifestConfiguration) *UpdateOriginEndpointOutput {
	s.LowLatencyHlsManifests = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *UpdateOriginEndpointOutput) SetModifiedAt(v time.Time) *UpdateOriginEndpointOutput {
	s.ModifiedAt = &v
	return s
}

// SetOriginEndpointName sets the OriginEndpointName field's value.
func (s *UpdateOriginEndpointOutput) SetOriginEndpointName(v string) *UpdateOriginEndpointOutput {
	s.OriginEndpointName = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *UpdateOriginEndpointOutput) SetSegment(v *Segment) *UpdateOriginEndpointOutput {
	s.Segment = v
	return s
}

// SetStartoverWindowSeconds sets the StartoverWindowSeconds field's value.
func (s *UpdateOriginEndpointOutput) SetStartoverWindowSeconds(v int64) *UpdateOriginEndpointOutput {
	s.StartoverWindowSeconds = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateOriginEndpointOutput) SetTags(v map[string]*string) *UpdateOriginEndpointOutput {
	s.Tags = v
	return s
}

// The input failed to meet the constraints specified by the AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The type of ValidationException.
	ValidationExceptionType *string `type:"string" enum:"ValidationExceptionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AdMarkerHlsDaterange is a AdMarkerHls enum value
	AdMarkerHlsDaterange = "DATERANGE"
)

// AdMarkerHls_Values returns all elements of the AdMarkerHls enum
func AdMarkerHls_Values() []string {
	return []string{
		AdMarkerHlsDaterange,
	}
}

const (
	// CmafEncryptionMethodCenc is a CmafEncryptionMethod enum value
	CmafEncryptionMethodCenc = "CENC"

	// CmafEncryptionMethodCbcs is a CmafEncryptionMethod enum value
	CmafEncryptionMethodCbcs = "CBCS"
)

// CmafEncryptionMethod_Values returns all elements of the CmafEncryptionMethod enum
func CmafEncryptionMethod_Values() []string {
	return []string{
		CmafEncryptionMethodCenc,
		CmafEncryptionMethodCbcs,
	}
}

const (
	// ConflictExceptionTypeResourceInUse is a ConflictExceptionType enum value
	ConflictExceptionTypeResourceInUse = "RESOURCE_IN_USE"

	// ConflictExceptionTypeResourceAlreadyExists is a ConflictExceptionType enum value
	ConflictExceptionTypeResourceAlreadyExists = "RESOURCE_ALREADY_EXISTS"

	// ConflictExceptionTypeIdempotentParameterMismatch is a ConflictExceptionType enum value
	ConflictExceptionTypeIdempotentParameterMismatch = "IDEMPOTENT_PARAMETER_MISMATCH"

	// ConflictExceptionTypeConflictingOperation is a ConflictExceptionType enum value
	ConflictExceptionTypeConflictingOperation = "CONFLICTING_OPERATION"
)

// ConflictExceptionType_Values returns all elements of the ConflictExceptionType enum
func ConflictExceptionType_Values() []string {
	return []string{
		ConflictExceptionTypeResourceInUse,
		ConflictExceptionTypeResourceAlreadyExists,
		ConflictExceptionTypeIdempotentParameterMismatch,
		ConflictExceptionTypeConflictingOperation,
	}
}

const (
	// ContainerTypeTs is a ContainerType enum value
	ContainerTypeTs = "TS"

	// ContainerTypeCmaf is a ContainerType enum value
	ContainerTypeCmaf = "CMAF"
)

// ContainerType_Values returns all elements of the ContainerType enum
func ContainerType_Values() []string {
	return []string{
		ContainerTypeTs,
		ContainerTypeCmaf,
	}
}

const (
	// DrmSystemClearKeyAes128 is a DrmSystem enum value
	DrmSystemClearKeyAes128 = "CLEAR_KEY_AES_128"

	// DrmSystemFairplay is a DrmSystem enum value
	DrmSystemFairplay = "FAIRPLAY"

	// DrmSystemPlayready is a DrmSystem enum value
	DrmSystemPlayready = "PLAYREADY"

	// DrmSystemWidevine is a DrmSystem enum value
	DrmSystemWidevine = "WIDEVINE"
)

// DrmSystem_Values returns all elements of the DrmSystem enum
func DrmSystem_Values() []string {
	return []string{
		DrmSystemClearKeyAes128,
		DrmSystemFairplay,
		DrmSystemPlayready,
		DrmSystemWidevine,
	}
}

const (
	// PresetSpeke20AudioPresetAudio1 is a PresetSpeke20Audio enum value
	PresetSpeke20AudioPresetAudio1 = "PRESET_AUDIO_1"

	// PresetSpeke20AudioPresetAudio2 is a PresetSpeke20Audio enum value
	PresetSpeke20AudioPresetAudio2 = "PRESET_AUDIO_2"

	// PresetSpeke20AudioPresetAudio3 is a PresetSpeke20Audio enum value
	PresetSpeke20AudioPresetAudio3 = "PRESET_AUDIO_3"

	// PresetSpeke20AudioShared is a PresetSpeke20Audio enum value
	PresetSpeke20AudioShared = "SHARED"

	// PresetSpeke20AudioUnencrypted is a PresetSpeke20Audio enum value
	PresetSpeke20AudioUnencrypted = "UNENCRYPTED"
)

// PresetSpeke20Audio_Values returns all elements of the PresetSpeke20Audio enum
func PresetSpeke20Audio_Values() []string {
	return []string{
		PresetSpeke20AudioPresetAudio1,
		PresetSpeke20AudioPresetAudio2,
		PresetSpeke20AudioPresetAudio3,
		PresetSpeke20AudioShared,
		PresetSpeke20AudioUnencrypted,
	}
}

const (
	// PresetSpeke20VideoPresetVideo1 is a PresetSpeke20Video enum value
	PresetSpeke20VideoPresetVideo1 = "PRESET_VIDEO_1"

	// PresetSpeke20VideoPresetVideo2 is a PresetSpeke20Video enum value
	PresetSpeke20VideoPresetVideo2 = "PRESET_VIDEO_2"

	// PresetSpeke20VideoPresetVideo3 is a PresetSpeke20Video enum value
	PresetSpeke20VideoPresetVideo3 = "PRESET_VIDEO_3"

	// PresetSpeke20VideoPresetVideo4 is a PresetSpeke20Video enum value
	PresetSpeke20VideoPresetVideo4 = "PRESET_VIDEO_4"

	// PresetSpeke20VideoPresetVideo5 is a PresetSpeke20Video enum value
	PresetSpeke20VideoPresetVideo5 = "PRESET_VIDEO_5"

	// PresetSpeke20VideoPresetVideo6 is a PresetSpeke20Video enum value
	PresetSpeke20VideoPresetVideo6 = "PRESET_VIDEO_6"

	// PresetSpeke20VideoPresetVideo7 is a PresetSpeke20Video enum value
	PresetSpeke20VideoPresetVideo7 = "PRESET_VIDEO_7"

	// PresetSpeke20VideoPresetVideo8 is a PresetSpeke20Video enum value
	PresetSpeke20VideoPresetVideo8 = "PRESET_VIDEO_8"

	// PresetSpeke20VideoShared is a PresetSpeke20Video enum value
	PresetSpeke20VideoShared = "SHARED"

	// PresetSpeke20VideoUnencrypted is a PresetSpeke20Video enum value
	PresetSpeke20VideoUnencrypted = "UNENCRYPTED"
)

// PresetSpeke20Video_Values returns all elements of the PresetSpeke20Video enum
func PresetSpeke20Video_Values() []string {
	return []string{
		PresetSpeke20VideoPresetVideo1,
		PresetSpeke20VideoPresetVideo2,
		PresetSpeke20VideoPresetVideo3,
		PresetSpeke20VideoPresetVideo4,
		PresetSpeke20VideoPresetVideo5,
		PresetSpeke20VideoPresetVideo6,
		PresetSpeke20VideoPresetVideo7,
		PresetSpeke20VideoPresetVideo8,
		PresetSpeke20VideoShared,
		PresetSpeke20VideoUnencrypted,
	}
}

const (
	// ResourceTypeNotFoundChannelGroup is a ResourceTypeNotFound enum value
	ResourceTypeNotFoundChannelGroup = "CHANNEL_GROUP"

	// ResourceTypeNotFoundChannel is a ResourceTypeNotFound enum value
	ResourceTypeNotFoundChannel = "CHANNEL"

	// ResourceTypeNotFoundOriginEndpoint is a ResourceTypeNotFound enum value
	ResourceTypeNotFoundOriginEndpoint = "ORIGIN_ENDPOINT"
)

// ResourceTypeNotFound_Values returns all elements of the ResourceTypeNotFound enum
func ResourceTypeNotFound_Values() []string {
	return []string{
		ResourceTypeNotFoundChannelGroup,
		ResourceTypeNotFoundChannel,
		ResourceTypeNotFoundOriginEndpoint,
	}
}

const (
	// ScteFilterSpliceInsert is a ScteFilter enum value
	ScteFilterSpliceInsert = "SPLICE_INSERT"

	// ScteFilterBreak is a ScteFilter enum value
	ScteFilterBreak = "BREAK"

	// ScteFilterProviderAdvertisement is a ScteFilter enum value
	ScteFilterProviderAdvertisement = "PROVIDER_ADVERTISEMENT"

	// ScteFilterDistributorAdvertisement is a ScteFilter enum value
	ScteFilterDistributorAdvertisement = "DISTRIBUTOR_ADVERTISEMENT"

	// ScteFilterProviderPlacementOpportunity is a ScteFilter enum value
	ScteFilterProviderPlacementOpportunity = "PROVIDER_PLACEMENT_OPPORTUNITY"

	// ScteFilterDistributorPlacementOpportunity is a ScteFilter enum value
	ScteFilterDistributorPlacementOpportunity = "DISTRIBUTOR_PLACEMENT_OPPORTUNITY"

	// ScteFilterProviderOverlayPlacementOpportunity is a ScteFilter enum value
	ScteFilterProviderOverlayPlacementOpportunity = "PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY"

	// ScteFilterDistributorOverlayPlacementOpportunity is a ScteFilter enum value
	ScteFilterDistributorOverlayPlacementOpportunity = "DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY"

	// ScteFilterProgram is a ScteFilter enum value
	ScteFilterProgram = "PROGRAM"
)

// ScteFilter_Values returns all elements of the ScteFilter enum
func ScteFilter_Values() []string {
	return []string{
		ScteFilterSpliceInsert,
		ScteFilterBreak,
		ScteFilterProviderAdvertisement,
		ScteFilterDistributorAdvertisement,
		ScteFilterProviderPlacementOpportunity,
		ScteFilterDistributorPlacementOpportunity,
		ScteFilterProviderOverlayPlacementOpportunity,
		ScteFilterDistributorOverlayPlacementOpportunity,
		ScteFilterProgram,
	}
}

const (
	// TsEncryptionMethodAes128 is a TsEncryptionMethod enum value
	TsEncryptionMethodAes128 = "AES_128"

	// TsEncryptionMethodSampleAes is a TsEncryptionMethod enum value
	TsEncryptionMethodSampleAes = "SAMPLE_AES"
)

// TsEncryptionMethod_Values returns all elements of the TsEncryptionMethod enum
func TsEncryptionMethod_Values() []string {
	return []string{
		TsEncryptionMethodAes128,
		TsEncryptionMethodSampleAes,
	}
}

const (
	// ValidationExceptionTypeContainerTypeImmutable is a ValidationExceptionType enum value
	ValidationExceptionTypeContainerTypeImmutable = "CONTAINER_TYPE_IMMUTABLE"

	// ValidationExceptionTypeInvalidPaginationToken is a ValidationExceptionType enum value
	ValidationExceptionTypeInvalidPaginationToken = "INVALID_PAGINATION_TOKEN"

	// ValidationExceptionTypeInvalidPaginationMaxResults is a ValidationExceptionType enum value
	ValidationExceptionTypeInvalidPaginationMaxResults = "INVALID_PAGINATION_MAX_RESULTS"

	// ValidationExceptionTypeInvalidPolicy is a ValidationExceptionType enum value
	ValidationExceptionTypeInvalidPolicy = "INVALID_POLICY"

	// ValidationExceptionTypeInvalidRoleArn is a ValidationExceptionType enum value
	ValidationExceptionTypeInvalidRoleArn = "INVALID_ROLE_ARN"

	// ValidationExceptionTypeManifestNameCollision is a ValidationExceptionType enum value
	ValidationExceptionTypeManifestNameCollision = "MANIFEST_NAME_COLLISION"

	// ValidationExceptionTypeEncryptionMethodContainerTypeMismatch is a ValidationExceptionType enum value
	ValidationExceptionTypeEncryptionMethodContainerTypeMismatch = "ENCRYPTION_METHOD_CONTAINER_TYPE_MISMATCH"

	// ValidationExceptionTypeCencIvIncompatible is a ValidationExceptionType enum value
	ValidationExceptionTypeCencIvIncompatible = "CENC_IV_INCOMPATIBLE"

	// ValidationExceptionTypeEncryptionContractWithoutAudioRenditionIncompatible is a ValidationExceptionType enum value
	ValidationExceptionTypeEncryptionContractWithoutAudioRenditionIncompatible = "ENCRYPTION_CONTRACT_WITHOUT_AUDIO_RENDITION_INCOMPATIBLE"

	// ValidationExceptionTypeEncryptionContractUnencrypted is a ValidationExceptionType enum value
	ValidationExceptionTypeEncryptionContractUnencrypted = "ENCRYPTION_CONTRACT_UNENCRYPTED"

	// ValidationExceptionTypeEncryptionContractShared is a ValidationExceptionType enum value
	ValidationExceptionTypeEncryptionContractShared = "ENCRYPTION_CONTRACT_SHARED"

	// ValidationExceptionTypeNumManifestsLow is a ValidationExceptionType enum value
	ValidationExceptionTypeNumManifestsLow = "NUM_MANIFESTS_LOW"

	// ValidationExceptionTypeNumManifestsHigh is a ValidationExceptionType enum value
	ValidationExceptionTypeNumManifestsHigh = "NUM_MANIFESTS_HIGH"

	// ValidationExceptionTypeDrmSystemsEncryptionMethodIncompatible is a ValidationExceptionType enum value
	ValidationExceptionTypeDrmSystemsEncryptionMethodIncompatible = "DRM_SYSTEMS_ENCRYPTION_METHOD_INCOMPATIBLE"

	// ValidationExceptionTypeRoleArnNotAssumable is a ValidationExceptionType enum value
	ValidationExceptionTypeRoleArnNotAssumable = "ROLE_ARN_NOT_ASSUMABLE"

	// ValidationExceptionTypeRoleArnLengthOutOfRange is a ValidationExceptionType enum value
	ValidationExceptionTypeRoleArnLengthOutOfRange = "ROLE_ARN_LENGTH_OUT_OF_RANGE"

	// ValidationExceptionTypeRoleArnInvalidFormat is a ValidationExceptionType enum value
	ValidationExceptionTypeRoleArnInvalidFormat = "ROLE_ARN_INVALID_FORMAT"

	// ValidationExceptionTypeUrlInvalid is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlInvalid = "URL_INVALID"

	// ValidationExceptionTypeUrlScheme is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlScheme = "URL_SCHEME"

	// ValidationExceptionTypeUrlUserInfo is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlUserInfo = "URL_USER_INFO"

	// ValidationExceptionTypeUrlPort is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlPort = "URL_PORT"

	// ValidationExceptionTypeUrlUnknownHost is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlUnknownHost = "URL_UNKNOWN_HOST"

	// ValidationExceptionTypeUrlLocalAddress is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlLocalAddress = "URL_LOCAL_ADDRESS"

	// ValidationExceptionTypeUrlLoopbackAddress is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlLoopbackAddress = "URL_LOOPBACK_ADDRESS"

	// ValidationExceptionTypeUrlLinkLocalAddress is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlLinkLocalAddress = "URL_LINK_LOCAL_ADDRESS"

	// ValidationExceptionTypeUrlMulticastAddress is a ValidationExceptionType enum value
	ValidationExceptionTypeUrlMulticastAddress = "URL_MULTICAST_ADDRESS"

	// ValidationExceptionTypeMemberInvalid is a ValidationExceptionType enum value
	ValidationExceptionTypeMemberInvalid = "MEMBER_INVALID"

	// ValidationExceptionTypeMemberMissing is a ValidationExceptionType enum value
	ValidationExceptionTypeMemberMissing = "MEMBER_MISSING"

	// ValidationExceptionTypeMemberMinValue is a ValidationExceptionType enum value
	ValidationExceptionTypeMemberMinValue = "MEMBER_MIN_VALUE"

	// ValidationExceptionTypeMemberMaxValue is a ValidationExceptionType enum value
	ValidationExceptionTypeMemberMaxValue = "MEMBER_MAX_VALUE"

	// ValidationExceptionTypeMemberMinLength is a ValidationExceptionType enum value
	ValidationExceptionTypeMemberMinLength = "MEMBER_MIN_LENGTH"

	// ValidationExceptionTypeMemberMaxLength is a ValidationExceptionType enum value
	ValidationExceptionTypeMemberMaxLength = "MEMBER_MAX_LENGTH"

	// ValidationExceptionTypeMemberInvalidEnumValue is a ValidationExceptionType enum value
	ValidationExceptionTypeMemberInvalidEnumValue = "MEMBER_INVALID_ENUM_VALUE"

	// ValidationExceptionTypeMemberDoesNotMatchPattern is a ValidationExceptionType enum value
	ValidationExceptionTypeMemberDoesNotMatchPattern = "MEMBER_DOES_NOT_MATCH_PATTERN"

	// ValidationExceptionTypeInvalidManifestFilter is a ValidationExceptionType enum value
	ValidationExceptionTypeInvalidManifestFilter = "INVALID_MANIFEST_FILTER"

	// ValidationExceptionTypeInvalidTimeDelaySeconds is a ValidationExceptionType enum value
	ValidationExceptionTypeInvalidTimeDelaySeconds = "INVALID_TIME_DELAY_SECONDS"

	// ValidationExceptionTypeEndTimeEarlierThanStartTime is a ValidationExceptionType enum value
	ValidationExceptionTypeEndTimeEarlierThanStartTime = "END_TIME_EARLIER_THAN_START_TIME"
)

// ValidationExceptionType_Values returns all elements of the ValidationExceptionType enum
func ValidationExceptionType_Values() []string {
	return []string{
		ValidationExceptionTypeContainerTypeImmutable,
		ValidationExceptionTypeInvalidPaginationToken,
		ValidationExceptionTypeInvalidPaginationMaxResults,
		ValidationExceptionTypeInvalidPolicy,
		ValidationExceptionTypeInvalidRoleArn,
		ValidationExceptionTypeManifestNameCollision,
		ValidationExceptionTypeEncryptionMethodContainerTypeMismatch,
		ValidationExceptionTypeCencIvIncompatible,
		ValidationExceptionTypeEncryptionContractWithoutAudioRenditionIncompatible,
		ValidationExceptionTypeEncryptionContractUnencrypted,
		ValidationExceptionTypeEncryptionContractShared,
		ValidationExceptionTypeNumManifestsLow,
		ValidationExceptionTypeNumManifestsHigh,
		ValidationExceptionTypeDrmSystemsEncryptionMethodIncompatible,
		ValidationExceptionTypeRoleArnNotAssumable,
		ValidationExceptionTypeRoleArnLengthOutOfRange,
		ValidationExceptionTypeRoleArnInvalidFormat,
		ValidationExceptionTypeUrlInvalid,
		ValidationExceptionTypeUrlScheme,
		ValidationExceptionTypeUrlUserInfo,
		ValidationExceptionTypeUrlPort,
		ValidationExceptionTypeUrlUnknownHost,
		ValidationExceptionTypeUrlLocalAddress,
		ValidationExceptionTypeUrlLoopbackAddress,
		ValidationExceptionTypeUrlLinkLocalAddress,
		ValidationExceptionTypeUrlMulticastAddress,
		ValidationExceptionTypeMemberInvalid,
		ValidationExceptionTypeMemberMissing,
		ValidationExceptionTypeMemberMinValue,
		ValidationExceptionTypeMemberMaxValue,
		ValidationExceptionTypeMemberMinLength,
		ValidationExceptionTypeMemberMaxLength,
		ValidationExceptionTypeMemberInvalidEnumValue,
		ValidationExceptionTypeMemberDoesNotMatchPattern,
		ValidationExceptionTypeInvalidManifestFilter,
		ValidationExceptionTypeInvalidTimeDelaySeconds,
		ValidationExceptionTypeEndTimeEarlierThanStartTime,
	}
}
