// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package acm provides a client for AWS Certificate Manager.
package acm

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTagsToCertificate = "AddTagsToCertificate"

// AddTagsToCertificateRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToCertificateRequest method.
//    req, resp := client.AddTagsToCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) AddTagsToCertificateRequest(input *AddTagsToCertificateInput) (req *request.Request, output *AddTagsToCertificateOutput) {
	op := &request.Operation{
		Name:       opAddTagsToCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AddTagsToCertificateOutput{}
	req.Data = output
	return
}

// AddTagsToCertificate API operation for AWS Certificate Manager.
//
// Adds one or more tags to an ACM Certificate. Tags are labels that you can
// use to identify and organize your AWS resources. Each tag consists of a key
// and an optional value. You specify the certificate on input by its Amazon
// Resource Name (ARN). You specify the tag by using a key-value pair.
//
// You can apply a tag to just one certificate if you want to identify a specific
// characteristic of that certificate, or you can apply the same tag to multiple
// certificates if you want to filter for a common relationship among those
// certificates. Similarly, you can apply the same tag to multiple resources
// if you want to specify a relationship among those resources. For example,
// you can add the same tag to an ACM Certificate and an Elastic Load Balancing
// load balancer to indicate that they are both used by the same website. For
// more information, see Tagging ACM Certificates (http://docs.aws.amazon.com/acm/latest/userguide/tags.html).
//
// To remove one or more tags, use the RemoveTagsFromCertificate action. To
// view all of the tags that have been applied to the certificate, use the ListTagsForCertificate
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation AddTagsToCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidTagException
//   One or both of the values that make up the key-value pair is not valid. For
//   example, you cannot specify a tag value that begins with aws:.
//
//   * TooManyTagsException
//   The request contains too many tags. Try the request again with fewer tags.
//
func (c *ACM) AddTagsToCertificate(input *AddTagsToCertificateInput) (*AddTagsToCertificateOutput, error) {
	req, out := c.AddTagsToCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteCertificateOutput{}
	req.Data = output
	return
}

// DeleteCertificate API operation for AWS Certificate Manager.
//
// Deletes an ACM Certificate and its associated private key. If this action
// succeeds, the certificate no longer appears in the list of ACM Certificates
// that can be displayed by calling the ListCertificates action or be retrieved
// by calling the GetCertificate action. The certificate will not be available
// for use by other AWS services.
//
// You cannot delete an ACM Certificate that is being used by another AWS service.
// To delete a certificate that is in use, the certificate association must
// first be removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * ResourceInUseException
//   The certificate is in use by another AWS service in the caller's account.
//   Remove the association and try again.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
func (c *ACM) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCertificate = "DescribeCertificate"

// DescribeCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCertificateRequest method.
//    req, resp := client.DescribeCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) DescribeCertificateRequest(input *DescribeCertificateInput) (req *request.Request, output *DescribeCertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCertificateOutput{}
	req.Data = output
	return
}

// DescribeCertificate API operation for AWS Certificate Manager.
//
// Returns a list of the fields contained in the specified ACM Certificate.
// For example, this action returns the certificate status, a flag that indicates
// whether the certificate is associated with any other AWS service, and the
// date at which the certificate request was created. You specify the ACM Certificate
// on input by its Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation DescribeCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
func (c *ACM) DescribeCertificate(input *DescribeCertificateInput) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opGetCertificate = "GetCertificate"

// GetCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCertificateRequest method.
//    req, resp := client.GetCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) GetCertificateRequest(input *GetCertificateInput) (req *request.Request, output *GetCertificateOutput) {
	op := &request.Operation{
		Name:       opGetCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCertificateOutput{}
	req.Data = output
	return
}

// GetCertificate API operation for AWS Certificate Manager.
//
// Retrieves an ACM Certificate and certificate chain for the certificate specified
// by an ARN. The chain is an ordered list of certificates that contains the
// root certificate, intermediate certificates of subordinate CAs, and the ACM
// Certificate. The certificate and certificate chain are base64 encoded. If
// you want to decode the certificate chain to see the individual certificate
// fields, you can use OpenSSL.
//
// Currently, ACM Certificates can be used only with Elastic Load Balancing
// and Amazon CloudFront.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation GetCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * RequestInProgressException
//   The certificate request is in process and the certificate in your account
//   has not yet been issued.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
func (c *ACM) GetCertificate(input *GetCertificateInput) (*GetCertificateOutput, error) {
	req, out := c.GetCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opImportCertificate = "ImportCertificate"

// ImportCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ImportCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportCertificateRequest method.
//    req, resp := client.ImportCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) ImportCertificateRequest(input *ImportCertificateInput) (req *request.Request, output *ImportCertificateOutput) {
	op := &request.Operation{
		Name:       opImportCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ImportCertificateOutput{}
	req.Data = output
	return
}

// ImportCertificate API operation for AWS Certificate Manager.
//
// Imports an SSL/TLS certificate into AWS Certificate Manager (ACM) to use
// with ACM's integrated AWS services (http://docs.aws.amazon.com/acm/latest/userguide/acm-services.html).
//
// ACM does not provide managed renewal (http://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
// for certificates that you import.
//
// For more information about importing certificates into ACM, including the
// differences between certificates that you import and those that ACM provides,
// see Importing Certificates (http://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
// in the AWS Certificate Manager User Guide.
//
// To import a certificate, you must provide the certificate and the matching
// private key. When the certificate is not self-signed, you must also provide
// a certificate chain. You can omit the certificate chain when importing a
// self-signed certificate.
//
// The certificate, private key, and certificate chain must be PEM-encoded.
// For more information about converting these items to PEM format, see Importing
// Certificates Troubleshooting (http://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html#import-certificate-troubleshooting)
// in the AWS Certificate Manager User Guide.
//
// To import a new certificate, omit the CertificateArn field. Include this
// field only when you want to replace a previously imported certificate.
//
// This operation returns the Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
// of the imported certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation ImportCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * LimitExceededException
//   An ACM limit has been exceeded. For example, you may have input more domains
//   than are allowed or you've requested too many certificates for your account.
//   See the exception message returned by ACM to determine which limit you have
//   violated. For more information about ACM limits, see the Limits (http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html)
//   topic.
//
func (c *ACM) ImportCertificate(input *ImportCertificateInput) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opListCertificates = "ListCertificates"

// ListCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCertificates operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListCertificates for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListCertificates method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListCertificatesRequest method.
//    req, resp := client.ListCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) ListCertificatesRequest(input *ListCertificatesInput) (req *request.Request, output *ListCertificatesOutput) {
	op := &request.Operation{
		Name:       opListCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCertificatesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListCertificatesOutput{}
	req.Data = output
	return
}

// ListCertificates API operation for AWS Certificate Manager.
//
// Retrieves a list of ACM Certificates and the domain name for each. You can
// optionally filter the list to return only the certificates that match the
// specified status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation ListCertificates for usage and error information.
func (c *ACM) ListCertificates(input *ListCertificatesInput) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	err := req.Send()
	return out, err
}

// ListCertificatesPages iterates over the pages of a ListCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCertificates operation.
//    pageNum := 0
//    err := client.ListCertificatesPages(params,
//        func(page *ListCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ACM) ListCertificatesPages(input *ListCertificatesInput, fn func(p *ListCertificatesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListCertificatesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListCertificatesOutput), lastPage)
	})
}

const opListTagsForCertificate = "ListTagsForCertificate"

// ListTagsForCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForCertificateRequest method.
//    req, resp := client.ListTagsForCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) ListTagsForCertificateRequest(input *ListTagsForCertificateInput) (req *request.Request, output *ListTagsForCertificateOutput) {
	op := &request.Operation{
		Name:       opListTagsForCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForCertificateOutput{}
	req.Data = output
	return
}

// ListTagsForCertificate API operation for AWS Certificate Manager.
//
// Lists the tags that have been applied to the ACM Certificate. Use the certificate
// ARN to specify the certificate. To add a tag to an ACM Certificate, use the
// AddTagsToCertificate action. To delete a tag, use the RemoveTagsFromCertificate
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation ListTagsForCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
func (c *ACM) ListTagsForCertificate(input *ListTagsForCertificateInput) (*ListTagsForCertificateOutput, error) {
	req, out := c.ListTagsForCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromCertificate = "RemoveTagsFromCertificate"

// RemoveTagsFromCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromCertificateRequest method.
//    req, resp := client.RemoveTagsFromCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) RemoveTagsFromCertificateRequest(input *RemoveTagsFromCertificateInput) (req *request.Request, output *RemoveTagsFromCertificateOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RemoveTagsFromCertificateOutput{}
	req.Data = output
	return
}

// RemoveTagsFromCertificate API operation for AWS Certificate Manager.
//
// Remove one or more tags from an ACM Certificate. A tag consists of a key-value
// pair. If you do not specify the value portion of the tag when calling this
// function, the tag will be removed regardless of value. If you specify a value,
// the tag is removed only if it is associated with the specified value.
//
// To add tags to a certificate, use the AddTagsToCertificate action. To view
// all of the tags that have been applied to a specific ACM Certificate, use
// the ListTagsForCertificate action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation RemoveTagsFromCertificate for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidTagException
//   One or both of the values that make up the key-value pair is not valid. For
//   example, you cannot specify a tag value that begins with aws:.
//
func (c *ACM) RemoveTagsFromCertificate(input *RemoveTagsFromCertificateInput) (*RemoveTagsFromCertificateOutput, error) {
	req, out := c.RemoveTagsFromCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opRequestCertificate = "RequestCertificate"

// RequestCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RequestCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RequestCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RequestCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RequestCertificateRequest method.
//    req, resp := client.RequestCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) RequestCertificateRequest(input *RequestCertificateInput) (req *request.Request, output *RequestCertificateOutput) {
	op := &request.Operation{
		Name:       opRequestCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestCertificateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RequestCertificateOutput{}
	req.Data = output
	return
}

// RequestCertificate API operation for AWS Certificate Manager.
//
// Requests an ACM Certificate for use with other AWS services. To request an
// ACM Certificate, you must specify the fully qualified domain name (FQDN)
// for your site. You can also specify additional FQDNs if users can reach your
// site by using other names. For each domain name you specify, email is sent
// to the domain owner to request approval to issue the certificate. After receiving
// approval from the domain owner, the ACM Certificate is issued. For more information,
// see the AWS Certificate Manager User Guide (http://docs.aws.amazon.com/acm/latest/userguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation RequestCertificate for usage and error information.
//
// Returned Error Codes:
//   * LimitExceededException
//   An ACM limit has been exceeded. For example, you may have input more domains
//   than are allowed or you've requested too many certificates for your account.
//   See the exception message returned by ACM to determine which limit you have
//   violated. For more information about ACM limits, see the Limits (http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html)
//   topic.
//
//   * InvalidDomainValidationOptionsException
//   One or more values in the DomainValidationOption structure is incorrect.
//
func (c *ACM) RequestCertificate(input *RequestCertificateInput) (*RequestCertificateOutput, error) {
	req, out := c.RequestCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opResendValidationEmail = "ResendValidationEmail"

// ResendValidationEmailRequest generates a "aws/request.Request" representing the
// client's request for the ResendValidationEmail operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResendValidationEmail for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResendValidationEmail method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResendValidationEmailRequest method.
//    req, resp := client.ResendValidationEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *ACM) ResendValidationEmailRequest(input *ResendValidationEmailInput) (req *request.Request, output *ResendValidationEmailOutput) {
	op := &request.Operation{
		Name:       opResendValidationEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResendValidationEmailInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ResendValidationEmailOutput{}
	req.Data = output
	return
}

// ResendValidationEmail API operation for AWS Certificate Manager.
//
// Resends the email that requests domain ownership validation. The domain owner
// or an authorized representative must approve the ACM Certificate before it
// can be issued. The certificate can be approved by clicking a link in the
// mail to navigate to the Amazon certificate approval website and then clicking
// I Approve. However, the validation email can be blocked by spam filters.
// Therefore, if you do not receive the original mail, you can request that
// the mail be resent within 72 hours of requesting the ACM Certificate. If
// more than 72 hours have elapsed since your original request or since your
// last attempt to resend validation mail, you must request a new certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager's
// API operation ResendValidationEmail for usage and error information.
//
// Returned Error Codes:
//   * ResourceNotFoundException
//   The specified certificate cannot be found in the caller's account, or the
//   caller's account cannot be found.
//
//   * InvalidStateException
//   Processing has reached an invalid state. For example, this exception can
//   occur if the specified domain is not using email validation, or the current
//   certificate status does not permit the requested operation. See the exception
//   message returned by ACM to determine which state is not valid.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidDomainValidationOptionsException
//   One or more values in the DomainValidationOption structure is incorrect.
//
func (c *ACM) ResendValidationEmail(input *ResendValidationEmailInput) (*ResendValidationEmailOutput, error) {
	req, out := c.ResendValidationEmailRequest(input)
	err := req.Send()
	return out, err
}

type AddTagsToCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate to which the tag is to
	// be applied. This must be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// The key-value pair that defines the tag. The tag value is optional.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddTagsToCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToCertificateOutput) GoString() string {
	return s.String()
}

// Contains detailed metadata about an ACM Certificate. This structure is returned
// in the response to a DescribeCertificate request.
type CertificateDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate. For more information about
	// ARNs, see Amazon Resource Names (ARNs) and AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	CertificateArn *string `min:"20" type:"string"`

	// The time at which the certificate was requested. This value exists only when
	// the certificate type is AMAZON_ISSUED.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The fully qualified domain name for the certificate, such as www.example.com
	// or example.com.
	DomainName *string `min:"1" type:"string"`

	// Contains information about the email address or addresses used for domain
	// validation. This field exists only when the certificate type is AMAZON_ISSUED.
	DomainValidationOptions []*DomainValidation `min:"1" type:"list"`

	// The reason the certificate request failed. This value exists only when the
	// certificate status is FAILED. For more information, see Certificate Request
	// Failed (http://docs.aws.amazon.com/acm/latest/userguide/troubleshooting.html#troubleshooting-failed)
	// in the AWS Certificate Manager User Guide.
	FailureReason *string `type:"string" enum:"FailureReason"`

	// The date and time at which the certificate was imported. This value exists
	// only when the certificate type is IMPORTED.
	ImportedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of ARNs for the AWS resources that are using the certificate. A certificate
	// can be used by multiple AWS resources.
	InUseBy []*string `type:"list"`

	// The time at which the certificate was issued. This value exists only when
	// the certificate type is AMAZON_ISSUED.
	IssuedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the certificate authority that issued and signed the certificate.
	Issuer *string `type:"string"`

	// The algorithm that was used to generate the key pair (the public and private
	// key).
	KeyAlgorithm *string `type:"string" enum:"KeyAlgorithm"`

	// The time after which the certificate is not valid.
	NotAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time before which the certificate is not valid.
	NotBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The reason the certificate was revoked. This value exists only when the certificate
	// status is REVOKED.
	RevocationReason *string `type:"string" enum:"RevocationReason"`

	// The time at which the certificate was revoked. This value exists only when
	// the certificate status is REVOKED.
	RevokedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The serial number of the certificate.
	Serial *string `type:"string"`

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string `type:"string"`

	// The status of the certificate.
	Status *string `type:"string" enum:"CertificateStatus"`

	// The name of the entity that is associated with the public key contained in
	// the certificate.
	Subject *string `type:"string"`

	// One or more domain names (subject alternative names) included in the certificate.
	// This list contains the domain names that are bound to the public key that
	// is contained in the certificate. The subject alternative names include the
	// canonical domain name (CN) of the certificate and additional domain names
	// that can be used to connect to the website.
	SubjectAlternativeNames []*string `min:"1" type:"list"`

	// The source of the certificate. For certificates provided by ACM, this value
	// is AMAZON_ISSUED. For certificates that you imported with ImportCertificate,
	// this value is IMPORTED. ACM does not provide managed renewal (http://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
	// for imported certificates. For more information about the differences between
	// certificates that you import and those that ACM provides, see Importing Certificates
	// (http://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
	// in the AWS Certificate Manager User Guide.
	Type *string `type:"string" enum:"CertificateType"`
}

// String returns the string representation
func (s CertificateDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateDetail) GoString() string {
	return s.String()
}

// This structure is returned in the response object of ListCertificates action.
type CertificateSummary struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the certificate. This is of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	CertificateArn *string `min:"20" type:"string"`

	// Fully qualified domain name (FQDN), such as www.example.com or example.com,
	// for the certificate.
	DomainName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CertificateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateSummary) GoString() string {
	return s.String()
}

type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate to be deleted. This must
	// be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

type DescribeCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains an ACM Certificate ARN. The ARN must be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Contains a CertificateDetail structure that lists the fields of an ACM Certificate.
	Certificate *CertificateDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateOutput) GoString() string {
	return s.String()
}

// Structure that contains the domain name, the base validation domain to which
// validation email is sent, and the email addresses used to validate the domain
// identity.
type DomainValidation struct {
	_ struct{} `type:"structure"`

	// Fully Qualified Domain Name (FQDN) of the form www.example.com or example.com.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The base validation domain that acts as the suffix of the email addresses
	// that are used to send the emails.
	ValidationDomain *string `min:"1" type:"string"`

	// A list of contact address for the domain registrant.
	ValidationEmails []*string `type:"list"`
}

// String returns the string representation
func (s DomainValidation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainValidation) GoString() string {
	return s.String()
}

// This structure is used in the request object of the RequestCertificate action.
type DomainValidationOption struct {
	_ struct{} `type:"structure"`

	// Fully Qualified Domain Name (FQDN) of the certificate being requested.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The domain to which validation email is sent. This is the base validation
	// domain that will act as the suffix of the email addresses. This must be the
	// same as the DomainName value or a superdomain of the DomainName value. For
	// example, if you requested a certificate for site.subdomain.example.com and
	// specify a ValidationDomain of subdomain.example.com, ACM sends email to the
	// domain registrant, technical contact, and administrative contact in WHOIS
	// for the base domain and the following five addresses:
	//
	//    * admin@subdomain.example.com
	//
	//    * administrator@subdomain.example.com
	//
	//    * hostmaster@subdomain.example.com
	//
	//    * postmaster@subdomain.example.com
	//
	//    * webmaster@subdomain.example.com
	//
	// ValidationDomain is a required field
	ValidationDomain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DomainValidationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainValidationOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainValidationOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainValidationOption"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ValidationDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationDomain"))
	}
	if s.ValidationDomain != nil && len(*s.ValidationDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationDomain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains a certificate ARN in the following format:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCertificateOutput struct {
	_ struct{} `type:"structure"`

	// String that contains the ACM Certificate represented by the ARN specified
	// at input.
	Certificate *string `min:"1" type:"string"`

	// The certificate chain that contains the root certificate issued by the certificate
	// authority (CA).
	CertificateChain *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCertificateOutput) GoString() string {
	return s.String()
}

type ImportCertificateInput struct {
	_ struct{} `type:"structure"`

	// The certificate to import. It must meet the following requirements:
	//
	//    * Must be PEM-encoded.
	//
	//    * Must contain a 1024-bit or 2048-bit RSA public key.
	//
	//    * Must be valid at the time of import. You cannot import a certificate
	//    before its validity period begins (the certificate's NotBefore date) or
	//    after it expires (the certificate's NotAfter date).
	//
	// Certificate is automatically base64 encoded/decoded by the SDK.
	//
	// Certificate is a required field
	Certificate []byte `min:"1" type:"blob" required:"true"`

	// The Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an imported certificate to replace. To import a new certificate, omit
	// this field.
	CertificateArn *string `min:"20" type:"string"`

	// The certificate chain. It must be PEM-encoded.
	//
	// CertificateChain is automatically base64 encoded/decoded by the SDK.
	CertificateChain []byte `min:"1" type:"blob"`

	// The private key that matches the public key in the certificate. It must meet
	// the following requirements:
	//
	//    * Must be PEM-encoded.
	//
	//    * Must be unencrypted. You cannot import a private key that is protected
	//    by a password or passphrase.
	//
	// PrivateKey is automatically base64 encoded/decoded by the SDK.
	//
	// PrivateKey is a required field
	PrivateKey []byte `min:"1" type:"blob" required:"true"`
}

// String returns the string representation
func (s ImportCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCertificateInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(s.Certificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 1))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.CertificateChain != nil && len(s.CertificateChain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateChain", 1))
	}
	if s.PrivateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKey"))
	}
	if s.PrivateKey != nil && len(s.PrivateKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrivateKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ImportCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the imported certificate.
	CertificateArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s ImportCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateOutput) GoString() string {
	return s.String()
}

type ListCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The status or statuses on which to filter the list of ACM Certificates.
	CertificateStatuses []*string `type:"list"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response. If additional items exist beyond the
	// number you specify, the NextToken element is sent in the response. Use this
	// NextToken value in a subsequent request to retrieve additional items.
	MaxItems *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you receive a response with truncated results. Set it to the
	// value of NextToken from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificatesInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of ACM Certificates.
	CertificateSummaryList []*CertificateSummary `type:"list"`

	// When the list is truncated, this value is present and contains the value
	// to use for the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesOutput) GoString() string {
	return s.String()
}

type ListTagsForCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate for which you want to
	// list the tags. This must be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTagsForCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The key-value pairs that define the applied tags.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTagsForCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForCertificateOutput) GoString() string {
	return s.String()
}

type RemoveTagsFromCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM Certificate with one or more tags
	// that you want to remove. This must be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// The key-value pair that defines the tag to remove.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveTagsFromCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromCertificateOutput) GoString() string {
	return s.String()
}

type RequestCertificateInput struct {
	_ struct{} `type:"structure"`

	// Fully qualified domain name (FQDN), such as www.example.com, of the site
	// you want to secure with an ACM Certificate. Use an asterisk (*) to create
	// a wildcard certificate that protects several sites in the same domain. For
	// example, *.example.com protects www.example.com, site.example.com, and images.example.com.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The base validation domain that will act as the suffix of the email addresses
	// that are used to send the emails. This must be the same as the Domain value
	// or a superdomain of the Domain value. For example, if you requested a certificate
	// for test.example.com and specify DomainValidationOptions of example.com,
	// ACM sends email to the domain registrant, technical contact, and administrative
	// contact in WHOIS and the following five addresses:
	//
	//    * admin@example.com
	//
	//    * administrator@example.com
	//
	//    * hostmaster@example.com
	//
	//    * postmaster@example.com
	//
	//    * webmaster@example.com
	DomainValidationOptions []*DomainValidationOption `min:"1" type:"list"`

	// Customer chosen string that can be used to distinguish between calls to RequestCertificate.
	// Idempotency tokens time out after one hour. Therefore, if you call RequestCertificate
	// multiple times with the same idempotency token within one hour, ACM recognizes
	// that you are requesting only one certificate and will issue only one. If
	// you change the idempotency token for each call, ACM recognizes that you are
	// requesting multiple certificates.
	IdempotencyToken *string `min:"1" type:"string"`

	// Additional FQDNs to be included in the Subject Alternative Name extension
	// of the ACM Certificate. For example, add the name www.example.net to a certificate
	// for which the DomainName field is www.example.com if users can reach your
	// site by using either name.
	SubjectAlternativeNames []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s RequestCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestCertificateInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.DomainValidationOptions != nil && len(s.DomainValidationOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainValidationOptions", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.SubjectAlternativeNames != nil && len(s.SubjectAlternativeNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubjectAlternativeNames", 1))
	}
	if s.DomainValidationOptions != nil {
		for i, v := range s.DomainValidationOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DomainValidationOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RequestCertificateOutput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the issued certificate. This must be of the
	// form:
	//
	// arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
	CertificateArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s RequestCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCertificateOutput) GoString() string {
	return s.String()
}

type ResendValidationEmailInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the requested certificate. The certificate
	// ARN is generated and returned by the RequestCertificate action as soon as
	// the request is made. By default, using this parameter causes email to be
	// sent to all top-level domains you specified in the certificate request.
	//
	// The ARN must be of the form:
	//
	// arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// The Fully Qualified Domain Name (FQDN) of the certificate that needs to be
	// validated.
	//
	// Domain is a required field
	Domain *string `min:"1" type:"string" required:"true"`

	// The base validation domain that will act as the suffix of the email addresses
	// that are used to send the emails. This must be the same as the Domain value
	// or a superdomain of the Domain value. For example, if you requested a certificate
	// for site.subdomain.example.com and specify a ValidationDomain of subdomain.example.com,
	// ACM sends email to the domain registrant, technical contact, and administrative
	// contact in WHOIS and the following five addresses:
	//
	//    * admin@subdomain.example.com
	//
	//    * administrator@subdomain.example.com
	//
	//    * hostmaster@subdomain.example.com
	//
	//    * postmaster@subdomain.example.com
	//
	//    * webmaster@subdomain.example.com
	//
	// ValidationDomain is a required field
	ValidationDomain *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResendValidationEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendValidationEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResendValidationEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResendValidationEmailInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.ValidationDomain == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationDomain"))
	}
	if s.ValidationDomain != nil && len(*s.ValidationDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationDomain", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ResendValidationEmailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResendValidationEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendValidationEmailOutput) GoString() string {
	return s.String()
}

// A key-value pair that identifies or specifies metadata about an ACM resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

const (
	// CertificateStatusPendingValidation is a CertificateStatus enum value
	CertificateStatusPendingValidation = "PENDING_VALIDATION"

	// CertificateStatusIssued is a CertificateStatus enum value
	CertificateStatusIssued = "ISSUED"

	// CertificateStatusInactive is a CertificateStatus enum value
	CertificateStatusInactive = "INACTIVE"

	// CertificateStatusExpired is a CertificateStatus enum value
	CertificateStatusExpired = "EXPIRED"

	// CertificateStatusValidationTimedOut is a CertificateStatus enum value
	CertificateStatusValidationTimedOut = "VALIDATION_TIMED_OUT"

	// CertificateStatusRevoked is a CertificateStatus enum value
	CertificateStatusRevoked = "REVOKED"

	// CertificateStatusFailed is a CertificateStatus enum value
	CertificateStatusFailed = "FAILED"
)

const (
	// CertificateTypeImported is a CertificateType enum value
	CertificateTypeImported = "IMPORTED"

	// CertificateTypeAmazonIssued is a CertificateType enum value
	CertificateTypeAmazonIssued = "AMAZON_ISSUED"
)

const (
	// FailureReasonNoAvailableContacts is a FailureReason enum value
	FailureReasonNoAvailableContacts = "NO_AVAILABLE_CONTACTS"

	// FailureReasonAdditionalVerificationRequired is a FailureReason enum value
	FailureReasonAdditionalVerificationRequired = "ADDITIONAL_VERIFICATION_REQUIRED"

	// FailureReasonDomainNotAllowed is a FailureReason enum value
	FailureReasonDomainNotAllowed = "DOMAIN_NOT_ALLOWED"

	// FailureReasonInvalidPublicDomain is a FailureReason enum value
	FailureReasonInvalidPublicDomain = "INVALID_PUBLIC_DOMAIN"

	// FailureReasonOther is a FailureReason enum value
	FailureReasonOther = "OTHER"
)

const (
	// KeyAlgorithmRsa2048 is a KeyAlgorithm enum value
	KeyAlgorithmRsa2048 = "RSA_2048"

	// KeyAlgorithmRsa1024 is a KeyAlgorithm enum value
	KeyAlgorithmRsa1024 = "RSA_1024"

	// KeyAlgorithmEcPrime256v1 is a KeyAlgorithm enum value
	KeyAlgorithmEcPrime256v1 = "EC_prime256v1"
)

const (
	// RevocationReasonUnspecified is a RevocationReason enum value
	RevocationReasonUnspecified = "UNSPECIFIED"

	// RevocationReasonKeyCompromise is a RevocationReason enum value
	RevocationReasonKeyCompromise = "KEY_COMPROMISE"

	// RevocationReasonCaCompromise is a RevocationReason enum value
	RevocationReasonCaCompromise = "CA_COMPROMISE"

	// RevocationReasonAffiliationChanged is a RevocationReason enum value
	RevocationReasonAffiliationChanged = "AFFILIATION_CHANGED"

	// RevocationReasonSuperceded is a RevocationReason enum value
	RevocationReasonSuperceded = "SUPERCEDED"

	// RevocationReasonCessationOfOperation is a RevocationReason enum value
	RevocationReasonCessationOfOperation = "CESSATION_OF_OPERATION"

	// RevocationReasonCertificateHold is a RevocationReason enum value
	RevocationReasonCertificateHold = "CERTIFICATE_HOLD"

	// RevocationReasonRemoveFromCrl is a RevocationReason enum value
	RevocationReasonRemoveFromCrl = "REMOVE_FROM_CRL"

	// RevocationReasonPrivilegeWithdrawn is a RevocationReason enum value
	RevocationReasonPrivilegeWithdrawn = "PRIVILEGE_WITHDRAWN"

	// RevocationReasonAACompromise is a RevocationReason enum value
	RevocationReasonAACompromise = "A_A_COMPROMISE"
)
