// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateAudienceModel struct {
}

func (*validateOpCreateAudienceModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAudienceModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAudienceModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAudienceModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateConfiguredAudienceModel struct {
}

func (*validateOpCreateConfiguredAudienceModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateConfiguredAudienceModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateConfiguredAudienceModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateConfiguredAudienceModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateTrainingDataset struct {
}

func (*validateOpCreateTrainingDataset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateTrainingDataset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateTrainingDatasetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateTrainingDatasetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAudienceGenerationJob struct {
}

func (*validateOpDeleteAudienceGenerationJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAudienceGenerationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAudienceGenerationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAudienceGenerationJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteAudienceModel struct {
}

func (*validateOpDeleteAudienceModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteAudienceModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteAudienceModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteAudienceModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteConfiguredAudienceModel struct {
}

func (*validateOpDeleteConfiguredAudienceModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteConfiguredAudienceModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteConfiguredAudienceModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteConfiguredAudienceModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteConfiguredAudienceModelPolicy struct {
}

func (*validateOpDeleteConfiguredAudienceModelPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteConfiguredAudienceModelPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteConfiguredAudienceModelPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteConfiguredAudienceModelPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTrainingDataset struct {
}

func (*validateOpDeleteTrainingDataset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTrainingDataset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTrainingDatasetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTrainingDatasetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAudienceGenerationJob struct {
}

func (*validateOpGetAudienceGenerationJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAudienceGenerationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAudienceGenerationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAudienceGenerationJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAudienceModel struct {
}

func (*validateOpGetAudienceModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAudienceModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAudienceModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAudienceModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetConfiguredAudienceModel struct {
}

func (*validateOpGetConfiguredAudienceModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetConfiguredAudienceModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetConfiguredAudienceModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetConfiguredAudienceModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetConfiguredAudienceModelPolicy struct {
}

func (*validateOpGetConfiguredAudienceModelPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetConfiguredAudienceModelPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetConfiguredAudienceModelPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetConfiguredAudienceModelPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTrainingDataset struct {
}

func (*validateOpGetTrainingDataset) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTrainingDataset) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTrainingDatasetInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTrainingDatasetInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutConfiguredAudienceModelPolicy struct {
}

func (*validateOpPutConfiguredAudienceModelPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutConfiguredAudienceModelPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutConfiguredAudienceModelPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutConfiguredAudienceModelPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartAudienceExportJob struct {
}

func (*validateOpStartAudienceExportJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartAudienceExportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartAudienceExportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartAudienceExportJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartAudienceGenerationJob struct {
}

func (*validateOpStartAudienceGenerationJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartAudienceGenerationJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartAudienceGenerationJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartAudienceGenerationJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateConfiguredAudienceModel struct {
}

func (*validateOpUpdateConfiguredAudienceModel) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConfiguredAudienceModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConfiguredAudienceModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConfiguredAudienceModelInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateAudienceModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAudienceModel{}, middleware.After)
}

func addOpCreateConfiguredAudienceModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateConfiguredAudienceModel{}, middleware.After)
}

func addOpCreateTrainingDatasetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateTrainingDataset{}, middleware.After)
}

func addOpDeleteAudienceGenerationJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAudienceGenerationJob{}, middleware.After)
}

func addOpDeleteAudienceModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteAudienceModel{}, middleware.After)
}

func addOpDeleteConfiguredAudienceModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteConfiguredAudienceModel{}, middleware.After)
}

func addOpDeleteConfiguredAudienceModelPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteConfiguredAudienceModelPolicy{}, middleware.After)
}

func addOpDeleteTrainingDatasetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTrainingDataset{}, middleware.After)
}

func addOpGetAudienceGenerationJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAudienceGenerationJob{}, middleware.After)
}

func addOpGetAudienceModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAudienceModel{}, middleware.After)
}

func addOpGetConfiguredAudienceModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetConfiguredAudienceModel{}, middleware.After)
}

func addOpGetConfiguredAudienceModelPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetConfiguredAudienceModelPolicy{}, middleware.After)
}

func addOpGetTrainingDatasetValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTrainingDataset{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutConfiguredAudienceModelPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutConfiguredAudienceModelPolicy{}, middleware.After)
}

func addOpStartAudienceExportJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartAudienceExportJob{}, middleware.After)
}

func addOpStartAudienceGenerationJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartAudienceGenerationJob{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateConfiguredAudienceModelValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConfiguredAudienceModel{}, middleware.After)
}

func validateAudienceDestination(v *types.AudienceDestination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AudienceDestination"}
	if v.S3Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Destination"))
	} else if v.S3Destination != nil {
		if err := validateS3ConfigMap(v.S3Destination); err != nil {
			invalidParams.AddNested("S3Destination", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAudienceGenerationJobDataSource(v *types.AudienceGenerationJobDataSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AudienceGenerationJobDataSource"}
	if v.DataSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSource"))
	} else if v.DataSource != nil {
		if err := validateS3ConfigMap(v.DataSource); err != nil {
			invalidParams.AddNested("DataSource", err.(smithy.InvalidParamsError))
		}
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAudienceSize(v *types.AudienceSize) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AudienceSize"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAudienceSizeConfig(v *types.AudienceSizeConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AudienceSizeConfig"}
	if len(v.AudienceSizeType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceSizeType"))
	}
	if v.AudienceSizeBins == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceSizeBins"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateColumnSchema(v *types.ColumnSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ColumnSchema"}
	if v.ColumnName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ColumnName"))
	}
	if v.ColumnTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ColumnTypes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateConfiguredAudienceModelOutputConfig(v *types.ConfiguredAudienceModelOutputConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConfiguredAudienceModelOutputConfig"}
	if v.Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destination"))
	} else if v.Destination != nil {
		if err := validateAudienceDestination(v.Destination); err != nil {
			invalidParams.AddNested("Destination", err.(smithy.InvalidParamsError))
		}
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDataset(v *types.Dataset) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Dataset"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.InputConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputConfig"))
	} else if v.InputConfig != nil {
		if err := validateDatasetInputConfig(v.InputConfig); err != nil {
			invalidParams.AddNested("InputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDatasetInputConfig(v *types.DatasetInputConfig) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DatasetInputConfig"}
	if v.Schema == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Schema"))
	} else if v.Schema != nil {
		if err := validateDatasetSchemaList(v.Schema); err != nil {
			invalidParams.AddNested("Schema", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataSource"))
	} else if v.DataSource != nil {
		if err := validateDataSource(v.DataSource); err != nil {
			invalidParams.AddNested("DataSource", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDatasetList(v []types.Dataset) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DatasetList"}
	for i := range v {
		if err := validateDataset(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDatasetSchemaList(v []types.ColumnSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DatasetSchemaList"}
	for i := range v {
		if err := validateColumnSchema(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDataSource(v *types.DataSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DataSource"}
	if v.GlueDataSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GlueDataSource"))
	} else if v.GlueDataSource != nil {
		if err := validateGlueDataSource(v.GlueDataSource); err != nil {
			invalidParams.AddNested("GlueDataSource", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateGlueDataSource(v *types.GlueDataSource) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GlueDataSource"}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if v.DatabaseName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatabaseName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateS3ConfigMap(v *types.S3ConfigMap) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "S3ConfigMap"}
	if v.S3Uri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("S3Uri"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAudienceModelInput(v *CreateAudienceModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAudienceModelInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.TrainingDatasetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TrainingDatasetArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateConfiguredAudienceModelInput(v *CreateConfiguredAudienceModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateConfiguredAudienceModelInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.AudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceModelArn"))
	}
	if v.OutputConfig == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutputConfig"))
	} else if v.OutputConfig != nil {
		if err := validateConfiguredAudienceModelOutputConfig(v.OutputConfig); err != nil {
			invalidParams.AddNested("OutputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.SharedAudienceMetrics == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SharedAudienceMetrics"))
	}
	if v.AudienceSizeConfig != nil {
		if err := validateAudienceSizeConfig(v.AudienceSizeConfig); err != nil {
			invalidParams.AddNested("AudienceSizeConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateTrainingDatasetInput(v *CreateTrainingDatasetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTrainingDatasetInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if v.TrainingData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TrainingData"))
	} else if v.TrainingData != nil {
		if err := validateDatasetList(v.TrainingData); err != nil {
			invalidParams.AddNested("TrainingData", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAudienceGenerationJobInput(v *DeleteAudienceGenerationJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAudienceGenerationJobInput"}
	if v.AudienceGenerationJobArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceGenerationJobArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteAudienceModelInput(v *DeleteAudienceModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteAudienceModelInput"}
	if v.AudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteConfiguredAudienceModelInput(v *DeleteConfiguredAudienceModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteConfiguredAudienceModelInput"}
	if v.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteConfiguredAudienceModelPolicyInput(v *DeleteConfiguredAudienceModelPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteConfiguredAudienceModelPolicyInput"}
	if v.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTrainingDatasetInput(v *DeleteTrainingDatasetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTrainingDatasetInput"}
	if v.TrainingDatasetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TrainingDatasetArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAudienceGenerationJobInput(v *GetAudienceGenerationJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAudienceGenerationJobInput"}
	if v.AudienceGenerationJobArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceGenerationJobArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAudienceModelInput(v *GetAudienceModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAudienceModelInput"}
	if v.AudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetConfiguredAudienceModelInput(v *GetConfiguredAudienceModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetConfiguredAudienceModelInput"}
	if v.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetConfiguredAudienceModelPolicyInput(v *GetConfiguredAudienceModelPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetConfiguredAudienceModelPolicyInput"}
	if v.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTrainingDatasetInput(v *GetTrainingDatasetInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTrainingDatasetInput"}
	if v.TrainingDatasetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TrainingDatasetArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutConfiguredAudienceModelPolicyInput(v *PutConfiguredAudienceModelPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutConfiguredAudienceModelPolicyInput"}
	if v.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if v.ConfiguredAudienceModelPolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfiguredAudienceModelPolicy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartAudienceExportJobInput(v *StartAudienceExportJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartAudienceExportJobInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.AudienceGenerationJobArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceGenerationJobArn"))
	}
	if v.AudienceSize == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AudienceSize"))
	} else if v.AudienceSize != nil {
		if err := validateAudienceSize(v.AudienceSize); err != nil {
			invalidParams.AddNested("AudienceSize", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartAudienceGenerationJobInput(v *StartAudienceGenerationJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartAudienceGenerationJobInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if v.SeedAudience == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SeedAudience"))
	} else if v.SeedAudience != nil {
		if err := validateAudienceGenerationJobDataSource(v.SeedAudience); err != nil {
			invalidParams.AddNested("SeedAudience", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConfiguredAudienceModelInput(v *UpdateConfiguredAudienceModelInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConfiguredAudienceModelInput"}
	if v.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if v.OutputConfig != nil {
		if err := validateConfiguredAudienceModelOutputConfig(v.OutputConfig); err != nil {
			invalidParams.AddNested("OutputConfig", err.(smithy.InvalidParamsError))
		}
	}
	if v.AudienceSizeConfig != nil {
		if err := validateAudienceSizeConfig(v.AudienceSizeConfig); err != nil {
			invalidParams.AddNested("AudienceSizeConfig", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
