// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The health check for the instance that's specified by ServiceId and InstanceId
// isn't a custom health check.
type CustomHealthNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CustomHealthNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomHealthNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomHealthNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CustomHealthNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *CustomHealthNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation is already in progress.
type DuplicateRequest struct {
	Message *string

	ErrorCodeOverride *string

	DuplicateOperationId *string

	noSmithyDocumentSerde
}

func (e *DuplicateRequest) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateRequest) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateRequest) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateRequest"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateRequest) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No instance exists with the specified ID, or the instance was recently
// registered, and information about the instance hasn't propagated yet.
type InstanceNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InstanceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InstanceNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *InstanceNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One or more specified values aren't valid. For example, a required value might
// be missing, a numeric value might be outside the allowed range, or a string
// value might exceed length constraints.
type InvalidInput struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInput) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInput) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInput) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInput"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInput) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The namespace that you're trying to create already exists.
type NamespaceAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	CreatorRequestId *string
	NamespaceId      *string

	noSmithyDocumentSerde
}

func (e *NamespaceAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NamespaceAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NamespaceAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NamespaceAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *NamespaceAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No namespace exists with the specified ID.
type NamespaceNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NamespaceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NamespaceNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NamespaceNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NamespaceNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *NamespaceNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No operation exists with the specified ID.
type OperationNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation can't be completed because you've reached the quota for the
// number of requests. For more information, see Cloud Map API request throttling
// quota (https://docs.aws.amazon.com/cloud-map/latest/dg/throttling.html) in the
// Cloud Map Developer Guide.
type RequestLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RequestLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RequestLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RequestLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RequestLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *RequestLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified resource can't be deleted because it contains other resources.
// For example, you can't delete a service that contains any instances.
type ResourceInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource can't be created because you've reached the quota on the number of
// resources.
type ResourceLimitExceeded struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceLimitExceeded) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceLimitExceeded) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceLimitExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceLimitExceeded) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation can't be completed because the resource was not found.
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The service can't be created because a service with the same name already
// exists.
type ServiceAlreadyExists struct {
	Message *string

	ErrorCodeOverride *string

	CreatorRequestId *string
	ServiceId        *string

	noSmithyDocumentSerde
}

func (e *ServiceAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceAlreadyExists) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceAlreadyExists) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceAlreadyExists) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No service exists with the specified ID.
type ServiceNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The list of tags on the resource is over the quota. The maximum number of tags
// that can be applied to a resource is 50.
type TooManyTagsException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceName *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyTagsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTagsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
