/*
 *  
 *  $Id: procesarcalibrado.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-14 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/msgdlg.h>
#include <wx/app.h>

#include <string>
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <main/controllers/commandcontroller.h>
#include "procesarcalibrado.h"
#include "datospersistentescalibrado.h"
#include <main/entorno.h>
#include <iostream>

#include <commands/comandocalibrado.h>
#define ID_REFRESCO_PROGRESO 1

namespace GNC {
	namespace GUI {

		BEGIN_EVENT_TABLE(ProcesarCalibrado, ProcesarCalibradoBase)
		EVT_MENU(ID_REFRESCO_PROGRESO, ProcesarCalibrado::OnRefrescoProgreso)
		END_EVENT_TABLE()

		ProcesarCalibrado::ProcesarCalibrado(wxWindow* pParent,IWizard* pWizard, TipoWizardCalibrado* pDatosPersistentes):ProcesarCalibradoBase(pParent), IPasoWizard(pWizard)
		{
			m_pDatosPersistentes = pDatosPersistentes;
			m_Ok = false;
			m_pCmd = NULL;
		}

		ProcesarCalibrado::~ProcesarCalibrado()
		{
			if(m_pCmd != NULL){
/*				((GADAPI::ComandoCalibrado*)m_pCmd)->SetNotificadorProgresoAlternativo(NULL);
				GNC::Entorno::Instance()->GetCommandController()->AbortarComando(m_pCmd);*/
			}
			//m_Working = false;
			m_pDatosPersistentes = NULL;
			m_pCmd = NULL;
		}

		//region "Metodos heredados de Ipasowizard"
		bool ProcesarCalibrado::Attach(){
			m_pProgreso->SetValue(0);
			m_pLabelProgreso->SetLabel(wxEmptyString);
			m_Ok = false;
			m_pDatosPersistentes->m_Puntos.clear();
			return true;
		}

		bool ProcesarCalibrado::Detach(){
			return true;
		}

		std::string ProcesarCalibrado::GetTitle(){
			return std::string("Procesamiento de la imagen");
		}

		std::string ProcesarCalibrado::GetSubTitle(){
			return std::string("");
		}

		bool ProcesarCalibrado::Siguiente(){
			return true;
		}

		bool ProcesarCalibrado::Anterior(){
			return false;
		}

		bool ProcesarCalibrado::Cancelar(){
			return true;
		}

		bool ProcesarCalibrado::Validar(){
			//se lanza el comando...
/*			if(!m_Ok){
				try{
					GADAPI::ComandoCalibradoParams* pParam = new GADAPI::ComandoCalibradoParams(m_pDatosPersistentes->m_pImageData,m_pDatosPersistentes->m_slice,this);
					m_pCmd = new GADAPI::ComandoCalibrado(pParam);
					((GADAPI::ComandoCalibrado*)m_pCmd)->SetNotificadorProgresoAlternativo(this);
					GNC::Entorno::Instance()->GetCommandController()->ProcessAsync(std::string("Procesando calibracion automatica"),m_pCmd,NULL);
				}catch(GADAPI::CalibradoParamsException &ex){
					wxString message = wxString::FromUTF8(ex.GetMensage().c_str());
					wxMessageBox(message,wxT("Error al calibrar:"),wxOK | wxICON_INFORMATION, GNC::Entorno::Instance()->GetVentanaRaiz());
				}
			}
			m_pWizard->EnableAnterior(false);
			m_pWizard->EnableSiguiente(false);*/
			return m_Ok;
		}

		void ProcesarCalibrado::SetPuntosCalibrado(std::list<GNC::GUI::TPuntoCalibrado>& puntos)
		{
			m_pCmd = NULL;
			if(puntos.size() == 4){
				std::list<GNC::GUI::TPuntoCalibrado>::iterator it = puntos.begin();
				for (int i = 0; i < 4; i++)
					m_pDatosPersistentes->m_Puntos.push_back(*(it++));
			}
			m_Ok = true;
			SiguientePaso();
		}

		bool ProcesarCalibrado::NotificarProgreso(float progresoNormalizado, const std::string& texto) {
			if (m_pCmd->EstaAbortado())
			{
				return false;
			}
			LockProgreso();
			SetProgresoNormalizado(progresoNormalizado);
			SetTextoProgreso(texto);
			UnLockProgreso();

			wxCommandEvent evt(wxEVT_COMMAND_MENU_SELECTED, ID_REFRESCO_PROGRESO);
			this->GetEventHandler()->AddPendingEvent(evt);
			return true;
		}

		void ProcesarCalibrado::OnRefrescoProgreso(wxCommandEvent &){
			LockProgreso();
			m_pProgreso->SetValue((int)(GetProgresoNormalizado() * 100.0f));
			m_pLabelProgreso->SetLabel(wxString::FromUTF8(GetTextoProgreso().c_str()));
			UnLockProgreso();
		}
		//endregion
	}
}
