/*
 * $Id: dio24_loopback.c,v 1.16 2012-02-22 09:27:20 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "dio24_loopback.h"

struct cpssp {
	struct sig_std_logic_merge *forward_a0_b0;
	struct sig_std_logic_merge *forward_a1_b1;
	struct sig_std_logic_merge *forward_a2_b2;
	struct sig_std_logic_merge *forward_a3_b3;
	struct sig_std_logic_merge *forward_a4_b4;
	struct sig_std_logic_merge *forward_a5_b5;
	struct sig_std_logic_merge *forward_a6_b6;
	struct sig_std_logic_merge *forward_a7_b7;

	struct sig_std_logic_merge *forward_c0_c4;
	struct sig_std_logic_merge *forward_c1_c5;
	struct sig_std_logic_merge *forward_c2_c6;
	struct sig_std_logic_merge *forward_c3_c7;
};

void *
dio24_loopback_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_dio24 *port_dio24
)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_a0_b0 = sig_std_logic_merge(
			port_dio24->sig[0], port_dio24->sig[8]);
	cpssp->forward_a1_b1 = sig_std_logic_merge(
			port_dio24->sig[1], port_dio24->sig[9]);
	cpssp->forward_a2_b2 = sig_std_logic_merge(
			port_dio24->sig[2], port_dio24->sig[10]);
	cpssp->forward_a3_b3 = sig_std_logic_merge(
			port_dio24->sig[3], port_dio24->sig[11]);
	cpssp->forward_a4_b4 = sig_std_logic_merge(
			port_dio24->sig[4], port_dio24->sig[12]);
	cpssp->forward_a5_b5 = sig_std_logic_merge(
			port_dio24->sig[5], port_dio24->sig[13]);
	cpssp->forward_a6_b6 = sig_std_logic_merge(
			port_dio24->sig[6], port_dio24->sig[14]);
	cpssp->forward_a7_b7 = sig_std_logic_merge(
			port_dio24->sig[7], port_dio24->sig[15]);

	cpssp->forward_c0_c4 = sig_std_logic_merge(
			port_dio24->sig[16], port_dio24->sig[20]);
	cpssp->forward_c1_c5 = sig_std_logic_merge(
			port_dio24->sig[17], port_dio24->sig[21]);
	cpssp->forward_c2_c6 = sig_std_logic_merge(
			port_dio24->sig[18], port_dio24->sig[22]);
	cpssp->forward_c3_c7 = sig_std_logic_merge(
			port_dio24->sig[19], port_dio24->sig[23]);

	return cpssp;
}

void
dio24_loopback_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
dio24_loopback_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
dio24_loopback_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
