#include "data.h"
#include "var.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace core {

void Data::setf(const char* key, unsigned len, const char* val)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            level.l1     = strtol(val, nullptr, 10);
                            break;
                        case '2':
                            level.l2     = strtol(val, nullptr, 10);
                            break;
                        default: values.setf(key, val);
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            trange.p1    = strtol(val, nullptr, 10);
                            break;
                        case '2':
                            trange.p2    = strtol(val, nullptr, 10);
                            break;
                        default: values.setf(key, val);
                    }
                    break;
                default: values.setf(key, val);
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                { double dval = strtod(val, nullptr); station.coords.set_lat(dval); }
                            } else {
                                values.setf(key, val);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                { double dval = strtod(val, nullptr); station.coords.set_lon(dval); }
                            } else {
                                values.setf(key, val);
                            }
                            break;
                        default: values.setf(key, val);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        datetime.day    = strtol(val, nullptr, 10);
                    } else {
                        values.setf(key, val);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        datetime.minute = strtol(val, nullptr, 10);
                    } else {
                        values.setf(key, val);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        datetime.second = strtol(val, nullptr, 10);
                    } else {
                        values.setf(key, val);
                    }
                    break;
                default: values.setf(key, val);
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        datetime.year   = strtol(val, nullptr, 10);
                    } else {
                        values.setf(key, val);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        datetime.hour   = strtol(val, nullptr, 10);
                    } else {
                        values.setf(key, val);
                    }
                    break;
                default: values.setf(key, val);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        station.ident = val;
                    } else {
                        values.setf(key, val);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        datetime.month  = strtol(val, nullptr, 10);
                    } else {
                        values.setf(key, val);
                    }
                    break;
                default: values.setf(key, val);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        station.report = val;
                    } else {
                        values.setf(key, val);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        station.id = strtol(val, nullptr, 10);
                    } else {
                        values.setf(key, val);
                    }
                    break;
                default: values.setf(key, val);
            }
            break;
        case 8:
            if (memcmp(key + 0, "rep_memo", 8) == 0) {
                station.report = val;
            } else {
                values.setf(key, val);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                level.ltype1 = strtol(val, nullptr, 10);
                                break;
                            case '2':
                                level.ltype2 = strtol(val, nullptr, 10);
                                break;
                            default: values.setf(key, val);
                        }
                    } else {
                        values.setf(key, val);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        trange.pind  = strtol(val, nullptr, 10);
                    } else {
                        values.setf(key, val);
                    }
                    break;
                default: values.setf(key, val);
            }
            break;
        default: values.setf(key, val);
    }
}

}
}
