-- examples/simple-config-reader.lua
--
-- Simple configuration reader which interrogates only specific keys
--
-- Copyright 2012 Daniel Silverstone <dsilvers@digital-scurf.org>
--

clod = require "clod"

local configuration = [[
project.name "Clod"
project.head "refs/heads/master"
]]

conf, err = clod.parse(configuration)
if not conf then
   error(err)
end

print("Project name is", conf.settings["project.name"])
print("Project HEAD is", conf.settings.project.head)
print("Unknown entry is", conf.settings.project.isnil)
