*
* $Id: d106xx.F,v 1.1.1.1 1996/02/15 17:48:47 mclareni Exp $
*
* $Log: d106xx.F,v $
* Revision 1.1.1.1  1996/02/15 17:48:47  mclareni
* Kernlib
*
*
#include "kernnum/pilot.h"
      SUBROUTINE D106XX(MODE,F,A,B,N,X,W)
      EXTERNAL F
      LOGICAL MFLAG,RFLAG
      SAVE NW
      DIMENSION X(N),W(N)
C
C     ******************************************************************
C
C     MODE=1 ... SETS X(1) EQUAL TO THE INTEGRAL OF THE FUNCTION F OVER
C     THE INTERVAL (A,B) AS APPROXIMATED BY THE GAUSS-LEGENDRE QUADRAT-
C     URE FORMULA OF ORDER N.
C
C     MODE=2 ... STORES IN ARRAYS X AND W, RESPECTIVELY, THE ABSCISSAE
C     AND WEIGHTS FOR N-POINT GAUSS-LEGENDRE QUADRATURE OVER THE INTER-
C     VAL (A,B).
C
C     ******************************************************************
C
      DIMENSION KTAB(36),XT(273),WT(273)
C
C  TABLE OF INITIAL SUBSCRIPTS.
      DATA KTAB(2) /  1/
      DATA KTAB(3) /  2/
      DATA KTAB(4) /  4/
      DATA KTAB(5) /  6/
      DATA KTAB(6) /  9/
      DATA KTAB(7) / 12/
      DATA KTAB(8) / 16/
      DATA KTAB(9) / 20/
      DATA KTAB(10)/ 25/
      DATA KTAB(11)/ 30/
      DATA KTAB(12)/ 36/
      DATA KTAB(13)/ 42/
      DATA KTAB(14)/ 49/
      DATA KTAB(15)/ 56/
      DATA KTAB(16)/ 64/
      DATA KTAB(17)/ 72/
      DATA KTAB(18)/ 82/
      DATA KTAB(20)/ 94/
      DATA KTAB(22)/110/
      DATA KTAB(24)/130/
      DATA KTAB(28)/154/
      DATA KTAB(32)/186/
      DATA KTAB(36)/226/
C
C  TABLE OF ABSCISSAE X AND WEIGHTS W FOR INTERVAL (-1,+1).
C
#if defined(CERNLIB_NUMHIPRE)
C     (EACH DECIMAL CONSTANT HAS MAXIMUM CDC NO-DIAGNOSTIC PRECISION.)
C
C  N=2.
      DATA XT(1)  /5.7735026918963 E-01/, WT(1)  /1.00000000000000E+00/
C  N=3.
      DATA XT(2)  /7.7459666924148 E-01/, WT(2)  /5.5555555555556 E-01/
      DATA XT(3)  /0.                  /, WT(3)  /8.8888888888889 E-01/
C  N=4.
      DATA XT(4)  /8.6113631159405 E-01/, WT(4)  /3.4785484513745 E-01/
      DATA XT(5)  /3.3998104358486 E-01/, WT(5)  /6.5214515486255 E-01/
C  N=5.
      DATA XT(6)  /9.0617984593866 E-01/, WT(6)  /2.36926885056189E-01/
      DATA XT(7)  /5.3846931010568 E-01/, WT(7)  /4.7862867049937 E-01/
      DATA XT(8)  /0.                  /, WT(8)  /5.6888888888889 E-01/
C  N=6.
      DATA XT(9)  /9.3246951420315 E-01/, WT(9)  /1.71324492379170E-01/
      DATA XT(10) /6.6120938646626 E-01/, WT(10) /3.6076157304814 E-01/
      DATA XT(11) /2.38619186083197E-01/, WT(11) /4.6791393457269 E-01/
C  N=7.
      DATA XT(12) /9.4910791234276 E-01/, WT(12) /1.29484966168870E-01/
      DATA XT(13) /7.4153118559939 E-01/, WT(13) /2.79705391489277E-01/
      DATA XT(14) /4.0584515137740 E-01/, WT(14) /3.8183005050512 E-01/
      DATA XT(15) /0.                  /, WT(15) /4.1795918367347 E-01/
C  N=8.
      DATA XT(16) /9.6028985649754 E-01/, WT(16) /1.01228536290376E-01/
      DATA XT(17) /7.9666647741363 E-01/, WT(17) /2.22381034453374E-01/
      DATA XT(18) /5.2553240991633 E-01/, WT(18) /3.1370664587789 E-01/
      DATA XT(19) /1.83434642495650E-01/, WT(19) /3.6268378337836 E-01/
C  N=9.
      DATA XT(20) /9.6816023950763 E-01/, WT(20) /8.1274388361574 E-02/
      DATA XT(21) /8.3603110732664 E-01/, WT(21) /1.80648160694857E-01/
      DATA XT(22) /6.1337143270059 E-01/, WT(22) /2.60610696402935E-01/
      DATA XT(23) /3.2425342340381 E-01/, WT(23) /3.1234707704000 E-01/
      DATA XT(24) /0.                  /, WT(24) /3.3023935500126 E-01/
C  N=10.
      DATA XT(25) /9.7390652851717 E-01/, WT(25) /6.6671344308688 E-02/
      DATA XT(26) /8.6506336668898 E-01/, WT(26) /1.49451349150581E-01/
      DATA XT(27) /6.7940956829902 E-01/, WT(27) /2.19086362515982E-01/
      DATA XT(28) /4.3339539412925 E-01/, WT(28) /2.69266719309996E-01/
      DATA XT(29) /1.48874338981631E-01/, WT(29) /2.9552422471475 E-01/
C  N=11.
      DATA XT(30) /9.7822865814606 E-01/, WT(30) /5.5668567116174 E-02/
      DATA XT(31) /8.8706259976810 E-01/, WT(31) /1.25580369464905E-01/
      DATA XT(32) /7.3015200557405 E-01/, WT(32) /1.86290210927734E-01/
      DATA XT(33) /5.1909612920681 E-01/, WT(33) /2.33193764591990E-01/
      DATA XT(34) /2.69543155952345E-01/, WT(34) /2.62804544510247E-01/
      DATA XT(35) /0.                  /, WT(35) /2.72925086777901E-01/
C  N=12.
      DATA XT(36) /9.8156063424672 E-01/, WT(36) /4.7175336386512 E-02/
      DATA XT(37) /9.0411725637047 E-01/, WT(37) /1.06939325995318E-01/
      DATA XT(38) /7.6990267419430 E-01/, WT(38) /1.60078328543346E-01/
      DATA XT(39) /5.8731795428662 E-01/, WT(39) /2.03167426723066E-01/
      DATA XT(40) /3.6783149899818 E-01/, WT(40) /2.33492536538355E-01/
      DATA XT(41) /1.25233408511469E-01/, WT(41) /2.49147045813403E-01/
C  N=13.
      DATA XT(42) /9.8418305471859 E-01/, WT(42) /4.0484004765316 E-02/
      DATA XT(43) /9.1759839922298 E-01/, WT(43) /9.2121499837728 E-02/
      DATA XT(44) /8.0157809073331 E-01/, WT(44) /1.38873510219787E-01/
      DATA XT(45) /6.4234933944034 E-01/, WT(45) /1.78145980761946E-01/
      DATA XT(46) /4.4849275103645 E-01/, WT(46) /2.07816047536889E-01/
      DATA XT(47) /2.30458315955135E-01/, WT(47) /2.26283180262897E-01/
      DATA XT(48) /0.                  /, WT(48) /2.32551553230874E-01/
C  N=14.
      DATA XT(49) /9.8628380869681 E-01/, WT(49) /3.5119460331752 E-02/
      DATA XT(50) /9.2843488366357 E-01/, WT(50) /8.0158087159760 E-02/
      DATA XT(51) /8.2720131506976 E-01/, WT(51) /1.21518570687903E-01/
      DATA XT(52) /6.8729290481169 E-01/, WT(52) /1.57203167158194E-01/
      DATA XT(53) /5.1524863635815 E-01/, WT(53) /1.85538397477938E-01/
      DATA XT(54) /3.1911236892789 E-01/, WT(54) /2.05198463721296E-01/
      DATA XT(55) /1.08054948707344E-01/, WT(55) /2.15263853463158E-01/
C  N=15.
      DATA XT(56) /9.8799251802049 E-01/, WT(56) /3.0753241996117 E-02/
      DATA XT(57) /9.3727339240071 E-01/, WT(57) /7.0366047488108 E-02/
      DATA XT(58) /8.4820658341043 E-01/, WT(58) /1.07159220467172E-01/
      DATA XT(59) /7.2441773136017 E-01/, WT(59) /1.39570677926154E-01/
      DATA XT(60) /5.7097217260854 E-01/, WT(60) /1.66269205816994E-01/
      DATA XT(61) /3.9415134707756 E-01/, WT(61) /1.86161000015562E-01/
      DATA XT(62) /2.01194093997435E-01/, WT(62) /1.98431485327112E-01/
      DATA XT(63) /0.                  /, WT(63) /2.02578241925561E-01/
C  N=16.
      DATA XT(64) /9.8940093499165 E-01/, WT(64) /2.71524594117541E-02/
      DATA XT(65) /9.4457502307323 E-01/, WT(65) /6.2253523938648 E-02/
      DATA XT(66) /8.6563120238783 E-01/, WT(66) /9.5158511682493 E-02/
      DATA XT(67) /7.5540440835500 E-01/, WT(67) /1.24628971255534E-01/
      DATA XT(68) /6.1787624440264 E-01/, WT(68) /1.49595988816577E-01/
      DATA XT(69) /4.5801677765723 E-01/, WT(69) /1.69156519395003E-01/
      DATA XT(70) /2.8160355077926 E-01/, WT(70) /1.82603415044924E-01/
      DATA XT(71) /9.5012509837637 E-02/, WT(71) /1.89450610455068E-01/
C  N=20.
      DATA XT(72) /9.9312859918509 E-01/, WT(72) /1.76140071391521E-02/
      DATA XT(73) /9.6397192727791 E-01/, WT(73) /4.0601429800387 E-02/
      DATA XT(74) /9.1223442825133 E-01/, WT(74) /6.2672048334109 E-02/
      DATA XT(75) /8.3911697182222 E-01/, WT(75) /8.3276741576705 E-02/
      DATA XT(76) /7.4633190646015 E-01/, WT(76) /1.01930119817240E-01/
      DATA XT(77) /6.3605368072652 E-01/, WT(77) /1.18194531961518E-01/
      DATA XT(78) /5.1086700195083 E-01/, WT(78) /1.31688638449177E-01/
      DATA XT(79) /3.7370608871542 E-01/, WT(79) /1.42096109318382E-01/
      DATA XT(80) /2.27785851141645E-01/, WT(80) /1.49172986472604E-01/
      DATA XT(81) /7.6526521133497 E-02/, WT(81) /1.52753387130726E-01/
C  N=24.
      DATA XT(82) /9.9518721999702 E-01/, WT(82) /1.23412297999872E-02/
      DATA XT(83) /9.7472855597131 E-01/, WT(83) /2.8531388628934 E-02/
      DATA XT(84) /9.3827455200273 E-01/, WT(84) /4.4277438817420 E-02/
      DATA XT(85) /8.8641552700440 E-01/, WT(85) /5.9298584915437 E-02/
      DATA XT(86) /8.2000198597390 E-01/, WT(86) /7.3346481411080 E-02/
      DATA XT(87) /7.4012419157855 E-01/, WT(87) /8.6190161531953 E-02/
      DATA XT(88) /6.4809365193698 E-01/, WT(88) /9.7618652104114 E-02/
      DATA XT(89) /5.4542147138884 E-01/, WT(89) /1.07444270115966E-01/
      DATA XT(90) /4.3379350762605 E-01/, WT(90) /1.15505668053726E-01/
      DATA XT(91) /3.1504267969616 E-01/, WT(91) /1.21670472927803E-01/
      DATA XT(92) /1.91118867473616E-01/, WT(92) /1.25837456346828E-01/
      DATA XT(93) /6.4056892862606 E-02/, WT(93) /1.27938195346752E-01/
C  N=32.
      DATA XT(94) /9.9726386184948 E-01/, WT(94) /7.0186100094701 E-03/
      DATA XT(95) /9.8561151154527 E-01/, WT(95) /1.62743947309057E-02/
      DATA XT(96) /9.6476225558751 E-01/, WT(96) /2.53920653092621E-02/
      DATA XT(97) /9.3490607593774 E-01/, WT(97) /3.4273862913021 E-02/
      DATA XT(98) /8.9632115576605 E-01/, WT(98) /4.2835898022227 E-02/
      DATA XT(99) /8.4936761373257 E-01/, WT(99) /5.0998059262376 E-02/
      DATA XT(100)/7.9448379596794 E-01/, WT(100)/5.8684093478536 E-02/
      DATA XT(101)/7.3218211874029 E-01/, WT(101)/6.5822222776362 E-02/
      DATA XT(102)/6.6304426693022 E-01/, WT(102)/7.2345794108849 E-02/
      DATA XT(103)/5.8771575724076 E-01/, WT(103)/7.8193895787070 E-02/
      DATA XT(104)/5.0689990893223 E-01/, WT(104)/8.3311924226947 E-02/
      DATA XT(105)/4.2135127613064 E-01/, WT(105)/8.7652093004404 E-02/
      DATA XT(106)/3.3186860228213 E-01/, WT(106)/9.1173878695764 E-02/
      DATA XT(107)/2.39287362252137E-01/, WT(107)/9.3844399080805 E-02/
      DATA XT(108)/1.44471961582796E-01/, WT(108)/9.5638720079275 E-02/
      DATA XT(109)/4.8307665687738 E-02/, WT(109)/9.6540088514728 E-02/
C  N=40.
      DATA XT(110)/9.9823770971056 E-01/, WT(110)/4.5212770985332 E-03/
      DATA XT(111)/9.9072623869946 E-01/, WT(111)/1.04982845311528E-02/
      DATA XT(112)/9.7725994998377 E-01/, WT(112)/1.64210583819079E-02/
      DATA XT(113)/9.5791681921379 E-01/, WT(113)/2.22458491941670E-02/
      DATA XT(114)/9.3281280827868 E-01/, WT(114)/2.79370069800234E-02/
      DATA XT(115)/9.0209880696887 E-01/, WT(115)/3.3460195282548 E-02/
      DATA XT(116)/8.6595950321226 E-01/, WT(116)/3.8782167974472 E-02/
      DATA XT(117)/8.2461223083331 E-01/, WT(117)/4.3870908185673 E-02/
      DATA XT(118)/7.7830565142652 E-01/, WT(118)/4.8695807635072 E-02/
      DATA XT(119)/7.2731825518993 E-01/, WT(119)/5.3227846983937 E-02/
      DATA XT(120)/6.7195668461418 E-01/, WT(120)/5.7439769099392 E-02/
      DATA XT(121)/6.1255388966798 E-01/, WT(121)/6.1306242492929 E-02/
      DATA XT(122)/5.4946712509513 E-01/, WT(122)/6.4804013456601 E-02/
      DATA XT(123)/4.8307580168618 E-01/, WT(123)/6.7912045815234 E-02/
      DATA XT(124)/4.1377920437161 E-01/, WT(124)/7.0611647391287 E-02/
      DATA XT(125)/3.4199409082576 E-01/, WT(125)/7.2886582395804 E-02/
      DATA XT(126)/2.68152185007254E-01/, WT(126)/7.4723169057968 E-02/
      DATA XT(127)/1.92697580701371E-01/, WT(127)/7.6110361900626 E-02/
      DATA XT(128)/1.16084070675255E-01/, WT(128)/7.7039818164248 E-02/
      DATA XT(129)/3.8772417506051 E-02/, WT(129)/7.7505947978425 E-02/
C  N=48.
      DATA XT(130)/9.9877100725243 E-01/, WT(130)/3.1533460523058 E-03/
      DATA XT(131)/9.9353017226635 E-01/, WT(131)/7.3275539012763 E-03/
      DATA XT(132)/9.8412458372283 E-01/, WT(132)/1.14772345792345E-02/
      DATA XT(133)/9.7059159254625 E-01/, WT(133)/1.55793157229438E-02/
      DATA XT(134)/9.5298770316043 E-01/, WT(134)/1.96161604573555E-02/
      DATA XT(135)/9.3138669070655 E-01/, WT(135)/2.35707608393244E-02/
      DATA XT(136)/9.0587913671557 E-01/, WT(136)/2.74265097083569E-02/
      DATA XT(137)/8.7657202027425 E-01/, WT(137)/3.1167227832798 E-02/
      DATA XT(138)/8.4358826162439 E-01/, WT(138)/3.4777222564770 E-02/
      DATA XT(139)/8.0706620402944 E-01/, WT(139)/3.8241351065831 E-02/
      DATA XT(140)/7.6715903251574 E-01/, WT(140)/4.1545082943465 E-02/
      DATA XT(141)/7.2403413092381 E-01/, WT(141)/4.4674560856694 E-02/
      DATA XT(142)/6.7787237963266 E-01/, WT(142)/4.7616658492490 E-02/
      DATA XT(143)/6.2886739677651 E-01/, WT(143)/5.0359035553854 E-02/
      DATA XT(144)/5.7722472608397 E-01/, WT(144)/5.2890189485194 E-02/
      DATA XT(145)/5.2316097472223 E-01/, WT(145)/5.5199503699984 E-02/
      DATA XT(146)/4.6690290475096 E-01/, WT(146)/5.7277292100403 E-02/
      DATA XT(147)/4.0868648199072 E-01/, WT(147)/5.9114839698396 E-02/
      DATA XT(148)/3.4875588629216 E-01/, WT(148)/6.0704439165894 E-02/
      DATA XT(149)/2.8736248735546 E-01/, WT(149)/6.2039423159893 E-02/
      DATA XT(150)/2.24763790394689E-01/, WT(150)/6.3114192286254 E-02/
      DATA XT(151)/1.61222356068892E-01/, WT(151)/6.3924238584648 E-02/
      DATA XT(152)/9.7004699209463 E-02/, WT(152)/6.4466164435950 E-02/
      DATA XT(153)/3.2380170962869 E-02/, WT(153)/6.4737696812684 E-02/
C  N=64.
      DATA XT(154)/9.9930504173577 E-01/, WT(154)/1.78328072169643E-03/
      DATA XT(155)/9.9634011677196 E-01/, WT(155)/4.1470332605625 E-03/
      DATA XT(156)/9.9101337147674 E-01/, WT(156)/6.5044579689784 E-03/
      DATA XT(157)/9.8333625388463 E-01/, WT(157)/8.8467598263639 E-03/
      DATA XT(158)/9.7332682778991 E-01/, WT(158)/1.11681394601311E-02/
      DATA XT(159)/9.6100879965205 E-01/, WT(159)/1.34630478967186E-02/
      DATA XT(160)/9.4641137485840 E-01/, WT(160)/1.57260304760247E-02/
      DATA XT(161)/9.2956917213194 E-01/, WT(161)/1.79517157756973E-02/
      DATA XT(162)/9.1052213707850 E-01/, WT(162)/2.01348231535302E-02/
      DATA XT(163)/8.8931544599511 E-01/, WT(163)/2.22701738083833E-02/
      DATA XT(164)/8.6599939815409 E-01/, WT(164)/2.43527025687109E-02/
      DATA XT(165)/8.4062929625258 E-01/, WT(165)/2.63774697150547E-02/
      DATA XT(166)/8.1326531512280 E-01/, WT(166)/2.8339672614259 E-02/
      DATA XT(167)/7.8397235894334 E-01/, WT(167)/3.0234657072402 E-02/
      DATA XT(168)/7.5281990726053 E-01/, WT(168)/3.2057928354852 E-02/
      DATA XT(169)/7.1988185017161 E-01/, WT(169)/3.3805161837142 E-02/
      DATA XT(170)/6.8523631305423 E-01/, WT(170)/3.5472213256882 E-02/
      DATA XT(171)/6.4896547125466 E-01/, WT(171)/3.7055128540240 E-02/
      DATA XT(172)/6.1115535517239 E-01/, WT(172)/3.8550153178616 E-02/
      DATA XT(173)/5.7189564620263 E-01/, WT(173)/3.9953741132720 E-02/
      DATA XT(174)/5.3127946401989 E-01/, WT(174)/4.1262563242624 E-02/
      DATA XT(175)/4.8940314570705 E-01/, WT(175)/4.2473515123654 E-02/
      DATA XT(176)/4.4636601725346 E-01/, WT(176)/4.3583724529323 E-02/
      DATA XT(177)/4.0227015796399 E-01/, WT(177)/4.4590558163757 E-02/
      DATA XT(178)/3.5722015833767 E-01/, WT(178)/4.5491627927418 E-02/
      DATA XT(179)/3.1132287199021 E-01/, WT(179)/4.6284796581314 E-02/
      DATA XT(180)/2.64687162208767E-01/, WT(180)/4.6968182816210 E-02/
      DATA XT(181)/2.17423643740007E-01/, WT(181)/4.7540165714830 E-02/
      DATA XT(182)/1.69644420423993E-01/, WT(182)/4.7999388596458 E-02/
      DATA XT(183)/1.21462819296121E-01/, WT(183)/4.8344762234803 E-02/
      DATA XT(184)/7.2993121787799 E-02/, WT(184)/4.8575467441503 E-02/
      DATA XT(185)/2.43502926634244E-02/, WT(185)/4.8690957009140 E-02/
C  N=80.
      DATA XT(186)/9.9955382265163 E-01/, WT(186)/1.14495000318694E-03/
      DATA XT(187)/9.9764986439824 E-01/, WT(187)/2.66353358951268E-03/
      DATA XT(188)/9.9422754096569 E-01/, WT(188)/4.1803131246949 E-03/
      DATA XT(189)/9.8929130249976 E-01/, WT(189)/5.6909224514032 E-03/
      DATA XT(190)/9.8284857273863 E-01/, WT(190)/7.1929047681173 E-03/
      DATA XT(191)/9.7490914058573 E-01/, WT(191)/8.6839452692609 E-03/
      DATA XT(192)/9.6548508904380 E-01/, WT(192)/1.01617660411031E-02/
      DATA XT(193)/9.5459076634363 E-01/, WT(193)/1.16241141207978E-02/
      DATA XT(194)/9.4224276130987 E-01/, WT(194)/1.30687615924013E-02/
      DATA XT(195)/9.2845987717245 E-01/, WT(195)/1.44935080405091E-02/
      DATA XT(196)/9.1326310257176 E-01/, WT(196)/1.58961835837257E-02/
      DATA XT(197)/8.9667557943877 E-01/, WT(197)/1.72746520562693E-02/
      DATA XT(198)/8.7872256767821 E-01/, WT(198)/1.86268142082990E-02/
      DATA XT(199)/8.5943140666311 E-01/, WT(199)/1.99506108781420E-02/
      DATA XT(200)/8.3883147358026 E-01/, WT(200)/2.12440261157821E-02/
      DATA XT(201)/8.1695413868146 E-01/, WT(201)/2.25050902463325E-02/
      DATA XT(202)/7.9383271750461 E-01/, WT(202)/2.37318828659301E-02/
      DATA XT(203)/7.6950242013504 E-01/, WT(203)/2.49225357641155E-02/
      DATA XT(204)/7.4400029758360 E-01/, WT(204)/2.60752357675651E-02/
      DATA XT(205)/7.1736518536210 E-01/, WT(205)/2.71882275004864E-02/
      DATA XT(206)/6.8963764434203 E-01/, WT(206)/2.8259816057277 E-02/
      DATA XT(207)/6.6085989898612 E-01/, WT(207)/2.9288369583268 E-02/
      DATA XT(208)/6.3107577304687 E-01/, WT(208)/3.0272321759558 E-02/
      DATA XT(209)/6.0033062282975 E-01/, WT(209)/3.1210174188115 E-02/
      DATA XT(210)/5.6867126812271 E-01/, WT(210)/3.2100498673488 E-02/
      DATA XT(211)/5.3614592089713 E-01/, WT(211)/3.2941939397645 E-02/
      DATA XT(212)/5.0280411188878 E-01/, WT(212)/3.3733214984612 E-02/
      DATA XT(213)/4.6869661517054 E-01/, WT(213)/3.4473120451754 E-02/
      DATA XT(214)/4.3387537083176 E-01/, WT(214)/3.5160529044748 E-02/
      DATA XT(215)/3.9839340588197 E-01/, WT(215)/3.5794393953416 E-02/
      DATA XT(216)/3.6230475349949 E-01/, WT(216)/3.6373749905836 E-02/
      DATA XT(217)/3.2566437074770 E-01/, WT(217)/3.6897714638276 E-02/
      DATA XT(218)/2.8852805488451 E-01/, WT(218)/3.7365490238730 E-02/
      DATA XT(219)/2.50952358392272E-01/, WT(219)/3.7776364362001 E-02/
      DATA XT(220)/2.12994502857666E-01/, WT(220)/3.8129711314478 E-02/
      DATA XT(221)/1.74712291832647E-01/, WT(221)/3.8424993006959 E-02/
      DATA XT(222)/1.36164022809144E-01/, WT(222)/3.8661759774076 E-02/
      DATA XT(223)/9.7408398441585 E-02/, WT(223)/3.8839651059052 E-02/
      DATA XT(224)/5.8504437152421 E-02/, WT(224)/3.8958395962770 E-02/
      DATA XT(225)/1.95113832567940E-02/, WT(225)/3.9017813656307 E-02/
C  N=96.
      DATA XT(226)/9.9968950388323 E-01/, WT(226)/7.9679206555201 E-04/
      DATA XT(227)/9.9836437586318 E-01/, WT(227)/1.85396078894692E-03/
      DATA XT(228)/9.9598184298721 E-01/, WT(228)/2.9107318179349 E-03/
      DATA XT(229)/9.9254390032376 E-01/, WT(229)/3.9645543384447 E-03/
      DATA XT(230)/9.8805412632962 E-01/, WT(230)/5.0142027429275 E-03/
      DATA XT(231)/9.8251726356301 E-01/, WT(231)/6.0585455042360 E-03/
      DATA XT(232)/9.7593917458514 E-01/, WT(232)/7.0964707911539 E-03/
      DATA XT(233)/9.6832682846326 E-01/, WT(233)/8.1268769256988 E-03/
      DATA XT(234)/9.5968829144874 E-01/, WT(234)/9.1486712307834 E-03/
      DATA XT(235)/9.5003271778444 E-01/, WT(235)/1.01607705350084E-02/
      DATA XT(236)/9.3937033975276 E-01/, WT(236)/1.11621020998385E-02/
      DATA XT(237)/9.2771245672231 E-01/, WT(237)/1.21516046710883E-02/
      DATA XT(238)/9.1507142312090 E-01/, WT(238)/1.31282295669616E-02/
      DATA XT(239)/9.0146063531585 E-01/, WT(239)/1.40909417723149E-02/
      DATA XT(240)/8.8689451740242 E-01/, WT(240)/1.50387210269949E-02/
      DATA XT(241)/8.7138850590930 E-01/, WT(241)/1.59705629025623E-02/
      DATA XT(242)/8.5495903343460 E-01/, WT(242)/1.68854798642452E-02/
      DATA XT(243)/8.3762351122819 E-01/, WT(243)/1.77825023160453E-02/
      DATA XT(244)/8.1940031073793 E-01/, WT(244)/1.86606796274115E-02/
      DATA XT(245)/8.0030874413914 E-01/, WT(245)/1.95190811401450E-02/
      DATA XT(246)/7.8036904386743 E-01/, WT(246)/2.03567971543333E-02/
      DATA XT(247)/7.5960234117665 E-01/, WT(247)/2.11729398921913E-02/
      DATA XT(248)/7.3803064374440 E-01/, WT(248)/2.19666444387443E-02/
      DATA XT(249)/7.1567681234897 E-01/, WT(249)/2.27370696583294E-02/
      DATA XT(250)/6.9256453664217 E-01/, WT(250)/2.34833990859262E-02/
      DATA XT(251)/6.6871831004392 E-01/, WT(251)/2.42048417923647E-02/
      DATA XT(252)/6.4416340378497 E-01/, WT(252)/2.49006332224836E-02/
      DATA XT(253)/6.1892584012547 E-01/, WT(253)/2.55700360053494E-02/
      DATA XT(254)/5.9303236477757 E-01/, WT(254)/2.62123407356724E-02/
      DATA XT(255)/5.6651041856140 E-01/, WT(255)/2.68268667255918E-02/
      DATA XT(256)/5.3938810832436 E-01/, WT(256)/2.74129627260292E-02/
      DATA XT(257)/5.1169417715467 E-01/, WT(257)/2.79700076168483E-02/
      DATA XT(258)/4.8345797392060 E-01/, WT(258)/2.8497411065085 E-02/
      DATA XT(259)/4.5470942216774 E-01/, WT(259)/2.8994614150555 E-02/
      DATA XT(260)/4.2547898840730 E-01/, WT(260)/2.9461089958168 E-02/
      DATA XT(261)/3.9579764982891 E-01/, WT(261)/2.9896344136328 E-02/
      DATA XT(262)/3.6569686147231 E-01/, WT(262)/3.0299915420828 E-02/
      DATA XT(263)/3.3520852289263 E-01/, WT(263)/3.0671376123669 E-02/
      DATA XT(264)/3.0436494435450 E-01/, WT(264)/3.1010332586314 E-02/
      DATA XT(265)/2.73198812591049E-01/, WT(265)/3.1316425596861 E-02/
      DATA XT(266)/2.41743156163840E-01/, WT(266)/3.1589330770727 E-02/
      DATA XT(267)/2.10031310460567E-01/, WT(267)/3.1828758894411 E-02/
      DATA XT(268)/1.78096882367619E-01/, WT(268)/3.2034456231993 E-02/
      DATA XT(269)/1.45973714654897E-01/, WT(269)/3.2206204794030 E-02/
      DATA XT(270)/1.13695850110666E-01/, WT(270)/3.2343822568576 E-02/
      DATA XT(271)/8.1297495464426 E-02/, WT(271)/3.2447163714064 E-02/
      DATA XT(272)/4.8812985136050 E-02/, WT(272)/3.2516118713869 E-02/
      DATA XT(273)/1.62767448496030E-02/, WT(273)/3.2550614492363 E-02/
#endif
#if defined(CERNLIB_NUMLOPRE)
C  N=2.
      DATA XT(1)  /5.77350269E-01/, WT(1)  /1.00000000E+00/
C  N=3.
      DATA XT(2)  /7.74596669E-01/, WT(2)  /5.55555556E-01/
      DATA XT(3)  /0.            /, WT(3)  /8.88888889E-01/
C  N=4.
      DATA XT(4)  /8.61136312E-01/, WT(4)  /3.47854845E-01/
      DATA XT(5)  /3.39981044E-01/, WT(5)  /6.52145155E-01/
C  N=5.
      DATA XT(6)  /9.06179846E-01/, WT(6)  /2.36926885E-01/
      DATA XT(7)  /5.38469310E-01/, WT(7)  /4.78628670E-01/
      DATA XT(8)  /0.            /, WT(8)  /5.68888889E-01/
C  N=6.
      DATA XT(9)  /9.32469514E-01/, WT(9)  /1.71324492E-01/
      DATA XT(10) /6.61209386E-01/, WT(10) /3.60761573E-01/
      DATA XT(11) /2.38619186E-01/, WT(11) /4.67913935E-01/
C  N=7.
      DATA XT(12) /9.49107912E-01/, WT(12) /1.29484966E-01/
      DATA XT(13) /7.41531186E-01/, WT(13) /2.79705391E-01/
      DATA XT(14) /4.05845151E-01/, WT(14) /3.81830051E-01/
      DATA XT(15) /0.            /, WT(15) /4.17959184E-01/
C  N=8.
      DATA XT(16) /9.60289856E-01/, WT(16) /1.01228536E-01/
      DATA XT(17) /7.96666477E-01/, WT(17) /2.22381034E-01/
      DATA XT(18) /5.25532410E-01/, WT(18) /3.13706646E-01/
      DATA XT(19) /1.83434642E-01/, WT(19) /3.62683783E-01/
C  N=9.
      DATA XT(20) /9.68160240E-01/, WT(20) /8.12743884E-02/
      DATA XT(21) /8.36031107E-01/, WT(21) /1.80648161E-01/
      DATA XT(22) /6.13371433E-01/, WT(22) /2.60610696E-01/
      DATA XT(23) /3.24253423E-01/, WT(23) /3.12347077E-01/
      DATA XT(24) /0.            /, WT(24) /3.30239355E-01/
C  N=10.
      DATA XT(25) /9.73906529E-01/, WT(25) /6.66713443E-02/
      DATA XT(26) /8.65063367E-01/, WT(26) /1.49451349E-01/
      DATA XT(27) /6.79409568E-01/, WT(27) /2.19086363E-01/
      DATA XT(28) /4.33395394E-01/, WT(28) /2.69266719E-01/
      DATA XT(29) /1.48874339E-01/, WT(29) /2.95524225E-01/
C  N=11.
      DATA XT(30) /9.78228658E-01/, WT(30) /5.56685671E-02/
      DATA XT(31) /8.87062600E-01/, WT(31) /1.25580369E-01/
      DATA XT(32) /7.30152006E-01/, WT(32) /1.86290211E-01/
      DATA XT(33) /5.19096129E-01/, WT(33) /2.33193765E-01/
      DATA XT(34) /2.69543156E-01/, WT(34) /2.62804545E-01/
      DATA XT(35) /0.            /, WT(35) /2.72925087E-01/
C  N=12.
      DATA XT(36) /9.81560634E-01/, WT(36) /4.71753364E-02/
      DATA XT(37) /9.04117256E-01/, WT(37) /1.06939326E-01/
      DATA XT(38) /7.69902674E-01/, WT(38) /1.60078329E-01/
      DATA XT(39) /5.87317954E-01/, WT(39) /2.03167427E-01/
      DATA XT(40) /3.67831499E-01/, WT(40) /2.33492537E-01/
      DATA XT(41) /1.25233409E-01/, WT(41) /2.49147046E-01/
C  N=13.
      DATA XT(42) /9.84183055E-01/, WT(42) /4.04840048E-02/
      DATA XT(43) /9.17598399E-01/, WT(43) /9.21214998E-02/
      DATA XT(44) /8.01578091E-01/, WT(44) /1.38873510E-01/
      DATA XT(45) /6.42349339E-01/, WT(45) /1.78145981E-01/
      DATA XT(46) /4.48492751E-01/, WT(46) /2.07816048E-01/
      DATA XT(47) /2.30458316E-01/, WT(47) /2.26283180E-01/
      DATA XT(48) /0.            /, WT(48) /2.32551553E-01/
C  N=14.
      DATA XT(49) /9.86283809E-01/, WT(49) /3.51194603E-02/
      DATA XT(50) /9.28434884E-01/, WT(50) /8.01580872E-02/
      DATA XT(51) /8.27201315E-01/, WT(51) /1.21518571E-01/
      DATA XT(52) /6.87292905E-01/, WT(52) /1.57203167E-01/
      DATA XT(53) /5.15248636E-01/, WT(53) /1.85538397E-01/
      DATA XT(54) /3.19112369E-01/, WT(54) /2.05198464E-01/
      DATA XT(55) /1.08054949E-01/, WT(55) /2.15263853E-01/
C  N=15.
      DATA XT(56) /9.87992518E-01/, WT(56) /3.07532420E-02/
      DATA XT(57) /9.37273392E-01/, WT(57) /7.03660475E-02/
      DATA XT(58) /8.48206583E-01/, WT(58) /1.07159220E-01/
      DATA XT(59) /7.24417731E-01/, WT(59) /1.39570678E-01/
      DATA XT(60) /5.70972173E-01/, WT(60) /1.66269206E-01/
      DATA XT(61) /3.94151347E-01/, WT(61) /1.86161000E-01/
      DATA XT(62) /2.01194094E-01/, WT(62) /1.98431485E-01/
      DATA XT(63) /0.            /, WT(63) /2.02578242E-01/
C  N=16.
      DATA XT(64) /9.89400935E-01/, WT(64) /2.71524594E-02/
      DATA XT(65) /9.44575023E-01/, WT(65) /6.22535239E-02/
      DATA XT(66) /8.65631202E-01/, WT(66) /9.51585117E-02/
      DATA XT(67) /7.55404408E-01/, WT(67) /1.24628971E-01/
      DATA XT(68) /6.17876244E-01/, WT(68) /1.49595989E-01/
      DATA XT(69) /4.58016778E-01/, WT(69) /1.69156519E-01/
      DATA XT(70) /2.81603551E-01/, WT(70) /1.82603415E-01/
      DATA XT(71) /9.50125098E-02/, WT(71) /1.89450610E-01/
C  N=20.
      DATA XT(72) /9.93128599E-01/, WT(72) /1.76140071E-02/
      DATA XT(73) /9.63971927E-01/, WT(73) /4.06014298E-02/
      DATA XT(74) /9.12234428E-01/, WT(74) /6.26720483E-02/
      DATA XT(75) /8.39116972E-01/, WT(75) /8.32767416E-02/
      DATA XT(76) /7.46331906E-01/, WT(76) /1.01930120E-01/
      DATA XT(77) /6.36053681E-01/, WT(77) /1.18194532E-01/
      DATA XT(78) /5.10867002E-01/, WT(78) /1.31688638E-01/
      DATA XT(79) /3.73706089E-01/, WT(79) /1.42096109E-01/
      DATA XT(80) /2.27785851E-01/, WT(80) /1.49172986E-01/
      DATA XT(81) /7.65265211E-02/, WT(81) /1.52753387E-01/
C  N=24.
      DATA XT(82) /9.95187220E-01/, WT(82) /1.23412298E-02/
      DATA XT(83) /9.74728556E-01/, WT(83) /2.85313886E-02/
      DATA XT(84) /9.38274552E-01/, WT(84) /4.42774388E-02/
      DATA XT(85) /8.86415527E-01/, WT(85) /5.92985849E-02/
      DATA XT(86) /8.20001986E-01/, WT(86) /7.33464814E-02/
      DATA XT(87) /7.40124192E-01/, WT(87) /8.61901615E-02/
      DATA XT(88) /6.48093652E-01/, WT(88) /9.76186521E-02/
      DATA XT(89) /5.45421471E-01/, WT(89) /1.07444270E-01/
      DATA XT(90) /4.33793508E-01/, WT(90) /1.15505668E-01/
      DATA XT(91) /3.15042680E-01/, WT(91) /1.21670473E-01/
      DATA XT(92) /1.91118867E-01/, WT(92) /1.25837456E-01/
      DATA XT(93) /6.40568929E-02/, WT(93) /1.27938195E-01/
C  N=32.
      DATA XT(94) /9.97263862E-01/, WT(94) /7.01861001E-03/
      DATA XT(95) /9.85611512E-01/, WT(95) /1.62743947E-02/
      DATA XT(96) /9.64762256E-01/, WT(96) /2.53920653E-02/
      DATA XT(97) /9.34906076E-01/, WT(97) /3.42738629E-02/
      DATA XT(98) /8.96321156E-01/, WT(98) /4.28358980E-02/
      DATA XT(99) /8.49367614E-01/, WT(99) /5.09980593E-02/
      DATA XT(100)/7.94483796E-01/, WT(100)/5.86840935E-02/
      DATA XT(101)/7.32182119E-01/, WT(101)/6.58222228E-02/
      DATA XT(102)/6.63044267E-01/, WT(102)/7.23457941E-02/
      DATA XT(103)/5.87715757E-01/, WT(103)/7.81938958E-02/
      DATA XT(104)/5.06899909E-01/, WT(104)/8.33119242E-02/
      DATA XT(105)/4.21351276E-01/, WT(105)/8.76520930E-02/
      DATA XT(106)/3.31868602E-01/, WT(106)/9.11738787E-02/
      DATA XT(107)/2.39287362E-01/, WT(107)/9.38443991E-02/
      DATA XT(108)/1.44471962E-01/, WT(108)/9.56387201E-02/
      DATA XT(109)/4.83076657E-02/, WT(109)/9.65400885E-02/
C  N=40.
      DATA XT(110)/9.98237710E-01/, WT(110)/4.52127710E-03/
      DATA XT(111)/9.90726239E-01/, WT(111)/1.04982845E-02/
      DATA XT(112)/9.77259950E-01/, WT(112)/1.64210584E-02/
      DATA XT(113)/9.57916819E-01/, WT(113)/2.22458492E-02/
      DATA XT(114)/9.32812808E-01/, WT(114)/2.79370070E-02/
      DATA XT(115)/9.02098807E-01/, WT(115)/3.34601953E-02/
      DATA XT(116)/8.65959503E-01/, WT(116)/3.87821680E-02/
      DATA XT(117)/8.24612231E-01/, WT(117)/4.38709082E-02/
      DATA XT(118)/7.78305651E-01/, WT(118)/4.86958076E-02/
      DATA XT(119)/7.27318255E-01/, WT(119)/5.32278470E-02/
      DATA XT(120)/6.71956685E-01/, WT(120)/5.74397691E-02/
      DATA XT(121)/6.12553890E-01/, WT(121)/6.13062425E-02/
      DATA XT(122)/5.49467125E-01/, WT(122)/6.48040135E-02/
      DATA XT(123)/4.83075802E-01/, WT(123)/6.79120458E-02/
      DATA XT(124)/4.13779204E-01/, WT(124)/7.06116474E-02/
      DATA XT(125)/3.41994091E-01/, WT(125)/7.28865824E-02/
      DATA XT(126)/2.68152185E-01/, WT(126)/7.47231691E-02/
      DATA XT(127)/1.92697581E-01/, WT(127)/7.61103619E-02/
      DATA XT(128)/1.16084071E-01/, WT(128)/7.70398182E-02/
      DATA XT(129)/3.87724175E-02/, WT(129)/7.75059480E-02/
C  N=48.
      DATA XT(130)/9.98771007E-01/, WT(130)/3.15334605E-03/
      DATA XT(131)/9.93530172E-01/, WT(131)/7.32755390E-03/
      DATA XT(132)/9.84124584E-01/, WT(132)/1.14772346E-02/
      DATA XT(133)/9.70591593E-01/, WT(133)/1.55793157E-02/
      DATA XT(134)/9.52987703E-01/, WT(134)/1.96161605E-02/
      DATA XT(135)/9.31386691E-01/, WT(135)/2.35707608E-02/
      DATA XT(136)/9.05879137E-01/, WT(136)/2.74265097E-02/
      DATA XT(137)/8.76572020E-01/, WT(137)/3.11672278E-02/
      DATA XT(138)/8.43588262E-01/, WT(138)/3.47772226E-02/
      DATA XT(139)/8.07066204E-01/, WT(139)/3.82413511E-02/
      DATA XT(140)/7.67159033E-01/, WT(140)/4.15450829E-02/
      DATA XT(141)/7.24034131E-01/, WT(141)/4.46745609E-02/
      DATA XT(142)/6.77872380E-01/, WT(142)/4.76166585E-02/
      DATA XT(143)/6.28867397E-01/, WT(143)/5.03590356E-02/
      DATA XT(144)/5.77224726E-01/, WT(144)/5.28901895E-02/
      DATA XT(145)/5.23160975E-01/, WT(145)/5.51995037E-02/
      DATA XT(146)/4.66902905E-01/, WT(146)/5.72772921E-02/
      DATA XT(147)/4.08686482E-01/, WT(147)/5.91148397E-02/
      DATA XT(148)/3.48755886E-01/, WT(148)/6.07044392E-02/
      DATA XT(149)/2.87362487E-01/, WT(149)/6.20394232E-02/
      DATA XT(150)/2.24763790E-01/, WT(150)/6.31141923E-02/
      DATA XT(151)/1.61222356E-01/, WT(151)/6.39242386E-02/
      DATA XT(152)/9.70046992E-02/, WT(152)/6.44661644E-02/
      DATA XT(153)/3.23801710E-02/, WT(153)/6.47376968E-02/
C  N=64.
      DATA XT(154)/9.99305042E-01/, WT(154)/1.78328072E-03/
      DATA XT(155)/9.96340117E-01/, WT(155)/4.14703326E-03/
      DATA XT(156)/9.91013371E-01/, WT(156)/6.50445797E-03/
      DATA XT(157)/9.83336254E-01/, WT(157)/8.84675983E-03/
      DATA XT(158)/9.73326828E-01/, WT(158)/1.11681395E-02/
      DATA XT(159)/9.61008800E-01/, WT(159)/1.34630479E-02/
      DATA XT(160)/9.46411375E-01/, WT(160)/1.57260305E-02/
      DATA XT(161)/9.29569172E-01/, WT(161)/1.79517158E-02/
      DATA XT(162)/9.10522137E-01/, WT(162)/2.01348232E-02/
      DATA XT(163)/8.89315446E-01/, WT(163)/2.22701738E-02/
      DATA XT(164)/8.65999398E-01/, WT(164)/2.43527026E-02/
      DATA XT(165)/8.40629296E-01/, WT(165)/2.63774697E-02/
      DATA XT(166)/8.13265315E-01/, WT(166)/2.83396726E-02/
      DATA XT(167)/7.83972359E-01/, WT(167)/3.02346571E-02/
      DATA XT(168)/7.52819907E-01/, WT(168)/3.20579284E-02/
      DATA XT(169)/7.19881850E-01/, WT(169)/3.38051618E-02/
      DATA XT(170)/6.85236313E-01/, WT(170)/3.54722133E-02/
      DATA XT(171)/6.48965471E-01/, WT(171)/3.70551285E-02/
      DATA XT(172)/6.11155355E-01/, WT(172)/3.85501532E-02/
      DATA XT(173)/5.71895646E-01/, WT(173)/3.99537411E-02/
      DATA XT(174)/5.31279464E-01/, WT(174)/4.12625632E-02/
      DATA XT(175)/4.89403146E-01/, WT(175)/4.24735151E-02/
      DATA XT(176)/4.46366017E-01/, WT(176)/4.35837245E-02/
      DATA XT(177)/4.02270158E-01/, WT(177)/4.45905582E-02/
      DATA XT(178)/3.57220158E-01/, WT(178)/4.54916279E-02/
      DATA XT(179)/3.11322872E-01/, WT(179)/4.62847966E-02/
      DATA XT(180)/2.64687162E-01/, WT(180)/4.69681828E-02/
      DATA XT(181)/2.17423644E-01/, WT(181)/4.75401657E-02/
      DATA XT(182)/1.69644420E-01/, WT(182)/4.79993886E-02/
      DATA XT(183)/1.21462819E-01/, WT(183)/4.83447622E-02/
      DATA XT(184)/7.29931218E-02/, WT(184)/4.85754674E-02/
      DATA XT(185)/2.43502927E-02/, WT(185)/4.86909570E-02/
C  N=80.
      DATA XT(186)/9.99553823E-01/, WT(186)/1.14495000E-03/
      DATA XT(187)/9.97649864E-01/, WT(187)/2.66353359E-03/
      DATA XT(188)/9.94227541E-01/, WT(188)/4.18031312E-03/
      DATA XT(189)/9.89291302E-01/, WT(189)/5.69092245E-03/
      DATA XT(190)/9.82848573E-01/, WT(190)/7.19290477E-03/
      DATA XT(191)/9.74909141E-01/, WT(191)/8.68394527E-03/
      DATA XT(192)/9.65485089E-01/, WT(192)/1.01617660E-02/
      DATA XT(193)/9.54590766E-01/, WT(193)/1.16241141E-02/
      DATA XT(194)/9.42242761E-01/, WT(194)/1.30687616E-02/
      DATA XT(195)/9.28459877E-01/, WT(195)/1.44935080E-02/
      DATA XT(196)/9.13263103E-01/, WT(196)/1.58961836E-02/
      DATA XT(197)/8.96675579E-01/, WT(197)/1.72746521E-02/
      DATA XT(198)/8.78722568E-01/, WT(198)/1.86268142E-02/
      DATA XT(199)/8.59431407E-01/, WT(199)/1.99506109E-02/
      DATA XT(200)/8.38831474E-01/, WT(200)/2.12440261E-02/
      DATA XT(201)/8.16954139E-01/, WT(201)/2.25050902E-02/
      DATA XT(202)/7.93832718E-01/, WT(202)/2.37318829E-02/
      DATA XT(203)/7.69502420E-01/, WT(203)/2.49225358E-02/
      DATA XT(204)/7.44000298E-01/, WT(204)/2.60752358E-02/
      DATA XT(205)/7.17365185E-01/, WT(205)/2.71882275E-02/
      DATA XT(206)/6.89637644E-01/, WT(206)/2.82598161E-02/
      DATA XT(207)/6.60859899E-01/, WT(207)/2.92883696E-02/
      DATA XT(208)/6.31075773E-01/, WT(208)/3.02723218E-02/
      DATA XT(209)/6.00330623E-01/, WT(209)/3.12101742E-02/
      DATA XT(210)/5.68671268E-01/, WT(210)/3.21004987E-02/
      DATA XT(211)/5.36145921E-01/, WT(211)/3.29419394E-02/
      DATA XT(212)/5.02804112E-01/, WT(212)/3.37332150E-02/
      DATA XT(213)/4.68696615E-01/, WT(213)/3.44731205E-02/
      DATA XT(214)/4.33875371E-01/, WT(214)/3.51605290E-02/
      DATA XT(215)/3.98393406E-01/, WT(215)/3.57943940E-02/
      DATA XT(216)/3.62304753E-01/, WT(216)/3.63737499E-02/
      DATA XT(217)/3.25664371E-01/, WT(217)/3.68977146E-02/
      DATA XT(218)/2.88528055E-01/, WT(218)/3.73654902E-02/
      DATA XT(219)/2.50952358E-01/, WT(219)/3.77763644E-02/
      DATA XT(220)/2.12994503E-01/, WT(220)/3.81297113E-02/
      DATA XT(221)/1.74712292E-01/, WT(221)/3.84249930E-02/
      DATA XT(222)/1.36164023E-01/, WT(222)/3.86617598E-02/
      DATA XT(223)/9.74083984E-02/, WT(223)/3.88396511E-02/
      DATA XT(224)/5.85044372E-02/, WT(224)/3.89583960E-02/
      DATA XT(225)/1.95113833E-02/, WT(225)/3.90178137E-02/
C  N=96.
      DATA XT(226)/9.99689504E-01/, WT(226)/7.96792066E-04/
      DATA XT(227)/9.98364376E-01/, WT(227)/1.85396079E-03/
      DATA XT(228)/9.95981843E-01/, WT(228)/2.91073182E-03/
      DATA XT(229)/9.92543900E-01/, WT(229)/3.96455434E-03/
      DATA XT(230)/9.88054126E-01/, WT(230)/5.01420274E-03/
      DATA XT(231)/9.82517264E-01/, WT(231)/6.05854550E-03/
      DATA XT(232)/9.75939175E-01/, WT(232)/7.09647079E-03/
      DATA XT(233)/9.68326828E-01/, WT(233)/8.12687693E-03/
      DATA XT(234)/9.59688291E-01/, WT(234)/9.14867123E-03/
      DATA XT(235)/9.50032718E-01/, WT(235)/1.01607705E-02/
      DATA XT(236)/9.39370340E-01/, WT(236)/1.11621021E-02/
      DATA XT(237)/9.27712457E-01/, WT(237)/1.21516047E-02/
      DATA XT(238)/9.15071423E-01/, WT(238)/1.31282296E-02/
      DATA XT(239)/9.01460635E-01/, WT(239)/1.40909418E-02/
      DATA XT(240)/8.86894517E-01/, WT(240)/1.50387210E-02/
      DATA XT(241)/8.71388506E-01/, WT(241)/1.59705629E-02/
      DATA XT(242)/8.54959033E-01/, WT(242)/1.68854799E-02/
      DATA XT(243)/8.37623511E-01/, WT(243)/1.77825023E-02/
      DATA XT(244)/8.19400311E-01/, WT(244)/1.86606796E-02/
      DATA XT(245)/8.00308744E-01/, WT(245)/1.95190811E-02/
      DATA XT(246)/7.80369044E-01/, WT(246)/2.03567972E-02/
      DATA XT(247)/7.59602341E-01/, WT(247)/2.11729399E-02/
      DATA XT(248)/7.38030644E-01/, WT(248)/2.19666444E-02/
      DATA XT(249)/7.15676812E-01/, WT(249)/2.27370697E-02/
      DATA XT(250)/6.92564537E-01/, WT(250)/2.34833991E-02/
      DATA XT(251)/6.68718310E-01/, WT(251)/2.42048418E-02/
      DATA XT(252)/6.44163404E-01/, WT(252)/2.49006332E-02/
      DATA XT(253)/6.18925840E-01/, WT(253)/2.55700360E-02/
      DATA XT(254)/5.93032365E-01/, WT(254)/2.62123407E-02/
      DATA XT(255)/5.66510419E-01/, WT(255)/2.68268667E-02/
      DATA XT(256)/5.39388108E-01/, WT(256)/2.74129627E-02/
      DATA XT(257)/5.11694177E-01/, WT(257)/2.79700076E-02/
      DATA XT(258)/4.83457974E-01/, WT(258)/2.84974111E-02/
      DATA XT(259)/4.54709422E-01/, WT(259)/2.89946142E-02/
      DATA XT(260)/4.25478988E-01/, WT(260)/2.94610900E-02/
      DATA XT(261)/3.95797650E-01/, WT(261)/2.98963441E-02/
      DATA XT(262)/3.65696861E-01/, WT(262)/3.02999154E-02/
      DATA XT(263)/3.35208523E-01/, WT(263)/3.06713761E-02/
      DATA XT(264)/3.04364944E-01/, WT(264)/3.10103326E-02/
      DATA XT(265)/2.73198813E-01/, WT(265)/3.13164256E-02/
      DATA XT(266)/2.41743156E-01/, WT(266)/3.15893308E-02/
      DATA XT(267)/2.10031310E-01/, WT(267)/3.18287589E-02/
      DATA XT(268)/1.78096882E-01/, WT(268)/3.20344562E-02/
      DATA XT(269)/1.45973715E-01/, WT(269)/3.22062048E-02/
      DATA XT(270)/1.13695850E-01/, WT(270)/3.23438226E-02/
      DATA XT(271)/8.12974955E-02/, WT(271)/3.24471637E-02/
      DATA XT(272)/4.88129851E-02/, WT(272)/3.25161187E-02/
      DATA XT(273)/1.62767448E-02/, WT(273)/3.25506145E-02/
#endif
C
      DATA NW/2/, K/1/, JMAX/1/, JMID/0/
C
C     ******************************************************************
C
C  START.  IF N HAS CHANGED VALUE, SET K TO INITIAL SUBSCRIPT OF ARRAYS
C  XT AND WT.
C
      IF(N.EQ.NW) GO TO 2
      NWSAVE=NW
      NW=N
      IF(NW.LT.2) GO TO 100
      L=NW
      IF(NW.LE.16) GO TO 1
      L=(NW/4)+12
      IF(NW.EQ.20) GO TO 1
      IF(NW.EQ.24) GO TO 1
      IF(NW.EQ.32) GO TO 1
      IF(NW.EQ.40) GO TO 1
      IF(NW.EQ.48) GO TO 1
      IF(NW.EQ.64) GO TO 1
      IF(NW.EQ.80) GO TO 1
      IF(NW.EQ.96) GO TO 1
      GO TO 100
C
    1 K=KTAB(L)
      M=NW/2
      JMAX=K+M-1
      JMID=0
      IF(NW-M-M.NE.0) JMID=K+M
C
    2 ALPHA=0.5*(B+A)
      BETA=0.5*(B-A)
      IF(MODE.EQ.2) GO TO 4
C
C  (MODE=1. EVALUATE QUDRATURE SUM.)
C
      SUM=0.
      DO 3 J=K,JMAX
         DELTA=BETA*XT(J)
         SUM=SUM+WT(J)*(F(ALPHA+DELTA)+F(ALPHA-DELTA))
    3 CONTINUE
      IF(JMID.NE.0) SUM=SUM+WT(JMID)*F(ALPHA)
      X(1)=BETA*SUM
      RETURN
C
C  (MODE=2. SET ARRAYS X AND W.)
C
    4 JLAST=(NW+1)/2
      DO 5 J=1,JLAST
         JTAB=K-1+J
         WTEMP=BETA*WT(JTAB)
         DELTA=BETA*XT(JTAB)
         X(J)=ALPHA-DELTA
         W(J)=WTEMP
         JP=NW+1-J
         X(JP)=ALPHA+DELTA
         W(JP)=WTEMP
    5 CONTINUE
      RETURN
C
C  ERROR MESSAGE FOR NON-PERMISSIBLE N.
C
  100 IF(MODE.EQ.1) X(1)=0.
      CALL KERMTR('D106.1',LGFILE,MFLAG,RFLAG)
      IF(MFLAG) THEN
         IF(LGFILE.EQ.0) THEN
            IF(MODE.EQ.1) WRITE(*,2001) N
            IF(MODE.EQ.2) WRITE(*,2002) N
         ELSE
            IF(MODE.EQ.1) WRITE(LGFILE,2001) N
            IF(MODE.EQ.2) WRITE(LGFILE,2002) N
         ENDIF
      ENDIF
      IF(.NOT. RFLAG) CALL ABEND
      NW=NWSAVE
      RETURN
C
 2001 FORMAT( 7X, 25HSUBROUTINE GQUAD ...  N =, I4,
     *        21H  IS NON-PERMISSIBLE. )
 2002 FORMAT( 7X, 24HSUBROUTINE GSET ...  N =, I4,
     *        21H  IS NON-PERMISSIBLE. )
      END
