module Make :
  functor (Dpkg : Dpkg.DB) ->
    sig
      val iter_over_packages : 'a -> 'b list -> ('b -> unit) -> unit
      val sf : ('a, unit, string) format -> 'a
      val bourbaki_dump :
        < flush : 'a; output_word : string -> unit; .. > ->
        versions:bool -> Dpkg.db -> int list -> 'a
      val list_dump :
        < flush : unit; output_word : string -> unit; .. > ->
        versions:bool -> Dpkg.db -> int list -> unit
      val default_field_order : string list * string list
      val compute_fields :
        ?field_order:string list * string list ->
        Dpkg.db -> 'a -> int list * int list * int list
      val raw_dump :
        < columns : int; flush : unit; newline : unit;
          output : string -> unit; output_word : string -> 'a; .. > ->
        Dpkg.db -> Opt.fields -> int list -> unit
      val table_dump :
        < output_char : char -> unit; output_string : string -> unit; .. > ->
        Dpkg.db ->
        ?field_order:string list * string list ->
        borders:bool -> Opt.fields -> int list -> unit
    end
