/* player.h - simple audio file player interface
 *
 * Copyright 2010 Petteri Hintsanen <petterih@iki.fi>
 *
 * This file is part of abx.
 *
 * abx is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * abx is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with abx.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ABX_PLAYER_H
#define ABX_PLAYER_H

#include "soundfile.h"
#include <portaudio.h>
#include <semaphore.h>

typedef struct Player Player;

/* Current playback state for a player. */
typedef struct {
    enum { PLAYING, PAUSED, STOPPED } playback;
    double location;
} Player_state;

extern Player *init_player(const char *filename, PaDeviceIndex outdev);
extern void close_player(Player *player);

extern Metadata get_player_metadata(Player *player);
extern Player_state get_player_state(Player *player);

extern void start_player(Player *player, sem_t *sem);
extern void stop_player(Player *player, sem_t *sem);
extern void pause_or_resume_player(Player *player, sem_t *sem);
extern void seek_player(Player *player, double offset, int whence,
                        sem_t *sem);

#endif
