/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.ReferencedColumns;
import org.apache.derby.iapi.services.io.Formatable;

public class ReferencedColumnsDescriptorImpl
implements ReferencedColumns,
Formatable {
    private int[] referencedColumns;

    public ReferencedColumnsDescriptorImpl(int[] nArray) {
        this.referencedColumns = nArray;
    }

    public ReferencedColumnsDescriptorImpl() {
    }

    public int[] getReferencedColumnPositions() {
        return this.referencedColumns;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.referencedColumns = new int[n];
        for (int i = 0; i < n; ++i) {
            this.referencedColumns[i] = objectInput.readInt();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.referencedColumns.length);
        for (int i = 0; i < this.referencedColumns.length; ++i) {
            objectOutput.writeInt(this.referencedColumns[i]);
        }
    }

    public int getTypeFormatId() {
        return 205;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append('(');
        for (int i = 0; i < this.referencedColumns.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(String.valueOf(this.referencedColumns[i]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

