#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Pandemonium
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220701.1

GAME_ID='pandemonium'
GAME_NAME='Pandemonium!'

ARCHIVE_BASE_0='setup_pandemonium_2.0.0.15.exe'
ARCHIVE_BASE_0_MD5='dee53eb1c87be925d64e75ea01eca74f'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.15'
ARCHIVE_BASE_0_SIZE='130000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/pandemonium'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_GAME_BIN_FILES='
*.bat
*.cnf
*.exe
*.dll'
ARCHIVE_GAME_DATA_FILES='
*.pkg'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='pandy.exe'
APP_MAIN_ICON='app/gfw_high.ico'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine libGL.so.1"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	content_path=$(content_path_default)
	cd "${PLAYIT_WORKDIR}/gamedata/${content_path}"
	mv pandy3.exe pandy.exe
	mv full3.cnf resource.cnf
)
prepare_package_layout

# Include game icon

PKG='PKG_DATA'
icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
