#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Mortician's Tale
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240905.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='a-morticians-tale'
GAME_NAME='A Mortician’s Tale'

ARCHIVE_BASE_64BIT_0_NAME="A Mortician's Tale - Windows x64.zip"
ARCHIVE_BASE_64BIT_0_MD5='581b86b6e5f20eeb497b07659aaa0991'
ARCHIVE_BASE_64BIT_0_SIZE='180000'
ARCHIVE_BASE_64BIT_0_VERSION='1.0-itch'
ARCHIVE_BASE_64BIT_0_URL='https://laundrybear.itch.io/morticians-tale'

ARCHIVE_BASE_32BIT_0_NAME="A Mortician's Tale - Windows x86.zip"
ARCHIVE_BASE_32BIT_0_MD5='02a3fbfd4121a88f462b6b3884d6a75e'
ARCHIVE_BASE_32BIT_0_SIZE='180000'
ARCHIVE_BASE_32BIT_0_VERSION='1.0-itch'
ARCHIVE_BASE_32BIT_0_URL='https://laundrybear.itch.io/morticians-tale'

UNITY3D_NAME='morticianstale'

CONTENT_PATH_DEFAULT='.'

## TODO: Add a diversion to persistent storage for saved games and settings.

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH_64BIT='64'
PKG_BIN_ARCH_32BIT='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
