/*
 * Copyright (C) 2010-2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.    See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.    If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *                         Ken VanDine <ken.vandine@canonical.com>
 *
 */

using GLib;
using Config;

public int unity_scope_module_get_version ()
{
    return Unity.SCOPE_API_VERSION;
}

public List<Unity.AbstractScope> unity_scope_module_load_scopes () throws Error
{
    /* Sort up locale to get translations but also sorting and
     * punctuation right */
    GLib.Intl.bindtextdomain (Config.PACKAGE, Config.LOCALE_DIR);
    GLib.Intl.bind_textdomain_codeset (Config.PACKAGE, "UTF-8");
    GLib.Intl.setlocale (GLib.LocaleCategory.ALL, "");

    List<Unity.AbstractScope> scopes = null;
    var scope = new UnityFriends.FriendsScope ();
    scopes.append (scope);
    return scopes;
}
