# This file should be included by the backends.

set(CMAKE_INCLUDE_CURRENT_DIR ON)

function(create_qzion create_qzion_EXTRA_SRCS create_qzion_EXTRA_MOCS)
    include_directories(../common)

    set(qzion_SRCS
        qzioncanvas.cpp
        qzionabstractcanvas.cpp
        qziongroup.cpp
        qzionimage.cpp
        qzionobject.cpp
        qzionrectangle.cpp
        qziontext.cpp
        qziontextblock.cpp
        qzionclippedgroup.cpp
        qzioncustomobject.cpp
        ${create_qzion_EXTRA_SRCS}
        )

    qt4_wrap_cpp(qzion_MOC_SRCS
        ${create_qzion_EXTRA_MOCS}
        ${qzion_DOTDOT_HEADERS}
        )

    add_library(qzion SHARED ${qzion_SRCS} ${qzion_MOC_SRCS})
    target_link_libraries(qzion ${QT_LIBRARIES})

    set_target_properties(qzion PROPERTIES
        VERSION ${QZION_LIB_VERSION_STRING}
        SOVERSION ${QZION_LIB_MAJOR_VERSION}
        )

    install(TARGETS qzion LIBRARY DESTINATION ${LIB_INSTALL_DIR}/)
endfunction(create_qzion)
