/*
 * %CopyrightBegin%
 *
 * Copyright Ericsson AB 2008-2016. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * %CopyrightEnd% 
*/

/***** This file is generated do not edit ****/

#include <wx/wx.h>
#include "../wxe_impl.h"
#include "../wxe_events.h"
#include "../wxe_return.h"
#include "../wxe_gl.h"
#include "wxe_macros.h"
#include "wxe_derived_dest.h"

#if !wxCHECK_VERSION(2,9,0)
#define wxPenJoin int
#define wxPenCap int
#define wxImageResizeQuality int
#define wxPolygonFillMode int
#define wxMappingMode int
#define wxRasterOperationMode int
#define wxFloodFillStyle int
#endif
void WxeApp::wxe_dispatch(wxeCommand& Ecmd)
{
 char * bp = Ecmd.buffer;
 wxeMemEnv *memenv = getMemEnv(Ecmd.port);
  wxeReturn rt = wxeReturn(WXE_DRV_PORT, Ecmd.caller, true);
 try {
 switch (Ecmd.op)
{
  case DESTROY_OBJECT: {
     void *This = getPtr(bp,memenv);
     wxeRefData *refd = getRefData(This);
     if(This && refd) {
       if(recurse_level > 1 && refd->type != 4) {
          delayed_delete->Append(Ecmd.Save());
       } else {
          delete_object(This, refd);
          ((WxeApp *) wxTheApp)->clearPtr(This);}
  } } break;
  case WXE_REGISTER_OBJECT: {
     registerPid(bp, Ecmd.caller, memenv);
     rt.addAtom("ok");
     break;
 }
 case WXE_BIN_INCR:
   driver_binary_inc_refc(Ecmd.bin[0].bin);
   break;
 case WXE_BIN_DECR:
   driver_binary_dec_refc(Ecmd.bin[0].bin);
   break;
 case WXE_INIT_OPENGL:
  wxe_initOpenGL(&rt, bp);
   break;

case 100: { // wxEvtHandler::Connect
  wxEvtHandler *This = (wxEvtHandler *) getPtr(bp, memenv); bp += 4;
  int * winid  = (int *) bp; bp += 4;
  int * lastId = (int *) bp; bp += 4;
  int * skip   = (int *) bp; bp += 4;
  int * haveUserData = (int *) bp; bp += 4;
  wxeErlTerm * userData = NULL;
  int * fun_cb = (int *) bp; bp += 4;
  int * eventTypeLen = (int *) bp; bp += 4;
  int * class_nameLen = (int *) bp; bp += 4;

  if(*haveUserData) {
      userData = new wxeErlTerm(&Ecmd.bin[0]);
  }

  int eventType = wxeEventTypeFromAtom(bp); bp += *eventTypeLen;
  char *class_name = bp; bp+= *class_nameLen;
  if(eventType > 0 ) {
    wxeEvtListener * Evt_cb = new wxeEvtListener(Ecmd.caller,getRef(This, memenv),
                                                 class_name,*fun_cb,
                                                 *skip, userData, Ecmd.port);
    This->Connect((int) *winid,(int) *lastId,eventType,
	          (wxObjectEventFunction)(wxEventFunction) &wxeEvtListener::forward,
	          Evt_cb, Evt_cb);
    rt.addAtom("ok");
    rt.addRef(getRef((void *)Evt_cb,memenv), "wxeEvtListener");
    rt.addTupleCount(2);
  } else {
    rt.addAtom("badarg");
    rt.addAtom("event_type");
    rt.addTupleCount(2);
  }
  break;
}
case 101: { // wxEvtHandler::Disconnect
  wxeEvtListener *Listener = (wxeEvtListener *) getPtr(bp,memenv); bp += 4;
  wxEvtHandler *This = (wxEvtHandler *) getPtr(bp, memenv); bp += 4;
  int * winid  = (int *) bp; bp += 4;
  int * lastId = (int *) bp; bp += 4;
  int * eventTypeLen = (int *) bp; bp += 4;

  int eventType = wxeEventTypeFromAtom(bp); bp += *eventTypeLen;
  if(eventType > 0) {
    if(recurse_level > 1) {
      delayed_delete->Append(Ecmd.Save());
    } else {
     bool Result = This->Disconnect((int) *winid,(int) *lastId,eventType,
                                    (wxObjectEventFunction)(wxEventFunction)
                                    &wxeEvtListener::forward,
                                    NULL, Listener);
     rt.addBool(Result);
    }
  } else {
    rt.addAtom("badarg");
    rt.addAtom("event_type");
    rt.addTupleCount(2);
  }
  break;
}

case wxWindow_new_0: { // wxWindow::wxWindow
 wxWindow * Result = new EwxWindow();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_new_3: { // wxWindow::wxWindow
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxWindow * Result = new EwxWindow(parent,*id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_CacheBestSize: { // wxWindow::CacheBestSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->CacheBestSize(size);
 break;
}
case wxWindow_CaptureMouse: { // wxWindow::CaptureMouse
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CaptureMouse();
 break;
}
case wxWindow_Center: { // wxWindow::Center
 int dir=wxBOTH;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 dir = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Center(dir);
 break;
}
case wxWindow_CenterOnParent: { // wxWindow::CenterOnParent
 int dir=wxBOTH;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 dir = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->CenterOnParent(dir);
 break;
}
case wxWindow_Centre: { // wxWindow::Centre
 int dir=wxBOTH;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 dir = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Centre(dir);
 break;
}
case wxWindow_CentreOnParent: { // wxWindow::CentreOnParent
 int dir=wxBOTH;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 dir = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->CentreOnParent(dir);
 break;
}
case wxWindow_ClearBackground: { // wxWindow::ClearBackground
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearBackground();
 break;
}
case wxWindow_ClientToScreen_2: { // wxWindow::ClientToScreen
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClientToScreen(x,y);
 rt.addInt(*x);
 rt.addInt(*y);
 rt.addTupleCount(2);
 break;
}
case wxWindow_ClientToScreen_1: { // wxWindow::ClientToScreen
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->ClientToScreen(pt);
 rt.add(Result);
 break;
}
case wxWindow_Close: { // wxWindow::Close
 bool force=false;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 force = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Close(force);
 rt.addBool(Result);
 break;
}
case wxWindow_ConvertDialogToPixels: { // wxWindow::ConvertDialogToPixels
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->ConvertDialogToPixels(sz);
 rt.add(Result);
 break;
}
case wxWindow_ConvertPixelsToDialog: { // wxWindow::ConvertPixelsToDialog
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->ConvertPixelsToDialog(sz);
 rt.add(Result);
 break;
}
case wxWindow_Destroy: { // wxWindow::Destroy
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Destroy();
 rt.addBool(Result);
 break;
}
case wxWindow_DestroyChildren: { // wxWindow::DestroyChildren
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DestroyChildren();
 rt.addBool(Result);
 break;
}
case wxWindow_Disable: { // wxWindow::Disable
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Disable();
 rt.addBool(Result);
 break;
}
case wxWindow_Enable: { // wxWindow::Enable
 bool enable=true;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Enable(enable);
 rt.addBool(Result);
 break;
}
case wxWindow_FindFocus: { // wxWindow::FindFocus
 wxWindow * Result = (wxWindow*)wxWindow::FindFocus();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_FindWindow_1_0: { // wxWindow::FindWindow
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * winid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->FindWindow(*winid);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_FindWindow_1_1: { // wxWindow::FindWindow
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->FindWindow(name);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_FindWindowById: { // wxWindow::FindWindowById
 const wxWindow * parent=NULL;
 int * winid = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxWindow * Result = (wxWindow*)wxWindow::FindWindowById(*winid,parent);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_FindWindowByName: { // wxWindow::FindWindowByName
 const wxWindow * parent=NULL;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxWindow * Result = (wxWindow*)wxWindow::FindWindowByName(name,parent);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_FindWindowByLabel: { // wxWindow::FindWindowByLabel
 const wxWindow * parent=NULL;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxWindow * Result = (wxWindow*)wxWindow::FindWindowByLabel(label,parent);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_Fit: { // wxWindow::Fit
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Fit();
 break;
}
case wxWindow_FitInside: { // wxWindow::FitInside
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->FitInside();
 break;
}
case wxWindow_Freeze: { // wxWindow::Freeze
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Freeze();
 break;
}
case wxWindow_GetAcceleratorTable: { // wxWindow::GetAcceleratorTable
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAcceleratorTable * Result = (wxAcceleratorTable*)This->GetAcceleratorTable();
 rt.addRef(getRef((void *)Result,memenv), "wxAcceleratorTable");
 break;
}
case wxWindow_GetBackgroundColour: { // wxWindow::GetBackgroundColour
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetBackgroundColour();
 rt.add(Result);
 break;
}
case wxWindow_GetBackgroundStyle: { // wxWindow::GetBackgroundStyle
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetBackgroundStyle();
 rt.addInt(Result);
 break;
}
case wxWindow_GetBestSize: { // wxWindow::GetBestSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetBestSize();
 rt.add(Result);
 break;
}
case wxWindow_GetCaret: { // wxWindow::GetCaret
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCaret * Result = (wxCaret*)This->GetCaret();
 rt.addRef(getRef((void *)Result,memenv), "wxCaret");
 break;
}
case wxWindow_GetCapture: { // wxWindow::GetCapture
 wxWindow * Result = (wxWindow*)wxWindow::GetCapture();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_GetCharHeight: { // wxWindow::GetCharHeight
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCharHeight();
 rt.addInt(Result);
 break;
}
case wxWindow_GetCharWidth: { // wxWindow::GetCharWidth
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCharWidth();
 rt.addInt(Result);
 break;
}
case wxWindow_GetChildren: { // wxWindow::GetChildren
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxWindowList Result = This->GetChildren();
 int i=0;
 for(wxWindowList::const_iterator it = Result.begin(); it != Result.end(); ++it) {
   wxWindow * ResultTmp = *it;
   rt.addRef(getRef((void *)ResultTmp,memenv), "wxWindow"); i++;}
 rt.endList(Result.GetCount());
 break;
}
case wxWindow_GetClientSize: { // wxWindow::GetClientSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetClientSize();
 rt.add(Result);
 break;
}
case wxWindow_GetContainingSizer: { // wxWindow::GetContainingSizer
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizer * Result = (wxSizer*)This->GetContainingSizer();
 rt.addRef(getRef((void *)Result,memenv), "wxSizer");
 break;
}
case wxWindow_GetCursor: { // wxWindow::GetCursor
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxCursor * Result = &This->GetCursor();
 rt.addRef(getRef((void *)Result,memenv), "wxCursor");
 break;
}
case wxWindow_GetDropTarget: { // wxWindow::GetDropTarget
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxDropTarget * Result = (wxDropTarget*)This->GetDropTarget();
 rt.addRef(getRef((void *)Result,memenv), "wxDropTarget");
 break;
}
case wxWindow_GetEventHandler: { // wxWindow::GetEventHandler
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxEvtHandler * Result = (wxEvtHandler*)This->GetEventHandler();
 rt.addRef(getRef((void *)Result,memenv), "wxEvtHandler");
 break;
}
case wxWindow_GetExtraStyle: { // wxWindow::GetExtraStyle
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetExtraStyle();
 rt.addInt(Result);
 break;
}
case wxWindow_GetFont: { // wxWindow::GetFont
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxWindow_GetForegroundColour: { // wxWindow::GetForegroundColour
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetForegroundColour();
 rt.add(Result);
 break;
}
case wxWindow_GetGrandParent: { // wxWindow::GetGrandParent
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetGrandParent();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_GetHandle: { // wxWindow::GetHandle
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxUIntPtr * Result = (wxUIntPtr*)This->GetHandle();
 rt.add(Result);
 break;
}
case wxWindow_GetHelpText: { // wxWindow::GetHelpText
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetHelpText();
 rt.add(Result);
 break;
}
case wxWindow_GetId: { // wxWindow::GetId
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindowID Result = This->GetId();
 rt.addInt(Result);
 break;
}
case wxWindow_GetLabel: { // wxWindow::GetLabel
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLabel();
 rt.add(Result);
 break;
}
case wxWindow_GetMaxSize: { // wxWindow::GetMaxSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetMaxSize();
 rt.add(Result);
 break;
}
case wxWindow_GetMinSize: { // wxWindow::GetMinSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetMinSize();
 rt.add(Result);
 break;
}
case wxWindow_GetName: { // wxWindow::GetName
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetName();
 rt.add(Result);
 break;
}
case wxWindow_GetParent: { // wxWindow::GetParent
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetParent();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxWindow_GetPosition: { // wxWindow::GetPosition
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxWindow_GetRect: { // wxWindow::GetRect
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetRect();
 rt.add(Result);
 break;
}
case wxWindow_GetScreenPosition: { // wxWindow::GetScreenPosition
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetScreenPosition();
 rt.add(Result);
 break;
}
case wxWindow_GetScreenRect: { // wxWindow::GetScreenRect
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetScreenRect();
 rt.add(Result);
 break;
}
case wxWindow_GetScrollPos: { // wxWindow::GetScrollPos
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * orient = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetScrollPos(*orient);
 rt.addInt(Result);
 break;
}
case wxWindow_GetScrollRange: { // wxWindow::GetScrollRange
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * orient = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetScrollRange(*orient);
 rt.addInt(Result);
 break;
}
case wxWindow_GetScrollThumb: { // wxWindow::GetScrollThumb
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * orient = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetScrollThumb(*orient);
 rt.addInt(Result);
 break;
}
case wxWindow_GetSize: { // wxWindow::GetSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetSize();
 rt.add(Result);
 break;
}
case wxWindow_GetSizer: { // wxWindow::GetSizer
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizer * Result = (wxSizer*)This->GetSizer();
 rt.addRef(getRef((void *)Result,memenv), "wxSizer");
 break;
}
case wxWindow_GetTextExtent: { // wxWindow::GetTextExtent
 int x;
 int y;
 int descent;
 int externalLeading;
 const wxFont * theFont=(const wxFont *) NULL;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * stringLen = (int *) bp; bp += 4;
 wxString string = wxString(bp, wxConvUTF8);
 bp += *stringLen+((8-((0+ *stringLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
theFont = (wxFont *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->GetTextExtent(string,&x,&y,&descent,&externalLeading,theFont);
 rt.addInt(x);
 rt.addInt(y);
 rt.addInt(descent);
 rt.addInt(externalLeading);
 rt.addTupleCount(4);
 break;
}
case wxWindow_GetToolTip: { // wxWindow::GetToolTip
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolTip * Result = (wxToolTip*)This->GetToolTip();
 rt.addRef(getRef((void *)Result,memenv), "wxToolTip");
 break;
}
case wxWindow_GetUpdateRegion: { // wxWindow::GetUpdateRegion
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxRegion * Result = &This->GetUpdateRegion();
 rt.addRef(getRef((void *)Result,memenv), "wxRegion");
 break;
}
case wxWindow_GetVirtualSize: { // wxWindow::GetVirtualSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetVirtualSize();
 rt.add(Result);
 break;
}
case wxWindow_GetWindowStyleFlag: { // wxWindow::GetWindowStyleFlag
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetWindowStyleFlag();
 rt.addInt(Result);
 break;
}
case wxWindow_GetWindowVariant: { // wxWindow::GetWindowVariant
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWindowVariant();
 rt.addInt(Result);
 break;
}
case wxWindow_HasCapture: { // wxWindow::HasCapture
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasCapture();
 rt.addBool(Result);
 break;
}
case wxWindow_HasScrollbar: { // wxWindow::HasScrollbar
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * orient = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasScrollbar(*orient);
 rt.addBool(Result);
 break;
}
case wxWindow_HasTransparentBackground: { // wxWindow::HasTransparentBackground
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasTransparentBackground();
 rt.addBool(Result);
 break;
}
case wxWindow_Hide: { // wxWindow::Hide
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Hide();
 rt.addBool(Result);
 break;
}
case wxWindow_InheritAttributes: { // wxWindow::InheritAttributes
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->InheritAttributes();
 break;
}
case wxWindow_InitDialog: { // wxWindow::InitDialog
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->InitDialog();
 break;
}
case wxWindow_InvalidateBestSize: { // wxWindow::InvalidateBestSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->InvalidateBestSize();
 break;
}
case wxWindow_IsEnabled: { // wxWindow::IsEnabled
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEnabled();
 rt.addBool(Result);
 break;
}
case wxWindow_IsExposed_2: { // wxWindow::IsExposed
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsExposed(*x,*y);
 rt.addBool(Result);
 break;
}
case wxWindow_IsExposed_4: { // wxWindow::IsExposed
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * w = (int *) bp; bp += 4;
 int * h = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsExposed(*x,*y,*w,*h);
 rt.addBool(Result);
 break;
}
case wxWindow_IsExposed_1_0: { // wxWindow::IsExposed
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsExposed(pt);
 rt.addBool(Result);
 break;
}
case wxWindow_IsExposed_1_1: { // wxWindow::IsExposed
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsExposed(rect);
 rt.addBool(Result);
 break;
}
case wxWindow_IsRetained: { // wxWindow::IsRetained
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsRetained();
 rt.addBool(Result);
 break;
}
case wxWindow_IsShown: { // wxWindow::IsShown
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsShown();
 rt.addBool(Result);
 break;
}
case wxWindow_IsTopLevel: { // wxWindow::IsTopLevel
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsTopLevel();
 rt.addBool(Result);
 break;
}
case wxWindow_Layout: { // wxWindow::Layout
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Layout();
 rt.addBool(Result);
 break;
}
case wxWindow_LineDown: { // wxWindow::LineDown
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->LineDown();
 rt.addBool(Result);
 break;
}
case wxWindow_LineUp: { // wxWindow::LineUp
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->LineUp();
 rt.addBool(Result);
 break;
}
case wxWindow_Lower: { // wxWindow::Lower
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Lower();
 break;
}
case wxWindow_MakeModal: { // wxWindow::MakeModal
 bool modal=true;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 modal = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->MakeModal(modal);
 break;
}
case wxWindow_Move_3: { // wxWindow::Move
 int flags=wxSIZE_USE_EXISTING;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Move(*x,*y,flags);
 break;
}
case wxWindow_Move_2: { // wxWindow::Move
 int flags=wxSIZE_USE_EXISTING;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Move(pt,flags);
 break;
}
case wxWindow_MoveAfterInTabOrder: { // wxWindow::MoveAfterInTabOrder
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MoveAfterInTabOrder(win);
 break;
}
case wxWindow_MoveBeforeInTabOrder: { // wxWindow::MoveBeforeInTabOrder
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MoveBeforeInTabOrder(win);
 break;
}
case wxWindow_Navigate: { // wxWindow::Navigate
 int flags=wxNavigationKeyEvent::IsForward;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Navigate(flags);
 rt.addBool(Result);
 break;
}
case wxWindow_PageDown: { // wxWindow::PageDown
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->PageDown();
 rt.addBool(Result);
 break;
}
case wxWindow_PageUp: { // wxWindow::PageUp
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->PageUp();
 rt.addBool(Result);
 break;
}
case wxWindow_PopEventHandler: { // wxWindow::PopEventHandler
 bool deleteHandler=false;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 deleteHandler = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxEvtHandler * Result = (wxEvtHandler*)This->PopEventHandler(deleteHandler);
 rt.addRef(getRef((void *)Result,memenv), "wxEvtHandler");
 break;
}
case wxWindow_PopupMenu_2: { // wxWindow::PopupMenu
 wxPoint pos= wxDefaultPosition;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxMenu *menu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->PopupMenu(menu,pos);
 rt.addBool(Result);
 break;
}
case wxWindow_PopupMenu_3: { // wxWindow::PopupMenu
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxMenu *menu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->PopupMenu(menu,*x,*y);
 rt.addBool(Result);
 break;
}
case wxWindow_Raise: { // wxWindow::Raise
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Raise();
 break;
}
case wxWindow_Refresh: { // wxWindow::Refresh
 bool eraseBackground=true;
 const wxRect *rect=(const wxRect *) NULL; wxRect rectTmp;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 eraseBackground = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 rectTmp = wxRect(*rectX,*rectY,*rectW,*rectH); rect = & rectTmp;
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Refresh(eraseBackground,rect);
 break;
}
case wxWindow_RefreshRect: { // wxWindow::RefreshRect
 bool eraseBackground=true;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 eraseBackground = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->RefreshRect(rect,eraseBackground);
 break;
}
case wxWindow_ReleaseMouse: { // wxWindow::ReleaseMouse
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ReleaseMouse();
 break;
}
case wxWindow_RemoveChild: { // wxWindow::RemoveChild
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxWindow *child = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->RemoveChild(child);
 break;
}
case wxWindow_Reparent: { // wxWindow::Reparent
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxWindow *newParent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Reparent(newParent);
 rt.addBool(Result);
 break;
}
case wxWindow_ScreenToClient_2: { // wxWindow::ScreenToClient
 int x;
 int y;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ScreenToClient(&x,&y);
 rt.addInt(x);
 rt.addInt(y);
 rt.addTupleCount(2);
 break;
}
case wxWindow_ScreenToClient_1: { // wxWindow::ScreenToClient
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->ScreenToClient(pt);
 rt.add(Result);
 break;
}
case wxWindow_ScrollLines: { // wxWindow::ScrollLines
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * lines = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ScrollLines(*lines);
 rt.addBool(Result);
 break;
}
case wxWindow_ScrollPages: { // wxWindow::ScrollPages
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * pages = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ScrollPages(*pages);
 rt.addBool(Result);
 break;
}
case wxWindow_ScrollWindow: { // wxWindow::ScrollWindow
 const wxRect *rect=(wxRect *) NULL; wxRect rectTmp;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * dx = (int *) bp; bp += 4;
 int * dy = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 rectTmp = wxRect(*rectX,*rectY,*rectW,*rectH); rect = & rectTmp;
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->ScrollWindow(*dx,*dy,rect);
 break;
}
case wxWindow_SetAcceleratorTable: { // wxWindow::SetAcceleratorTable
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxAcceleratorTable *accel = (wxAcceleratorTable *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAcceleratorTable(*accel);
 break;
}
case wxWindow_SetAutoLayout: { // wxWindow::SetAutoLayout
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bool * autoLayout = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAutoLayout(*autoLayout);
 break;
}
case wxWindow_SetBackgroundColour: { // wxWindow::SetBackgroundColour
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetBackgroundColour(colour);
 rt.addBool(Result);
 break;
}
case wxWindow_SetBackgroundStyle: { // wxWindow::SetBackgroundStyle
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxBackgroundStyle style = *(wxBackgroundStyle *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetBackgroundStyle(style);
 rt.addBool(Result);
 break;
}
case wxWindow_SetCaret: { // wxWindow::SetCaret
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxCaret *caret = (wxCaret *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCaret(caret);
 break;
}
case wxWindow_SetClientSize_2: { // wxWindow::SetClientSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetClientSize(*width,*height);
 break;
}
case wxWindow_SetClientSize_1_0: { // wxWindow::SetClientSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetClientSize(size);
 break;
}
case wxWindow_SetClientSize_1_1: { // wxWindow::SetClientSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 This->SetClientSize(rect);
 break;
}
case wxWindow_SetContainingSizer: { // wxWindow::SetContainingSizer
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetContainingSizer(sizer);
 break;
}
case wxWindow_SetCursor: { // wxWindow::SetCursor
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxCursor *cursor = (wxCursor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetCursor(*cursor);
 rt.addBool(Result);
 break;
}
case wxWindow_SetMaxSize: { // wxWindow::SetMaxSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * maxSizeW = (int *) bp; bp += 4;
 int * maxSizeH = (int *) bp; bp += 4;
 wxSize maxSize = wxSize(*maxSizeW,*maxSizeH);
 if(!This) throw wxe_badarg(0);
 This->SetMaxSize(maxSize);
 break;
}
case wxWindow_SetMinSize: { // wxWindow::SetMinSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * minSizeW = (int *) bp; bp += 4;
 int * minSizeH = (int *) bp; bp += 4;
 wxSize minSize = wxSize(*minSizeW,*minSizeH);
 if(!This) throw wxe_badarg(0);
 This->SetMinSize(minSize);
 break;
}
case wxWindow_SetOwnBackgroundColour: { // wxWindow::SetOwnBackgroundColour
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetOwnBackgroundColour(colour);
 break;
}
case wxWindow_SetOwnFont: { // wxWindow::SetOwnFont
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetOwnFont(*font);
 break;
}
case wxWindow_SetOwnForegroundColour: { // wxWindow::SetOwnForegroundColour
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetOwnForegroundColour(colour);
 break;
}
case wxWindow_SetDropTarget: { // wxWindow::SetDropTarget
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxDropTarget *dropTarget = (wxDropTarget *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDropTarget(dropTarget);
 break;
}
case wxWindow_SetExtraStyle: { // wxWindow::SetExtraStyle
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * exStyle = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetExtraStyle(*exStyle);
 break;
}
case wxWindow_SetFocus: { // wxWindow::SetFocus
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFocus();
 break;
}
case wxWindow_SetFocusFromKbd: { // wxWindow::SetFocusFromKbd
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFocusFromKbd();
 break;
}
case wxWindow_SetFont: { // wxWindow::SetFont
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetFont(*font);
 rt.addBool(Result);
 break;
}
case wxWindow_SetForegroundColour: { // wxWindow::SetForegroundColour
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetForegroundColour(colour);
 rt.addBool(Result);
 break;
}
case wxWindow_SetHelpText: { // wxWindow::SetHelpText
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetHelpText(text);
 break;
}
case wxWindow_SetId: { // wxWindow::SetId
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * winid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetId(*winid);
 break;
}
case wxWindow_SetLabel: { // wxWindow::SetLabel
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetLabel(label);
 break;
}
case wxWindow_SetName: { // wxWindow::SetName
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetName(name);
 break;
}
case wxWindow_SetPalette: { // wxWindow::SetPalette
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxPalette *pal = (wxPalette *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPalette(*pal);
 break;
}
case wxWindow_SetScrollbar: { // wxWindow::SetScrollbar
 bool refresh=true;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * orient = (int *) bp; bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * thumbVisible = (int *) bp; bp += 4;
 int * range = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 refresh = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetScrollbar(*orient,*pos,*thumbVisible,*range,refresh);
 break;
}
case wxWindow_SetScrollPos: { // wxWindow::SetScrollPos
 bool refresh=true;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * orient = (int *) bp; bp += 4;
 int * pos = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 refresh = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetScrollPos(*orient,*pos,refresh);
 break;
}
case wxWindow_SetSize_5: { // wxWindow::SetSize
 int sizeFlags=wxSIZE_AUTO;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 sizeFlags = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetSize(*x,*y,*width,*height,sizeFlags);
 break;
}
case wxWindow_SetSize_2_0: { // wxWindow::SetSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSize(*width,*height);
 break;
}
case wxWindow_SetSize_1: { // wxWindow::SetSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetSize(size);
 break;
}
case wxWindow_SetSize_2_1: { // wxWindow::SetSize
 int sizeFlags=wxSIZE_AUTO;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 sizeFlags = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetSize(rect,sizeFlags);
 break;
}
case wxWindow_SetSizeHints_3: { // wxWindow::SetSizeHints
 int maxW=wxDefaultCoord;
 int maxH=wxDefaultCoord;
 int incW=wxDefaultCoord;
 int incH=wxDefaultCoord;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * minW = (int *) bp; bp += 4;
 int * minH = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 maxW = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 maxH = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 incW = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
 incH = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetSizeHints(*minW,*minH,maxW,maxH,incW,incH);
 break;
}
case wxWindow_SetSizeHints_2: { // wxWindow::SetSizeHints
 wxSize maxSize= wxDefaultSize;
 wxSize incSize= wxDefaultSize;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * minSizeW = (int *) bp; bp += 4;
 int * minSizeH = (int *) bp; bp += 4;
 wxSize minSize = wxSize(*minSizeW,*minSizeH);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * maxSizeW = (int *) bp; bp += 4;
 int * maxSizeH = (int *) bp; bp += 4;
 maxSize = wxSize(*maxSizeW,*maxSizeH);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * incSizeW = (int *) bp; bp += 4;
 int * incSizeH = (int *) bp; bp += 4;
 incSize = wxSize(*incSizeW,*incSizeH);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetSizeHints(minSize,maxSize,incSize);
 break;
}
case wxWindow_SetSizer: { // wxWindow::SetSizer
 bool deleteOld=true;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 deleteOld = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetSizer(sizer,deleteOld);
 break;
}
case wxWindow_SetSizerAndFit: { // wxWindow::SetSizerAndFit
 bool deleteOld=true;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 deleteOld = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetSizerAndFit(sizer,deleteOld);
 break;
}
case wxWindow_SetThemeEnabled: { // wxWindow::SetThemeEnabled
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bool * enableTheme = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetThemeEnabled(*enableTheme);
 break;
}
case wxWindow_SetToolTip_1_0: { // wxWindow::SetToolTip
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * tipLen = (int *) bp; bp += 4;
 wxString tip = wxString(bp, wxConvUTF8);
 bp += *tipLen+((8-((0+ *tipLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetToolTip(tip);
 break;
}
case wxWindow_SetToolTip_1_1: { // wxWindow::SetToolTip
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxToolTip *tip = (wxToolTip *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetToolTip(tip);
 break;
}
case wxWindow_SetVirtualSize_1: { // wxWindow::SetVirtualSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetVirtualSize(size);
 break;
}
case wxWindow_SetVirtualSize_2: { // wxWindow::SetVirtualSize
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetVirtualSize(*x,*y);
 break;
}
case wxWindow_SetVirtualSizeHints_3: { // wxWindow::SetVirtualSizeHints
 int maxW=wxDefaultCoord;
 int maxH=wxDefaultCoord;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * minW = (int *) bp; bp += 4;
 int * minH = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 maxW = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 maxH = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetVirtualSizeHints(*minW,*minH,maxW,maxH);
 break;
}
case wxWindow_SetVirtualSizeHints_2: { // wxWindow::SetVirtualSizeHints
 wxSize maxSize= wxDefaultSize;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * minSizeW = (int *) bp; bp += 4;
 int * minSizeH = (int *) bp; bp += 4;
 wxSize minSize = wxSize(*minSizeW,*minSizeH);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * maxSizeW = (int *) bp; bp += 4;
 int * maxSizeH = (int *) bp; bp += 4;
 maxSize = wxSize(*maxSizeW,*maxSizeH);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetVirtualSizeHints(minSize,maxSize);
 break;
}
case wxWindow_SetWindowStyle: { // wxWindow::SetWindowStyle
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWindowStyle(*style);
 break;
}
case wxWindow_SetWindowStyleFlag: { // wxWindow::SetWindowStyleFlag
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWindowStyleFlag(*style);
 break;
}
case wxWindow_SetWindowVariant: { // wxWindow::SetWindowVariant
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxWindowVariant variant = *(wxWindowVariant *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetWindowVariant(variant);
 break;
}
case wxWindow_ShouldInheritColours: { // wxWindow::ShouldInheritColours
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ShouldInheritColours();
 rt.addBool(Result);
 break;
}
case wxWindow_Show: { // wxWindow::Show
 bool show=true;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Show(show);
 rt.addBool(Result);
 break;
}
case wxWindow_Thaw: { // wxWindow::Thaw
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Thaw();
 break;
}
case wxWindow_TransferDataFromWindow: { // wxWindow::TransferDataFromWindow
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->TransferDataFromWindow();
 rt.addBool(Result);
 break;
}
case wxWindow_TransferDataToWindow: { // wxWindow::TransferDataToWindow
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->TransferDataToWindow();
 rt.addBool(Result);
 break;
}
case wxWindow_Update: { // wxWindow::Update
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Update();
 break;
}
case wxWindow_UpdateWindowUI: { // wxWindow::UpdateWindowUI
 long flags=wxUPDATE_UI_NONE;
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->UpdateWindowUI(flags);
 break;
}
case wxWindow_Validate: { // wxWindow::Validate
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Validate();
 rt.addBool(Result);
 break;
}
case wxWindow_WarpPointer: { // wxWindow::WarpPointer
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->WarpPointer(*x,*y);
 break;
}
#if wxCHECK_VERSION(2,8,12)
case wxWindow_SetTransparent: { // wxWindow::SetTransparent
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * alpha = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetTransparent(*alpha);
 rt.addBool(Result);
 break;
}
#endif
#if wxCHECK_VERSION(2,8,12)
case wxWindow_CanSetTransparent: { // wxWindow::CanSetTransparent
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanSetTransparent();
 rt.addBool(Result);
 break;
}
#endif
#if wxCHECK_VERSION(3,0,0)
case wxWindow_IsDoubleBuffered: { // wxWindow::IsDoubleBuffered
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsDoubleBuffered();
 rt.addBool(Result);
 break;
}
#endif
#if wxCHECK_VERSION(3,0,0) && !defined(__WXMAC__)
case wxWindow_SetDoubleBuffered: { // wxWindow::SetDoubleBuffered
 wxWindow *This = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bool * on = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDoubleBuffered(*on);
 break;
}
#endif
case wxTopLevelWindow_GetIcon: { // wxTopLevelWindow::GetIcon
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxIcon * Result = new EwxIcon(This->GetIcon()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxIcon");
 break;
}
case wxTopLevelWindow_GetIcons: { // wxTopLevelWindow::GetIcons
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxIconBundle * Result = &This->GetIcons();
 rt.addRef(getRef((void *)Result,memenv), "wxIconBundle");
 break;
}
case wxTopLevelWindow_GetTitle: { // wxTopLevelWindow::GetTitle
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetTitle();
 rt.add(Result);
 break;
}
case wxTopLevelWindow_IsActive: { // wxTopLevelWindow::IsActive
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsActive();
 rt.addBool(Result);
 break;
}
case wxTopLevelWindow_Iconize: { // wxTopLevelWindow::Iconize
 bool iconize=true;
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 iconize = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Iconize(iconize);
 break;
}
case wxTopLevelWindow_IsFullScreen: { // wxTopLevelWindow::IsFullScreen
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsFullScreen();
 rt.addBool(Result);
 break;
}
case wxTopLevelWindow_IsIconized: { // wxTopLevelWindow::IsIconized
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsIconized();
 rt.addBool(Result);
 break;
}
case wxTopLevelWindow_IsMaximized: { // wxTopLevelWindow::IsMaximized
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsMaximized();
 rt.addBool(Result);
 break;
}
case wxTopLevelWindow_Maximize: { // wxTopLevelWindow::Maximize
 bool maximize=true;
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 maximize = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Maximize(maximize);
 break;
}
case wxTopLevelWindow_RequestUserAttention: { // wxTopLevelWindow::RequestUserAttention
 int flags=wxUSER_ATTENTION_INFO;
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->RequestUserAttention(flags);
 break;
}
case wxTopLevelWindow_SetIcon: { // wxTopLevelWindow::SetIcon
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 wxIcon *icon = (wxIcon *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetIcon(*icon);
 break;
}
case wxTopLevelWindow_SetIcons: { // wxTopLevelWindow::SetIcons
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 wxIconBundle *icons = (wxIconBundle *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetIcons(*icons);
 break;
}
case wxTopLevelWindow_CenterOnScreen: { // wxTopLevelWindow::CenterOnScreen
 int dir=wxBOTH;
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 dir = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->CenterOnScreen(dir);
 break;
}
case wxTopLevelWindow_CentreOnScreen: { // wxTopLevelWindow::CentreOnScreen
 int dir=wxBOTH;
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 dir = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->CentreOnScreen(dir);
 break;
}
case wxTopLevelWindow_SetShape: { // wxTopLevelWindow::SetShape
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 wxRegion *region = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetShape(*region);
 rt.addBool(Result);
 break;
}
case wxTopLevelWindow_SetTitle: { // wxTopLevelWindow::SetTitle
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetTitle(title);
 break;
}
case wxTopLevelWindow_ShowFullScreen: { // wxTopLevelWindow::ShowFullScreen
 long style=wxFULLSCREEN_ALL;
 wxTopLevelWindow *This = (wxTopLevelWindow *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ShowFullScreen(*show,style);
 rt.addBool(Result);
 break;
}
case wxFrame_new_4: { // wxFrame::wxFrame
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_FRAME_STYLE;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxFrame * Result = new EwxFrame(parent,*id,title,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFrame");
 break;
}
case wxFrame_new_0: { // wxFrame::wxFrame
 wxFrame * Result = new EwxFrame();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFrame");
 break;
}
case wxFrame_Create: { // wxFrame::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_FRAME_STYLE;
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,title,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxFrame_CreateStatusBar: { // wxFrame::CreateStatusBar
 int number=1;
 long style=wxST_SIZEGRIP|wxFULL_REPAINT_ON_RESIZE;
 wxWindowID id=0;
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 number = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxStatusBar * Result = (wxStatusBar*)This->CreateStatusBar(number,style,id);
 rt.addRef(getRef((void *)Result,memenv), "wxStatusBar");
 break;
}
case wxFrame_CreateToolBar: { // wxFrame::CreateToolBar
 long style=-1;
 wxWindowID id=-1;
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBar * Result = (wxToolBar*)This->CreateToolBar(style,id);
 rt.addRef(getRef((void *)Result,memenv), "wxToolBar");
 break;
}
case wxFrame_GetClientAreaOrigin: { // wxFrame::GetClientAreaOrigin
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetClientAreaOrigin();
 rt.add(Result);
 break;
}
case wxFrame_GetMenuBar: { // wxFrame::GetMenuBar
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuBar * Result = (wxMenuBar*)This->GetMenuBar();
 rt.addRef(getRef((void *)Result,memenv), "wxMenuBar");
 break;
}
case wxFrame_GetStatusBar: { // wxFrame::GetStatusBar
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxStatusBar * Result = (wxStatusBar*)This->GetStatusBar();
 rt.addRef(getRef((void *)Result,memenv), "wxStatusBar");
 break;
}
case wxFrame_GetStatusBarPane: { // wxFrame::GetStatusBarPane
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetStatusBarPane();
 rt.addInt(Result);
 break;
}
case wxFrame_GetToolBar: { // wxFrame::GetToolBar
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBar * Result = (wxToolBar*)This->GetToolBar();
 rt.addRef(getRef((void *)Result,memenv), "wxToolBar");
 break;
}
case wxFrame_ProcessCommand: { // wxFrame::ProcessCommand
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 int * winid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ProcessCommand(*winid);
 rt.addBool(Result);
 break;
}
case wxFrame_SendSizeEvent: { // wxFrame::SendSizeEvent
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SendSizeEvent();
 break;
}
case wxFrame_SetMenuBar: { // wxFrame::SetMenuBar
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 wxMenuBar *menubar = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMenuBar(menubar);
 break;
}
case wxFrame_SetStatusBar: { // wxFrame::SetStatusBar
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 wxStatusBar *statbar = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStatusBar(statbar);
 break;
}
case wxFrame_SetStatusBarPane: { // wxFrame::SetStatusBarPane
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStatusBarPane(*n);
 break;
}
case wxFrame_SetStatusText: { // wxFrame::SetStatusText
 int number=0;
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 number = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetStatusText(text,number);
 break;
}
case wxFrame_SetStatusWidths: { // wxFrame::SetStatusWidths
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 int * widths_fieldLen = (int *) bp; bp += 4;
 int * widths_field = (int *) bp; bp += *widths_fieldLen*4+((0+ *widths_fieldLen)%2 )*4;
 if(!This) throw wxe_badarg(0);
 This->SetStatusWidths(*widths_fieldLen,widths_field);
 break;
}
case wxFrame_SetToolBar: { // wxFrame::SetToolBar
 wxFrame *This = (wxFrame *) getPtr(bp,memenv); bp += 4;
 wxToolBar *toolbar = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetToolBar(toolbar);
 break;
}
case wxMiniFrame_new_0: { // wxMiniFrame::wxMiniFrame
 wxMiniFrame * Result = new EwxMiniFrame();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMiniFrame");
 break;
}
case wxMiniFrame_new_4: { // wxMiniFrame::wxMiniFrame
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxCAPTION|wxRESIZE_BORDER;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxMiniFrame * Result = new EwxMiniFrame(parent,*id,title,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMiniFrame");
 break;
}
case wxMiniFrame_Create: { // wxMiniFrame::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxCAPTION|wxRESIZE_BORDER;
 wxMiniFrame *This = (wxMiniFrame *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,title,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxSplashScreen_new_0: { // wxSplashScreen::wxSplashScreen
 wxSplashScreen * Result = new EwxSplashScreen();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSplashScreen");
 break;
}
case wxSplashScreen_new_6: { // wxSplashScreen::wxSplashScreen
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSIMPLE_BORDER|wxFRAME_NO_TASKBAR|wxSTAY_ON_TOP;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * splashStyle = (int *) bp; bp += 4;
 int * milliseconds = (int *) bp; bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxSplashScreen * Result = new EwxSplashScreen(*bitmap,*splashStyle,*milliseconds,parent,*id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSplashScreen");
 break;
}
case wxSplashScreen_GetSplashStyle: { // wxSplashScreen::GetSplashStyle
 wxSplashScreen *This = (wxSplashScreen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetSplashStyle();
 rt.addInt(Result);
 break;
}
case wxSplashScreen_GetTimeout: { // wxSplashScreen::GetTimeout
 wxSplashScreen *This = (wxSplashScreen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetTimeout();
 rt.addInt(Result);
 break;
}
case wxPanel_new_0: { // wxPanel::wxPanel
 wxPanel * Result = new EwxPanel();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPanel");
 break;
}
case wxPanel_new_6: { // wxPanel::wxPanel
 long style=wxTAB_TRAVERSAL|wxNO_BORDER;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxPanel * Result = new EwxPanel(parent,*x,*y,*width,*height,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPanel");
 break;
}
case wxPanel_new_2: { // wxPanel::wxPanel
 wxWindowID winid=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxTAB_TRAVERSAL|wxNO_BORDER;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 winid = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxPanel * Result = new EwxPanel(parent,winid,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPanel");
 break;
}
case wxPanel_InitDialog: { // wxPanel::InitDialog
 wxPanel *This = (wxPanel *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->InitDialog();
 break;
}
case wxPanel_SetFocusIgnoringChildren: { // wxPanel::SetFocusIgnoringChildren
 wxPanel *This = (wxPanel *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFocusIgnoringChildren();
 break;
}
case wxScrolledWindow_new_0: { // wxScrolledWindow::wxScrolledWindow
 wxScrolledWindow * Result = new EwxScrolledWindow();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxScrolledWindow");
 break;
}
case wxScrolledWindow_new_2: { // wxScrolledWindow::wxScrolledWindow
 wxWindowID winid=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxScrolledWindowStyle;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 winid = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxScrolledWindow * Result = new EwxScrolledWindow(parent,winid,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxScrolledWindow");
 break;
}
case wxScrolledWindow_CalcScrolledPosition_4: { // wxScrolledWindow::CalcScrolledPosition
 int xx;
 int yy;
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CalcScrolledPosition(*x,*y,&xx,&yy);
 rt.addInt(xx);
 rt.addInt(yy);
 rt.addTupleCount(2);
 break;
}
case wxScrolledWindow_CalcScrolledPosition_1: { // wxScrolledWindow::CalcScrolledPosition
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->CalcScrolledPosition(pt);
 rt.add(Result);
 break;
}
case wxScrolledWindow_CalcUnscrolledPosition_4: { // wxScrolledWindow::CalcUnscrolledPosition
 int xx;
 int yy;
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CalcUnscrolledPosition(*x,*y,&xx,&yy);
 rt.addInt(xx);
 rt.addInt(yy);
 rt.addTupleCount(2);
 break;
}
case wxScrolledWindow_CalcUnscrolledPosition_1: { // wxScrolledWindow::CalcUnscrolledPosition
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->CalcUnscrolledPosition(pt);
 rt.add(Result);
 break;
}
case wxScrolledWindow_EnableScrolling: { // wxScrolledWindow::EnableScrolling
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 bool * x_scrolling = (bool *) bp; bp += 4;
 bool * y_scrolling = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableScrolling(*x_scrolling,*y_scrolling);
 break;
}
case wxScrolledWindow_GetScrollPixelsPerUnit: { // wxScrolledWindow::GetScrollPixelsPerUnit
 int pixelsPerUnitX;
 int pixelsPerUnitY;
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetScrollPixelsPerUnit(&pixelsPerUnitX,&pixelsPerUnitY);
 rt.addInt(pixelsPerUnitX);
 rt.addInt(pixelsPerUnitY);
 rt.addTupleCount(2);
 break;
}
case wxScrolledWindow_GetViewStart: { // wxScrolledWindow::GetViewStart
 int x;
 int y;
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetViewStart(&x,&y);
 rt.addInt(x);
 rt.addInt(y);
 rt.addTupleCount(2);
 break;
}
case wxScrolledWindow_DoPrepareDC: { // wxScrolledWindow::DoPrepareDC
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DoPrepareDC(*dc);
 break;
}
case wxScrolledWindow_PrepareDC: { // wxScrolledWindow::PrepareDC
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->PrepareDC(*dc);
 break;
}
case wxScrolledWindow_Scroll: { // wxScrolledWindow::Scroll
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Scroll(*x,*y);
 break;
}
case wxScrolledWindow_SetScrollbars: { // wxScrolledWindow::SetScrollbars
 int xPos=0;
 int yPos=0;
 bool noRefresh=false;
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 int * pixelsPerUnitX = (int *) bp; bp += 4;
 int * pixelsPerUnitY = (int *) bp; bp += 4;
 int * noUnitsX = (int *) bp; bp += 4;
 int * noUnitsY = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 xPos = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 yPos = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 noRefresh = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetScrollbars(*pixelsPerUnitX,*pixelsPerUnitY,*noUnitsX,*noUnitsY,xPos,yPos,noRefresh);
 break;
}
case wxScrolledWindow_SetScrollRate: { // wxScrolledWindow::SetScrollRate
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 int * xstep = (int *) bp; bp += 4;
 int * ystep = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetScrollRate(*xstep,*ystep);
 break;
}
case wxScrolledWindow_SetTargetWindow: { // wxScrolledWindow::SetTargetWindow
 wxScrolledWindow *This = (wxScrolledWindow *) getPtr(bp,memenv); bp += 4;
 wxWindow *target = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTargetWindow(target);
 break;
}
case wxSashWindow_new_0: { // wxSashWindow::wxSashWindow
 wxSashWindow * Result = new EwxSashWindow();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSashWindow");
 break;
}
case wxSashWindow_new_2: { // wxSashWindow::wxSashWindow
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSW_3D|wxCLIP_CHILDREN;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxSashWindow * Result = new EwxSashWindow(parent,id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSashWindow");
 break;
}
case wxSashWindow_GetSashVisible: { // wxSashWindow::GetSashVisible
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 wxSashEdgePosition edge = *(wxSashEdgePosition *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetSashVisible(edge);
 rt.addBool(Result);
 break;
}
case wxSashWindow_GetMaximumSizeX: { // wxSashWindow::GetMaximumSizeX
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMaximumSizeX();
 rt.addInt(Result);
 break;
}
case wxSashWindow_GetMaximumSizeY: { // wxSashWindow::GetMaximumSizeY
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMaximumSizeY();
 rt.addInt(Result);
 break;
}
case wxSashWindow_GetMinimumSizeX: { // wxSashWindow::GetMinimumSizeX
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMinimumSizeX();
 rt.addInt(Result);
 break;
}
case wxSashWindow_GetMinimumSizeY: { // wxSashWindow::GetMinimumSizeY
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMinimumSizeY();
 rt.addInt(Result);
 break;
}
case wxSashWindow_SetMaximumSizeX: { // wxSashWindow::SetMaximumSizeX
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 int * max = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMaximumSizeX(*max);
 break;
}
case wxSashWindow_SetMaximumSizeY: { // wxSashWindow::SetMaximumSizeY
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 int * max = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMaximumSizeY(*max);
 break;
}
case wxSashWindow_SetMinimumSizeX: { // wxSashWindow::SetMinimumSizeX
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 int * min = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMinimumSizeX(*min);
 break;
}
case wxSashWindow_SetMinimumSizeY: { // wxSashWindow::SetMinimumSizeY
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 int * min = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMinimumSizeY(*min);
 break;
}
case wxSashWindow_SetSashVisible: { // wxSashWindow::SetSashVisible
 wxSashWindow *This = (wxSashWindow *) getPtr(bp,memenv); bp += 4;
 wxSashEdgePosition edge = *(wxSashEdgePosition *) bp; bp += 4;;
 bool * sash = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSashVisible(edge,*sash);
 break;
}
case wxSashLayoutWindow_new_0: { // wxSashLayoutWindow::wxSashLayoutWindow
 wxSashLayoutWindow * Result = new EwxSashLayoutWindow();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSashLayoutWindow");
 break;
}
case wxSashLayoutWindow_new_2: { // wxSashLayoutWindow::wxSashLayoutWindow
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSW_3D|wxCLIP_CHILDREN;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxSashLayoutWindow * Result = new EwxSashLayoutWindow(parent,id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSashLayoutWindow");
 break;
}
case wxSashLayoutWindow_Create: { // wxSashLayoutWindow::Create
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSW_3D|wxCLIP_CHILDREN;
 wxSashLayoutWindow *This = (wxSashLayoutWindow *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxSashLayoutWindow_GetAlignment: { // wxSashLayoutWindow::GetAlignment
 wxSashLayoutWindow *This = (wxSashLayoutWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetAlignment();
 rt.addInt(Result);
 break;
}
case wxSashLayoutWindow_GetOrientation: { // wxSashLayoutWindow::GetOrientation
 wxSashLayoutWindow *This = (wxSashLayoutWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetOrientation();
 rt.addInt(Result);
 break;
}
case wxSashLayoutWindow_SetAlignment: { // wxSashLayoutWindow::SetAlignment
 wxSashLayoutWindow *This = (wxSashLayoutWindow *) getPtr(bp,memenv); bp += 4;
 wxLayoutAlignment align = *(wxLayoutAlignment *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetAlignment(align);
 break;
}
case wxSashLayoutWindow_SetDefaultSize: { // wxSashLayoutWindow::SetDefaultSize
 wxSashLayoutWindow *This = (wxSashLayoutWindow *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetDefaultSize(size);
 break;
}
case wxSashLayoutWindow_SetOrientation: { // wxSashLayoutWindow::SetOrientation
 wxSashLayoutWindow *This = (wxSashLayoutWindow *) getPtr(bp,memenv); bp += 4;
 wxLayoutOrientation orient = *(wxLayoutOrientation *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetOrientation(orient);
 break;
}
case wxGrid_new_0: { // wxGrid::wxGrid
 wxGrid * Result = new EwxGrid();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGrid");
 break;
}
case wxGrid_new_3: { // wxGrid::wxGrid
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxWANTS_CHARS;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxGrid * Result = new EwxGrid(parent,*id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGrid");
 break;
}
case wxGrid_new_4: { // wxGrid::wxGrid
 int w=wxDefaultCoord;
 int h=wxDefaultCoord;
 long style=wxWANTS_CHARS;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 w = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 h = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxGrid * Result = new EwxGrid(parent,*x,*y,w,h,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGrid");
 break;
}
case wxGrid_AppendCols: { // wxGrid::AppendCols
 int numCols=1;
 bool updateLabels=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 numCols = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 updateLabels = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AppendCols(numCols,updateLabels);
 rt.addBool(Result);
 break;
}
case wxGrid_AppendRows: { // wxGrid::AppendRows
 int numRows=1;
 bool updateLabels=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 numRows = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 updateLabels = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AppendRows(numRows,updateLabels);
 rt.addBool(Result);
 break;
}
case wxGrid_AutoSize: { // wxGrid::AutoSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoSize();
 break;
}
case wxGrid_AutoSizeColumn: { // wxGrid::AutoSizeColumn
 bool setAsMin=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 setAsMin = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AutoSizeColumn(*col,setAsMin);
 break;
}
case wxGrid_AutoSizeColumns: { // wxGrid::AutoSizeColumns
 bool setAsMin=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 setAsMin = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AutoSizeColumns(setAsMin);
 break;
}
case wxGrid_AutoSizeRow: { // wxGrid::AutoSizeRow
 bool setAsMin=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 setAsMin = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AutoSizeRow(*row,setAsMin);
 break;
}
case wxGrid_AutoSizeRows: { // wxGrid::AutoSizeRows
 bool setAsMin=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 setAsMin = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AutoSizeRows(setAsMin);
 break;
}
case wxGrid_BeginBatch: { // wxGrid::BeginBatch
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->BeginBatch();
 break;
}
case wxGrid_BlockToDeviceRect: { // wxGrid::BlockToDeviceRect
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * topLeftR = (int *) bp; bp += 4;
 int * topLeftC = (int *) bp; bp += 4;
 wxGridCellCoords topLeft = wxGridCellCoords(*topLeftR,*topLeftC);
 int * bottomRightR = (int *) bp; bp += 4;
 int * bottomRightC = (int *) bp; bp += 4;
 wxGridCellCoords bottomRight = wxGridCellCoords(*bottomRightR,*bottomRightC);
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->BlockToDeviceRect(topLeft,bottomRight);
 rt.add(Result);
 break;
}
case wxGrid_CanDragColSize: { // wxGrid::CanDragColSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanDragColSize();
 rt.addBool(Result);
 break;
}
case wxGrid_CanDragRowSize: { // wxGrid::CanDragRowSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanDragRowSize();
 rt.addBool(Result);
 break;
}
case wxGrid_CanDragGridSize: { // wxGrid::CanDragGridSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanDragGridSize();
 rt.addBool(Result);
 break;
}
case wxGrid_CanEnableCellControl: { // wxGrid::CanEnableCellControl
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanEnableCellControl();
 rt.addBool(Result);
 break;
}
case wxGrid_CellToRect_2: { // wxGrid::CellToRect
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->CellToRect(*row,*col);
 rt.add(Result);
 break;
}
case wxGrid_CellToRect_1: { // wxGrid::CellToRect
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * coordsR = (int *) bp; bp += 4;
 int * coordsC = (int *) bp; bp += 4;
 wxGridCellCoords coords = wxGridCellCoords(*coordsR,*coordsC);
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->CellToRect(coords);
 rt.add(Result);
 break;
}
case wxGrid_ClearGrid: { // wxGrid::ClearGrid
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearGrid();
 break;
}
case wxGrid_ClearSelection: { // wxGrid::ClearSelection
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearSelection();
 break;
}
case wxGrid_CreateGrid: { // wxGrid::CreateGrid
 wxGrid::wxGridSelectionModes selmode=wxGrid::wxGridSelectCells;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * numRows = (int *) bp; bp += 4;
 int * numCols = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
selmode = *(wxGrid::wxGridSelectionModes *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->CreateGrid(*numRows,*numCols,selmode);
 rt.addBool(Result);
 break;
}
case wxGrid_DeleteCols: { // wxGrid::DeleteCols
 int pos=0;
 int numCols=1;
 bool updateLabels=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 pos = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 numCols = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 updateLabels = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteCols(pos,numCols,updateLabels);
 rt.addBool(Result);
 break;
}
case wxGrid_DeleteRows: { // wxGrid::DeleteRows
 int pos=0;
 int numRows=1;
 bool updateLabels=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 pos = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 numRows = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 updateLabels = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteRows(pos,numRows,updateLabels);
 rt.addBool(Result);
 break;
}
case wxGrid_DisableCellEditControl: { // wxGrid::DisableCellEditControl
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DisableCellEditControl();
 break;
}
case wxGrid_DisableDragColSize: { // wxGrid::DisableDragColSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DisableDragColSize();
 break;
}
case wxGrid_DisableDragGridSize: { // wxGrid::DisableDragGridSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DisableDragGridSize();
 break;
}
case wxGrid_DisableDragRowSize: { // wxGrid::DisableDragRowSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DisableDragRowSize();
 break;
}
case wxGrid_EnableCellEditControl: { // wxGrid::EnableCellEditControl
 bool enable=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->EnableCellEditControl(enable);
 break;
}
case wxGrid_EnableDragColSize: { // wxGrid::EnableDragColSize
 bool enable=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->EnableDragColSize(enable);
 break;
}
case wxGrid_EnableDragGridSize: { // wxGrid::EnableDragGridSize
 bool enable=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->EnableDragGridSize(enable);
 break;
}
case wxGrid_EnableDragRowSize: { // wxGrid::EnableDragRowSize
 bool enable=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->EnableDragRowSize(enable);
 break;
}
case wxGrid_EnableEditing: { // wxGrid::EnableEditing
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * edit = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableEditing(*edit);
 break;
}
case wxGrid_EnableGridLines: { // wxGrid::EnableGridLines
 bool enable=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->EnableGridLines(enable);
 break;
}
case wxGrid_EndBatch: { // wxGrid::EndBatch
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EndBatch();
 break;
}
case wxGrid_Fit: { // wxGrid::Fit
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Fit();
 break;
}
case wxGrid_ForceRefresh: { // wxGrid::ForceRefresh
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ForceRefresh();
 break;
}
case wxGrid_GetBatchCount: { // wxGrid::GetBatchCount
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetBatchCount();
 rt.addInt(Result);
 break;
}
case wxGrid_GetCellAlignment: { // wxGrid::GetCellAlignment
 int horiz;
 int vert;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetCellAlignment(*row,*col,&horiz,&vert);
 rt.addInt(horiz);
 rt.addInt(vert);
 rt.addTupleCount(2);
 break;
}
case wxGrid_GetCellBackgroundColour: { // wxGrid::GetCellBackgroundColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetCellBackgroundColour(*row,*col);
 rt.add(Result);
 break;
}
case wxGrid_GetCellEditor: { // wxGrid::GetCellEditor
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellEditor * Result = (wxGridCellEditor*)This->GetCellEditor(*row,*col);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellEditor");
 break;
}
case wxGrid_GetCellFont: { // wxGrid::GetCellFont
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetCellFont(*row,*col)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxGrid_GetCellRenderer: { // wxGrid::GetCellRenderer
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellRenderer * Result = (wxGridCellRenderer*)This->GetCellRenderer(*row,*col);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellRenderer");
 break;
}
case wxGrid_GetCellTextColour: { // wxGrid::GetCellTextColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetCellTextColour(*row,*col);
 rt.add(Result);
 break;
}
case wxGrid_GetCellValue_2: { // wxGrid::GetCellValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetCellValue(*row,*col);
 rt.add(Result);
 break;
}
case wxGrid_GetCellValue_1: { // wxGrid::GetCellValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * coordsR = (int *) bp; bp += 4;
 int * coordsC = (int *) bp; bp += 4;
 wxGridCellCoords coords = wxGridCellCoords(*coordsR,*coordsC);
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetCellValue(coords);
 rt.add(Result);
 break;
}
case wxGrid_GetColLabelAlignment: { // wxGrid::GetColLabelAlignment
 int horiz;
 int vert;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetColLabelAlignment(&horiz,&vert);
 rt.addInt(horiz);
 rt.addInt(vert);
 rt.addTupleCount(2);
 break;
}
case wxGrid_GetColLabelSize: { // wxGrid::GetColLabelSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColLabelSize();
 rt.addInt(Result);
 break;
}
case wxGrid_GetColLabelValue: { // wxGrid::GetColLabelValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetColLabelValue(*col);
 rt.add(Result);
 break;
}
case wxGrid_GetColMinimalAcceptableWidth: { // wxGrid::GetColMinimalAcceptableWidth
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColMinimalAcceptableWidth();
 rt.addInt(Result);
 break;
}
case wxGrid_GetDefaultCellAlignment: { // wxGrid::GetDefaultCellAlignment
 int horiz;
 int vert;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetDefaultCellAlignment(&horiz,&vert);
 rt.addInt(horiz);
 rt.addInt(vert);
 rt.addTupleCount(2);
 break;
}
case wxGrid_GetDefaultCellBackgroundColour: { // wxGrid::GetDefaultCellBackgroundColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetDefaultCellBackgroundColour();
 rt.add(Result);
 break;
}
case wxGrid_GetDefaultCellFont: { // wxGrid::GetDefaultCellFont
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetDefaultCellFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxGrid_GetDefaultCellTextColour: { // wxGrid::GetDefaultCellTextColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetDefaultCellTextColour();
 rt.add(Result);
 break;
}
case wxGrid_GetDefaultColLabelSize: { // wxGrid::GetDefaultColLabelSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDefaultColLabelSize();
 rt.addInt(Result);
 break;
}
case wxGrid_GetDefaultColSize: { // wxGrid::GetDefaultColSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDefaultColSize();
 rt.addInt(Result);
 break;
}
case wxGrid_GetDefaultEditor: { // wxGrid::GetDefaultEditor
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellEditor * Result = (wxGridCellEditor*)This->GetDefaultEditor();
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellEditor");
 break;
}
case wxGrid_GetDefaultEditorForCell_2: { // wxGrid::GetDefaultEditorForCell
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellEditor * Result = (wxGridCellEditor*)This->GetDefaultEditorForCell(*row,*col);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellEditor");
 break;
}
case wxGrid_GetDefaultEditorForCell_1: { // wxGrid::GetDefaultEditorForCell
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * cR = (int *) bp; bp += 4;
 int * cC = (int *) bp; bp += 4;
 wxGridCellCoords c = wxGridCellCoords(*cR,*cC);
 if(!This) throw wxe_badarg(0);
 wxGridCellEditor * Result = (wxGridCellEditor*)This->GetDefaultEditorForCell(c);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellEditor");
 break;
}
case wxGrid_GetDefaultEditorForType: { // wxGrid::GetDefaultEditorForType
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * typeNameLen = (int *) bp; bp += 4;
 wxString typeName = wxString(bp, wxConvUTF8);
 bp += *typeNameLen+((8-((0+ *typeNameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxGridCellEditor * Result = (wxGridCellEditor*)This->GetDefaultEditorForType(typeName);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellEditor");
 break;
}
case wxGrid_GetDefaultRenderer: { // wxGrid::GetDefaultRenderer
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellRenderer * Result = (wxGridCellRenderer*)This->GetDefaultRenderer();
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellRenderer");
 break;
}
case wxGrid_GetDefaultRendererForCell: { // wxGrid::GetDefaultRendererForCell
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellRenderer * Result = (wxGridCellRenderer*)This->GetDefaultRendererForCell(*row,*col);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellRenderer");
 break;
}
case wxGrid_GetDefaultRendererForType: { // wxGrid::GetDefaultRendererForType
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * typeNameLen = (int *) bp; bp += 4;
 wxString typeName = wxString(bp, wxConvUTF8);
 bp += *typeNameLen+((8-((0+ *typeNameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxGridCellRenderer * Result = (wxGridCellRenderer*)This->GetDefaultRendererForType(typeName);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellRenderer");
 break;
}
case wxGrid_GetDefaultRowLabelSize: { // wxGrid::GetDefaultRowLabelSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDefaultRowLabelSize();
 rt.addInt(Result);
 break;
}
case wxGrid_GetDefaultRowSize: { // wxGrid::GetDefaultRowSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDefaultRowSize();
 rt.addInt(Result);
 break;
}
case wxGrid_GetGridCursorCol: { // wxGrid::GetGridCursorCol
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetGridCursorCol();
 rt.addInt(Result);
 break;
}
case wxGrid_GetGridCursorRow: { // wxGrid::GetGridCursorRow
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetGridCursorRow();
 rt.addInt(Result);
 break;
}
case wxGrid_GetGridLineColour: { // wxGrid::GetGridLineColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetGridLineColour();
 rt.add(Result);
 break;
}
case wxGrid_GridLinesEnabled: { // wxGrid::GridLinesEnabled
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GridLinesEnabled();
 rt.addBool(Result);
 break;
}
case wxGrid_GetLabelBackgroundColour: { // wxGrid::GetLabelBackgroundColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetLabelBackgroundColour();
 rt.add(Result);
 break;
}
case wxGrid_GetLabelFont: { // wxGrid::GetLabelFont
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetLabelFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxGrid_GetLabelTextColour: { // wxGrid::GetLabelTextColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetLabelTextColour();
 rt.add(Result);
 break;
}
case wxGrid_GetNumberCols: { // wxGrid::GetNumberCols
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetNumberCols();
 rt.addInt(Result);
 break;
}
case wxGrid_GetNumberRows: { // wxGrid::GetNumberRows
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetNumberRows();
 rt.addInt(Result);
 break;
}
case wxGrid_GetOrCreateCellAttr: { // wxGrid::GetOrCreateCellAttr
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellAttr * Result = (wxGridCellAttr*)This->GetOrCreateCellAttr(*row,*col);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellAttr");
 break;
}
case wxGrid_GetRowMinimalAcceptableHeight: { // wxGrid::GetRowMinimalAcceptableHeight
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRowMinimalAcceptableHeight();
 rt.addInt(Result);
 break;
}
case wxGrid_GetRowLabelAlignment: { // wxGrid::GetRowLabelAlignment
 int horiz;
 int vert;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetRowLabelAlignment(&horiz,&vert);
 rt.addInt(horiz);
 rt.addInt(vert);
 rt.addTupleCount(2);
 break;
}
case wxGrid_GetRowLabelSize: { // wxGrid::GetRowLabelSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRowLabelSize();
 rt.addInt(Result);
 break;
}
case wxGrid_GetRowLabelValue: { // wxGrid::GetRowLabelValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetRowLabelValue(*row);
 rt.add(Result);
 break;
}
case wxGrid_GetRowSize: { // wxGrid::GetRowSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRowSize(*row);
 rt.addInt(Result);
 break;
}
case wxGrid_GetScrollLineX: { // wxGrid::GetScrollLineX
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetScrollLineX();
 rt.addInt(Result);
 break;
}
case wxGrid_GetScrollLineY: { // wxGrid::GetScrollLineY
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetScrollLineY();
 rt.addInt(Result);
 break;
}
case wxGrid_GetSelectedCells: { // wxGrid::GetSelectedCells
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellCoordsArray Result = This->GetSelectedCells();
 for(unsigned int i=0; i < Result.GetCount(); i++) {
  rt.add(Result[i]);
 }
 rt.endList(Result.GetCount());
 break;
}
case wxGrid_GetSelectedCols: { // wxGrid::GetSelectedCols
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxArrayInt Result = This->GetSelectedCols();
 rt.add(Result);
 break;
}
case wxGrid_GetSelectedRows: { // wxGrid::GetSelectedRows
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxArrayInt Result = This->GetSelectedRows();
 rt.add(Result);
 break;
}
case wxGrid_GetSelectionBackground: { // wxGrid::GetSelectionBackground
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetSelectionBackground();
 rt.add(Result);
 break;
}
case wxGrid_GetSelectionBlockTopLeft: { // wxGrid::GetSelectionBlockTopLeft
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellCoordsArray Result = This->GetSelectionBlockTopLeft();
 for(unsigned int i=0; i < Result.GetCount(); i++) {
  rt.add(Result[i]);
 }
 rt.endList(Result.GetCount());
 break;
}
case wxGrid_GetSelectionBlockBottomRight: { // wxGrid::GetSelectionBlockBottomRight
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellCoordsArray Result = This->GetSelectionBlockBottomRight();
 for(unsigned int i=0; i < Result.GetCount(); i++) {
  rt.add(Result[i]);
 }
 rt.endList(Result.GetCount());
 break;
}
case wxGrid_GetSelectionForeground: { // wxGrid::GetSelectionForeground
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetSelectionForeground();
 rt.add(Result);
 break;
}
case wxGrid_GetViewWidth: { // wxGrid::GetViewWidth
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetViewWidth();
 rt.addInt(Result);
 break;
}
case wxGrid_GetGridWindow: { // wxGrid::GetGridWindow
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetGridWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxGrid_GetGridRowLabelWindow: { // wxGrid::GetGridRowLabelWindow
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetGridRowLabelWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxGrid_GetGridColLabelWindow: { // wxGrid::GetGridColLabelWindow
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetGridColLabelWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxGrid_GetGridCornerLabelWindow: { // wxGrid::GetGridCornerLabelWindow
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetGridCornerLabelWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxGrid_HideCellEditControl: { // wxGrid::HideCellEditControl
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->HideCellEditControl();
 break;
}
case wxGrid_InsertCols: { // wxGrid::InsertCols
 int pos=0;
 int numCols=1;
 bool updateLabels=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 pos = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 numCols = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 updateLabels = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertCols(pos,numCols,updateLabels);
 rt.addBool(Result);
 break;
}
case wxGrid_InsertRows: { // wxGrid::InsertRows
 int pos=0;
 int numRows=1;
 bool updateLabels=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 pos = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 numRows = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 updateLabels = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertRows(pos,numRows,updateLabels);
 rt.addBool(Result);
 break;
}
case wxGrid_IsCellEditControlEnabled: { // wxGrid::IsCellEditControlEnabled
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsCellEditControlEnabled();
 rt.addBool(Result);
 break;
}
case wxGrid_IsCurrentCellReadOnly: { // wxGrid::IsCurrentCellReadOnly
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsCurrentCellReadOnly();
 rt.addBool(Result);
 break;
}
case wxGrid_IsEditable: { // wxGrid::IsEditable
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEditable();
 rt.addBool(Result);
 break;
}
case wxGrid_IsInSelection_2: { // wxGrid::IsInSelection
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsInSelection(*row,*col);
 rt.addBool(Result);
 break;
}
case wxGrid_IsInSelection_1: { // wxGrid::IsInSelection
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * coordsR = (int *) bp; bp += 4;
 int * coordsC = (int *) bp; bp += 4;
 wxGridCellCoords coords = wxGridCellCoords(*coordsR,*coordsC);
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsInSelection(coords);
 rt.addBool(Result);
 break;
}
case wxGrid_IsReadOnly: { // wxGrid::IsReadOnly
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsReadOnly(*row,*col);
 rt.addBool(Result);
 break;
}
case wxGrid_IsSelection: { // wxGrid::IsSelection
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSelection();
 rt.addBool(Result);
 break;
}
case wxGrid_IsVisible_3: { // wxGrid::IsVisible
 bool wholeCellVisible=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 wholeCellVisible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsVisible(*row,*col,wholeCellVisible);
 rt.addBool(Result);
 break;
}
case wxGrid_IsVisible_2: { // wxGrid::IsVisible
 bool wholeCellVisible=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * coordsR = (int *) bp; bp += 4;
 int * coordsC = (int *) bp; bp += 4;
 wxGridCellCoords coords = wxGridCellCoords(*coordsR,*coordsC);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 wholeCellVisible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsVisible(coords,wholeCellVisible);
 rt.addBool(Result);
 break;
}
case wxGrid_MakeCellVisible_2: { // wxGrid::MakeCellVisible
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MakeCellVisible(*row,*col);
 break;
}
case wxGrid_MakeCellVisible_1: { // wxGrid::MakeCellVisible
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * coordsR = (int *) bp; bp += 4;
 int * coordsC = (int *) bp; bp += 4;
 wxGridCellCoords coords = wxGridCellCoords(*coordsR,*coordsC);
 if(!This) throw wxe_badarg(0);
 This->MakeCellVisible(coords);
 break;
}
case wxGrid_MoveCursorDown: { // wxGrid::MoveCursorDown
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * expandSelection = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoveCursorDown(*expandSelection);
 rt.addBool(Result);
 break;
}
case wxGrid_MoveCursorLeft: { // wxGrid::MoveCursorLeft
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * expandSelection = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoveCursorLeft(*expandSelection);
 rt.addBool(Result);
 break;
}
case wxGrid_MoveCursorRight: { // wxGrid::MoveCursorRight
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * expandSelection = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoveCursorRight(*expandSelection);
 rt.addBool(Result);
 break;
}
case wxGrid_MoveCursorUp: { // wxGrid::MoveCursorUp
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * expandSelection = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoveCursorUp(*expandSelection);
 rt.addBool(Result);
 break;
}
case wxGrid_MoveCursorDownBlock: { // wxGrid::MoveCursorDownBlock
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * expandSelection = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoveCursorDownBlock(*expandSelection);
 rt.addBool(Result);
 break;
}
case wxGrid_MoveCursorLeftBlock: { // wxGrid::MoveCursorLeftBlock
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * expandSelection = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoveCursorLeftBlock(*expandSelection);
 rt.addBool(Result);
 break;
}
case wxGrid_MoveCursorRightBlock: { // wxGrid::MoveCursorRightBlock
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * expandSelection = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoveCursorRightBlock(*expandSelection);
 rt.addBool(Result);
 break;
}
case wxGrid_MoveCursorUpBlock: { // wxGrid::MoveCursorUpBlock
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 bool * expandSelection = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoveCursorUpBlock(*expandSelection);
 rt.addBool(Result);
 break;
}
case wxGrid_MovePageDown: { // wxGrid::MovePageDown
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MovePageDown();
 rt.addBool(Result);
 break;
}
case wxGrid_MovePageUp: { // wxGrid::MovePageUp
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MovePageUp();
 rt.addBool(Result);
 break;
}
case wxGrid_RegisterDataType: { // wxGrid::RegisterDataType
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * typeNameLen = (int *) bp; bp += 4;
 wxString typeName = wxString(bp, wxConvUTF8);
 bp += *typeNameLen+((8-((0+ *typeNameLen) & 7)) & 7);
 wxGridCellRenderer *renderer = (wxGridCellRenderer *) getPtr(bp,memenv); bp += 4;
 wxGridCellEditor *editor = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->RegisterDataType(typeName,renderer,editor);
 break;
}
case wxGrid_SaveEditControlValue: { // wxGrid::SaveEditControlValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SaveEditControlValue();
 break;
}
case wxGrid_SelectAll: { // wxGrid::SelectAll
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SelectAll();
 break;
}
case wxGrid_SelectBlock_5: { // wxGrid::SelectBlock
 bool addToSelected=false;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * topRow = (int *) bp; bp += 4;
 int * leftCol = (int *) bp; bp += 4;
 int * bottomRow = (int *) bp; bp += 4;
 int * rightCol = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 addToSelected = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SelectBlock(*topRow,*leftCol,*bottomRow,*rightCol,addToSelected);
 break;
}
case wxGrid_SelectBlock_3: { // wxGrid::SelectBlock
 bool addToSelected=false;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * topLeftR = (int *) bp; bp += 4;
 int * topLeftC = (int *) bp; bp += 4;
 wxGridCellCoords topLeft = wxGridCellCoords(*topLeftR,*topLeftC);
 int * bottomRightR = (int *) bp; bp += 4;
 int * bottomRightC = (int *) bp; bp += 4;
 wxGridCellCoords bottomRight = wxGridCellCoords(*bottomRightR,*bottomRightC);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 addToSelected = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SelectBlock(topLeft,bottomRight,addToSelected);
 break;
}
case wxGrid_SelectCol: { // wxGrid::SelectCol
 bool addToSelected=false;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 addToSelected = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SelectCol(*col,addToSelected);
 break;
}
case wxGrid_SelectRow: { // wxGrid::SelectRow
 bool addToSelected=false;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 addToSelected = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SelectRow(*row,addToSelected);
 break;
}
case wxGrid_SetCellAlignment_4: { // wxGrid::SetCellAlignment
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 int * horiz = (int *) bp; bp += 4;
 int * vert = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellAlignment(*row,*col,*horiz,*vert);
 break;
}
case wxGrid_SetCellAlignment_3: { // wxGrid::SetCellAlignment
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * align = (int *) bp; bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellAlignment(*align,*row,*col);
 break;
}
case wxGrid_SetCellAlignment_1: { // wxGrid::SetCellAlignment
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * align = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellAlignment(*align);
 break;
}
case wxGrid_SetCellBackgroundColour_3_0: { // wxGrid::SetCellBackgroundColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 int * valR = (int *) bp; bp += 4;
 int * valG = (int *) bp; bp += 4;
 int * valB = (int *) bp; bp += 4;
 int * valA = (int *) bp; bp += 4;
 wxColour val = wxColour(*valR,*valG,*valB,*valA);
 if(!This) throw wxe_badarg(0);
 This->SetCellBackgroundColour(*row,*col,val);
 break;
}
case wxGrid_SetCellBackgroundColour_1: { // wxGrid::SetCellBackgroundColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetCellBackgroundColour(col);
 break;
}
case wxGrid_SetCellBackgroundColour_3_1: { // wxGrid::SetCellBackgroundColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellBackgroundColour(colour,*row,*col);
 break;
}
case wxGrid_SetCellEditor: { // wxGrid::SetCellEditor
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 wxGridCellEditor *editor = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellEditor(*row,*col,editor);
 break;
}
case wxGrid_SetCellFont: { // wxGrid::SetCellFont
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 wxFont *val = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellFont(*row,*col,*val);
 break;
}
case wxGrid_SetCellRenderer: { // wxGrid::SetCellRenderer
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 wxGridCellRenderer *renderer = (wxGridCellRenderer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellRenderer(*row,*col,renderer);
 break;
}
case wxGrid_SetCellTextColour_3_0: { // wxGrid::SetCellTextColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 int * valR = (int *) bp; bp += 4;
 int * valG = (int *) bp; bp += 4;
 int * valB = (int *) bp; bp += 4;
 int * valA = (int *) bp; bp += 4;
 wxColour val = wxColour(*valR,*valG,*valB,*valA);
 if(!This) throw wxe_badarg(0);
 This->SetCellTextColour(*row,*col,val);
 break;
}
case wxGrid_SetCellTextColour_3_1: { // wxGrid::SetCellTextColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * valR = (int *) bp; bp += 4;
 int * valG = (int *) bp; bp += 4;
 int * valB = (int *) bp; bp += 4;
 int * valA = (int *) bp; bp += 4;
 wxColour val = wxColour(*valR,*valG,*valB,*valA);
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellTextColour(val,*row,*col);
 break;
}
case wxGrid_SetCellTextColour_1: { // wxGrid::SetCellTextColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetCellTextColour(col);
 break;
}
case wxGrid_SetCellValue_3_0: { // wxGrid::SetCellValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 int * sLen = (int *) bp; bp += 4;
 wxString s = wxString(bp, wxConvUTF8);
 bp += *sLen+((8-((0+ *sLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetCellValue(*row,*col,s);
 break;
}
case wxGrid_SetCellValue_2: { // wxGrid::SetCellValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * coordsR = (int *) bp; bp += 4;
 int * coordsC = (int *) bp; bp += 4;
 wxGridCellCoords coords = wxGridCellCoords(*coordsR,*coordsC);
 int * sLen = (int *) bp; bp += 4;
 wxString s = wxString(bp, wxConvUTF8);
 bp += *sLen+((8-((0+ *sLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetCellValue(coords,s);
 break;
}
case wxGrid_SetCellValue_3_1: { // wxGrid::SetCellValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * valLen = (int *) bp; bp += 4;
 wxString val = wxString(bp, wxConvUTF8);
 bp += *valLen+((8-((0+ *valLen) & 7)) & 7);
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCellValue(val,*row,*col);
 break;
}
case wxGrid_SetColAttr: { // wxGrid::SetColAttr
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 wxGridCellAttr *attr = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColAttr(*col,attr);
 break;
}
case wxGrid_SetColFormatBool: { // wxGrid::SetColFormatBool
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColFormatBool(*col);
 break;
}
case wxGrid_SetColFormatNumber: { // wxGrid::SetColFormatNumber
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColFormatNumber(*col);
 break;
}
case wxGrid_SetColFormatFloat: { // wxGrid::SetColFormatFloat
 int width=-1;
 int precision=-1;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 width = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 precision = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetColFormatFloat(*col,width,precision);
 break;
}
case wxGrid_SetColFormatCustom: { // wxGrid::SetColFormatCustom
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 int * typeNameLen = (int *) bp; bp += 4;
 wxString typeName = wxString(bp, wxConvUTF8);
 bp += *typeNameLen+((8-((4+ *typeNameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetColFormatCustom(*col,typeName);
 break;
}
case wxGrid_SetColLabelAlignment: { // wxGrid::SetColLabelAlignment
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * horiz = (int *) bp; bp += 4;
 int * vert = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColLabelAlignment(*horiz,*vert);
 break;
}
case wxGrid_SetColLabelSize: { // wxGrid::SetColLabelSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColLabelSize(*height);
 break;
}
case wxGrid_SetColLabelValue: { // wxGrid::SetColLabelValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 int * valLen = (int *) bp; bp += 4;
 wxString val = wxString(bp, wxConvUTF8);
 bp += *valLen+((8-((4+ *valLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetColLabelValue(*col,val);
 break;
}
case wxGrid_SetColMinimalWidth: { // wxGrid::SetColMinimalWidth
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColMinimalWidth(*col,*width);
 break;
}
case wxGrid_SetColMinimalAcceptableWidth: { // wxGrid::SetColMinimalAcceptableWidth
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColMinimalAcceptableWidth(*width);
 break;
}
case wxGrid_SetColSize: { // wxGrid::SetColSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColSize(*col,*width);
 break;
}
case wxGrid_SetDefaultCellAlignment: { // wxGrid::SetDefaultCellAlignment
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * horiz = (int *) bp; bp += 4;
 int * vert = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDefaultCellAlignment(*horiz,*vert);
 break;
}
case wxGrid_SetDefaultCellBackgroundColour: { // wxGrid::SetDefaultCellBackgroundColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * valR = (int *) bp; bp += 4;
 int * valG = (int *) bp; bp += 4;
 int * valB = (int *) bp; bp += 4;
 int * valA = (int *) bp; bp += 4;
 wxColour val = wxColour(*valR,*valG,*valB,*valA);
 if(!This) throw wxe_badarg(0);
 This->SetDefaultCellBackgroundColour(val);
 break;
}
case wxGrid_SetDefaultCellFont: { // wxGrid::SetDefaultCellFont
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 wxFont *val = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDefaultCellFont(*val);
 break;
}
case wxGrid_SetDefaultCellTextColour: { // wxGrid::SetDefaultCellTextColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * valR = (int *) bp; bp += 4;
 int * valG = (int *) bp; bp += 4;
 int * valB = (int *) bp; bp += 4;
 int * valA = (int *) bp; bp += 4;
 wxColour val = wxColour(*valR,*valG,*valB,*valA);
 if(!This) throw wxe_badarg(0);
 This->SetDefaultCellTextColour(val);
 break;
}
case wxGrid_SetDefaultEditor: { // wxGrid::SetDefaultEditor
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 wxGridCellEditor *editor = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDefaultEditor(editor);
 break;
}
case wxGrid_SetDefaultRenderer: { // wxGrid::SetDefaultRenderer
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 wxGridCellRenderer *renderer = (wxGridCellRenderer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDefaultRenderer(renderer);
 break;
}
case wxGrid_SetDefaultColSize: { // wxGrid::SetDefaultColSize
 bool resizeExistingCols=false;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 resizeExistingCols = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetDefaultColSize(*width,resizeExistingCols);
 break;
}
case wxGrid_SetDefaultRowSize: { // wxGrid::SetDefaultRowSize
 bool resizeExistingRows=false;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * height = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 resizeExistingRows = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetDefaultRowSize(*height,resizeExistingRows);
 break;
}
case wxGrid_SetGridCursor: { // wxGrid::SetGridCursor
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetGridCursor(*row,*col);
 break;
}
case wxGrid_SetGridLineColour: { // wxGrid::SetGridLineColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * valR = (int *) bp; bp += 4;
 int * valG = (int *) bp; bp += 4;
 int * valB = (int *) bp; bp += 4;
 int * valA = (int *) bp; bp += 4;
 wxColour val = wxColour(*valR,*valG,*valB,*valA);
 if(!This) throw wxe_badarg(0);
 This->SetGridLineColour(val);
 break;
}
case wxGrid_SetLabelBackgroundColour: { // wxGrid::SetLabelBackgroundColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * valR = (int *) bp; bp += 4;
 int * valG = (int *) bp; bp += 4;
 int * valB = (int *) bp; bp += 4;
 int * valA = (int *) bp; bp += 4;
 wxColour val = wxColour(*valR,*valG,*valB,*valA);
 if(!This) throw wxe_badarg(0);
 This->SetLabelBackgroundColour(val);
 break;
}
case wxGrid_SetLabelFont: { // wxGrid::SetLabelFont
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 wxFont *val = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetLabelFont(*val);
 break;
}
case wxGrid_SetLabelTextColour: { // wxGrid::SetLabelTextColour
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * valR = (int *) bp; bp += 4;
 int * valG = (int *) bp; bp += 4;
 int * valB = (int *) bp; bp += 4;
 int * valA = (int *) bp; bp += 4;
 wxColour val = wxColour(*valR,*valG,*valB,*valA);
 if(!This) throw wxe_badarg(0);
 This->SetLabelTextColour(val);
 break;
}
case wxGrid_SetMargins: { // wxGrid::SetMargins
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * extraWidth = (int *) bp; bp += 4;
 int * extraHeight = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMargins(*extraWidth,*extraHeight);
 break;
}
case wxGrid_SetReadOnly: { // wxGrid::SetReadOnly
 bool isReadOnly=true;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 isReadOnly = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetReadOnly(*row,*col,isReadOnly);
 break;
}
case wxGrid_SetRowAttr: { // wxGrid::SetRowAttr
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 wxGridCellAttr *attr = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRowAttr(*row,attr);
 break;
}
case wxGrid_SetRowLabelAlignment: { // wxGrid::SetRowLabelAlignment
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * horiz = (int *) bp; bp += 4;
 int * vert = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRowLabelAlignment(*horiz,*vert);
 break;
}
case wxGrid_SetRowLabelSize: { // wxGrid::SetRowLabelSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRowLabelSize(*width);
 break;
}
case wxGrid_SetRowLabelValue: { // wxGrid::SetRowLabelValue
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * valLen = (int *) bp; bp += 4;
 wxString val = wxString(bp, wxConvUTF8);
 bp += *valLen+((8-((4+ *valLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetRowLabelValue(*row,val);
 break;
}
case wxGrid_SetRowMinimalHeight: { // wxGrid::SetRowMinimalHeight
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRowMinimalHeight(*row,*width);
 break;
}
case wxGrid_SetRowMinimalAcceptableHeight: { // wxGrid::SetRowMinimalAcceptableHeight
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRowMinimalAcceptableHeight(*width);
 break;
}
case wxGrid_SetRowSize: { // wxGrid::SetRowSize
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRowSize(*row,*height);
 break;
}
case wxGrid_SetScrollLineX: { // wxGrid::SetScrollLineX
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetScrollLineX(*x);
 break;
}
case wxGrid_SetScrollLineY: { // wxGrid::SetScrollLineY
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetScrollLineY(*y);
 break;
}
case wxGrid_SetSelectionBackground: { // wxGrid::SetSelectionBackground
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * cR = (int *) bp; bp += 4;
 int * cG = (int *) bp; bp += 4;
 int * cB = (int *) bp; bp += 4;
 int * cA = (int *) bp; bp += 4;
 wxColour c = wxColour(*cR,*cG,*cB,*cA);
 if(!This) throw wxe_badarg(0);
 This->SetSelectionBackground(c);
 break;
}
case wxGrid_SetSelectionForeground: { // wxGrid::SetSelectionForeground
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * cR = (int *) bp; bp += 4;
 int * cG = (int *) bp; bp += 4;
 int * cB = (int *) bp; bp += 4;
 int * cA = (int *) bp; bp += 4;
 wxColour c = wxColour(*cR,*cG,*cB,*cA);
 if(!This) throw wxe_badarg(0);
 This->SetSelectionForeground(c);
 break;
}
case wxGrid_SetSelectionMode: { // wxGrid::SetSelectionMode
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 wxGrid::wxGridSelectionModes selmode = *(wxGrid::wxGridSelectionModes *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetSelectionMode(selmode);
 break;
}
case wxGrid_ShowCellEditControl: { // wxGrid::ShowCellEditControl
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ShowCellEditControl();
 break;
}
case wxGrid_XToCol: { // wxGrid::XToCol
 bool clipToMinMax=false;
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 clipToMinMax = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 int Result = This->XToCol(*x,clipToMinMax);
 rt.addInt(Result);
 break;
}
case wxGrid_XToEdgeOfCol: { // wxGrid::XToEdgeOfCol
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->XToEdgeOfCol(*x);
 rt.addInt(Result);
 break;
}
case wxGrid_YToEdgeOfRow: { // wxGrid::YToEdgeOfRow
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->YToEdgeOfRow(*y);
 rt.addInt(Result);
 break;
}
case wxGrid_YToRow: { // wxGrid::YToRow
 wxGrid *This = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->YToRow(*y);
 rt.addInt(Result);
 break;
}
case wxGridCellRenderer_Draw: { // wxGridCellRenderer::Draw
 wxGridCellRenderer *This = (wxGridCellRenderer *) getPtr(bp,memenv); bp += 4;
 wxGrid *grid = (wxGrid *) getPtr(bp,memenv); bp += 4;
 wxGridCellAttr *attr = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 bool * isSelected = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Draw(*grid,*attr,*dc,rect,*row,*col,*isSelected);
 break;
}
case wxGridCellRenderer_GetBestSize: { // wxGridCellRenderer::GetBestSize
 wxGridCellRenderer *This = (wxGridCellRenderer *) getPtr(bp,memenv); bp += 4;
 wxGrid *grid = (wxGrid *) getPtr(bp,memenv); bp += 4;
 wxGridCellAttr *attr = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetBestSize(*grid,*attr,*dc,*row,*col);
 rt.add(Result);
 break;
}
case wxGridCellEditor_Create: { // wxGridCellEditor::Create
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 wxEvtHandler *evtHandler = (wxEvtHandler *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Create(parent,*id,evtHandler);
 break;
}
case wxGridCellEditor_IsCreated: { // wxGridCellEditor::IsCreated
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsCreated();
 rt.addBool(Result);
 break;
}
case wxGridCellEditor_SetSize: { // wxGridCellEditor::SetSize
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 This->SetSize(rect);
 break;
}
case wxGridCellEditor_Show: { // wxGridCellEditor::Show
 wxGridCellAttr * attr=(wxGridCellAttr *) NULL;
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
attr = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Show(*show,attr);
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxGridCellEditor_PaintBackground: { // wxGridCellEditor::PaintBackground
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 int * rectCellX = (int *) bp; bp += 4;
 int * rectCellY = (int *) bp; bp += 4;
 int * rectCellW = (int *) bp; bp += 4;
 int * rectCellH = (int *) bp; bp += 4;
 wxRect rectCell = wxRect(*rectCellX,*rectCellY,*rectCellW,*rectCellH);
 wxGridCellAttr *attr = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->PaintBackground(rectCell,attr);
 break;
}
#endif
case wxGridCellEditor_BeginEdit: { // wxGridCellEditor::BeginEdit
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 wxGrid *grid = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->BeginEdit(*row,*col,grid);
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxGridCellEditor_EndEdit: { // wxGridCellEditor::EndEdit
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 wxGrid *grid = (wxGrid *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->EndEdit(*row,*col,grid);
 rt.addBool(Result);
 break;
}
#endif
case wxGridCellEditor_Reset: { // wxGridCellEditor::Reset
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Reset();
 break;
}
case wxGridCellEditor_StartingKey: { // wxGridCellEditor::StartingKey
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 wxKeyEvent *event = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StartingKey(*event);
 break;
}
case wxGridCellEditor_StartingClick: { // wxGridCellEditor::StartingClick
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StartingClick();
 break;
}
case wxGridCellEditor_HandleReturn: { // wxGridCellEditor::HandleReturn
 wxGridCellEditor *This = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 wxKeyEvent *event = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->HandleReturn(*event);
 break;
}
case wxGridCellBoolRenderer_new: { // wxGridCellBoolRenderer::wxGridCellBoolRenderer
 wxGridCellBoolRenderer * Result = new wxGridCellBoolRenderer();
 newPtr((void *) Result, 24, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellBoolRenderer");
 break;
}
case wxGridCellBoolRenderer_destroy: { // wxGridCellBoolRenderer::destroy
 wxGridCellBoolRenderer *This = (wxGridCellBoolRenderer *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellBoolEditor_new: { // wxGridCellBoolEditor::wxGridCellBoolEditor
 wxGridCellBoolEditor * Result = new wxGridCellBoolEditor();
 newPtr((void *) Result, 25, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellBoolEditor");
 break;
}
case wxGridCellBoolEditor_IsTrueValue: { // wxGridCellBoolEditor::IsTrueValue
 int * valueLen = (int *) bp; bp += 4;
 wxString value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((4+ *valueLen) & 7)) & 7);
 bool Result = wxGridCellBoolEditor::IsTrueValue(value);
 rt.addBool(Result);
 break;
}
case wxGridCellBoolEditor_UseStringValues: { // wxGridCellBoolEditor::UseStringValues
 wxString valueTrue= wxT("1");
 wxString valueFalse= wxEmptyString;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * valueTrueLen = (int *) bp; bp += 4;
 valueTrue = wxString(bp, wxConvUTF8);
 bp += *valueTrueLen+((8-((0+ *valueTrueLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * valueFalseLen = (int *) bp; bp += 4;
 valueFalse = wxString(bp, wxConvUTF8);
 bp += *valueFalseLen+((8-((0+ *valueFalseLen) & 7)) & 7);
  } break;
 }};
 wxGridCellBoolEditor::UseStringValues(valueTrue,valueFalse);
 break;
}
case wxGridCellBoolEditor_destroy: { // wxGridCellBoolEditor::destroy
 wxGridCellBoolEditor *This = (wxGridCellBoolEditor *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellFloatRenderer_new: { // wxGridCellFloatRenderer::wxGridCellFloatRenderer
 int width=-1;
 int precision=-1;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 width = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 precision = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxGridCellFloatRenderer * Result = new wxGridCellFloatRenderer(width,precision);
 newPtr((void *) Result, 26, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellFloatRenderer");
 break;
}
case wxGridCellFloatRenderer_GetPrecision: { // wxGridCellFloatRenderer::GetPrecision
 wxGridCellFloatRenderer *This = (wxGridCellFloatRenderer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPrecision();
 rt.addInt(Result);
 break;
}
case wxGridCellFloatRenderer_GetWidth: { // wxGridCellFloatRenderer::GetWidth
 wxGridCellFloatRenderer *This = (wxGridCellFloatRenderer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWidth();
 rt.addInt(Result);
 break;
}
case wxGridCellFloatRenderer_SetParameters: { // wxGridCellFloatRenderer::SetParameters
 wxGridCellFloatRenderer *This = (wxGridCellFloatRenderer *) getPtr(bp,memenv); bp += 4;
 int * paramsLen = (int *) bp; bp += 4;
 wxString params = wxString(bp, wxConvUTF8);
 bp += *paramsLen+((8-((0+ *paramsLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetParameters(params);
 break;
}
case wxGridCellFloatRenderer_SetPrecision: { // wxGridCellFloatRenderer::SetPrecision
 wxGridCellFloatRenderer *This = (wxGridCellFloatRenderer *) getPtr(bp,memenv); bp += 4;
 int * precision = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPrecision(*precision);
 break;
}
case wxGridCellFloatRenderer_SetWidth: { // wxGridCellFloatRenderer::SetWidth
 wxGridCellFloatRenderer *This = (wxGridCellFloatRenderer *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWidth(*width);
 break;
}
case wxGridCellFloatRenderer_destroy: { // wxGridCellFloatRenderer::destroy
 wxGridCellFloatRenderer *This = (wxGridCellFloatRenderer *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellFloatEditor_new: { // wxGridCellFloatEditor::wxGridCellFloatEditor
 int width=-1;
 int precision=-1;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 width = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 precision = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxGridCellFloatEditor * Result = new wxGridCellFloatEditor(width,precision);
 newPtr((void *) Result, 27, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellFloatEditor");
 break;
}
case wxGridCellFloatEditor_SetParameters: { // wxGridCellFloatEditor::SetParameters
 wxGridCellFloatEditor *This = (wxGridCellFloatEditor *) getPtr(bp,memenv); bp += 4;
 int * paramsLen = (int *) bp; bp += 4;
 wxString params = wxString(bp, wxConvUTF8);
 bp += *paramsLen+((8-((0+ *paramsLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetParameters(params);
 break;
}
case wxGridCellFloatEditor_destroy: { // wxGridCellFloatEditor::destroy
 wxGridCellFloatEditor *This = (wxGridCellFloatEditor *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellStringRenderer_new: { // wxGridCellStringRenderer::wxGridCellStringRenderer
 wxGridCellStringRenderer * Result = new wxGridCellStringRenderer();
 newPtr((void *) Result, 28, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellStringRenderer");
 break;
}
case wxGridCellStringRenderer_destroy: { // wxGridCellStringRenderer::destroy
 wxGridCellStringRenderer *This = (wxGridCellStringRenderer *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellTextEditor_new: { // wxGridCellTextEditor::wxGridCellTextEditor
 wxGridCellTextEditor * Result = new wxGridCellTextEditor();
 newPtr((void *) Result, 29, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellTextEditor");
 break;
}
case wxGridCellTextEditor_SetParameters: { // wxGridCellTextEditor::SetParameters
 wxGridCellTextEditor *This = (wxGridCellTextEditor *) getPtr(bp,memenv); bp += 4;
 int * paramsLen = (int *) bp; bp += 4;
 wxString params = wxString(bp, wxConvUTF8);
 bp += *paramsLen+((8-((0+ *paramsLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetParameters(params);
 break;
}
case wxGridCellTextEditor_destroy: { // wxGridCellTextEditor::destroy
 wxGridCellTextEditor *This = (wxGridCellTextEditor *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellChoiceEditor_new: { // wxGridCellChoiceEditor::wxGridCellChoiceEditor
 bool allowOthers=false;
 int * choicesLen = (int *) bp; bp += 4;
 wxArrayString choices;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((4+ choicesASz) & 7 )) & 7;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 allowOthers = *(bool *) bp; bp += 4;
  } break;
 }};
 wxGridCellChoiceEditor * Result = new wxGridCellChoiceEditor(choices,allowOthers);
 newPtr((void *) Result, 30, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellChoiceEditor");
 break;
}
case wxGridCellChoiceEditor_SetParameters: { // wxGridCellChoiceEditor::SetParameters
 wxGridCellChoiceEditor *This = (wxGridCellChoiceEditor *) getPtr(bp,memenv); bp += 4;
 int * paramsLen = (int *) bp; bp += 4;
 wxString params = wxString(bp, wxConvUTF8);
 bp += *paramsLen+((8-((0+ *paramsLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetParameters(params);
 break;
}
case wxGridCellChoiceEditor_destroy: { // wxGridCellChoiceEditor::destroy
 wxGridCellChoiceEditor *This = (wxGridCellChoiceEditor *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellNumberRenderer_new: { // wxGridCellNumberRenderer::wxGridCellNumberRenderer
 wxGridCellNumberRenderer * Result = new wxGridCellNumberRenderer();
 newPtr((void *) Result, 31, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellNumberRenderer");
 break;
}
case wxGridCellNumberRenderer_destroy: { // wxGridCellNumberRenderer::destroy
 wxGridCellNumberRenderer *This = (wxGridCellNumberRenderer *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellNumberEditor_new: { // wxGridCellNumberEditor::wxGridCellNumberEditor
 int min=-1;
 int max=-1;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 min = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 max = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxGridCellNumberEditor * Result = new wxGridCellNumberEditor(min,max);
 newPtr((void *) Result, 32, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellNumberEditor");
 break;
}
case wxGridCellNumberEditor_GetValue: { // wxGridCellNumberEditor::GetValue
 wxGridCellNumberEditor *This = (wxGridCellNumberEditor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetValue();
 rt.add(Result);
 break;
}
case wxGridCellNumberEditor_SetParameters: { // wxGridCellNumberEditor::SetParameters
 wxGridCellNumberEditor *This = (wxGridCellNumberEditor *) getPtr(bp,memenv); bp += 4;
 int * paramsLen = (int *) bp; bp += 4;
 wxString params = wxString(bp, wxConvUTF8);
 bp += *paramsLen+((8-((0+ *paramsLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetParameters(params);
 break;
}
case wxGridCellNumberEditor_destroy: { // wxGridCellNumberEditor::destroy
 wxGridCellNumberEditor *This = (wxGridCellNumberEditor *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxGridCellAttr_SetTextColour: { // wxGridCellAttr::SetTextColour
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 int * colTextR = (int *) bp; bp += 4;
 int * colTextG = (int *) bp; bp += 4;
 int * colTextB = (int *) bp; bp += 4;
 int * colTextA = (int *) bp; bp += 4;
 wxColour colText = wxColour(*colTextR,*colTextG,*colTextB,*colTextA);
 if(!This) throw wxe_badarg(0);
 This->SetTextColour(colText);
 break;
}
case wxGridCellAttr_SetBackgroundColour: { // wxGridCellAttr::SetBackgroundColour
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 int * colBackR = (int *) bp; bp += 4;
 int * colBackG = (int *) bp; bp += 4;
 int * colBackB = (int *) bp; bp += 4;
 int * colBackA = (int *) bp; bp += 4;
 wxColour colBack = wxColour(*colBackR,*colBackG,*colBackB,*colBackA);
 if(!This) throw wxe_badarg(0);
 This->SetBackgroundColour(colBack);
 break;
}
case wxGridCellAttr_SetFont: { // wxGridCellAttr::SetFont
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFont(*font);
 break;
}
case wxGridCellAttr_SetAlignment: { // wxGridCellAttr::SetAlignment
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 int * hAlign = (int *) bp; bp += 4;
 int * vAlign = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAlignment(*hAlign,*vAlign);
 break;
}
case wxGridCellAttr_SetReadOnly: { // wxGridCellAttr::SetReadOnly
 bool isReadOnly=true;
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 isReadOnly = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetReadOnly(isReadOnly);
 break;
}
case wxGridCellAttr_SetRenderer: { // wxGridCellAttr::SetRenderer
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 wxGridCellRenderer *renderer = (wxGridCellRenderer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRenderer(renderer);
 break;
}
case wxGridCellAttr_SetEditor: { // wxGridCellAttr::SetEditor
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 wxGridCellEditor *editor = (wxGridCellEditor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetEditor(editor);
 break;
}
case wxGridCellAttr_HasTextColour: { // wxGridCellAttr::HasTextColour
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasTextColour();
 rt.addBool(Result);
 break;
}
case wxGridCellAttr_HasBackgroundColour: { // wxGridCellAttr::HasBackgroundColour
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasBackgroundColour();
 rt.addBool(Result);
 break;
}
case wxGridCellAttr_HasFont: { // wxGridCellAttr::HasFont
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasFont();
 rt.addBool(Result);
 break;
}
case wxGridCellAttr_HasAlignment: { // wxGridCellAttr::HasAlignment
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasAlignment();
 rt.addBool(Result);
 break;
}
case wxGridCellAttr_HasRenderer: { // wxGridCellAttr::HasRenderer
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasRenderer();
 rt.addBool(Result);
 break;
}
case wxGridCellAttr_HasEditor: { // wxGridCellAttr::HasEditor
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasEditor();
 rt.addBool(Result);
 break;
}
case wxGridCellAttr_GetTextColour: { // wxGridCellAttr::GetTextColour
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetTextColour();
 rt.add((*Result));
 break;
}
case wxGridCellAttr_GetBackgroundColour: { // wxGridCellAttr::GetBackgroundColour
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetBackgroundColour();
 rt.add((*Result));
 break;
}
case wxGridCellAttr_GetFont: { // wxGridCellAttr::GetFont
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxFont * Result = &This->GetFont();
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxGridCellAttr_GetAlignment: { // wxGridCellAttr::GetAlignment
 int hAlign;
 int vAlign;
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetAlignment(&hAlign,&vAlign);
 rt.addInt(hAlign);
 rt.addInt(vAlign);
 rt.addTupleCount(2);
 break;
}
case wxGridCellAttr_GetRenderer: { // wxGridCellAttr::GetRenderer
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 wxGrid *grid = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellRenderer * Result = (wxGridCellRenderer*)This->GetRenderer(grid,*row,*col);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellRenderer");
 break;
}
case wxGridCellAttr_GetEditor: { // wxGridCellAttr::GetEditor
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 wxGrid *grid = (wxGrid *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGridCellEditor * Result = (wxGridCellEditor*)This->GetEditor(grid,*row,*col);
 rt.addRef(getRef((void *)Result,memenv), "wxGridCellEditor");
 break;
}
case wxGridCellAttr_IsReadOnly: { // wxGridCellAttr::IsReadOnly
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsReadOnly();
 rt.addBool(Result);
 break;
}
case wxGridCellAttr_SetDefAttr: { // wxGridCellAttr::SetDefAttr
 wxGridCellAttr *This = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 wxGridCellAttr *defAttr = (wxGridCellAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDefAttr(defAttr);
 break;
}
case wxDC_Blit: { // wxDC::Blit
 wxRasterOperationMode rop=wxCOPY;
 bool useMask=false;
 wxPoint srcPtMask= wxDefaultPosition;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * destPtX = (int *) bp; bp += 4;
 int * destPtY = (int *) bp; bp += 4;
 wxPoint destPt = wxPoint(*destPtX,*destPtY);
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 wxDC *source = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * srcPtX = (int *) bp; bp += 4;
 int * srcPtY = (int *) bp; bp += 4;
 wxPoint srcPt = wxPoint(*srcPtX,*srcPtY);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
rop = *(wxRasterOperationMode *) bp; bp += 4;;
  } break;
  case 2: {bp += 4;
 useMask = *(bool *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 int * srcPtMaskX = (int *) bp; bp += 4;
 int * srcPtMaskY = (int *) bp; bp += 4;
 srcPtMask = wxPoint(*srcPtMaskX,*srcPtMaskY);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Blit(destPt,sz,source,srcPt,rop,useMask,srcPtMask);
 rt.addBool(Result);
 break;
}
case wxDC_CalcBoundingBox: { // wxDC::CalcBoundingBox
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CalcBoundingBox(*x,*y);
 break;
}
case wxDC_Clear: { // wxDC::Clear
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Clear();
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxDC_ComputeScaleAndOrigin: { // wxDC::ComputeScaleAndOrigin
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ComputeScaleAndOrigin();
 break;
}
#endif
case wxDC_CrossHair: { // wxDC::CrossHair
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->CrossHair(pt);
 break;
}
case wxDC_DestroyClippingRegion: { // wxDC::DestroyClippingRegion
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DestroyClippingRegion();
 break;
}
case wxDC_DeviceToLogicalX: { // wxDC::DeviceToLogicalX
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->DeviceToLogicalX(*x);
 rt.addInt(Result);
 break;
}
case wxDC_DeviceToLogicalXRel: { // wxDC::DeviceToLogicalXRel
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->DeviceToLogicalXRel(*x);
 rt.addInt(Result);
 break;
}
case wxDC_DeviceToLogicalY: { // wxDC::DeviceToLogicalY
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->DeviceToLogicalY(*y);
 rt.addInt(Result);
 break;
}
case wxDC_DeviceToLogicalYRel: { // wxDC::DeviceToLogicalYRel
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->DeviceToLogicalYRel(*y);
 rt.addInt(Result);
 break;
}
case wxDC_DrawArc: { // wxDC::DrawArc
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * pt1X = (int *) bp; bp += 4;
 int * pt1Y = (int *) bp; bp += 4;
 wxPoint pt1 = wxPoint(*pt1X,*pt1Y);
 int * pt2X = (int *) bp; bp += 4;
 int * pt2Y = (int *) bp; bp += 4;
 wxPoint pt2 = wxPoint(*pt2X,*pt2Y);
 int * centreX = (int *) bp; bp += 4;
 int * centreY = (int *) bp; bp += 4;
 wxPoint centre = wxPoint(*centreX,*centreY);
 if(!This) throw wxe_badarg(0);
 This->DrawArc(pt1,pt2,centre);
 break;
}
case wxDC_DrawBitmap: { // wxDC::DrawBitmap
 bool useMask=false;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 useMask = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->DrawBitmap(*bmp,pt,useMask);
 break;
}
case wxDC_DrawCheckMark: { // wxDC::DrawCheckMark
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 This->DrawCheckMark(rect);
 break;
}
case wxDC_DrawCircle: { // wxDC::DrawCircle
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 int * radius = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DrawCircle(pt,*radius);
 break;
}
case wxDC_DrawEllipse_2: { // wxDC::DrawEllipse
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 if(!This) throw wxe_badarg(0);
 This->DrawEllipse(pt,sz);
 break;
}
case wxDC_DrawEllipse_1: { // wxDC::DrawEllipse
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 This->DrawEllipse(rect);
 break;
}
case wxDC_DrawEllipticArc: { // wxDC::DrawEllipticArc
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 bp += 4; /* Align */
 double * sa = (double *) bp; bp += 8;
 double * ea = (double *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawEllipticArc(pt,sz,*sa,*ea);
 break;
}
case wxDC_DrawIcon: { // wxDC::DrawIcon
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxIcon *icon = (wxIcon *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->DrawIcon(*icon,pt);
 break;
}
case wxDC_DrawLabel: { // wxDC::DrawLabel
 int alignment=wxALIGN_LEFT|wxALIGN_TOP;
 int indexAccel=-1;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 alignment = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 indexAccel = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->DrawLabel(text,rect,alignment,indexAccel);
 break;
}
case wxDC_DrawLine: { // wxDC::DrawLine
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * pt1X = (int *) bp; bp += 4;
 int * pt1Y = (int *) bp; bp += 4;
 wxPoint pt1 = wxPoint(*pt1X,*pt1Y);
 int * pt2X = (int *) bp; bp += 4;
 int * pt2Y = (int *) bp; bp += 4;
 wxPoint pt2 = wxPoint(*pt2X,*pt2Y);
 if(!This) throw wxe_badarg(0);
 This->DrawLine(pt1,pt2);
 break;
}
case wxDC_DrawLines: { // wxDC::DrawLines
 wxCoord xoffset=0;
 wxCoord yoffset=0;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * pointsLen = (int *) bp; bp += 4;
 wxPoint *points;
 points = (wxPoint *) driver_alloc(sizeof(wxPoint) * *pointsLen);
 for(int i=0; i < *pointsLen; i++) {
   int x = * (int *) bp; bp += 4;
   int y = * (int *) bp; bp += 4;
   points[i] = wxPoint(x,y);}
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 xoffset = (wxCoord)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 yoffset = (wxCoord)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->DrawLines(*pointsLen,points,xoffset,yoffset);
 driver_free(points);
 break;
}
case wxDC_DrawPolygon: { // wxDC::DrawPolygon
 wxCoord xoffset=0;
 wxCoord yoffset=0;
 wxPolygonFillMode fillStyle=wxODDEVEN_RULE;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * pointsLen = (int *) bp; bp += 4;
 wxPoint *points;
 points = (wxPoint *) driver_alloc(sizeof(wxPoint) * *pointsLen);
 for(int i=0; i < *pointsLen; i++) {
   int x = * (int *) bp; bp += 4;
   int y = * (int *) bp; bp += 4;
   points[i] = wxPoint(x,y);}
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 xoffset = (wxCoord)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 yoffset = (wxCoord)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
fillStyle = *(wxPolygonFillMode *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->DrawPolygon(*pointsLen,points,xoffset,yoffset,fillStyle);
 driver_free(points);
 break;
}
case wxDC_DrawPoint: { // wxDC::DrawPoint
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->DrawPoint(pt);
 break;
}
case wxDC_DrawRectangle_2: { // wxDC::DrawRectangle
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 if(!This) throw wxe_badarg(0);
 This->DrawRectangle(pt,sz);
 break;
}
case wxDC_DrawRectangle_1: { // wxDC::DrawRectangle
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 This->DrawRectangle(rect);
 break;
}
case wxDC_DrawRotatedText: { // wxDC::DrawRotatedText
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 double * angle = (double *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawRotatedText(text,pt,*angle);
 break;
}
case wxDC_DrawRoundedRectangle_3: { // wxDC::DrawRoundedRectangle
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 bp += 4; /* Align */
 double * radius = (double *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawRoundedRectangle(pt,sz,*radius);
 break;
}
case wxDC_DrawRoundedRectangle_2: { // wxDC::DrawRoundedRectangle
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rX = (int *) bp; bp += 4;
 int * rY = (int *) bp; bp += 4;
 int * rW = (int *) bp; bp += 4;
 int * rH = (int *) bp; bp += 4;
 wxRect r = wxRect(*rX,*rY,*rW,*rH);
 bp += 4; /* Align */
 double * radius = (double *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawRoundedRectangle(r,*radius);
 break;
}
case wxDC_DrawText: { // wxDC::DrawText
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->DrawText(text,pt);
 break;
}
case wxDC_EndDoc: { // wxDC::EndDoc
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EndDoc();
 break;
}
case wxDC_EndPage: { // wxDC::EndPage
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EndPage();
 break;
}
case wxDC_FloodFill: { // wxDC::FloodFill
 wxFloodFillStyle style=wxFLOOD_SURFACE;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
style = *(wxFloodFillStyle *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->FloodFill(pt,col,style);
 rt.addBool(Result);
 break;
}
case wxDC_GetBackground: { // wxDC::GetBackground
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxBrush * Result = &This->GetBackground();
 rt.addRef(getRef((void *)Result,memenv), "wxBrush");
 break;
}
case wxDC_GetBackgroundMode: { // wxDC::GetBackgroundMode
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetBackgroundMode();
 rt.addInt(Result);
 break;
}
case wxDC_GetBrush: { // wxDC::GetBrush
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxBrush * Result = &This->GetBrush();
 rt.addRef(getRef((void *)Result,memenv), "wxBrush");
 break;
}
case wxDC_GetCharHeight: { // wxDC::GetCharHeight
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->GetCharHeight();
 rt.addInt(Result);
 break;
}
case wxDC_GetCharWidth: { // wxDC::GetCharWidth
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->GetCharWidth();
 rt.addInt(Result);
 break;
}
case wxDC_GetClippingBox: { // wxDC::GetClippingBox
 wxCoord x;
 wxCoord y;
 wxCoord w;
 wxCoord h;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetClippingBox(&x,&y,&w,&h);
 rt.addInt(x);
 rt.addInt(y);
 rt.addInt(w);
 rt.addInt(h);
 rt.addTupleCount(4);
 break;
}
case wxDC_GetFont: { // wxDC::GetFont
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxFont * Result = &This->GetFont();
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxDC_GetLayoutDirection: { // wxDC::GetLayoutDirection
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLayoutDirection();
 rt.addInt(Result);
 break;
}
case wxDC_GetLogicalFunction: { // wxDC::GetLogicalFunction
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLogicalFunction();
 rt.addInt(Result);
 break;
}
case wxDC_GetMapMode: { // wxDC::GetMapMode
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMapMode();
 rt.addInt(Result);
 break;
}
case wxDC_GetMultiLineTextExtent_4: { // wxDC::GetMultiLineTextExtent
 wxCoord width;
 wxCoord height;
 wxCoord heightLine;
 wxFont * font=NULL;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * stringLen = (int *) bp; bp += 4;
 wxString string = wxString(bp, wxConvUTF8);
 bp += *stringLen+((8-((0+ *stringLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
font = (wxFont *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->GetMultiLineTextExtent(string,&width,&height,&heightLine,font);
 rt.addInt(width);
 rt.addInt(height);
 rt.addInt(heightLine);
 rt.addTupleCount(3);
 break;
}
case wxDC_GetMultiLineTextExtent_1: { // wxDC::GetMultiLineTextExtent
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * stringLen = (int *) bp; bp += 4;
 wxString string = wxString(bp, wxConvUTF8);
 bp += *stringLen+((8-((0+ *stringLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetMultiLineTextExtent(string);
 rt.add(Result);
 break;
}
case wxDC_GetPartialTextExtents: { // wxDC::GetPartialTextExtents
 wxArrayInt widths;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetPartialTextExtents(text,widths);
 rt.addBool(Result);
 rt.add(widths);
 rt.addTupleCount(2);
 break;
}
case wxDC_GetPen: { // wxDC::GetPen
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxPen * Result = &This->GetPen();
 rt.addRef(getRef((void *)Result,memenv), "wxPen");
 break;
}
case wxDC_GetPixel: { // wxDC::GetPixel
 wxColour col;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetPixel(pt,&col);
 rt.addBool(Result);
 rt.add(col);
 rt.addTupleCount(2);
 break;
}
case wxDC_GetPPI: { // wxDC::GetPPI
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetPPI();
 rt.add(Result);
 break;
}
case wxDC_GetSize: { // wxDC::GetSize
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetSize();
 rt.add(Result);
 break;
}
case wxDC_GetSizeMM: { // wxDC::GetSizeMM
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetSizeMM();
 rt.add(Result);
 break;
}
case wxDC_GetTextBackground: { // wxDC::GetTextBackground
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetTextBackground();
 rt.add((*Result));
 break;
}
case wxDC_GetTextExtent_4: { // wxDC::GetTextExtent
 wxCoord x;
 wxCoord y;
 wxCoord descent;
 wxCoord externalLeading;
 wxFont * theFont=NULL;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * stringLen = (int *) bp; bp += 4;
 wxString string = wxString(bp, wxConvUTF8);
 bp += *stringLen+((8-((0+ *stringLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
theFont = (wxFont *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->GetTextExtent(string,&x,&y,&descent,&externalLeading,theFont);
 rt.addInt(x);
 rt.addInt(y);
 rt.addInt(descent);
 rt.addInt(externalLeading);
 rt.addTupleCount(4);
 break;
}
case wxDC_GetTextExtent_1: { // wxDC::GetTextExtent
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * stringLen = (int *) bp; bp += 4;
 wxString string = wxString(bp, wxConvUTF8);
 bp += *stringLen+((8-((0+ *stringLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetTextExtent(string);
 rt.add(Result);
 break;
}
case wxDC_GetTextForeground: { // wxDC::GetTextForeground
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetTextForeground();
 rt.add((*Result));
 break;
}
case wxDC_GetUserScale: { // wxDC::GetUserScale
 double x;
 double y;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetUserScale(&x,&y);
 rt.ensureFloatCount(3);
 rt.addFloat(x);
 rt.addFloat(y);
 rt.addTupleCount(2);
 break;
}
case wxDC_GradientFillConcentric_3: { // wxDC::GradientFillConcentric
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 int * initialColourR = (int *) bp; bp += 4;
 int * initialColourG = (int *) bp; bp += 4;
 int * initialColourB = (int *) bp; bp += 4;
 int * initialColourA = (int *) bp; bp += 4;
 wxColour initialColour = wxColour(*initialColourR,*initialColourG,*initialColourB,*initialColourA);
 int * destColourR = (int *) bp; bp += 4;
 int * destColourG = (int *) bp; bp += 4;
 int * destColourB = (int *) bp; bp += 4;
 int * destColourA = (int *) bp; bp += 4;
 wxColour destColour = wxColour(*destColourR,*destColourG,*destColourB,*destColourA);
 if(!This) throw wxe_badarg(0);
 This->GradientFillConcentric(rect,initialColour,destColour);
 break;
}
case wxDC_GradientFillConcentric_4: { // wxDC::GradientFillConcentric
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 int * initialColourR = (int *) bp; bp += 4;
 int * initialColourG = (int *) bp; bp += 4;
 int * initialColourB = (int *) bp; bp += 4;
 int * initialColourA = (int *) bp; bp += 4;
 wxColour initialColour = wxColour(*initialColourR,*initialColourG,*initialColourB,*initialColourA);
 int * destColourR = (int *) bp; bp += 4;
 int * destColourG = (int *) bp; bp += 4;
 int * destColourB = (int *) bp; bp += 4;
 int * destColourA = (int *) bp; bp += 4;
 wxColour destColour = wxColour(*destColourR,*destColourG,*destColourB,*destColourA);
 int * circleCenterX = (int *) bp; bp += 4;
 int * circleCenterY = (int *) bp; bp += 4;
 wxPoint circleCenter = wxPoint(*circleCenterX,*circleCenterY);
 if(!This) throw wxe_badarg(0);
 This->GradientFillConcentric(rect,initialColour,destColour,circleCenter);
 break;
}
case wxDC_GradientFillLinear: { // wxDC::GradientFillLinear
 wxDirection nDirection=wxEAST;
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 int * initialColourR = (int *) bp; bp += 4;
 int * initialColourG = (int *) bp; bp += 4;
 int * initialColourB = (int *) bp; bp += 4;
 int * initialColourA = (int *) bp; bp += 4;
 wxColour initialColour = wxColour(*initialColourR,*initialColourG,*initialColourB,*initialColourA);
 int * destColourR = (int *) bp; bp += 4;
 int * destColourG = (int *) bp; bp += 4;
 int * destColourB = (int *) bp; bp += 4;
 int * destColourA = (int *) bp; bp += 4;
 wxColour destColour = wxColour(*destColourR,*destColourG,*destColourB,*destColourA);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
nDirection = *(wxDirection *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->GradientFillLinear(rect,initialColour,destColour,nDirection);
 break;
}
case wxDC_LogicalToDeviceX: { // wxDC::LogicalToDeviceX
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->LogicalToDeviceX(*x);
 rt.addInt(Result);
 break;
}
case wxDC_LogicalToDeviceXRel: { // wxDC::LogicalToDeviceXRel
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->LogicalToDeviceXRel(*x);
 rt.addInt(Result);
 break;
}
case wxDC_LogicalToDeviceY: { // wxDC::LogicalToDeviceY
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->LogicalToDeviceY(*y);
 rt.addInt(Result);
 break;
}
case wxDC_LogicalToDeviceYRel: { // wxDC::LogicalToDeviceYRel
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->LogicalToDeviceYRel(*y);
 rt.addInt(Result);
 break;
}
case wxDC_MaxX: { // wxDC::MaxX
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->MaxX();
 rt.addInt(Result);
 break;
}
case wxDC_MaxY: { // wxDC::MaxY
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->MaxY();
 rt.addInt(Result);
 break;
}
case wxDC_MinX: { // wxDC::MinX
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->MinX();
 rt.addInt(Result);
 break;
}
case wxDC_MinY: { // wxDC::MinY
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->MinY();
 rt.addInt(Result);
 break;
}
case wxDC_IsOk: { // wxDC::IsOk
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxDC_ResetBoundingBox: { // wxDC::ResetBoundingBox
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ResetBoundingBox();
 break;
}
case wxDC_SetAxisOrientation: { // wxDC::SetAxisOrientation
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 bool * xLeftRight = (bool *) bp; bp += 4;
 bool * yBottomUp = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAxisOrientation(*xLeftRight,*yBottomUp);
 break;
}
case wxDC_SetBackground: { // wxDC::SetBackground
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxBrush *brush = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBackground(*brush);
 break;
}
case wxDC_SetBackgroundMode: { // wxDC::SetBackgroundMode
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * mode = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBackgroundMode(*mode);
 break;
}
case wxDC_SetBrush: { // wxDC::SetBrush
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxBrush *brush = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBrush(*brush);
 break;
}
case wxDC_SetClippingRegion_2: { // wxDC::SetClippingRegion
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 if(!This) throw wxe_badarg(0);
 This->SetClippingRegion(pt,sz);
 break;
}
case wxDC_SetClippingRegion_1_1: { // wxDC::SetClippingRegion
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 This->SetClippingRegion(rect);
 break;
}
case wxDC_SetClippingRegion_1_0: { // wxDC::SetClippingRegion
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxRegion *region = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetClippingRegion(*region);
 break;
}
case wxDC_SetDeviceOrigin: { // wxDC::SetDeviceOrigin
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDeviceOrigin(*x,*y);
 break;
}
case wxDC_SetFont: { // wxDC::SetFont
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFont(*font);
 break;
}
case wxDC_SetLayoutDirection: { // wxDC::SetLayoutDirection
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxLayoutDirection dir = *(wxLayoutDirection *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetLayoutDirection(dir);
 break;
}
case wxDC_SetLogicalFunction: { // wxDC::SetLogicalFunction
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxRasterOperationMode function = *(wxRasterOperationMode *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetLogicalFunction(function);
 break;
}
case wxDC_SetMapMode: { // wxDC::SetMapMode
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxMappingMode mode = *(wxMappingMode *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetMapMode(mode);
 break;
}
case wxDC_SetPalette: { // wxDC::SetPalette
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxPalette *palette = (wxPalette *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPalette(*palette);
 break;
}
case wxDC_SetPen: { // wxDC::SetPen
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxPen *pen = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPen(*pen);
 break;
}
case wxDC_SetTextBackground: { // wxDC::SetTextBackground
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetTextBackground(colour);
 break;
}
case wxDC_SetTextForeground: { // wxDC::SetTextForeground
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetTextForeground(colour);
 break;
}
case wxDC_SetUserScale: { // wxDC::SetUserScale
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 double * x = (double *) bp; bp += 8;
 double * y = (double *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->SetUserScale(*x,*y);
 break;
}
case wxDC_StartDoc: { // wxDC::StartDoc
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->StartDoc(message);
 rt.addBool(Result);
 break;
}
case wxDC_StartPage: { // wxDC::StartPage
 wxDC *This = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StartPage();
 break;
}
case wxMirrorDC_new: { // wxMirrorDC::wxMirrorDC
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 bool * mirror = (bool *) bp; bp += 4;
 wxMirrorDC * Result = new EwxMirrorDC(*dc,*mirror);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMirrorDC");
 break;
}
case wxScreenDC_new: { // wxScreenDC::wxScreenDC
 wxScreenDC * Result = new EwxScreenDC();
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxScreenDC");
 break;
}
#if wxUSE_POSTSCRIPT
case wxPostScriptDC_new_0: { // wxPostScriptDC::wxPostScriptDC
 wxPostScriptDC * Result = new EwxPostScriptDC();
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPostScriptDC");
 break;
}
case wxPostScriptDC_new_1: { // wxPostScriptDC::wxPostScriptDC
 wxPrintData *printData = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxPostScriptDC * Result = new EwxPostScriptDC(*printData);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPostScriptDC");
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxPostScriptDC_SetResolution: { // wxPostScriptDC::SetResolution
 int * ppi = (int *) bp; bp += 4;
 wxPostScriptDC::SetResolution(*ppi);
 break;
}
#endif
#if !wxCHECK_VERSION(2,9,0)
case wxPostScriptDC_GetResolution: { // wxPostScriptDC::GetResolution
 int Result = wxPostScriptDC::GetResolution();
 rt.addInt(Result);
 break;
}
#endif
#endif // wxUSE_POSTSCRIPT
#if !wxCHECK_VERSION(2,9,0)
case wxWindowDC_new_0: { // wxWindowDC::wxWindowDC
 wxWindowDC * Result = new EwxWindowDC();
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxWindowDC");
 break;
}
#endif
case wxWindowDC_new_1: { // wxWindowDC::wxWindowDC
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxWindowDC * Result = new EwxWindowDC(win);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxWindowDC");
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxClientDC_new_0: { // wxClientDC::wxClientDC
 wxClientDC * Result = new EwxClientDC();
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxClientDC");
 break;
}
#endif
case wxClientDC_new_1: { // wxClientDC::wxClientDC
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxClientDC * Result = new EwxClientDC(win);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxClientDC");
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxPaintDC_new_0: { // wxPaintDC::wxPaintDC
 wxPaintDC * Result = new EwxPaintDC();
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPaintDC");
 break;
}
#endif
case wxPaintDC_new_1: { // wxPaintDC::wxPaintDC
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxPaintDC * Result = new EwxPaintDC(win);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPaintDC");
 break;
}
case wxMemoryDC_new_1_0: { // wxMemoryDC::wxMemoryDC
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxMemoryDC * Result = new EwxMemoryDC(*bitmap);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMemoryDC");
 break;
}
case wxMemoryDC_new_1_1: { // wxMemoryDC::wxMemoryDC
 wxDC * dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxMemoryDC * Result = new EwxMemoryDC(dc);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMemoryDC");
 break;
}
case wxMemoryDC_new_0: { // wxMemoryDC::wxMemoryDC
 wxMemoryDC * Result = new EwxMemoryDC();
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMemoryDC");
 break;
}
case wxMemoryDC_SelectObject: { // wxMemoryDC::SelectObject
 wxMemoryDC *This = (wxMemoryDC *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SelectObject(*bmp);
 break;
}
case wxMemoryDC_SelectObjectAsSource: { // wxMemoryDC::SelectObjectAsSource
 wxMemoryDC *This = (wxMemoryDC *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SelectObjectAsSource(*bmp);
 break;
}
case wxBufferedDC_new_0: { // wxBufferedDC::wxBufferedDC
 wxBufferedDC * Result = new EwxBufferedDC();
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBufferedDC");
 break;
}
case wxBufferedDC_new_2: { // wxBufferedDC::wxBufferedDC
 wxBitmap * buffer= &wxNullBitmap;
 int style=wxBUFFER_CLIENT_AREA;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
buffer = (wxBitmap *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxBufferedDC * Result = new EwxBufferedDC(dc,*buffer,style);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBufferedDC");
 break;
}
case wxBufferedDC_new_3: { // wxBufferedDC::wxBufferedDC
 int style=wxBUFFER_CLIENT_AREA;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * areaW = (int *) bp; bp += 4;
 int * areaH = (int *) bp; bp += 4;
 wxSize area = wxSize(*areaW,*areaH);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxBufferedDC * Result = new EwxBufferedDC(dc,area,style);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBufferedDC");
 break;
}
case wxBufferedDC_Init_2: { // wxBufferedDC::Init
 wxBitmap * buffer= &wxNullBitmap;
 int style=wxBUFFER_CLIENT_AREA;
 wxBufferedDC *This = (wxBufferedDC *) getPtr(bp,memenv); bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
buffer = (wxBitmap *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Init(dc,*buffer,style);
 break;
}
case wxBufferedDC_Init_3: { // wxBufferedDC::Init
 int style=wxBUFFER_CLIENT_AREA;
 wxBufferedDC *This = (wxBufferedDC *) getPtr(bp,memenv); bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * areaW = (int *) bp; bp += 4;
 int * areaH = (int *) bp; bp += 4;
 wxSize area = wxSize(*areaW,*areaH);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Init(dc,area,style);
 break;
}
case wxBufferedPaintDC_new_3: { // wxBufferedPaintDC::wxBufferedPaintDC
 int style=wxBUFFER_CLIENT_AREA;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxBitmap *buffer = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxBufferedPaintDC * Result = new EwxBufferedPaintDC(window,*buffer,style);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBufferedPaintDC");
 break;
}
case wxBufferedPaintDC_new_2: { // wxBufferedPaintDC::wxBufferedPaintDC
 int style=wxBUFFER_CLIENT_AREA;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxBufferedPaintDC * Result = new EwxBufferedPaintDC(window,style);
 newPtr((void *) Result, 4, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBufferedPaintDC");
 break;
}
#if wxUSE_GRAPHICS_CONTEXT
case wxGraphicsObject_GetRenderer: { // wxGraphicsObject::GetRenderer
 wxGraphicsObject *This = (wxGraphicsObject *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsRenderer * Result = (wxGraphicsRenderer*)This->GetRenderer();
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsRenderer");
 break;
}
case wxGraphicsObject_IsNull: { // wxGraphicsObject::IsNull
 wxGraphicsObject *This = (wxGraphicsObject *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsNull();
 rt.addBool(Result);
 break;
}
#endif // wxUSE_GRAPHICS_CONTEXT
#if wxUSE_GRAPHICS_CONTEXT
case wxGraphicsContext_Create_1_1: { // wxGraphicsContext::Create
 wxWindowDC * dc = (wxWindowDC *) getPtr(bp,memenv); bp += 4;
 wxGraphicsContext * Result = (wxGraphicsContext*)wxGraphicsContext::Create(*dc);
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsContext");
 break;
}
case wxGraphicsContext_Create_1_0: { // wxGraphicsContext::Create
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxGraphicsContext * Result = (wxGraphicsContext*)wxGraphicsContext::Create(window);
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsContext");
 break;
}
case wxGraphicsContext_Create_0: { // wxGraphicsContext::Create
 wxGraphicsContext * Result = (wxGraphicsContext*)wxGraphicsContext::Create();
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsContext");
 break;
}
case wxGraphicsContext_CreatePen: { // wxGraphicsContext::CreatePen
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxPen *pen = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsPen * Result = new wxGraphicsPen(This->CreatePen(*pen)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsPen");
 break;
}
case wxGraphicsContext_CreateBrush: { // wxGraphicsContext::CreateBrush
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxBrush *brush = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsBrush * Result = new wxGraphicsBrush(This->CreateBrush(*brush)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsBrush");
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxGraphicsContext_CreateRadialGradientBrush: { // wxGraphicsContext::CreateRadialGradientBrush
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * xo = (wxDouble *) bp; bp += 8;
 wxDouble * yo = (wxDouble *) bp; bp += 8;
 wxDouble * xc = (wxDouble *) bp; bp += 8;
 wxDouble * yc = (wxDouble *) bp; bp += 8;
 wxDouble * radius = (wxDouble *) bp; bp += 8;
 int * oColorR = (int *) bp; bp += 4;
 int * oColorG = (int *) bp; bp += 4;
 int * oColorB = (int *) bp; bp += 4;
 int * oColorA = (int *) bp; bp += 4;
 wxColour oColor = wxColour(*oColorR,*oColorG,*oColorB,*oColorA);
 int * cColorR = (int *) bp; bp += 4;
 int * cColorG = (int *) bp; bp += 4;
 int * cColorB = (int *) bp; bp += 4;
 int * cColorA = (int *) bp; bp += 4;
 wxColour cColor = wxColour(*cColorR,*cColorG,*cColorB,*cColorA);
 if(!This) throw wxe_badarg(0);
 wxGraphicsBrush * Result = new wxGraphicsBrush(This->CreateRadialGradientBrush(*xo,*yo,*xc,*yc,*radius,oColor,cColor)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsBrush");
 break;
}
#endif
#if !wxCHECK_VERSION(2,9,0)
case wxGraphicsContext_CreateLinearGradientBrush: { // wxGraphicsContext::CreateLinearGradientBrush
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x1 = (wxDouble *) bp; bp += 8;
 wxDouble * y1 = (wxDouble *) bp; bp += 8;
 wxDouble * x2 = (wxDouble *) bp; bp += 8;
 wxDouble * y2 = (wxDouble *) bp; bp += 8;
 int * c1R = (int *) bp; bp += 4;
 int * c1G = (int *) bp; bp += 4;
 int * c1B = (int *) bp; bp += 4;
 int * c1A = (int *) bp; bp += 4;
 wxColour c1 = wxColour(*c1R,*c1G,*c1B,*c1A);
 int * c2R = (int *) bp; bp += 4;
 int * c2G = (int *) bp; bp += 4;
 int * c2B = (int *) bp; bp += 4;
 int * c2A = (int *) bp; bp += 4;
 wxColour c2 = wxColour(*c2R,*c2G,*c2B,*c2A);
 if(!This) throw wxe_badarg(0);
 wxGraphicsBrush * Result = new wxGraphicsBrush(This->CreateLinearGradientBrush(*x1,*y1,*x2,*y2,c1,c2)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsBrush");
 break;
}
#endif
case wxGraphicsContext_CreateFont: { // wxGraphicsContext::CreateFont
 wxColour col= *wxBLACK;
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 col = wxColour(*colR,*colG,*colB,*colA);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxGraphicsFont * Result = new wxGraphicsFont(This->CreateFont(*font,col)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsFont");
 break;
}
case wxGraphicsContext_CreateMatrix: { // wxGraphicsContext::CreateMatrix
 wxDouble a=1.0;
 wxDouble b=0.0;
 wxDouble c=0.0;
 wxDouble d=1.0;
 wxDouble tx=0.0;
 wxDouble ty=0.0;
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bp += 4; /* Align */
 a = * (wxDouble *) bp; bp += 8;
  } break;
  case 2: {bp += 4;
 bp += 4; /* Align */
 b = * (wxDouble *) bp; bp += 8;
  } break;
  case 3: {bp += 4;
 bp += 4; /* Align */
 c = * (wxDouble *) bp; bp += 8;
  } break;
  case 4: {bp += 4;
 bp += 4; /* Align */
 d = * (wxDouble *) bp; bp += 8;
  } break;
  case 5: {bp += 4;
 bp += 4; /* Align */
 tx = * (wxDouble *) bp; bp += 8;
  } break;
  case 6: {bp += 4;
 bp += 4; /* Align */
 ty = * (wxDouble *) bp; bp += 8;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxGraphicsMatrix * Result = new wxGraphicsMatrix(This->CreateMatrix(a,b,c,d,tx,ty)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsMatrix");
 break;
}
case wxGraphicsContext_CreatePath: { // wxGraphicsContext::CreatePath
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsPath * Result = new wxGraphicsPath(This->CreatePath()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsPath");
 break;
}
case wxGraphicsContext_Clip_1: { // wxGraphicsContext::Clip
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxRegion *region = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Clip(*region);
 break;
}
case wxGraphicsContext_Clip_4: { // wxGraphicsContext::Clip
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Clip(*x,*y,*w,*h);
 break;
}
case wxGraphicsContext_ResetClip: { // wxGraphicsContext::ResetClip
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ResetClip();
 break;
}
case wxGraphicsContext_DrawBitmap: { // wxGraphicsContext::DrawBitmap
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawBitmap(*bmp,*x,*y,*w,*h);
 break;
}
case wxGraphicsContext_DrawEllipse: { // wxGraphicsContext::DrawEllipse
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawEllipse(*x,*y,*w,*h);
 break;
}
case wxGraphicsContext_DrawIcon: { // wxGraphicsContext::DrawIcon
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxIcon *icon = (wxIcon *) getPtr(bp,memenv); bp += 4;
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawIcon(*icon,*x,*y,*w,*h);
 break;
}
case wxGraphicsContext_DrawLines: { // wxGraphicsContext::DrawLines
 wxPolygonFillMode fillStyle=wxODDEVEN_RULE;
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 int * pointsLen = (int *) bp; bp += 4;
 wxPoint2DDouble *points;
 points = (wxPoint2DDouble *) driver_alloc(sizeof(wxPoint2DDouble) * *pointsLen);
 for(int i=0; i < *pointsLen; i++) {
   double x = * (double *) bp; bp += 8;
   double y = * (double *) bp; bp += 8;
   points[i] = wxPoint2DDouble(x,y);}
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
fillStyle = *(wxPolygonFillMode *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->DrawLines(*pointsLen,points,fillStyle);
 driver_free(points);
 break;
}
case wxGraphicsContext_DrawPath: { // wxGraphicsContext::DrawPath
 wxPolygonFillMode fillStyle=wxODDEVEN_RULE;
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxGraphicsPath *path = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
fillStyle = *(wxPolygonFillMode *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->DrawPath(*path,fillStyle);
 break;
}
case wxGraphicsContext_DrawRectangle: { // wxGraphicsContext::DrawRectangle
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawRectangle(*x,*y,*w,*h);
 break;
}
case wxGraphicsContext_DrawRoundedRectangle: { // wxGraphicsContext::DrawRoundedRectangle
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 wxDouble * radius = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawRoundedRectangle(*x,*y,*w,*h,*radius);
 break;
}
case wxGraphicsContext_DrawText_3: { // wxGraphicsContext::DrawText
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawText(str,*x,*y);
 break;
}
case wxGraphicsContext_DrawText_4_0: { // wxGraphicsContext::DrawText
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * angle = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DrawText(str,*x,*y,*angle);
 break;
}
case wxGraphicsContext_DrawText_4_1: { // wxGraphicsContext::DrawText
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxGraphicsBrush *backgroundBrush = (wxGraphicsBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DrawText(str,*x,*y,*backgroundBrush);
 break;
}
case wxGraphicsContext_DrawText_5: { // wxGraphicsContext::DrawText
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * angle = (wxDouble *) bp; bp += 8;
 wxGraphicsBrush *backgroundBrush = (wxGraphicsBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DrawText(str,*x,*y,*angle,*backgroundBrush);
 break;
}
case wxGraphicsContext_FillPath: { // wxGraphicsContext::FillPath
 wxPolygonFillMode fillStyle=wxODDEVEN_RULE;
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxGraphicsPath *path = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
fillStyle = *(wxPolygonFillMode *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->FillPath(*path,fillStyle);
 break;
}
case wxGraphicsContext_StrokePath: { // wxGraphicsContext::StrokePath
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxGraphicsPath *path = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StrokePath(*path);
 break;
}
case wxGraphicsContext_GetPartialTextExtents: { // wxGraphicsContext::GetPartialTextExtents
 wxArrayDouble widths;
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->GetPartialTextExtents(text,widths);
 rt.add(widths);
 break;
}
case wxGraphicsContext_GetTextExtent: { // wxGraphicsContext::GetTextExtent
 wxDouble width;
 wxDouble height;
 wxDouble descent;
 wxDouble externalLeading;
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->GetTextExtent(text,&width,&height,&descent,&externalLeading);
 rt.ensureFloatCount(5);
 rt.addFloat(width);
 rt.addFloat(height);
 rt.addFloat(descent);
 rt.addFloat(externalLeading);
 rt.addTupleCount(4);
 break;
}
case wxGraphicsContext_Rotate: { // wxGraphicsContext::Rotate
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * angle = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Rotate(*angle);
 break;
}
case wxGraphicsContext_Scale: { // wxGraphicsContext::Scale
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * xScale = (wxDouble *) bp; bp += 8;
 wxDouble * yScale = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Scale(*xScale,*yScale);
 break;
}
case wxGraphicsContext_Translate: { // wxGraphicsContext::Translate
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * dx = (wxDouble *) bp; bp += 8;
 wxDouble * dy = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Translate(*dx,*dy);
 break;
}
case wxGraphicsContext_GetTransform: { // wxGraphicsContext::GetTransform
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsMatrix * Result = new wxGraphicsMatrix(This->GetTransform()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsMatrix");
 break;
}
case wxGraphicsContext_SetTransform: { // wxGraphicsContext::SetTransform
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxGraphicsMatrix *matrix = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTransform(*matrix);
 break;
}
case wxGraphicsContext_ConcatTransform: { // wxGraphicsContext::ConcatTransform
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxGraphicsMatrix *matrix = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ConcatTransform(*matrix);
 break;
}
case wxGraphicsContext_SetBrush_1_1: { // wxGraphicsContext::SetBrush
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxGraphicsBrush * brush = (wxGraphicsBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBrush(*brush);
 break;
}
case wxGraphicsContext_SetBrush_1_0: { // wxGraphicsContext::SetBrush
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxBrush *brush = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBrush(*brush);
 break;
}
case wxGraphicsContext_SetFont_1: { // wxGraphicsContext::SetFont
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxGraphicsFont *font = (wxGraphicsFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFont(*font);
 break;
}
case wxGraphicsContext_SetFont_2: { // wxGraphicsContext::SetFont
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetFont(*font,colour);
 break;
}
case wxGraphicsContext_SetPen_1_0: { // wxGraphicsContext::SetPen
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxGraphicsPen *pen = (wxGraphicsPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPen(*pen);
 break;
}
case wxGraphicsContext_SetPen_1_1: { // wxGraphicsContext::SetPen
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 wxPen * pen = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPen(*pen);
 break;
}
case wxGraphicsContext_StrokeLine: { // wxGraphicsContext::StrokeLine
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x1 = (wxDouble *) bp; bp += 8;
 wxDouble * y1 = (wxDouble *) bp; bp += 8;
 wxDouble * x2 = (wxDouble *) bp; bp += 8;
 wxDouble * y2 = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->StrokeLine(*x1,*y1,*x2,*y2);
 break;
}
case wxGraphicsContext_StrokeLines: { // wxGraphicsContext::StrokeLines
 wxGraphicsContext *This = (wxGraphicsContext *) getPtr(bp,memenv); bp += 4;
 int * pointsLen = (int *) bp; bp += 4;
 wxPoint2DDouble *points;
 points = (wxPoint2DDouble *) driver_alloc(sizeof(wxPoint2DDouble) * *pointsLen);
 for(int i=0; i < *pointsLen; i++) {
   double x = * (double *) bp; bp += 8;
   double y = * (double *) bp; bp += 8;
   points[i] = wxPoint2DDouble(x,y);}
 if(!This) throw wxe_badarg(0);
 This->StrokeLines(*pointsLen,points);
 driver_free(points);
 break;
}
#endif // wxUSE_GRAPHICS_CONTEXT
#if wxUSE_GRAPHICS_CONTEXT
case wxGraphicsMatrix_Concat: { // wxGraphicsMatrix::Concat
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 wxGraphicsMatrix *t = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Concat(t);
 break;
}
case wxGraphicsMatrix_Get: { // wxGraphicsMatrix::Get
 wxDouble a;
 wxDouble b;
 wxDouble c;
 wxDouble d;
 wxDouble tx;
 wxDouble ty;
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Get(&a,&b,&c,&d,&tx,&ty);
 rt.ensureFloatCount(7);
 rt.addFloat(a);
 rt.addFloat(b);
 rt.addFloat(c);
 rt.addFloat(d);
 rt.addFloat(tx);
 rt.addFloat(ty);
 rt.addTupleCount(6);
 break;
}
case wxGraphicsMatrix_Invert: { // wxGraphicsMatrix::Invert
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Invert();
 break;
}
case wxGraphicsMatrix_IsEqual: { // wxGraphicsMatrix::IsEqual
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 wxGraphicsMatrix *t = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEqual(t);
 rt.addBool(Result);
 break;
}
case wxGraphicsMatrix_IsIdentity: { // wxGraphicsMatrix::IsIdentity
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsIdentity();
 rt.addBool(Result);
 break;
}
case wxGraphicsMatrix_Rotate: { // wxGraphicsMatrix::Rotate
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * angle = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Rotate(*angle);
 break;
}
case wxGraphicsMatrix_Scale: { // wxGraphicsMatrix::Scale
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * xScale = (wxDouble *) bp; bp += 8;
 wxDouble * yScale = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Scale(*xScale,*yScale);
 break;
}
case wxGraphicsMatrix_Translate: { // wxGraphicsMatrix::Translate
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * dx = (wxDouble *) bp; bp += 8;
 wxDouble * dy = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Translate(*dx,*dy);
 break;
}
case wxGraphicsMatrix_Set: { // wxGraphicsMatrix::Set
 wxDouble a=1.0;
 wxDouble b=0.0;
 wxDouble c=0.0;
 wxDouble d=1.0;
 wxDouble tx=0.0;
 wxDouble ty=0.0;
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bp += 4; /* Align */
 a = * (wxDouble *) bp; bp += 8;
  } break;
  case 2: {bp += 4;
 bp += 4; /* Align */
 b = * (wxDouble *) bp; bp += 8;
  } break;
  case 3: {bp += 4;
 bp += 4; /* Align */
 c = * (wxDouble *) bp; bp += 8;
  } break;
  case 4: {bp += 4;
 bp += 4; /* Align */
 d = * (wxDouble *) bp; bp += 8;
  } break;
  case 5: {bp += 4;
 bp += 4; /* Align */
 tx = * (wxDouble *) bp; bp += 8;
  } break;
  case 6: {bp += 4;
 bp += 4; /* Align */
 ty = * (wxDouble *) bp; bp += 8;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Set(a,b,c,d,tx,ty);
 break;
}
case wxGraphicsMatrix_TransformPoint: { // wxGraphicsMatrix::TransformPoint
 wxDouble x;
 wxDouble y;
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->TransformPoint(&x,&y);
 rt.ensureFloatCount(3);
 rt.addFloat(x);
 rt.addFloat(y);
 rt.addTupleCount(2);
 break;
}
case wxGraphicsMatrix_TransformDistance: { // wxGraphicsMatrix::TransformDistance
 wxDouble dx;
 wxDouble dy;
 wxGraphicsMatrix *This = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->TransformDistance(&dx,&dy);
 rt.ensureFloatCount(3);
 rt.addFloat(dx);
 rt.addFloat(dy);
 rt.addTupleCount(2);
 break;
}
#endif // wxUSE_GRAPHICS_CONTEXT
#if wxUSE_GRAPHICS_CONTEXT
case wxGraphicsPath_MoveToPoint_2: { // wxGraphicsPath::MoveToPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->MoveToPoint(*x,*y);
 break;
}
case wxGraphicsPath_MoveToPoint_1: { // wxGraphicsPath::MoveToPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * pX = (wxDouble *) bp; bp += 8;
 wxDouble * pY = (wxDouble *) bp; bp += 8;
 wxPoint2DDouble p = wxPoint2DDouble(*pX,*pY);
 if(!This) throw wxe_badarg(0);
 This->MoveToPoint(p);
 break;
}
case wxGraphicsPath_AddArc_6: { // wxGraphicsPath::AddArc
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * r = (wxDouble *) bp; bp += 8;
 wxDouble * startAngle = (wxDouble *) bp; bp += 8;
 wxDouble * endAngle = (wxDouble *) bp; bp += 8;
 bool * clockwise = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AddArc(*x,*y,*r,*startAngle,*endAngle,*clockwise);
 break;
}
case wxGraphicsPath_AddArc_5: { // wxGraphicsPath::AddArc
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * cX = (wxDouble *) bp; bp += 8;
 wxDouble * cY = (wxDouble *) bp; bp += 8;
 wxPoint2DDouble c = wxPoint2DDouble(*cX,*cY);
 wxDouble * r = (wxDouble *) bp; bp += 8;
 wxDouble * startAngle = (wxDouble *) bp; bp += 8;
 wxDouble * endAngle = (wxDouble *) bp; bp += 8;
 bool * clockwise = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AddArc(c,*r,*startAngle,*endAngle,*clockwise);
 break;
}
case wxGraphicsPath_AddArcToPoint: { // wxGraphicsPath::AddArcToPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x1 = (wxDouble *) bp; bp += 8;
 wxDouble * y1 = (wxDouble *) bp; bp += 8;
 wxDouble * x2 = (wxDouble *) bp; bp += 8;
 wxDouble * y2 = (wxDouble *) bp; bp += 8;
 wxDouble * r = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->AddArcToPoint(*x1,*y1,*x2,*y2,*r);
 break;
}
case wxGraphicsPath_AddCircle: { // wxGraphicsPath::AddCircle
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * r = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->AddCircle(*x,*y,*r);
 break;
}
case wxGraphicsPath_AddCurveToPoint_6: { // wxGraphicsPath::AddCurveToPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * cx1 = (wxDouble *) bp; bp += 8;
 wxDouble * cy1 = (wxDouble *) bp; bp += 8;
 wxDouble * cx2 = (wxDouble *) bp; bp += 8;
 wxDouble * cy2 = (wxDouble *) bp; bp += 8;
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->AddCurveToPoint(*cx1,*cy1,*cx2,*cy2,*x,*y);
 break;
}
case wxGraphicsPath_AddCurveToPoint_3: { // wxGraphicsPath::AddCurveToPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * c1X = (wxDouble *) bp; bp += 8;
 wxDouble * c1Y = (wxDouble *) bp; bp += 8;
 wxPoint2DDouble c1 = wxPoint2DDouble(*c1X,*c1Y);
 wxDouble * c2X = (wxDouble *) bp; bp += 8;
 wxDouble * c2Y = (wxDouble *) bp; bp += 8;
 wxPoint2DDouble c2 = wxPoint2DDouble(*c2X,*c2Y);
 wxDouble * eX = (wxDouble *) bp; bp += 8;
 wxDouble * eY = (wxDouble *) bp; bp += 8;
 wxPoint2DDouble e = wxPoint2DDouble(*eX,*eY);
 if(!This) throw wxe_badarg(0);
 This->AddCurveToPoint(c1,c2,e);
 break;
}
case wxGraphicsPath_AddEllipse: { // wxGraphicsPath::AddEllipse
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->AddEllipse(*x,*y,*w,*h);
 break;
}
case wxGraphicsPath_AddLineToPoint_2: { // wxGraphicsPath::AddLineToPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->AddLineToPoint(*x,*y);
 break;
}
case wxGraphicsPath_AddLineToPoint_1: { // wxGraphicsPath::AddLineToPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * pX = (wxDouble *) bp; bp += 8;
 wxDouble * pY = (wxDouble *) bp; bp += 8;
 wxPoint2DDouble p = wxPoint2DDouble(*pX,*pY);
 if(!This) throw wxe_badarg(0);
 This->AddLineToPoint(p);
 break;
}
case wxGraphicsPath_AddPath: { // wxGraphicsPath::AddPath
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 wxGraphicsPath *path = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AddPath(*path);
 break;
}
case wxGraphicsPath_AddQuadCurveToPoint: { // wxGraphicsPath::AddQuadCurveToPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * cx = (wxDouble *) bp; bp += 8;
 wxDouble * cy = (wxDouble *) bp; bp += 8;
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->AddQuadCurveToPoint(*cx,*cy,*x,*y);
 break;
}
case wxGraphicsPath_AddRectangle: { // wxGraphicsPath::AddRectangle
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->AddRectangle(*x,*y,*w,*h);
 break;
}
case wxGraphicsPath_AddRoundedRectangle: { // wxGraphicsPath::AddRoundedRectangle
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 wxDouble * w = (wxDouble *) bp; bp += 8;
 wxDouble * h = (wxDouble *) bp; bp += 8;
 wxDouble * radius = (wxDouble *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->AddRoundedRectangle(*x,*y,*w,*h,*radius);
 break;
}
case wxGraphicsPath_CloseSubpath: { // wxGraphicsPath::CloseSubpath
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CloseSubpath();
 break;
}
case wxGraphicsPath_Contains_3: { // wxGraphicsPath::Contains
 wxPolygonFillMode fillStyle=wxODDEVEN_RULE;
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x = (wxDouble *) bp; bp += 8;
 wxDouble * y = (wxDouble *) bp; bp += 8;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
fillStyle = *(wxPolygonFillMode *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Contains(*x,*y,fillStyle);
 rt.addBool(Result);
 break;
}
case wxGraphicsPath_Contains_2: { // wxGraphicsPath::Contains
 wxPolygonFillMode fillStyle=wxODDEVEN_RULE;
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * cX = (wxDouble *) bp; bp += 8;
 wxDouble * cY = (wxDouble *) bp; bp += 8;
 wxPoint2DDouble c = wxPoint2DDouble(*cX,*cY);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
fillStyle = *(wxPolygonFillMode *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Contains(c,fillStyle);
 rt.addBool(Result);
 break;
}
case wxGraphicsPath_GetBox: { // wxGraphicsPath::GetBox
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect2DDouble Result = This->GetBox();
 rt.add(Result);
 break;
}
case wxGraphicsPath_GetCurrentPoint: { // wxGraphicsPath::GetCurrentPoint
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint2DDouble Result = This->GetCurrentPoint();
 rt.add(Result);
 break;
}
case wxGraphicsPath_Transform: { // wxGraphicsPath::Transform
 wxGraphicsPath *This = (wxGraphicsPath *) getPtr(bp,memenv); bp += 4;
 wxGraphicsMatrix *matrix = (wxGraphicsMatrix *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Transform(*matrix);
 break;
}
#endif // wxUSE_GRAPHICS_CONTEXT
#if wxUSE_GRAPHICS_CONTEXT
case wxGraphicsRenderer_GetDefaultRenderer: { // wxGraphicsRenderer::GetDefaultRenderer
 wxGraphicsRenderer * Result = (wxGraphicsRenderer*)wxGraphicsRenderer::GetDefaultRenderer();
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsRenderer");
 break;
}
case wxGraphicsRenderer_CreateContext_1_1: { // wxGraphicsRenderer::CreateContext
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 wxWindowDC * dc = (wxWindowDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsContext * Result = (wxGraphicsContext*)This->CreateContext(*dc);
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsContext");
 break;
}
case wxGraphicsRenderer_CreateContext_1_0: { // wxGraphicsRenderer::CreateContext
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsContext * Result = (wxGraphicsContext*)This->CreateContext(window);
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsContext");
 break;
}
case wxGraphicsRenderer_CreatePen: { // wxGraphicsRenderer::CreatePen
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 wxPen *pen = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsPen * Result = new wxGraphicsPen(This->CreatePen(*pen)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsPen");
 break;
}
case wxGraphicsRenderer_CreateBrush: { // wxGraphicsRenderer::CreateBrush
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 wxBrush *brush = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsBrush * Result = new wxGraphicsBrush(This->CreateBrush(*brush)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsBrush");
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxGraphicsRenderer_CreateLinearGradientBrush: { // wxGraphicsRenderer::CreateLinearGradientBrush
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * x1 = (wxDouble *) bp; bp += 8;
 wxDouble * y1 = (wxDouble *) bp; bp += 8;
 wxDouble * x2 = (wxDouble *) bp; bp += 8;
 wxDouble * y2 = (wxDouble *) bp; bp += 8;
 int * c1R = (int *) bp; bp += 4;
 int * c1G = (int *) bp; bp += 4;
 int * c1B = (int *) bp; bp += 4;
 int * c1A = (int *) bp; bp += 4;
 wxColour c1 = wxColour(*c1R,*c1G,*c1B,*c1A);
 int * c2R = (int *) bp; bp += 4;
 int * c2G = (int *) bp; bp += 4;
 int * c2B = (int *) bp; bp += 4;
 int * c2A = (int *) bp; bp += 4;
 wxColour c2 = wxColour(*c2R,*c2G,*c2B,*c2A);
 if(!This) throw wxe_badarg(0);
 wxGraphicsBrush * Result = new wxGraphicsBrush(This->CreateLinearGradientBrush(*x1,*y1,*x2,*y2,c1,c2)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsBrush");
 break;
}
#endif
#if !wxCHECK_VERSION(2,9,0)
case wxGraphicsRenderer_CreateRadialGradientBrush: { // wxGraphicsRenderer::CreateRadialGradientBrush
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxDouble * xo = (wxDouble *) bp; bp += 8;
 wxDouble * yo = (wxDouble *) bp; bp += 8;
 wxDouble * xc = (wxDouble *) bp; bp += 8;
 wxDouble * yc = (wxDouble *) bp; bp += 8;
 wxDouble * radius = (wxDouble *) bp; bp += 8;
 int * oColorR = (int *) bp; bp += 4;
 int * oColorG = (int *) bp; bp += 4;
 int * oColorB = (int *) bp; bp += 4;
 int * oColorA = (int *) bp; bp += 4;
 wxColour oColor = wxColour(*oColorR,*oColorG,*oColorB,*oColorA);
 int * cColorR = (int *) bp; bp += 4;
 int * cColorG = (int *) bp; bp += 4;
 int * cColorB = (int *) bp; bp += 4;
 int * cColorA = (int *) bp; bp += 4;
 wxColour cColor = wxColour(*cColorR,*cColorG,*cColorB,*cColorA);
 if(!This) throw wxe_badarg(0);
 wxGraphicsBrush * Result = new wxGraphicsBrush(This->CreateRadialGradientBrush(*xo,*yo,*xc,*yc,*radius,oColor,cColor)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsBrush");
 break;
}
#endif
case wxGraphicsRenderer_CreateFont: { // wxGraphicsRenderer::CreateFont
 wxColour col= *wxBLACK;
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 col = wxColour(*colR,*colG,*colB,*colA);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxGraphicsFont * Result = new wxGraphicsFont(This->CreateFont(*font,col)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsFont");
 break;
}
case wxGraphicsRenderer_CreateMatrix: { // wxGraphicsRenderer::CreateMatrix
 wxDouble a=1.0;
 wxDouble b=0.0;
 wxDouble c=0.0;
 wxDouble d=1.0;
 wxDouble tx=0.0;
 wxDouble ty=0.0;
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bp += 4; /* Align */
 a = * (wxDouble *) bp; bp += 8;
  } break;
  case 2: {bp += 4;
 bp += 4; /* Align */
 b = * (wxDouble *) bp; bp += 8;
  } break;
  case 3: {bp += 4;
 bp += 4; /* Align */
 c = * (wxDouble *) bp; bp += 8;
  } break;
  case 4: {bp += 4;
 bp += 4; /* Align */
 d = * (wxDouble *) bp; bp += 8;
  } break;
  case 5: {bp += 4;
 bp += 4; /* Align */
 tx = * (wxDouble *) bp; bp += 8;
  } break;
  case 6: {bp += 4;
 bp += 4; /* Align */
 ty = * (wxDouble *) bp; bp += 8;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxGraphicsMatrix * Result = new wxGraphicsMatrix(This->CreateMatrix(a,b,c,d,tx,ty)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsMatrix");
 break;
}
case wxGraphicsRenderer_CreatePath: { // wxGraphicsRenderer::CreatePath
 wxGraphicsRenderer *This = (wxGraphicsRenderer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGraphicsPath * Result = new wxGraphicsPath(This->CreatePath()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxGraphicsPath");
 break;
}
#endif // wxUSE_GRAPHICS_CONTEXT
#if wxUSE_GRAPHICS_CONTEXT
#endif // wxUSE_GRAPHICS_CONTEXT
#if wxUSE_GRAPHICS_CONTEXT
#endif // wxUSE_GRAPHICS_CONTEXT
#if wxUSE_GRAPHICS_CONTEXT
#endif // wxUSE_GRAPHICS_CONTEXT
case wxMenuBar_new_1: { // wxMenuBar::wxMenuBar
 int * style = (int *) bp; bp += 4;
 wxMenuBar * Result = new EwxMenuBar(*style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuBar");
 break;
}
case wxMenuBar_new_0: { // wxMenuBar::wxMenuBar
 wxMenuBar * Result = new EwxMenuBar();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuBar");
 break;
}
case wxMenuBar_Append: { // wxMenuBar::Append
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 wxMenu *menu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Append(menu,title);
 rt.addBool(Result);
 break;
}
case wxMenuBar_Check: { // wxMenuBar::Check
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 bool * check = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Check(*itemid,*check);
 break;
}
case wxMenuBar_Enable_2: { // wxMenuBar::Enable
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 bool * enable = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Enable(*itemid,*enable);
 break;
}
case wxMenuBar_Enable_1: { // wxMenuBar::Enable
 bool enable=true;
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Enable(enable);
 rt.addBool(Result);
 break;
}
case wxMenuBar_EnableTop: { // wxMenuBar::EnableTop
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableTop(*pos,*flag);
 break;
}
case wxMenuBar_FindMenu: { // wxMenuBar::FindMenu
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 int Result = This->FindMenu(title);
 rt.addInt(Result);
 break;
}
case wxMenuBar_FindMenuItem: { // wxMenuBar::FindMenuItem
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * menuStringLen = (int *) bp; bp += 4;
 wxString menuString = wxString(bp, wxConvUTF8);
 bp += *menuStringLen+((8-((0+ *menuStringLen) & 7)) & 7);
 int * itemStringLen = (int *) bp; bp += 4;
 wxString itemString = wxString(bp, wxConvUTF8);
 bp += *itemStringLen+((8-((4+ *itemStringLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 int Result = This->FindMenuItem(menuString,itemString);
 rt.addInt(Result);
 break;
}
case wxMenuBar_FindItem: { // wxMenuBar::FindItem
 wxMenu ** menu = NULL;
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->FindItem(*id,menu);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenuBar_GetHelpString: { // wxMenuBar::GetHelpString
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetHelpString(*itemid);
 rt.add(Result);
 break;
}
case wxMenuBar_GetLabel_1: { // wxMenuBar::GetLabel
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLabel(*itemid);
 rt.add(Result);
 break;
}
case wxMenuBar_GetLabel_0: { // wxMenuBar::GetLabel
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLabel();
 rt.add(Result);
 break;
}
case wxMenuBar_GetLabelTop: { // wxMenuBar::GetLabelTop
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLabelTop(*pos);
 rt.add(Result);
 break;
}
case wxMenuBar_GetMenu: { // wxMenuBar::GetMenu
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenu * Result = (wxMenu*)This->GetMenu(*pos);
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxMenuBar_GetMenuCount: { // wxMenuBar::GetMenuCount
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetMenuCount();
 rt.addInt(Result);
 break;
}
case wxMenuBar_Insert: { // wxMenuBar::Insert
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 wxMenu *menu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Insert(*pos,menu,title);
 rt.addBool(Result);
 break;
}
case wxMenuBar_IsChecked: { // wxMenuBar::IsChecked
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsChecked(*itemid);
 rt.addBool(Result);
 break;
}
case wxMenuBar_IsEnabled_1: { // wxMenuBar::IsEnabled
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEnabled(*itemid);
 rt.addBool(Result);
 break;
}
case wxMenuBar_IsEnabled_0: { // wxMenuBar::IsEnabled
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEnabled();
 rt.addBool(Result);
 break;
}
case wxMenuBar_Remove: { // wxMenuBar::Remove
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenu * Result = (wxMenu*)This->Remove(*pos);
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxMenuBar_Replace: { // wxMenuBar::Replace
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 wxMenu *menu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxMenu * Result = (wxMenu*)This->Replace(*pos,menu,title);
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxMenuBar_SetHelpString: { // wxMenuBar::SetHelpString
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * helpStringLen = (int *) bp; bp += 4;
 wxString helpString = wxString(bp, wxConvUTF8);
 bp += *helpStringLen+((8-((4+ *helpStringLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetHelpString(*itemid,helpString);
 break;
}
case wxMenuBar_SetLabel_2: { // wxMenuBar::SetLabel
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetLabel(*itemid,label);
 break;
}
case wxMenuBar_SetLabel_1: { // wxMenuBar::SetLabel
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * sLen = (int *) bp; bp += 4;
 wxString s = wxString(bp, wxConvUTF8);
 bp += *sLen+((8-((0+ *sLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetLabel(s);
 break;
}
case wxMenuBar_SetLabelTop: { // wxMenuBar::SetLabelTop
 wxMenuBar *This = (wxMenuBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetLabelTop(*pos,label);
 break;
}
case wxControl_GetLabel: { // wxControl::GetLabel
 wxControl *This = (wxControl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLabel();
 rt.add(Result);
 break;
}
case wxControl_SetLabel: { // wxControl::SetLabel
 wxControl *This = (wxControl *) getPtr(bp,memenv); bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetLabel(label);
 break;
}
case wxControlWithItems_Append_1: { // wxControlWithItems::Append
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * itemLen = (int *) bp; bp += 4;
 wxString item = wxString(bp, wxConvUTF8);
 bp += *itemLen+((8-((0+ *itemLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 int Result = This->Append(item);
 rt.addInt(Result);
 break;
}
case wxControlWithItems_Append_2: { // wxControlWithItems::Append
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * itemLen = (int *) bp; bp += 4;
 wxString item = wxString(bp, wxConvUTF8);
 bp += *itemLen+((8-((0+ *itemLen) & 7)) & 7);
 wxeErlTerm * clientData =  new wxeErlTerm(&Ecmd.bin[0]);
 if(!This) throw wxe_badarg(0);
 int Result = This->Append(item,clientData);
 rt.addInt(Result);
 break;
}
case wxControlWithItems_appendStrings_1: { // wxControlWithItems::Append
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * stringsLen = (int *) bp; bp += 4;
 wxArrayString strings;
 int stringsASz = 0, * stringsTemp;
 for(int i=0; i < *stringsLen; i++) {
   stringsTemp = (int *) bp; bp += 4;
   strings.Add(wxString(bp, wxConvUTF8));
   bp += *stringsTemp;
   stringsASz += *stringsTemp+4;
 }
 bp += (8-((0+ stringsASz) & 7 )) & 7;
 if(!This) throw wxe_badarg(0);
 This->Append(strings);
 break;
}
case wxControlWithItems_Clear: { // wxControlWithItems::Clear
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Clear();
 break;
}
case wxControlWithItems_Delete: { // wxControlWithItems::Delete
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Delete(*n);
 break;
}
case wxControlWithItems_FindString: { // wxControlWithItems::FindString
 bool bCase=false;
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * sLen = (int *) bp; bp += 4;
 wxString s = wxString(bp, wxConvUTF8);
 bp += *sLen+((8-((0+ *sLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bCase = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 int Result = This->FindString(s,bCase);
 rt.addInt(Result);
 break;
}
case wxControlWithItems_getClientData: { // wxControlWithItems::GetClientObject
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxeErlTerm * Result = (wxeErlTerm*)This->GetClientObject(*n);
 rt.addExt2Term(Result);
 break;
}
case wxControlWithItems_setClientData: { // wxControlWithItems::SetClientObject
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 wxeErlTerm * clientData =  new wxeErlTerm(&Ecmd.bin[0]);
 if(!This) throw wxe_badarg(0);
 This->SetClientObject(*n,clientData);
 break;
}
case wxControlWithItems_GetCount: { // wxControlWithItems::GetCount
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCount();
 rt.addUint(Result);
 break;
}
case wxControlWithItems_GetSelection: { // wxControlWithItems::GetSelection
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxControlWithItems_GetString: { // wxControlWithItems::GetString
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetString(*n);
 rt.add(Result);
 break;
}
case wxControlWithItems_GetStringSelection: { // wxControlWithItems::GetStringSelection
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetStringSelection();
 rt.add(Result);
 break;
}
case wxControlWithItems_Insert_2: { // wxControlWithItems::Insert
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * itemLen = (int *) bp; bp += 4;
 wxString item = wxString(bp, wxConvUTF8);
 bp += *itemLen+((8-((0+ *itemLen) & 7)) & 7);
 unsigned int * pos = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->Insert(item,*pos);
 rt.addInt(Result);
 break;
}
case wxControlWithItems_Insert_3: { // wxControlWithItems::Insert
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * itemLen = (int *) bp; bp += 4;
 wxString item = wxString(bp, wxConvUTF8);
 bp += *itemLen+((8-((0+ *itemLen) & 7)) & 7);
 unsigned int * pos = (unsigned int *) bp; bp += 4;
 wxeErlTerm * clientData =  new wxeErlTerm(&Ecmd.bin[0]);
 if(!This) throw wxe_badarg(0);
 int Result = This->Insert(item,*pos,clientData);
 rt.addInt(Result);
 break;
}
case wxControlWithItems_IsEmpty: { // wxControlWithItems::IsEmpty
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEmpty();
 rt.addBool(Result);
 break;
}
case wxControlWithItems_Select: { // wxControlWithItems::Select
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Select(*n);
 break;
}
case wxControlWithItems_SetSelection: { // wxControlWithItems::SetSelection
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*n);
 break;
}
case wxControlWithItems_SetString: { // wxControlWithItems::SetString
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 int * sLen = (int *) bp; bp += 4;
 wxString s = wxString(bp, wxConvUTF8);
 bp += *sLen+((8-((4+ *sLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetString(*n,s);
 break;
}
case wxControlWithItems_SetStringSelection: { // wxControlWithItems::SetStringSelection
 wxControlWithItems *This = (wxControlWithItems *) getPtr(bp,memenv); bp += 4;
 int * sLen = (int *) bp; bp += 4;
 wxString s = wxString(bp, wxConvUTF8);
 bp += *sLen+((8-((0+ *sLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetStringSelection(s);
 rt.addBool(Result);
 break;
}
case wxMenu_new_2: { // wxMenu::wxMenu
 long style=0;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxMenu * Result = new EwxMenu(title,style);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxMenu_new_1: { // wxMenu::wxMenu
 long style=0;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxMenu * Result = new EwxMenu(style);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxMenu_Append_3: { // wxMenu::Append
 wxString help= wxEmptyString;
 wxItemKind kind=wxITEM_NORMAL;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
kind = *(wxItemKind *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Append(*itemid,text,help,kind);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Append_1: { // wxMenu::Append
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 wxMenuItem *item = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Append(item);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Append_4_0: { // wxMenu::Append
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 int * helpLen = (int *) bp; bp += 4;
 wxString help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((4+ *helpLen) & 7)) & 7);
 bool * isCheckable = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Append(*itemid,text,help,*isCheckable);
 break;
}
case wxMenu_Append_4_1: { // wxMenu::Append
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 wxMenu *submenu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Append(*itemid,text,submenu,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_AppendCheckItem: { // wxMenu::AppendCheckItem
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->AppendCheckItem(*itemid,text,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_AppendRadioItem: { // wxMenu::AppendRadioItem
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->AppendRadioItem(*itemid,text,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_AppendSeparator: { // wxMenu::AppendSeparator
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->AppendSeparator();
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Break: { // wxMenu::Break
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Break();
 break;
}
case wxMenu_Check: { // wxMenu::Check
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 bool * check = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Check(*itemid,*check);
 break;
}
case wxMenu_Delete_1_0: { // wxMenu::Delete
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Delete(*itemid);
 rt.addBool(Result);
 break;
}
case wxMenu_Delete_1_1: { // wxMenu::Delete
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 wxMenuItem *item = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Delete(item);
 rt.addBool(Result);
 break;
}
case wxMenu_Destroy_1_0: { // wxMenu::Destroy
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Destroy(*itemid);
 rt.addBool(Result);
 break;
}
case wxMenu_Destroy_1_1: { // wxMenu::Destroy
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 wxMenuItem *item = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Destroy(item);
 rt.addBool(Result);
 break;
}
case wxMenu_Enable: { // wxMenu::Enable
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 bool * enable = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Enable(*itemid,*enable);
 break;
}
case wxMenu_FindItem_1: { // wxMenu::FindItem
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemLen = (int *) bp; bp += 4;
 wxString item = wxString(bp, wxConvUTF8);
 bp += *itemLen+((8-((0+ *itemLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 int Result = This->FindItem(item);
 rt.addInt(Result);
 break;
}
case wxMenu_FindItem_2: { // wxMenu::FindItem
 wxMenu ** menu = NULL;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->FindItem(*itemid,menu);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_FindItemByPosition: { // wxMenu::FindItemByPosition
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * position = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->FindItemByPosition(*position);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_GetHelpString: { // wxMenu::GetHelpString
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetHelpString(*itemid);
 rt.add(Result);
 break;
}
case wxMenu_GetLabel: { // wxMenu::GetLabel
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLabel(*itemid);
 rt.add(Result);
 break;
}
case wxMenu_GetMenuItemCount: { // wxMenu::GetMenuItemCount
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetMenuItemCount();
 rt.addInt(Result);
 break;
}
case wxMenu_GetMenuItems: { // wxMenu::GetMenuItems
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxMenuItemList Result = This->GetMenuItems();
 int i=0;
 for(wxMenuItemList::const_iterator it = Result.begin(); it != Result.end(); ++it) {
   wxMenuItem * ResultTmp = *it;
   rt.addRef(getRef((void *)ResultTmp,memenv), "wxMenuItem"); i++;}
 rt.endList(Result.GetCount());
 break;
}
case wxMenu_GetTitle: { // wxMenu::GetTitle
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString Result = This->GetTitle();
 rt.add(Result);
 break;
}
case wxMenu_Insert_2: { // wxMenu::Insert
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 wxMenuItem *item = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Insert(*pos,item);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Insert_3: { // wxMenu::Insert
 wxString text= wxEmptyString;
 wxString help= wxEmptyString;
 wxItemKind kind=wxITEM_NORMAL;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * itemid = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * textLen = (int *) bp; bp += 4;
 text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
kind = *(wxItemKind *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Insert(*pos,*itemid,text,help,kind);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Insert_5_1: { // wxMenu::Insert
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 wxMenu *submenu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Insert(*pos,*itemid,text,submenu,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Insert_5_0: { // wxMenu::Insert
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 int * helpLen = (int *) bp; bp += 4;
 wxString help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((4+ *helpLen) & 7)) & 7);
 bool * isCheckable = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Insert(*pos,*itemid,text,help,*isCheckable);
 break;
}
case wxMenu_InsertCheckItem: { // wxMenu::InsertCheckItem
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->InsertCheckItem(*pos,*itemid,text,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_InsertRadioItem: { // wxMenu::InsertRadioItem
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->InsertRadioItem(*pos,*itemid,text,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_InsertSeparator: { // wxMenu::InsertSeparator
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->InsertSeparator(*pos);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_IsChecked: { // wxMenu::IsChecked
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsChecked(*itemid);
 rt.addBool(Result);
 break;
}
case wxMenu_IsEnabled: { // wxMenu::IsEnabled
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEnabled(*itemid);
 rt.addBool(Result);
 break;
}
case wxMenu_Prepend_1: { // wxMenu::Prepend
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 wxMenuItem *item = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Prepend(item);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Prepend_2: { // wxMenu::Prepend
 wxString text= wxEmptyString;
 wxString help= wxEmptyString;
 wxItemKind kind=wxITEM_NORMAL;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * textLen = (int *) bp; bp += 4;
 text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
kind = *(wxItemKind *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Prepend(*itemid,text,help,kind);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Prepend_4_1: { // wxMenu::Prepend
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 wxMenu *submenu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Prepend(*itemid,text,submenu,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Prepend_4_0: { // wxMenu::Prepend
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 int * helpLen = (int *) bp; bp += 4;
 wxString help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((4+ *helpLen) & 7)) & 7);
 bool * isCheckable = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Prepend(*itemid,text,help,*isCheckable);
 break;
}
case wxMenu_PrependCheckItem: { // wxMenu::PrependCheckItem
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->PrependCheckItem(*itemid,text,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_PrependRadioItem: { // wxMenu::PrependRadioItem
 wxString help= wxEmptyString;
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->PrependRadioItem(*itemid,text,help);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_PrependSeparator: { // wxMenu::PrependSeparator
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->PrependSeparator();
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Remove_1_0: { // wxMenu::Remove
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Remove(*itemid);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_Remove_1_1: { // wxMenu::Remove
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 wxMenuItem *item = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenuItem * Result = (wxMenuItem*)This->Remove(item);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenu_SetHelpString: { // wxMenu::SetHelpString
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * helpStringLen = (int *) bp; bp += 4;
 wxString helpString = wxString(bp, wxConvUTF8);
 bp += *helpStringLen+((8-((4+ *helpStringLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetHelpString(*itemid,helpString);
 break;
}
case wxMenu_SetLabel: { // wxMenu::SetLabel
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * itemid = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetLabel(*itemid,label);
 break;
}
case wxMenu_SetTitle: { // wxMenu::SetTitle
 wxMenu *This = (wxMenu *) getPtr(bp,memenv); bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetTitle(title);
 break;
}
case wxMenuItem_new: { // wxMenuItem::wxMenuItem
 wxMenu * parentMenu=(wxMenu *) NULL;
 int id=wxID_SEPARATOR;
 wxString text= wxEmptyString;
 wxString help= wxEmptyString;
 wxItemKind kind=wxITEM_NORMAL;
 wxMenu * subMenu=(wxMenu *) NULL;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
parentMenu = (wxMenu *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 id = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 int * textLen = (int *) bp; bp += 4;
 text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
 int * helpLen = (int *) bp; bp += 4;
 help = wxString(bp, wxConvUTF8);
 bp += *helpLen+((8-((0+ *helpLen) & 7)) & 7);
  } break;
  case 5: {bp += 4;
kind = *(wxItemKind *) bp; bp += 4;;
  } break;
  case 6: {bp += 4;
subMenu = (wxMenu *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxMenuItem * Result = new EwxMenuItem(parentMenu,id,text,help,kind,subMenu);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuItem");
 break;
}
case wxMenuItem_Check: { // wxMenuItem::Check
 bool check=TRUE;
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 check = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Check(check);
 break;
}
case wxMenuItem_Enable: { // wxMenuItem::Enable
 bool enable=TRUE;
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Enable(enable);
 break;
}
case wxMenuItem_GetBitmap: { // wxMenuItem::GetBitmap
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxBitmap * Result = &This->GetBitmap();
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxMenuItem_GetHelp: { // wxMenuItem::GetHelp
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString * Result = &This->GetHelp();
 rt.add(Result);
 break;
}
case wxMenuItem_GetId: { // wxMenuItem::GetId
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetId();
 rt.addInt(Result);
 break;
}
case wxMenuItem_GetKind: { // wxMenuItem::GetKind
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetKind();
 rt.addInt(Result);
 break;
}
case wxMenuItem_GetLabel: { // wxMenuItem::GetLabel
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLabel();
 rt.add(Result);
 break;
}
case wxMenuItem_GetLabelFromText: { // wxMenuItem::GetLabelFromText
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 wxString Result = wxMenuItem::GetLabelFromText(text);
 rt.add(Result);
 break;
}
case wxMenuItem_GetMenu: { // wxMenuItem::GetMenu
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenu * Result = (wxMenu*)This->GetMenu();
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxMenuItem_GetText: { // wxMenuItem::GetText
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString * Result = &This->GetText();
 rt.add(Result);
 break;
}
case wxMenuItem_GetSubMenu: { // wxMenuItem::GetSubMenu
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenu * Result = (wxMenu*)This->GetSubMenu();
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxMenuItem_IsCheckable: { // wxMenuItem::IsCheckable
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsCheckable();
 rt.addBool(Result);
 break;
}
case wxMenuItem_IsChecked: { // wxMenuItem::IsChecked
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsChecked();
 rt.addBool(Result);
 break;
}
case wxMenuItem_IsEnabled: { // wxMenuItem::IsEnabled
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEnabled();
 rt.addBool(Result);
 break;
}
case wxMenuItem_IsSeparator: { // wxMenuItem::IsSeparator
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSeparator();
 rt.addBool(Result);
 break;
}
case wxMenuItem_IsSubMenu: { // wxMenuItem::IsSubMenu
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSubMenu();
 rt.addBool(Result);
 break;
}
case wxMenuItem_SetBitmap: { // wxMenuItem::SetBitmap
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBitmap(*bitmap);
 break;
}
case wxMenuItem_SetHelp: { // wxMenuItem::SetHelp
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetHelp(str);
 break;
}
case wxMenuItem_SetMenu: { // wxMenuItem::SetMenu
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 wxMenu *menu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMenu(menu);
 break;
}
case wxMenuItem_SetSubMenu: { // wxMenuItem::SetSubMenu
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 wxMenu *menu = (wxMenu *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSubMenu(menu);
 break;
}
case wxMenuItem_SetText: { // wxMenuItem::SetText
 wxMenuItem *This = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetText(str);
 break;
}
case wxToolBar_AddControl: { // wxToolBar::AddControl
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 wxControl *control = (wxControl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddControl(control);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddSeparator: { // wxToolBar::AddSeparator
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddSeparator();
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddTool_5: { // wxToolBar::AddTool
 wxItemKind kind=wxITEM_NORMAL;
 wxString shortHelp= wxEmptyString;
 wxString longHelp= wxEmptyString;
 wxObject * data=NULL;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmpDisabled = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
kind = *(wxItemKind *) bp; bp += 4;;
  } break;
  case 2: {bp += 4;
 int * shortHelpLen = (int *) bp; bp += 4;
 shortHelp = wxString(bp, wxConvUTF8);
 bp += *shortHelpLen+((8-((0+ *shortHelpLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * longHelpLen = (int *) bp; bp += 4;
 longHelp = wxString(bp, wxConvUTF8);
 bp += *longHelpLen+((8-((0+ *longHelpLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
data = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddTool(*toolid,label,*bitmap,*bmpDisabled,kind,shortHelp,longHelp,data);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddTool_4_0: { // wxToolBar::AddTool
 wxString shortHelp= wxEmptyString;
 wxItemKind kind=wxITEM_NORMAL;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * shortHelpLen = (int *) bp; bp += 4;
 shortHelp = wxString(bp, wxConvUTF8);
 bp += *shortHelpLen+((8-((0+ *shortHelpLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
kind = *(wxItemKind *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddTool(*toolid,label,*bitmap,shortHelp,kind);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddTool_1: { // wxToolBar::AddTool
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 wxToolBarToolBase *tool = (wxToolBarToolBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddTool(tool);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddTool_4_1: { // wxToolBar::AddTool
 bool toggle=false;
 wxObject * clientData=NULL;
 wxString shortHelpString= wxEmptyString;
 wxString longHelpString= wxEmptyString;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmpDisabled = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 toggle = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
clientData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
  case 3: {bp += 4;
 int * shortHelpStringLen = (int *) bp; bp += 4;
 shortHelpString = wxString(bp, wxConvUTF8);
 bp += *shortHelpStringLen+((8-((0+ *shortHelpStringLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
 int * longHelpStringLen = (int *) bp; bp += 4;
 longHelpString = wxString(bp, wxConvUTF8);
 bp += *longHelpStringLen+((8-((0+ *longHelpStringLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddTool(*toolid,*bitmap,*bmpDisabled,toggle,clientData,shortHelpString,longHelpString);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddTool_3: { // wxToolBar::AddTool
 wxString shortHelpString= wxEmptyString;
 wxString longHelpString= wxEmptyString;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * shortHelpStringLen = (int *) bp; bp += 4;
 shortHelpString = wxString(bp, wxConvUTF8);
 bp += *shortHelpStringLen+((8-((0+ *shortHelpStringLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * longHelpStringLen = (int *) bp; bp += 4;
 longHelpString = wxString(bp, wxConvUTF8);
 bp += *longHelpStringLen+((8-((0+ *longHelpStringLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddTool(*toolid,*bitmap,shortHelpString,longHelpString);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddTool_6: { // wxToolBar::AddTool
 wxCoord yPos=wxDefaultCoord;
 wxObject * clientData=NULL;
 wxString shortHelp= wxEmptyString;
 wxString longHelp= wxEmptyString;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmpDisabled = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 bool * toggle = (bool *) bp; bp += 4;
 int * xPos = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 yPos = (wxCoord)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
clientData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
  case 3: {bp += 4;
 int * shortHelpLen = (int *) bp; bp += 4;
 shortHelp = wxString(bp, wxConvUTF8);
 bp += *shortHelpLen+((8-((0+ *shortHelpLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
 int * longHelpLen = (int *) bp; bp += 4;
 longHelp = wxString(bp, wxConvUTF8);
 bp += *longHelpLen+((8-((0+ *longHelpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddTool(*toolid,*bitmap,*bmpDisabled,*toggle,*xPos,yPos,clientData,shortHelp,longHelp);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddCheckTool: { // wxToolBar::AddCheckTool
 const wxBitmap * bmpDisabled= &wxNullBitmap;
 wxString shortHelp= wxEmptyString;
 wxString longHelp= wxEmptyString;
 wxObject * data=NULL;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
bmpDisabled = (wxBitmap *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 int * shortHelpLen = (int *) bp; bp += 4;
 shortHelp = wxString(bp, wxConvUTF8);
 bp += *shortHelpLen+((8-((0+ *shortHelpLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * longHelpLen = (int *) bp; bp += 4;
 longHelp = wxString(bp, wxConvUTF8);
 bp += *longHelpLen+((8-((0+ *longHelpLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
data = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddCheckTool(*toolid,label,*bitmap,*bmpDisabled,shortHelp,longHelp,data);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_AddRadioTool: { // wxToolBar::AddRadioTool
 const wxBitmap * bmpDisabled= &wxNullBitmap;
 wxString shortHelp= wxEmptyString;
 wxString longHelp= wxEmptyString;
 wxObject * data=NULL;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
bmpDisabled = (wxBitmap *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 int * shortHelpLen = (int *) bp; bp += 4;
 shortHelp = wxString(bp, wxConvUTF8);
 bp += *shortHelpLen+((8-((0+ *shortHelpLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * longHelpLen = (int *) bp; bp += 4;
 longHelp = wxString(bp, wxConvUTF8);
 bp += *longHelpLen+((8-((0+ *longHelpLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
data = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddRadioTool(*toolid,label,*bitmap,*bmpDisabled,shortHelp,longHelp,data);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
#if wxCHECK_VERSION(3,0,0)
case wxToolBar_AddStretchableSpace: { // wxToolBar::AddStretchableSpace
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->AddStretchableSpace();
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
#endif
#if wxCHECK_VERSION(3,0,0)
case wxToolBar_InsertStretchableSpace: { // wxToolBar::InsertStretchableSpace
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->InsertStretchableSpace(*pos);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
#endif
case wxToolBar_DeleteTool: { // wxToolBar::DeleteTool
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteTool(*toolid);
 rt.addBool(Result);
 break;
}
case wxToolBar_DeleteToolByPos: { // wxToolBar::DeleteToolByPos
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteToolByPos(*pos);
 rt.addBool(Result);
 break;
}
case wxToolBar_EnableTool: { // wxToolBar::EnableTool
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 bool * enable = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableTool(*toolid,*enable);
 break;
}
case wxToolBar_FindById: { // wxToolBar::FindById
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->FindById(*toolid);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_FindControl: { // wxToolBar::FindControl
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxControl * Result = (wxControl*)This->FindControl(*toolid);
 rt.addRef(getRef((void *)Result,memenv), "wxControl");
 break;
}
case wxToolBar_FindToolForPosition: { // wxToolBar::FindToolForPosition
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->FindToolForPosition(*x,*y);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_GetToolSize: { // wxToolBar::GetToolSize
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetToolSize();
 rt.add(Result);
 break;
}
case wxToolBar_GetToolBitmapSize: { // wxToolBar::GetToolBitmapSize
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetToolBitmapSize();
 rt.add(Result);
 break;
}
case wxToolBar_GetMargins: { // wxToolBar::GetMargins
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetMargins();
 rt.add(Result);
 break;
}
case wxToolBar_GetToolEnabled: { // wxToolBar::GetToolEnabled
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetToolEnabled(*toolid);
 rt.addBool(Result);
 break;
}
case wxToolBar_GetToolLongHelp: { // wxToolBar::GetToolLongHelp
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetToolLongHelp(*toolid);
 rt.add(Result);
 break;
}
case wxToolBar_GetToolPacking: { // wxToolBar::GetToolPacking
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetToolPacking();
 rt.addInt(Result);
 break;
}
case wxToolBar_GetToolPos: { // wxToolBar::GetToolPos
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetToolPos(*id);
 rt.addInt(Result);
 break;
}
case wxToolBar_GetToolSeparation: { // wxToolBar::GetToolSeparation
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetToolSeparation();
 rt.addInt(Result);
 break;
}
case wxToolBar_GetToolShortHelp: { // wxToolBar::GetToolShortHelp
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetToolShortHelp(*toolid);
 rt.add(Result);
 break;
}
case wxToolBar_GetToolState: { // wxToolBar::GetToolState
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetToolState(*toolid);
 rt.addBool(Result);
 break;
}
case wxToolBar_InsertControl: { // wxToolBar::InsertControl
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 wxControl *control = (wxControl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->InsertControl(*pos,control);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_InsertSeparator: { // wxToolBar::InsertSeparator
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->InsertSeparator(*pos);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_InsertTool_5: { // wxToolBar::InsertTool
 const wxBitmap * bmpDisabled= &wxNullBitmap;
 wxItemKind kind=wxITEM_NORMAL;
 wxString shortHelp= wxEmptyString;
 wxString longHelp= wxEmptyString;
 wxObject * clientData=NULL;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * toolid = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
bmpDisabled = (wxBitmap *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
kind = *(wxItemKind *) bp; bp += 4;;
  } break;
  case 3: {bp += 4;
 int * shortHelpLen = (int *) bp; bp += 4;
 shortHelp = wxString(bp, wxConvUTF8);
 bp += *shortHelpLen+((8-((0+ *shortHelpLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
 int * longHelpLen = (int *) bp; bp += 4;
 longHelp = wxString(bp, wxConvUTF8);
 bp += *longHelpLen+((8-((0+ *longHelpLen) & 7)) & 7);
  } break;
  case 5: {bp += 4;
clientData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->InsertTool(*pos,*toolid,label,*bitmap,*bmpDisabled,kind,shortHelp,longHelp,clientData);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_InsertTool_2: { // wxToolBar::InsertTool
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 wxToolBarToolBase *tool = (wxToolBarToolBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->InsertTool(*pos,tool);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_InsertTool_4: { // wxToolBar::InsertTool
 const wxBitmap * bmpDisabled= &wxNullBitmap;
 bool toggle=false;
 wxObject * clientData=NULL;
 wxString shortHelp= wxEmptyString;
 wxString longHelp= wxEmptyString;
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * toolid = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
bmpDisabled = (wxBitmap *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 toggle = *(bool *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
clientData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
  case 4: {bp += 4;
 int * shortHelpLen = (int *) bp; bp += 4;
 shortHelp = wxString(bp, wxConvUTF8);
 bp += *shortHelpLen+((8-((0+ *shortHelpLen) & 7)) & 7);
  } break;
  case 5: {bp += 4;
 int * longHelpLen = (int *) bp; bp += 4;
 longHelp = wxString(bp, wxConvUTF8);
 bp += *longHelpLen+((8-((0+ *longHelpLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->InsertTool(*pos,*toolid,*bitmap,*bmpDisabled,toggle,clientData,shortHelp,longHelp);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_Realize: { // wxToolBar::Realize
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Realize();
 rt.addBool(Result);
 break;
}
case wxToolBar_RemoveTool: { // wxToolBar::RemoveTool
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolBarToolBase * Result = (wxToolBarToolBase*)This->RemoveTool(*toolid);
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxToolBar_SetMargins: { // wxToolBar::SetMargins
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMargins(*x,*y);
 break;
}
case wxToolBar_SetToolBitmapSize: { // wxToolBar::SetToolBitmapSize
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetToolBitmapSize(size);
 break;
}
case wxToolBar_SetToolLongHelp: { // wxToolBar::SetToolLongHelp
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 int * helpStringLen = (int *) bp; bp += 4;
 wxString helpString = wxString(bp, wxConvUTF8);
 bp += *helpStringLen+((8-((4+ *helpStringLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetToolLongHelp(*toolid,helpString);
 break;
}
case wxToolBar_SetToolPacking: { // wxToolBar::SetToolPacking
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * packing = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetToolPacking(*packing);
 break;
}
case wxToolBar_SetToolShortHelp: { // wxToolBar::SetToolShortHelp
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * helpStringLen = (int *) bp; bp += 4;
 wxString helpString = wxString(bp, wxConvUTF8);
 bp += *helpStringLen+((8-((4+ *helpStringLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetToolShortHelp(*id,helpString);
 break;
}
case wxToolBar_SetToolSeparation: { // wxToolBar::SetToolSeparation
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * separation = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetToolSeparation(*separation);
 break;
}
case wxToolBar_ToggleTool: { // wxToolBar::ToggleTool
 wxToolBar *This = (wxToolBar *) getPtr(bp,memenv); bp += 4;
 int * toolid = (int *) bp; bp += 4;
 bool * toggle = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ToggleTool(*toolid,*toggle);
 break;
}
case wxStatusBar_new_0: { // wxStatusBar::wxStatusBar
 wxStatusBar * Result = new EwxStatusBar();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStatusBar");
 break;
}
case wxStatusBar_new_2: { // wxStatusBar::wxStatusBar
 wxWindowID winid=wxID_ANY;
 long style=wxST_SIZEGRIP;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 winid = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxStatusBar * Result = new EwxStatusBar(parent,winid,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStatusBar");
 break;
}
case wxStatusBar_Create: { // wxStatusBar::Create
 wxWindowID winid=wxID_ANY;
 long style=wxST_SIZEGRIP;
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 winid = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,winid,style);
 rt.addBool(Result);
 break;
}
case wxStatusBar_GetFieldRect: { // wxStatusBar::GetFieldRect
 wxRect rect;
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 int * i = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetFieldRect(*i,rect);
 rt.addBool(Result);
 rt.add(rect);
 rt.addTupleCount(2);
 break;
}
case wxStatusBar_GetFieldsCount: { // wxStatusBar::GetFieldsCount
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFieldsCount();
 rt.addInt(Result);
 break;
}
case wxStatusBar_GetStatusText: { // wxStatusBar::GetStatusText
 int number=0;
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 number = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetStatusText(number);
 rt.add(Result);
 break;
}
case wxStatusBar_PopStatusText: { // wxStatusBar::PopStatusText
 int number=0;
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 number = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->PopStatusText(number);
 break;
}
case wxStatusBar_PushStatusText: { // wxStatusBar::PushStatusText
 int number=0;
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 number = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->PushStatusText(text,number);
 break;
}
case wxStatusBar_SetFieldsCount: { // wxStatusBar::SetFieldsCount
 int * widthsLen = 0;
 int * widths = (int *) NULL;
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 int * number = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 widthsLen = (int *) bp; bp += 4;
 widths = (int *) bp; bp += *widthsLen*4+((0+ *widthsLen)%2 )*4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetFieldsCount(*number,widths);
 break;
}
case wxStatusBar_SetMinHeight: { // wxStatusBar::SetMinHeight
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMinHeight(*height);
 break;
}
case wxStatusBar_SetStatusText: { // wxStatusBar::SetStatusText
 int number=0;
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 number = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetStatusText(text,number);
 break;
}
case wxStatusBar_SetStatusWidths: { // wxStatusBar::SetStatusWidths
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 int * widths_fieldLen = (int *) bp; bp += 4;
 int * widths_field = (int *) bp; bp += *widths_fieldLen*4+((0+ *widths_fieldLen)%2 )*4;
 if(!This) throw wxe_badarg(0);
 This->SetStatusWidths(*widths_fieldLen,widths_field);
 break;
}
case wxStatusBar_SetStatusStyles: { // wxStatusBar::SetStatusStyles
 wxStatusBar *This = (wxStatusBar *) getPtr(bp,memenv); bp += 4;
 int * stylesLen = (int *) bp; bp += 4;
 int * styles = (int *) bp; bp += *stylesLen*4+((0+ *stylesLen)%2 )*4;
 if(!This) throw wxe_badarg(0);
 This->SetStatusStyles(*stylesLen,styles);
 break;
}
case wxBitmap_new_0: { // wxBitmap::wxBitmap
 wxBitmap * Result = new EwxBitmap();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmap_new_3: { // wxBitmap::wxBitmap
 int depth=-1;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 depth = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxBitmap * Result = new EwxBitmap(*width,*height,depth);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmap_new_4: { // wxBitmap::wxBitmap
 int depth=1;
 const char * bits = (const char*) Ecmd.bin[0].base;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 depth = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxBitmap * Result = new EwxBitmap(bits,*width,*height,depth);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmap_new_2_0: { // wxBitmap::wxBitmap
 wxBitmapType type=wxBITMAP_TYPE_XPM;
 int * filenameLen = (int *) bp; bp += 4;
 wxString filename = wxString(bp, wxConvUTF8);
 bp += *filenameLen+((8-((4+ *filenameLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
type = *(wxBitmapType *) bp; bp += 4;;
  } break;
 }};
 wxBitmap * Result = new EwxBitmap(filename,type);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmap_new_2_1: { // wxBitmap::wxBitmap
 int depth=-1;
 wxImage *image = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 depth = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxBitmap * Result = new EwxBitmap(*image,depth);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmap_ConvertToImage: { // wxBitmap::ConvertToImage
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->ConvertToImage()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxBitmap_CopyFromIcon: { // wxBitmap::CopyFromIcon
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxIcon *icon = (wxIcon *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CopyFromIcon(*icon);
 rt.addBool(Result);
 break;
}
case wxBitmap_Create: { // wxBitmap::Create
 int depth=-1;
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 depth = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(*width,*height,depth);
 rt.addBool(Result);
 break;
}
case wxBitmap_GetDepth: { // wxBitmap::GetDepth
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDepth();
 rt.addInt(Result);
 break;
}
case wxBitmap_GetHeight: { // wxBitmap::GetHeight
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetHeight();
 rt.addInt(Result);
 break;
}
case wxBitmap_GetPalette: { // wxBitmap::GetPalette
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPalette * Result = (wxPalette*)This->GetPalette();
 rt.addRef(getRef((void *)Result,memenv), "wxPalette");
 break;
}
case wxBitmap_GetMask: { // wxBitmap::GetMask
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMask * Result = (wxMask*)This->GetMask();
 rt.addRef(getRef((void *)Result,memenv), "wxMask");
 break;
}
case wxBitmap_GetWidth: { // wxBitmap::GetWidth
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWidth();
 rt.addInt(Result);
 break;
}
case wxBitmap_GetSubBitmap: { // wxBitmap::GetSubBitmap
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 wxBitmap * Result = new EwxBitmap(This->GetSubBitmap(rect)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmap_LoadFile: { // wxBitmap::LoadFile
 wxBitmapType type=wxBITMAP_TYPE_XPM;
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
type = *(wxBitmapType *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->LoadFile(name,type);
 rt.addBool(Result);
 break;
}
case wxBitmap_Ok: { // wxBitmap::Ok
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Ok();
 rt.addBool(Result);
 break;
}
case wxBitmap_SaveFile: { // wxBitmap::SaveFile
 const wxPalette * palette=(wxPalette *) NULL;
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 wxBitmapType type = *(wxBitmapType *) bp; bp += 4;;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
palette = (wxPalette *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->SaveFile(name,type,palette);
 rt.addBool(Result);
 break;
}
case wxBitmap_SetDepth: { // wxBitmap::SetDepth
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * depth = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDepth(*depth);
 break;
}
case wxBitmap_SetHeight: { // wxBitmap::SetHeight
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetHeight(*height);
 break;
}
case wxBitmap_SetMask: { // wxBitmap::SetMask
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxMask *mask = (wxMask *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMask(mask);
 break;
}
case wxBitmap_SetPalette: { // wxBitmap::SetPalette
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxPalette *palette = (wxPalette *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPalette(*palette);
 break;
}
case wxBitmap_SetWidth: { // wxBitmap::SetWidth
 wxBitmap *This = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWidth(*width);
 break;
}
case wxIcon_new_0: { // wxIcon::wxIcon
 wxIcon * Result = new EwxIcon();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxIcon");
 break;
}
case wxIcon_new_2: { // wxIcon::wxIcon
 wxBitmapType type=wxICON_DEFAULT_BITMAP_TYPE;
 int desiredWidth=-1;
 int desiredHeight=-1;
 int * filenameLen = (int *) bp; bp += 4;
 wxString filename = wxString(bp, wxConvUTF8);
 bp += *filenameLen+((8-((4+ *filenameLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
type = *(wxBitmapType *) bp; bp += 4;;
  } break;
  case 2: {bp += 4;
 desiredWidth = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 desiredHeight = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxIcon * Result = new EwxIcon(filename,type,desiredWidth,desiredHeight);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxIcon");
 break;
}
case wxIcon_new_1: { // wxIcon::wxIcon
 wxIconLocation *loc = (wxIconLocation *) getPtr(bp,memenv); bp += 4;
 wxIcon * Result = new EwxIcon(*loc);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxIcon");
 break;
}
case wxIcon_CopyFromBitmap: { // wxIcon::CopyFromBitmap
 wxIcon *This = (wxIcon *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CopyFromBitmap(*bmp);
 break;
}
case wxIconBundle_new_0: { // wxIconBundle::wxIconBundle
 wxIconBundle * Result = new wxIconBundle();
 newPtr((void *) Result, 61, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxIconBundle");
 break;
}
case wxIconBundle_new_2: { // wxIconBundle::wxIconBundle
 int * fileLen = (int *) bp; bp += 4;
 wxString file = wxString(bp, wxConvUTF8);
 bp += *fileLen+((8-((4+ *fileLen) & 7)) & 7);
 int * type = (int *) bp; bp += 4;
 wxIconBundle * Result = new wxIconBundle(file,*type);
 newPtr((void *) Result, 61, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxIconBundle");
 break;
}
case wxIconBundle_new_1_0: { // wxIconBundle::wxIconBundle
 wxIcon *icon = (wxIcon *) getPtr(bp,memenv); bp += 4;
 wxIconBundle * Result = new wxIconBundle(*icon);
 newPtr((void *) Result, 61, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxIconBundle");
 break;
}
case wxIconBundle_new_1_1: { // wxIconBundle::wxIconBundle
 wxIconBundle * ic = (wxIconBundle *) getPtr(bp,memenv); bp += 4;
 wxIconBundle * Result = new wxIconBundle(*ic);
 newPtr((void *) Result, 61, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxIconBundle");
 break;
}
case wxIconBundle_destruct: { // wxIconBundle::~wxIconBundle
 wxIconBundle *This = (wxIconBundle *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxIconBundle_AddIcon_2: { // wxIconBundle::AddIcon
 wxIconBundle *This = (wxIconBundle *) getPtr(bp,memenv); bp += 4;
 int * fileLen = (int *) bp; bp += 4;
 wxString file = wxString(bp, wxConvUTF8);
 bp += *fileLen+((8-((0+ *fileLen) & 7)) & 7);
 int * type = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AddIcon(file,*type);
 break;
}
case wxIconBundle_AddIcon_1: { // wxIconBundle::AddIcon
 wxIconBundle *This = (wxIconBundle *) getPtr(bp,memenv); bp += 4;
 wxIcon *icon = (wxIcon *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AddIcon(*icon);
 break;
}
case wxIconBundle_GetIcon_1_1: { // wxIconBundle::GetIcon
 wxIconBundle *This = (wxIconBundle *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 const wxIcon * Result = new EwxIcon(This->GetIcon(size)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxIcon");
 break;
}
case wxIconBundle_GetIcon_1_0: { // wxIconBundle::GetIcon
 wxCoord size=wxDefaultCoord;
 wxIconBundle *This = (wxIconBundle *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 size = (wxCoord)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 const wxIcon * Result = new EwxIcon(This->GetIcon(size)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxIcon");
 break;
}
case wxCursor_new_0: { // wxCursor::wxCursor
 wxCursor * Result = new EwxCursor();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCursor");
 break;
}
case wxCursor_new_1_0: { // wxCursor::wxCursor
 int * cursorId = (int *) bp; bp += 4;
 wxCursor * Result = new EwxCursor(*cursorId);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCursor");
 break;
}
case wxCursor_new_1_1: { // wxCursor::wxCursor
 wxImage *image = (wxImage *) getPtr(bp,memenv); bp += 4;
 wxCursor * Result = new EwxCursor(*image);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCursor");
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxCursor_new_4: { // wxCursor::wxCursor
 int hotSpotX=-1;
 int hotSpotY=-1;
 const char * bits = (const char*) Ecmd.bin[0].base;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 hotSpotX = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 hotSpotY = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxCursor * Result = new EwxCursor(bits,*width,*height,hotSpotX,hotSpotY);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCursor");
 break;
}
#endif
case wxCursor_Ok: { // wxCursor::Ok
 wxCursor *This = (wxCursor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Ok();
 rt.addBool(Result);
 break;
}
case wxMask_new_0: { // wxMask::wxMask
 wxMask * Result = new EwxMask();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMask");
 break;
}
case wxMask_new_2_1: { // wxMask::wxMask
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 wxMask * Result = new EwxMask(*bitmap,colour);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMask");
 break;
}
case wxMask_new_2_0: { // wxMask::wxMask
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * paletteIndex = (int *) bp; bp += 4;
 wxMask * Result = new EwxMask(*bitmap,*paletteIndex);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMask");
 break;
}
case wxMask_new_1: { // wxMask::wxMask
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxMask * Result = new EwxMask(*bitmap);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMask");
 break;
}
case wxMask_Create_2_1: { // wxMask::Create
 wxMask *This = (wxMask *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(*bitmap,colour);
 rt.addBool(Result);
 break;
}
case wxMask_Create_2_0: { // wxMask::Create
 wxMask *This = (wxMask *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * paletteIndex = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(*bitmap,*paletteIndex);
 rt.addBool(Result);
 break;
}
case wxMask_Create_1: { // wxMask::Create
 wxMask *This = (wxMask *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(*bitmap);
 rt.addBool(Result);
 break;
}
case wxImage_new_0: { // wxImage::wxImage
 wxImage * Result = new EwxImage();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_new_3_0: { // wxImage::wxImage
 bool clear=true;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 clear = *(bool *) bp; bp += 4;
  } break;
 }};
 wxImage * Result = new EwxImage(*width,*height,clear);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_new_4: { // wxImage::wxImage
 bool static_data=false;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 unsigned char * data = (unsigned char*) Ecmd.bin[0].base;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 static_data = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!static_data) {data = (unsigned char *) malloc(Ecmd.bin[0].size);memcpy(data,Ecmd.bin[0].base,Ecmd.bin[0].size);};
 wxImage * Result = new EwxImage(*width,*height,data,static_data);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_new_5: { // wxImage::wxImage
 bool static_data=false;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 unsigned char * data = (unsigned char*) Ecmd.bin[0].base;
 unsigned char * alpha = (unsigned char*) Ecmd.bin[1].base;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 static_data = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!static_data) { data = (unsigned char *) malloc(Ecmd.bin[0].size); alpha = (unsigned char *) malloc(Ecmd.bin[1].size); memcpy(data,Ecmd.bin[0].base,Ecmd.bin[0].size); memcpy(alpha,Ecmd.bin[1].base,Ecmd.bin[1].size);};
 wxImage * Result = new EwxImage(*width,*height,data,alpha,static_data);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_new_2: { // wxImage::wxImage
 long type=wxBITMAP_TYPE_ANY;
 int index=-1;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 type = (long)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 index = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxImage * Result = new EwxImage(name,type,index);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_new_3_1: { // wxImage::wxImage
 int index=-1;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 int * mimetypeLen = (int *) bp; bp += 4;
 wxString mimetype = wxString(bp, wxConvUTF8);
 bp += *mimetypeLen+((8-((4+ *mimetypeLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 index = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxImage * Result = new EwxImage(name,mimetype,index);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_Blur: { // wxImage::Blur
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * radius = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->Blur(*radius)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_BlurHorizontal: { // wxImage::BlurHorizontal
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * radius = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->BlurHorizontal(*radius)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_BlurVertical: { // wxImage::BlurVertical
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * radius = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->BlurVertical(*radius)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_ConvertAlphaToMask: { // wxImage::ConvertAlphaToMask
 char threshold=wxIMAGE_ALPHA_THRESHOLD;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 threshold = (char)*(unsigned int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ConvertAlphaToMask(threshold);
 rt.addBool(Result);
 break;
}
case wxImage_ConvertToGreyscale: { // wxImage::ConvertToGreyscale
 double lr=0.299;
 double lg=0.587;
 double lb=0.114;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bp += 4; /* Align */
 lr = * (double *) bp; bp += 8;
  } break;
  case 2: {bp += 4;
 bp += 4; /* Align */
 lg = * (double *) bp; bp += 8;
  } break;
  case 3: {bp += 4;
 bp += 4; /* Align */
 lb = * (double *) bp; bp += 8;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->ConvertToGreyscale(lr,lg,lb)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_ConvertToMono: { // wxImage::ConvertToMono
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 unsigned int * r = (unsigned int *) bp; bp += 4;
 unsigned int * g = (unsigned int *) bp; bp += 4;
 unsigned int * b = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->ConvertToMono(*r,*g,*b)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_Copy: { // wxImage::Copy
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->Copy()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_Create_3: { // wxImage::Create
 bool clear=true;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 clear = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(*width,*height,clear);
 rt.addBool(Result);
 break;
}
case wxImage_Create_4: { // wxImage::Create
 bool static_data=false;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 unsigned char * data = (unsigned char*) Ecmd.bin[0].base;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 static_data = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!static_data) {data = (unsigned char *) malloc(Ecmd.bin[0].size);memcpy(data,Ecmd.bin[0].base,Ecmd.bin[0].size);};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(*width,*height,data,static_data);
 rt.addBool(Result);
 break;
}
case wxImage_Create_5: { // wxImage::Create
 bool static_data=false;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 unsigned char * data = (unsigned char*) Ecmd.bin[0].base;
 unsigned char * alpha = (unsigned char*) Ecmd.bin[1].base;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 static_data = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!static_data) { data =  (unsigned char *) malloc(Ecmd.bin[0].size); alpha = (unsigned char *) malloc(Ecmd.bin[1].size); memcpy(data,Ecmd.bin[0].base,Ecmd.bin[0].size); memcpy(alpha,Ecmd.bin[1].base,Ecmd.bin[1].size);};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(*width,*height,data,alpha,static_data);
 rt.addBool(Result);
 break;
}
case wxImage_Destroy: { // wxImage::Destroy
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Destroy();
 break;
}
case wxImage_FindFirstUnusedColour: { // wxImage::FindFirstUnusedColour
 unsigned char r;
 unsigned char g;
 unsigned char b;
 char startR=1;
 char startG=0;
 char startB=0;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 startR = (char)*(unsigned int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 startG = (char)*(unsigned int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 startB = (char)*(unsigned int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->FindFirstUnusedColour(&r,&g,&b,startR,startG,startB);
 rt.addBool(Result);
 rt.addUint(r);
 rt.addUint(g);
 rt.addUint(b);
 rt.addTupleCount(4);
 break;
}
case wxImage_GetImageExtWildcard: { // wxImage::GetImageExtWildcard
 wxString Result = wxImage::GetImageExtWildcard();
 rt.add(Result);
 break;
}
case wxImage_GetAlpha_2: { // wxImage::GetAlpha
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 char Result = This->GetAlpha(*x,*y);
 rt.addUint(Result);
 break;
}
case wxImage_GetAlpha_0: { // wxImage::GetAlpha
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 char * Result = (char*)This->GetAlpha();
 if(Result) {
    rt.addBinary(Result, (This->GetWidth()*This->GetHeight()));
 } else {rt.addAtom("null");};
 break;
}
case wxImage_GetBlue: { // wxImage::GetBlue
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 char Result = This->GetBlue(*x,*y);
 rt.addUint(Result);
 break;
}
case wxImage_GetData: { // wxImage::GetData
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 char * Result = (char*)This->GetData();
 if(Result) {
    rt.addBinary(Result, (This->GetWidth()*This->GetHeight()*3));
 } else {rt.addAtom("null");};
 break;
}
case wxImage_GetGreen: { // wxImage::GetGreen
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 char Result = This->GetGreen(*x,*y);
 rt.addUint(Result);
 break;
}
case wxImage_GetImageCount: { // wxImage::GetImageCount
 wxBitmapType type=wxBITMAP_TYPE_ANY;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
type = *(wxBitmapType *) bp; bp += 4;;
  } break;
 }};
 int Result = wxImage::GetImageCount(name,type);
 rt.addInt(Result);
 break;
}
case wxImage_GetHeight: { // wxImage::GetHeight
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetHeight();
 rt.addInt(Result);
 break;
}
case wxImage_GetMaskBlue: { // wxImage::GetMaskBlue
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 char Result = This->GetMaskBlue();
 rt.addUint(Result);
 break;
}
case wxImage_GetMaskGreen: { // wxImage::GetMaskGreen
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 char Result = This->GetMaskGreen();
 rt.addUint(Result);
 break;
}
case wxImage_GetMaskRed: { // wxImage::GetMaskRed
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 char Result = This->GetMaskRed();
 rt.addUint(Result);
 break;
}
case wxImage_GetOrFindMaskColour: { // wxImage::GetOrFindMaskColour
 unsigned char r;
 unsigned char g;
 unsigned char b;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetOrFindMaskColour(&r,&g,&b);
 rt.addBool(Result);
 rt.addUint(r);
 rt.addUint(g);
 rt.addUint(b);
 rt.addTupleCount(4);
 break;
}
case wxImage_GetPalette: { // wxImage::GetPalette
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxPalette * Result = &This->GetPalette();
 rt.addRef(getRef((void *)Result,memenv), "wxPalette");
 break;
}
case wxImage_GetRed: { // wxImage::GetRed
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 char Result = This->GetRed(*x,*y);
 rt.addUint(Result);
 break;
}
case wxImage_GetSubImage: { // wxImage::GetSubImage
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->GetSubImage(rect)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_GetWidth: { // wxImage::GetWidth
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWidth();
 rt.addInt(Result);
 break;
}
case wxImage_HasAlpha: { // wxImage::HasAlpha
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasAlpha();
 rt.addBool(Result);
 break;
}
case wxImage_HasMask: { // wxImage::HasMask
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasMask();
 rt.addBool(Result);
 break;
}
case wxImage_GetOption: { // wxImage::GetOption
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetOption(name);
 rt.add(Result);
 break;
}
case wxImage_GetOptionInt: { // wxImage::GetOptionInt
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 int Result = This->GetOptionInt(name);
 rt.addInt(Result);
 break;
}
case wxImage_HasOption: { // wxImage::HasOption
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasOption(name);
 rt.addBool(Result);
 break;
}
case wxImage_InitAlpha: { // wxImage::InitAlpha
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->InitAlpha();
 break;
}
case wxImage_InitStandardHandlers: { // wxImage::InitStandardHandlers
 wxImage::InitStandardHandlers();
 break;
}
case wxImage_IsTransparent: { // wxImage::IsTransparent
 char threshold=wxIMAGE_ALPHA_THRESHOLD;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 threshold = (char)*(unsigned int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsTransparent(*x,*y,threshold);
 rt.addBool(Result);
 break;
}
case wxImage_LoadFile_2: { // wxImage::LoadFile
 long type=wxBITMAP_TYPE_ANY;
 int index=-1;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 type = (long)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 index = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->LoadFile(name,type,index);
 rt.addBool(Result);
 break;
}
case wxImage_LoadFile_3: { // wxImage::LoadFile
 int index=-1;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 int * mimetypeLen = (int *) bp; bp += 4;
 wxString mimetype = wxString(bp, wxConvUTF8);
 bp += *mimetypeLen+((8-((4+ *mimetypeLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 index = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->LoadFile(name,mimetype,index);
 rt.addBool(Result);
 break;
}
case wxImage_Ok: { // wxImage::Ok
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Ok();
 rt.addBool(Result);
 break;
}
case wxImage_RemoveHandler: { // wxImage::RemoveHandler
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 bool Result = wxImage::RemoveHandler(name);
 rt.addBool(Result);
 break;
}
case wxImage_Mirror: { // wxImage::Mirror
 bool horizontally=true;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 horizontally = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->Mirror(horizontally)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_Replace: { // wxImage::Replace
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 unsigned int * r1 = (unsigned int *) bp; bp += 4;
 unsigned int * g1 = (unsigned int *) bp; bp += 4;
 unsigned int * b1 = (unsigned int *) bp; bp += 4;
 unsigned int * r2 = (unsigned int *) bp; bp += 4;
 unsigned int * g2 = (unsigned int *) bp; bp += 4;
 unsigned int * b2 = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Replace(*r1,*g1,*b1,*r2,*g2,*b2);
 break;
}
case wxImage_Rescale: { // wxImage::Rescale
 wxImageResizeQuality quality=wxIMAGE_QUALITY_NORMAL;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
quality = *(wxImageResizeQuality *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxImage * Result = &This->Rescale(*width,*height,quality);
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_Resize: { // wxImage::Resize
 int r=-1;
 int g=-1;
 int b=-1;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 r = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 g = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 b = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxImage * Result = &This->Resize(size,pos,r,g,b);
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_Rotate: { // wxImage::Rotate
 bool interpolating=true;
 wxPoint *offset_after_rotation=(wxPoint *) NULL; wxPoint offset_after_rotationTmp;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 double * angle = (double *) bp; bp += 8;
 int * centre_of_rotationX = (int *) bp; bp += 4;
 int * centre_of_rotationY = (int *) bp; bp += 4;
 wxPoint centre_of_rotation = wxPoint(*centre_of_rotationX,*centre_of_rotationY);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 interpolating = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * offset_after_rotationX = (int *) bp; bp += 4;
 int * offset_after_rotationY = (int *) bp; bp += 4;
 offset_after_rotationTmp = wxPoint(*offset_after_rotationX,*offset_after_rotationY); offset_after_rotation = & offset_after_rotationTmp;
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->Rotate(*angle,centre_of_rotation,interpolating,offset_after_rotation)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_RotateHue: { // wxImage::RotateHue
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 double * angle = (double *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->RotateHue(*angle);
 break;
}
case wxImage_Rotate90: { // wxImage::Rotate90
 bool clockwise=true;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 clockwise = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->Rotate90(clockwise)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_SaveFile_1: { // wxImage::SaveFile
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SaveFile(name);
 rt.addBool(Result);
 break;
}
case wxImage_SaveFile_2_0: { // wxImage::SaveFile
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 int * type = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SaveFile(name,*type);
 rt.addBool(Result);
 break;
}
case wxImage_SaveFile_2_1: { // wxImage::SaveFile
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 int * mimetypeLen = (int *) bp; bp += 4;
 wxString mimetype = wxString(bp, wxConvUTF8);
 bp += *mimetypeLen+((8-((4+ *mimetypeLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SaveFile(name,mimetype);
 rt.addBool(Result);
 break;
}
case wxImage_Scale: { // wxImage::Scale
 wxImageResizeQuality quality=wxIMAGE_QUALITY_NORMAL;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
quality = *(wxImageResizeQuality *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->Scale(*width,*height,quality)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_Size: { // wxImage::Size
 int r=-1;
 int g=-1;
 int b=-1;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 r = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 g = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 b = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxImage * Result = new EwxImage(This->Size(size,pos,r,g,b)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxImage");
 break;
}
case wxImage_SetAlpha_3: { // wxImage::SetAlpha
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 unsigned int * alpha = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAlpha(*x,*y,*alpha);
 break;
}
case wxImage_SetAlpha_2: { // wxImage::SetAlpha
 bool static_data=false;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 unsigned char * alpha = (unsigned char*) Ecmd.bin[0].base;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 static_data = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!static_data) {alpha = (unsigned char *) malloc(Ecmd.bin[0].size);memcpy(alpha,Ecmd.bin[0].base,Ecmd.bin[0].size);};
 if(!This) throw wxe_badarg(0);
 This->SetAlpha(alpha,static_data);
 break;
}
case wxImage_SetData_2: { // wxImage::SetData
 bool static_data=false;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 unsigned char * data = (unsigned char*) Ecmd.bin[0].base;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 static_data = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!static_data) {data = (unsigned char *) malloc(Ecmd.bin[0].size);memcpy(data,Ecmd.bin[0].base,Ecmd.bin[0].size);};
 if(!This) throw wxe_badarg(0);
 This->SetData(data,static_data);
 break;
}
case wxImage_SetData_4: { // wxImage::SetData
 bool static_data=false;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 unsigned char * data = (unsigned char*) Ecmd.bin[0].base;
 int * new_width = (int *) bp; bp += 4;
 int * new_height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 static_data = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!static_data) {data = (unsigned char *) malloc(Ecmd.bin[0].size);memcpy(data,Ecmd.bin[0].base,Ecmd.bin[0].size);};
 if(!This) throw wxe_badarg(0);
 This->SetData(data,*new_width,*new_height,static_data);
 break;
}
case wxImage_SetMask: { // wxImage::SetMask
 bool mask=true;
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 mask = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetMask(mask);
 break;
}
case wxImage_SetMaskColour: { // wxImage::SetMaskColour
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 unsigned int * r = (unsigned int *) bp; bp += 4;
 unsigned int * g = (unsigned int *) bp; bp += 4;
 unsigned int * b = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMaskColour(*r,*g,*b);
 break;
}
case wxImage_SetMaskFromImage: { // wxImage::SetMaskFromImage
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 wxImage *mask = (wxImage *) getPtr(bp,memenv); bp += 4;
 unsigned int * mr = (unsigned int *) bp; bp += 4;
 unsigned int * mg = (unsigned int *) bp; bp += 4;
 unsigned int * mb = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetMaskFromImage(*mask,*mr,*mg,*mb);
 rt.addBool(Result);
 break;
}
case wxImage_SetOption_2_1: { // wxImage::SetOption
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 int * valueLen = (int *) bp; bp += 4;
 wxString value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((4+ *valueLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetOption(name,value);
 break;
}
case wxImage_SetOption_2_0: { // wxImage::SetOption
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 int * value = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetOption(name,*value);
 break;
}
case wxImage_SetPalette: { // wxImage::SetPalette
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 wxPalette *palette = (wxPalette *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPalette(*palette);
 break;
}
case wxImage_SetRGB_5: { // wxImage::SetRGB
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 unsigned int * r = (unsigned int *) bp; bp += 4;
 unsigned int * g = (unsigned int *) bp; bp += 4;
 unsigned int * b = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRGB(*x,*y,*r,*g,*b);
 break;
}
case wxImage_SetRGB_4: { // wxImage::SetRGB
 wxImage *This = (wxImage *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 unsigned int * r = (unsigned int *) bp; bp += 4;
 unsigned int * g = (unsigned int *) bp; bp += 4;
 unsigned int * b = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRGB(rect,*r,*g,*b);
 break;
}
case wxBrush_new_0: { // wxBrush::wxBrush
 wxBrush * Result = new EwxBrush();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBrush");
 break;
}
case wxBrush_new_2: { // wxBrush::wxBrush
 int style=wxSOLID;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxBrush * Result = new EwxBrush(colour,style);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBrush");
 break;
}
case wxBrush_new_1: { // wxBrush::wxBrush
 wxBitmap *stippleBitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxBrush * Result = new EwxBrush(*stippleBitmap);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBrush");
 break;
}
case wxBrush_GetColour: { // wxBrush::GetColour
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetColour();
 rt.add(Result);
 break;
}
case wxBrush_GetStipple: { // wxBrush::GetStipple
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxBitmap * Result = (wxBitmap*)This->GetStipple();
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBrush_GetStyle: { // wxBrush::GetStyle
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetStyle();
 rt.addInt(Result);
 break;
}
case wxBrush_IsHatch: { // wxBrush::IsHatch
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsHatch();
 rt.addBool(Result);
 break;
}
case wxBrush_IsOk: { // wxBrush::IsOk
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxBrush_SetColour_1: { // wxBrush::SetColour
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetColour(col);
 break;
}
case wxBrush_SetColour_3: { // wxBrush::SetColour
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 unsigned int * r = (unsigned int *) bp; bp += 4;
 unsigned int * g = (unsigned int *) bp; bp += 4;
 unsigned int * b = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColour(*r,*g,*b);
 break;
}
case wxBrush_SetStipple: { // wxBrush::SetStipple
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 wxBitmap *stipple = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStipple(*stipple);
 break;
}
case wxBrush_SetStyle: { // wxBrush::SetStyle
 wxBrush *This = (wxBrush *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStyle(*style);
 break;
}
case wxPen_new_0: { // wxPen::wxPen
 wxPen * Result = new EwxPen();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPen");
 break;
}
case wxPen_new_2: { // wxPen::wxPen
 int width=1;
 int style=wxSOLID;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 width = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxPen * Result = new EwxPen(colour,width,style);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPen");
 break;
}
case wxPen_GetCap: { // wxPen::GetCap
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCap();
 rt.addInt(Result);
 break;
}
case wxPen_GetColour: { // wxPen::GetColour
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetColour();
 rt.add(Result);
 break;
}
case wxPen_GetJoin: { // wxPen::GetJoin
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetJoin();
 rt.addInt(Result);
 break;
}
case wxPen_GetStyle: { // wxPen::GetStyle
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetStyle();
 rt.addInt(Result);
 break;
}
case wxPen_GetWidth: { // wxPen::GetWidth
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWidth();
 rt.addInt(Result);
 break;
}
case wxPen_IsOk: { // wxPen::IsOk
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxPen_SetCap: { // wxPen::SetCap
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 wxPenCap capStyle = *(wxPenCap *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetCap(capStyle);
 break;
}
case wxPen_SetColour_1: { // wxPen::SetColour
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetColour(colour);
 break;
}
case wxPen_SetColour_3: { // wxPen::SetColour
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 unsigned int * red = (unsigned int *) bp; bp += 4;
 unsigned int * green = (unsigned int *) bp; bp += 4;
 unsigned int * blue = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColour(*red,*green,*blue);
 break;
}
case wxPen_SetJoin: { // wxPen::SetJoin
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 wxPenJoin joinStyle = *(wxPenJoin *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetJoin(joinStyle);
 break;
}
case wxPen_SetStyle: { // wxPen::SetStyle
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStyle(*style);
 break;
}
case wxPen_SetWidth: { // wxPen::SetWidth
 wxPen *This = (wxPen *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWidth(*width);
 break;
}
case wxRegion_new_0: { // wxRegion::wxRegion
 wxRegion * Result = new EwxRegion();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxRegion");
 break;
}
case wxRegion_new_4: { // wxRegion::wxRegion
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * w = (int *) bp; bp += 4;
 int * h = (int *) bp; bp += 4;
 wxRegion * Result = new EwxRegion(*x,*y,*w,*h);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxRegion");
 break;
}
case wxRegion_new_2: { // wxRegion::wxRegion
 int * topLeftX = (int *) bp; bp += 4;
 int * topLeftY = (int *) bp; bp += 4;
 wxPoint topLeft = wxPoint(*topLeftX,*topLeftY);
 int * bottomRightX = (int *) bp; bp += 4;
 int * bottomRightY = (int *) bp; bp += 4;
 wxPoint bottomRight = wxPoint(*bottomRightX,*bottomRightY);
 wxRegion * Result = new EwxRegion(topLeft,bottomRight);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxRegion");
 break;
}
case wxRegion_new_1_1: { // wxRegion::wxRegion
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 wxRegion * Result = new EwxRegion(rect);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxRegion");
 break;
}
case wxRegion_new_1_0: { // wxRegion::wxRegion
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxRegion * Result = new EwxRegion(*bmp);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxRegion");
 break;
}
case wxRegion_Clear: { // wxRegion::Clear
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Clear();
 break;
}
case wxRegion_Contains_2: { // wxRegion::Contains
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->Contains(*x,*y);
 rt.addInt(Result);
 break;
}
case wxRegion_Contains_1_0: { // wxRegion::Contains
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 int Result = This->Contains(pt);
 rt.addInt(Result);
 break;
}
case wxRegion_Contains_4: { // wxRegion::Contains
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * w = (int *) bp; bp += 4;
 int * h = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->Contains(*x,*y,*w,*h);
 rt.addInt(Result);
 break;
}
case wxRegion_Contains_1_1: { // wxRegion::Contains
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 int Result = This->Contains(rect);
 rt.addInt(Result);
 break;
}
case wxRegion_ConvertToBitmap: { // wxRegion::ConvertToBitmap
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxBitmap * Result = new EwxBitmap(This->ConvertToBitmap()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxRegion_GetBox: { // wxRegion::GetBox
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetBox();
 rt.add(Result);
 break;
}
case wxRegion_Intersect_4: { // wxRegion::Intersect
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * w = (int *) bp; bp += 4;
 int * h = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Intersect(*x,*y,*w,*h);
 rt.addBool(Result);
 break;
}
case wxRegion_Intersect_1_1: { // wxRegion::Intersect
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Intersect(rect);
 rt.addBool(Result);
 break;
}
case wxRegion_Intersect_1_0: { // wxRegion::Intersect
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 wxRegion *region = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Intersect(*region);
 rt.addBool(Result);
 break;
}
case wxRegion_IsEmpty: { // wxRegion::IsEmpty
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEmpty();
 rt.addBool(Result);
 break;
}
case wxRegion_Subtract_4: { // wxRegion::Subtract
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * w = (int *) bp; bp += 4;
 int * h = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Subtract(*x,*y,*w,*h);
 rt.addBool(Result);
 break;
}
case wxRegion_Subtract_1_1: { // wxRegion::Subtract
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Subtract(rect);
 rt.addBool(Result);
 break;
}
case wxRegion_Subtract_1_0: { // wxRegion::Subtract
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 wxRegion *region = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Subtract(*region);
 rt.addBool(Result);
 break;
}
case wxRegion_Offset_2: { // wxRegion::Offset
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Offset(*x,*y);
 rt.addBool(Result);
 break;
}
case wxRegion_Offset_1: { // wxRegion::Offset
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Offset(pt);
 rt.addBool(Result);
 break;
}
case wxRegion_Union_4: { // wxRegion::Union
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * w = (int *) bp; bp += 4;
 int * h = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Union(*x,*y,*w,*h);
 rt.addBool(Result);
 break;
}
case wxRegion_Union_1_2: { // wxRegion::Union
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Union(rect);
 rt.addBool(Result);
 break;
}
case wxRegion_Union_1_1: { // wxRegion::Union
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 wxRegion * region = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Union(*region);
 rt.addBool(Result);
 break;
}
case wxRegion_Union_1_0: { // wxRegion::Union
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Union(*bmp);
 rt.addBool(Result);
 break;
}
case wxRegion_Union_3: { // wxRegion::Union
 int tolerance=0;
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * transpR = (int *) bp; bp += 4;
 int * transpG = (int *) bp; bp += 4;
 int * transpB = (int *) bp; bp += 4;
 int * transpA = (int *) bp; bp += 4;
 wxColour transp = wxColour(*transpR,*transpG,*transpB,*transpA);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 tolerance = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Union(*bmp,transp,tolerance);
 rt.addBool(Result);
 break;
}
case wxRegion_Xor_4: { // wxRegion::Xor
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * w = (int *) bp; bp += 4;
 int * h = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Xor(*x,*y,*w,*h);
 rt.addBool(Result);
 break;
}
case wxRegion_Xor_1_1: { // wxRegion::Xor
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Xor(rect);
 rt.addBool(Result);
 break;
}
case wxRegion_Xor_1_0: { // wxRegion::Xor
 wxRegion *This = (wxRegion *) getPtr(bp,memenv); bp += 4;
 wxRegion *region = (wxRegion *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Xor(*region);
 rt.addBool(Result);
 break;
}
case wxAcceleratorTable_new_0: { // wxAcceleratorTable::wxAcceleratorTable
 wxAcceleratorTable * Result = new EwxAcceleratorTable();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAcceleratorTable");
 break;
}
case wxAcceleratorTable_new_2: { // wxAcceleratorTable::wxAcceleratorTable
 int * n = (int *) bp; bp += 4;
 int * entriesLen = (int *) bp; bp += 4;
 wxAcceleratorEntry *entries;
 entries = (wxAcceleratorEntry *) driver_alloc(sizeof(wxAcceleratorEntry) * *entriesLen); for(int i=0; i < *entriesLen; i++) { entries[i] = * (wxAcceleratorEntry *) getPtr(bp,memenv); bp += 4;}
 bp += ((0+ *entriesLen)%2 )*4;
 wxAcceleratorTable * Result = new EwxAcceleratorTable(*n,entries);
 newPtr((void *) Result, 1, memenv);
 driver_free(entries);
 rt.addRef(getRef((void *)Result,memenv), "wxAcceleratorTable");
 break;
}
case wxAcceleratorTable_Ok: { // wxAcceleratorTable::Ok
 wxAcceleratorTable *This = (wxAcceleratorTable *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Ok();
 rt.addBool(Result);
 break;
}
case wxAcceleratorEntry_new_1_0: { // wxAcceleratorEntry::wxAcceleratorEntry
 int flags=0;
 int keyCode=0;
 int cmd=0;
 wxMenuItem * item=NULL;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 keyCode = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 cmd = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
item = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxAcceleratorEntry * Result = new wxAcceleratorEntry(flags,keyCode,cmd,item);
 newPtr((void *) Result, 69, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAcceleratorEntry");
 break;
}
case wxAcceleratorEntry_new_1_1: { // wxAcceleratorEntry::wxAcceleratorEntry
 wxAcceleratorEntry *entry = (wxAcceleratorEntry *) getPtr(bp,memenv); bp += 4;
 wxAcceleratorEntry * Result = new wxAcceleratorEntry(*entry);
 newPtr((void *) Result, 69, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAcceleratorEntry");
 break;
}
case wxAcceleratorEntry_GetCommand: { // wxAcceleratorEntry::GetCommand
 wxAcceleratorEntry *This = (wxAcceleratorEntry *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCommand();
 rt.addInt(Result);
 break;
}
case wxAcceleratorEntry_GetFlags: { // wxAcceleratorEntry::GetFlags
 wxAcceleratorEntry *This = (wxAcceleratorEntry *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFlags();
 rt.addInt(Result);
 break;
}
case wxAcceleratorEntry_GetKeyCode: { // wxAcceleratorEntry::GetKeyCode
 wxAcceleratorEntry *This = (wxAcceleratorEntry *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetKeyCode();
 rt.addInt(Result);
 break;
}
case wxAcceleratorEntry_Set: { // wxAcceleratorEntry::Set
 wxMenuItem * item=NULL;
 wxAcceleratorEntry *This = (wxAcceleratorEntry *) getPtr(bp,memenv); bp += 4;
 int * flags = (int *) bp; bp += 4;
 int * keyCode = (int *) bp; bp += 4;
 int * cmd = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
item = (wxMenuItem *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Set(*flags,*keyCode,*cmd,item);
 break;
}
case wxAcceleratorEntry_destroy: { // wxAcceleratorEntry::destroy
 wxAcceleratorEntry *This = (wxAcceleratorEntry *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxCaret_new_3: { // wxCaret::wxCaret
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 wxCaret * Result = new EwxCaret(window,*width,*height);
 newPtr((void *) Result, 70, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCaret");
 break;
}
case wxCaret_new_2: { // wxCaret::wxCaret
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 wxCaret * Result = new EwxCaret(window,size);
 newPtr((void *) Result, 70, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCaret");
 break;
}
case wxCaret_destruct: { // wxCaret::~wxCaret
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxCaret_Create_3: { // wxCaret::Create
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(window,*width,*height);
 rt.addBool(Result);
 break;
}
case wxCaret_Create_2: { // wxCaret::Create
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(window,size);
 rt.addBool(Result);
 break;
}
case wxCaret_GetBlinkTime: { // wxCaret::GetBlinkTime
 int Result = wxCaret::GetBlinkTime();
 rt.addInt(Result);
 break;
}
case wxCaret_GetPosition: { // wxCaret::GetPosition
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxCaret_GetSize: { // wxCaret::GetSize
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetSize();
 rt.add(Result);
 break;
}
case wxCaret_GetWindow: { // wxCaret::GetWindow
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxCaret_Hide: { // wxCaret::Hide
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Hide();
 break;
}
case wxCaret_IsOk: { // wxCaret::IsOk
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxCaret_IsVisible: { // wxCaret::IsVisible
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsVisible();
 rt.addBool(Result);
 break;
}
case wxCaret_Move_2: { // wxCaret::Move
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Move(*x,*y);
 break;
}
case wxCaret_Move_1: { // wxCaret::Move
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->Move(pt);
 break;
}
case wxCaret_SetBlinkTime: { // wxCaret::SetBlinkTime
 int * milliseconds = (int *) bp; bp += 4;
 wxCaret::SetBlinkTime(*milliseconds);
 break;
}
case wxCaret_SetSize_2: { // wxCaret::SetSize
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSize(*width,*height);
 break;
}
case wxCaret_SetSize_1: { // wxCaret::SetSize
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetSize(size);
 break;
}
case wxCaret_Show: { // wxCaret::Show
 bool show=true;
 wxCaret *This = (wxCaret *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Show(show);
 break;
}
case wxSizer_Add_2_1: { // wxSizer::Add
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(window,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Add_2_0: { // wxSizer::Add
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(sizer,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Add_3: { // wxSizer::Add
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(*width,*height,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Add_2_3: { // wxSizer::Add
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(window,*flags);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Add_2_2: { // wxSizer::Add
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(sizer,*flags);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_AddSpacer: { // wxSizer::AddSpacer
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * size = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->AddSpacer(*size);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_AddStretchSpacer: { // wxSizer::AddStretchSpacer
 int prop=1;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 prop = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->AddStretchSpacer(prop);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_CalcMin: { // wxSizer::CalcMin
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->CalcMin();
 rt.add(Result);
 break;
}
case wxSizer_Clear: { // wxSizer::Clear
 bool delete_windows=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 delete_windows = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Clear(delete_windows);
 break;
}
case wxSizer_Detach_1_2: { // wxSizer::Detach
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Detach(window);
 rt.addBool(Result);
 break;
}
case wxSizer_Detach_1_1: { // wxSizer::Detach
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Detach(sizer);
 rt.addBool(Result);
 break;
}
case wxSizer_Detach_1_0: { // wxSizer::Detach
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Detach(*index);
 rt.addBool(Result);
 break;
}
case wxSizer_Fit: { // wxSizer::Fit
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->Fit(window);
 rt.add(Result);
 break;
}
case wxSizer_FitInside: { // wxSizer::FitInside
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->FitInside(window);
 break;
}
case wxSizer_GetChildren: { // wxSizer::GetChildren
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItemList Result = This->GetChildren();
 int i=0;
 for(wxSizerItemList::const_iterator it = Result.begin(); it != Result.end(); ++it) {
   wxSizerItem * ResultTmp = *it;
   rt.addRef(getRef((void *)ResultTmp,memenv), "wxSizerItem"); i++;}
 rt.endList(Result.GetCount());
 break;
}
case wxSizer_GetItem_2_1: { // wxSizer::GetItem
 bool recursive=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 recursive = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->GetItem(window,recursive);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_GetItem_2_0: { // wxSizer::GetItem
 bool recursive=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 recursive = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->GetItem(sizer,recursive);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_GetItem_1: { // wxSizer::GetItem
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->GetItem(*index);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_GetSize: { // wxSizer::GetSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetSize();
 rt.add(Result);
 break;
}
case wxSizer_GetPosition: { // wxSizer::GetPosition
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxSizer_GetMinSize: { // wxSizer::GetMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetMinSize();
 rt.add(Result);
 break;
}
case wxSizer_Hide_2_0: { // wxSizer::Hide
 bool recursive=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 recursive = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Hide(sizer,recursive);
 rt.addBool(Result);
 break;
}
case wxSizer_Hide_2_1: { // wxSizer::Hide
 bool recursive=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 recursive = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Hide(window,recursive);
 rt.addBool(Result);
 break;
}
case wxSizer_Hide_1: { // wxSizer::Hide
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Hide(*index);
 rt.addBool(Result);
 break;
}
case wxSizer_Insert_3_1: { // wxSizer::Insert
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Insert(*index,window,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Insert_3_0: { // wxSizer::Insert
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Insert(*index,sizer,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Insert_4: { // wxSizer::Insert
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Insert(*index,*width,*height,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Insert_3_3: { // wxSizer::Insert
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Insert(*index,window,*flags);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Insert_3_2: { // wxSizer::Insert
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Insert(*index,sizer,*flags);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Insert_2: { // wxSizer::Insert
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxSizerItem *item = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Insert(*index,item);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_InsertSpacer: { // wxSizer::InsertSpacer
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * size = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->InsertSpacer(*index,*size);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_InsertStretchSpacer: { // wxSizer::InsertStretchSpacer
 int prop=1;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 prop = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->InsertStretchSpacer(*index,prop);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_IsShown_1_2: { // wxSizer::IsShown
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsShown(window);
 rt.addBool(Result);
 break;
}
case wxSizer_IsShown_1_1: { // wxSizer::IsShown
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsShown(sizer);
 rt.addBool(Result);
 break;
}
case wxSizer_IsShown_1_0: { // wxSizer::IsShown
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsShown(*index);
 rt.addBool(Result);
 break;
}
case wxSizer_Layout: { // wxSizer::Layout
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Layout();
 break;
}
case wxSizer_Prepend_2_1: { // wxSizer::Prepend
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Prepend(window,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Prepend_2_0: { // wxSizer::Prepend
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Prepend(sizer,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Prepend_3: { // wxSizer::Prepend
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Prepend(*width,*height,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Prepend_2_3: { // wxSizer::Prepend
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Prepend(window,*flags);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Prepend_2_2: { // wxSizer::Prepend
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Prepend(sizer,*flags);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_Prepend_1: { // wxSizer::Prepend
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizerItem *item = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Prepend(item);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_PrependSpacer: { // wxSizer::PrependSpacer
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * size = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->PrependSpacer(*size);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_PrependStretchSpacer: { // wxSizer::PrependStretchSpacer
 int prop=1;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 prop = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->PrependStretchSpacer(prop);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizer_RecalcSizes: { // wxSizer::RecalcSizes
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->RecalcSizes();
 break;
}
case wxSizer_Remove_1_1: { // wxSizer::Remove
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Remove(sizer);
 rt.addBool(Result);
 break;
}
case wxSizer_Remove_1_0: { // wxSizer::Remove
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Remove(*index);
 rt.addBool(Result);
 break;
}
case wxSizer_Replace_3_1: { // wxSizer::Replace
 bool recursive=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * oldwin = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxWindow * newwin = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 recursive = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Replace(oldwin,newwin,recursive);
 rt.addBool(Result);
 break;
}
case wxSizer_Replace_3_0: { // wxSizer::Replace
 bool recursive=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *oldsz = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *newsz = (wxSizer *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 recursive = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Replace(oldsz,newsz,recursive);
 rt.addBool(Result);
 break;
}
case wxSizer_Replace_2: { // wxSizer::Replace
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxSizerItem *newitem = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Replace(*index,newitem);
 rt.addBool(Result);
 break;
}
case wxSizer_SetDimension: { // wxSizer::SetDimension
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDimension(*x,*y,*width,*height);
 break;
}
case wxSizer_SetMinSize_2: { // wxSizer::SetMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMinSize(*width,*height);
 break;
}
case wxSizer_SetMinSize_1: { // wxSizer::SetMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetMinSize(size);
 break;
}
case wxSizer_SetItemMinSize_3_2: { // wxSizer::SetItemMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemMinSize(window,*width,*height);
 rt.addBool(Result);
 break;
}
case wxSizer_SetItemMinSize_2_2: { // wxSizer::SetItemMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemMinSize(window,size);
 rt.addBool(Result);
 break;
}
case wxSizer_SetItemMinSize_3_1: { // wxSizer::SetItemMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemMinSize(sizer,*width,*height);
 rt.addBool(Result);
 break;
}
case wxSizer_SetItemMinSize_2_1: { // wxSizer::SetItemMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemMinSize(sizer,size);
 rt.addBool(Result);
 break;
}
case wxSizer_SetItemMinSize_3_0: { // wxSizer::SetItemMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemMinSize(*index,*width,*height);
 rt.addBool(Result);
 break;
}
case wxSizer_SetItemMinSize_2_0: { // wxSizer::SetItemMinSize
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemMinSize(*index,size);
 rt.addBool(Result);
 break;
}
case wxSizer_SetSizeHints: { // wxSizer::SetSizeHints
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSizeHints(window);
 break;
}
case wxSizer_SetVirtualSizeHints: { // wxSizer::SetVirtualSizeHints
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetVirtualSizeHints(window);
 break;
}
case wxSizer_Show_2_2: { // wxSizer::Show
 bool show=true;
 bool recursive=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 recursive = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Show(window,show,recursive);
 rt.addBool(Result);
 break;
}
case wxSizer_Show_2_1: { // wxSizer::Show
 bool show=true;
 bool recursive=false;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 recursive = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Show(sizer,show,recursive);
 rt.addBool(Result);
 break;
}
case wxSizer_Show_2_0: { // wxSizer::Show
 bool show=true;
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Show(*index,show);
 rt.addBool(Result);
 break;
}
case wxSizer_Show_1: { // wxSizer::Show
 wxSizer *This = (wxSizer *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Show(*show);
 break;
}
case wxSizerFlags_new: { // wxSizerFlags::wxSizerFlags
 int proportion=0;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxSizerFlags * Result = new wxSizerFlags(proportion);
 newPtr((void *) Result, 72, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Align: { // wxSizerFlags::Align
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 int * alignment = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Align(*alignment);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Border_2: { // wxSizerFlags::Border
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 int * direction = (int *) bp; bp += 4;
 int * borderInPixels = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Border(*direction,*borderInPixels);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Border_1: { // wxSizerFlags::Border
 int direction=wxALL;
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 direction = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Border(direction);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Center: { // wxSizerFlags::Center
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Center();
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Centre: { // wxSizerFlags::Centre
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Centre();
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Expand: { // wxSizerFlags::Expand
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Expand();
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Left: { // wxSizerFlags::Left
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Left();
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Proportion: { // wxSizerFlags::Proportion
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 int * proportion = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Proportion(*proportion);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_Right: { // wxSizerFlags::Right
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerFlags * Result = &This->Right();
 rt.addRef(getRef((void *)Result,memenv), "wxSizerFlags");
 break;
}
case wxSizerFlags_destroy: { // wxSizerFlags::destroy
 wxSizerFlags *This = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxSizerItem_new_5_1: { // wxSizerItem::wxSizerItem
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * proportion = (int *) bp; bp += 4;
 int * flag = (int *) bp; bp += 4;
 int * border = (int *) bp; bp += 4;
 wxObject *userData = (wxObject *) getPtr(bp,memenv); bp += 4;
 wxSizerItem * Result = new EwxSizerItem(window,*proportion,*flag,*border,userData);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizerItem_new_2_1: { // wxSizerItem::wxSizerItem
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 wxSizerItem * Result = new EwxSizerItem(window,*flags);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizerItem_new_5_0: { // wxSizerItem::wxSizerItem
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * proportion = (int *) bp; bp += 4;
 int * flag = (int *) bp; bp += 4;
 int * border = (int *) bp; bp += 4;
 wxObject *userData = (wxObject *) getPtr(bp,memenv); bp += 4;
 wxSizerItem * Result = new EwxSizerItem(sizer,*proportion,*flag,*border,userData);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizerItem_new_2_0: { // wxSizerItem::wxSizerItem
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 wxSizerItem * Result = new EwxSizerItem(sizer,*flags);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizerItem_new_6: { // wxSizerItem::wxSizerItem
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 int * proportion = (int *) bp; bp += 4;
 int * flag = (int *) bp; bp += 4;
 int * border = (int *) bp; bp += 4;
 wxObject *userData = (wxObject *) getPtr(bp,memenv); bp += 4;
 wxSizerItem * Result = new EwxSizerItem(*width,*height,*proportion,*flag,*border,userData);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizerItem_new_3: { // wxSizerItem::wxSizerItem
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 wxSizerFlags *flags = (wxSizerFlags *) getPtr(bp,memenv); bp += 4;
 wxSizerItem * Result = new EwxSizerItem(*width,*height,*flags);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizerItem_new_0: { // wxSizerItem::wxSizerItem
 wxSizerItem * Result = new EwxSizerItem();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxSizerItem_CalcMin: { // wxSizerItem::CalcMin
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->CalcMin();
 rt.add(Result);
 break;
}
case wxSizerItem_DeleteWindows: { // wxSizerItem::DeleteWindows
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DeleteWindows();
 break;
}
case wxSizerItem_DetachSizer: { // wxSizerItem::DetachSizer
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DetachSizer();
 break;
}
case wxSizerItem_GetBorder: { // wxSizerItem::GetBorder
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetBorder();
 rt.addInt(Result);
 break;
}
case wxSizerItem_GetFlag: { // wxSizerItem::GetFlag
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFlag();
 rt.addInt(Result);
 break;
}
case wxSizerItem_GetMinSize: { // wxSizerItem::GetMinSize
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetMinSize();
 rt.add(Result);
 break;
}
case wxSizerItem_GetPosition: { // wxSizerItem::GetPosition
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxSizerItem_GetProportion: { // wxSizerItem::GetProportion
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetProportion();
 rt.addInt(Result);
 break;
}
case wxSizerItem_GetRatio: { // wxSizerItem::GetRatio
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 float Result = This->GetRatio();
 rt.addFloat(Result);
 break;
}
case wxSizerItem_GetRect: { // wxSizerItem::GetRect
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetRect();
 rt.add(Result);
 break;
}
case wxSizerItem_GetSize: { // wxSizerItem::GetSize
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetSize();
 rt.add(Result);
 break;
}
case wxSizerItem_GetSizer: { // wxSizerItem::GetSizer
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizer * Result = (wxSizer*)This->GetSizer();
 rt.addRef(getRef((void *)Result,memenv), "wxSizer");
 break;
}
case wxSizerItem_GetSpacer: { // wxSizerItem::GetSpacer
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetSpacer();
 rt.add(Result);
 break;
}
case wxSizerItem_GetUserData: { // wxSizerItem::GetUserData
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxObject * Result = (wxObject*)This->GetUserData();
 rt.addRef(getRef((void *)Result,memenv), "wx");
 break;
}
case wxSizerItem_GetWindow: { // wxSizerItem::GetWindow
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxSizerItem_IsSizer: { // wxSizerItem::IsSizer
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSizer();
 rt.addBool(Result);
 break;
}
case wxSizerItem_IsShown: { // wxSizerItem::IsShown
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsShown();
 rt.addBool(Result);
 break;
}
case wxSizerItem_IsSpacer: { // wxSizerItem::IsSpacer
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSpacer();
 rt.addBool(Result);
 break;
}
case wxSizerItem_IsWindow: { // wxSizerItem::IsWindow
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsWindow();
 rt.addBool(Result);
 break;
}
case wxSizerItem_SetBorder: { // wxSizerItem::SetBorder
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * border = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBorder(*border);
 break;
}
case wxSizerItem_SetDimension: { // wxSizerItem::SetDimension
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetDimension(pos,size);
 break;
}
case wxSizerItem_SetFlag: { // wxSizerItem::SetFlag
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * flag = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFlag(*flag);
 break;
}
case wxSizerItem_SetInitSize: { // wxSizerItem::SetInitSize
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetInitSize(*x,*y);
 break;
}
case wxSizerItem_SetMinSize_1: { // wxSizerItem::SetMinSize
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetMinSize(size);
 break;
}
case wxSizerItem_SetMinSize_2: { // wxSizerItem::SetMinSize
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMinSize(*x,*y);
 break;
}
case wxSizerItem_SetProportion: { // wxSizerItem::SetProportion
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * proportion = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetProportion(*proportion);
 break;
}
case wxSizerItem_SetRatio_2: { // wxSizerItem::SetRatio
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRatio(*width,*height);
 break;
}
case wxSizerItem_SetRatio_1_1: { // wxSizerItem::SetRatio
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetRatio(size);
 break;
}
case wxSizerItem_SetRatio_1_0: { // wxSizerItem::SetRatio
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 float * ratio = (float *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRatio(*ratio);
 break;
}
case wxSizerItem_SetSizer: { // wxSizerItem::SetSizer
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSizer(sizer);
 break;
}
case wxSizerItem_SetSpacer_1: { // wxSizerItem::SetSpacer
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetSpacer(size);
 break;
}
case wxSizerItem_SetSpacer_2: { // wxSizerItem::SetSpacer
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSpacer(*width,*height);
 break;
}
case wxSizerItem_SetWindow: { // wxSizerItem::SetWindow
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWindow(window);
 break;
}
case wxSizerItem_Show: { // wxSizerItem::Show
 wxSizerItem *This = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Show(*show);
 break;
}
case wxBoxSizer_new: { // wxBoxSizer::wxBoxSizer
 int * orient = (int *) bp; bp += 4;
 wxBoxSizer * Result = new EwxBoxSizer(*orient);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBoxSizer");
 break;
}
case wxBoxSizer_GetOrientation: { // wxBoxSizer::GetOrientation
 wxBoxSizer *This = (wxBoxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetOrientation();
 rt.addInt(Result);
 break;
}
case wxStaticBoxSizer_new_2: { // wxStaticBoxSizer::wxStaticBoxSizer
 wxStaticBox *box = (wxStaticBox *) getPtr(bp,memenv); bp += 4;
 int * orient = (int *) bp; bp += 4;
 wxStaticBoxSizer * Result = new EwxStaticBoxSizer(box,*orient);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticBoxSizer");
 break;
}
case wxStaticBoxSizer_new_3: { // wxStaticBoxSizer::wxStaticBoxSizer
 wxString label= wxEmptyString;
 int * orient = (int *) bp; bp += 4;
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
  } break;
 }};
 wxStaticBoxSizer * Result = new EwxStaticBoxSizer(*orient,win,label);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticBoxSizer");
 break;
}
case wxStaticBoxSizer_GetStaticBox: { // wxStaticBoxSizer::GetStaticBox
 wxStaticBoxSizer *This = (wxStaticBoxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxStaticBox * Result = (wxStaticBox*)This->GetStaticBox();
 rt.addRef(getRef((void *)Result,memenv), "wxStaticBox");
 break;
}
case wxGridSizer_new_4: { // wxGridSizer::wxGridSizer
 int * rows = (int *) bp; bp += 4;
 int * cols = (int *) bp; bp += 4;
 int * vgap = (int *) bp; bp += 4;
 int * hgap = (int *) bp; bp += 4;
 wxGridSizer * Result = new EwxGridSizer(*rows,*cols,*vgap,*hgap);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridSizer");
 break;
}
case wxGridSizer_new_2: { // wxGridSizer::wxGridSizer
 int vgap=0;
 int hgap=0;
 int * cols = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 vgap = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 hgap = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxGridSizer * Result = new EwxGridSizer(*cols,vgap,hgap);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridSizer");
 break;
}
case wxGridSizer_GetCols: { // wxGridSizer::GetCols
 wxGridSizer *This = (wxGridSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCols();
 rt.addInt(Result);
 break;
}
case wxGridSizer_GetHGap: { // wxGridSizer::GetHGap
 wxGridSizer *This = (wxGridSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetHGap();
 rt.addInt(Result);
 break;
}
case wxGridSizer_GetRows: { // wxGridSizer::GetRows
 wxGridSizer *This = (wxGridSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRows();
 rt.addInt(Result);
 break;
}
case wxGridSizer_GetVGap: { // wxGridSizer::GetVGap
 wxGridSizer *This = (wxGridSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetVGap();
 rt.addInt(Result);
 break;
}
case wxGridSizer_SetCols: { // wxGridSizer::SetCols
 wxGridSizer *This = (wxGridSizer *) getPtr(bp,memenv); bp += 4;
 int * cols = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCols(*cols);
 break;
}
case wxGridSizer_SetHGap: { // wxGridSizer::SetHGap
 wxGridSizer *This = (wxGridSizer *) getPtr(bp,memenv); bp += 4;
 int * gap = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetHGap(*gap);
 break;
}
case wxGridSizer_SetRows: { // wxGridSizer::SetRows
 wxGridSizer *This = (wxGridSizer *) getPtr(bp,memenv); bp += 4;
 int * rows = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRows(*rows);
 break;
}
case wxGridSizer_SetVGap: { // wxGridSizer::SetVGap
 wxGridSizer *This = (wxGridSizer *) getPtr(bp,memenv); bp += 4;
 int * gap = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetVGap(*gap);
 break;
}
case wxFlexGridSizer_new_4: { // wxFlexGridSizer::wxFlexGridSizer
 int * rows = (int *) bp; bp += 4;
 int * cols = (int *) bp; bp += 4;
 int * vgap = (int *) bp; bp += 4;
 int * hgap = (int *) bp; bp += 4;
 wxFlexGridSizer * Result = new EwxFlexGridSizer(*rows,*cols,*vgap,*hgap);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFlexGridSizer");
 break;
}
case wxFlexGridSizer_new_2: { // wxFlexGridSizer::wxFlexGridSizer
 int vgap=0;
 int hgap=0;
 int * cols = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 vgap = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 hgap = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxFlexGridSizer * Result = new EwxFlexGridSizer(*cols,vgap,hgap);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFlexGridSizer");
 break;
}
case wxFlexGridSizer_AddGrowableCol: { // wxFlexGridSizer::AddGrowableCol
 int proportion=0;
 wxFlexGridSizer *This = (wxFlexGridSizer *) getPtr(bp,memenv); bp += 4;
 int * idx = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AddGrowableCol(*idx,proportion);
 break;
}
case wxFlexGridSizer_AddGrowableRow: { // wxFlexGridSizer::AddGrowableRow
 int proportion=0;
 wxFlexGridSizer *This = (wxFlexGridSizer *) getPtr(bp,memenv); bp += 4;
 int * idx = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AddGrowableRow(*idx,proportion);
 break;
}
case wxFlexGridSizer_GetFlexibleDirection: { // wxFlexGridSizer::GetFlexibleDirection
 wxFlexGridSizer *This = (wxFlexGridSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFlexibleDirection();
 rt.addInt(Result);
 break;
}
case wxFlexGridSizer_GetNonFlexibleGrowMode: { // wxFlexGridSizer::GetNonFlexibleGrowMode
 wxFlexGridSizer *This = (wxFlexGridSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetNonFlexibleGrowMode();
 rt.addInt(Result);
 break;
}
case wxFlexGridSizer_RemoveGrowableCol: { // wxFlexGridSizer::RemoveGrowableCol
 wxFlexGridSizer *This = (wxFlexGridSizer *) getPtr(bp,memenv); bp += 4;
 int * idx = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->RemoveGrowableCol(*idx);
 break;
}
case wxFlexGridSizer_RemoveGrowableRow: { // wxFlexGridSizer::RemoveGrowableRow
 wxFlexGridSizer *This = (wxFlexGridSizer *) getPtr(bp,memenv); bp += 4;
 int * idx = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->RemoveGrowableRow(*idx);
 break;
}
case wxFlexGridSizer_SetFlexibleDirection: { // wxFlexGridSizer::SetFlexibleDirection
 wxFlexGridSizer *This = (wxFlexGridSizer *) getPtr(bp,memenv); bp += 4;
 int * direction = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFlexibleDirection(*direction);
 break;
}
case wxFlexGridSizer_SetNonFlexibleGrowMode: { // wxFlexGridSizer::SetNonFlexibleGrowMode
 wxFlexGridSizer *This = (wxFlexGridSizer *) getPtr(bp,memenv); bp += 4;
 wxFlexSizerGrowMode mode = *(wxFlexSizerGrowMode *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetNonFlexibleGrowMode(mode);
 break;
}
case wxGridBagSizer_new: { // wxGridBagSizer::wxGridBagSizer
 int vgap=0;
 int hgap=0;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 vgap = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 hgap = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxGridBagSizer * Result = new EwxGridBagSizer(vgap,hgap);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGridBagSizer");
 break;
}
case wxGridBagSizer_Add_3_2: { // wxGridBagSizer::Add
 wxGBSpan span= wxDefaultSpan;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * posR = (int *) bp; bp += 4;
 int * posC = (int *) bp; bp += 4;
 wxGBPosition pos = wxGBPosition(*posR,*posC);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * spanRS = (int *) bp; bp += 4;
 int * spanCS = (int *) bp; bp += 4;
 span = wxGBSpan(*spanRS,*spanCS);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(window,pos,span,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxGridBagSizer_Add_3_1: { // wxGridBagSizer::Add
 wxGBSpan span= wxDefaultSpan;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * posR = (int *) bp; bp += 4;
 int * posC = (int *) bp; bp += 4;
 wxGBPosition pos = wxGBPosition(*posR,*posC);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * spanRS = (int *) bp; bp += 4;
 int * spanCS = (int *) bp; bp += 4;
 span = wxGBSpan(*spanRS,*spanCS);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(sizer,pos,span,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxGridBagSizer_Add_4: { // wxGridBagSizer::Add
 wxGBSpan span= wxDefaultSpan;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 int * posR = (int *) bp; bp += 4;
 int * posC = (int *) bp; bp += 4;
 wxGBPosition pos = wxGBPosition(*posR,*posC);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * spanRS = (int *) bp; bp += 4;
 int * spanCS = (int *) bp; bp += 4;
 span = wxGBSpan(*spanRS,*spanCS);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(*width,*height,pos,span,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxGridBagSizer_Add_1_0: { // wxGridBagSizer::Add
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxGBSizerItem *item = (wxGBSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(item);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxGridBagSizer_Add_2_1: { // wxGridBagSizer::Add
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(window,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxGridBagSizer_Add_2_0: { // wxGridBagSizer::Add
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(sizer,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxGridBagSizer_Add_3_0: { // wxGridBagSizer::Add
 int proportion=0;
 int flag=0;
 int border=0;
 wxObject * userData=NULL;
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 proportion = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 border = (int)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
userData = (wxObject *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(*width,*height,proportion,flag,border,userData);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxGridBagSizer_Add_1_1: { // wxGridBagSizer::Add
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxSizerItem * item = (wxSizerItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizerItem * Result = (wxSizerItem*)This->Add(item);
 rt.addRef(getRef((void *)Result,memenv), "wxSizerItem");
 break;
}
case wxGridBagSizer_CalcMin: { // wxGridBagSizer::CalcMin
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->CalcMin();
 rt.add(Result);
 break;
}
case wxGridBagSizer_CheckForIntersection_2: { // wxGridBagSizer::CheckForIntersection
 wxGBSizerItem * excludeItem=NULL;
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxGBSizerItem *item = (wxGBSizerItem *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
excludeItem = (wxGBSizerItem *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->CheckForIntersection(item,excludeItem);
 rt.addBool(Result);
 break;
}
case wxGridBagSizer_CheckForIntersection_3: { // wxGridBagSizer::CheckForIntersection
 wxGBSizerItem * excludeItem=NULL;
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * posR = (int *) bp; bp += 4;
 int * posC = (int *) bp; bp += 4;
 wxGBPosition pos = wxGBPosition(*posR,*posC);
 int * spanRS = (int *) bp; bp += 4;
 int * spanCS = (int *) bp; bp += 4;
 wxGBSpan span = wxGBSpan(*spanRS,*spanCS);
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
excludeItem = (wxGBSizerItem *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->CheckForIntersection(pos,span,excludeItem);
 rt.addBool(Result);
 break;
}
case wxGridBagSizer_FindItem_1_1: { // wxGridBagSizer::FindItem
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBSizerItem * Result = (wxGBSizerItem*)This->FindItem(window);
 rt.addRef(getRef((void *)Result,memenv), "wxGBSizerItem");
 break;
}
case wxGridBagSizer_FindItem_1_0: { // wxGridBagSizer::FindItem
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBSizerItem * Result = (wxGBSizerItem*)This->FindItem(sizer);
 rt.addRef(getRef((void *)Result,memenv), "wxGBSizerItem");
 break;
}
case wxGridBagSizer_FindItemAtPoint: { // wxGridBagSizer::FindItemAtPoint
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 wxGBSizerItem * Result = (wxGBSizerItem*)This->FindItemAtPoint(pt);
 rt.addRef(getRef((void *)Result,memenv), "wxGBSizerItem");
 break;
}
case wxGridBagSizer_FindItemAtPosition: { // wxGridBagSizer::FindItemAtPosition
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * posR = (int *) bp; bp += 4;
 int * posC = (int *) bp; bp += 4;
 wxGBPosition pos = wxGBPosition(*posR,*posC);
 if(!This) throw wxe_badarg(0);
 wxGBSizerItem * Result = (wxGBSizerItem*)This->FindItemAtPosition(pos);
 rt.addRef(getRef((void *)Result,memenv), "wxGBSizerItem");
 break;
}
case wxGridBagSizer_FindItemWithData: { // wxGridBagSizer::FindItemWithData
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxObject *userData = (wxObject *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBSizerItem * Result = (wxGBSizerItem*)This->FindItemWithData(userData);
 rt.addRef(getRef((void *)Result,memenv), "wxGBSizerItem");
 break;
}
case wxGridBagSizer_GetCellSize: { // wxGridBagSizer::GetCellSize
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetCellSize(*row,*col);
 rt.add(Result);
 break;
}
case wxGridBagSizer_GetEmptyCellSize: { // wxGridBagSizer::GetEmptyCellSize
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetEmptyCellSize();
 rt.add(Result);
 break;
}
case wxGridBagSizer_GetItemPosition_1_2: { // wxGridBagSizer::GetItemPosition
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBPosition Result = This->GetItemPosition(window);
 rt.add(Result);
 break;
}
case wxGridBagSizer_GetItemPosition_1_1: { // wxGridBagSizer::GetItemPosition
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBPosition Result = This->GetItemPosition(sizer);
 rt.add(Result);
 break;
}
case wxGridBagSizer_GetItemPosition_1_0: { // wxGridBagSizer::GetItemPosition
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBPosition Result = This->GetItemPosition(*index);
 rt.add(Result);
 break;
}
case wxGridBagSizer_GetItemSpan_1_2: { // wxGridBagSizer::GetItemSpan
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBSpan Result = This->GetItemSpan(window);
 rt.add(Result);
 break;
}
case wxGridBagSizer_GetItemSpan_1_1: { // wxGridBagSizer::GetItemSpan
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBSpan Result = This->GetItemSpan(sizer);
 rt.add(Result);
 break;
}
case wxGridBagSizer_GetItemSpan_1_0: { // wxGridBagSizer::GetItemSpan
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGBSpan Result = This->GetItemSpan(*index);
 rt.add(Result);
 break;
}
case wxGridBagSizer_SetEmptyCellSize: { // wxGridBagSizer::SetEmptyCellSize
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 if(!This) throw wxe_badarg(0);
 This->SetEmptyCellSize(sz);
 break;
}
case wxGridBagSizer_SetItemPosition_2_2: { // wxGridBagSizer::SetItemPosition
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * posR = (int *) bp; bp += 4;
 int * posC = (int *) bp; bp += 4;
 wxGBPosition pos = wxGBPosition(*posR,*posC);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemPosition(window,pos);
 rt.addBool(Result);
 break;
}
case wxGridBagSizer_SetItemPosition_2_1: { // wxGridBagSizer::SetItemPosition
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * posR = (int *) bp; bp += 4;
 int * posC = (int *) bp; bp += 4;
 wxGBPosition pos = wxGBPosition(*posR,*posC);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemPosition(sizer,pos);
 rt.addBool(Result);
 break;
}
case wxGridBagSizer_SetItemPosition_2_0: { // wxGridBagSizer::SetItemPosition
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * posR = (int *) bp; bp += 4;
 int * posC = (int *) bp; bp += 4;
 wxGBPosition pos = wxGBPosition(*posR,*posC);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemPosition(*index,pos);
 rt.addBool(Result);
 break;
}
case wxGridBagSizer_SetItemSpan_2_2: { // wxGridBagSizer::SetItemSpan
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxWindow * window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * spanRS = (int *) bp; bp += 4;
 int * spanCS = (int *) bp; bp += 4;
 wxGBSpan span = wxGBSpan(*spanRS,*spanCS);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemSpan(window,span);
 rt.addBool(Result);
 break;
}
case wxGridBagSizer_SetItemSpan_2_1: { // wxGridBagSizer::SetItemSpan
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 wxSizer *sizer = (wxSizer *) getPtr(bp,memenv); bp += 4;
 int * spanRS = (int *) bp; bp += 4;
 int * spanCS = (int *) bp; bp += 4;
 wxGBSpan span = wxGBSpan(*spanRS,*spanCS);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemSpan(sizer,span);
 rt.addBool(Result);
 break;
}
case wxGridBagSizer_SetItemSpan_2_0: { // wxGridBagSizer::SetItemSpan
 wxGridBagSizer *This = (wxGridBagSizer *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * spanRS = (int *) bp; bp += 4;
 int * spanCS = (int *) bp; bp += 4;
 wxGBSpan span = wxGBSpan(*spanRS,*spanCS);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemSpan(*index,span);
 rt.addBool(Result);
 break;
}
case wxStdDialogButtonSizer_new: { // wxStdDialogButtonSizer::wxStdDialogButtonSizer
 wxStdDialogButtonSizer * Result = new EwxStdDialogButtonSizer();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStdDialogButtonSizer");
 break;
}
case wxStdDialogButtonSizer_AddButton: { // wxStdDialogButtonSizer::AddButton
 wxStdDialogButtonSizer *This = (wxStdDialogButtonSizer *) getPtr(bp,memenv); bp += 4;
 wxButton *button = (wxButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AddButton(button);
 break;
}
case wxStdDialogButtonSizer_Realize: { // wxStdDialogButtonSizer::Realize
 wxStdDialogButtonSizer *This = (wxStdDialogButtonSizer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Realize();
 break;
}
case wxStdDialogButtonSizer_SetAffirmativeButton: { // wxStdDialogButtonSizer::SetAffirmativeButton
 wxStdDialogButtonSizer *This = (wxStdDialogButtonSizer *) getPtr(bp,memenv); bp += 4;
 wxButton *button = (wxButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAffirmativeButton(button);
 break;
}
case wxStdDialogButtonSizer_SetCancelButton: { // wxStdDialogButtonSizer::SetCancelButton
 wxStdDialogButtonSizer *This = (wxStdDialogButtonSizer *) getPtr(bp,memenv); bp += 4;
 wxButton *button = (wxButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCancelButton(button);
 break;
}
case wxStdDialogButtonSizer_SetNegativeButton: { // wxStdDialogButtonSizer::SetNegativeButton
 wxStdDialogButtonSizer *This = (wxStdDialogButtonSizer *) getPtr(bp,memenv); bp += 4;
 wxButton *button = (wxButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetNegativeButton(button);
 break;
}
case wxFont_new_0: { // wxFont::wxFont
 wxFont * Result = new EwxFont();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxFont_new_1: { // wxFont::wxFont
 int * fontnameLen = (int *) bp; bp += 4;
 wxString fontname = wxString(bp, wxConvUTF8);
 bp += *fontnameLen+((8-((4+ *fontnameLen) & 7)) & 7);
 wxFont * Result = new EwxFont(fontname);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxFont_new_5: { // wxFont::wxFont
 bool underlined=false;
 wxString face= wxEmptyString;
 wxFontEncoding encoding=wxFONTENCODING_DEFAULT;
 int * size = (int *) bp; bp += 4;
 wxFontFamily family = *(wxFontFamily *) bp; bp += 4;;
 wxFontStyle style = *(wxFontStyle *) bp; bp += 4;;
 int * weight = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 underlined = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * faceLen = (int *) bp; bp += 4;
 face = wxString(bp, wxConvUTF8);
 bp += *faceLen+((8-((0+ *faceLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
encoding = *(wxFontEncoding *) bp; bp += 4;;
  } break;
 }};
 wxFont * Result = new EwxFont(*size,family,style,*weight,underlined,face,encoding);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxFont_IsFixedWidth: { // wxFont::IsFixedWidth
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsFixedWidth();
 rt.addBool(Result);
 break;
}
case wxFont_GetDefaultEncoding: { // wxFont::GetDefaultEncoding
 int Result = wxFont::GetDefaultEncoding();
 rt.addInt(Result);
 break;
}
case wxFont_GetFaceName: { // wxFont::GetFaceName
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetFaceName();
 rt.add(Result);
 break;
}
case wxFont_GetFamily: { // wxFont::GetFamily
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFamily();
 rt.addInt(Result);
 break;
}
case wxFont_GetNativeFontInfoDesc: { // wxFont::GetNativeFontInfoDesc
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetNativeFontInfoDesc();
 rt.add(Result);
 break;
}
case wxFont_GetNativeFontInfoUserDesc: { // wxFont::GetNativeFontInfoUserDesc
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetNativeFontInfoUserDesc();
 rt.add(Result);
 break;
}
case wxFont_GetPointSize: { // wxFont::GetPointSize
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPointSize();
 rt.addInt(Result);
 break;
}
case wxFont_GetStyle: { // wxFont::GetStyle
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetStyle();
 rt.addInt(Result);
 break;
}
case wxFont_GetUnderlined: { // wxFont::GetUnderlined
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetUnderlined();
 rt.addBool(Result);
 break;
}
case wxFont_GetWeight: { // wxFont::GetWeight
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWeight();
 rt.addInt(Result);
 break;
}
case wxFont_Ok: { // wxFont::Ok
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Ok();
 rt.addBool(Result);
 break;
}
case wxFont_SetDefaultEncoding: { // wxFont::SetDefaultEncoding
 wxFontEncoding encoding = *(wxFontEncoding *) bp; bp += 4;;
 wxFont::SetDefaultEncoding(encoding);
 break;
}
case wxFont_SetFaceName: { // wxFont::SetFaceName
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 int * faceNameLen = (int *) bp; bp += 4;
 wxString faceName = wxString(bp, wxConvUTF8);
 bp += *faceNameLen+((8-((0+ *faceNameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetFaceName(faceName);
 rt.addBool(Result);
 break;
}
case wxFont_SetFamily: { // wxFont::SetFamily
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 wxFontFamily family = *(wxFontFamily *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetFamily(family);
 break;
}
case wxFont_SetPointSize: { // wxFont::SetPointSize
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 int * pointSize = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPointSize(*pointSize);
 break;
}
case wxFont_SetStyle: { // wxFont::SetStyle
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 wxFontStyle style = *(wxFontStyle *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetStyle(style);
 break;
}
case wxFont_SetUnderlined: { // wxFont::SetUnderlined
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 bool * underlined = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetUnderlined(*underlined);
 break;
}
case wxFont_SetWeight: { // wxFont::SetWeight
 wxFont *This = (wxFont *) getPtr(bp,memenv); bp += 4;
 int * weight = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWeight(*weight);
 break;
}
case wxToolTip_Enable: { // wxToolTip::Enable
 bool * flag = (bool *) bp; bp += 4;
 wxToolTip::Enable(*flag);
 break;
}
case wxToolTip_SetDelay: { // wxToolTip::SetDelay
 int * msecs = (int *) bp; bp += 4;
 wxToolTip::SetDelay(*msecs);
 break;
}
case wxToolTip_new: { // wxToolTip::wxToolTip
 int * tipLen = (int *) bp; bp += 4;
 wxString tip = wxString(bp, wxConvUTF8);
 bp += *tipLen+((8-((4+ *tipLen) & 7)) & 7);
 wxToolTip * Result = new EwxToolTip(tip);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxToolTip");
 break;
}
case wxToolTip_SetTip: { // wxToolTip::SetTip
 wxToolTip *This = (wxToolTip *) getPtr(bp,memenv); bp += 4;
 int * tipLen = (int *) bp; bp += 4;
 wxString tip = wxString(bp, wxConvUTF8);
 bp += *tipLen+((8-((0+ *tipLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetTip(tip);
 break;
}
case wxToolTip_GetTip: { // wxToolTip::GetTip
 wxToolTip *This = (wxToolTip *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetTip();
 rt.add(Result);
 break;
}
case wxToolTip_GetWindow: { // wxToolTip::GetWindow
 wxToolTip *This = (wxToolTip *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxButton_new_3: { // wxButton::wxButton
 wxString label= wxEmptyString;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxButton * Result = new EwxButton(parent,*id,label,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxButton");
 break;
}
case wxButton_new_0: { // wxButton::wxButton
 wxButton * Result = new EwxButton();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxButton");
 break;
}
case wxButton_Create: { // wxButton::Create
 wxString label= wxEmptyString;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxButton *This = (wxButton *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,label,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxButton_GetDefaultSize: { // wxButton::GetDefaultSize
 wxSize Result = wxButton::GetDefaultSize();
 rt.add(Result);
 break;
}
case wxButton_SetDefault: { // wxButton::SetDefault
 wxButton *This = (wxButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDefault();
 break;
}
case wxButton_SetLabel: { // wxButton::SetLabel
 wxButton *This = (wxButton *) getPtr(bp,memenv); bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetLabel(label);
 break;
}
case wxBitmapButton_new_4: { // wxBitmapButton::wxBitmapButton
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxBU_AUTODRAW;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxBitmapButton * Result = new EwxBitmapButton(parent,*id,*bitmap,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBitmapButton");
 break;
}
case wxBitmapButton_new_0: { // wxBitmapButton::wxBitmapButton
 wxBitmapButton * Result = new EwxBitmapButton();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxBitmapButton");
 break;
}
case wxBitmapButton_Create: { // wxBitmapButton::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxBU_AUTODRAW;
 const wxValidator * validator= &wxDefaultValidator;
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,*bitmap,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxBitmapButton_GetBitmapDisabled: { // wxBitmapButton::GetBitmapDisabled
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxBitmap * Result = new EwxBitmap(This->GetBitmapDisabled()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmapButton_GetBitmapFocus: { // wxBitmapButton::GetBitmapFocus
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxBitmap * Result = new EwxBitmap(This->GetBitmapFocus()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmapButton_GetBitmapLabel: { // wxBitmapButton::GetBitmapLabel
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxBitmap * Result = new EwxBitmap(This->GetBitmapLabel()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmapButton_GetBitmapSelected: { // wxBitmapButton::GetBitmapSelected
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxBitmap * Result = new EwxBitmap(This->GetBitmapSelected()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxBitmapButton_SetBitmapDisabled: { // wxBitmapButton::SetBitmapDisabled
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 wxBitmap *disabled = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBitmapDisabled(*disabled);
 break;
}
case wxBitmapButton_SetBitmapFocus: { // wxBitmapButton::SetBitmapFocus
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 wxBitmap *focus = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBitmapFocus(*focus);
 break;
}
case wxBitmapButton_SetBitmapLabel: { // wxBitmapButton::SetBitmapLabel
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBitmapLabel(*bitmap);
 break;
}
case wxBitmapButton_SetBitmapSelected: { // wxBitmapButton::SetBitmapSelected
 wxBitmapButton *This = (wxBitmapButton *) getPtr(bp,memenv); bp += 4;
 wxBitmap *sel = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBitmapSelected(*sel);
 break;
}
case wxToggleButton_new_0: { // wxToggleButton::wxToggleButton
 wxToggleButton * Result = new EwxToggleButton();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxToggleButton");
 break;
}
case wxToggleButton_new_4: { // wxToggleButton::wxToggleButton
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxToggleButton * Result = new EwxToggleButton(parent,*id,label,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxToggleButton");
 break;
}
case wxToggleButton_Create: { // wxToggleButton::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxToggleButton *This = (wxToggleButton *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,label,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxToggleButton_GetValue: { // wxToggleButton::GetValue
 wxToggleButton *This = (wxToggleButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetValue();
 rt.addBool(Result);
 break;
}
case wxToggleButton_SetValue: { // wxToggleButton::SetValue
 wxToggleButton *This = (wxToggleButton *) getPtr(bp,memenv); bp += 4;
 bool * state = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetValue(*state);
 break;
}
case wxCalendarCtrl_new_0: { // wxCalendarCtrl::wxCalendarCtrl
 wxCalendarCtrl * Result = new EwxCalendarCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCalendarCtrl");
 break;
}
case wxCalendarCtrl_new_3: { // wxCalendarCtrl::wxCalendarCtrl
 wxDateTime date= wxDefaultDateTime;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxCAL_SHOW_HOLIDAYS|wxWANTS_CHARS;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * dateD = (int *) bp; bp += 4;
 int * dateMo = (int *) bp; bp += 4;
 int * dateY = (int *) bp; bp += 4;
 int * dateH = (int *) bp; bp += 4;
 int * dateMi = (int *) bp; bp += 4;
 int * dateS = (int *) bp; bp += 4;
 date = wxDateTime((wxDateTime::wxDateTime_t) *dateD,(wxDateTime::Month) *dateMo,*dateY,(wxDateTime::wxDateTime_t) *dateH,(wxDateTime::wxDateTime_t) *dateMi,(wxDateTime::wxDateTime_t) *dateS);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxCalendarCtrl * Result = new EwxCalendarCtrl(parent,*id,date,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCalendarCtrl");
 break;
}
case wxCalendarCtrl_Create: { // wxCalendarCtrl::Create
 wxDateTime date= wxDefaultDateTime;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxCAL_SHOW_HOLIDAYS|wxWANTS_CHARS;
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * dateD = (int *) bp; bp += 4;
 int * dateMo = (int *) bp; bp += 4;
 int * dateY = (int *) bp; bp += 4;
 int * dateH = (int *) bp; bp += 4;
 int * dateMi = (int *) bp; bp += 4;
 int * dateS = (int *) bp; bp += 4;
 date = wxDateTime((wxDateTime::wxDateTime_t) *dateD,(wxDateTime::Month) *dateMo,*dateY,(wxDateTime::wxDateTime_t) *dateH,(wxDateTime::wxDateTime_t) *dateMi,(wxDateTime::wxDateTime_t) *dateS);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,date,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxCalendarCtrl_SetDate: { // wxCalendarCtrl::SetDate
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * dateD = (int *) bp; bp += 4;
 int * dateMo = (int *) bp; bp += 4;
 int * dateY = (int *) bp; bp += 4;
 int * dateH = (int *) bp; bp += 4;
 int * dateMi = (int *) bp; bp += 4;
 int * dateS = (int *) bp; bp += 4;
 wxDateTime date = wxDateTime((wxDateTime::wxDateTime_t) *dateD,(wxDateTime::Month) *dateMo,*dateY,(wxDateTime::wxDateTime_t) *dateH,(wxDateTime::wxDateTime_t) *dateMi,(wxDateTime::wxDateTime_t) *dateS);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetDate(date);
 rt.addBool(Result);
 break;
}
case wxCalendarCtrl_GetDate: { // wxCalendarCtrl::GetDate
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxDateTime Result = This->GetDate();
 rt.add(Result);
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxCalendarCtrl_EnableYearChange: { // wxCalendarCtrl::EnableYearChange
 bool enable=true;
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->EnableYearChange(enable);
 break;
}
#endif
case wxCalendarCtrl_EnableMonthChange: { // wxCalendarCtrl::EnableMonthChange
 bool enable=true;
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->EnableMonthChange(enable);
 break;
}
case wxCalendarCtrl_EnableHolidayDisplay: { // wxCalendarCtrl::EnableHolidayDisplay
 bool display=true;
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 display = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->EnableHolidayDisplay(display);
 break;
}
case wxCalendarCtrl_SetHeaderColours: { // wxCalendarCtrl::SetHeaderColours
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * colFgR = (int *) bp; bp += 4;
 int * colFgG = (int *) bp; bp += 4;
 int * colFgB = (int *) bp; bp += 4;
 int * colFgA = (int *) bp; bp += 4;
 wxColour colFg = wxColour(*colFgR,*colFgG,*colFgB,*colFgA);
 int * colBgR = (int *) bp; bp += 4;
 int * colBgG = (int *) bp; bp += 4;
 int * colBgB = (int *) bp; bp += 4;
 int * colBgA = (int *) bp; bp += 4;
 wxColour colBg = wxColour(*colBgR,*colBgG,*colBgB,*colBgA);
 if(!This) throw wxe_badarg(0);
 This->SetHeaderColours(colFg,colBg);
 break;
}
case wxCalendarCtrl_GetHeaderColourFg: { // wxCalendarCtrl::GetHeaderColourFg
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetHeaderColourFg();
 rt.add((*Result));
 break;
}
case wxCalendarCtrl_GetHeaderColourBg: { // wxCalendarCtrl::GetHeaderColourBg
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetHeaderColourBg();
 rt.add((*Result));
 break;
}
case wxCalendarCtrl_SetHighlightColours: { // wxCalendarCtrl::SetHighlightColours
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * colFgR = (int *) bp; bp += 4;
 int * colFgG = (int *) bp; bp += 4;
 int * colFgB = (int *) bp; bp += 4;
 int * colFgA = (int *) bp; bp += 4;
 wxColour colFg = wxColour(*colFgR,*colFgG,*colFgB,*colFgA);
 int * colBgR = (int *) bp; bp += 4;
 int * colBgG = (int *) bp; bp += 4;
 int * colBgB = (int *) bp; bp += 4;
 int * colBgA = (int *) bp; bp += 4;
 wxColour colBg = wxColour(*colBgR,*colBgG,*colBgB,*colBgA);
 if(!This) throw wxe_badarg(0);
 This->SetHighlightColours(colFg,colBg);
 break;
}
case wxCalendarCtrl_GetHighlightColourFg: { // wxCalendarCtrl::GetHighlightColourFg
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetHighlightColourFg();
 rt.add((*Result));
 break;
}
case wxCalendarCtrl_GetHighlightColourBg: { // wxCalendarCtrl::GetHighlightColourBg
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetHighlightColourBg();
 rt.add((*Result));
 break;
}
case wxCalendarCtrl_SetHolidayColours: { // wxCalendarCtrl::SetHolidayColours
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * colFgR = (int *) bp; bp += 4;
 int * colFgG = (int *) bp; bp += 4;
 int * colFgB = (int *) bp; bp += 4;
 int * colFgA = (int *) bp; bp += 4;
 wxColour colFg = wxColour(*colFgR,*colFgG,*colFgB,*colFgA);
 int * colBgR = (int *) bp; bp += 4;
 int * colBgG = (int *) bp; bp += 4;
 int * colBgB = (int *) bp; bp += 4;
 int * colBgA = (int *) bp; bp += 4;
 wxColour colBg = wxColour(*colBgR,*colBgG,*colBgB,*colBgA);
 if(!This) throw wxe_badarg(0);
 This->SetHolidayColours(colFg,colBg);
 break;
}
case wxCalendarCtrl_GetHolidayColourFg: { // wxCalendarCtrl::GetHolidayColourFg
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetHolidayColourFg();
 rt.add((*Result));
 break;
}
case wxCalendarCtrl_GetHolidayColourBg: { // wxCalendarCtrl::GetHolidayColourBg
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetHolidayColourBg();
 rt.add((*Result));
 break;
}
case wxCalendarCtrl_GetAttr: { // wxCalendarCtrl::GetAttr
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * day = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCalendarDateAttr * Result = (wxCalendarDateAttr*)This->GetAttr(*day);
 rt.addRef(getRef((void *)Result,memenv), "wxCalendarDateAttr");
 break;
}
case wxCalendarCtrl_SetAttr: { // wxCalendarCtrl::SetAttr
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * day = (int *) bp; bp += 4;
 wxCalendarDateAttr *attr = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAttr(*day,attr);
 break;
}
case wxCalendarCtrl_SetHoliday: { // wxCalendarCtrl::SetHoliday
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * day = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetHoliday(*day);
 break;
}
case wxCalendarCtrl_ResetAttr: { // wxCalendarCtrl::ResetAttr
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * day = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ResetAttr(*day);
 break;
}
case wxCalendarCtrl_HitTest: { // wxCalendarCtrl::HitTest
 wxDateTime date;
 wxDateTime::WeekDay wd;
 wxCalendarCtrl *This = (wxCalendarCtrl *) getPtr(bp,memenv); bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 if(!This) throw wxe_badarg(0);
 int Result = This->HitTest(pos,&date,&wd);
 rt.addInt(Result);
 rt.add(date);
 rt.addInt(wd);
 rt.addTupleCount(3);
 break;
}
case wxCalendarDateAttr_new_0: { // wxCalendarDateAttr::wxCalendarDateAttr
 wxCalendarDateAttr * Result = new wxCalendarDateAttr();
 newPtr((void *) Result, 88, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCalendarDateAttr");
 break;
}
case wxCalendarDateAttr_new_2_1: { // wxCalendarDateAttr::wxCalendarDateAttr
 wxColour colBack= wxNullColour;
 wxColour colBorder= wxNullColour;
 const wxFont * font= &wxNullFont;
 wxCalendarDateBorder border=wxCAL_BORDER_NONE;
 int * colTextR = (int *) bp; bp += 4;
 int * colTextG = (int *) bp; bp += 4;
 int * colTextB = (int *) bp; bp += 4;
 int * colTextA = (int *) bp; bp += 4;
 wxColour colText = wxColour(*colTextR,*colTextG,*colTextB,*colTextA);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * colBackR = (int *) bp; bp += 4;
 int * colBackG = (int *) bp; bp += 4;
 int * colBackB = (int *) bp; bp += 4;
 int * colBackA = (int *) bp; bp += 4;
 colBack = wxColour(*colBackR,*colBackG,*colBackB,*colBackA);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * colBorderR = (int *) bp; bp += 4;
 int * colBorderG = (int *) bp; bp += 4;
 int * colBorderB = (int *) bp; bp += 4;
 int * colBorderA = (int *) bp; bp += 4;
 colBorder = wxColour(*colBorderR,*colBorderG,*colBorderB,*colBorderA);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
font = (wxFont *) getPtr(bp,memenv); bp += 4;
  } break;
  case 4: {bp += 4;
border = *(wxCalendarDateBorder *) bp; bp += 4;;
  } break;
 }};
 wxCalendarDateAttr * Result = new wxCalendarDateAttr(colText,colBack,colBorder,*font,border);
 newPtr((void *) Result, 88, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCalendarDateAttr");
 break;
}
case wxCalendarDateAttr_new_2_0: { // wxCalendarDateAttr::wxCalendarDateAttr
 wxColour colBorder= wxNullColour;
 wxCalendarDateBorder border = *(wxCalendarDateBorder *) bp; bp += 4;;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * colBorderR = (int *) bp; bp += 4;
 int * colBorderG = (int *) bp; bp += 4;
 int * colBorderB = (int *) bp; bp += 4;
 int * colBorderA = (int *) bp; bp += 4;
 colBorder = wxColour(*colBorderR,*colBorderG,*colBorderB,*colBorderA);
 bp += 4; /* Align */
  } break;
 }};
 wxCalendarDateAttr * Result = new wxCalendarDateAttr(border,colBorder);
 newPtr((void *) Result, 88, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCalendarDateAttr");
 break;
}
case wxCalendarDateAttr_SetTextColour: { // wxCalendarDateAttr::SetTextColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 int * colTextR = (int *) bp; bp += 4;
 int * colTextG = (int *) bp; bp += 4;
 int * colTextB = (int *) bp; bp += 4;
 int * colTextA = (int *) bp; bp += 4;
 wxColour colText = wxColour(*colTextR,*colTextG,*colTextB,*colTextA);
 if(!This) throw wxe_badarg(0);
 This->SetTextColour(colText);
 break;
}
case wxCalendarDateAttr_SetBackgroundColour: { // wxCalendarDateAttr::SetBackgroundColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 int * colBackR = (int *) bp; bp += 4;
 int * colBackG = (int *) bp; bp += 4;
 int * colBackB = (int *) bp; bp += 4;
 int * colBackA = (int *) bp; bp += 4;
 wxColour colBack = wxColour(*colBackR,*colBackG,*colBackB,*colBackA);
 if(!This) throw wxe_badarg(0);
 This->SetBackgroundColour(colBack);
 break;
}
case wxCalendarDateAttr_SetBorderColour: { // wxCalendarDateAttr::SetBorderColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetBorderColour(col);
 break;
}
case wxCalendarDateAttr_SetFont: { // wxCalendarDateAttr::SetFont
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFont(*font);
 break;
}
case wxCalendarDateAttr_SetBorder: { // wxCalendarDateAttr::SetBorder
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 wxCalendarDateBorder border = *(wxCalendarDateBorder *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetBorder(border);
 break;
}
case wxCalendarDateAttr_SetHoliday: { // wxCalendarDateAttr::SetHoliday
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 bool * holiday = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetHoliday(*holiday);
 break;
}
case wxCalendarDateAttr_HasTextColour: { // wxCalendarDateAttr::HasTextColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasTextColour();
 rt.addBool(Result);
 break;
}
case wxCalendarDateAttr_HasBackgroundColour: { // wxCalendarDateAttr::HasBackgroundColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasBackgroundColour();
 rt.addBool(Result);
 break;
}
case wxCalendarDateAttr_HasBorderColour: { // wxCalendarDateAttr::HasBorderColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasBorderColour();
 rt.addBool(Result);
 break;
}
case wxCalendarDateAttr_HasFont: { // wxCalendarDateAttr::HasFont
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasFont();
 rt.addBool(Result);
 break;
}
case wxCalendarDateAttr_HasBorder: { // wxCalendarDateAttr::HasBorder
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasBorder();
 rt.addBool(Result);
 break;
}
case wxCalendarDateAttr_IsHoliday: { // wxCalendarDateAttr::IsHoliday
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsHoliday();
 rt.addBool(Result);
 break;
}
case wxCalendarDateAttr_GetTextColour: { // wxCalendarDateAttr::GetTextColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetTextColour();
 rt.add((*Result));
 break;
}
case wxCalendarDateAttr_GetBackgroundColour: { // wxCalendarDateAttr::GetBackgroundColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetBackgroundColour();
 rt.add((*Result));
 break;
}
case wxCalendarDateAttr_GetBorderColour: { // wxCalendarDateAttr::GetBorderColour
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetBorderColour();
 rt.add((*Result));
 break;
}
case wxCalendarDateAttr_GetFont: { // wxCalendarDateAttr::GetFont
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxFont * Result = &This->GetFont();
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxCalendarDateAttr_GetBorder: { // wxCalendarDateAttr::GetBorder
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetBorder();
 rt.addInt(Result);
 break;
}
case wxCalendarDateAttr_destroy: { // wxCalendarDateAttr::destroy
 wxCalendarDateAttr *This = (wxCalendarDateAttr *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxCheckBox_new_4: { // wxCheckBox::wxCheckBox
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxCheckBox * Result = new EwxCheckBox(parent,*id,label,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCheckBox");
 break;
}
case wxCheckBox_new_0: { // wxCheckBox::wxCheckBox
 wxCheckBox * Result = new EwxCheckBox();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCheckBox");
 break;
}
case wxCheckBox_Create: { // wxCheckBox::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxCheckBox *This = (wxCheckBox *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,label,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxCheckBox_GetValue: { // wxCheckBox::GetValue
 wxCheckBox *This = (wxCheckBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetValue();
 rt.addBool(Result);
 break;
}
case wxCheckBox_Get3StateValue: { // wxCheckBox::Get3StateValue
 wxCheckBox *This = (wxCheckBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->Get3StateValue();
 rt.addInt(Result);
 break;
}
case wxCheckBox_Is3rdStateAllowedForUser: { // wxCheckBox::Is3rdStateAllowedForUser
 wxCheckBox *This = (wxCheckBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Is3rdStateAllowedForUser();
 rt.addBool(Result);
 break;
}
case wxCheckBox_Is3State: { // wxCheckBox::Is3State
 wxCheckBox *This = (wxCheckBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Is3State();
 rt.addBool(Result);
 break;
}
case wxCheckBox_IsChecked: { // wxCheckBox::IsChecked
 wxCheckBox *This = (wxCheckBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsChecked();
 rt.addBool(Result);
 break;
}
case wxCheckBox_SetValue: { // wxCheckBox::SetValue
 wxCheckBox *This = (wxCheckBox *) getPtr(bp,memenv); bp += 4;
 bool * state = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetValue(*state);
 break;
}
case wxCheckBox_Set3StateValue: { // wxCheckBox::Set3StateValue
 wxCheckBox *This = (wxCheckBox *) getPtr(bp,memenv); bp += 4;
 wxCheckBoxState state = *(wxCheckBoxState *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->Set3StateValue(state);
 break;
}
case wxCheckListBox_new_0: { // wxCheckListBox::wxCheckListBox
 wxCheckListBox * Result = new EwxCheckListBox();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCheckListBox");
 break;
}
case wxCheckListBox_new_3: { // wxCheckListBox::wxCheckListBox
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 wxArrayString choices;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * choicesLen = (int *) bp; bp += 4;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((0+ choicesASz) & 7 )) & 7;
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxCheckListBox * Result = new EwxCheckListBox(parent,*id,pos,size,choices,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxCheckListBox");
 break;
}
case wxCheckListBox_Check: { // wxCheckListBox::Check
 bool check=true;
 wxCheckListBox *This = (wxCheckListBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * index = (unsigned int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 check = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Check(*index,check);
 break;
}
case wxCheckListBox_IsChecked: { // wxCheckListBox::IsChecked
 wxCheckListBox *This = (wxCheckListBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * index = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsChecked(*index);
 rt.addBool(Result);
 break;
}
case wxChoice_new_3: { // wxChoice::wxChoice
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 wxArrayString choices;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * choicesLen = (int *) bp; bp += 4;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((0+ choicesASz) & 7 )) & 7;
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxChoice * Result = new EwxChoice(parent,*id,pos,size,choices,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxChoice");
 break;
}
case wxChoice_new_0: { // wxChoice::wxChoice
 wxChoice * Result = new EwxChoice();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxChoice");
 break;
}
case wxChoice_Create: { // wxChoice::Create
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxChoice *This = (wxChoice *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 int * choicesLen = (int *) bp; bp += 4;
 wxArrayString choices;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((0+ choicesASz) & 7 )) & 7;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,pos,size,choices,style,*validator);
 rt.addBool(Result);
 break;
}
case wxChoice_Delete: { // wxChoice::Delete
 wxChoice *This = (wxChoice *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Delete(*n);
 break;
}
case wxChoice_GetColumns: { // wxChoice::GetColumns
 wxChoice *This = (wxChoice *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColumns();
 rt.addInt(Result);
 break;
}
case wxChoice_SetColumns: { // wxChoice::SetColumns
 int n=1;
 wxChoice *This = (wxChoice *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 n = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetColumns(n);
 break;
}
case wxComboBox_new_0: { // wxComboBox::wxComboBox
 wxComboBox * Result = new EwxComboBox();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxComboBox");
 break;
}
case wxComboBox_new_3: { // wxComboBox::wxComboBox
 wxString value= wxEmptyString;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 wxArrayString choices;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 int * choicesLen = (int *) bp; bp += 4;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((0+ choicesASz) & 7 )) & 7;
  } break;
  case 5: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 6: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxComboBox * Result = new EwxComboBox(parent,*id,value,pos,size,choices,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxComboBox");
 break;
}
case wxComboBox_Create: { // wxComboBox::Create
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 wxString value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 int * choicesLen = (int *) bp; bp += 4;
 wxArrayString choices;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((4+ choicesASz) & 7 )) & 7;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,value,pos,size,choices,style,*validator);
 rt.addBool(Result);
 break;
}
case wxComboBox_CanCopy: { // wxComboBox::CanCopy
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanCopy();
 rt.addBool(Result);
 break;
}
case wxComboBox_CanCut: { // wxComboBox::CanCut
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanCut();
 rt.addBool(Result);
 break;
}
case wxComboBox_CanPaste: { // wxComboBox::CanPaste
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanPaste();
 rt.addBool(Result);
 break;
}
case wxComboBox_CanRedo: { // wxComboBox::CanRedo
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanRedo();
 rt.addBool(Result);
 break;
}
case wxComboBox_CanUndo: { // wxComboBox::CanUndo
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanUndo();
 rt.addBool(Result);
 break;
}
case wxComboBox_Copy: { // wxComboBox::Copy
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Copy();
 break;
}
case wxComboBox_Cut: { // wxComboBox::Cut
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Cut();
 break;
}
case wxComboBox_GetInsertionPoint: { // wxComboBox::GetInsertionPoint
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetInsertionPoint();
 rt.addInt(Result);
 break;
}
case wxComboBox_GetLastPosition: { // wxComboBox::GetLastPosition
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTextPos Result = This->GetLastPosition();
 rt.addInt(Result);
 break;
}
case wxComboBox_GetValue: { // wxComboBox::GetValue
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetValue();
 rt.add(Result);
 break;
}
case wxComboBox_Paste: { // wxComboBox::Paste
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Paste();
 break;
}
case wxComboBox_Redo: { // wxComboBox::Redo
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Redo();
 break;
}
case wxComboBox_Replace: { // wxComboBox::Replace
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 int * from = (int *) bp; bp += 4;
 int * to = (int *) bp; bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 wxString value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->Replace(*from,*to,value);
 break;
}
case wxComboBox_Remove: { // wxComboBox::Remove
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 int * from = (int *) bp; bp += 4;
 int * to = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Remove(*from,*to);
 break;
}
case wxComboBox_SetInsertionPoint: { // wxComboBox::SetInsertionPoint
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetInsertionPoint(*pos);
 break;
}
case wxComboBox_SetInsertionPointEnd: { // wxComboBox::SetInsertionPointEnd
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetInsertionPointEnd();
 break;
}
case wxComboBox_SetSelection_1: { // wxComboBox::SetSelection
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*n);
 break;
}
case wxComboBox_SetSelection_2: { // wxComboBox::SetSelection
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 int * from = (int *) bp; bp += 4;
 int * to = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*from,*to);
 break;
}
case wxComboBox_SetValue: { // wxComboBox::SetValue
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 wxString value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetValue(value);
 break;
}
case wxComboBox_Undo: { // wxComboBox::Undo
 wxComboBox *This = (wxComboBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Undo();
 break;
}
case wxGauge_new_0: { // wxGauge::wxGauge
 wxGauge * Result = new EwxGauge();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGauge");
 break;
}
case wxGauge_new_4: { // wxGauge::wxGauge
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxGA_HORIZONTAL;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * range = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxGauge * Result = new EwxGauge(parent,*id,*range,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGauge");
 break;
}
case wxGauge_Create: { // wxGauge::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxGA_HORIZONTAL;
 const wxValidator * validator= &wxDefaultValidator;
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * range = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,*range,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxGauge_GetBezelFace: { // wxGauge::GetBezelFace
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetBezelFace();
 rt.addInt(Result);
 break;
}
case wxGauge_GetRange: { // wxGauge::GetRange
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRange();
 rt.addInt(Result);
 break;
}
case wxGauge_GetShadowWidth: { // wxGauge::GetShadowWidth
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetShadowWidth();
 rt.addInt(Result);
 break;
}
case wxGauge_GetValue: { // wxGauge::GetValue
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetValue();
 rt.addInt(Result);
 break;
}
case wxGauge_IsVertical: { // wxGauge::IsVertical
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsVertical();
 rt.addBool(Result);
 break;
}
case wxGauge_SetBezelFace: { // wxGauge::SetBezelFace
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 int * w = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBezelFace(*w);
 break;
}
case wxGauge_SetRange: { // wxGauge::SetRange
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 int * r = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRange(*r);
 break;
}
case wxGauge_SetShadowWidth: { // wxGauge::SetShadowWidth
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 int * w = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetShadowWidth(*w);
 break;
}
case wxGauge_SetValue: { // wxGauge::SetValue
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetValue(*pos);
 break;
}
case wxGauge_Pulse: { // wxGauge::Pulse
 wxGauge *This = (wxGauge *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Pulse();
 break;
}
case wxGenericDirCtrl_new_0: { // wxGenericDirCtrl::wxGenericDirCtrl
 wxGenericDirCtrl * Result = new EwxGenericDirCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGenericDirCtrl");
 break;
}
case wxGenericDirCtrl_new_2: { // wxGenericDirCtrl::wxGenericDirCtrl
 wxWindowID id=wxID_ANY;
 wxString dir= wxDirDialogDefaultFolderStr;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDIRCTRL_3D_INTERNAL|wxSUNKEN_BORDER;
 wxString filter= wxEmptyString;
 int defaultFilter=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(const int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * dirLen = (int *) bp; bp += 4;
 dir = wxString(bp, wxConvUTF8);
 bp += *dirLen+((8-((0+ *dirLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 6: {bp += 4;
 int * filterLen = (int *) bp; bp += 4;
 filter = wxString(bp, wxConvUTF8);
 bp += *filterLen+((8-((0+ *filterLen) & 7)) & 7);
  } break;
  case 7: {bp += 4;
 defaultFilter = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxGenericDirCtrl * Result = new EwxGenericDirCtrl(parent,id,dir,pos,size,style,filter,defaultFilter);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGenericDirCtrl");
 break;
}
case wxGenericDirCtrl_Create: { // wxGenericDirCtrl::Create
 wxWindowID id=wxID_ANY;
 wxString dir= wxDirDialogDefaultFolderStr;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDIRCTRL_3D_INTERNAL|wxSUNKEN_BORDER;
 wxString filter= wxEmptyString;
 int defaultFilter=0;
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(const int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * dirLen = (int *) bp; bp += 4;
 dir = wxString(bp, wxConvUTF8);
 bp += *dirLen+((8-((0+ *dirLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 6: {bp += 4;
 int * filterLen = (int *) bp; bp += 4;
 filter = wxString(bp, wxConvUTF8);
 bp += *filterLen+((8-((0+ *filterLen) & 7)) & 7);
  } break;
  case 7: {bp += 4;
 defaultFilter = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,id,dir,pos,size,style,filter,defaultFilter);
 rt.addBool(Result);
 break;
}
case wxGenericDirCtrl_Init: { // wxGenericDirCtrl::Init
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Init();
 break;
}
case wxGenericDirCtrl_CollapseTree: { // wxGenericDirCtrl::CollapseTree
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CollapseTree();
 break;
}
case wxGenericDirCtrl_ExpandPath: { // wxGenericDirCtrl::ExpandPath
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 wxString path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->ExpandPath(path);
 rt.addBool(Result);
 break;
}
case wxGenericDirCtrl_GetDefaultPath: { // wxGenericDirCtrl::GetDefaultPath
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetDefaultPath();
 rt.add(Result);
 break;
}
case wxGenericDirCtrl_GetPath: { // wxGenericDirCtrl::GetPath
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPath();
 rt.add(Result);
 break;
}
case wxGenericDirCtrl_GetFilePath: { // wxGenericDirCtrl::GetFilePath
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetFilePath();
 rt.add(Result);
 break;
}
case wxGenericDirCtrl_GetFilter: { // wxGenericDirCtrl::GetFilter
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetFilter();
 rt.add(Result);
 break;
}
case wxGenericDirCtrl_GetFilterIndex: { // wxGenericDirCtrl::GetFilterIndex
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFilterIndex();
 rt.addInt(Result);
 break;
}
case wxGenericDirCtrl_GetRootId: { // wxGenericDirCtrl::GetRootId
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetRootId();
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxGenericDirCtrl_GetTreeCtrl: { // wxGenericDirCtrl::GetTreeCtrl
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTreeCtrl * Result = (wxTreeCtrl*)This->GetTreeCtrl();
 rt.addRef(getRef((void *)Result,memenv), "wxTreeCtrl");
 break;
}
case wxGenericDirCtrl_ReCreateTree: { // wxGenericDirCtrl::ReCreateTree
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ReCreateTree();
 break;
}
case wxGenericDirCtrl_SetDefaultPath: { // wxGenericDirCtrl::SetDefaultPath
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 wxString path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetDefaultPath(path);
 break;
}
case wxGenericDirCtrl_SetFilter: { // wxGenericDirCtrl::SetFilter
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 int * filterLen = (int *) bp; bp += 4;
 wxString filter = wxString(bp, wxConvUTF8);
 bp += *filterLen+((8-((0+ *filterLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetFilter(filter);
 break;
}
case wxGenericDirCtrl_SetFilterIndex: { // wxGenericDirCtrl::SetFilterIndex
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFilterIndex(*n);
 break;
}
case wxGenericDirCtrl_SetPath: { // wxGenericDirCtrl::SetPath
 wxGenericDirCtrl *This = (wxGenericDirCtrl *) getPtr(bp,memenv); bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 wxString path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetPath(path);
 break;
}
case wxStaticBox_new_4: { // wxStaticBox::wxStaticBox
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxStaticBox * Result = new EwxStaticBox(parent,*id,label,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticBox");
 break;
}
case wxStaticBox_new_0: { // wxStaticBox::wxStaticBox
 wxStaticBox * Result = new EwxStaticBox();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticBox");
 break;
}
case wxStaticBox_Create: { // wxStaticBox::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxStaticBox *This = (wxStaticBox *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,label,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxStaticLine_new_2: { // wxStaticLine::wxStaticLine
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxLI_HORIZONTAL;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxStaticLine * Result = new EwxStaticLine(parent,id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticLine");
 break;
}
case wxStaticLine_new_0: { // wxStaticLine::wxStaticLine
 wxStaticLine * Result = new EwxStaticLine();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticLine");
 break;
}
case wxStaticLine_Create: { // wxStaticLine::Create
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxLI_HORIZONTAL;
 wxStaticLine *This = (wxStaticLine *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxStaticLine_IsVertical: { // wxStaticLine::IsVertical
 wxStaticLine *This = (wxStaticLine *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsVertical();
 rt.addBool(Result);
 break;
}
case wxStaticLine_GetDefaultSize: { // wxStaticLine::GetDefaultSize
 int Result = wxStaticLine::GetDefaultSize();
 rt.addInt(Result);
 break;
}
case wxListBox_new_3: { // wxListBox::wxListBox
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 wxArrayString choices;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * choicesLen = (int *) bp; bp += 4;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((0+ choicesASz) & 7 )) & 7;
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxListBox * Result = new EwxListBox(parent,*id,pos,size,choices,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListBox");
 break;
}
case wxListBox_new_0: { // wxListBox::wxListBox
 wxListBox * Result = new EwxListBox();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListBox");
 break;
}
case wxListBox_Create: { // wxListBox::Create
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 int * choicesLen = (int *) bp; bp += 4;
 wxArrayString choices;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((0+ choicesASz) & 7 )) & 7;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,pos,size,choices,style,*validator);
 rt.addBool(Result);
 break;
}
case wxListBox_Deselect: { // wxListBox::Deselect
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Deselect(*n);
 break;
}
case wxListBox_GetSelections: { // wxListBox::GetSelections
 wxArrayInt aSelections;
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelections(aSelections);
 rt.addInt(Result);
 rt.add(aSelections);
 rt.addTupleCount(2);
 break;
}
case wxListBox_InsertItems: { // wxListBox::InsertItems
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 int * itemsLen = (int *) bp; bp += 4;
 wxArrayString items;
 int itemsASz = 0, * itemsTemp;
 for(int i=0; i < *itemsLen; i++) {
   itemsTemp = (int *) bp; bp += 4;
   items.Add(wxString(bp, wxConvUTF8));
   bp += *itemsTemp;
   itemsASz += *itemsTemp+4;
 }
 bp += (8-((0+ itemsASz) & 7 )) & 7;
 unsigned int * pos = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->InsertItems(items,*pos);
 break;
}
case wxListBox_IsSelected: { // wxListBox::IsSelected
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSelected(*n);
 rt.addBool(Result);
 break;
}
case wxListBox_Set: { // wxListBox::Set
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 int * itemsLen = (int *) bp; bp += 4;
 wxArrayString items;
 int itemsASz = 0, * itemsTemp;
 for(int i=0; i < *itemsLen; i++) {
   itemsTemp = (int *) bp; bp += 4;
   items.Add(wxString(bp, wxConvUTF8));
   bp += *itemsTemp;
   itemsASz += *itemsTemp+4;
 }
 bp += (8-((0+ itemsASz) & 7 )) & 7;
 if(!This) throw wxe_badarg(0);
 This->Set(items);
 break;
}
case wxListBox_HitTest: { // wxListBox::HitTest
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 int * pointX = (int *) bp; bp += 4;
 int * pointY = (int *) bp; bp += 4;
 wxPoint point = wxPoint(*pointX,*pointY);
 if(!This) throw wxe_badarg(0);
 int Result = This->HitTest(point);
 rt.addInt(Result);
 break;
}
case wxListBox_SetFirstItem_1_0: { // wxListBox::SetFirstItem
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFirstItem(*n);
 break;
}
case wxListBox_SetFirstItem_1_1: { // wxListBox::SetFirstItem
 wxListBox *This = (wxListBox *) getPtr(bp,memenv); bp += 4;
 int * sLen = (int *) bp; bp += 4;
 wxString s = wxString(bp, wxConvUTF8);
 bp += *sLen+((8-((0+ *sLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetFirstItem(s);
 break;
}

case wxListCtrl_new_0: { // wxListCtrl::wxListCtrl
 wxListCtrl * Result = new EwxListCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListCtrl");
 break;
}

case wxListCtrl_new_2: { // wxListCtrl::wxListCtrl
 wxWindowID winid=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxLC_ICON;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int onGetItemText = 0, onGetItemAttr = 0, onGetItemColumnImage = 0;

 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 winid = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
  case 6: {bp += 4;
    onGetItemText = *(int *) bp; bp += 4;
  } break;
  case 7: {bp += 4;
    onGetItemAttr = *(int *) bp; bp += 4;
  } break;
  case 8: {bp += 4;
    onGetItemColumnImage = *(int *) bp; bp += 4;
  } break;
 }};
 EwxListCtrl * Result = new EwxListCtrl(parent,winid,pos,size,style,*validator);
 Result->onGetItemText = onGetItemText;
 Result->onGetItemAttr = onGetItemAttr;
 Result->onGetItemColumnImage = onGetItemColumnImage;
 Result->port = Ecmd.port;
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListCtrl");
 break;
}
case wxListCtrl_Arrange: { // wxListCtrl::Arrange
 int flag=wxLIST_ALIGN_DEFAULT;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flag = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Arrange(flag);
 rt.addBool(Result);
 break;
}
case wxListCtrl_AssignImageList: { // wxListCtrl::AssignImageList
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * which = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AssignImageList(imageList,*which);
 break;
}
case wxListCtrl_ClearAll: { // wxListCtrl::ClearAll
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearAll();
 break;
}

case wxListCtrl_Create: { // wxListCtrl::Create
 wxWindowID winid=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxLC_ICON;
 const wxValidator * validator= &wxDefaultValidator;
 EwxListCtrl *This = (EwxListCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int onGetItemText = 0, onGetItemAttr = 0, onGetItemColumnImage = 0;

 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 winid = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
  case 6: {bp += 4;
    onGetItemText = *(int *) bp; bp += 4;
  } break;
  case 7: {bp += 4;
    onGetItemAttr = *(int *) bp; bp += 4;
  } break;
  case 8: {bp += 4;
    onGetItemColumnImage = *(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,winid,pos,size,style,*validator);
 This->onGetItemText = onGetItemText;
 This->onGetItemAttr = onGetItemAttr;
 This->onGetItemColumnImage = onGetItemColumnImage;
 This->port = Ecmd.port;

 rt.addBool(Result);
 break;
}
case wxListCtrl_DeleteAllItems: { // wxListCtrl::DeleteAllItems
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteAllItems();
 rt.addBool(Result);
 break;
}
case wxListCtrl_DeleteColumn: { // wxListCtrl::DeleteColumn
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteColumn(*col);
 rt.addBool(Result);
 break;
}
case wxListCtrl_DeleteItem: { // wxListCtrl::DeleteItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteItem(*item);
 rt.addBool(Result);
 break;
}
case wxListCtrl_EditLabel: { // wxListCtrl::EditLabel
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTextCtrl * Result = (wxTextCtrl*)This->EditLabel(*item);
 rt.addRef(getRef((void *)Result,memenv), "wxTextCtrl");
 break;
}
case wxListCtrl_EnsureVisible: { // wxListCtrl::EnsureVisible
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->EnsureVisible(*item);
 rt.addBool(Result);
 break;
}
case wxListCtrl_FindItem_3_0: { // wxListCtrl::FindItem
 bool partial=false;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * start = (int *) bp; bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((4+ *strLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 partial = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 long Result = This->FindItem(*start,str,partial);
 rt.addInt(Result);
 break;
}
case wxListCtrl_FindItem_3_1: { // wxListCtrl::FindItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * start = (int *) bp; bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 int * direction = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->FindItem(*start,pt,*direction);
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetColumn: { // wxListCtrl::GetColumn
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 wxListItem *item = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetColumn(*col,*item);
 rt.addBool(Result);
 break;
}
case wxListCtrl_GetColumnCount: { // wxListCtrl::GetColumnCount
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColumnCount();
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetColumnWidth: { // wxListCtrl::GetColumnWidth
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColumnWidth(*col);
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetCountPerPage: { // wxListCtrl::GetCountPerPage
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCountPerPage();
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetEditControl: { // wxListCtrl::GetEditControl
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTextCtrl * Result = (wxTextCtrl*)This->GetEditControl();
 rt.addRef(getRef((void *)Result,memenv), "wxTextCtrl");
 break;
}
case wxListCtrl_GetImageList: { // wxListCtrl::GetImageList
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * which = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImageList * Result = (wxImageList*)This->GetImageList(*which);
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxListCtrl_GetItem: { // wxListCtrl::GetItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 wxListItem *info = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetItem(*info);
 rt.addBool(Result);
 break;
}
case wxListCtrl_GetItemBackgroundColour: { // wxListCtrl::GetItemBackgroundColour
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetItemBackgroundColour(*item);
 rt.add(Result);
 break;
}
case wxListCtrl_GetItemCount: { // wxListCtrl::GetItemCount
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetItemCount();
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetItemData: { // wxListCtrl::GetItemData
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxUIntPtr Result = This->GetItemData(*item);
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetItemFont: { // wxListCtrl::GetItemFont
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetItemFont(*item)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxListCtrl_GetItemPosition: { // wxListCtrl::GetItemPosition
 wxPoint pos;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetItemPosition(*item,pos);
 rt.addBool(Result);
 rt.add(pos);
 rt.addTupleCount(2);
 break;
}
case wxListCtrl_GetItemRect: { // wxListCtrl::GetItemRect
 wxRect rect;
 int code=wxLIST_RECT_BOUNDS;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 code = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetItemRect(*item,rect,code);
 rt.addBool(Result);
 rt.add(rect);
 rt.addTupleCount(2);
 break;
}
case wxListCtrl_GetItemSpacing: { // wxListCtrl::GetItemSpacing
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetItemSpacing();
 rt.add(Result);
 break;
}
case wxListCtrl_GetItemState: { // wxListCtrl::GetItemState
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * stateMask = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetItemState(*item,*stateMask);
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetItemText: { // wxListCtrl::GetItemText
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetItemText(*item);
 rt.add(Result);
 break;
}
case wxListCtrl_GetItemTextColour: { // wxListCtrl::GetItemTextColour
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetItemTextColour(*item);
 rt.add(Result);
 break;
}
case wxListCtrl_GetNextItem: { // wxListCtrl::GetNextItem
 int geometry=wxLIST_NEXT_ALL;
 int state=wxLIST_STATE_DONTCARE;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 geometry = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 state = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 long Result = This->GetNextItem(*item,geometry,state);
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetSelectedItemCount: { // wxListCtrl::GetSelectedItemCount
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelectedItemCount();
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetTextColour: { // wxListCtrl::GetTextColour
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetTextColour();
 rt.add(Result);
 break;
}
case wxListCtrl_GetTopItem: { // wxListCtrl::GetTopItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetTopItem();
 rt.addInt(Result);
 break;
}
case wxListCtrl_GetViewRect: { // wxListCtrl::GetViewRect
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetViewRect();
 rt.add(Result);
 break;
}
case wxListCtrl_HitTest: { // wxListCtrl::HitTest
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * pointX = (int *) bp; bp += 4;
 int * pointY = (int *) bp; bp += 4;
 wxPoint point = wxPoint(*pointX,*pointY);
 int * flags = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->HitTest(point,*flags);
 rt.addInt(Result);
 break;
}
case wxListCtrl_InsertColumn_2: { // wxListCtrl::InsertColumn
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 wxListItem *info = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->InsertColumn(*col,*info);
 rt.addInt(Result);
 break;
}
case wxListCtrl_InsertColumn_3: { // wxListCtrl::InsertColumn
 int format=wxLIST_FORMAT_LEFT;
 int width=-1;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 int * headingLen = (int *) bp; bp += 4;
 wxString heading = wxString(bp, wxConvUTF8);
 bp += *headingLen+((8-((4+ *headingLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 format = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 width = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 long Result = This->InsertColumn(*col,heading,format,width);
 rt.addInt(Result);
 break;
}
case wxListCtrl_InsertItem_1: { // wxListCtrl::InsertItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 wxListItem *info = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->InsertItem(*info);
 rt.addInt(Result);
 break;
}
case wxListCtrl_InsertItem_2_1: { // wxListCtrl::InsertItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 long Result = This->InsertItem(*index,label);
 rt.addInt(Result);
 break;
}
case wxListCtrl_InsertItem_2_0: { // wxListCtrl::InsertItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * imageIndex = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->InsertItem(*index,*imageIndex);
 rt.addInt(Result);
 break;
}
case wxListCtrl_InsertItem_3: { // wxListCtrl::InsertItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 int * imageIndex = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->InsertItem(*index,label,*imageIndex);
 rt.addInt(Result);
 break;
}
case wxListCtrl_RefreshItem: { // wxListCtrl::RefreshItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->RefreshItem(*item);
 break;
}
case wxListCtrl_RefreshItems: { // wxListCtrl::RefreshItems
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * itemFrom = (int *) bp; bp += 4;
 int * itemTo = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->RefreshItems(*itemFrom,*itemTo);
 break;
}
case wxListCtrl_ScrollList: { // wxListCtrl::ScrollList
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * dx = (int *) bp; bp += 4;
 int * dy = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ScrollList(*dx,*dy);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetBackgroundColour: { // wxListCtrl::SetBackgroundColour
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetBackgroundColour(colour);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetColumn: { // wxListCtrl::SetColumn
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 wxListItem *item = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetColumn(*col,*item);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetColumnWidth: { // wxListCtrl::SetColumnWidth
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetColumnWidth(*col,*width);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetImageList: { // wxListCtrl::SetImageList
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * which = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetImageList(imageList,*which);
 break;
}
case wxListCtrl_SetItem_1: { // wxListCtrl::SetItem
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 wxListItem *info = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItem(*info);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetItem_4: { // wxListCtrl::SetItem
 int imageId=-1;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 int * col = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 long Result = This->SetItem(*index,*col,label,imageId);
 rt.addInt(Result);
 break;
}
case wxListCtrl_SetItemBackgroundColour: { // wxListCtrl::SetItemBackgroundColour
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetItemBackgroundColour(*item,col);
 break;
}
case wxListCtrl_SetItemCount: { // wxListCtrl::SetItemCount
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * count = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetItemCount(*count);
 break;
}
case wxListCtrl_SetItemData: { // wxListCtrl::SetItemData
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * data = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemData(*item,*data);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetItemFont: { // wxListCtrl::SetItemFont
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 wxFont *f = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetItemFont(*item,*f);
 break;
}
case wxListCtrl_SetItemImage: { // wxListCtrl::SetItemImage
 int selImage=-1;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * image = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 selImage = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemImage(*item,*image,selImage);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetItemColumnImage: { // wxListCtrl::SetItemColumnImage
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * column = (int *) bp; bp += 4;
 int * image = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemColumnImage(*item,*column,*image);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetItemPosition: { // wxListCtrl::SetItemPosition
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemPosition(*item,pos);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetItemState: { // wxListCtrl::SetItemState
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * state = (int *) bp; bp += 4;
 int * stateMask = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetItemState(*item,*state,*stateMask);
 rt.addBool(Result);
 break;
}
case wxListCtrl_SetItemText: { // wxListCtrl::SetItemText
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((4+ *strLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetItemText(*item,str);
 break;
}
case wxListCtrl_SetItemTextColour: { // wxListCtrl::SetItemTextColour
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetItemTextColour(*item,col);
 break;
}
case wxListCtrl_SetSingleStyle: { // wxListCtrl::SetSingleStyle
 bool add=true;
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 add = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetSingleStyle(*style,add);
 break;
}
case wxListCtrl_SetTextColour: { // wxListCtrl::SetTextColour
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetTextColour(col);
 break;
}
case wxListCtrl_SetWindowStyleFlag: { // wxListCtrl::SetWindowStyleFlag
 wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWindowStyleFlag(*style);
 break;
}

case wxListCtrl_SortItems: { // wxListCtrl::SortItems taylormade
  wxListCtrl *This = (wxListCtrl *) getPtr(bp,memenv); bp += 4;
  int sortCallback=*(int *) bp; bp += 4;
  if(!This) throw wxe_badarg(0);

  callbackInfo* cb = new callbackInfo();
  cb->port = Ecmd.port;
  cb->callbackID = sortCallback;
  bool Result = This->SortItems(wxEListCtrlCompare, (wxeIntPtr)cb);
  delete cb;

  /* Destroy the callback, see wxEPrintout::clear_cb */
  wxeReturn cbrt = wxeReturn(WXE_DRV_PORT, memenv->owner, false);
  // NOTE: Remove this later when changing from funs to gen_server
  cbrt.addAtom("wx_delete_cb");
  cbrt.addInt(sortCallback);
  cbrt.addTupleCount(2);
  cbrt.send();

  rt.addBool(Result);
  break;
}
case wxListView_ClearColumnImage: { // wxListView::ClearColumnImage
 wxListView *This = (wxListView *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearColumnImage(*col);
 break;
}
case wxListView_Focus: { // wxListView::Focus
 wxListView *This = (wxListView *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Focus(*index);
 break;
}
case wxListView_GetFirstSelected: { // wxListView::GetFirstSelected
 wxListView *This = (wxListView *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetFirstSelected();
 rt.addInt(Result);
 break;
}
case wxListView_GetFocusedItem: { // wxListView::GetFocusedItem
 wxListView *This = (wxListView *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetFocusedItem();
 rt.addInt(Result);
 break;
}
case wxListView_GetNextSelected: { // wxListView::GetNextSelected
 wxListView *This = (wxListView *) getPtr(bp,memenv); bp += 4;
 int * item = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetNextSelected(*item);
 rt.addInt(Result);
 break;
}
case wxListView_IsSelected: { // wxListView::IsSelected
 wxListView *This = (wxListView *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSelected(*index);
 rt.addBool(Result);
 break;
}
case wxListView_Select: { // wxListView::Select
 bool on=true;
 wxListView *This = (wxListView *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 on = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Select(*n,on);
 break;
}
case wxListView_SetColumnImage: { // wxListView::SetColumnImage
 wxListView *This = (wxListView *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 int * image = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColumnImage(*col,*image);
 break;
}
case wxListItem_new_0: { // wxListItem::wxListItem
 wxListItem * Result = new EwxListItem();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListItem");
 break;
}
case wxListItem_new_1: { // wxListItem::wxListItem
 wxListItem *item = (wxListItem *) getPtr(bp,memenv); bp += 4;
 wxListItem * Result = new EwxListItem(*item);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListItem");
 break;
}
case wxListItem_Clear: { // wxListItem::Clear
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Clear();
 break;
}
case wxListItem_GetAlign: { // wxListItem::GetAlign
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetAlign();
 rt.addInt(Result);
 break;
}
case wxListItem_GetBackgroundColour: { // wxListItem::GetBackgroundColour
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetBackgroundColour();
 rt.add(Result);
 break;
}
case wxListItem_GetColumn: { // wxListItem::GetColumn
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColumn();
 rt.addInt(Result);
 break;
}
case wxListItem_GetFont: { // wxListItem::GetFont
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxListItem_GetId: { // wxListItem::GetId
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetId();
 rt.addInt(Result);
 break;
}
case wxListItem_GetImage: { // wxListItem::GetImage
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetImage();
 rt.addInt(Result);
 break;
}
case wxListItem_GetMask: { // wxListItem::GetMask
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetMask();
 rt.addInt(Result);
 break;
}
case wxListItem_GetState: { // wxListItem::GetState
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetState();
 rt.addInt(Result);
 break;
}
case wxListItem_GetText: { // wxListItem::GetText
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString * Result = &This->GetText();
 rt.add(Result);
 break;
}
case wxListItem_GetTextColour: { // wxListItem::GetTextColour
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetTextColour();
 rt.add(Result);
 break;
}
case wxListItem_GetWidth: { // wxListItem::GetWidth
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWidth();
 rt.addInt(Result);
 break;
}
case wxListItem_SetAlign: { // wxListItem::SetAlign
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 wxListColumnFormat align = *(wxListColumnFormat *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetAlign(align);
 break;
}
case wxListItem_SetBackgroundColour: { // wxListItem::SetBackgroundColour
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * colBackR = (int *) bp; bp += 4;
 int * colBackG = (int *) bp; bp += 4;
 int * colBackB = (int *) bp; bp += 4;
 int * colBackA = (int *) bp; bp += 4;
 wxColour colBack = wxColour(*colBackR,*colBackG,*colBackB,*colBackA);
 if(!This) throw wxe_badarg(0);
 This->SetBackgroundColour(colBack);
 break;
}
case wxListItem_SetColumn: { // wxListItem::SetColumn
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * col = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColumn(*col);
 break;
}
case wxListItem_SetFont: { // wxListItem::SetFont
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFont(*font);
 break;
}
case wxListItem_SetId: { // wxListItem::SetId
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetId(*id);
 break;
}
case wxListItem_SetImage: { // wxListItem::SetImage
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * image = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetImage(*image);
 break;
}
case wxListItem_SetMask: { // wxListItem::SetMask
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * mask = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMask(*mask);
 break;
}
case wxListItem_SetState: { // wxListItem::SetState
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * state = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetState(*state);
 break;
}
case wxListItem_SetStateMask: { // wxListItem::SetStateMask
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * stateMask = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStateMask(*stateMask);
 break;
}
case wxListItem_SetText: { // wxListItem::SetText
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetText(text);
 break;
}
case wxListItem_SetTextColour: { // wxListItem::SetTextColour
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * colTextR = (int *) bp; bp += 4;
 int * colTextG = (int *) bp; bp += 4;
 int * colTextB = (int *) bp; bp += 4;
 int * colTextA = (int *) bp; bp += 4;
 wxColour colText = wxColour(*colTextR,*colTextG,*colTextB,*colTextA);
 if(!This) throw wxe_badarg(0);
 This->SetTextColour(colText);
 break;
}
case wxListItem_SetWidth: { // wxListItem::SetWidth
 wxListItem *This = (wxListItem *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWidth(*width);
 break;
}
case wxListItemAttr_new_0: { // wxListItemAttr::wxListItemAttr
 wxListItemAttr * Result = new wxListItemAttr();
 newPtr((void *) Result, 101, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListItemAttr");
 break;
}
case wxListItemAttr_new_3: { // wxListItemAttr::wxListItemAttr
 int * colTextR = (int *) bp; bp += 4;
 int * colTextG = (int *) bp; bp += 4;
 int * colTextB = (int *) bp; bp += 4;
 int * colTextA = (int *) bp; bp += 4;
 wxColour colText = wxColour(*colTextR,*colTextG,*colTextB,*colTextA);
 int * colBackR = (int *) bp; bp += 4;
 int * colBackG = (int *) bp; bp += 4;
 int * colBackB = (int *) bp; bp += 4;
 int * colBackA = (int *) bp; bp += 4;
 wxColour colBack = wxColour(*colBackR,*colBackG,*colBackB,*colBackA);
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 wxListItemAttr * Result = new wxListItemAttr(colText,colBack,*font);
 newPtr((void *) Result, 101, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListItemAttr");
 break;
}
case wxListItemAttr_GetBackgroundColour: { // wxListItemAttr::GetBackgroundColour
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetBackgroundColour();
 rt.add((*Result));
 break;
}
case wxListItemAttr_GetFont: { // wxListItemAttr::GetFont
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxFont * Result = &This->GetFont();
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxListItemAttr_GetTextColour: { // wxListItemAttr::GetTextColour
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetTextColour();
 rt.add((*Result));
 break;
}
case wxListItemAttr_HasBackgroundColour: { // wxListItemAttr::HasBackgroundColour
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasBackgroundColour();
 rt.addBool(Result);
 break;
}
case wxListItemAttr_HasFont: { // wxListItemAttr::HasFont
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasFont();
 rt.addBool(Result);
 break;
}
case wxListItemAttr_HasTextColour: { // wxListItemAttr::HasTextColour
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasTextColour();
 rt.addBool(Result);
 break;
}
case wxListItemAttr_SetBackgroundColour: { // wxListItemAttr::SetBackgroundColour
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 int * colBackR = (int *) bp; bp += 4;
 int * colBackG = (int *) bp; bp += 4;
 int * colBackB = (int *) bp; bp += 4;
 int * colBackA = (int *) bp; bp += 4;
 wxColour colBack = wxColour(*colBackR,*colBackG,*colBackB,*colBackA);
 if(!This) throw wxe_badarg(0);
 This->SetBackgroundColour(colBack);
 break;
}
case wxListItemAttr_SetFont: { // wxListItemAttr::SetFont
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFont(*font);
 break;
}
case wxListItemAttr_SetTextColour: { // wxListItemAttr::SetTextColour
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 int * colTextR = (int *) bp; bp += 4;
 int * colTextG = (int *) bp; bp += 4;
 int * colTextB = (int *) bp; bp += 4;
 int * colTextA = (int *) bp; bp += 4;
 wxColour colText = wxColour(*colTextR,*colTextG,*colTextB,*colTextA);
 if(!This) throw wxe_badarg(0);
 This->SetTextColour(colText);
 break;
}
case wxListItemAttr_destroy: { // wxListItemAttr::destroy
 wxListItemAttr *This = (wxListItemAttr *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxImageList_new_0: { // wxImageList::wxImageList
 wxImageList * Result = new EwxImageList();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxImageList_new_3: { // wxImageList::wxImageList
 bool mask=true;
 int initialCount=1;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 mask = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 initialCount = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxImageList * Result = new EwxImageList(*width,*height,mask,initialCount);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxImageList_Add_1: { // wxImageList::Add
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->Add(*bitmap);
 rt.addInt(Result);
 break;
}
case wxImageList_Add_2_0: { // wxImageList::Add
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxBitmap *mask = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->Add(*bitmap,*mask);
 rt.addInt(Result);
 break;
}
case wxImageList_Add_2_1: { // wxImageList::Add
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 int * maskColourR = (int *) bp; bp += 4;
 int * maskColourG = (int *) bp; bp += 4;
 int * maskColourB = (int *) bp; bp += 4;
 int * maskColourA = (int *) bp; bp += 4;
 wxColour maskColour = wxColour(*maskColourR,*maskColourG,*maskColourB,*maskColourA);
 if(!This) throw wxe_badarg(0);
 int Result = This->Add(*bitmap,maskColour);
 rt.addInt(Result);
 break;
}
case wxImageList_Create: { // wxImageList::Create
 bool mask=true;
 int initialCount=1;
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 int * height = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 mask = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 initialCount = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(*width,*height,mask,initialCount);
 rt.addBool(Result);
 break;
}
case wxImageList_Draw: { // wxImageList::Draw
 int flags=wxIMAGELIST_DRAW_NORMAL;
 bool solidBackground=false;
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 solidBackground = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Draw(*index,*dc,*x,*y,flags,solidBackground);
 rt.addBool(Result);
 break;
}
case wxImageList_GetBitmap: { // wxImageList::GetBitmap
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxBitmap * Result = new EwxBitmap(This->GetBitmap(*index)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxImageList_GetIcon: { // wxImageList::GetIcon
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxIcon * Result = new EwxIcon(This->GetIcon(*index)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxIcon");
 break;
}
case wxImageList_GetImageCount: { // wxImageList::GetImageCount
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetImageCount();
 rt.addInt(Result);
 break;
}
case wxImageList_GetSize: { // wxImageList::GetSize
 int width;
 int height;
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetSize(*index,width,height);
 rt.addBool(Result);
 rt.addInt(width);
 rt.addInt(height);
 rt.addTupleCount(3);
 break;
}
case wxImageList_Remove: { // wxImageList::Remove
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Remove(*index);
 rt.addBool(Result);
 break;
}
case wxImageList_RemoveAll: { // wxImageList::RemoveAll
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RemoveAll();
 rt.addBool(Result);
 break;
}
case wxImageList_Replace_2: { // wxImageList::Replace
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Replace(*index,*bitmap);
 rt.addBool(Result);
 break;
}
case wxImageList_Replace_3: { // wxImageList::Replace
 wxImageList *This = (wxImageList *) getPtr(bp,memenv); bp += 4;
 int * index = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 wxBitmap *mask = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Replace(*index,*bitmap,*mask);
 rt.addBool(Result);
 break;
}
case wxTextAttr_new_0: { // wxTextAttr::wxTextAttr
 wxTextAttr * Result = new wxTextAttr();
 newPtr((void *) Result, 103, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTextAttr");
 break;
}
case wxTextAttr_new_2: { // wxTextAttr::wxTextAttr
 wxColour colBack= wxNullColour;
 const wxFont * font= &wxNullFont;
 wxTextAttrAlignment alignment=wxTEXT_ALIGNMENT_DEFAULT;
 int * colTextR = (int *) bp; bp += 4;
 int * colTextG = (int *) bp; bp += 4;
 int * colTextB = (int *) bp; bp += 4;
 int * colTextA = (int *) bp; bp += 4;
 wxColour colText = wxColour(*colTextR,*colTextG,*colTextB,*colTextA);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * colBackR = (int *) bp; bp += 4;
 int * colBackG = (int *) bp; bp += 4;
 int * colBackB = (int *) bp; bp += 4;
 int * colBackA = (int *) bp; bp += 4;
 colBack = wxColour(*colBackR,*colBackG,*colBackB,*colBackA);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
font = (wxFont *) getPtr(bp,memenv); bp += 4;
  } break;
  case 3: {bp += 4;
alignment = *(wxTextAttrAlignment *) bp; bp += 4;;
  } break;
 }};
 wxTextAttr * Result = new wxTextAttr(colText,colBack,*font,alignment);
 newPtr((void *) Result, 103, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTextAttr");
 break;
}
case wxTextAttr_GetAlignment: { // wxTextAttr::GetAlignment
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetAlignment();
 rt.addInt(Result);
 break;
}
case wxTextAttr_GetBackgroundColour: { // wxTextAttr::GetBackgroundColour
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetBackgroundColour();
 rt.add((*Result));
 break;
}
case wxTextAttr_GetFont: { // wxTextAttr::GetFont
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxFont * Result = new EwxFont(This->GetFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxTextAttr_GetLeftIndent: { // wxTextAttr::GetLeftIndent
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetLeftIndent();
 rt.addInt(Result);
 break;
}
case wxTextAttr_GetLeftSubIndent: { // wxTextAttr::GetLeftSubIndent
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetLeftSubIndent();
 rt.addInt(Result);
 break;
}
case wxTextAttr_GetRightIndent: { // wxTextAttr::GetRightIndent
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetRightIndent();
 rt.addInt(Result);
 break;
}
case wxTextAttr_GetTabs: { // wxTextAttr::GetTabs
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxArrayInt Result = This->GetTabs();
 rt.add(Result);
 break;
}
case wxTextAttr_GetTextColour: { // wxTextAttr::GetTextColour
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetTextColour();
 rt.add((*Result));
 break;
}
case wxTextAttr_HasBackgroundColour: { // wxTextAttr::HasBackgroundColour
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasBackgroundColour();
 rt.addBool(Result);
 break;
}
case wxTextAttr_HasFont: { // wxTextAttr::HasFont
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasFont();
 rt.addBool(Result);
 break;
}
case wxTextAttr_HasTextColour: { // wxTextAttr::HasTextColour
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasTextColour();
 rt.addBool(Result);
 break;
}
case wxTextAttr_GetFlags: { // wxTextAttr::GetFlags
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetFlags();
 rt.addInt(Result);
 break;
}
case wxTextAttr_IsDefault: { // wxTextAttr::IsDefault
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsDefault();
 rt.addBool(Result);
 break;
}
case wxTextAttr_SetAlignment: { // wxTextAttr::SetAlignment
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 wxTextAttrAlignment alignment = *(wxTextAttrAlignment *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetAlignment(alignment);
 break;
}
case wxTextAttr_SetBackgroundColour: { // wxTextAttr::SetBackgroundColour
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 int * colBackR = (int *) bp; bp += 4;
 int * colBackG = (int *) bp; bp += 4;
 int * colBackB = (int *) bp; bp += 4;
 int * colBackA = (int *) bp; bp += 4;
 wxColour colBack = wxColour(*colBackR,*colBackG,*colBackB,*colBackA);
 if(!This) throw wxe_badarg(0);
 This->SetBackgroundColour(colBack);
 break;
}
case wxTextAttr_SetFlags: { // wxTextAttr::SetFlags
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 int * flags = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFlags(*flags);
 break;
}
case wxTextAttr_SetFont: { // wxTextAttr::SetFont
 long flags=wxTEXT_ATTR_FONT;
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetFont(*font,flags);
 break;
}
case wxTextAttr_SetLeftIndent: { // wxTextAttr::SetLeftIndent
 int subIndent=0;
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 int * indent = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 subIndent = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetLeftIndent(*indent,subIndent);
 break;
}
case wxTextAttr_SetRightIndent: { // wxTextAttr::SetRightIndent
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 int * indent = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRightIndent(*indent);
 break;
}
case wxTextAttr_SetTabs: { // wxTextAttr::SetTabs
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 int * tabsLen = (int *) bp; bp += 4;
 wxArrayInt tabs;
 for(int i=0; i < *tabsLen; i++) {  tabs.Add(*(int *) bp); bp += 4;}
 bp += ((*tabsLen + 2) % 2 )*4;
 if(!This) throw wxe_badarg(0);
 This->SetTabs(tabs);
 break;
}
case wxTextAttr_SetTextColour: { // wxTextAttr::SetTextColour
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 int * colTextR = (int *) bp; bp += 4;
 int * colTextG = (int *) bp; bp += 4;
 int * colTextB = (int *) bp; bp += 4;
 int * colTextA = (int *) bp; bp += 4;
 wxColour colText = wxColour(*colTextR,*colTextG,*colTextB,*colTextA);
 if(!This) throw wxe_badarg(0);
 This->SetTextColour(colText);
 break;
}
case wxTextAttr_destroy: { // wxTextAttr::destroy
 wxTextAttr *This = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxTextCtrl_new_3: { // wxTextCtrl::wxTextCtrl
 wxString value= wxEmptyString;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxTextCtrl * Result = new EwxTextCtrl(parent,*id,value,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTextCtrl");
 break;
}
case wxTextCtrl_new_0: { // wxTextCtrl::wxTextCtrl
 wxTextCtrl * Result = new EwxTextCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTextCtrl");
 break;
}
case wxTextCtrl_AppendText: { // wxTextCtrl::AppendText
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->AppendText(text);
 break;
}
case wxTextCtrl_CanCopy: { // wxTextCtrl::CanCopy
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanCopy();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_CanCut: { // wxTextCtrl::CanCut
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanCut();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_CanPaste: { // wxTextCtrl::CanPaste
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanPaste();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_CanRedo: { // wxTextCtrl::CanRedo
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanRedo();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_CanUndo: { // wxTextCtrl::CanUndo
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanUndo();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_Clear: { // wxTextCtrl::Clear
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Clear();
 break;
}
case wxTextCtrl_Copy: { // wxTextCtrl::Copy
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Copy();
 break;
}
case wxTextCtrl_Create: { // wxTextCtrl::Create
 wxString value= wxEmptyString;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,value,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxTextCtrl_Cut: { // wxTextCtrl::Cut
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Cut();
 break;
}
case wxTextCtrl_DiscardEdits: { // wxTextCtrl::DiscardEdits
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DiscardEdits();
 break;
}
case wxTextCtrl_ChangeValue: { // wxTextCtrl::ChangeValue
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 wxString value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->ChangeValue(value);
 break;
}
case wxTextCtrl_EmulateKeyPress: { // wxTextCtrl::EmulateKeyPress
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 wxKeyEvent *event = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->EmulateKeyPress(*event);
 rt.addBool(Result);
 break;
}
case wxTextCtrl_GetDefaultStyle: { // wxTextCtrl::GetDefaultStyle
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxTextAttr * Result = &This->GetDefaultStyle();
 rt.addRef(getRef((void *)Result,memenv), "wxTextAttr");
 break;
}
case wxTextCtrl_GetInsertionPoint: { // wxTextCtrl::GetInsertionPoint
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetInsertionPoint();
 rt.addInt(Result);
 break;
}
case wxTextCtrl_GetLastPosition: { // wxTextCtrl::GetLastPosition
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTextPos Result = This->GetLastPosition();
 rt.addInt(Result);
 break;
}
case wxTextCtrl_GetLineLength: { // wxTextCtrl::GetLineLength
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * lineNo = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLineLength(*lineNo);
 rt.addInt(Result);
 break;
}
case wxTextCtrl_GetLineText: { // wxTextCtrl::GetLineText
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * lineNo = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLineText(*lineNo);
 rt.add(Result);
 break;
}
case wxTextCtrl_GetNumberOfLines: { // wxTextCtrl::GetNumberOfLines
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetNumberOfLines();
 rt.addInt(Result);
 break;
}
case wxTextCtrl_GetRange: { // wxTextCtrl::GetRange
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * from = (int *) bp; bp += 4;
 int * to = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetRange(*from,*to);
 rt.add(Result);
 break;
}
case wxTextCtrl_GetSelection: { // wxTextCtrl::GetSelection
 long from;
 long to;
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetSelection(&from,&to);
 rt.addInt(from);
 rt.addInt(to);
 rt.addTupleCount(2);
 break;
}
case wxTextCtrl_GetStringSelection: { // wxTextCtrl::GetStringSelection
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetStringSelection();
 rt.add(Result);
 break;
}
case wxTextCtrl_GetStyle: { // wxTextCtrl::GetStyle
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * position = (int *) bp; bp += 4;
 wxTextAttr *style = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetStyle(*position,*style);
 rt.addBool(Result);
 break;
}
case wxTextCtrl_GetValue: { // wxTextCtrl::GetValue
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetValue();
 rt.add(Result);
 break;
}
case wxTextCtrl_IsEditable: { // wxTextCtrl::IsEditable
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEditable();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_IsModified: { // wxTextCtrl::IsModified
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsModified();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_IsMultiLine: { // wxTextCtrl::IsMultiLine
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsMultiLine();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_IsSingleLine: { // wxTextCtrl::IsSingleLine
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSingleLine();
 rt.addBool(Result);
 break;
}
case wxTextCtrl_LoadFile: { // wxTextCtrl::LoadFile
 int fileType=wxTEXT_TYPE_ANY;
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * fileLen = (int *) bp; bp += 4;
 wxString file = wxString(bp, wxConvUTF8);
 bp += *fileLen+((8-((0+ *fileLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 fileType = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->LoadFile(file,fileType);
 rt.addBool(Result);
 break;
}
case wxTextCtrl_MarkDirty: { // wxTextCtrl::MarkDirty
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MarkDirty();
 break;
}
case wxTextCtrl_Paste: { // wxTextCtrl::Paste
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Paste();
 break;
}
case wxTextCtrl_PositionToXY: { // wxTextCtrl::PositionToXY
 long x;
 long y;
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->PositionToXY(*pos,&x,&y);
 rt.addBool(Result);
 rt.addInt(x);
 rt.addInt(y);
 rt.addTupleCount(3);
 break;
}
case wxTextCtrl_Redo: { // wxTextCtrl::Redo
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Redo();
 break;
}
case wxTextCtrl_Remove: { // wxTextCtrl::Remove
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * from = (int *) bp; bp += 4;
 int * to = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Remove(*from,*to);
 break;
}
case wxTextCtrl_Replace: { // wxTextCtrl::Replace
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * from = (int *) bp; bp += 4;
 int * to = (int *) bp; bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 wxString value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->Replace(*from,*to,value);
 break;
}
case wxTextCtrl_SaveFile: { // wxTextCtrl::SaveFile
 wxString file= wxEmptyString;
 int fileType=wxTEXT_TYPE_ANY;
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * fileLen = (int *) bp; bp += 4;
 file = wxString(bp, wxConvUTF8);
 bp += *fileLen+((8-((0+ *fileLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 fileType = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->SaveFile(file,fileType);
 rt.addBool(Result);
 break;
}
case wxTextCtrl_SetDefaultStyle: { // wxTextCtrl::SetDefaultStyle
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 wxTextAttr *style = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetDefaultStyle(*style);
 rt.addBool(Result);
 break;
}
case wxTextCtrl_SetEditable: { // wxTextCtrl::SetEditable
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * editable = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetEditable(*editable);
 break;
}
case wxTextCtrl_SetInsertionPoint: { // wxTextCtrl::SetInsertionPoint
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetInsertionPoint(*pos);
 break;
}
case wxTextCtrl_SetInsertionPointEnd: { // wxTextCtrl::SetInsertionPointEnd
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetInsertionPointEnd();
 break;
}
case wxTextCtrl_SetMaxLength: { // wxTextCtrl::SetMaxLength
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 unsigned int * len = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMaxLength(*len);
 break;
}
case wxTextCtrl_SetSelection: { // wxTextCtrl::SetSelection
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * from = (int *) bp; bp += 4;
 int * to = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*from,*to);
 break;
}
case wxTextCtrl_SetStyle: { // wxTextCtrl::SetStyle
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * start = (int *) bp; bp += 4;
 int * end = (int *) bp; bp += 4;
 wxTextAttr *style = (wxTextAttr *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetStyle(*start,*end,*style);
 rt.addBool(Result);
 break;
}
case wxTextCtrl_SetValue: { // wxTextCtrl::SetValue
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 wxString value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetValue(value);
 break;
}
case wxTextCtrl_ShowPosition: { // wxTextCtrl::ShowPosition
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ShowPosition(*pos);
 break;
}
case wxTextCtrl_Undo: { // wxTextCtrl::Undo
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Undo();
 break;
}
case wxTextCtrl_WriteText: { // wxTextCtrl::WriteText
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->WriteText(text);
 break;
}
case wxTextCtrl_XYToPosition: { // wxTextCtrl::XYToPosition
 wxTextCtrl *This = (wxTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->XYToPosition(*x,*y);
 rt.addInt(Result);
 break;
}
case wxNotebook_new_0: { // wxNotebook::wxNotebook
 wxNotebook * Result = new EwxNotebook();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxNotebook");
 break;
}
case wxNotebook_new_3: { // wxNotebook::wxNotebook
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * winid = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxNotebook * Result = new EwxNotebook(parent,*winid,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxNotebook");
 break;
}
case wxNotebook_AddPage: { // wxNotebook::AddPage
 bool bSelect=false;
 int imageId=-1;
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPage(page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxNotebook_AdvanceSelection: { // wxNotebook::AdvanceSelection
 bool forward=true;
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 forward = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AdvanceSelection(forward);
 break;
}
case wxNotebook_AssignImageList: { // wxNotebook::AssignImageList
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AssignImageList(imageList);
 break;
}
case wxNotebook_Create: { // wxNotebook::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxNotebook_DeleteAllPages: { // wxNotebook::DeleteAllPages
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteAllPages();
 rt.addBool(Result);
 break;
}
case wxNotebook_DeletePage: { // wxNotebook::DeletePage
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * nPage = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeletePage(*nPage);
 rt.addBool(Result);
 break;
}
case wxNotebook_RemovePage: { // wxNotebook::RemovePage
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * nPage = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RemovePage(*nPage);
 rt.addBool(Result);
 break;
}
case wxNotebook_GetCurrentPage: { // wxNotebook::GetCurrentPage
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetCurrentPage();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxNotebook_GetImageList: { // wxNotebook::GetImageList
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImageList * Result = (wxImageList*)This->GetImageList();
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxNotebook_GetPage: { // wxNotebook::GetPage
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetPage(*n);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxNotebook_GetPageCount: { // wxNotebook::GetPageCount
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetPageCount();
 rt.addInt(Result);
 break;
}
case wxNotebook_GetPageImage: { // wxNotebook::GetPageImage
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * nPage = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPageImage(*nPage);
 rt.addInt(Result);
 break;
}
case wxNotebook_GetPageText: { // wxNotebook::GetPageText
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * nPage = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPageText(*nPage);
 rt.add(Result);
 break;
}
case wxNotebook_GetRowCount: { // wxNotebook::GetRowCount
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRowCount();
 rt.addInt(Result);
 break;
}
case wxNotebook_GetSelection: { // wxNotebook::GetSelection
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxNotebook_GetThemeBackgroundColour: { // wxNotebook::GetThemeBackgroundColour
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetThemeBackgroundColour();
 rt.add(Result);
 break;
}
case wxNotebook_HitTest: { // wxNotebook::HitTest
 long flags;
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 int Result = This->HitTest(pt,&flags);
 rt.addInt(Result);
 rt.addInt(flags);
 rt.addTupleCount(2);
 break;
}
case wxNotebook_InsertPage: { // wxNotebook::InsertPage
 bool bSelect=false;
 int imageId=-1;
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * position = (int *) bp; bp += 4;
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * strTextLen = (int *) bp; bp += 4;
 wxString strText = wxString(bp, wxConvUTF8);
 bp += *strTextLen+((8-((0+ *strTextLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertPage(*position,win,strText,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxNotebook_SetImageList: { // wxNotebook::SetImageList
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetImageList(imageList);
 break;
}
case wxNotebook_SetPadding: { // wxNotebook::SetPadding
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * paddingW = (int *) bp; bp += 4;
 int * paddingH = (int *) bp; bp += 4;
 wxSize padding = wxSize(*paddingW,*paddingH);
 if(!This) throw wxe_badarg(0);
 This->SetPadding(padding);
 break;
}
case wxNotebook_SetPageSize: { // wxNotebook::SetPageSize
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetPageSize(size);
 break;
}
case wxNotebook_SetPageImage: { // wxNotebook::SetPageImage
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * nPage = (int *) bp; bp += 4;
 int * nImage = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageImage(*nPage,*nImage);
 rt.addBool(Result);
 break;
}
case wxNotebook_SetPageText: { // wxNotebook::SetPageText
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * nPage = (int *) bp; bp += 4;
 int * strTextLen = (int *) bp; bp += 4;
 wxString strText = wxString(bp, wxConvUTF8);
 bp += *strTextLen+((8-((4+ *strTextLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageText(*nPage,strText);
 rt.addBool(Result);
 break;
}
case wxNotebook_SetSelection: { // wxNotebook::SetSelection
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * nPage = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->SetSelection(*nPage);
 rt.addInt(Result);
 break;
}
case wxNotebook_ChangeSelection: { // wxNotebook::ChangeSelection
 wxNotebook *This = (wxNotebook *) getPtr(bp,memenv); bp += 4;
 int * nPage = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->ChangeSelection(*nPage);
 rt.addInt(Result);
 break;
}
case wxChoicebook_new_0: { // wxChoicebook::wxChoicebook
 wxChoicebook * Result = new EwxChoicebook();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxChoicebook");
 break;
}
case wxChoicebook_new_3: { // wxChoicebook::wxChoicebook
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxChoicebook * Result = new EwxChoicebook(parent,*id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxChoicebook");
 break;
}
case wxChoicebook_AddPage: { // wxChoicebook::AddPage
 bool bSelect=false;
 int imageId=-1;
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPage(page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxChoicebook_AdvanceSelection: { // wxChoicebook::AdvanceSelection
 bool forward=true;
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 forward = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AdvanceSelection(forward);
 break;
}
case wxChoicebook_AssignImageList: { // wxChoicebook::AssignImageList
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AssignImageList(imageList);
 break;
}
case wxChoicebook_Create: { // wxChoicebook::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxChoicebook_DeleteAllPages: { // wxChoicebook::DeleteAllPages
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteAllPages();
 rt.addBool(Result);
 break;
}
case wxChoicebook_DeletePage: { // wxChoicebook::DeletePage
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeletePage(*n);
 rt.addBool(Result);
 break;
}
case wxChoicebook_RemovePage: { // wxChoicebook::RemovePage
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RemovePage(*n);
 rt.addBool(Result);
 break;
}
case wxChoicebook_GetCurrentPage: { // wxChoicebook::GetCurrentPage
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetCurrentPage();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxChoicebook_GetImageList: { // wxChoicebook::GetImageList
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImageList * Result = (wxImageList*)This->GetImageList();
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxChoicebook_GetPage: { // wxChoicebook::GetPage
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetPage(*n);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxChoicebook_GetPageCount: { // wxChoicebook::GetPageCount
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetPageCount();
 rt.addInt(Result);
 break;
}
case wxChoicebook_GetPageImage: { // wxChoicebook::GetPageImage
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPageImage(*n);
 rt.addInt(Result);
 break;
}
case wxChoicebook_GetPageText: { // wxChoicebook::GetPageText
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPageText(*n);
 rt.add(Result);
 break;
}
case wxChoicebook_GetSelection: { // wxChoicebook::GetSelection
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxChoicebook_HitTest: { // wxChoicebook::HitTest
 long flags;
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 int Result = This->HitTest(pt,&flags);
 rt.addInt(Result);
 rt.addInt(flags);
 rt.addTupleCount(2);
 break;
}
case wxChoicebook_InsertPage: { // wxChoicebook::InsertPage
 bool bSelect=false;
 int imageId=-1;
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertPage(*n,page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxChoicebook_SetImageList: { // wxChoicebook::SetImageList
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetImageList(imageList);
 break;
}
case wxChoicebook_SetPageSize: { // wxChoicebook::SetPageSize
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetPageSize(size);
 break;
}
case wxChoicebook_SetPageImage: { // wxChoicebook::SetPageImage
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 int * imageId = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageImage(*n,*imageId);
 rt.addBool(Result);
 break;
}
case wxChoicebook_SetPageText: { // wxChoicebook::SetPageText
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 int * strTextLen = (int *) bp; bp += 4;
 wxString strText = wxString(bp, wxConvUTF8);
 bp += *strTextLen+((8-((4+ *strTextLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageText(*n,strText);
 rt.addBool(Result);
 break;
}
case wxChoicebook_SetSelection: { // wxChoicebook::SetSelection
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->SetSelection(*n);
 rt.addInt(Result);
 break;
}
case wxChoicebook_ChangeSelection: { // wxChoicebook::ChangeSelection
 wxChoicebook *This = (wxChoicebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->ChangeSelection(*n);
 rt.addInt(Result);
 break;
}
case wxToolbook_new_0: { // wxToolbook::wxToolbook
 wxToolbook * Result = new EwxToolbook();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxToolbook");
 break;
}
case wxToolbook_new_3: { // wxToolbook::wxToolbook
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxToolbook * Result = new EwxToolbook(parent,*id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxToolbook");
 break;
}
case wxToolbook_AddPage: { // wxToolbook::AddPage
 bool bSelect=false;
 int imageId=-1;
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPage(page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxToolbook_AdvanceSelection: { // wxToolbook::AdvanceSelection
 bool forward=true;
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 forward = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AdvanceSelection(forward);
 break;
}
case wxToolbook_AssignImageList: { // wxToolbook::AssignImageList
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AssignImageList(imageList);
 break;
}
case wxToolbook_Create: { // wxToolbook::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxToolbook_DeleteAllPages: { // wxToolbook::DeleteAllPages
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteAllPages();
 rt.addBool(Result);
 break;
}
case wxToolbook_DeletePage: { // wxToolbook::DeletePage
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeletePage(*n);
 rt.addBool(Result);
 break;
}
case wxToolbook_RemovePage: { // wxToolbook::RemovePage
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RemovePage(*n);
 rt.addBool(Result);
 break;
}
case wxToolbook_GetCurrentPage: { // wxToolbook::GetCurrentPage
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetCurrentPage();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxToolbook_GetImageList: { // wxToolbook::GetImageList
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImageList * Result = (wxImageList*)This->GetImageList();
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxToolbook_GetPage: { // wxToolbook::GetPage
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetPage(*n);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxToolbook_GetPageCount: { // wxToolbook::GetPageCount
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetPageCount();
 rt.addInt(Result);
 break;
}
case wxToolbook_GetPageImage: { // wxToolbook::GetPageImage
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPageImage(*n);
 rt.addInt(Result);
 break;
}
case wxToolbook_GetPageText: { // wxToolbook::GetPageText
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPageText(*n);
 rt.add(Result);
 break;
}
case wxToolbook_GetSelection: { // wxToolbook::GetSelection
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxToolbook_HitTest: { // wxToolbook::HitTest
 long flags;
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 int Result = This->HitTest(pt,&flags);
 rt.addInt(Result);
 rt.addInt(flags);
 rt.addTupleCount(2);
 break;
}
case wxToolbook_InsertPage: { // wxToolbook::InsertPage
 bool bSelect=false;
 int imageId=-1;
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertPage(*n,page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxToolbook_SetImageList: { // wxToolbook::SetImageList
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetImageList(imageList);
 break;
}
case wxToolbook_SetPageSize: { // wxToolbook::SetPageSize
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetPageSize(size);
 break;
}
case wxToolbook_SetPageImage: { // wxToolbook::SetPageImage
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 int * imageId = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageImage(*n,*imageId);
 rt.addBool(Result);
 break;
}
case wxToolbook_SetPageText: { // wxToolbook::SetPageText
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 int * strTextLen = (int *) bp; bp += 4;
 wxString strText = wxString(bp, wxConvUTF8);
 bp += *strTextLen+((8-((4+ *strTextLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageText(*n,strText);
 rt.addBool(Result);
 break;
}
case wxToolbook_SetSelection: { // wxToolbook::SetSelection
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->SetSelection(*n);
 rt.addInt(Result);
 break;
}
case wxToolbook_ChangeSelection: { // wxToolbook::ChangeSelection
 wxToolbook *This = (wxToolbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->ChangeSelection(*n);
 rt.addInt(Result);
 break;
}
case wxListbook_new_0: { // wxListbook::wxListbook
 wxListbook * Result = new EwxListbook();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListbook");
 break;
}
case wxListbook_new_3: { // wxListbook::wxListbook
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxListbook * Result = new EwxListbook(parent,*id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxListbook");
 break;
}
case wxListbook_AddPage: { // wxListbook::AddPage
 bool bSelect=false;
 int imageId=-1;
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPage(page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxListbook_AdvanceSelection: { // wxListbook::AdvanceSelection
 bool forward=true;
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 forward = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AdvanceSelection(forward);
 break;
}
case wxListbook_AssignImageList: { // wxListbook::AssignImageList
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AssignImageList(imageList);
 break;
}
case wxListbook_Create: { // wxListbook::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxListbook_DeleteAllPages: { // wxListbook::DeleteAllPages
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteAllPages();
 rt.addBool(Result);
 break;
}
case wxListbook_DeletePage: { // wxListbook::DeletePage
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeletePage(*n);
 rt.addBool(Result);
 break;
}
case wxListbook_RemovePage: { // wxListbook::RemovePage
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RemovePage(*n);
 rt.addBool(Result);
 break;
}
case wxListbook_GetCurrentPage: { // wxListbook::GetCurrentPage
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetCurrentPage();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxListbook_GetImageList: { // wxListbook::GetImageList
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImageList * Result = (wxImageList*)This->GetImageList();
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxListbook_GetPage: { // wxListbook::GetPage
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetPage(*n);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxListbook_GetPageCount: { // wxListbook::GetPageCount
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetPageCount();
 rt.addInt(Result);
 break;
}
case wxListbook_GetPageImage: { // wxListbook::GetPageImage
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPageImage(*n);
 rt.addInt(Result);
 break;
}
case wxListbook_GetPageText: { // wxListbook::GetPageText
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPageText(*n);
 rt.add(Result);
 break;
}
case wxListbook_GetSelection: { // wxListbook::GetSelection
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxListbook_HitTest: { // wxListbook::HitTest
 long flags;
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 int Result = This->HitTest(pt,&flags);
 rt.addInt(Result);
 rt.addInt(flags);
 rt.addTupleCount(2);
 break;
}
case wxListbook_InsertPage: { // wxListbook::InsertPage
 bool bSelect=false;
 int imageId=-1;
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertPage(*n,page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxListbook_SetImageList: { // wxListbook::SetImageList
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetImageList(imageList);
 break;
}
case wxListbook_SetPageSize: { // wxListbook::SetPageSize
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetPageSize(size);
 break;
}
case wxListbook_SetPageImage: { // wxListbook::SetPageImage
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 int * imageId = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageImage(*n,*imageId);
 rt.addBool(Result);
 break;
}
case wxListbook_SetPageText: { // wxListbook::SetPageText
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 int * strTextLen = (int *) bp; bp += 4;
 wxString strText = wxString(bp, wxConvUTF8);
 bp += *strTextLen+((8-((4+ *strTextLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageText(*n,strText);
 rt.addBool(Result);
 break;
}
case wxListbook_SetSelection: { // wxListbook::SetSelection
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->SetSelection(*n);
 rt.addInt(Result);
 break;
}
case wxListbook_ChangeSelection: { // wxListbook::ChangeSelection
 wxListbook *This = (wxListbook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->ChangeSelection(*n);
 rt.addInt(Result);
 break;
}
case wxTreebook_new_0: { // wxTreebook::wxTreebook
 wxTreebook * Result = new EwxTreebook();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTreebook");
 break;
}
case wxTreebook_new_3: { // wxTreebook::wxTreebook
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxBK_DEFAULT;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxTreebook * Result = new EwxTreebook(parent,*id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTreebook");
 break;
}
case wxTreebook_AddPage: { // wxTreebook::AddPage
 bool bSelect=false;
 int imageId=wxNOT_FOUND;
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPage(page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxTreebook_AdvanceSelection: { // wxTreebook::AdvanceSelection
 bool forward=true;
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 forward = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->AdvanceSelection(forward);
 break;
}
case wxTreebook_AssignImageList: { // wxTreebook::AssignImageList
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AssignImageList(imageList);
 break;
}
case wxTreebook_Create: { // wxTreebook::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxBK_DEFAULT;
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxTreebook_DeleteAllPages: { // wxTreebook::DeleteAllPages
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeleteAllPages();
 rt.addBool(Result);
 break;
}
case wxTreebook_DeletePage: { // wxTreebook::DeletePage
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeletePage(*pos);
 rt.addBool(Result);
 break;
}
case wxTreebook_RemovePage: { // wxTreebook::RemovePage
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RemovePage(*n);
 rt.addBool(Result);
 break;
}
case wxTreebook_GetCurrentPage: { // wxTreebook::GetCurrentPage
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetCurrentPage();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxTreebook_GetImageList: { // wxTreebook::GetImageList
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImageList * Result = (wxImageList*)This->GetImageList();
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxTreebook_GetPage: { // wxTreebook::GetPage
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetPage(*n);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxTreebook_GetPageCount: { // wxTreebook::GetPageCount
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetPageCount();
 rt.addInt(Result);
 break;
}
case wxTreebook_GetPageImage: { // wxTreebook::GetPageImage
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPageImage(*n);
 rt.addInt(Result);
 break;
}
case wxTreebook_GetPageText: { // wxTreebook::GetPageText
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPageText(*n);
 rt.add(Result);
 break;
}
case wxTreebook_GetSelection: { // wxTreebook::GetSelection
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxTreebook_ExpandNode: { // wxTreebook::ExpandNode
 bool expand=true;
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 expand = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ExpandNode(*pos,expand);
 rt.addBool(Result);
 break;
}
case wxTreebook_IsNodeExpanded: { // wxTreebook::IsNodeExpanded
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsNodeExpanded(*pos);
 rt.addBool(Result);
 break;
}
case wxTreebook_HitTest: { // wxTreebook::HitTest
 long flags;
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 int Result = This->HitTest(pt,&flags);
 rt.addInt(Result);
 rt.addInt(flags);
 rt.addTupleCount(2);
 break;
}
case wxTreebook_InsertPage: { // wxTreebook::InsertPage
 bool bSelect=false;
 int imageId=wxNOT_FOUND;
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertPage(*pos,page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxTreebook_InsertSubPage: { // wxTreebook::InsertSubPage
 bool bSelect=false;
 int imageId=wxNOT_FOUND;
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bSelect = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 imageId = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertSubPage(*pos,page,text,bSelect,imageId);
 rt.addBool(Result);
 break;
}
case wxTreebook_SetImageList: { // wxTreebook::SetImageList
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetImageList(imageList);
 break;
}
case wxTreebook_SetPageSize: { // wxTreebook::SetPageSize
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetPageSize(size);
 break;
}
case wxTreebook_SetPageImage: { // wxTreebook::SetPageImage
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 int * imageId = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageImage(*n,*imageId);
 rt.addBool(Result);
 break;
}
case wxTreebook_SetPageText: { // wxTreebook::SetPageText
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 int * strTextLen = (int *) bp; bp += 4;
 wxString strText = wxString(bp, wxConvUTF8);
 bp += *strTextLen+((8-((4+ *strTextLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageText(*n,strText);
 rt.addBool(Result);
 break;
}
case wxTreebook_SetSelection: { // wxTreebook::SetSelection
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->SetSelection(*n);
 rt.addInt(Result);
 break;
}
case wxTreebook_ChangeSelection: { // wxTreebook::ChangeSelection
 wxTreebook *This = (wxTreebook *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->ChangeSelection(*n);
 rt.addInt(Result);
 break;
}
case wxTreeCtrl_new_2: { // wxTreeCtrl::wxTreeCtrl
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxTR_HAS_BUTTONS|wxTR_LINES_AT_ROOT;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxTreeCtrl * Result = new EwxTreeCtrl(parent,id,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTreeCtrl");
 break;
}
case wxTreeCtrl_new_0: { // wxTreeCtrl::wxTreeCtrl
 wxTreeCtrl * Result = new EwxTreeCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTreeCtrl");
 break;
}
case wxTreeCtrl_AddRoot: { // wxTreeCtrl::AddRoot
 int image=-1;
 int selectedImage=-1;
 wxETreeItemData * data= NULL;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 image = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 selectedImage = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 data = new wxETreeItemData(Ecmd.bin[0].size, Ecmd.bin[0].base);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->AddRoot(text,image,selectedImage,data);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_AppendItem: { // wxTreeCtrl::AppendItem
 int image=-1;
 int selectedImage=-1;
 wxETreeItemData * data= NULL;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId parent = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 image = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 selectedImage = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 data = new wxETreeItemData(Ecmd.bin[0].size, Ecmd.bin[0].base);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->AppendItem(parent,text,image,selectedImage,data);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_AssignImageList: { // wxTreeCtrl::AssignImageList
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AssignImageList(imageList);
 break;
}
case wxTreeCtrl_AssignStateImageList: { // wxTreeCtrl::AssignStateImageList
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AssignStateImageList(imageList);
 break;
}
case wxTreeCtrl_Collapse: { // wxTreeCtrl::Collapse
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Collapse(item);
 break;
}
case wxTreeCtrl_CollapseAndReset: { // wxTreeCtrl::CollapseAndReset
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->CollapseAndReset(item);
 break;
}
case wxTreeCtrl_Create: { // wxTreeCtrl::Create
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxTR_HAS_BUTTONS|wxTR_LINES_AT_ROOT;
 const wxValidator * validator= &wxDefaultValidator;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,id,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxTreeCtrl_Delete: { // wxTreeCtrl::Delete
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Delete(item);
 break;
}
case wxTreeCtrl_DeleteAllItems: { // wxTreeCtrl::DeleteAllItems
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DeleteAllItems();
 break;
}
case wxTreeCtrl_DeleteChildren: { // wxTreeCtrl::DeleteChildren
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->DeleteChildren(item);
 break;
}
case wxTreeCtrl_EditLabel: { // wxTreeCtrl::EditLabel
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTextCtrl * Result = (wxTextCtrl*)This->EditLabel(item);
 rt.addRef(getRef((void *)Result,memenv), "wxTextCtrl");
 break;
}
case wxTreeCtrl_EnsureVisible: { // wxTreeCtrl::EnsureVisible
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->EnsureVisible(item);
 break;
}
case wxTreeCtrl_Expand: { // wxTreeCtrl::Expand
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Expand(item);
 break;
}
case wxTreeCtrl_GetBoundingRect: { // wxTreeCtrl::GetBoundingRect
 wxRect rect;
 bool textOnly=false;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 textOnly = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetBoundingRect(item,rect,textOnly);
 rt.addBool(Result);
 rt.add(rect);
 rt.addTupleCount(2);
 break;
}
case wxTreeCtrl_GetChildrenCount: { // wxTreeCtrl::GetChildrenCount
 bool recursively=true;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 recursively = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetChildrenCount(item,recursively);
 rt.addInt(Result);
 break;
}
case wxTreeCtrl_GetCount: { // wxTreeCtrl::GetCount
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCount();
 rt.addUint(Result);
 break;
}
case wxTreeCtrl_GetEditControl: { // wxTreeCtrl::GetEditControl
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTextCtrl * Result = (wxTextCtrl*)This->GetEditControl();
 rt.addRef(getRef((void *)Result,memenv), "wxTextCtrl");
 break;
}
case wxTreeCtrl_GetFirstChild: { // wxTreeCtrl::GetFirstChild
 wxTreeItemIdValue cookie;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetFirstChild(item,cookie);
 rt.add((wxUIntPtr *) Result.m_pItem);
 rt.add((wxUIntPtr *) cookie);
 rt.addTupleCount(2);
 break;
}
case wxTreeCtrl_GetNextChild: { // wxTreeCtrl::GetNextChild
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 wxTreeItemIdValue cookie = (wxTreeItemIdValue) * (wxUint64 *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetNextChild(item,cookie);
 rt.add((wxUIntPtr *) Result.m_pItem);
 rt.add((wxUIntPtr *) cookie);
 rt.addTupleCount(2);
 break;
}
case wxTreeCtrl_GetFirstVisibleItem: { // wxTreeCtrl::GetFirstVisibleItem
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetFirstVisibleItem();
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetImageList: { // wxTreeCtrl::GetImageList
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImageList * Result = (wxImageList*)This->GetImageList();
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxTreeCtrl_GetIndent: { // wxTreeCtrl::GetIndent
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetIndent();
 rt.addUint(Result);
 break;
}
case wxTreeCtrl_GetItemBackgroundColour: { // wxTreeCtrl::GetItemBackgroundColour
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetItemBackgroundColour(item);
 rt.add(Result);
 break;
}
case wxTreeCtrl_GetItemData: { // wxTreeCtrl::GetItemData
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxETreeItemData * Result = (wxETreeItemData*)This->GetItemData(item);
 rt.addExt2Term(Result);
 break;
}
case wxTreeCtrl_GetItemFont: { // wxTreeCtrl::GetItemFont
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetItemFont(item)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxTreeCtrl_GetItemImage_1: { // wxTreeCtrl::GetItemImage
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetItemImage(item);
 rt.addInt(Result);
 break;
}
case wxTreeCtrl_GetItemImage_2: { // wxTreeCtrl::GetItemImage
 wxTreeItemIcon which=wxTreeItemIcon_Normal;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
which = *(wxTreeItemIcon *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 int Result = This->GetItemImage(item,which);
 rt.addInt(Result);
 break;
}
case wxTreeCtrl_GetItemText: { // wxTreeCtrl::GetItemText
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetItemText(item);
 rt.add(Result);
 break;
}
case wxTreeCtrl_GetItemTextColour: { // wxTreeCtrl::GetItemTextColour
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetItemTextColour(item);
 rt.add(Result);
 break;
}
case wxTreeCtrl_GetLastChild: { // wxTreeCtrl::GetLastChild
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetLastChild(item);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetNextSibling: { // wxTreeCtrl::GetNextSibling
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetNextSibling(item);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetNextVisible: { // wxTreeCtrl::GetNextVisible
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetNextVisible(item);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetItemParent: { // wxTreeCtrl::GetItemParent
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetItemParent(item);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetPrevSibling: { // wxTreeCtrl::GetPrevSibling
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetPrevSibling(item);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetPrevVisible: { // wxTreeCtrl::GetPrevVisible
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetPrevVisible(item);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetRootItem: { // wxTreeCtrl::GetRootItem
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetRootItem();
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetSelection: { // wxTreeCtrl::GetSelection
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->GetSelection();
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_GetSelections: { // wxTreeCtrl::GetSelections
 wxArrayTreeItemIds val;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetSelections(val);
 rt.addInt(Result);
 for(unsigned int i=0; i < val.GetCount(); i++) {
    rt.add((wxUIntPtr *)val[i].m_pItem);}
 rt.endList(val.GetCount());
 rt.addTupleCount(2);
 break;
}
case wxTreeCtrl_GetStateImageList: { // wxTreeCtrl::GetStateImageList
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxImageList * Result = (wxImageList*)This->GetStateImageList();
 rt.addRef(getRef((void *)Result,memenv), "wxImageList");
 break;
}
case wxTreeCtrl_HitTest: { // wxTreeCtrl::HitTest
 int flags;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 int * pointX = (int *) bp; bp += 4;
 int * pointY = (int *) bp; bp += 4;
 wxPoint point = wxPoint(*pointX,*pointY);
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->HitTest(point,flags);
 rt.add((wxUIntPtr *) Result.m_pItem);
 rt.addInt(flags);
 rt.addTupleCount(2);
 break;
}
case wxTreeCtrl_InsertItem: { // wxTreeCtrl::InsertItem
 int image=-1;
 int selImage=-1;
 wxETreeItemData * data= NULL;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId parent = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 int * pos = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 image = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 selImage = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 data = new wxETreeItemData(Ecmd.bin[0].size, Ecmd.bin[0].base);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->InsertItem(parent,*pos,text,image,selImage,data);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_IsBold: { // wxTreeCtrl::IsBold
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsBold(item);
 rt.addBool(Result);
 break;
}
case wxTreeCtrl_IsExpanded: { // wxTreeCtrl::IsExpanded
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsExpanded(item);
 rt.addBool(Result);
 break;
}
case wxTreeCtrl_IsSelected: { // wxTreeCtrl::IsSelected
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSelected(item);
 rt.addBool(Result);
 break;
}
case wxTreeCtrl_IsVisible: { // wxTreeCtrl::IsVisible
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsVisible(item);
 rt.addBool(Result);
 break;
}
case wxTreeCtrl_ItemHasChildren: { // wxTreeCtrl::ItemHasChildren
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ItemHasChildren(item);
 rt.addBool(Result);
 break;
}

case wxTreeCtrl_IsTreeItemIdOk: { // wxTreeCtrl::IsTreeItemIdOk
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 bool Result = item.IsOk();
 rt.addBool(Result);
 break;
}
case wxTreeCtrl_PrependItem: { // wxTreeCtrl::PrependItem
 int image=-1;
 int selectedImage=-1;
 wxETreeItemData * data= NULL;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId parent = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 image = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 selectedImage = (int)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 data = new wxETreeItemData(Ecmd.bin[0].size, Ecmd.bin[0].base);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxTreeItemId Result = This->PrependItem(parent,text,image,selectedImage,data);
 rt.add((wxUIntPtr *) Result.m_pItem);
 break;
}
case wxTreeCtrl_ScrollTo: { // wxTreeCtrl::ScrollTo
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->ScrollTo(item);
 break;
}
case wxTreeCtrl_SelectItem_1: { // wxTreeCtrl::SelectItem
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->SelectItem(item);
 break;
}
case wxTreeCtrl_SelectItem_2: { // wxTreeCtrl::SelectItem
 bool select=true;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 select = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SelectItem(item,select);
 break;
}
case wxTreeCtrl_SetIndent: { // wxTreeCtrl::SetIndent
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 unsigned int * indent = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetIndent(*indent);
 break;
}
case wxTreeCtrl_SetImageList: { // wxTreeCtrl::SetImageList
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetImageList(imageList);
 break;
}
case wxTreeCtrl_SetItemBackgroundColour: { // wxTreeCtrl::SetItemBackgroundColour
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetItemBackgroundColour(item,col);
 break;
}
case wxTreeCtrl_SetItemBold: { // wxTreeCtrl::SetItemBold
 bool bold=true;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 bold = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetItemBold(item,bold);
 break;
}
case wxTreeCtrl_SetItemData: { // wxTreeCtrl::SetItemData
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 wxETreeItemData * data =  new wxETreeItemData(Ecmd.bin[0].size, Ecmd.bin[0].base);
 if(!This) throw wxe_badarg(0);
 This->SetItemData(item,data);
 break;
}
case wxTreeCtrl_SetItemDropHighlight: { // wxTreeCtrl::SetItemDropHighlight
 bool highlight=true;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 highlight = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetItemDropHighlight(item,highlight);
 break;
}
case wxTreeCtrl_SetItemFont: { // wxTreeCtrl::SetItemFont
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetItemFont(item,*font);
 break;
}
case wxTreeCtrl_SetItemHasChildren: { // wxTreeCtrl::SetItemHasChildren
 bool has=true;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 has = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetItemHasChildren(item,has);
 break;
}
case wxTreeCtrl_SetItemImage_2: { // wxTreeCtrl::SetItemImage
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 int * image = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetItemImage(item,*image);
 break;
}
case wxTreeCtrl_SetItemImage_3: { // wxTreeCtrl::SetItemImage
 wxTreeItemIcon which=wxTreeItemIcon_Normal;
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 int * image = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
which = *(wxTreeItemIcon *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetItemImage(item,*image,which);
 break;
}
case wxTreeCtrl_SetItemText: { // wxTreeCtrl::SetItemText
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetItemText(item,text);
 break;
}
case wxTreeCtrl_SetItemTextColour: { // wxTreeCtrl::SetItemTextColour
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetItemTextColour(item,col);
 break;
}
case wxTreeCtrl_SetStateImageList: { // wxTreeCtrl::SetStateImageList
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 wxImageList *imageList = (wxImageList *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStateImageList(imageList);
 break;
}
case wxTreeCtrl_SetWindowStyle: { // wxTreeCtrl::SetWindowStyle
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 const int * styles = (const int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWindowStyle(*styles);
 break;
}
case wxTreeCtrl_SortChildren: { // wxTreeCtrl::SortChildren
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->SortChildren(item);
 break;
}
case wxTreeCtrl_Toggle: { // wxTreeCtrl::Toggle
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->Toggle(item);
 break;
}
case wxTreeCtrl_ToggleItemSelection: { // wxTreeCtrl::ToggleItemSelection
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->ToggleItemSelection(item);
 break;
}
case wxTreeCtrl_Unselect: { // wxTreeCtrl::Unselect
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Unselect();
 break;
}
case wxTreeCtrl_UnselectAll: { // wxTreeCtrl::UnselectAll
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->UnselectAll();
 break;
}
case wxTreeCtrl_UnselectItem: { // wxTreeCtrl::UnselectItem
 wxTreeCtrl *This = (wxTreeCtrl *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 wxTreeItemId item = wxTreeItemId((void *) *(wxUint64 *) bp); bp += 8;
 if(!This) throw wxe_badarg(0);
 This->UnselectItem(item);
 break;
}
case wxScrollBar_new_0: { // wxScrollBar::wxScrollBar
 wxScrollBar * Result = new EwxScrollBar();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxScrollBar");
 break;
}
case wxScrollBar_new_3: { // wxScrollBar::wxScrollBar
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSB_HORIZONTAL;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxScrollBar * Result = new EwxScrollBar(parent,*id,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxScrollBar");
 break;
}
case wxScrollBar_Create: { // wxScrollBar::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSB_HORIZONTAL;
 const wxValidator * validator= &wxDefaultValidator;
 wxScrollBar *This = (wxScrollBar *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxScrollBar_GetRange: { // wxScrollBar::GetRange
 wxScrollBar *This = (wxScrollBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRange();
 rt.addInt(Result);
 break;
}
case wxScrollBar_GetPageSize: { // wxScrollBar::GetPageSize
 wxScrollBar *This = (wxScrollBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPageSize();
 rt.addInt(Result);
 break;
}
case wxScrollBar_GetThumbPosition: { // wxScrollBar::GetThumbPosition
 wxScrollBar *This = (wxScrollBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetThumbPosition();
 rt.addInt(Result);
 break;
}
case wxScrollBar_GetThumbSize: { // wxScrollBar::GetThumbSize
 wxScrollBar *This = (wxScrollBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetThumbSize();
 rt.addInt(Result);
 break;
}
case wxScrollBar_SetThumbPosition: { // wxScrollBar::SetThumbPosition
 wxScrollBar *This = (wxScrollBar *) getPtr(bp,memenv); bp += 4;
 int * viewStart = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetThumbPosition(*viewStart);
 break;
}
case wxScrollBar_SetScrollbar: { // wxScrollBar::SetScrollbar
 bool refresh=true;
 wxScrollBar *This = (wxScrollBar *) getPtr(bp,memenv); bp += 4;
 int * position = (int *) bp; bp += 4;
 int * thumbSize = (int *) bp; bp += 4;
 int * range = (int *) bp; bp += 4;
 int * pageSize = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 refresh = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetScrollbar(*position,*thumbSize,*range,*pageSize,refresh);
 break;
}
case wxSpinButton_new_2: { // wxSpinButton::wxSpinButton
 wxWindowID id=-1;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSP_VERTICAL;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxSpinButton * Result = new EwxSpinButton(parent,id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSpinButton");
 break;
}
case wxSpinButton_new_0: { // wxSpinButton::wxSpinButton
 wxSpinButton * Result = new EwxSpinButton();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSpinButton");
 break;
}
case wxSpinButton_Create: { // wxSpinButton::Create
 wxWindowID id=-1;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSP_VERTICAL;
 wxSpinButton *This = (wxSpinButton *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxSpinButton_GetMax: { // wxSpinButton::GetMax
 wxSpinButton *This = (wxSpinButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMax();
 rt.addInt(Result);
 break;
}
case wxSpinButton_GetMin: { // wxSpinButton::GetMin
 wxSpinButton *This = (wxSpinButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMin();
 rt.addInt(Result);
 break;
}
case wxSpinButton_GetValue: { // wxSpinButton::GetValue
 wxSpinButton *This = (wxSpinButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetValue();
 rt.addInt(Result);
 break;
}
case wxSpinButton_SetRange: { // wxSpinButton::SetRange
 wxSpinButton *This = (wxSpinButton *) getPtr(bp,memenv); bp += 4;
 int * minVal = (int *) bp; bp += 4;
 int * maxVal = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRange(*minVal,*maxVal);
 break;
}
case wxSpinButton_SetValue: { // wxSpinButton::SetValue
 wxSpinButton *This = (wxSpinButton *) getPtr(bp,memenv); bp += 4;
 int * value = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetValue(*value);
 break;
}
case wxSpinCtrl_new_0: { // wxSpinCtrl::wxSpinCtrl
 wxSpinCtrl * Result = new EwxSpinCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSpinCtrl");
 break;
}
case wxSpinCtrl_new_2: { // wxSpinCtrl::wxSpinCtrl
 wxWindowID id=wxID_ANY;
 wxString value= wxEmptyString;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSP_ARROW_KEYS;
 int min=0;
 int max=100;
 int initial=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 6: {bp += 4;
 min = (int)*(int *) bp; bp += 4;
  } break;
  case 7: {bp += 4;
 max = (int)*(int *) bp; bp += 4;
  } break;
  case 8: {bp += 4;
 initial = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxSpinCtrl * Result = new EwxSpinCtrl(parent,id,value,pos,size,style,min,max,initial);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSpinCtrl");
 break;
}
case wxSpinCtrl_Create: { // wxSpinCtrl::Create
 wxWindowID id=wxID_ANY;
 wxString value= wxEmptyString;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSP_ARROW_KEYS;
 int min=0;
 int max=100;
 int initial=0;
 wxSpinCtrl *This = (wxSpinCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 6: {bp += 4;
 min = (int)*(int *) bp; bp += 4;
  } break;
  case 7: {bp += 4;
 max = (int)*(int *) bp; bp += 4;
  } break;
  case 8: {bp += 4;
 initial = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,id,value,pos,size,style,min,max,initial);
 rt.addBool(Result);
 break;
}
case wxSpinCtrl_SetValue_1_1: { // wxSpinCtrl::SetValue
 wxSpinCtrl *This = (wxSpinCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetValue(text);
 break;
}
case wxSpinCtrl_SetValue_1_0: { // wxSpinCtrl::SetValue
 wxSpinCtrl *This = (wxSpinCtrl *) getPtr(bp,memenv); bp += 4;
 int * value = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetValue(*value);
 break;
}
case wxSpinCtrl_GetValue: { // wxSpinCtrl::GetValue
 wxSpinCtrl *This = (wxSpinCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetValue();
 rt.addInt(Result);
 break;
}
case wxSpinCtrl_SetRange: { // wxSpinCtrl::SetRange
 wxSpinCtrl *This = (wxSpinCtrl *) getPtr(bp,memenv); bp += 4;
 int * minVal = (int *) bp; bp += 4;
 int * maxVal = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRange(*minVal,*maxVal);
 break;
}
case wxSpinCtrl_SetSelection: { // wxSpinCtrl::SetSelection
 wxSpinCtrl *This = (wxSpinCtrl *) getPtr(bp,memenv); bp += 4;
 int * from = (int *) bp; bp += 4;
 int * to = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*from,*to);
 break;
}
case wxSpinCtrl_GetMin: { // wxSpinCtrl::GetMin
 wxSpinCtrl *This = (wxSpinCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMin();
 rt.addInt(Result);
 break;
}
case wxSpinCtrl_GetMax: { // wxSpinCtrl::GetMax
 wxSpinCtrl *This = (wxSpinCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMax();
 rt.addInt(Result);
 break;
}
case wxStaticText_new_0: { // wxStaticText::wxStaticText
 wxStaticText * Result = new EwxStaticText();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticText");
 break;
}
case wxStaticText_new_4: { // wxStaticText::wxStaticText
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxStaticText * Result = new EwxStaticText(parent,*id,label,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticText");
 break;
}
case wxStaticText_Create: { // wxStaticText::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxStaticText *This = (wxStaticText *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,label,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxStaticText_GetLabel: { // wxStaticText::GetLabel
 wxStaticText *This = (wxStaticText *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLabel();
 rt.add(Result);
 break;
}
case wxStaticText_SetLabel: { // wxStaticText::SetLabel
 wxStaticText *This = (wxStaticText *) getPtr(bp,memenv); bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetLabel(label);
 break;
}
case wxStaticText_Wrap: { // wxStaticText::Wrap
 wxStaticText *This = (wxStaticText *) getPtr(bp,memenv); bp += 4;
 int * width = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Wrap(*width);
 break;
}
case wxStaticBitmap_new_0: { // wxStaticBitmap::wxStaticBitmap
 wxStaticBitmap * Result = new EwxStaticBitmap();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticBitmap");
 break;
}
case wxStaticBitmap_new_4: { // wxStaticBitmap::wxStaticBitmap
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 wxBitmap *label = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxStaticBitmap * Result = new EwxStaticBitmap(parent,*id,*label,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStaticBitmap");
 break;
}
case wxStaticBitmap_Create: { // wxStaticBitmap::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxStaticBitmap *This = (wxStaticBitmap *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 wxBitmap *label = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,*label,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxStaticBitmap_GetBitmap: { // wxStaticBitmap::GetBitmap
 wxStaticBitmap *This = (wxStaticBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxBitmap * Result = new EwxBitmap(This->GetBitmap()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxStaticBitmap_SetBitmap: { // wxStaticBitmap::SetBitmap
 wxStaticBitmap *This = (wxStaticBitmap *) getPtr(bp,memenv); bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBitmap(*bitmap);
 break;
}
case wxRadioBox_new: { // wxRadioBox::wxRadioBox
 int majorDim=1;
 long style=wxRA_HORIZONTAL;
 const wxValidator * val= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 int * choicesLen = (int *) bp; bp += 4;
 wxArrayString choices;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((4+ choicesASz) & 7 )) & 7;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 majorDim = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
val = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxRadioBox * Result = new EwxRadioBox(parent,*id,title,pos,size,choices,majorDim,style,*val);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxRadioBox");
 break;
}
case wxRadioBox_Create: { // wxRadioBox::Create
 int majorDim=0;
 long style=wxRA_HORIZONTAL;
 const wxValidator * val= &wxDefaultValidator;
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 int * choicesLen = (int *) bp; bp += 4;
 wxArrayString choices;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((4+ choicesASz) & 7 )) & 7;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 majorDim = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
val = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,title,pos,size,choices,majorDim,style,*val);
 rt.addBool(Result);
 break;
}
case wxRadioBox_Enable_2: { // wxRadioBox::Enable
 bool enable=true;
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Enable(*n,enable);
 rt.addBool(Result);
 break;
}
case wxRadioBox_Enable_1: { // wxRadioBox::Enable
 bool enable=true;
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 enable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Enable(enable);
 rt.addBool(Result);
 break;
}
case wxRadioBox_GetSelection: { // wxRadioBox::GetSelection
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxRadioBox_GetString: { // wxRadioBox::GetString
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetString(*n);
 rt.add(Result);
 break;
}
case wxRadioBox_SetSelection: { // wxRadioBox::SetSelection
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 int * n = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*n);
 break;
}
case wxRadioBox_Show_2: { // wxRadioBox::Show
 bool show=true;
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Show(*n,show);
 rt.addBool(Result);
 break;
}
case wxRadioBox_Show_1: { // wxRadioBox::Show
 bool show=true;
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Show(show);
 rt.addBool(Result);
 break;
}
case wxRadioBox_GetColumnCount: { // wxRadioBox::GetColumnCount
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColumnCount();
 rt.addUint(Result);
 break;
}
case wxRadioBox_GetItemHelpText: { // wxRadioBox::GetItemHelpText
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetItemHelpText(*n);
 rt.add(Result);
 break;
}
case wxRadioBox_GetItemToolTip: { // wxRadioBox::GetItemToolTip
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * item = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxToolTip * Result = (wxToolTip*)This->GetItemToolTip(*item);
 rt.addRef(getRef((void *)Result,memenv), "wxToolTip");
 break;
}
case wxRadioBox_GetItemFromPoint: { // wxRadioBox::GetItemFromPoint
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 int Result = This->GetItemFromPoint(pt);
 rt.addInt(Result);
 break;
}
case wxRadioBox_GetRowCount: { // wxRadioBox::GetRowCount
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRowCount();
 rt.addUint(Result);
 break;
}
case wxRadioBox_IsItemEnabled: { // wxRadioBox::IsItemEnabled
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsItemEnabled(*n);
 rt.addBool(Result);
 break;
}
case wxRadioBox_IsItemShown: { // wxRadioBox::IsItemShown
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsItemShown(*n);
 rt.addBool(Result);
 break;
}
case wxRadioBox_SetItemHelpText: { // wxRadioBox::SetItemHelpText
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * n = (unsigned int *) bp; bp += 4;
 int * helpTextLen = (int *) bp; bp += 4;
 wxString helpText = wxString(bp, wxConvUTF8);
 bp += *helpTextLen+((8-((4+ *helpTextLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetItemHelpText(*n,helpText);
 break;
}
case wxRadioBox_SetItemToolTip: { // wxRadioBox::SetItemToolTip
 wxRadioBox *This = (wxRadioBox *) getPtr(bp,memenv); bp += 4;
 unsigned int * item = (unsigned int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetItemToolTip(*item,text);
 break;
}
case wxRadioButton_new_0: { // wxRadioButton::wxRadioButton
 wxRadioButton * Result = new EwxRadioButton();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxRadioButton");
 break;
}
case wxRadioButton_new_4: { // wxRadioButton::wxRadioButton
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((4+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxRadioButton * Result = new EwxRadioButton(parent,*id,label,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxRadioButton");
 break;
}
case wxRadioButton_Create: { // wxRadioButton::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 const wxValidator * validator= &wxDefaultValidator;
 wxRadioButton *This = (wxRadioButton *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * labelLen = (int *) bp; bp += 4;
 wxString label = wxString(bp, wxConvUTF8);
 bp += *labelLen+((8-((0+ *labelLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,label,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxRadioButton_GetValue: { // wxRadioButton::GetValue
 wxRadioButton *This = (wxRadioButton *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetValue();
 rt.addBool(Result);
 break;
}
case wxRadioButton_SetValue: { // wxRadioButton::SetValue
 wxRadioButton *This = (wxRadioButton *) getPtr(bp,memenv); bp += 4;
 bool * val = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetValue(*val);
 break;
}
case wxSlider_new_6: { // wxSlider::wxSlider
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSL_HORIZONTAL;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * value = (int *) bp; bp += 4;
 int * minValue = (int *) bp; bp += 4;
 int * maxValue = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxSlider * Result = new EwxSlider(parent,*id,*value,*minValue,*maxValue,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSlider");
 break;
}
case wxSlider_new_0: { // wxSlider::wxSlider
 wxSlider * Result = new EwxSlider();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSlider");
 break;
}
case wxSlider_Create: { // wxSlider::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxSL_HORIZONTAL;
 const wxValidator * validator= &wxDefaultValidator;
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * value = (int *) bp; bp += 4;
 int * minValue = (int *) bp; bp += 4;
 int * maxValue = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,*value,*minValue,*maxValue,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxSlider_GetLineSize: { // wxSlider::GetLineSize
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLineSize();
 rt.addInt(Result);
 break;
}
case wxSlider_GetMax: { // wxSlider::GetMax
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMax();
 rt.addInt(Result);
 break;
}
case wxSlider_GetMin: { // wxSlider::GetMin
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMin();
 rt.addInt(Result);
 break;
}
case wxSlider_GetPageSize: { // wxSlider::GetPageSize
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPageSize();
 rt.addInt(Result);
 break;
}
case wxSlider_GetThumbLength: { // wxSlider::GetThumbLength
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetThumbLength();
 rt.addInt(Result);
 break;
}
case wxSlider_GetValue: { // wxSlider::GetValue
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetValue();
 rt.addInt(Result);
 break;
}
case wxSlider_SetLineSize: { // wxSlider::SetLineSize
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 int * lineSize = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetLineSize(*lineSize);
 break;
}
case wxSlider_SetPageSize: { // wxSlider::SetPageSize
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 int * pageSize = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPageSize(*pageSize);
 break;
}
case wxSlider_SetRange: { // wxSlider::SetRange
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 int * minValue = (int *) bp; bp += 4;
 int * maxValue = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRange(*minValue,*maxValue);
 break;
}
case wxSlider_SetThumbLength: { // wxSlider::SetThumbLength
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 int * lenPixels = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetThumbLength(*lenPixels);
 break;
}
case wxSlider_SetValue: { // wxSlider::SetValue
 wxSlider *This = (wxSlider *) getPtr(bp,memenv); bp += 4;
 int * value = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetValue(*value);
 break;
}
case wxDialog_new_4: { // wxDialog::wxDialog
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_DIALOG_STYLE;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxDialog * Result = new EwxDialog(parent,*id,title,pos,size,style);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxDialog");
 break;
}
case wxDialog_new_0: { // wxDialog::wxDialog
 wxDialog * Result = new EwxDialog();
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxDialog");
 break;
}
case wxDialog_Create: { // wxDialog::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_DIALOG_STYLE;
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,title,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxDialog_CreateButtonSizer: { // wxDialog::CreateButtonSizer
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 int * flags = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSizer * Result = (wxSizer*)This->CreateButtonSizer(*flags);
 rt.addRef(getRef((void *)Result,memenv), "wxSizer");
 break;
}
case wxDialog_CreateStdDialogButtonSizer: { // wxDialog::CreateStdDialogButtonSizer
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 int * flags = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxStdDialogButtonSizer * Result = (wxStdDialogButtonSizer*)This->CreateStdDialogButtonSizer(*flags);
 rt.addRef(getRef((void *)Result,memenv), "wxStdDialogButtonSizer");
 break;
}
case wxDialog_EndModal: { // wxDialog::EndModal
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 int * retCode = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EndModal(*retCode);
 break;
}
case wxDialog_GetAffirmativeId: { // wxDialog::GetAffirmativeId
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetAffirmativeId();
 rt.addInt(Result);
 break;
}
case wxDialog_GetReturnCode: { // wxDialog::GetReturnCode
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetReturnCode();
 rt.addInt(Result);
 break;
}
case wxDialog_IsModal: { // wxDialog::IsModal
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsModal();
 rt.addBool(Result);
 break;
}
case wxDialog_SetAffirmativeId: { // wxDialog::SetAffirmativeId
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 int * affirmativeId = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAffirmativeId(*affirmativeId);
 break;
}
case wxDialog_SetReturnCode: { // wxDialog::SetReturnCode
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 int * returnCode = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetReturnCode(*returnCode);
 break;
}
case wxDialog_Show: { // wxDialog::Show
 bool show=TRUE;
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Show(show);
 rt.addBool(Result);
 break;
}
case wxDialog_ShowModal: { // wxDialog::ShowModal
 wxDialog *This = (wxDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->ShowModal();
 rt.addInt(Result);
 break;
}
case wxColourDialog_new_0: { // wxColourDialog::wxColourDialog
 wxColourDialog * Result = new EwxColourDialog();
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxColourDialog");
 break;
}
case wxColourDialog_new_2: { // wxColourDialog::wxColourDialog
 wxColourData * data=(wxColourData *) NULL;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
data = (wxColourData *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxColourDialog * Result = new EwxColourDialog(parent,data);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxColourDialog");
 break;
}
case wxColourDialog_Create: { // wxColourDialog::Create
 wxColourData * data=(wxColourData *) NULL;
 wxColourDialog *This = (wxColourDialog *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
data = (wxColourData *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,data);
 rt.addBool(Result);
 break;
}
case wxColourDialog_GetColourData: { // wxColourDialog::GetColourData
 wxColourDialog *This = (wxColourDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColourData * Result = &This->GetColourData();
 rt.addRef(getRef((void *)Result,memenv), "wxColourData");
 break;
}
case wxColourData_new_0: { // wxColourData::wxColourData
 wxColourData * Result = new EwxColourData();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxColourData");
 break;
}
case wxColourData_new_1: { // wxColourData::wxColourData
 wxColourData *data = (wxColourData *) getPtr(bp,memenv); bp += 4;
 wxColourData * Result = new EwxColourData(*data);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxColourData");
 break;
}
case wxColourData_GetChooseFull: { // wxColourData::GetChooseFull
 wxColourData *This = (wxColourData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetChooseFull();
 rt.addBool(Result);
 break;
}
case wxColourData_GetColour: { // wxColourData::GetColour
 wxColourData *This = (wxColourData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetColour();
 rt.add((*Result));
 break;
}
case wxColourData_GetCustomColour: { // wxColourData::GetCustomColour
 wxColourData *This = (wxColourData *) getPtr(bp,memenv); bp += 4;
 int * i = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetCustomColour(*i);
 rt.add(Result);
 break;
}
case wxColourData_SetChooseFull: { // wxColourData::SetChooseFull
 wxColourData *This = (wxColourData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetChooseFull(*flag);
 break;
}
case wxColourData_SetColour: { // wxColourData::SetColour
 wxColourData *This = (wxColourData *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetColour(colour);
 break;
}
case wxColourData_SetCustomColour: { // wxColourData::SetCustomColour
 wxColourData *This = (wxColourData *) getPtr(bp,memenv); bp += 4;
 int * i = (int *) bp; bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetCustomColour(*i,colour);
 break;
}
case wxPalette_new_0: { // wxPalette::wxPalette
 wxPalette * Result = new EwxPalette();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPalette");
 break;
}
case wxPalette_new_4: { // wxPalette::wxPalette
 const unsigned char * red = (const unsigned char*) Ecmd.bin[0].base;
 const unsigned char * green = (const unsigned char*) Ecmd.bin[1].base;
 const unsigned char * blue = (const unsigned char*) Ecmd.bin[2].base;
 wxPalette * Result = new EwxPalette(Ecmd.bin[0].size,red,green,blue);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPalette");
 break;
}
case wxPalette_Create: { // wxPalette::Create
 wxPalette *This = (wxPalette *) getPtr(bp,memenv); bp += 4;
 const unsigned char * red = (const unsigned char*) Ecmd.bin[0].base;
 const unsigned char * green = (const unsigned char*) Ecmd.bin[1].base;
 const unsigned char * blue = (const unsigned char*) Ecmd.bin[2].base;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(Ecmd.bin[0].size,red,green,blue);
 rt.addBool(Result);
 break;
}
case wxPalette_GetColoursCount: { // wxPalette::GetColoursCount
 wxPalette *This = (wxPalette *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColoursCount();
 rt.addInt(Result);
 break;
}
case wxPalette_GetPixel: { // wxPalette::GetPixel
 wxPalette *This = (wxPalette *) getPtr(bp,memenv); bp += 4;
 unsigned int * red = (unsigned int *) bp; bp += 4;
 unsigned int * green = (unsigned int *) bp; bp += 4;
 unsigned int * blue = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPixel(*red,*green,*blue);
 rt.addInt(Result);
 break;
}
case wxPalette_GetRGB: { // wxPalette::GetRGB
 unsigned char red;
 unsigned char green;
 unsigned char blue;
 wxPalette *This = (wxPalette *) getPtr(bp,memenv); bp += 4;
 int * pixel = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetRGB(*pixel,&red,&green,&blue);
 rt.addBool(Result);
 rt.addUint(red);
 rt.addUint(green);
 rt.addUint(blue);
 rt.addTupleCount(4);
 break;
}
case wxPalette_IsOk: { // wxPalette::IsOk
 wxPalette *This = (wxPalette *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxDirDialog_new: { // wxDirDialog::wxDirDialog
 wxString title= wxDirSelectorPromptStr;
 wxString defaultPath= wxEmptyString;
 long style=wxDD_DEFAULT_STYLE;
 wxPoint pos= wxDefaultPosition;
 wxSize sz= wxDefaultSize;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * defaultPathLen = (int *) bp; bp += 4;
 defaultPath = wxString(bp, wxConvUTF8);
 bp += *defaultPathLen+((8-((0+ *defaultPathLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 sz = wxSize(*szW,*szH);
 bp += 4; /* Align */
  } break;
 }};
 wxDirDialog * Result = new EwxDirDialog(parent,title,defaultPath,style,pos,sz);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxDirDialog");
 break;
}
case wxDirDialog_GetPath: { // wxDirDialog::GetPath
 wxDirDialog *This = (wxDirDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPath();
 rt.add(Result);
 break;
}
case wxDirDialog_GetMessage: { // wxDirDialog::GetMessage
 wxDirDialog *This = (wxDirDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetMessage();
 rt.add(Result);
 break;
}
case wxDirDialog_SetMessage: { // wxDirDialog::SetMessage
 wxDirDialog *This = (wxDirDialog *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetMessage(message);
 break;
}
case wxDirDialog_SetPath: { // wxDirDialog::SetPath
 wxDirDialog *This = (wxDirDialog *) getPtr(bp,memenv); bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 wxString path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetPath(path);
 break;
}
case wxFileDialog_new: { // wxFileDialog::wxFileDialog
 wxString message= wxFileSelectorPromptStr;
 wxString defaultDir= wxEmptyString;
 wxString defaultFile= wxEmptyString;
 wxString wildCard= wxFileSelectorDefaultWildcardStr;
 long style=wxFD_DEFAULT_STYLE;
 wxPoint pos= wxDefaultPosition;
 wxSize sz= wxDefaultSize;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * defaultDirLen = (int *) bp; bp += 4;
 defaultDir = wxString(bp, wxConvUTF8);
 bp += *defaultDirLen+((8-((0+ *defaultDirLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * defaultFileLen = (int *) bp; bp += 4;
 defaultFile = wxString(bp, wxConvUTF8);
 bp += *defaultFileLen+((8-((0+ *defaultFileLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
 int * wildCardLen = (int *) bp; bp += 4;
 wildCard = wxString(bp, wxConvUTF8);
 bp += *wildCardLen+((8-((0+ *wildCardLen) & 7)) & 7);
  } break;
  case 5: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 6: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 7: {bp += 4;
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 sz = wxSize(*szW,*szH);
 bp += 4; /* Align */
  } break;
 }};
 wxFileDialog * Result = new EwxFileDialog(parent,message,defaultDir,defaultFile,wildCard,style,pos,sz);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFileDialog");
 break;
}
case wxFileDialog_GetDirectory: { // wxFileDialog::GetDirectory
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetDirectory();
 rt.add(Result);
 break;
}
case wxFileDialog_GetFilename: { // wxFileDialog::GetFilename
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetFilename();
 rt.add(Result);
 break;
}
case wxFileDialog_GetFilenames: { // wxFileDialog::GetFilenames
 wxArrayString files;
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetFilenames(files);
 rt.add(files);
 break;
}
case wxFileDialog_GetFilterIndex: { // wxFileDialog::GetFilterIndex
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFilterIndex();
 rt.addInt(Result);
 break;
}
case wxFileDialog_GetMessage: { // wxFileDialog::GetMessage
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetMessage();
 rt.add(Result);
 break;
}
case wxFileDialog_GetPath: { // wxFileDialog::GetPath
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPath();
 rt.add(Result);
 break;
}
case wxFileDialog_GetPaths: { // wxFileDialog::GetPaths
 wxArrayString paths;
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetPaths(paths);
 rt.add(paths);
 break;
}
case wxFileDialog_GetWildcard: { // wxFileDialog::GetWildcard
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetWildcard();
 rt.add(Result);
 break;
}
case wxFileDialog_SetDirectory: { // wxFileDialog::SetDirectory
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 int * dirLen = (int *) bp; bp += 4;
 wxString dir = wxString(bp, wxConvUTF8);
 bp += *dirLen+((8-((0+ *dirLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetDirectory(dir);
 break;
}
case wxFileDialog_SetFilename: { // wxFileDialog::SetFilename
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetFilename(name);
 break;
}
case wxFileDialog_SetFilterIndex: { // wxFileDialog::SetFilterIndex
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 int * filterIndex = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFilterIndex(*filterIndex);
 break;
}
case wxFileDialog_SetMessage: { // wxFileDialog::SetMessage
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetMessage(message);
 break;
}
case wxFileDialog_SetPath: { // wxFileDialog::SetPath
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 wxString path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetPath(path);
 break;
}
case wxFileDialog_SetWildcard: { // wxFileDialog::SetWildcard
 wxFileDialog *This = (wxFileDialog *) getPtr(bp,memenv); bp += 4;
 int * wildCardLen = (int *) bp; bp += 4;
 wxString wildCard = wxString(bp, wxConvUTF8);
 bp += *wildCardLen+((8-((0+ *wildCardLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetWildcard(wildCard);
 break;
}
case wxPickerBase_SetInternalMargin: { // wxPickerBase::SetInternalMargin
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 int * newmargin = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetInternalMargin(*newmargin);
 break;
}
case wxPickerBase_GetInternalMargin: { // wxPickerBase::GetInternalMargin
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetInternalMargin();
 rt.addInt(Result);
 break;
}
case wxPickerBase_SetTextCtrlProportion: { // wxPickerBase::SetTextCtrlProportion
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 int * prop = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTextCtrlProportion(*prop);
 break;
}
case wxPickerBase_SetPickerCtrlProportion: { // wxPickerBase::SetPickerCtrlProportion
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 int * prop = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPickerCtrlProportion(*prop);
 break;
}
case wxPickerBase_GetTextCtrlProportion: { // wxPickerBase::GetTextCtrlProportion
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetTextCtrlProportion();
 rt.addInt(Result);
 break;
}
case wxPickerBase_GetPickerCtrlProportion: { // wxPickerBase::GetPickerCtrlProportion
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPickerCtrlProportion();
 rt.addInt(Result);
 break;
}
case wxPickerBase_HasTextCtrl: { // wxPickerBase::HasTextCtrl
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasTextCtrl();
 rt.addBool(Result);
 break;
}
case wxPickerBase_GetTextCtrl: { // wxPickerBase::GetTextCtrl
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxTextCtrl * Result = (wxTextCtrl*)This->GetTextCtrl();
 rt.addRef(getRef((void *)Result,memenv), "wxTextCtrl");
 break;
}
case wxPickerBase_IsTextCtrlGrowable: { // wxPickerBase::IsTextCtrlGrowable
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsTextCtrlGrowable();
 rt.addBool(Result);
 break;
}
case wxPickerBase_SetPickerCtrlGrowable: { // wxPickerBase::SetPickerCtrlGrowable
 bool grow=true;
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 grow = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetPickerCtrlGrowable(grow);
 break;
}
case wxPickerBase_SetTextCtrlGrowable: { // wxPickerBase::SetTextCtrlGrowable
 bool grow=true;
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 grow = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetTextCtrlGrowable(grow);
 break;
}
case wxPickerBase_IsPickerCtrlGrowable: { // wxPickerBase::IsPickerCtrlGrowable
 wxPickerBase *This = (wxPickerBase *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsPickerCtrlGrowable();
 rt.addBool(Result);
 break;
}
case wxFilePickerCtrl_new_0: { // wxFilePickerCtrl::wxFilePickerCtrl
 wxFilePickerCtrl * Result = new EwxFilePickerCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFilePickerCtrl");
 break;
}
case wxFilePickerCtrl_new_3: { // wxFilePickerCtrl::wxFilePickerCtrl
 wxString path= wxEmptyString;
 wxString message= wxFileSelectorPromptStr;
 wxString wildcard= wxFileSelectorDefaultWildcardStr;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxFLP_DEFAULT_STYLE;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * wildcardLen = (int *) bp; bp += 4;
 wildcard = wxString(bp, wxConvUTF8);
 bp += *wildcardLen+((8-((0+ *wildcardLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 6: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 7: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxFilePickerCtrl * Result = new EwxFilePickerCtrl(parent,*id,path,message,wildcard,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFilePickerCtrl");
 break;
}
case wxFilePickerCtrl_Create: { // wxFilePickerCtrl::Create
 wxString path= wxEmptyString;
 wxString message= wxFileSelectorPromptStr;
 wxString wildcard= wxFileSelectorDefaultWildcardStr;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxFLP_DEFAULT_STYLE;
 const wxValidator * validator= &wxDefaultValidator;
 wxFilePickerCtrl *This = (wxFilePickerCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * wildcardLen = (int *) bp; bp += 4;
 wildcard = wxString(bp, wxConvUTF8);
 bp += *wildcardLen+((8-((0+ *wildcardLen) & 7)) & 7);
  } break;
  case 4: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 6: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 7: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,path,message,wildcard,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxFilePickerCtrl_GetPath: { // wxFilePickerCtrl::GetPath
 wxFilePickerCtrl *This = (wxFilePickerCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPath();
 rt.add(Result);
 break;
}
case wxFilePickerCtrl_SetPath: { // wxFilePickerCtrl::SetPath
 wxFilePickerCtrl *This = (wxFilePickerCtrl *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetPath(str);
 break;
}
case wxDirPickerCtrl_new_0: { // wxDirPickerCtrl::wxDirPickerCtrl
 wxDirPickerCtrl * Result = new EwxDirPickerCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxDirPickerCtrl");
 break;
}
case wxDirPickerCtrl_new_3: { // wxDirPickerCtrl::wxDirPickerCtrl
 wxString path= wxEmptyString;
 wxString message= wxDirSelectorPromptStr;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDIRP_DEFAULT_STYLE;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 6: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxDirPickerCtrl * Result = new EwxDirPickerCtrl(parent,*id,path,message,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxDirPickerCtrl");
 break;
}
case wxDirPickerCtrl_Create: { // wxDirPickerCtrl::Create
 wxString path= wxEmptyString;
 wxString message= wxDirSelectorPromptStr;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDIRP_DEFAULT_STYLE;
 const wxValidator * validator= &wxDefaultValidator;
 wxDirPickerCtrl *This = (wxDirPickerCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * pathLen = (int *) bp; bp += 4;
 path = wxString(bp, wxConvUTF8);
 bp += *pathLen+((8-((0+ *pathLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 5: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 6: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,path,message,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxDirPickerCtrl_GetPath: { // wxDirPickerCtrl::GetPath
 wxDirPickerCtrl *This = (wxDirPickerCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPath();
 rt.add(Result);
 break;
}
case wxDirPickerCtrl_SetPath: { // wxDirPickerCtrl::SetPath
 wxDirPickerCtrl *This = (wxDirPickerCtrl *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetPath(str);
 break;
}
case wxColourPickerCtrl_new_0: { // wxColourPickerCtrl::wxColourPickerCtrl
 wxColourPickerCtrl * Result = new EwxColourPickerCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxColourPickerCtrl");
 break;
}
case wxColourPickerCtrl_new_3: { // wxColourPickerCtrl::wxColourPickerCtrl
 wxColour col= *wxBLACK;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxCLRP_DEFAULT_STYLE;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 col = wxColour(*colR,*colG,*colB,*colA);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxColourPickerCtrl * Result = new EwxColourPickerCtrl(parent,*id,col,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxColourPickerCtrl");
 break;
}
case wxColourPickerCtrl_Create: { // wxColourPickerCtrl::Create
 wxColour col= *wxBLACK;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxCLRP_DEFAULT_STYLE;
 const wxValidator * validator= &wxDefaultValidator;
 wxColourPickerCtrl *This = (wxColourPickerCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 col = wxColour(*colR,*colG,*colB,*colA);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,col,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxColourPickerCtrl_GetColour: { // wxColourPickerCtrl::GetColour
 wxColourPickerCtrl *This = (wxColourPickerCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetColour();
 rt.add(Result);
 break;
}
case wxColourPickerCtrl_SetColour_1_1: { // wxColourPickerCtrl::SetColour
 wxColourPickerCtrl *This = (wxColourPickerCtrl *) getPtr(bp,memenv); bp += 4;
 int * colR = (int *) bp; bp += 4;
 int * colG = (int *) bp; bp += 4;
 int * colB = (int *) bp; bp += 4;
 int * colA = (int *) bp; bp += 4;
 wxColour col = wxColour(*colR,*colG,*colB,*colA);
 if(!This) throw wxe_badarg(0);
 This->SetColour(col);
 break;
}
case wxColourPickerCtrl_SetColour_1_0: { // wxColourPickerCtrl::SetColour
 wxColourPickerCtrl *This = (wxColourPickerCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetColour(text);
 rt.addBool(Result);
 break;
}
case wxDatePickerCtrl_new_0: { // wxDatePickerCtrl::wxDatePickerCtrl
 wxDatePickerCtrl * Result = new EwxDatePickerCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxDatePickerCtrl");
 break;
}
case wxDatePickerCtrl_new_3: { // wxDatePickerCtrl::wxDatePickerCtrl
 wxDateTime date= wxDefaultDateTime;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDP_DEFAULT|wxDP_SHOWCENTURY;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * dateD = (int *) bp; bp += 4;
 int * dateMo = (int *) bp; bp += 4;
 int * dateY = (int *) bp; bp += 4;
 int * dateH = (int *) bp; bp += 4;
 int * dateMi = (int *) bp; bp += 4;
 int * dateS = (int *) bp; bp += 4;
 date = wxDateTime((wxDateTime::wxDateTime_t) *dateD,(wxDateTime::Month) *dateMo,*dateY,(wxDateTime::wxDateTime_t) *dateH,(wxDateTime::wxDateTime_t) *dateMi,(wxDateTime::wxDateTime_t) *dateS);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxDatePickerCtrl * Result = new EwxDatePickerCtrl(parent,*id,date,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxDatePickerCtrl");
 break;
}
case wxDatePickerCtrl_GetRange: { // wxDatePickerCtrl::GetRange
 wxDatePickerCtrl *This = (wxDatePickerCtrl *) getPtr(bp,memenv); bp += 4;
 int * dt1D = (int *) bp; bp += 4;
 int * dt1Mo = (int *) bp; bp += 4;
 int * dt1Y = (int *) bp; bp += 4;
 int * dt1H = (int *) bp; bp += 4;
 int * dt1Mi = (int *) bp; bp += 4;
 int * dt1S = (int *) bp; bp += 4;
 wxDateTime dt1 = wxDateTime((wxDateTime::wxDateTime_t) *dt1D,(wxDateTime::Month) *dt1Mo,*dt1Y,(wxDateTime::wxDateTime_t) *dt1H,(wxDateTime::wxDateTime_t) *dt1Mi,(wxDateTime::wxDateTime_t) *dt1S);
 int * dt2D = (int *) bp; bp += 4;
 int * dt2Mo = (int *) bp; bp += 4;
 int * dt2Y = (int *) bp; bp += 4;
 int * dt2H = (int *) bp; bp += 4;
 int * dt2Mi = (int *) bp; bp += 4;
 int * dt2S = (int *) bp; bp += 4;
 wxDateTime dt2 = wxDateTime((wxDateTime::wxDateTime_t) *dt2D,(wxDateTime::Month) *dt2Mo,*dt2Y,(wxDateTime::wxDateTime_t) *dt2H,(wxDateTime::wxDateTime_t) *dt2Mi,(wxDateTime::wxDateTime_t) *dt2S);
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetRange(&dt1,&dt2);
 rt.addBool(Result);
 break;
}
case wxDatePickerCtrl_GetValue: { // wxDatePickerCtrl::GetValue
 wxDatePickerCtrl *This = (wxDatePickerCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxDateTime Result = This->GetValue();
 rt.add(Result);
 break;
}
case wxDatePickerCtrl_SetRange: { // wxDatePickerCtrl::SetRange
 wxDatePickerCtrl *This = (wxDatePickerCtrl *) getPtr(bp,memenv); bp += 4;
 int * dt1D = (int *) bp; bp += 4;
 int * dt1Mo = (int *) bp; bp += 4;
 int * dt1Y = (int *) bp; bp += 4;
 int * dt1H = (int *) bp; bp += 4;
 int * dt1Mi = (int *) bp; bp += 4;
 int * dt1S = (int *) bp; bp += 4;
 wxDateTime dt1 = wxDateTime((wxDateTime::wxDateTime_t) *dt1D,(wxDateTime::Month) *dt1Mo,*dt1Y,(wxDateTime::wxDateTime_t) *dt1H,(wxDateTime::wxDateTime_t) *dt1Mi,(wxDateTime::wxDateTime_t) *dt1S);
 int * dt2D = (int *) bp; bp += 4;
 int * dt2Mo = (int *) bp; bp += 4;
 int * dt2Y = (int *) bp; bp += 4;
 int * dt2H = (int *) bp; bp += 4;
 int * dt2Mi = (int *) bp; bp += 4;
 int * dt2S = (int *) bp; bp += 4;
 wxDateTime dt2 = wxDateTime((wxDateTime::wxDateTime_t) *dt2D,(wxDateTime::Month) *dt2Mo,*dt2Y,(wxDateTime::wxDateTime_t) *dt2H,(wxDateTime::wxDateTime_t) *dt2Mi,(wxDateTime::wxDateTime_t) *dt2S);
 if(!This) throw wxe_badarg(0);
 This->SetRange(dt1,dt2);
 break;
}
case wxDatePickerCtrl_SetValue: { // wxDatePickerCtrl::SetValue
 wxDatePickerCtrl *This = (wxDatePickerCtrl *) getPtr(bp,memenv); bp += 4;
 int * dateD = (int *) bp; bp += 4;
 int * dateMo = (int *) bp; bp += 4;
 int * dateY = (int *) bp; bp += 4;
 int * dateH = (int *) bp; bp += 4;
 int * dateMi = (int *) bp; bp += 4;
 int * dateS = (int *) bp; bp += 4;
 wxDateTime date = wxDateTime((wxDateTime::wxDateTime_t) *dateD,(wxDateTime::Month) *dateMo,*dateY,(wxDateTime::wxDateTime_t) *dateH,(wxDateTime::wxDateTime_t) *dateMi,(wxDateTime::wxDateTime_t) *dateS);
 if(!This) throw wxe_badarg(0);
 This->SetValue(date);
 break;
}
case wxFontPickerCtrl_new_0: { // wxFontPickerCtrl::wxFontPickerCtrl
 wxFontPickerCtrl * Result = new EwxFontPickerCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFontPickerCtrl");
 break;
}
case wxFontPickerCtrl_new_3: { // wxFontPickerCtrl::wxFontPickerCtrl
 const wxFont * initial= &wxNullFont;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxFNTP_DEFAULT_STYLE;
 const wxValidator * validator= &wxDefaultValidator;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
initial = (wxFont *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxFontPickerCtrl * Result = new EwxFontPickerCtrl(parent,*id,*initial,pos,size,style,*validator);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFontPickerCtrl");
 break;
}
case wxFontPickerCtrl_Create: { // wxFontPickerCtrl::Create
 const wxFont * initial= &wxNullFont;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxFNTP_DEFAULT_STYLE;
 const wxValidator * validator= &wxDefaultValidator;
 wxFontPickerCtrl *This = (wxFontPickerCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
initial = (wxFont *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
validator = (wxValidator *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,*initial,pos,size,style,*validator);
 rt.addBool(Result);
 break;
}
case wxFontPickerCtrl_GetSelectedFont: { // wxFontPickerCtrl::GetSelectedFont
 wxFontPickerCtrl *This = (wxFontPickerCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetSelectedFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxFontPickerCtrl_SetSelectedFont: { // wxFontPickerCtrl::SetSelectedFont
 wxFontPickerCtrl *This = (wxFontPickerCtrl *) getPtr(bp,memenv); bp += 4;
 wxFont *f = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelectedFont(*f);
 break;
}
case wxFontPickerCtrl_GetMaxPointSize: { // wxFontPickerCtrl::GetMaxPointSize
 wxFontPickerCtrl *This = (wxFontPickerCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMaxPointSize();
 rt.addUint(Result);
 break;
}
case wxFontPickerCtrl_SetMaxPointSize: { // wxFontPickerCtrl::SetMaxPointSize
 wxFontPickerCtrl *This = (wxFontPickerCtrl *) getPtr(bp,memenv); bp += 4;
 unsigned int * max = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMaxPointSize(*max);
 break;
}
case wxFindReplaceDialog_new_0: { // wxFindReplaceDialog::wxFindReplaceDialog
 wxFindReplaceDialog * Result = new EwxFindReplaceDialog();
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFindReplaceDialog");
 break;
}
case wxFindReplaceDialog_new_4: { // wxFindReplaceDialog::wxFindReplaceDialog
 int style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxFindReplaceData *data = (wxFindReplaceData *) getPtr(bp,memenv); bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxFindReplaceDialog * Result = new EwxFindReplaceDialog(parent,data,title,style);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFindReplaceDialog");
 break;
}
case wxFindReplaceDialog_Create: { // wxFindReplaceDialog::Create
 int style=0;
 wxFindReplaceDialog *This = (wxFindReplaceDialog *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxFindReplaceData *data = (wxFindReplaceData *) getPtr(bp,memenv); bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,data,title,style);
 rt.addBool(Result);
 break;
}
case wxFindReplaceDialog_GetData: { // wxFindReplaceDialog::GetData
 wxFindReplaceDialog *This = (wxFindReplaceDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxFindReplaceData * Result = (wxFindReplaceData*)This->GetData();
 rt.addRef(getRef((void *)Result,memenv), "wxFindReplaceData");
 break;
}
case wxFindReplaceData_new_0: { // wxFindReplaceData::wxFindReplaceData
 wxFindReplaceData * Result = new EwxFindReplaceData();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFindReplaceData");
 break;
}
case wxFindReplaceData_new_1: { // wxFindReplaceData::wxFindReplaceData
 unsigned int * flags = (unsigned int *) bp; bp += 4;
 wxFindReplaceData * Result = new EwxFindReplaceData(*flags);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFindReplaceData");
 break;
}
case wxFindReplaceData_GetFindString: { // wxFindReplaceData::GetFindString
 wxFindReplaceData *This = (wxFindReplaceData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString * Result = &This->GetFindString();
 rt.add(Result);
 break;
}
case wxFindReplaceData_GetReplaceString: { // wxFindReplaceData::GetReplaceString
 wxFindReplaceData *This = (wxFindReplaceData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString * Result = &This->GetReplaceString();
 rt.add(Result);
 break;
}
case wxFindReplaceData_GetFlags: { // wxFindReplaceData::GetFlags
 wxFindReplaceData *This = (wxFindReplaceData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFlags();
 rt.addInt(Result);
 break;
}
case wxFindReplaceData_SetFlags: { // wxFindReplaceData::SetFlags
 wxFindReplaceData *This = (wxFindReplaceData *) getPtr(bp,memenv); bp += 4;
 unsigned int * flags = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFlags(*flags);
 break;
}
case wxFindReplaceData_SetFindString: { // wxFindReplaceData::SetFindString
 wxFindReplaceData *This = (wxFindReplaceData *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetFindString(str);
 break;
}
case wxFindReplaceData_SetReplaceString: { // wxFindReplaceData::SetReplaceString
 wxFindReplaceData *This = (wxFindReplaceData *) getPtr(bp,memenv); bp += 4;
 int * strLen = (int *) bp; bp += 4;
 wxString str = wxString(bp, wxConvUTF8);
 bp += *strLen+((8-((0+ *strLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetReplaceString(str);
 break;
}
case wxMultiChoiceDialog_new_0: { // wxMultiChoiceDialog::wxMultiChoiceDialog
 wxMultiChoiceDialog * Result = new EwxMultiChoiceDialog();
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMultiChoiceDialog");
 break;
}
case wxMultiChoiceDialog_new_5: { // wxMultiChoiceDialog::wxMultiChoiceDialog
 long style=wxCHOICEDLG_STYLE;
 wxPoint pos= wxDefaultPosition;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 int * captionLen = (int *) bp; bp += 4;
 wxString caption = wxString(bp, wxConvUTF8);
 bp += *captionLen+((8-((4+ *captionLen) & 7)) & 7);
 int * choicesLen = (int *) bp; bp += 4;
 wxArrayString choices;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((4+ choicesASz) & 7 )) & 7;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
 }};
 wxMultiChoiceDialog * Result = new EwxMultiChoiceDialog(parent,message,caption,choices,style,pos);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMultiChoiceDialog");
 break;
}
case wxMultiChoiceDialog_GetSelections: { // wxMultiChoiceDialog::GetSelections
 wxMultiChoiceDialog *This = (wxMultiChoiceDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxArrayInt Result = This->GetSelections();
 rt.add(Result);
 break;
}
case wxMultiChoiceDialog_SetSelections: { // wxMultiChoiceDialog::SetSelections
 wxMultiChoiceDialog *This = (wxMultiChoiceDialog *) getPtr(bp,memenv); bp += 4;
 int * selectionsLen = (int *) bp; bp += 4;
 wxArrayInt selections;
 for(int i=0; i < *selectionsLen; i++) {  selections.Add(*(int *) bp); bp += 4;}
 bp += ((*selectionsLen + 2) % 2 )*4;
 if(!This) throw wxe_badarg(0);
 This->SetSelections(selections);
 break;
}
case wxSingleChoiceDialog_new_0: { // wxSingleChoiceDialog::wxSingleChoiceDialog
 wxSingleChoiceDialog * Result = new EwxSingleChoiceDialog();
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSingleChoiceDialog");
 break;
}
case wxSingleChoiceDialog_new_5: { // wxSingleChoiceDialog::wxSingleChoiceDialog
 char ** clientData = (char **) NULL;
 long style=wxCHOICEDLG_STYLE;
 wxPoint pos= wxDefaultPosition;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 int * captionLen = (int *) bp; bp += 4;
 wxString caption = wxString(bp, wxConvUTF8);
 bp += *captionLen+((8-((4+ *captionLen) & 7)) & 7);
 int * choicesLen = (int *) bp; bp += 4;
 wxArrayString choices;
 int choicesASz = 0, * choicesTemp;
 for(int i=0; i < *choicesLen; i++) {
   choicesTemp = (int *) bp; bp += 4;
   choices.Add(wxString(bp, wxConvUTF8));
   bp += *choicesTemp;
   choicesASz += *choicesTemp+4;
 }
 bp += (8-((4+ choicesASz) & 7 )) & 7;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
 }};
 wxSingleChoiceDialog * Result = new EwxSingleChoiceDialog(parent,message,caption,choices,clientData,style,pos);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxSingleChoiceDialog");
 break;
}
case wxSingleChoiceDialog_GetSelection: { // wxSingleChoiceDialog::GetSelection
 wxSingleChoiceDialog *This = (wxSingleChoiceDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxSingleChoiceDialog_GetStringSelection: { // wxSingleChoiceDialog::GetStringSelection
 wxSingleChoiceDialog *This = (wxSingleChoiceDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetStringSelection();
 rt.add(Result);
 break;
}
case wxSingleChoiceDialog_SetSelection: { // wxSingleChoiceDialog::SetSelection
 wxSingleChoiceDialog *This = (wxSingleChoiceDialog *) getPtr(bp,memenv); bp += 4;
 int * sel = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*sel);
 break;
}
case wxTextEntryDialog_new: { // wxTextEntryDialog::wxTextEntryDialog
 wxString caption= wxGetTextFromUserPromptStr;
 wxString value= wxEmptyString;
 long style=wxTextEntryDialogStyle;
 wxPoint pos= wxDefaultPosition;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * captionLen = (int *) bp; bp += 4;
 caption = wxString(bp, wxConvUTF8);
 bp += *captionLen+((8-((0+ *captionLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
 }};
 wxTextEntryDialog * Result = new EwxTextEntryDialog(parent,message,caption,value,style,pos);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxTextEntryDialog");
 break;
}
case wxTextEntryDialog_GetValue: { // wxTextEntryDialog::GetValue
 wxTextEntryDialog *This = (wxTextEntryDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetValue();
 rt.add(Result);
 break;
}
case wxTextEntryDialog_SetValue: { // wxTextEntryDialog::SetValue
 wxTextEntryDialog *This = (wxTextEntryDialog *) getPtr(bp,memenv); bp += 4;
 int * valLen = (int *) bp; bp += 4;
 wxString val = wxString(bp, wxConvUTF8);
 bp += *valLen+((8-((0+ *valLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetValue(val);
 break;
}
case wxPasswordEntryDialog_new: { // wxPasswordEntryDialog::wxPasswordEntryDialog
 wxString caption= wxGetPasswordFromUserPromptStr;
 wxString value= wxEmptyString;
 long style=wxTextEntryDialogStyle;
 wxPoint pos= wxDefaultPosition;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * captionLen = (int *) bp; bp += 4;
 caption = wxString(bp, wxConvUTF8);
 bp += *captionLen+((8-((0+ *captionLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * valueLen = (int *) bp; bp += 4;
 value = wxString(bp, wxConvUTF8);
 bp += *valueLen+((8-((0+ *valueLen) & 7)) & 7);
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 4: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
 }};
 wxPasswordEntryDialog * Result = new EwxPasswordEntryDialog(parent,message,caption,value,style,pos);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPasswordEntryDialog");
 break;
}
case wxFontData_new_0: { // wxFontData::wxFontData
 wxFontData * Result = new EwxFontData();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFontData");
 break;
}
case wxFontData_new_1: { // wxFontData::wxFontData
 wxFontData *data = (wxFontData *) getPtr(bp,memenv); bp += 4;
 wxFontData * Result = new EwxFontData(*data);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFontData");
 break;
}
case wxFontData_EnableEffects: { // wxFontData::EnableEffects
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableEffects(*flag);
 break;
}
case wxFontData_GetAllowSymbols: { // wxFontData::GetAllowSymbols
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetAllowSymbols();
 rt.addBool(Result);
 break;
}
case wxFontData_GetColour: { // wxFontData::GetColour
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxColour * Result = &This->GetColour();
 rt.add((*Result));
 break;
}
case wxFontData_GetChosenFont: { // wxFontData::GetChosenFont
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetChosenFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxFontData_GetEnableEffects: { // wxFontData::GetEnableEffects
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetEnableEffects();
 rt.addBool(Result);
 break;
}
case wxFontData_GetInitialFont: { // wxFontData::GetInitialFont
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetInitialFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxFontData_GetShowHelp: { // wxFontData::GetShowHelp
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetShowHelp();
 rt.addBool(Result);
 break;
}
case wxFontData_SetAllowSymbols: { // wxFontData::SetAllowSymbols
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAllowSymbols(*flag);
 break;
}
case wxFontData_SetChosenFont: { // wxFontData::SetChosenFont
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetChosenFont(*font);
 break;
}
case wxFontData_SetColour: { // wxFontData::SetColour
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetColour(colour);
 break;
}
case wxFontData_SetInitialFont: { // wxFontData::SetInitialFont
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetInitialFont(*font);
 break;
}
case wxFontData_SetRange: { // wxFontData::SetRange
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 int * minRange = (int *) bp; bp += 4;
 int * maxRange = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetRange(*minRange,*maxRange);
 break;
}
case wxFontData_SetShowHelp: { // wxFontData::SetShowHelp
 wxFontData *This = (wxFontData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetShowHelp(*flag);
 break;
}
case wxFontDialog_new_0: { // wxFontDialog::wxFontDialog
 wxFontDialog * Result = new EwxFontDialog();
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFontDialog");
 break;
}
case wxFontDialog_new_2: { // wxFontDialog::wxFontDialog
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxFontData *data = (wxFontData *) getPtr(bp,memenv); bp += 4;
 wxFontDialog * Result = new EwxFontDialog(parent,*data);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxFontDialog");
 break;
}
case wxFontDialog_Create: { // wxFontDialog::Create
 wxFontDialog *This = (wxFontDialog *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxFontData *data = (wxFontData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*data);
 rt.addBool(Result);
 break;
}
case wxFontDialog_GetFontData: { // wxFontDialog::GetFontData
 wxFontDialog *This = (wxFontDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxFontData * Result = &This->GetFontData();
 rt.addRef(getRef((void *)Result,memenv), "wxFontData");
 break;
}
case wxProgressDialog_new: { // wxProgressDialog::wxProgressDialog
 int maximum=100;
 wxWindow * parent=NULL;
 int style=wxPD_APP_MODAL|wxPD_AUTO_HIDE;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((4+ *messageLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 maximum = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
  case 3: {bp += 4;
 style = (int)*(int *) bp; bp += 4;
  } break;
 }};
 wxProgressDialog * Result = new EwxProgressDialog(title,message,maximum,parent,style);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxProgressDialog");
 break;
}
case wxProgressDialog_Resume: { // wxProgressDialog::Resume
 wxProgressDialog *This = (wxProgressDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Resume();
 break;
}
case wxProgressDialog_Update_2: { // wxProgressDialog::Update
 wxString newmsg= wxEmptyString;
 wxProgressDialog *This = (wxProgressDialog *) getPtr(bp,memenv); bp += 4;
 int * value = (int *) bp; bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * newmsgLen = (int *) bp; bp += 4;
 newmsg = wxString(bp, wxConvUTF8);
 bp += *newmsgLen+((8-((0+ *newmsgLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Update(*value,newmsg);
 rt.addBool(Result);
 break;
}
case wxProgressDialog_Update_0: { // wxProgressDialog::Update
 wxProgressDialog *This = (wxProgressDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Update();
 break;
}
case wxMessageDialog_new: { // wxMessageDialog::wxMessageDialog
 wxString caption= wxMessageBoxCaptionStr;
 long style=wxOK|wxCENTRE;
 wxPoint pos= wxDefaultPosition;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * captionLen = (int *) bp; bp += 4;
 caption = wxString(bp, wxConvUTF8);
 bp += *captionLen+((8-((0+ *captionLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 3: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
 }};
 wxMessageDialog * Result = new EwxMessageDialog(parent,message,caption,style,pos);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMessageDialog");
 break;
}
case wxPageSetupDialog_new: { // wxPageSetupDialog::wxPageSetupDialog
 wxPageSetupDialogData * data=NULL;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
data = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxPageSetupDialog * Result = new EwxPageSetupDialog(parent,data);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPageSetupDialog");
 break;
}
case wxPageSetupDialog_GetPageSetupData: { // wxPageSetupDialog::GetPageSetupData
 wxPageSetupDialog *This = (wxPageSetupDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPageSetupDialogData * Result = &This->GetPageSetupData();
 rt.addRef(getRef((void *)Result,memenv), "wxPageSetupDialogData");
 break;
}
case wxPageSetupDialog_ShowModal: { // wxPageSetupDialog::ShowModal
 wxPageSetupDialog *This = (wxPageSetupDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->ShowModal();
 rt.addInt(Result);
 break;
}
case wxPageSetupDialogData_new_0: { // wxPageSetupDialogData::wxPageSetupDialogData
 wxPageSetupDialogData * Result = new EwxPageSetupDialogData();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPageSetupDialogData");
 break;
}
case wxPageSetupDialogData_new_1_0: { // wxPageSetupDialogData::wxPageSetupDialogData
 wxPageSetupDialogData *dialogData = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 wxPageSetupDialogData * Result = new EwxPageSetupDialogData(*dialogData);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPageSetupDialogData");
 break;
}
case wxPageSetupDialogData_new_1_1: { // wxPageSetupDialogData::wxPageSetupDialogData
 wxPrintData * printData = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxPageSetupDialogData * Result = new EwxPageSetupDialogData(*printData);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPageSetupDialogData");
 break;
}
case wxPageSetupDialogData_EnableHelp: { // wxPageSetupDialogData::EnableHelp
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableHelp(*flag);
 break;
}
case wxPageSetupDialogData_EnableMargins: { // wxPageSetupDialogData::EnableMargins
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableMargins(*flag);
 break;
}
case wxPageSetupDialogData_EnableOrientation: { // wxPageSetupDialogData::EnableOrientation
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableOrientation(*flag);
 break;
}
case wxPageSetupDialogData_EnablePaper: { // wxPageSetupDialogData::EnablePaper
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnablePaper(*flag);
 break;
}
case wxPageSetupDialogData_EnablePrinter: { // wxPageSetupDialogData::EnablePrinter
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnablePrinter(*flag);
 break;
}
case wxPageSetupDialogData_GetDefaultMinMargins: { // wxPageSetupDialogData::GetDefaultMinMargins
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetDefaultMinMargins();
 rt.addBool(Result);
 break;
}
case wxPageSetupDialogData_GetEnableMargins: { // wxPageSetupDialogData::GetEnableMargins
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetEnableMargins();
 rt.addBool(Result);
 break;
}
case wxPageSetupDialogData_GetEnableOrientation: { // wxPageSetupDialogData::GetEnableOrientation
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetEnableOrientation();
 rt.addBool(Result);
 break;
}
case wxPageSetupDialogData_GetEnablePaper: { // wxPageSetupDialogData::GetEnablePaper
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetEnablePaper();
 rt.addBool(Result);
 break;
}
case wxPageSetupDialogData_GetEnablePrinter: { // wxPageSetupDialogData::GetEnablePrinter
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetEnablePrinter();
 rt.addBool(Result);
 break;
}
case wxPageSetupDialogData_GetEnableHelp: { // wxPageSetupDialogData::GetEnableHelp
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetEnableHelp();
 rt.addBool(Result);
 break;
}
case wxPageSetupDialogData_GetDefaultInfo: { // wxPageSetupDialogData::GetDefaultInfo
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetDefaultInfo();
 rt.addBool(Result);
 break;
}
case wxPageSetupDialogData_GetMarginTopLeft: { // wxPageSetupDialogData::GetMarginTopLeft
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetMarginTopLeft();
 rt.add(Result);
 break;
}
case wxPageSetupDialogData_GetMarginBottomRight: { // wxPageSetupDialogData::GetMarginBottomRight
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetMarginBottomRight();
 rt.add(Result);
 break;
}
case wxPageSetupDialogData_GetMinMarginTopLeft: { // wxPageSetupDialogData::GetMinMarginTopLeft
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetMinMarginTopLeft();
 rt.add(Result);
 break;
}
case wxPageSetupDialogData_GetMinMarginBottomRight: { // wxPageSetupDialogData::GetMinMarginBottomRight
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetMinMarginBottomRight();
 rt.add(Result);
 break;
}
case wxPageSetupDialogData_GetPaperId: { // wxPageSetupDialogData::GetPaperId
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPaperId();
 rt.addInt(Result);
 break;
}
case wxPageSetupDialogData_GetPaperSize: { // wxPageSetupDialogData::GetPaperSize
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetPaperSize();
 rt.add(Result);
 break;
}
case wxPageSetupDialogData_GetPrintData: { // wxPageSetupDialogData::GetPrintData
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxPrintData * Result = &This->GetPrintData();
 rt.addRef(getRef((void *)Result,memenv), "wxPrintData");
 break;
}
case wxPageSetupDialogData_IsOk: { // wxPageSetupDialogData::IsOk
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxPageSetupDialogData_SetDefaultInfo: { // wxPageSetupDialogData::SetDefaultInfo
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDefaultInfo(*flag);
 break;
}
case wxPageSetupDialogData_SetDefaultMinMargins: { // wxPageSetupDialogData::SetDefaultMinMargins
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDefaultMinMargins(*flag);
 break;
}
case wxPageSetupDialogData_SetMarginTopLeft: { // wxPageSetupDialogData::SetMarginTopLeft
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->SetMarginTopLeft(pt);
 break;
}
case wxPageSetupDialogData_SetMarginBottomRight: { // wxPageSetupDialogData::SetMarginBottomRight
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->SetMarginBottomRight(pt);
 break;
}
case wxPageSetupDialogData_SetMinMarginTopLeft: { // wxPageSetupDialogData::SetMinMarginTopLeft
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->SetMinMarginTopLeft(pt);
 break;
}
case wxPageSetupDialogData_SetMinMarginBottomRight: { // wxPageSetupDialogData::SetMinMarginBottomRight
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 This->SetMinMarginBottomRight(pt);
 break;
}
case wxPageSetupDialogData_SetPaperId: { // wxPageSetupDialogData::SetPaperId
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 wxPaperSize id = *(wxPaperSize *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetPaperId(id);
 break;
}
case wxPageSetupDialogData_SetPaperSize_1_1: { // wxPageSetupDialogData::SetPaperSize
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 int * szW = (int *) bp; bp += 4;
 int * szH = (int *) bp; bp += 4;
 wxSize sz = wxSize(*szW,*szH);
 if(!This) throw wxe_badarg(0);
 This->SetPaperSize(sz);
 break;
}
case wxPageSetupDialogData_SetPaperSize_1_0: { // wxPageSetupDialogData::SetPaperSize
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 wxPaperSize id = *(wxPaperSize *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetPaperSize(id);
 break;
}
case wxPageSetupDialogData_SetPrintData: { // wxPageSetupDialogData::SetPrintData
 wxPageSetupDialogData *This = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 wxPrintData *printData = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPrintData(*printData);
 break;
}
case wxPrintDialog_new_2_0: { // wxPrintDialog::wxPrintDialog
 wxPrintDialogData * data=NULL;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
data = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxPrintDialog * Result = new EwxPrintDialog(parent,data);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintDialog");
 break;
}
case wxPrintDialog_new_2_1: { // wxPrintDialog::wxPrintDialog
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxPrintData *data = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxPrintDialog * Result = new EwxPrintDialog(parent,data);
 newPtr((void *) Result, 2, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintDialog");
 break;
}
case wxPrintDialog_GetPrintDialogData: { // wxPrintDialog::GetPrintDialogData
 wxPrintDialog *This = (wxPrintDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPrintDialogData * Result = &This->GetPrintDialogData();
 rt.addRef(getRef((void *)Result,memenv), "wxPrintDialogData");
 break;
}
case wxPrintDialog_GetPrintDC: { // wxPrintDialog::GetPrintDC
 wxPrintDialog *This = (wxPrintDialog *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxDC * Result = (wxDC*)This->GetPrintDC();
 rt.addRef(getRef((void *)Result,memenv), "wxDC");
 break;
}
case wxPrintDialogData_new_0: { // wxPrintDialogData::wxPrintDialogData
 wxPrintDialogData * Result = new EwxPrintDialogData();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintDialogData");
 break;
}
case wxPrintDialogData_new_1_1: { // wxPrintDialogData::wxPrintDialogData
 wxPrintDialogData * dialogData = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 wxPrintDialogData * Result = new EwxPrintDialogData(*dialogData);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintDialogData");
 break;
}
case wxPrintDialogData_new_1_0: { // wxPrintDialogData::wxPrintDialogData
 wxPrintData *printData = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxPrintDialogData * Result = new EwxPrintDialogData(*printData);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintDialogData");
 break;
}
case wxPrintDialogData_EnableHelp: { // wxPrintDialogData::EnableHelp
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableHelp(*flag);
 break;
}
case wxPrintDialogData_EnablePageNumbers: { // wxPrintDialogData::EnablePageNumbers
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnablePageNumbers(*flag);
 break;
}
case wxPrintDialogData_EnablePrintToFile: { // wxPrintDialogData::EnablePrintToFile
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnablePrintToFile(*flag);
 break;
}
case wxPrintDialogData_EnableSelection: { // wxPrintDialogData::EnableSelection
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnableSelection(*flag);
 break;
}
case wxPrintDialogData_GetAllPages: { // wxPrintDialogData::GetAllPages
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetAllPages();
 rt.addBool(Result);
 break;
}
case wxPrintDialogData_GetCollate: { // wxPrintDialogData::GetCollate
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetCollate();
 rt.addBool(Result);
 break;
}
case wxPrintDialogData_GetFromPage: { // wxPrintDialogData::GetFromPage
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFromPage();
 rt.addInt(Result);
 break;
}
case wxPrintDialogData_GetMaxPage: { // wxPrintDialogData::GetMaxPage
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMaxPage();
 rt.addInt(Result);
 break;
}
case wxPrintDialogData_GetMinPage: { // wxPrintDialogData::GetMinPage
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMinPage();
 rt.addInt(Result);
 break;
}
case wxPrintDialogData_GetNoCopies: { // wxPrintDialogData::GetNoCopies
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetNoCopies();
 rt.addInt(Result);
 break;
}
case wxPrintDialogData_GetPrintData: { // wxPrintDialogData::GetPrintData
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPrintData * Result = &This->GetPrintData();
 rt.addRef(getRef((void *)Result,memenv), "wxPrintData");
 break;
}
case wxPrintDialogData_GetPrintToFile: { // wxPrintDialogData::GetPrintToFile
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetPrintToFile();
 rt.addBool(Result);
 break;
}
case wxPrintDialogData_GetSelection: { // wxPrintDialogData::GetSelection
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetSelection();
 rt.addBool(Result);
 break;
}
case wxPrintDialogData_GetToPage: { // wxPrintDialogData::GetToPage
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetToPage();
 rt.addInt(Result);
 break;
}
case wxPrintDialogData_IsOk: { // wxPrintDialogData::IsOk
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxPrintDialogData_SetCollate: { // wxPrintDialogData::SetCollate
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCollate(*flag);
 break;
}
case wxPrintDialogData_SetFromPage: { // wxPrintDialogData::SetFromPage
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 int * v = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFromPage(*v);
 break;
}
case wxPrintDialogData_SetMaxPage: { // wxPrintDialogData::SetMaxPage
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 int * v = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMaxPage(*v);
 break;
}
case wxPrintDialogData_SetMinPage: { // wxPrintDialogData::SetMinPage
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 int * v = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMinPage(*v);
 break;
}
case wxPrintDialogData_SetNoCopies: { // wxPrintDialogData::SetNoCopies
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 int * v = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetNoCopies(*v);
 break;
}
case wxPrintDialogData_SetPrintData: { // wxPrintDialogData::SetPrintData
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 wxPrintData *printData = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPrintData(*printData);
 break;
}
case wxPrintDialogData_SetPrintToFile: { // wxPrintDialogData::SetPrintToFile
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPrintToFile(*flag);
 break;
}
case wxPrintDialogData_SetSelection: { // wxPrintDialogData::SetSelection
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*flag);
 break;
}
case wxPrintDialogData_SetToPage: { // wxPrintDialogData::SetToPage
 wxPrintDialogData *This = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
 int * v = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetToPage(*v);
 break;
}
case wxPrintData_new_0: { // wxPrintData::wxPrintData
 wxPrintData * Result = new EwxPrintData();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintData");
 break;
}
case wxPrintData_new_1: { // wxPrintData::wxPrintData
 wxPrintData *printData = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxPrintData * Result = new EwxPrintData(*printData);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintData");
 break;
}
case wxPrintData_GetCollate: { // wxPrintData::GetCollate
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetCollate();
 rt.addBool(Result);
 break;
}
case wxPrintData_GetBin: { // wxPrintData::GetBin
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetBin();
 rt.addInt(Result);
 break;
}
case wxPrintData_GetColour: { // wxPrintData::GetColour
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetColour();
 rt.addBool(Result);
 break;
}
case wxPrintData_GetDuplex: { // wxPrintData::GetDuplex
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDuplex();
 rt.addInt(Result);
 break;
}
case wxPrintData_GetNoCopies: { // wxPrintData::GetNoCopies
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetNoCopies();
 rt.addInt(Result);
 break;
}
case wxPrintData_GetOrientation: { // wxPrintData::GetOrientation
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetOrientation();
 rt.addInt(Result);
 break;
}
case wxPrintData_GetPaperId: { // wxPrintData::GetPaperId
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPaperId();
 rt.addInt(Result);
 break;
}
case wxPrintData_GetPrinterName: { // wxPrintData::GetPrinterName
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString * Result = &This->GetPrinterName();
 rt.add(Result);
 break;
}
case wxPrintData_GetQuality: { // wxPrintData::GetQuality
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPrintQuality Result = This->GetQuality();
 rt.addInt(Result);
 break;
}
case wxPrintData_IsOk: { // wxPrintData::IsOk
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxPrintData_SetBin: { // wxPrintData::SetBin
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxPrintBin bin = *(wxPrintBin *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetBin(bin);
 break;
}
case wxPrintData_SetCollate: { // wxPrintData::SetCollate
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 bool * flag = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCollate(*flag);
 break;
}
case wxPrintData_SetColour: { // wxPrintData::SetColour
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 bool * colour = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetColour(*colour);
 break;
}
case wxPrintData_SetDuplex: { // wxPrintData::SetDuplex
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxDuplexMode duplex = *(wxDuplexMode *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetDuplex(duplex);
 break;
}
case wxPrintData_SetNoCopies: { // wxPrintData::SetNoCopies
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 int * v = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetNoCopies(*v);
 break;
}
case wxPrintData_SetOrientation: { // wxPrintData::SetOrientation
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 int * orient = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetOrientation(*orient);
 break;
}
case wxPrintData_SetPaperId: { // wxPrintData::SetPaperId
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxPaperSize sizeId = *(wxPaperSize *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetPaperId(sizeId);
 break;
}
case wxPrintData_SetPrinterName: { // wxPrintData::SetPrinterName
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetPrinterName(name);
 break;
}
case wxPrintData_SetQuality: { // wxPrintData::SetQuality
 wxPrintData *This = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 int * quality = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetQuality(*quality);
 break;
}
case wxPrintPreview_new_2: { // wxPrintPreview::wxPrintPreview
 wxPrintout * printoutForPrinting=(wxPrintout *) NULL;
 wxPrintDialogData * data=(wxPrintDialogData *) NULL;
 wxPrintout *printout = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
printoutForPrinting = (wxPrintout *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
data = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxPrintPreview * Result = new EwxPrintPreview(printout,printoutForPrinting,data);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintPreview");
 break;
}
case wxPrintPreview_new_3: { // wxPrintPreview::wxPrintPreview
 wxPrintout *printout = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 wxPrintout *printoutForPrinting = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 wxPrintData *data = (wxPrintData *) getPtr(bp,memenv); bp += 4;
 wxPrintPreview * Result = new EwxPrintPreview(printout,printoutForPrinting,data);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrintPreview");
 break;
}
case wxPrintPreview_GetCanvas: { // wxPrintPreview::GetCanvas
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPreviewCanvas * Result = (wxPreviewCanvas*)This->GetCanvas();
 rt.addRef(getRef((void *)Result,memenv), "wxPreviewCanvas");
 break;
}
case wxPrintPreview_GetCurrentPage: { // wxPrintPreview::GetCurrentPage
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCurrentPage();
 rt.addInt(Result);
 break;
}
case wxPrintPreview_GetFrame: { // wxPrintPreview::GetFrame
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFrame * Result = (wxFrame*)This->GetFrame();
 rt.addRef(getRef((void *)Result,memenv), "wxFrame");
 break;
}
case wxPrintPreview_GetMaxPage: { // wxPrintPreview::GetMaxPage
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMaxPage();
 rt.addInt(Result);
 break;
}
case wxPrintPreview_GetMinPage: { // wxPrintPreview::GetMinPage
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMinPage();
 rt.addInt(Result);
 break;
}
case wxPrintPreview_GetPrintout: { // wxPrintPreview::GetPrintout
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPrintout * Result = (wxPrintout*)This->GetPrintout();
 rt.addRef(getRef((void *)Result,memenv), "wxPrintout");
 break;
}
case wxPrintPreview_GetPrintoutForPrinting: { // wxPrintPreview::GetPrintoutForPrinting
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPrintout * Result = (wxPrintout*)This->GetPrintoutForPrinting();
 rt.addRef(getRef((void *)Result,memenv), "wxPrintout");
 break;
}
case wxPrintPreview_IsOk: { // wxPrintPreview::IsOk
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxPrintPreview_PaintPage: { // wxPrintPreview::PaintPage
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 wxPreviewCanvas *canvas = (wxPreviewCanvas *) getPtr(bp,memenv); bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->PaintPage(canvas,*dc);
 rt.addBool(Result);
 break;
}
case wxPrintPreview_Print: { // wxPrintPreview::Print
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 bool * interactive = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Print(*interactive);
 rt.addBool(Result);
 break;
}
case wxPrintPreview_RenderPage: { // wxPrintPreview::RenderPage
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 int * pageNum = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RenderPage(*pageNum);
 rt.addBool(Result);
 break;
}
case wxPrintPreview_SetCanvas: { // wxPrintPreview::SetCanvas
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 wxPreviewCanvas *canvas = (wxPreviewCanvas *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCanvas(canvas);
 break;
}
case wxPrintPreview_SetCurrentPage: { // wxPrintPreview::SetCurrentPage
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 int * pageNum = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetCurrentPage(*pageNum);
 rt.addBool(Result);
 break;
}
case wxPrintPreview_SetFrame: { // wxPrintPreview::SetFrame
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 wxFrame *frame = (wxFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFrame(frame);
 break;
}
case wxPrintPreview_SetPrintout: { // wxPrintPreview::SetPrintout
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 wxPrintout *printout = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPrintout(printout);
 break;
}
case wxPrintPreview_SetZoom: { // wxPrintPreview::SetZoom
 wxPrintPreview *This = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 int * percent = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetZoom(*percent);
 break;
}
case wxPreviewFrame_new: { // wxPreviewFrame::wxPreviewFrame
 wxString title= wxT("Print Preview");
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_FRAME_STYLE|wxFRAME_FLOAT_ON_PARENT;
 wxPrintPreview *preview = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxPreviewFrame * Result = new EwxPreviewFrame(preview,parent,title,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPreviewFrame");
 break;
}
case wxPreviewFrame_CreateControlBar: { // wxPreviewFrame::CreateControlBar
 wxPreviewFrame *This = (wxPreviewFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CreateControlBar();
 break;
}
case wxPreviewFrame_CreateCanvas: { // wxPreviewFrame::CreateCanvas
 wxPreviewFrame *This = (wxPreviewFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CreateCanvas();
 break;
}
case wxPreviewFrame_Initialize: { // wxPreviewFrame::Initialize
 wxPreviewFrame *This = (wxPreviewFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Initialize();
 break;
}
case wxPreviewFrame_OnCloseWindow: { // wxPreviewFrame::OnCloseWindow
 wxPreviewFrame *This = (wxPreviewFrame *) getPtr(bp,memenv); bp += 4;
 wxCloseEvent *event = (wxCloseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->OnCloseWindow(*event);
 break;
}
case wxPreviewControlBar_new: { // wxPreviewControlBar::wxPreviewControlBar
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxTAB_TRAVERSAL;
 wxPrintPreview *preview = (wxPrintPreview *) getPtr(bp,memenv); bp += 4;
 int * buttons = (int *) bp; bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxPreviewControlBar * Result = new EwxPreviewControlBar(preview,*buttons,parent,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPreviewControlBar");
 break;
}
case wxPreviewControlBar_CreateButtons: { // wxPreviewControlBar::CreateButtons
 wxPreviewControlBar *This = (wxPreviewControlBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CreateButtons();
 break;
}
case wxPreviewControlBar_GetPrintPreview: { // wxPreviewControlBar::GetPrintPreview
 wxPreviewControlBar *This = (wxPreviewControlBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPrintPreview * Result = (wxPrintPreview*)This->GetPrintPreview();
 rt.addRef(getRef((void *)Result,memenv), "wxPrintPreview");
 break;
}
case wxPreviewControlBar_GetZoomControl: { // wxPreviewControlBar::GetZoomControl
 wxPreviewControlBar *This = (wxPreviewControlBar *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetZoomControl();
 rt.addInt(Result);
 break;
}
case wxPreviewControlBar_SetZoomControl: { // wxPreviewControlBar::SetZoomControl
 wxPreviewControlBar *This = (wxPreviewControlBar *) getPtr(bp,memenv); bp += 4;
 int * zoom = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetZoomControl(*zoom);
 break;
}
case wxPrinter_new: { // wxPrinter::wxPrinter
 wxPrintDialogData * data=(wxPrintDialogData *) NULL;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
data = (wxPrintDialogData *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxPrinter * Result = new EwxPrinter(data);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxPrinter");
 break;
}
case wxPrinter_CreateAbortWindow: { // wxPrinter::CreateAbortWindow
 wxPrinter *This = (wxPrinter *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxPrintout *printout = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->CreateAbortWindow(parent,printout);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxPrinter_GetAbort: { // wxPrinter::GetAbort
 wxPrinter *This = (wxPrinter *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetAbort();
 rt.addBool(Result);
 break;
}
case wxPrinter_GetLastError: { // wxPrinter::GetLastError
 int Result = wxPrinter::GetLastError();
 rt.addInt(Result);
 break;
}
case wxPrinter_GetPrintDialogData: { // wxPrinter::GetPrintDialogData
 wxPrinter *This = (wxPrinter *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPrintDialogData * Result = &This->GetPrintDialogData();
 rt.addRef(getRef((void *)Result,memenv), "wxPrintDialogData");
 break;
}
case wxPrinter_Print: { // wxPrinter::Print
 bool prompt=true;
 wxPrinter *This = (wxPrinter *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxPrintout *printout = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 prompt = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Print(parent,printout,prompt);
 rt.addBool(Result);
 break;
}
case wxPrinter_PrintDialog: { // wxPrinter::PrintDialog
 wxPrinter *This = (wxPrinter *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxDC * Result = (wxDC*)This->PrintDialog(parent);
 rt.addRef(getRef((void *)Result,memenv), "wxDC");
 break;
}
case wxPrinter_ReportError: { // wxPrinter::ReportError
 wxPrinter *This = (wxPrinter *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxPrintout *printout = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 int * messageLen = (int *) bp; bp += 4;
 wxString message = wxString(bp, wxConvUTF8);
 bp += *messageLen+((8-((0+ *messageLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->ReportError(parent,printout,message);
 break;
}
case wxPrinter_Setup: { // wxPrinter::Setup
 wxPrinter *This = (wxPrinter *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Setup(parent);
 rt.addBool(Result);
 break;
}
case wxXmlResource_new_1: { // wxXmlResource::wxXmlResource
 int flags=wxXRC_USE_LOCALE;
 wxString domain= wxEmptyString;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * domainLen = (int *) bp; bp += 4;
 domain = wxString(bp, wxConvUTF8);
 bp += *domainLen+((8-((0+ *domainLen) & 7)) & 7);
  } break;
 }};
 wxXmlResource * Result = new EwxXmlResource(flags,domain);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxXmlResource");
 break;
}
case wxXmlResource_new_2: { // wxXmlResource::wxXmlResource
 int flags=wxXRC_USE_LOCALE;
 wxString domain= wxEmptyString;
 int * filemaskLen = (int *) bp; bp += 4;
 wxString filemask = wxString(bp, wxConvUTF8);
 bp += *filemaskLen+((8-((4+ *filemaskLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * domainLen = (int *) bp; bp += 4;
 domain = wxString(bp, wxConvUTF8);
 bp += *domainLen+((8-((0+ *domainLen) & 7)) & 7);
  } break;
 }};
 wxXmlResource * Result = new EwxXmlResource(filemask,flags,domain);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxXmlResource");
 break;
}
case wxXmlResource_AttachUnknownControl: { // wxXmlResource::AttachUnknownControl
 wxWindow * parent=NULL;
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 wxWindow *control = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AttachUnknownControl(name,control,parent);
 rt.addBool(Result);
 break;
}
case wxXmlResource_ClearHandlers: { // wxXmlResource::ClearHandlers
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearHandlers();
 break;
}
case wxXmlResource_CompareVersion: { // wxXmlResource::CompareVersion
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * major = (int *) bp; bp += 4;
 int * minor = (int *) bp; bp += 4;
 int * release = (int *) bp; bp += 4;
 int * revision = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->CompareVersion(*major,*minor,*release,*revision);
 rt.addInt(Result);
 break;
}
case wxXmlResource_Get: { // wxXmlResource::Get
 wxXmlResource * Result = (wxXmlResource*)wxXmlResource::Get();
 rt.addRef(getRef((void *)Result,memenv), "wxXmlResource");
 break;
}
case wxXmlResource_GetFlags: { // wxXmlResource::GetFlags
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFlags();
 rt.addInt(Result);
 break;
}
case wxXmlResource_GetVersion: { // wxXmlResource::GetVersion
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetVersion();
 rt.addInt(Result);
 break;
}
case wxXmlResource_GetXRCID: { // wxXmlResource::GetXRCID
 int value_if_not_found=wxID_NONE;
 int * str_idLen = (int *) bp; bp += 4;
 wxString str_id = wxString(bp, wxConvUTF8);
 bp += *str_idLen+((8-((4+ *str_idLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 value_if_not_found = (int)*(int *) bp; bp += 4;
  } break;
 }};
 int Result = wxXmlResource::GetXRCID(str_id,value_if_not_found);
 rt.addInt(Result);
 break;
}
case wxXmlResource_InitAllHandlers: { // wxXmlResource::InitAllHandlers
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->InitAllHandlers();
 break;
}
case wxXmlResource_Load: { // wxXmlResource::Load
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * filemaskLen = (int *) bp; bp += 4;
 wxString filemask = wxString(bp, wxConvUTF8);
 bp += *filemaskLen+((8-((0+ *filemaskLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Load(filemask);
 rt.addBool(Result);
 break;
}
case wxXmlResource_LoadBitmap: { // wxXmlResource::LoadBitmap
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxBitmap * Result = new EwxBitmap(This->LoadBitmap(name)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxXmlResource_LoadDialog_2: { // wxXmlResource::LoadDialog
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxDialog * Result = (wxDialog*)This->LoadDialog(parent,name);
 rt.addRef(getRef((void *)Result,memenv), "wxDialog");
 break;
}
case wxXmlResource_LoadDialog_3: { // wxXmlResource::LoadDialog
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxDialog *dlg = (wxDialog *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->LoadDialog(dlg,parent,name);
 rt.addBool(Result);
 break;
}
case wxXmlResource_LoadFrame_2: { // wxXmlResource::LoadFrame
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxFrame * Result = (wxFrame*)This->LoadFrame(parent,name);
 rt.addRef(getRef((void *)Result,memenv), "wxFrame");
 break;
}
case wxXmlResource_LoadFrame_3: { // wxXmlResource::LoadFrame
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxFrame *frame = (wxFrame *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->LoadFrame(frame,parent,name);
 rt.addBool(Result);
 break;
}
case wxXmlResource_LoadIcon: { // wxXmlResource::LoadIcon
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxIcon * Result = new EwxIcon(This->LoadIcon(name)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxIcon");
 break;
}
case wxXmlResource_LoadMenu: { // wxXmlResource::LoadMenu
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxMenu * Result = (wxMenu*)This->LoadMenu(name);
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxXmlResource_LoadMenuBar_2: { // wxXmlResource::LoadMenuBar
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxMenuBar * Result = (wxMenuBar*)This->LoadMenuBar(parent,name);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuBar");
 break;
}
case wxXmlResource_LoadMenuBar_1: { // wxXmlResource::LoadMenuBar
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxMenuBar * Result = (wxMenuBar*)This->LoadMenuBar(name);
 rt.addRef(getRef((void *)Result,memenv), "wxMenuBar");
 break;
}
case wxXmlResource_LoadPanel_2: { // wxXmlResource::LoadPanel
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxPanel * Result = (wxPanel*)This->LoadPanel(parent,name);
 rt.addRef(getRef((void *)Result,memenv), "wxPanel");
 break;
}
case wxXmlResource_LoadPanel_3: { // wxXmlResource::LoadPanel
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxPanel *panel = (wxPanel *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->LoadPanel(panel,parent,name);
 rt.addBool(Result);
 break;
}
case wxXmlResource_LoadToolBar: { // wxXmlResource::LoadToolBar
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((4+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxToolBar * Result = (wxToolBar*)This->LoadToolBar(parent,name);
 rt.addRef(getRef((void *)Result,memenv), "wxToolBar");
 break;
}
case wxXmlResource_Set: { // wxXmlResource::Set
 wxXmlResource *res = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 wxXmlResource * Result = (wxXmlResource*)wxXmlResource::Set(res);
 rt.addRef(getRef((void *)Result,memenv), "wxXmlResource");
 break;
}
case wxXmlResource_SetFlags: { // wxXmlResource::SetFlags
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * flags = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFlags(*flags);
 break;
}
case wxXmlResource_Unload: { // wxXmlResource::Unload
 wxXmlResource *This = (wxXmlResource *) getPtr(bp,memenv); bp += 4;
 int * filenameLen = (int *) bp; bp += 4;
 wxString filename = wxString(bp, wxConvUTF8);
 bp += *filenameLen+((8-((0+ *filenameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->Unload(filename);
 rt.addBool(Result);
 break;
}

// XRCTRL macro implemented in erlang funcid wxXmlResource_xrcctrl
case wxHtmlEasyPrinting_new: { // wxHtmlEasyPrinting::wxHtmlEasyPrinting
 wxString name= wxT("Printing");
 wxWindow * parentWindow=NULL;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
  } break;
  case 2: {bp += 4;
parentWindow = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxHtmlEasyPrinting * Result = new EwxHtmlEasyPrinting(name,parentWindow);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxHtmlEasyPrinting");
 break;
}
case wxHtmlEasyPrinting_GetPrintData: { // wxHtmlEasyPrinting::GetPrintData
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPrintData * Result = (wxPrintData*)This->GetPrintData();
 rt.addRef(getRef((void *)Result,memenv), "wxPrintData");
 break;
}
case wxHtmlEasyPrinting_GetPageSetupData: { // wxHtmlEasyPrinting::GetPageSetupData
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPageSetupDialogData * Result = (wxPageSetupDialogData*)This->GetPageSetupData();
 rt.addRef(getRef((void *)Result,memenv), "wxPageSetupDialogData");
 break;
}
case wxHtmlEasyPrinting_PreviewFile: { // wxHtmlEasyPrinting::PreviewFile
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 int * htmlfileLen = (int *) bp; bp += 4;
 wxString htmlfile = wxString(bp, wxConvUTF8);
 bp += *htmlfileLen+((8-((0+ *htmlfileLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->PreviewFile(htmlfile);
 rt.addBool(Result);
 break;
}
case wxHtmlEasyPrinting_PreviewText: { // wxHtmlEasyPrinting::PreviewText
 wxString basepath= wxEmptyString;
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 int * htmltextLen = (int *) bp; bp += 4;
 wxString htmltext = wxString(bp, wxConvUTF8);
 bp += *htmltextLen+((8-((0+ *htmltextLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * basepathLen = (int *) bp; bp += 4;
 basepath = wxString(bp, wxConvUTF8);
 bp += *basepathLen+((8-((0+ *basepathLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->PreviewText(htmltext,basepath);
 rt.addBool(Result);
 break;
}
case wxHtmlEasyPrinting_PrintFile: { // wxHtmlEasyPrinting::PrintFile
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 int * htmlfileLen = (int *) bp; bp += 4;
 wxString htmlfile = wxString(bp, wxConvUTF8);
 bp += *htmlfileLen+((8-((0+ *htmlfileLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->PrintFile(htmlfile);
 rt.addBool(Result);
 break;
}
case wxHtmlEasyPrinting_PrintText: { // wxHtmlEasyPrinting::PrintText
 wxString basepath= wxEmptyString;
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 int * htmltextLen = (int *) bp; bp += 4;
 wxString htmltext = wxString(bp, wxConvUTF8);
 bp += *htmltextLen+((8-((0+ *htmltextLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * basepathLen = (int *) bp; bp += 4;
 basepath = wxString(bp, wxConvUTF8);
 bp += *basepathLen+((8-((0+ *basepathLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->PrintText(htmltext,basepath);
 rt.addBool(Result);
 break;
}
case wxHtmlEasyPrinting_PageSetup: { // wxHtmlEasyPrinting::PageSetup
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->PageSetup();
 break;
}
case wxHtmlEasyPrinting_SetFonts: { // wxHtmlEasyPrinting::SetFonts
 int * sizesLen = 0;
 int * sizes = (int *) NULL;
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 int * normal_faceLen = (int *) bp; bp += 4;
 wxString normal_face = wxString(bp, wxConvUTF8);
 bp += *normal_faceLen+((8-((0+ *normal_faceLen) & 7)) & 7);
 int * fixed_faceLen = (int *) bp; bp += 4;
 wxString fixed_face = wxString(bp, wxConvUTF8);
 bp += *fixed_faceLen+((8-((4+ *fixed_faceLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 sizesLen = (int *) bp; bp += 4;
 sizes = (int *) bp; bp += *sizesLen*4+((0+ *sizesLen)%2 )*4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetFonts(normal_face,fixed_face,sizes);
 break;
}
case wxHtmlEasyPrinting_SetHeader: { // wxHtmlEasyPrinting::SetHeader
 int pg=wxPAGE_ALL;
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 int * headerLen = (int *) bp; bp += 4;
 wxString header = wxString(bp, wxConvUTF8);
 bp += *headerLen+((8-((0+ *headerLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 pg = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetHeader(header,pg);
 break;
}
case wxHtmlEasyPrinting_SetFooter: { // wxHtmlEasyPrinting::SetFooter
 int pg=wxPAGE_ALL;
 wxHtmlEasyPrinting *This = (wxHtmlEasyPrinting *) getPtr(bp,memenv); bp += 4;
 int * footerLen = (int *) bp; bp += 4;
 wxString footer = wxString(bp, wxConvUTF8);
 bp += *footerLen+((8-((0+ *footerLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 pg = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->SetFooter(footer,pg);
 break;
}
case wxGLCanvas_new_2: { // wxGLCanvas::wxGLCanvas
 wxWindowID id=-1;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxString name= wxGLCanvasName;
 int * attribListLen = 0;
 int * attribList = (int *) NULL;
 const wxPalette * palette= &wxNullPalette;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
  } break;
  case 6: {bp += 4;
 attribListLen = (int *) bp; bp += 4;
 attribList = (int *) bp; bp += *attribListLen*4+((0+ *attribListLen)%2 )*4;
  } break;
  case 7: {bp += 4;
palette = (wxPalette *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxGLCanvas * Result = new EwxGLCanvas(parent,id,pos,size,style,name,attribList,*palette);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGLCanvas");
 break;
}
case wxGLCanvas_new_3_1: { // wxGLCanvas::wxGLCanvas
 wxWindowID id=-1;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxString name= wxGLCanvasName;
 int * attribListLen = 0;
 int * attribList = (int *) NULL;
 const wxPalette * palette= &wxNullPalette;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxGLContext * shared = (wxGLContext *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
  } break;
  case 6: {bp += 4;
 attribListLen = (int *) bp; bp += 4;
 attribList = (int *) bp; bp += *attribListLen*4+((0+ *attribListLen)%2 )*4;
  } break;
  case 7: {bp += 4;
palette = (wxPalette *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxGLCanvas * Result = new EwxGLCanvas(parent,shared,id,pos,size,style,name,attribList,*palette);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGLCanvas");
 break;
}
case wxGLCanvas_new_3_0: { // wxGLCanvas::wxGLCanvas
 wxWindowID id=-1;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxString name= wxGLCanvasName;
 int * attribListLen = 0;
 int * attribList = (int *) NULL;
 const wxPalette * palette= &wxNullPalette;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxGLCanvas *shared = (wxGLCanvas *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
  case 5: {bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
  } break;
  case 6: {bp += 4;
 attribListLen = (int *) bp; bp += 4;
 attribList = (int *) bp; bp += *attribListLen*4+((0+ *attribListLen)%2 )*4;
  } break;
  case 7: {bp += 4;
palette = (wxPalette *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 wxGLCanvas * Result = new EwxGLCanvas(parent,shared,id,pos,size,style,name,attribList,*palette);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxGLCanvas");
 break;
}
case wxGLCanvas_GetContext: { // wxGLCanvas::GetContext
 wxGLCanvas *This = (wxGLCanvas *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxGLContext * Result = (wxGLContext*)This->GetContext();
 rt.addRef(getRef((void *)Result,memenv), "wxGLContext");
 break;
}
case wxGLCanvas_SetCurrent: { // wxGLCanvas::SetCurrent
 wxGLCanvas *This = (wxGLCanvas *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCurrent();
 if(This->GetContext()) setActiveGL(Ecmd.caller,This);
 break;
}
case wxGLCanvas_SwapBuffers: { // wxGLCanvas::SwapBuffers
 wxGLCanvas *This = (wxGLCanvas *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SwapBuffers();
 break;
}
#if wxUSE_AUI
case wxAuiManager_new: { // wxAuiManager::wxAuiManager
 wxWindow * managed_wnd=NULL;
 int flags=wxAUI_MGR_DEFAULT;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
managed_wnd = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
  case 2: {bp += 4;
 flags = (int)*(unsigned int *) bp; bp += 4;
  } break;
 }};
 wxAuiManager * Result = new EwxAuiManager(managed_wnd,flags);
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiManager");
 break;
}
case wxAuiManager_AddPane_2_1: { // wxAuiManager::AddPane
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxAuiPaneInfo *pane_info = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPane(window,*pane_info);
 rt.addBool(Result);
 break;
}
case wxAuiManager_AddPane_3: { // wxAuiManager::AddPane
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxAuiPaneInfo *pane_info = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * drop_posX = (int *) bp; bp += 4;
 int * drop_posY = (int *) bp; bp += 4;
 wxPoint drop_pos = wxPoint(*drop_posX,*drop_posY);
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPane(window,*pane_info,drop_pos);
 rt.addBool(Result);
 break;
}
case wxAuiManager_AddPane_2_0: { // wxAuiManager::AddPane
 int direction=wxLEFT;
 wxString caption= wxEmptyString;
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 direction = (int)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * captionLen = (int *) bp; bp += 4;
 caption = wxString(bp, wxConvUTF8);
 bp += *captionLen+((8-((0+ *captionLen) & 7)) & 7);
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPane(window,direction,caption);
 rt.addBool(Result);
 break;
}
case wxAuiManager_DetachPane: { // wxAuiManager::DetachPane
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DetachPane(window);
 rt.addBool(Result);
 break;
}
case wxAuiManager_GetAllPanes: { // wxAuiManager::GetAllPanes
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfoArray Result = This->GetAllPanes();
 for(unsigned int i=0; i < Result.GetCount(); i++) {
  rt.addRef(getRef((void *) &Result.Item(i), memenv), "wxAuiPaneInfo");
 }
 rt.endList(Result.GetCount());
 break;
}
case wxAuiManager_GetArtProvider: { // wxAuiManager::GetArtProvider
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiDockArt * Result = (wxAuiDockArt*)This->GetArtProvider();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiDockArt");
 break;
}
case wxAuiManager_GetDockSizeConstraint: { // wxAuiManager::GetDockSizeConstraint
 double width_pct;
 double height_pct;
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetDockSizeConstraint(&width_pct,&height_pct);
 rt.ensureFloatCount(3);
 rt.addFloat(width_pct);
 rt.addFloat(height_pct);
 rt.addTupleCount(2);
 break;
}
case wxAuiManager_GetFlags: { // wxAuiManager::GetFlags
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFlags();
 rt.addUint(Result);
 break;
}
case wxAuiManager_GetManagedWindow: { // wxAuiManager::GetManagedWindow
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetManagedWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxAuiManager_GetManager: { // wxAuiManager::GetManager
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxAuiManager * Result = (wxAuiManager*)wxAuiManager::GetManager(window);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiManager");
 break;
}
case wxAuiManager_GetPane_1_1: { // wxAuiManager::GetPane
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->GetPane(window);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiManager_GetPane_1_0: { // wxAuiManager::GetPane
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 int * nameLen = (int *) bp; bp += 4;
 wxString name = wxString(bp, wxConvUTF8);
 bp += *nameLen+((8-((0+ *nameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->GetPane(name);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiManager_HideHint: { // wxAuiManager::HideHint
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->HideHint();
 break;
}
case wxAuiManager_InsertPane: { // wxAuiManager::InsertPane
 int insert_level=wxAUI_INSERT_PANE;
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxWindow *window = (wxWindow *) getPtr(bp,memenv); bp += 4;
 wxAuiPaneInfo *insert_location = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 insert_level = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertPane(window,*insert_location,insert_level);
 rt.addBool(Result);
 break;
}
case wxAuiManager_LoadPaneInfo: { // wxAuiManager::LoadPaneInfo
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 int * pane_partLen = (int *) bp; bp += 4;
 wxString pane_part = wxString(bp, wxConvUTF8);
 bp += *pane_partLen+((8-((0+ *pane_partLen) & 7)) & 7);
 wxAuiPaneInfo *pane = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LoadPaneInfo(pane_part,*pane);
 break;
}
case wxAuiManager_LoadPerspective: { // wxAuiManager::LoadPerspective
 bool update=true;
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 int * perspectiveLen = (int *) bp; bp += 4;
 wxString perspective = wxString(bp, wxConvUTF8);
 bp += *perspectiveLen+((8-((0+ *perspectiveLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 update = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->LoadPerspective(perspective,update);
 rt.addBool(Result);
 break;
}
case wxAuiManager_SavePaneInfo: { // wxAuiManager::SavePaneInfo
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxAuiPaneInfo *pane = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->SavePaneInfo(*pane);
 rt.add(Result);
 break;
}
case wxAuiManager_SavePerspective: { // wxAuiManager::SavePerspective
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->SavePerspective();
 rt.add(Result);
 break;
}
case wxAuiManager_SetArtProvider: { // wxAuiManager::SetArtProvider
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxAuiDockArt *art_provider = (wxAuiDockArt *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetArtProvider(art_provider);
 break;
}
case wxAuiManager_SetDockSizeConstraint: { // wxAuiManager::SetDockSizeConstraint
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 double * width_pct = (double *) bp; bp += 8;
 double * height_pct = (double *) bp; bp += 8;
 if(!This) throw wxe_badarg(0);
 This->SetDockSizeConstraint(*width_pct,*height_pct);
 break;
}
case wxAuiManager_SetFlags: { // wxAuiManager::SetFlags
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 unsigned int * flags = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFlags(*flags);
 break;
}
case wxAuiManager_SetManagedWindow: { // wxAuiManager::SetManagedWindow
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 wxWindow *managed_wnd = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetManagedWindow(managed_wnd);
 break;
}
case wxAuiManager_ShowHint: { // wxAuiManager::ShowHint
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 wxRect rect = wxRect(*rectX,*rectY,*rectW,*rectH);
 if(!This) throw wxe_badarg(0);
 This->ShowHint(rect);
 break;
}
case wxAuiManager_UnInit: { // wxAuiManager::UnInit
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->UnInit();
 break;
}
case wxAuiManager_Update: { // wxAuiManager::Update
 wxAuiManager *This = (wxAuiManager *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Update();
 break;
}
#endif // wxUSE_AUI
#if wxUSE_AUI
case wxAuiPaneInfo_new_0: { // wxAuiPaneInfo::wxAuiPaneInfo
 wxAuiPaneInfo * Result = new wxAuiPaneInfo();
 newPtr((void *) Result, 155, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_new_1: { // wxAuiPaneInfo::wxAuiPaneInfo
 wxAuiPaneInfo *c = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 wxAuiPaneInfo * Result = new wxAuiPaneInfo(*c);
 newPtr((void *) Result, 155, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_destruct: { // wxAuiPaneInfo::~wxAuiPaneInfo
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
case wxAuiPaneInfo_BestSize_1: { // wxAuiPaneInfo::BestSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->BestSize(size);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_BestSize_2: { // wxAuiPaneInfo::BestSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->BestSize(*x,*y);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Bottom: { // wxAuiPaneInfo::Bottom
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Bottom();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_BottomDockable: { // wxAuiPaneInfo::BottomDockable
 bool b=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 b = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->BottomDockable(b);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Caption: { // wxAuiPaneInfo::Caption
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * cLen = (int *) bp; bp += 4;
 wxString c = wxString(bp, wxConvUTF8);
 bp += *cLen+((8-((0+ *cLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Caption(c);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_CaptionVisible: { // wxAuiPaneInfo::CaptionVisible
 bool visible=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 visible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->CaptionVisible(visible);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Centre: { // wxAuiPaneInfo::Centre
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Centre();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_CentrePane: { // wxAuiPaneInfo::CentrePane
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->CentrePane();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_CloseButton: { // wxAuiPaneInfo::CloseButton
 bool visible=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 visible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->CloseButton(visible);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_DefaultPane: { // wxAuiPaneInfo::DefaultPane
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->DefaultPane();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_DestroyOnClose: { // wxAuiPaneInfo::DestroyOnClose
 bool b=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 b = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->DestroyOnClose(b);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Direction: { // wxAuiPaneInfo::Direction
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * direction = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Direction(*direction);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Dock: { // wxAuiPaneInfo::Dock
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Dock();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Dockable: { // wxAuiPaneInfo::Dockable
 bool b=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 b = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Dockable(b);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Fixed: { // wxAuiPaneInfo::Fixed
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Fixed();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Float: { // wxAuiPaneInfo::Float
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Float();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Floatable: { // wxAuiPaneInfo::Floatable
 bool b=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 b = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Floatable(b);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_FloatingPosition_1: { // wxAuiPaneInfo::FloatingPosition
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->FloatingPosition(pos);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_FloatingPosition_2: { // wxAuiPaneInfo::FloatingPosition
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->FloatingPosition(*x,*y);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_FloatingSize_1: { // wxAuiPaneInfo::FloatingSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->FloatingSize(size);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_FloatingSize_2: { // wxAuiPaneInfo::FloatingSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->FloatingSize(*x,*y);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Gripper: { // wxAuiPaneInfo::Gripper
 bool visible=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 visible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Gripper(visible);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_GripperTop: { // wxAuiPaneInfo::GripperTop
 bool attop=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 attop = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->GripperTop(attop);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_HasBorder: { // wxAuiPaneInfo::HasBorder
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasBorder();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_HasCaption: { // wxAuiPaneInfo::HasCaption
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasCaption();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_HasCloseButton: { // wxAuiPaneInfo::HasCloseButton
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasCloseButton();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_HasFlag: { // wxAuiPaneInfo::HasFlag
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 unsigned int * flag = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasFlag(*flag);
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_HasGripper: { // wxAuiPaneInfo::HasGripper
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasGripper();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_HasGripperTop: { // wxAuiPaneInfo::HasGripperTop
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasGripperTop();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_HasMaximizeButton: { // wxAuiPaneInfo::HasMaximizeButton
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasMaximizeButton();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_HasMinimizeButton: { // wxAuiPaneInfo::HasMinimizeButton
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasMinimizeButton();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_HasPinButton: { // wxAuiPaneInfo::HasPinButton
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasPinButton();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_Hide: { // wxAuiPaneInfo::Hide
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Hide();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_IsBottomDockable: { // wxAuiPaneInfo::IsBottomDockable
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsBottomDockable();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsDocked: { // wxAuiPaneInfo::IsDocked
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsDocked();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsFixed: { // wxAuiPaneInfo::IsFixed
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsFixed();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsFloatable: { // wxAuiPaneInfo::IsFloatable
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsFloatable();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsFloating: { // wxAuiPaneInfo::IsFloating
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsFloating();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsLeftDockable: { // wxAuiPaneInfo::IsLeftDockable
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsLeftDockable();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsMovable: { // wxAuiPaneInfo::IsMovable
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsMovable();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsOk: { // wxAuiPaneInfo::IsOk
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsOk();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsResizable: { // wxAuiPaneInfo::IsResizable
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsResizable();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsRightDockable: { // wxAuiPaneInfo::IsRightDockable
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsRightDockable();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsShown: { // wxAuiPaneInfo::IsShown
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsShown();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsToolbar: { // wxAuiPaneInfo::IsToolbar
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsToolbar();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_IsTopDockable: { // wxAuiPaneInfo::IsTopDockable
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsTopDockable();
 rt.addBool(Result);
 break;
}
case wxAuiPaneInfo_Layer: { // wxAuiPaneInfo::Layer
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * layer = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Layer(*layer);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Left: { // wxAuiPaneInfo::Left
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Left();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_LeftDockable: { // wxAuiPaneInfo::LeftDockable
 bool b=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 b = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->LeftDockable(b);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_MaxSize_1: { // wxAuiPaneInfo::MaxSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->MaxSize(size);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_MaxSize_2: { // wxAuiPaneInfo::MaxSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->MaxSize(*x,*y);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_MaximizeButton: { // wxAuiPaneInfo::MaximizeButton
 bool visible=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 visible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->MaximizeButton(visible);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_MinSize_1: { // wxAuiPaneInfo::MinSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->MinSize(size);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_MinSize_2: { // wxAuiPaneInfo::MinSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->MinSize(*x,*y);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_MinimizeButton: { // wxAuiPaneInfo::MinimizeButton
 bool visible=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 visible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->MinimizeButton(visible);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Movable: { // wxAuiPaneInfo::Movable
 bool b=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 b = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Movable(b);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Name: { // wxAuiPaneInfo::Name
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * nLen = (int *) bp; bp += 4;
 wxString n = wxString(bp, wxConvUTF8);
 bp += *nLen+((8-((0+ *nLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Name(n);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_PaneBorder: { // wxAuiPaneInfo::PaneBorder
 bool visible=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 visible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->PaneBorder(visible);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_PinButton: { // wxAuiPaneInfo::PinButton
 bool visible=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 visible = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->PinButton(visible);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Position: { // wxAuiPaneInfo::Position
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Position(*pos);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Resizable: { // wxAuiPaneInfo::Resizable
 bool resizable=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 resizable = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Resizable(resizable);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Right: { // wxAuiPaneInfo::Right
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Right();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_RightDockable: { // wxAuiPaneInfo::RightDockable
 bool b=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 b = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->RightDockable(b);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Row: { // wxAuiPaneInfo::Row
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 int * row = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Row(*row);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_SafeSet: { // wxAuiPaneInfo::SafeSet
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 wxAuiPaneInfo *source = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SafeSet(*source);
 break;
}
case wxAuiPaneInfo_SetFlag: { // wxAuiPaneInfo::SetFlag
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 unsigned int * flag = (unsigned int *) bp; bp += 4;
 bool * option_state = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->SetFlag(*flag,*option_state);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Show: { // wxAuiPaneInfo::Show
 bool show=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 show = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Show(show);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_ToolbarPane: { // wxAuiPaneInfo::ToolbarPane
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->ToolbarPane();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Top: { // wxAuiPaneInfo::Top
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Top();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_TopDockable: { // wxAuiPaneInfo::TopDockable
 bool b=true;
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 b = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->TopDockable(b);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_Window: { // wxAuiPaneInfo::Window
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 wxWindow *w = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiPaneInfo * Result = &This->Window(w);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiPaneInfo");
 break;
}
case wxAuiPaneInfo_GetWindow: { // wxAuiPaneInfo::GetWindow
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 #if 0
;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetWindow();
 #endif
 if(!This) throw wxe_badarg(0);
 wxWindow* Result = This->window;
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxAuiPaneInfo_GetFrame: { // wxAuiPaneInfo::GetFrame
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 #if 0
;
 if(!This) throw wxe_badarg(0);
 wxFrame * Result = (wxFrame*)This->GetFrame();
 #endif
 if(!This) throw wxe_badarg(0);
 wxFrame* Result = This->frame;
 rt.addRef(getRef((void *)Result,memenv), "wxFrame");
 break;
}
case wxAuiPaneInfo_GetDirection: { // wxAuiPaneInfo::GetDirection
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 #if 0
;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDirection();
 #endif
 if(!This) throw wxe_badarg(0);
 int Result = This->dock_direction;
 rt.addInt(Result);
 break;
}
case wxAuiPaneInfo_GetLayer: { // wxAuiPaneInfo::GetLayer
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 #if 0
;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLayer();
 #endif
 if(!This) throw wxe_badarg(0);
 int Result = This->dock_layer;
 rt.addInt(Result);
 break;
}
case wxAuiPaneInfo_GetRow: { // wxAuiPaneInfo::GetRow
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 #if 0
;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRow();
 #endif
 if(!This) throw wxe_badarg(0);
 int Result = This->dock_row;
 rt.addInt(Result);
 break;
}
case wxAuiPaneInfo_GetPosition: { // wxAuiPaneInfo::GetPosition
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 #if 0
;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPosition();
 #endif
 if(!This) throw wxe_badarg(0);
 int Result = This->dock_pos;
 rt.addInt(Result);
 break;
}
case wxAuiPaneInfo_GetFloatingPosition: { // wxAuiPaneInfo::GetFloatingPosition
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 #if 0
;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetFloatingPosition();
 #endif
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->floating_pos;
 rt.add(Result);
 break;
}
case wxAuiPaneInfo_GetFloatingSize: { // wxAuiPaneInfo::GetFloatingSize
 wxAuiPaneInfo *This = (wxAuiPaneInfo *) getPtr(bp,memenv); bp += 4;
 #if 0
;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetFloatingSize();
 #endif
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->floating_size;
 rt.add(Result);
 break;
}
#endif // wxUSE_AUI
#if wxUSE_AUI
case wxAuiNotebook_new_0: { // wxAuiNotebook::wxAuiNotebook
 wxAuiNotebook * Result = new EwxAuiNotebook();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiNotebook");
 break;
}
case wxAuiNotebook_new_2: { // wxAuiNotebook::wxAuiNotebook
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxAUI_NB_DEFAULT_STYLE;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxAuiNotebook * Result = new EwxAuiNotebook(parent,id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiNotebook");
 break;
}
case wxAuiNotebook_AddPage: { // wxAuiNotebook::AddPage
 bool select=false;
 const wxBitmap * bitmap= &wxNullBitmap;
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * captionLen = (int *) bp; bp += 4;
 wxString caption = wxString(bp, wxConvUTF8);
 bp += *captionLen+((8-((4+ *captionLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 select = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->AddPage(page,caption,select,*bitmap);
 rt.addBool(Result);
 break;
}
case wxAuiNotebook_Create: { // wxAuiNotebook::Create
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxAuiNotebook_DeletePage: { // wxAuiNotebook::DeletePage
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * page = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->DeletePage(*page);
 rt.addBool(Result);
 break;
}
case wxAuiNotebook_GetArtProvider: { // wxAuiNotebook::GetArtProvider
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxAuiTabArt * Result = (wxAuiTabArt*)This->GetArtProvider();
 rt.addRef(getRef((void *)Result,memenv), "wxAuiTabArt");
 break;
}
case wxAuiNotebook_GetPage: { // wxAuiNotebook::GetPage
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * page_idx = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetPage(*page_idx);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxAuiNotebook_GetPageBitmap: { // wxAuiNotebook::GetPageBitmap
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * page_idx = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxBitmap * Result = new EwxBitmap(This->GetPageBitmap(*page_idx)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxBitmap");
 break;
}
case wxAuiNotebook_GetPageCount: { // wxAuiNotebook::GetPageCount
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->GetPageCount();
 rt.addInt(Result);
 break;
}
case wxAuiNotebook_GetPageIndex: { // wxAuiNotebook::GetPageIndex
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 wxWindow *page_wnd = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPageIndex(page_wnd);
 rt.addInt(Result);
 break;
}
case wxAuiNotebook_GetPageText: { // wxAuiNotebook::GetPageText
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * page_idx = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPageText(*page_idx);
 rt.add(Result);
 break;
}
case wxAuiNotebook_GetSelection: { // wxAuiNotebook::GetSelection
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxAuiNotebook_InsertPage: { // wxAuiNotebook::InsertPage
 bool select=false;
 const wxBitmap * bitmap= &wxNullBitmap;
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * page_idx = (int *) bp; bp += 4;
 wxWindow *page = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * captionLen = (int *) bp; bp += 4;
 wxString caption = wxString(bp, wxConvUTF8);
 bp += *captionLen+((8-((0+ *captionLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 select = *(bool *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->InsertPage(*page_idx,page,caption,select,*bitmap);
 rt.addBool(Result);
 break;
}
case wxAuiNotebook_RemovePage: { // wxAuiNotebook::RemovePage
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * page = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RemovePage(*page);
 rt.addBool(Result);
 break;
}
case wxAuiNotebook_SetArtProvider: { // wxAuiNotebook::SetArtProvider
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 wxAuiTabArt *art = (wxAuiTabArt *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetArtProvider(art);
 break;
}
case wxAuiNotebook_SetFont: { // wxAuiNotebook::SetFont
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetFont(*font);
 rt.addBool(Result);
 break;
}
case wxAuiNotebook_SetPageBitmap: { // wxAuiNotebook::SetPageBitmap
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * page = (int *) bp; bp += 4;
 wxBitmap *bitmap = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageBitmap(*page,*bitmap);
 rt.addBool(Result);
 break;
}
case wxAuiNotebook_SetPageText: { // wxAuiNotebook::SetPageText
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * page = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 bool Result = This->SetPageText(*page,text);
 rt.addBool(Result);
 break;
}
case wxAuiNotebook_SetSelection: { // wxAuiNotebook::SetSelection
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * new_page = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 size_t Result = This->SetSelection(*new_page);
 rt.addInt(Result);
 break;
}
case wxAuiNotebook_SetTabCtrlHeight: { // wxAuiNotebook::SetTabCtrlHeight
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * height = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTabCtrlHeight(*height);
 break;
}
case wxAuiNotebook_SetUniformBitmapSize: { // wxAuiNotebook::SetUniformBitmapSize
 wxAuiNotebook *This = (wxAuiNotebook *) getPtr(bp,memenv); bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 wxSize size = wxSize(*sizeW,*sizeH);
 if(!This) throw wxe_badarg(0);
 This->SetUniformBitmapSize(size);
 break;
}
#endif // wxUSE_AUI
#if wxUSE_AUI
case wxAuiTabArt_SetFlags: { // wxAuiTabArt::SetFlags
 wxAuiTabArt *This = (wxAuiTabArt *) getPtr(bp,memenv); bp += 4;
 unsigned int * flags = (unsigned int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFlags(*flags);
 break;
}
case wxAuiTabArt_SetMeasuringFont: { // wxAuiTabArt::SetMeasuringFont
 wxAuiTabArt *This = (wxAuiTabArt *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMeasuringFont(*font);
 break;
}
case wxAuiTabArt_SetNormalFont: { // wxAuiTabArt::SetNormalFont
 wxAuiTabArt *This = (wxAuiTabArt *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetNormalFont(*font);
 break;
}
case wxAuiTabArt_SetSelectedFont: { // wxAuiTabArt::SetSelectedFont
 wxAuiTabArt *This = (wxAuiTabArt *) getPtr(bp,memenv); bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelectedFont(*font);
 break;
}
#if wxCHECK_VERSION(3,0,0)
case wxAuiTabArt_SetColour: { // wxAuiTabArt::SetColour
 wxAuiTabArt *This = (wxAuiTabArt *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetColour(colour);
 break;
}
#endif
#if wxCHECK_VERSION(3,0,0)
case wxAuiTabArt_SetActiveColour: { // wxAuiTabArt::SetActiveColour
 wxAuiTabArt *This = (wxAuiTabArt *) getPtr(bp,memenv); bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetActiveColour(colour);
 break;
}
#endif
#endif // wxUSE_AUI
#if wxUSE_AUI
case wxAuiDockArt_GetColour: { // wxAuiDockArt::GetColour
 wxAuiDockArt *This = (wxAuiDockArt *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetColour(*id);
 rt.add(Result);
 break;
}
case wxAuiDockArt_GetFont: { // wxAuiDockArt::GetFont
 wxAuiDockArt *This = (wxAuiDockArt *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetFont(*id)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxAuiDockArt_GetMetric: { // wxAuiDockArt::GetMetric
 wxAuiDockArt *This = (wxAuiDockArt *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMetric(*id);
 rt.addInt(Result);
 break;
}
case wxAuiDockArt_SetColour: { // wxAuiDockArt::SetColour
 wxAuiDockArt *This = (wxAuiDockArt *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * colourR = (int *) bp; bp += 4;
 int * colourG = (int *) bp; bp += 4;
 int * colourB = (int *) bp; bp += 4;
 int * colourA = (int *) bp; bp += 4;
 wxColour colour = wxColour(*colourR,*colourG,*colourB,*colourA);
 if(!This) throw wxe_badarg(0);
 This->SetColour(*id,colour);
 break;
}
case wxAuiDockArt_SetFont: { // wxAuiDockArt::SetFont
 wxAuiDockArt *This = (wxAuiDockArt *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 wxFont *font = (wxFont *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFont(*id,*font);
 break;
}
case wxAuiDockArt_SetMetric: { // wxAuiDockArt::SetMetric
 wxAuiDockArt *This = (wxAuiDockArt *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * new_val = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMetric(*id,*new_val);
 break;
}
#endif // wxUSE_AUI
#if wxUSE_AUI
case wxAuiSimpleTabArt_new: { // wxAuiSimpleTabArt::wxAuiSimpleTabArt
 wxAuiSimpleTabArt * Result = new wxAuiSimpleTabArt();
 newPtr((void *) Result, 159, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxAuiSimpleTabArt");
 break;
}
case wxAuiSimpleTabArt_destroy: { // wxAuiSimpleTabArt::destroy
 wxAuiSimpleTabArt *This = (wxAuiSimpleTabArt *) getPtr(bp,memenv); bp += 4;
 if(This) {   ((WxeApp *) wxTheApp)->clearPtr((void *) This);
   delete This;}
 break;
}
#endif // wxUSE_AUI
case wxMDIParentFrame_new_0: { // wxMDIParentFrame::wxMDIParentFrame
 wxMDIParentFrame * Result = new EwxMDIParentFrame();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMDIParentFrame");
 break;
}
case wxMDIParentFrame_new_4: { // wxMDIParentFrame::wxMDIParentFrame
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_FRAME_STYLE|wxVSCROLL|wxHSCROLL;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxMDIParentFrame * Result = new EwxMDIParentFrame(parent,*id,title,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMDIParentFrame");
 break;
}
case wxMDIParentFrame_ActivateNext: { // wxMDIParentFrame::ActivateNext
 wxMDIParentFrame *This = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ActivateNext();
 break;
}
case wxMDIParentFrame_ActivatePrevious: { // wxMDIParentFrame::ActivatePrevious
 wxMDIParentFrame *This = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ActivatePrevious();
 break;
}
case wxMDIParentFrame_ArrangeIcons: { // wxMDIParentFrame::ArrangeIcons
 wxMDIParentFrame *This = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ArrangeIcons();
 break;
}
case wxMDIParentFrame_Cascade: { // wxMDIParentFrame::Cascade
 wxMDIParentFrame *This = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Cascade();
 break;
}
case wxMDIParentFrame_Create: { // wxMDIParentFrame::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_FRAME_STYLE|wxVSCROLL|wxHSCROLL;
 wxMDIParentFrame *This = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,title,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxMDIParentFrame_GetActiveChild: { // wxMDIParentFrame::GetActiveChild
 wxMDIParentFrame *This = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMDIChildFrame * Result = (wxMDIChildFrame*)This->GetActiveChild();
 rt.addRef(getRef((void *)Result,memenv), "wxMDIChildFrame");
 break;
}
case wxMDIParentFrame_GetClientWindow: { // wxMDIParentFrame::GetClientWindow
 wxMDIParentFrame *This = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMDIClientWindow * Result = (wxMDIClientWindow*)This->GetClientWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxMDIClientWindow");
 break;
}
case wxMDIParentFrame_Tile: { // wxMDIParentFrame::Tile
 wxOrientation orient=wxHORIZONTAL;
 wxMDIParentFrame *This = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
orient = *(wxOrientation *) bp; bp += 4;;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Tile(orient);
 break;
}
case wxMDIChildFrame_new_0: { // wxMDIChildFrame::wxMDIChildFrame
 wxMDIChildFrame * Result = new EwxMDIChildFrame();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMDIChildFrame");
 break;
}
case wxMDIChildFrame_new_4: { // wxMDIChildFrame::wxMDIChildFrame
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_FRAME_STYLE;
 wxMDIParentFrame *parent = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxMDIChildFrame * Result = new EwxMDIChildFrame(parent,*id,title,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMDIChildFrame");
 break;
}
case wxMDIChildFrame_Activate: { // wxMDIChildFrame::Activate
 wxMDIChildFrame *This = (wxMDIChildFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Activate();
 break;
}
case wxMDIChildFrame_Create: { // wxMDIChildFrame::Create
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=wxDEFAULT_FRAME_STYLE;
 wxMDIChildFrame *This = (wxMDIChildFrame *) getPtr(bp,memenv); bp += 4;
 wxMDIParentFrame *parent = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 int * id = (int *) bp; bp += 4;
 int * titleLen = (int *) bp; bp += 4;
 wxString title = wxString(bp, wxConvUTF8);
 bp += *titleLen+((8-((0+ *titleLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,*id,title,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxMDIChildFrame_Maximize: { // wxMDIChildFrame::Maximize
 bool maximize=true;
 wxMDIChildFrame *This = (wxMDIChildFrame *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 maximize = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Maximize(maximize);
 break;
}
case wxMDIChildFrame_Restore: { // wxMDIChildFrame::Restore
 wxMDIChildFrame *This = (wxMDIChildFrame *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Restore();
 break;
}
case wxMDIClientWindow_new_0: { // wxMDIClientWindow::wxMDIClientWindow
 wxMDIClientWindow * Result = new EwxMDIClientWindow();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMDIClientWindow");
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxMDIClientWindow_new_2: { // wxMDIClientWindow::wxMDIClientWindow
 long style=0;
 wxMDIParentFrame *parent = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxMDIClientWindow * Result = new EwxMDIClientWindow(parent,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxMDIClientWindow");
 break;
}
#endif
case wxMDIClientWindow_CreateClient: { // wxMDIClientWindow::CreateClient
 long style=wxVSCROLL|wxHSCROLL;
 wxMDIClientWindow *This = (wxMDIClientWindow *) getPtr(bp,memenv); bp += 4;
 wxMDIParentFrame *parent = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->CreateClient(parent,style);
 rt.addBool(Result);
 break;
}
case wxLayoutAlgorithm_new: { // wxLayoutAlgorithm::wxLayoutAlgorithm
 wxLayoutAlgorithm * Result = new EwxLayoutAlgorithm();
 newPtr((void *) Result, 1, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxLayoutAlgorithm");
 break;
}
case wxLayoutAlgorithm_LayoutFrame: { // wxLayoutAlgorithm::LayoutFrame
 wxWindow * mainWindow=(wxWindow *) NULL;
 wxLayoutAlgorithm *This = (wxLayoutAlgorithm *) getPtr(bp,memenv); bp += 4;
 wxFrame *frame = (wxFrame *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
mainWindow = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->LayoutFrame(frame,mainWindow);
 rt.addBool(Result);
 break;
}
case wxLayoutAlgorithm_LayoutMDIFrame: { // wxLayoutAlgorithm::LayoutMDIFrame
 wxRect *rect=(wxRect *) NULL; wxRect rectTmp;
 wxLayoutAlgorithm *This = (wxLayoutAlgorithm *) getPtr(bp,memenv); bp += 4;
 wxMDIParentFrame *frame = (wxMDIParentFrame *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * rectX = (int *) bp; bp += 4;
 int * rectY = (int *) bp; bp += 4;
 int * rectW = (int *) bp; bp += 4;
 int * rectH = (int *) bp; bp += 4;
 rectTmp = wxRect(*rectX,*rectY,*rectW,*rectH); rect = & rectTmp;
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->LayoutMDIFrame(frame,rect);
 rt.addBool(Result);
 break;
}
case wxLayoutAlgorithm_LayoutWindow: { // wxLayoutAlgorithm::LayoutWindow
 wxWindow * mainWindow=(wxWindow *) NULL;
 wxLayoutAlgorithm *This = (wxLayoutAlgorithm *) getPtr(bp,memenv); bp += 4;
 wxWindow *frame = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
mainWindow = (wxWindow *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->LayoutWindow(frame,mainWindow);
 rt.addBool(Result);
 break;
}
case wxEvent_GetId: { // wxEvent::GetId
 wxEvent *This = (wxEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetId();
 rt.addInt(Result);
 break;
}
case wxEvent_GetSkipped: { // wxEvent::GetSkipped
 wxEvent *This = (wxEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetSkipped();
 rt.addBool(Result);
 break;
}
case wxEvent_GetTimestamp: { // wxEvent::GetTimestamp
 wxEvent *This = (wxEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetTimestamp();
 rt.addUint(Result);
 break;
}
case wxEvent_IsCommandEvent: { // wxEvent::IsCommandEvent
 wxEvent *This = (wxEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsCommandEvent();
 rt.addBool(Result);
 break;
}
case wxEvent_ResumePropagation: { // wxEvent::ResumePropagation
 wxEvent *This = (wxEvent *) getPtr(bp,memenv); bp += 4;
 int * propagationLevel = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ResumePropagation(*propagationLevel);
 break;
}
case wxEvent_ShouldPropagate: { // wxEvent::ShouldPropagate
 wxEvent *This = (wxEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ShouldPropagate();
 rt.addBool(Result);
 break;
}
case wxEvent_Skip: { // wxEvent::Skip
 bool skip=true;
 wxEvent *This = (wxEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 skip = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Skip(skip);
 break;
}
case wxEvent_StopPropagation: { // wxEvent::StopPropagation
 wxEvent *This = (wxEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->StopPropagation();
 rt.addInt(Result);
 break;
}
case wxCommandEvent_getClientData: { // wxCommandEvent::GetClientObject
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxeErlTerm * Result = (wxeErlTerm*)This->GetClientObject();
 rt.addExt2Term(Result);
 break;
}
case wxCommandEvent_GetExtraLong: { // wxCommandEvent::GetExtraLong
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetExtraLong();
 rt.addInt(Result);
 break;
}
case wxCommandEvent_GetInt: { // wxCommandEvent::GetInt
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetInt();
 rt.addInt(Result);
 break;
}
case wxCommandEvent_GetSelection: { // wxCommandEvent::GetSelection
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelection();
 rt.addInt(Result);
 break;
}
case wxCommandEvent_GetString: { // wxCommandEvent::GetString
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetString();
 rt.add(Result);
 break;
}
case wxCommandEvent_IsChecked: { // wxCommandEvent::IsChecked
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsChecked();
 rt.addBool(Result);
 break;
}
case wxCommandEvent_IsSelection: { // wxCommandEvent::IsSelection
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsSelection();
 rt.addBool(Result);
 break;
}
case wxCommandEvent_SetInt: { // wxCommandEvent::SetInt
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 int * i = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetInt(*i);
 break;
}
case wxCommandEvent_SetString: { // wxCommandEvent::SetString
 wxCommandEvent *This = (wxCommandEvent *) getPtr(bp,memenv); bp += 4;
 int * sLen = (int *) bp; bp += 4;
 wxString s = wxString(bp, wxConvUTF8);
 bp += *sLen+((8-((0+ *sLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetString(s);
 break;
}
case wxScrollEvent_GetOrientation: { // wxScrollEvent::GetOrientation
 wxScrollEvent *This = (wxScrollEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetOrientation();
 rt.addInt(Result);
 break;
}
case wxScrollEvent_GetPosition: { // wxScrollEvent::GetPosition
 wxScrollEvent *This = (wxScrollEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPosition();
 rt.addInt(Result);
 break;
}
case wxScrollWinEvent_GetOrientation: { // wxScrollWinEvent::GetOrientation
 wxScrollWinEvent *This = (wxScrollWinEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetOrientation();
 rt.addInt(Result);
 break;
}
case wxScrollWinEvent_GetPosition: { // wxScrollWinEvent::GetPosition
 wxScrollWinEvent *This = (wxScrollWinEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPosition();
 rt.addInt(Result);
 break;
}
case wxMouseEvent_AltDown: { // wxMouseEvent::AltDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AltDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_Button: { // wxMouseEvent::Button
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 int * but = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Button(*but);
 rt.addBool(Result);
 break;
}
case wxMouseEvent_ButtonDClick: { // wxMouseEvent::ButtonDClick
 int but=wxMOUSE_BTN_ANY;
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 but = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ButtonDClick(but);
 rt.addBool(Result);
 break;
}
case wxMouseEvent_ButtonDown: { // wxMouseEvent::ButtonDown
 int but=wxMOUSE_BTN_ANY;
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 but = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ButtonDown(but);
 rt.addBool(Result);
 break;
}
case wxMouseEvent_ButtonUp: { // wxMouseEvent::ButtonUp
 int but=wxMOUSE_BTN_ANY;
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 but = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ButtonUp(but);
 rt.addBool(Result);
 break;
}
case wxMouseEvent_CmdDown: { // wxMouseEvent::CmdDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CmdDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_ControlDown: { // wxMouseEvent::ControlDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ControlDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_Dragging: { // wxMouseEvent::Dragging
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Dragging();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_Entering: { // wxMouseEvent::Entering
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Entering();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_GetButton: { // wxMouseEvent::GetButton
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetButton();
 rt.addInt(Result);
 break;
}
case wxMouseEvent_GetPosition: { // wxMouseEvent::GetPosition
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxMouseEvent_GetLogicalPosition: { // wxMouseEvent::GetLogicalPosition
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 wxDC *dc = (wxDC *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetLogicalPosition(*dc);
 rt.add(Result);
 break;
}
case wxMouseEvent_GetLinesPerAction: { // wxMouseEvent::GetLinesPerAction
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLinesPerAction();
 rt.addInt(Result);
 break;
}
case wxMouseEvent_GetWheelRotation: { // wxMouseEvent::GetWheelRotation
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWheelRotation();
 rt.addInt(Result);
 break;
}
case wxMouseEvent_GetWheelDelta: { // wxMouseEvent::GetWheelDelta
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWheelDelta();
 rt.addInt(Result);
 break;
}
case wxMouseEvent_GetX: { // wxMouseEvent::GetX
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->GetX();
 rt.addInt(Result);
 break;
}
case wxMouseEvent_GetY: { // wxMouseEvent::GetY
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->GetY();
 rt.addInt(Result);
 break;
}
case wxMouseEvent_IsButton: { // wxMouseEvent::IsButton
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsButton();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_IsPageScroll: { // wxMouseEvent::IsPageScroll
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsPageScroll();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_Leaving: { // wxMouseEvent::Leaving
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Leaving();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_LeftDClick: { // wxMouseEvent::LeftDClick
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->LeftDClick();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_LeftDown: { // wxMouseEvent::LeftDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->LeftDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_LeftIsDown: { // wxMouseEvent::LeftIsDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->LeftIsDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_LeftUp: { // wxMouseEvent::LeftUp
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->LeftUp();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_MetaDown: { // wxMouseEvent::MetaDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MetaDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_MiddleDClick: { // wxMouseEvent::MiddleDClick
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MiddleDClick();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_MiddleDown: { // wxMouseEvent::MiddleDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MiddleDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_MiddleIsDown: { // wxMouseEvent::MiddleIsDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MiddleIsDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_MiddleUp: { // wxMouseEvent::MiddleUp
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MiddleUp();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_Moving: { // wxMouseEvent::Moving
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Moving();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_RightDClick: { // wxMouseEvent::RightDClick
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RightDClick();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_RightDown: { // wxMouseEvent::RightDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RightDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_RightIsDown: { // wxMouseEvent::RightIsDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RightIsDown();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_RightUp: { // wxMouseEvent::RightUp
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->RightUp();
 rt.addBool(Result);
 break;
}
case wxMouseEvent_ShiftDown: { // wxMouseEvent::ShiftDown
 wxMouseEvent *This = (wxMouseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ShiftDown();
 rt.addBool(Result);
 break;
}
case wxSetCursorEvent_GetCursor: { // wxSetCursorEvent::GetCursor
 wxSetCursorEvent *This = (wxSetCursorEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxCursor * Result = &This->GetCursor();
 rt.addRef(getRef((void *)Result,memenv), "wxCursor");
 break;
}
case wxSetCursorEvent_GetX: { // wxSetCursorEvent::GetX
 wxSetCursorEvent *This = (wxSetCursorEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->GetX();
 rt.addInt(Result);
 break;
}
case wxSetCursorEvent_GetY: { // wxSetCursorEvent::GetY
 wxSetCursorEvent *This = (wxSetCursorEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->GetY();
 rt.addInt(Result);
 break;
}
case wxSetCursorEvent_HasCursor: { // wxSetCursorEvent::HasCursor
 wxSetCursorEvent *This = (wxSetCursorEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasCursor();
 rt.addBool(Result);
 break;
}
case wxSetCursorEvent_SetCursor: { // wxSetCursorEvent::SetCursor
 wxSetCursorEvent *This = (wxSetCursorEvent *) getPtr(bp,memenv); bp += 4;
 wxCursor *cursor = (wxCursor *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCursor(*cursor);
 break;
}
case wxKeyEvent_AltDown: { // wxKeyEvent::AltDown
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AltDown();
 rt.addBool(Result);
 break;
}
case wxKeyEvent_CmdDown: { // wxKeyEvent::CmdDown
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CmdDown();
 rt.addBool(Result);
 break;
}
case wxKeyEvent_ControlDown: { // wxKeyEvent::ControlDown
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ControlDown();
 rt.addBool(Result);
 break;
}
case wxKeyEvent_GetKeyCode: { // wxKeyEvent::GetKeyCode
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetKeyCode();
 rt.addInt(Result);
 break;
}
case wxKeyEvent_GetModifiers: { // wxKeyEvent::GetModifiers
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetModifiers();
 rt.addInt(Result);
 break;
}
case wxKeyEvent_GetPosition: { // wxKeyEvent::GetPosition
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxKeyEvent_GetRawKeyCode: { // wxKeyEvent::GetRawKeyCode
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRawKeyCode();
 rt.addUint(Result);
 break;
}
case wxKeyEvent_GetRawKeyFlags: { // wxKeyEvent::GetRawKeyFlags
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRawKeyFlags();
 rt.addUint(Result);
 break;
}
case wxKeyEvent_GetUnicodeKey: { // wxKeyEvent::GetUnicodeKey
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxChar Result = This->GetUnicodeKey();
 rt.addInt(Result);
 break;
}
case wxKeyEvent_GetX: { // wxKeyEvent::GetX
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->GetX();
 rt.addInt(Result);
 break;
}
case wxKeyEvent_GetY: { // wxKeyEvent::GetY
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxCoord Result = This->GetY();
 rt.addInt(Result);
 break;
}
case wxKeyEvent_HasModifiers: { // wxKeyEvent::HasModifiers
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->HasModifiers();
 rt.addBool(Result);
 break;
}
case wxKeyEvent_MetaDown: { // wxKeyEvent::MetaDown
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MetaDown();
 rt.addBool(Result);
 break;
}
case wxKeyEvent_ShiftDown: { // wxKeyEvent::ShiftDown
 wxKeyEvent *This = (wxKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ShiftDown();
 rt.addBool(Result);
 break;
}
case wxSizeEvent_GetSize: { // wxSizeEvent::GetSize
 wxSizeEvent *This = (wxSizeEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxSize Result = This->GetSize();
 rt.add(Result);
 break;
}
case wxMoveEvent_GetPosition: { // wxMoveEvent::GetPosition
 wxMoveEvent *This = (wxMoveEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxEraseEvent_GetDC: { // wxEraseEvent::GetDC
 wxEraseEvent *This = (wxEraseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxDC * Result = (wxDC*)This->GetDC();
 rt.addRef(getRef((void *)Result,memenv), "wxDC");
 break;
}
case wxFocusEvent_GetWindow: { // wxFocusEvent::GetWindow
 wxFocusEvent *This = (wxFocusEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxChildFocusEvent_GetWindow: { // wxChildFocusEvent::GetWindow
 wxChildFocusEvent *This = (wxChildFocusEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxMenuEvent_GetMenu: { // wxMenuEvent::GetMenu
 wxMenuEvent *This = (wxMenuEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMenu * Result = (wxMenu*)This->GetMenu();
 rt.addRef(getRef((void *)Result,memenv), "wxMenu");
 break;
}
case wxMenuEvent_GetMenuId: { // wxMenuEvent::GetMenuId
 wxMenuEvent *This = (wxMenuEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMenuId();
 rt.addInt(Result);
 break;
}
case wxMenuEvent_IsPopup: { // wxMenuEvent::IsPopup
 wxMenuEvent *This = (wxMenuEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsPopup();
 rt.addBool(Result);
 break;
}
case wxCloseEvent_CanVeto: { // wxCloseEvent::CanVeto
 wxCloseEvent *This = (wxCloseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanVeto();
 rt.addBool(Result);
 break;
}
case wxCloseEvent_GetLoggingOff: { // wxCloseEvent::GetLoggingOff
 wxCloseEvent *This = (wxCloseEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetLoggingOff();
 rt.addBool(Result);
 break;
}
case wxCloseEvent_SetCanVeto: { // wxCloseEvent::SetCanVeto
 wxCloseEvent *This = (wxCloseEvent *) getPtr(bp,memenv); bp += 4;
 bool * canVeto = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCanVeto(*canVeto);
 break;
}
case wxCloseEvent_SetLoggingOff: { // wxCloseEvent::SetLoggingOff
 wxCloseEvent *This = (wxCloseEvent *) getPtr(bp,memenv); bp += 4;
 bool * logOff = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetLoggingOff(*logOff);
 break;
}
case wxCloseEvent_Veto: { // wxCloseEvent::Veto
 bool veto=true;
 wxCloseEvent *This = (wxCloseEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 veto = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->Veto(veto);
 break;
}
case wxShowEvent_SetShow: { // wxShowEvent::SetShow
 wxShowEvent *This = (wxShowEvent *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetShow(*show);
 break;
}
case wxShowEvent_GetShow: { // wxShowEvent::GetShow
 wxShowEvent *This = (wxShowEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetShow();
 rt.addBool(Result);
 break;
}
case wxIconizeEvent_Iconized: { // wxIconizeEvent::Iconized
 wxIconizeEvent *This = (wxIconizeEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Iconized();
 rt.addBool(Result);
 break;
}
case wxJoystickEvent_ButtonDown: { // wxJoystickEvent::ButtonDown
 int but=wxJOY_BUTTON_ANY;
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 but = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ButtonDown(but);
 rt.addBool(Result);
 break;
}
case wxJoystickEvent_ButtonIsDown: { // wxJoystickEvent::ButtonIsDown
 int but=wxJOY_BUTTON_ANY;
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 but = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ButtonIsDown(but);
 rt.addBool(Result);
 break;
}
case wxJoystickEvent_ButtonUp: { // wxJoystickEvent::ButtonUp
 int but=wxJOY_BUTTON_ANY;
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 but = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->ButtonUp(but);
 rt.addBool(Result);
 break;
}
case wxJoystickEvent_GetButtonChange: { // wxJoystickEvent::GetButtonChange
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetButtonChange();
 rt.addInt(Result);
 break;
}
case wxJoystickEvent_GetButtonState: { // wxJoystickEvent::GetButtonState
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetButtonState();
 rt.addInt(Result);
 break;
}
case wxJoystickEvent_GetJoystick: { // wxJoystickEvent::GetJoystick
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetJoystick();
 rt.addInt(Result);
 break;
}
case wxJoystickEvent_GetPosition: { // wxJoystickEvent::GetPosition
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxJoystickEvent_GetZPosition: { // wxJoystickEvent::GetZPosition
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetZPosition();
 rt.addInt(Result);
 break;
}
case wxJoystickEvent_IsButton: { // wxJoystickEvent::IsButton
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsButton();
 rt.addBool(Result);
 break;
}
case wxJoystickEvent_IsMove: { // wxJoystickEvent::IsMove
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsMove();
 rt.addBool(Result);
 break;
}
case wxJoystickEvent_IsZMove: { // wxJoystickEvent::IsZMove
 wxJoystickEvent *This = (wxJoystickEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsZMove();
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_CanUpdate: { // wxUpdateUIEvent::CanUpdate
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bool Result = wxUpdateUIEvent::CanUpdate(win);
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_Check: { // wxUpdateUIEvent::Check
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 bool * check = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Check(*check);
 break;
}
case wxUpdateUIEvent_Enable: { // wxUpdateUIEvent::Enable
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 bool * enable = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Enable(*enable);
 break;
}
case wxUpdateUIEvent_Show: { // wxUpdateUIEvent::Show
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Show(*show);
 break;
}
case wxUpdateUIEvent_GetChecked: { // wxUpdateUIEvent::GetChecked
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetChecked();
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_GetEnabled: { // wxUpdateUIEvent::GetEnabled
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetEnabled();
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_GetShown: { // wxUpdateUIEvent::GetShown
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetShown();
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_GetSetChecked: { // wxUpdateUIEvent::GetSetChecked
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetSetChecked();
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_GetSetEnabled: { // wxUpdateUIEvent::GetSetEnabled
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetSetEnabled();
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_GetSetShown: { // wxUpdateUIEvent::GetSetShown
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetSetShown();
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_GetSetText: { // wxUpdateUIEvent::GetSetText
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetSetText();
 rt.addBool(Result);
 break;
}
case wxUpdateUIEvent_GetText: { // wxUpdateUIEvent::GetText
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetText();
 rt.add(Result);
 break;
}
case wxUpdateUIEvent_GetMode: { // wxUpdateUIEvent::GetMode
 int Result = wxUpdateUIEvent::GetMode();
 rt.addInt(Result);
 break;
}
case wxUpdateUIEvent_GetUpdateInterval: { // wxUpdateUIEvent::GetUpdateInterval
 long Result = wxUpdateUIEvent::GetUpdateInterval();
 rt.addInt(Result);
 break;
}
case wxUpdateUIEvent_ResetUpdateTime: { // wxUpdateUIEvent::ResetUpdateTime
 wxUpdateUIEvent::ResetUpdateTime();
 break;
}
case wxUpdateUIEvent_SetMode: { // wxUpdateUIEvent::SetMode
 wxUpdateUIMode mode = *(wxUpdateUIMode *) bp; bp += 4;;
 wxUpdateUIEvent::SetMode(mode);
 break;
}
case wxUpdateUIEvent_SetText: { // wxUpdateUIEvent::SetText
 wxUpdateUIEvent *This = (wxUpdateUIEvent *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetText(text);
 break;
}
case wxUpdateUIEvent_SetUpdateInterval: { // wxUpdateUIEvent::SetUpdateInterval
 int * updateInterval = (int *) bp; bp += 4;
 wxUpdateUIEvent::SetUpdateInterval(*updateInterval);
 break;
}
case wxMouseCaptureChangedEvent_GetCapturedWindow: { // wxMouseCaptureChangedEvent::GetCapturedWindow
 wxMouseCaptureChangedEvent *This = (wxMouseCaptureChangedEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetCapturedWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxPaletteChangedEvent_SetChangedWindow: { // wxPaletteChangedEvent::SetChangedWindow
 wxPaletteChangedEvent *This = (wxPaletteChangedEvent *) getPtr(bp,memenv); bp += 4;
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetChangedWindow(win);
 break;
}
case wxPaletteChangedEvent_GetChangedWindow: { // wxPaletteChangedEvent::GetChangedWindow
 wxPaletteChangedEvent *This = (wxPaletteChangedEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetChangedWindow();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxQueryNewPaletteEvent_SetPaletteRealized: { // wxQueryNewPaletteEvent::SetPaletteRealized
 wxQueryNewPaletteEvent *This = (wxQueryNewPaletteEvent *) getPtr(bp,memenv); bp += 4;
 bool * realized = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPaletteRealized(*realized);
 break;
}
case wxQueryNewPaletteEvent_GetPaletteRealized: { // wxQueryNewPaletteEvent::GetPaletteRealized
 wxQueryNewPaletteEvent *This = (wxQueryNewPaletteEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetPaletteRealized();
 rt.addBool(Result);
 break;
}
case wxNavigationKeyEvent_GetDirection: { // wxNavigationKeyEvent::GetDirection
 wxNavigationKeyEvent *This = (wxNavigationKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetDirection();
 rt.addBool(Result);
 break;
}
case wxNavigationKeyEvent_SetDirection: { // wxNavigationKeyEvent::SetDirection
 wxNavigationKeyEvent *This = (wxNavigationKeyEvent *) getPtr(bp,memenv); bp += 4;
 bool * bForward = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetDirection(*bForward);
 break;
}
case wxNavigationKeyEvent_IsWindowChange: { // wxNavigationKeyEvent::IsWindowChange
 wxNavigationKeyEvent *This = (wxNavigationKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsWindowChange();
 rt.addBool(Result);
 break;
}
case wxNavigationKeyEvent_SetWindowChange: { // wxNavigationKeyEvent::SetWindowChange
 wxNavigationKeyEvent *This = (wxNavigationKeyEvent *) getPtr(bp,memenv); bp += 4;
 bool * bIs = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWindowChange(*bIs);
 break;
}
case wxNavigationKeyEvent_IsFromTab: { // wxNavigationKeyEvent::IsFromTab
 wxNavigationKeyEvent *This = (wxNavigationKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsFromTab();
 rt.addBool(Result);
 break;
}
case wxNavigationKeyEvent_SetFromTab: { // wxNavigationKeyEvent::SetFromTab
 wxNavigationKeyEvent *This = (wxNavigationKeyEvent *) getPtr(bp,memenv); bp += 4;
 bool * bIs = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFromTab(*bIs);
 break;
}
case wxNavigationKeyEvent_GetCurrentFocus: { // wxNavigationKeyEvent::GetCurrentFocus
 wxNavigationKeyEvent *This = (wxNavigationKeyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxWindow * Result = (wxWindow*)This->GetCurrentFocus();
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case wxNavigationKeyEvent_SetCurrentFocus: { // wxNavigationKeyEvent::SetCurrentFocus
 wxNavigationKeyEvent *This = (wxNavigationKeyEvent *) getPtr(bp,memenv); bp += 4;
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCurrentFocus(win);
 break;
}
case wxHelpEvent_GetOrigin: { // wxHelpEvent::GetOrigin
 wxHelpEvent *This = (wxHelpEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetOrigin();
 rt.addInt(Result);
 break;
}
case wxHelpEvent_GetPosition: { // wxHelpEvent::GetPosition
 wxHelpEvent *This = (wxHelpEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxPoint * Result = &This->GetPosition();
 rt.add((*Result));
 break;
}
case wxHelpEvent_SetOrigin: { // wxHelpEvent::SetOrigin
 wxHelpEvent *This = (wxHelpEvent *) getPtr(bp,memenv); bp += 4;
 wxHelpEvent::Origin origin = *(wxHelpEvent::Origin *) bp; bp += 4;;
 if(!This) throw wxe_badarg(0);
 This->SetOrigin(origin);
 break;
}
case wxHelpEvent_SetPosition: { // wxHelpEvent::SetPosition
 wxHelpEvent *This = (wxHelpEvent *) getPtr(bp,memenv); bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 if(!This) throw wxe_badarg(0);
 This->SetPosition(pos);
 break;
}
case wxContextMenuEvent_GetPosition: { // wxContextMenuEvent::GetPosition
 wxContextMenuEvent *This = (wxContextMenuEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxPoint * Result = &This->GetPosition();
 rt.add((*Result));
 break;
}
case wxContextMenuEvent_SetPosition: { // wxContextMenuEvent::SetPosition
 wxContextMenuEvent *This = (wxContextMenuEvent *) getPtr(bp,memenv); bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 wxPoint pos = wxPoint(*posX,*posY);
 if(!This) throw wxe_badarg(0);
 This->SetPosition(pos);
 break;
}
#if !wxCHECK_VERSION(2,9,0)
case wxIdleEvent_CanSend: { // wxIdleEvent::CanSend
 wxWindow *win = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bool Result = wxIdleEvent::CanSend(win);
 rt.addBool(Result);
 break;
}
#endif
case wxIdleEvent_GetMode: { // wxIdleEvent::GetMode
 int Result = wxIdleEvent::GetMode();
 rt.addInt(Result);
 break;
}
case wxIdleEvent_RequestMore: { // wxIdleEvent::RequestMore
 bool needMore=true;
 wxIdleEvent *This = (wxIdleEvent *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 needMore = *(bool *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->RequestMore(needMore);
 break;
}
case wxIdleEvent_MoreRequested: { // wxIdleEvent::MoreRequested
 wxIdleEvent *This = (wxIdleEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MoreRequested();
 rt.addBool(Result);
 break;
}
case wxIdleEvent_SetMode: { // wxIdleEvent::SetMode
 wxIdleMode mode = *(wxIdleMode *) bp; bp += 4;;
 wxIdleEvent::SetMode(mode);
 break;
}
case wxGridEvent_AltDown: { // wxGridEvent::AltDown
 wxGridEvent *This = (wxGridEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AltDown();
 rt.addBool(Result);
 break;
}
case wxGridEvent_ControlDown: { // wxGridEvent::ControlDown
 wxGridEvent *This = (wxGridEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ControlDown();
 rt.addBool(Result);
 break;
}
case wxGridEvent_GetCol: { // wxGridEvent::GetCol
 wxGridEvent *This = (wxGridEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCol();
 rt.addInt(Result);
 break;
}
case wxGridEvent_GetPosition: { // wxGridEvent::GetPosition
 wxGridEvent *This = (wxGridEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPosition();
 rt.add(Result);
 break;
}
case wxGridEvent_GetRow: { // wxGridEvent::GetRow
 wxGridEvent *This = (wxGridEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetRow();
 rt.addInt(Result);
 break;
}
case wxGridEvent_MetaDown: { // wxGridEvent::MetaDown
 wxGridEvent *This = (wxGridEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->MetaDown();
 rt.addBool(Result);
 break;
}
case wxGridEvent_Selecting: { // wxGridEvent::Selecting
 wxGridEvent *This = (wxGridEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->Selecting();
 rt.addBool(Result);
 break;
}
case wxGridEvent_ShiftDown: { // wxGridEvent::ShiftDown
 wxGridEvent *This = (wxGridEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->ShiftDown();
 rt.addBool(Result);
 break;
}
case wxNotifyEvent_Allow: { // wxNotifyEvent::Allow
 wxNotifyEvent *This = (wxNotifyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Allow();
 break;
}
case wxNotifyEvent_IsAllowed: { // wxNotifyEvent::IsAllowed
 wxNotifyEvent *This = (wxNotifyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsAllowed();
 rt.addBool(Result);
 break;
}
case wxNotifyEvent_Veto: { // wxNotifyEvent::Veto
 wxNotifyEvent *This = (wxNotifyEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Veto();
 break;
}
case wxSashEvent_GetEdge: { // wxSashEvent::GetEdge
 wxSashEvent *This = (wxSashEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetEdge();
 rt.addInt(Result);
 break;
}
case wxSashEvent_GetDragRect: { // wxSashEvent::GetDragRect
 wxSashEvent *This = (wxSashEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetDragRect();
 rt.add(Result);
 break;
}
case wxSashEvent_GetDragStatus: { // wxSashEvent::GetDragStatus
 wxSashEvent *This = (wxSashEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDragStatus();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetCacheFrom: { // wxListEvent::GetCacheFrom
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetCacheFrom();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetCacheTo: { // wxListEvent::GetCacheTo
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetCacheTo();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetKeyCode: { // wxListEvent::GetKeyCode
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetKeyCode();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetIndex: { // wxListEvent::GetIndex
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetIndex();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetColumn: { // wxListEvent::GetColumn
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColumn();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetPoint: { // wxListEvent::GetPoint
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxPoint Result = This->GetPoint();
 rt.add(Result);
 break;
}
case wxListEvent_GetLabel: { // wxListEvent::GetLabel
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString * Result = &This->GetLabel();
 rt.add(Result);
 break;
}
case wxListEvent_GetText: { // wxListEvent::GetText
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxString * Result = &This->GetText();
 rt.add(Result);
 break;
}
case wxListEvent_GetImage: { // wxListEvent::GetImage
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetImage();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetData: { // wxListEvent::GetData
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetData();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetMask: { // wxListEvent::GetMask
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 long Result = This->GetMask();
 rt.addInt(Result);
 break;
}
case wxListEvent_GetItem: { // wxListEvent::GetItem
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxListItem * Result = &This->GetItem();
 rt.addRef(getRef((void *)Result,memenv), "wxListItem");
 break;
}
case wxListEvent_IsEditCancelled: { // wxListEvent::IsEditCancelled
 wxListEvent *This = (wxListEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsEditCancelled();
 rt.addBool(Result);
 break;
}
case wxDateEvent_GetDate: { // wxDateEvent::GetDate
 wxDateEvent *This = (wxDateEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 const wxDateTime * Result = &This->GetDate();
 rt.add((*Result));
 break;
}
case wxCalendarEvent_GetWeekDay: { // wxCalendarEvent::GetWeekDay
 wxCalendarEvent *This = (wxCalendarEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWeekDay();
 rt.addInt(Result);
 break;
}
case wxFileDirPickerEvent_GetPath: { // wxFileDirPickerEvent::GetPath
 wxFileDirPickerEvent *This = (wxFileDirPickerEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetPath();
 rt.add(Result);
 break;
}
case wxColourPickerEvent_GetColour: { // wxColourPickerEvent::GetColour
 wxColourPickerEvent *This = (wxColourPickerEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetColour();
 rt.add(Result);
 break;
}
case wxFontPickerEvent_GetFont: { // wxFontPickerEvent::GetFont
 wxFontPickerEvent *This = (wxFontPickerEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxFont * Result = new EwxFont(This->GetFont()); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxFont");
 break;
}
case wxStyledTextEvent_GetPosition: { // wxStyledTextEvent::GetPosition
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPosition();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetKey: { // wxStyledTextEvent::GetKey
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetKey();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetModifiers: { // wxStyledTextEvent::GetModifiers
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetModifiers();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetModificationType: { // wxStyledTextEvent::GetModificationType
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetModificationType();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetText: { // wxStyledTextEvent::GetText
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetText();
 rt.add(Result);
 break;
}
case wxStyledTextEvent_GetLength: { // wxStyledTextEvent::GetLength
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLength();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetLinesAdded: { // wxStyledTextEvent::GetLinesAdded
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLinesAdded();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetLine: { // wxStyledTextEvent::GetLine
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLine();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetFoldLevelNow: { // wxStyledTextEvent::GetFoldLevelNow
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFoldLevelNow();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetFoldLevelPrev: { // wxStyledTextEvent::GetFoldLevelPrev
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFoldLevelPrev();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetMargin: { // wxStyledTextEvent::GetMargin
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMargin();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetMessage: { // wxStyledTextEvent::GetMessage
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMessage();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetWParam: { // wxStyledTextEvent::GetWParam
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWParam();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetLParam: { // wxStyledTextEvent::GetLParam
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLParam();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetListType: { // wxStyledTextEvent::GetListType
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetListType();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetX: { // wxStyledTextEvent::GetX
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetX();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetY: { // wxStyledTextEvent::GetY
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetY();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetDragText: { // wxStyledTextEvent::GetDragText
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetDragText();
 rt.add(Result);
 break;
}
case wxStyledTextEvent_GetDragAllowMove: { // wxStyledTextEvent::GetDragAllowMove
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetDragAllowMove();
 rt.addBool(Result);
 break;
}
case wxStyledTextEvent_GetDragResult: { // wxStyledTextEvent::GetDragResult
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetDragResult();
 rt.addInt(Result);
 break;
}
case wxStyledTextEvent_GetShift: { // wxStyledTextEvent::GetShift
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetShift();
 rt.addBool(Result);
 break;
}
case wxStyledTextEvent_GetControl: { // wxStyledTextEvent::GetControl
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetControl();
 rt.addBool(Result);
 break;
}
case wxStyledTextEvent_GetAlt: { // wxStyledTextEvent::GetAlt
 wxStyledTextEvent *This = (wxStyledTextEvent *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetAlt();
 rt.addBool(Result);
 break;
}
case utils_wxGetKeyState: { // utils::wxGetKeyState
 wxKeyCode key = *(wxKeyCode *) bp; bp += 4;;
 bool Result = ::wxGetKeyState(key);
 rt.addBool(Result);
 break;
}
case utils_wxGetMousePosition: { // utils::wxGetMousePosition
 int x;
 int y;
 ::wxGetMousePosition(&x,&y);
 rt.addInt(x);
 rt.addInt(y);
 rt.addTupleCount(2);
 break;
}
case utils_wxGetMouseState: { // utils::wxGetMouseState
 wxMouseState Result = ::wxGetMouseState();
 rt.add(Result);
 break;
}
case utils_wxSetDetectableAutoRepeat: { // utils::wxSetDetectableAutoRepeat
 bool * flag = (bool *) bp; bp += 4;
 bool Result = ::wxSetDetectableAutoRepeat(*flag);
 rt.addBool(Result);
 break;
}
case utils_wxBell: { // utils::wxBell
 ::wxBell();
 break;
}
case utils_wxFindMenuItemId: { // utils::wxFindMenuItemId
 wxFrame *frame = (wxFrame *) getPtr(bp,memenv); bp += 4;
 int * menuStringLen = (int *) bp; bp += 4;
 wxString menuString = wxString(bp, wxConvUTF8);
 bp += *menuStringLen+((8-((0+ *menuStringLen) & 7)) & 7);
 int * itemStringLen = (int *) bp; bp += 4;
 wxString itemString = wxString(bp, wxConvUTF8);
 bp += *itemStringLen+((8-((4+ *itemStringLen) & 7)) & 7);
 int Result = ::wxFindMenuItemId(frame,menuString,itemString);
 rt.addInt(Result);
 break;
}
case utils_wxGenericFindWindowAtPoint: { // utils::wxGenericFindWindowAtPoint
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 wxWindow * Result = (wxWindow*)::wxGenericFindWindowAtPoint(pt);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case utils_wxFindWindowAtPoint: { // utils::wxFindWindowAtPoint
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 wxWindow * Result = (wxWindow*)::wxFindWindowAtPoint(pt);
 rt.addRef(getRef((void *)Result,memenv), "wxWindow");
 break;
}
case utils_wxBeginBusyCursor: { // utils::wxBeginBusyCursor
 const wxCursor * cursor=wxHOURGLASS_CURSOR;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
cursor = (wxCursor *) getPtr(bp,memenv); bp += 4;
  } break;
 }};
 ::wxBeginBusyCursor(cursor);
 break;
}
case utils_wxEndBusyCursor: { // utils::wxEndBusyCursor
 ::wxEndBusyCursor();
 break;
}
case utils_wxIsBusy: { // utils::wxIsBusy
 bool Result = ::wxIsBusy();
 rt.addBool(Result);
 break;
}
case utils_wxShutdown: { // utils::wxShutdown
 wxShutdownFlags wFlags = *(wxShutdownFlags *) bp; bp += 4;;
 bool Result = ::wxShutdown(wFlags);
 rt.addBool(Result);
 break;
}
case utils_wxShell: { // utils::wxShell
 wxString command= wxEmptyString;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * commandLen = (int *) bp; bp += 4;
 command = wxString(bp, wxConvUTF8);
 bp += *commandLen+((8-((0+ *commandLen) & 7)) & 7);
  } break;
 }};
 bool Result = ::wxShell(command);
 rt.addBool(Result);
 break;
}
case utils_wxLaunchDefaultBrowser: { // utils::wxLaunchDefaultBrowser
 int flags=0;
 int * urlLen = (int *) bp; bp += 4;
 wxString url = wxString(bp, wxConvUTF8);
 bp += *urlLen+((8-((4+ *urlLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
 }};
 bool Result = ::wxLaunchDefaultBrowser(url,flags);
 rt.addBool(Result);
 break;
}
case utils_wxGetEmailAddress: { // utils::wxGetEmailAddress
 wxString Result = ::wxGetEmailAddress();
 rt.add(Result);
 break;
}
case utils_wxGetUserId: { // utils::wxGetUserId
 wxString Result = ::wxGetUserId();
 rt.add(Result);
 break;
}
case utils_wxGetHomeDir: { // utils::wxGetHomeDir
 wxString Result = ::wxGetHomeDir();
 rt.add(Result);
 break;
}
case utils_wxNewId: { // utils::wxNewId
 long Result = ::wxNewId();
 rt.addInt(Result);
 break;
}
case utils_wxRegisterId: { // utils::wxRegisterId
 int * id = (int *) bp; bp += 4;
 ::wxRegisterId(*id);
 break;
}
case utils_wxGetCurrentId: { // utils::wxGetCurrentId
 long Result = ::wxGetCurrentId();
 rt.addInt(Result);
 break;
}
case utils_wxGetOsDescription: { // utils::wxGetOsDescription
 wxString Result = ::wxGetOsDescription();
 rt.add(Result);
 break;
}
case utils_wxIsPlatformLittleEndian: { // utils::wxIsPlatformLittleEndian
 bool Result = ::wxIsPlatformLittleEndian();
 rt.addBool(Result);
 break;
}
case utils_wxIsPlatform64Bit: { // utils::wxIsPlatform64Bit
 bool Result = ::wxIsPlatform64Bit();
 rt.addBool(Result);
 break;
}
case gdicmn_wxDisplaySize: { // gdicmn::wxDisplaySize
 int width;
 int height;
 ::wxDisplaySize(&width,&height);
 rt.addInt(width);
 rt.addInt(height);
 rt.addTupleCount(2);
 break;
}
case gdicmn_wxSetCursor: { // gdicmn::wxSetCursor
 wxCursor *cursor = (wxCursor *) getPtr(bp,memenv); bp += 4;
 ::wxSetCursor(*cursor);
 break;
}

case wxPrintout_new: { // wxPrintout::wxPrintout taylormade
  int onPreparePrinting=0,onBeginPrinting=0,onEndPrinting=0,onBeginDocument=0,
    onEndDocument=0,hasPage=0,getPageInfo=0;
  int * titleLen = (int *) bp; bp += 4;
  wxString title = wxString(bp, wxConvUTF8);
  bp += *titleLen+((8-((4+ *titleLen) & 7)) & 7);
  int onPrintPage=*(int *) bp; bp += 4;
  while( * (int*) bp) { 
    switch (* (int*) bp) { 
    case 1: {bp += 4; onPreparePrinting = *(int *) bp; bp += 4;} break;
    case 2: {bp += 4; onBeginPrinting = *(int *) bp; bp += 4;} break;
    case 3: {bp += 4; onEndPrinting = *(int *) bp; bp += 4;} break;
    case 4: {bp += 4; onBeginDocument = *(int *) bp; bp += 4;} break;
    case 5: {bp += 4; onEndDocument = *(int *) bp; bp += 4;} break;
    case 6: {bp += 4; hasPage = *(int *) bp; bp += 4;} break;
    case 7: {bp += 4; getPageInfo = *(int *) bp; bp += 4;} break;
    }
  }
  wxEPrintout *Result = new wxEPrintout(title,onPrintPage,
					onPreparePrinting,
					onBeginPrinting,onEndPrinting,
					onBeginDocument,onEndDocument,
					hasPage,getPageInfo, Ecmd.port);

  rt.addRef(getRef((void *)Result,memenv), "wxPrintout");
  break;
}
case wxPrintout_GetDC: { // wxPrintout::GetDC
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxDC * Result = (wxDC*)This->GetDC();
 rt.addRef(getRef((void *)Result,memenv), "wxDC");
 break;
}
case wxPrintout_GetPageSizeMM: { // wxPrintout::GetPageSizeMM
 int w;
 int h;
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetPageSizeMM(&w,&h);
 rt.addInt(w);
 rt.addInt(h);
 rt.addTupleCount(2);
 break;
}
case wxPrintout_GetPageSizePixels: { // wxPrintout::GetPageSizePixels
 int w;
 int h;
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetPageSizePixels(&w,&h);
 rt.addInt(w);
 rt.addInt(h);
 rt.addTupleCount(2);
 break;
}
case wxPrintout_GetPaperRectPixels: { // wxPrintout::GetPaperRectPixels
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetPaperRectPixels();
 rt.add(Result);
 break;
}
case wxPrintout_GetPPIPrinter: { // wxPrintout::GetPPIPrinter
 int x;
 int y;
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetPPIPrinter(&x,&y);
 rt.addInt(x);
 rt.addInt(y);
 rt.addTupleCount(2);
 break;
}
case wxPrintout_GetPPIScreen: { // wxPrintout::GetPPIScreen
 int x;
 int y;
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GetPPIScreen(&x,&y);
 rt.addInt(x);
 rt.addInt(y);
 rt.addTupleCount(2);
 break;
}
case wxPrintout_GetTitle: { // wxPrintout::GetTitle
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetTitle();
 rt.add(Result);
 break;
}
case wxPrintout_IsPreview: { // wxPrintout::IsPreview
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->IsPreview();
 rt.addBool(Result);
 break;
}
case wxPrintout_FitThisSizeToPaper: { // wxPrintout::FitThisSizeToPaper
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 int * imageSizeW = (int *) bp; bp += 4;
 int * imageSizeH = (int *) bp; bp += 4;
 wxSize imageSize = wxSize(*imageSizeW,*imageSizeH);
 if(!This) throw wxe_badarg(0);
 This->FitThisSizeToPaper(imageSize);
 break;
}
case wxPrintout_FitThisSizeToPage: { // wxPrintout::FitThisSizeToPage
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 int * imageSizeW = (int *) bp; bp += 4;
 int * imageSizeH = (int *) bp; bp += 4;
 wxSize imageSize = wxSize(*imageSizeW,*imageSizeH);
 if(!This) throw wxe_badarg(0);
 This->FitThisSizeToPage(imageSize);
 break;
}
case wxPrintout_FitThisSizeToPageMargins: { // wxPrintout::FitThisSizeToPageMargins
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 int * imageSizeW = (int *) bp; bp += 4;
 int * imageSizeH = (int *) bp; bp += 4;
 wxSize imageSize = wxSize(*imageSizeW,*imageSizeH);
 wxPageSetupDialogData *pageSetupData = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->FitThisSizeToPageMargins(imageSize,*pageSetupData);
 break;
}
case wxPrintout_MapScreenSizeToPaper: { // wxPrintout::MapScreenSizeToPaper
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MapScreenSizeToPaper();
 break;
}
case wxPrintout_MapScreenSizeToPage: { // wxPrintout::MapScreenSizeToPage
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MapScreenSizeToPage();
 break;
}
case wxPrintout_MapScreenSizeToPageMargins: { // wxPrintout::MapScreenSizeToPageMargins
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 wxPageSetupDialogData *pageSetupData = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MapScreenSizeToPageMargins(*pageSetupData);
 break;
}
case wxPrintout_MapScreenSizeToDevice: { // wxPrintout::MapScreenSizeToDevice
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MapScreenSizeToDevice();
 break;
}
case wxPrintout_GetLogicalPaperRect: { // wxPrintout::GetLogicalPaperRect
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetLogicalPaperRect();
 rt.add(Result);
 break;
}
case wxPrintout_GetLogicalPageRect: { // wxPrintout::GetLogicalPageRect
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetLogicalPageRect();
 rt.add(Result);
 break;
}
case wxPrintout_GetLogicalPageMarginsRect: { // wxPrintout::GetLogicalPageMarginsRect
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 wxPageSetupDialogData *pageSetupData = (wxPageSetupDialogData *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxRect Result = This->GetLogicalPageMarginsRect(*pageSetupData);
 rt.add(Result);
 break;
}
case wxPrintout_SetLogicalOrigin: { // wxPrintout::SetLogicalOrigin
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetLogicalOrigin(*x,*y);
 break;
}
case wxPrintout_OffsetLogicalOrigin: { // wxPrintout::OffsetLogicalOrigin
 wxPrintout *This = (wxPrintout *) getPtr(bp,memenv); bp += 4;
 int * xoff = (int *) bp; bp += 4;
 int * yoff = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->OffsetLogicalOrigin(*xoff,*yoff);
 break;
}
case wxStyledTextCtrl_new_2: { // wxStyledTextCtrl::wxStyledTextCtrl
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 wxStyledTextCtrl * Result = new EwxStyledTextCtrl(parent,id,pos,size,style);
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStyledTextCtrl");
 break;
}
case wxStyledTextCtrl_new_0: { // wxStyledTextCtrl::wxStyledTextCtrl
 wxStyledTextCtrl * Result = new EwxStyledTextCtrl();
 newPtr((void *) Result, 0, memenv);
 rt.addRef(getRef((void *)Result,memenv), "wxStyledTextCtrl");
 break;
}
case wxStyledTextCtrl_Create: { // wxStyledTextCtrl::Create
 wxWindowID id=wxID_ANY;
 wxPoint pos= wxDefaultPosition;
 wxSize size= wxDefaultSize;
 long style=0;
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 wxWindow *parent = (wxWindow *) getPtr(bp,memenv); bp += 4;
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 id = (wxWindowID)*(int *) bp; bp += 4;
  } break;
  case 2: {bp += 4;
 int * posX = (int *) bp; bp += 4;
 int * posY = (int *) bp; bp += 4;
 pos = wxPoint(*posX,*posY);
 bp += 4; /* Align */
  } break;
  case 3: {bp += 4;
 int * sizeW = (int *) bp; bp += 4;
 int * sizeH = (int *) bp; bp += 4;
 size = wxSize(*sizeW,*sizeH);
 bp += 4; /* Align */
  } break;
  case 4: {bp += 4;
 style = (long)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 bool Result = This->Create(parent,id,pos,size,style);
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_AddText: { // wxStyledTextCtrl::AddText
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->AddText(text);
 break;
}
case wxStyledTextCtrl_AddStyledText: { // wxStyledTextCtrl::AddStyledText
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 wxMemoryBuffer *data = (wxMemoryBuffer *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AddStyledText(*data);
 break;
}
case wxStyledTextCtrl_InsertText: { // wxStyledTextCtrl::InsertText
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->InsertText(*pos,text);
 break;
}
case wxStyledTextCtrl_ClearAll: { // wxStyledTextCtrl::ClearAll
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearAll();
 break;
}
case wxStyledTextCtrl_ClearDocumentStyle: { // wxStyledTextCtrl::ClearDocumentStyle
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearDocumentStyle();
 break;
}
case wxStyledTextCtrl_GetLength: { // wxStyledTextCtrl::GetLength
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLength();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetCharAt: { // wxStyledTextCtrl::GetCharAt
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCharAt(*pos);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetCurrentPos: { // wxStyledTextCtrl::GetCurrentPos
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCurrentPos();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetAnchor: { // wxStyledTextCtrl::GetAnchor
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetAnchor();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetStyleAt: { // wxStyledTextCtrl::GetStyleAt
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetStyleAt(*pos);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_Redo: { // wxStyledTextCtrl::Redo
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Redo();
 break;
}
case wxStyledTextCtrl_SetUndoCollection: { // wxStyledTextCtrl::SetUndoCollection
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * collectUndo = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetUndoCollection(*collectUndo);
 break;
}
case wxStyledTextCtrl_SelectAll: { // wxStyledTextCtrl::SelectAll
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SelectAll();
 break;
}
case wxStyledTextCtrl_SetSavePoint: { // wxStyledTextCtrl::SetSavePoint
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSavePoint();
 break;
}
case wxStyledTextCtrl_GetStyledText: { // wxStyledTextCtrl::GetStyledText
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * startPos = (int *) bp; bp += 4;
 int * endPos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxMemoryBuffer * Result = new wxMemoryBuffer(This->GetStyledText(*startPos,*endPos)); newPtr((void *) Result,3, memenv);;
 rt.addRef(getRef((void *)Result,memenv), "wxMemoryBuffer");
 break;
}
case wxStyledTextCtrl_CanRedo: { // wxStyledTextCtrl::CanRedo
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanRedo();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_MarkerLineFromHandle: { // wxStyledTextCtrl::MarkerLineFromHandle
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * handle = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->MarkerLineFromHandle(*handle);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_MarkerDeleteHandle: { // wxStyledTextCtrl::MarkerDeleteHandle
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * handle = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MarkerDeleteHandle(*handle);
 break;
}
case wxStyledTextCtrl_GetUndoCollection: { // wxStyledTextCtrl::GetUndoCollection
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetUndoCollection();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_GetViewWhiteSpace: { // wxStyledTextCtrl::GetViewWhiteSpace
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetViewWhiteSpace();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetViewWhiteSpace: { // wxStyledTextCtrl::SetViewWhiteSpace
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * viewWS = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetViewWhiteSpace(*viewWS);
 break;
}
case wxStyledTextCtrl_PositionFromPoint: { // wxStyledTextCtrl::PositionFromPoint
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * ptX = (int *) bp; bp += 4;
 int * ptY = (int *) bp; bp += 4;
 wxPoint pt = wxPoint(*ptX,*ptY);
 if(!This) throw wxe_badarg(0);
 int Result = This->PositionFromPoint(pt);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_PositionFromPointClose: { // wxStyledTextCtrl::PositionFromPointClose
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * x = (int *) bp; bp += 4;
 int * y = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->PositionFromPointClose(*x,*y);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GotoLine: { // wxStyledTextCtrl::GotoLine
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GotoLine(*line);
 break;
}
case wxStyledTextCtrl_GotoPos: { // wxStyledTextCtrl::GotoPos
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->GotoPos(*pos);
 break;
}
case wxStyledTextCtrl_SetAnchor: { // wxStyledTextCtrl::SetAnchor
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * posAnchor = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetAnchor(*posAnchor);
 break;
}
case wxStyledTextCtrl_GetCurLine: { // wxStyledTextCtrl::GetCurLine
 int linePos;
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetCurLine(&linePos);
 rt.add(Result);
 rt.addInt(linePos);
 rt.addTupleCount(2);
 break;
}
case wxStyledTextCtrl_GetEndStyled: { // wxStyledTextCtrl::GetEndStyled
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetEndStyled();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_ConvertEOLs: { // wxStyledTextCtrl::ConvertEOLs
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * eolMode = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ConvertEOLs(*eolMode);
 break;
}
case wxStyledTextCtrl_GetEOLMode: { // wxStyledTextCtrl::GetEOLMode
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetEOLMode();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetEOLMode: { // wxStyledTextCtrl::SetEOLMode
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * eolMode = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetEOLMode(*eolMode);
 break;
}
case wxStyledTextCtrl_StartStyling: { // wxStyledTextCtrl::StartStyling
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * mask = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StartStyling(*pos,*mask);
 break;
}
case wxStyledTextCtrl_SetStyling: { // wxStyledTextCtrl::SetStyling
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * length = (int *) bp; bp += 4;
 int * style = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStyling(*length,*style);
 break;
}
case wxStyledTextCtrl_GetBufferedDraw: { // wxStyledTextCtrl::GetBufferedDraw
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetBufferedDraw();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetBufferedDraw: { // wxStyledTextCtrl::SetBufferedDraw
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * buffered = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBufferedDraw(*buffered);
 break;
}
case wxStyledTextCtrl_SetTabWidth: { // wxStyledTextCtrl::SetTabWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * tabWidth = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTabWidth(*tabWidth);
 break;
}
case wxStyledTextCtrl_GetTabWidth: { // wxStyledTextCtrl::GetTabWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetTabWidth();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetCodePage: { // wxStyledTextCtrl::SetCodePage
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * codePage = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCodePage(*codePage);
 break;
}
case wxStyledTextCtrl_MarkerDefine: { // wxStyledTextCtrl::MarkerDefine
 wxColour foreground= wxNullColour;
 wxColour background= wxNullColour;
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * markerNumber = (int *) bp; bp += 4;
 int * markerSymbol = (int *) bp; bp += 4;
 bp += 4; /* Align */
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 int * foregroundR = (int *) bp; bp += 4;
 int * foregroundG = (int *) bp; bp += 4;
 int * foregroundB = (int *) bp; bp += 4;
 int * foregroundA = (int *) bp; bp += 4;
 foreground = wxColour(*foregroundR,*foregroundG,*foregroundB,*foregroundA);
 bp += 4; /* Align */
  } break;
  case 2: {bp += 4;
 int * backgroundR = (int *) bp; bp += 4;
 int * backgroundG = (int *) bp; bp += 4;
 int * backgroundB = (int *) bp; bp += 4;
 int * backgroundA = (int *) bp; bp += 4;
 background = wxColour(*backgroundR,*backgroundG,*backgroundB,*backgroundA);
 bp += 4; /* Align */
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 This->MarkerDefine(*markerNumber,*markerSymbol,foreground,background);
 break;
}
case wxStyledTextCtrl_MarkerSetForeground: { // wxStyledTextCtrl::MarkerSetForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * markerNumber = (int *) bp; bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->MarkerSetForeground(*markerNumber,fore);
 break;
}
case wxStyledTextCtrl_MarkerSetBackground: { // wxStyledTextCtrl::MarkerSetBackground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * markerNumber = (int *) bp; bp += 4;
 int * backR = (int *) bp; bp += 4;
 int * backG = (int *) bp; bp += 4;
 int * backB = (int *) bp; bp += 4;
 int * backA = (int *) bp; bp += 4;
 wxColour back = wxColour(*backR,*backG,*backB,*backA);
 if(!This) throw wxe_badarg(0);
 This->MarkerSetBackground(*markerNumber,back);
 break;
}
case wxStyledTextCtrl_MarkerAdd: { // wxStyledTextCtrl::MarkerAdd
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 int * markerNumber = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->MarkerAdd(*line,*markerNumber);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_MarkerDelete: { // wxStyledTextCtrl::MarkerDelete
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 int * markerNumber = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MarkerDelete(*line,*markerNumber);
 break;
}
case wxStyledTextCtrl_MarkerDeleteAll: { // wxStyledTextCtrl::MarkerDeleteAll
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * markerNumber = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MarkerDeleteAll(*markerNumber);
 break;
}
case wxStyledTextCtrl_MarkerGet: { // wxStyledTextCtrl::MarkerGet
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->MarkerGet(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_MarkerNext: { // wxStyledTextCtrl::MarkerNext
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * lineStart = (int *) bp; bp += 4;
 int * markerMask = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->MarkerNext(*lineStart,*markerMask);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_MarkerPrevious: { // wxStyledTextCtrl::MarkerPrevious
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * lineStart = (int *) bp; bp += 4;
 int * markerMask = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->MarkerPrevious(*lineStart,*markerMask);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_MarkerDefineBitmap: { // wxStyledTextCtrl::MarkerDefineBitmap
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * markerNumber = (int *) bp; bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MarkerDefineBitmap(*markerNumber,*bmp);
 break;
}
case wxStyledTextCtrl_MarkerAddSet: { // wxStyledTextCtrl::MarkerAddSet
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 int * set = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MarkerAddSet(*line,*set);
 break;
}
case wxStyledTextCtrl_MarkerSetAlpha: { // wxStyledTextCtrl::MarkerSetAlpha
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * markerNumber = (int *) bp; bp += 4;
 int * alpha = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->MarkerSetAlpha(*markerNumber,*alpha);
 break;
}
case wxStyledTextCtrl_SetMarginType: { // wxStyledTextCtrl::SetMarginType
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * margin = (int *) bp; bp += 4;
 int * marginType = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMarginType(*margin,*marginType);
 break;
}
case wxStyledTextCtrl_GetMarginType: { // wxStyledTextCtrl::GetMarginType
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * margin = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMarginType(*margin);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetMarginWidth: { // wxStyledTextCtrl::SetMarginWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * margin = (int *) bp; bp += 4;
 int * pixelWidth = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMarginWidth(*margin,*pixelWidth);
 break;
}
case wxStyledTextCtrl_GetMarginWidth: { // wxStyledTextCtrl::GetMarginWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * margin = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMarginWidth(*margin);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetMarginMask: { // wxStyledTextCtrl::SetMarginMask
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * margin = (int *) bp; bp += 4;
 int * mask = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMarginMask(*margin,*mask);
 break;
}
case wxStyledTextCtrl_GetMarginMask: { // wxStyledTextCtrl::GetMarginMask
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * margin = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMarginMask(*margin);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetMarginSensitive: { // wxStyledTextCtrl::SetMarginSensitive
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * margin = (int *) bp; bp += 4;
 bool * sensitive = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMarginSensitive(*margin,*sensitive);
 break;
}
case wxStyledTextCtrl_GetMarginSensitive: { // wxStyledTextCtrl::GetMarginSensitive
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * margin = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetMarginSensitive(*margin);
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_StyleClearAll: { // wxStyledTextCtrl::StyleClearAll
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleClearAll();
 break;
}
case wxStyledTextCtrl_StyleSetForeground: { // wxStyledTextCtrl::StyleSetForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->StyleSetForeground(*style,fore);
 break;
}
case wxStyledTextCtrl_StyleSetBackground: { // wxStyledTextCtrl::StyleSetBackground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 int * backR = (int *) bp; bp += 4;
 int * backG = (int *) bp; bp += 4;
 int * backB = (int *) bp; bp += 4;
 int * backA = (int *) bp; bp += 4;
 wxColour back = wxColour(*backR,*backG,*backB,*backA);
 if(!This) throw wxe_badarg(0);
 This->StyleSetBackground(*style,back);
 break;
}
case wxStyledTextCtrl_StyleSetBold: { // wxStyledTextCtrl::StyleSetBold
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 bool * bold = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleSetBold(*style,*bold);
 break;
}
case wxStyledTextCtrl_StyleSetItalic: { // wxStyledTextCtrl::StyleSetItalic
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 bool * italic = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleSetItalic(*style,*italic);
 break;
}
case wxStyledTextCtrl_StyleSetSize: { // wxStyledTextCtrl::StyleSetSize
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 int * sizePoints = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleSetSize(*style,*sizePoints);
 break;
}
case wxStyledTextCtrl_StyleSetFaceName: { // wxStyledTextCtrl::StyleSetFaceName
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 int * fontNameLen = (int *) bp; bp += 4;
 wxString fontName = wxString(bp, wxConvUTF8);
 bp += *fontNameLen+((8-((4+ *fontNameLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->StyleSetFaceName(*style,fontName);
 break;
}
case wxStyledTextCtrl_StyleSetEOLFilled: { // wxStyledTextCtrl::StyleSetEOLFilled
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 bool * filled = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleSetEOLFilled(*style,*filled);
 break;
}
case wxStyledTextCtrl_StyleResetDefault: { // wxStyledTextCtrl::StyleResetDefault
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleResetDefault();
 break;
}
case wxStyledTextCtrl_StyleSetUnderline: { // wxStyledTextCtrl::StyleSetUnderline
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 bool * underline = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleSetUnderline(*style,*underline);
 break;
}
case wxStyledTextCtrl_StyleSetCase: { // wxStyledTextCtrl::StyleSetCase
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 int * caseForce = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleSetCase(*style,*caseForce);
 break;
}
case wxStyledTextCtrl_StyleSetHotSpot: { // wxStyledTextCtrl::StyleSetHotSpot
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 bool * hotspot = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleSetHotSpot(*style,*hotspot);
 break;
}
case wxStyledTextCtrl_SetSelForeground: { // wxStyledTextCtrl::SetSelForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * useSetting = (bool *) bp; bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->SetSelForeground(*useSetting,fore);
 break;
}
case wxStyledTextCtrl_SetSelBackground: { // wxStyledTextCtrl::SetSelBackground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * useSetting = (bool *) bp; bp += 4;
 int * backR = (int *) bp; bp += 4;
 int * backG = (int *) bp; bp += 4;
 int * backB = (int *) bp; bp += 4;
 int * backA = (int *) bp; bp += 4;
 wxColour back = wxColour(*backR,*backG,*backB,*backA);
 if(!This) throw wxe_badarg(0);
 This->SetSelBackground(*useSetting,back);
 break;
}
case wxStyledTextCtrl_GetSelAlpha: { // wxStyledTextCtrl::GetSelAlpha
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelAlpha();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetSelAlpha: { // wxStyledTextCtrl::SetSelAlpha
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * alpha = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelAlpha(*alpha);
 break;
}
case wxStyledTextCtrl_SetCaretForeground: { // wxStyledTextCtrl::SetCaretForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->SetCaretForeground(fore);
 break;
}
case wxStyledTextCtrl_CmdKeyAssign: { // wxStyledTextCtrl::CmdKeyAssign
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * key = (int *) bp; bp += 4;
 int * modifiers = (int *) bp; bp += 4;
 int * cmd = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CmdKeyAssign(*key,*modifiers,*cmd);
 break;
}
case wxStyledTextCtrl_CmdKeyClear: { // wxStyledTextCtrl::CmdKeyClear
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * key = (int *) bp; bp += 4;
 int * modifiers = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CmdKeyClear(*key,*modifiers);
 break;
}
case wxStyledTextCtrl_CmdKeyClearAll: { // wxStyledTextCtrl::CmdKeyClearAll
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CmdKeyClearAll();
 break;
}
case wxStyledTextCtrl_SetStyleBytes: { // wxStyledTextCtrl::SetStyleBytes
 char styleBytes;
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * length = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetStyleBytes(*length,&styleBytes);
 rt.addInt(styleBytes);
 break;
}
case wxStyledTextCtrl_StyleSetVisible: { // wxStyledTextCtrl::StyleSetVisible
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 bool * visible = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->StyleSetVisible(*style,*visible);
 break;
}
case wxStyledTextCtrl_GetCaretPeriod: { // wxStyledTextCtrl::GetCaretPeriod
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCaretPeriod();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetCaretPeriod: { // wxStyledTextCtrl::SetCaretPeriod
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * periodMilliseconds = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCaretPeriod(*periodMilliseconds);
 break;
}
case wxStyledTextCtrl_SetWordChars: { // wxStyledTextCtrl::SetWordChars
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * charactersLen = (int *) bp; bp += 4;
 wxString characters = wxString(bp, wxConvUTF8);
 bp += *charactersLen+((8-((0+ *charactersLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetWordChars(characters);
 break;
}
case wxStyledTextCtrl_BeginUndoAction: { // wxStyledTextCtrl::BeginUndoAction
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->BeginUndoAction();
 break;
}
case wxStyledTextCtrl_EndUndoAction: { // wxStyledTextCtrl::EndUndoAction
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EndUndoAction();
 break;
}
case wxStyledTextCtrl_IndicatorSetStyle: { // wxStyledTextCtrl::IndicatorSetStyle
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * indic = (int *) bp; bp += 4;
 int * style = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->IndicatorSetStyle(*indic,*style);
 break;
}
case wxStyledTextCtrl_IndicatorGetStyle: { // wxStyledTextCtrl::IndicatorGetStyle
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * indic = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->IndicatorGetStyle(*indic);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_IndicatorSetForeground: { // wxStyledTextCtrl::IndicatorSetForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * indic = (int *) bp; bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->IndicatorSetForeground(*indic,fore);
 break;
}
case wxStyledTextCtrl_IndicatorGetForeground: { // wxStyledTextCtrl::IndicatorGetForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * indic = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->IndicatorGetForeground(*indic);
 rt.add(Result);
 break;
}
case wxStyledTextCtrl_SetWhitespaceForeground: { // wxStyledTextCtrl::SetWhitespaceForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * useSetting = (bool *) bp; bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->SetWhitespaceForeground(*useSetting,fore);
 break;
}
case wxStyledTextCtrl_SetWhitespaceBackground: { // wxStyledTextCtrl::SetWhitespaceBackground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * useSetting = (bool *) bp; bp += 4;
 int * backR = (int *) bp; bp += 4;
 int * backG = (int *) bp; bp += 4;
 int * backB = (int *) bp; bp += 4;
 int * backA = (int *) bp; bp += 4;
 wxColour back = wxColour(*backR,*backG,*backB,*backA);
 if(!This) throw wxe_badarg(0);
 This->SetWhitespaceBackground(*useSetting,back);
 break;
}
case wxStyledTextCtrl_GetStyleBits: { // wxStyledTextCtrl::GetStyleBits
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetStyleBits();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetLineState: { // wxStyledTextCtrl::SetLineState
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 int * state = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetLineState(*line,*state);
 break;
}
case wxStyledTextCtrl_GetLineState: { // wxStyledTextCtrl::GetLineState
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLineState(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetMaxLineState: { // wxStyledTextCtrl::GetMaxLineState
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMaxLineState();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetCaretLineVisible: { // wxStyledTextCtrl::GetCaretLineVisible
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetCaretLineVisible();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetCaretLineVisible: { // wxStyledTextCtrl::SetCaretLineVisible
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCaretLineVisible(*show);
 break;
}
case wxStyledTextCtrl_GetCaretLineBackground: { // wxStyledTextCtrl::GetCaretLineBackground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetCaretLineBackground();
 rt.add(Result);
 break;
}
case wxStyledTextCtrl_SetCaretLineBackground: { // wxStyledTextCtrl::SetCaretLineBackground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * backR = (int *) bp; bp += 4;
 int * backG = (int *) bp; bp += 4;
 int * backB = (int *) bp; bp += 4;
 int * backA = (int *) bp; bp += 4;
 wxColour back = wxColour(*backR,*backG,*backB,*backA);
 if(!This) throw wxe_badarg(0);
 This->SetCaretLineBackground(back);
 break;
}
case wxStyledTextCtrl_AutoCompShow: { // wxStyledTextCtrl::AutoCompShow
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * lenEntered = (int *) bp; bp += 4;
 int * itemListLen = (int *) bp; bp += 4;
 wxString itemList = wxString(bp, wxConvUTF8);
 bp += *itemListLen+((8-((4+ *itemListLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->AutoCompShow(*lenEntered,itemList);
 break;
}
case wxStyledTextCtrl_AutoCompCancel: { // wxStyledTextCtrl::AutoCompCancel
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompCancel();
 break;
}
case wxStyledTextCtrl_AutoCompActive: { // wxStyledTextCtrl::AutoCompActive
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AutoCompActive();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_AutoCompPosStart: { // wxStyledTextCtrl::AutoCompPosStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->AutoCompPosStart();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_AutoCompComplete: { // wxStyledTextCtrl::AutoCompComplete
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompComplete();
 break;
}
case wxStyledTextCtrl_AutoCompStops: { // wxStyledTextCtrl::AutoCompStops
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * characterSetLen = (int *) bp; bp += 4;
 wxString characterSet = wxString(bp, wxConvUTF8);
 bp += *characterSetLen+((8-((0+ *characterSetLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->AutoCompStops(characterSet);
 break;
}
case wxStyledTextCtrl_AutoCompSetSeparator: { // wxStyledTextCtrl::AutoCompSetSeparator
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * separatorCharacter = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetSeparator(*separatorCharacter);
 break;
}
case wxStyledTextCtrl_AutoCompGetSeparator: { // wxStyledTextCtrl::AutoCompGetSeparator
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->AutoCompGetSeparator();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_AutoCompSelect: { // wxStyledTextCtrl::AutoCompSelect
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->AutoCompSelect(text);
 break;
}
case wxStyledTextCtrl_AutoCompSetCancelAtStart: { // wxStyledTextCtrl::AutoCompSetCancelAtStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * cancel = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetCancelAtStart(*cancel);
 break;
}
case wxStyledTextCtrl_AutoCompGetCancelAtStart: { // wxStyledTextCtrl::AutoCompGetCancelAtStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AutoCompGetCancelAtStart();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_AutoCompSetFillUps: { // wxStyledTextCtrl::AutoCompSetFillUps
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * characterSetLen = (int *) bp; bp += 4;
 wxString characterSet = wxString(bp, wxConvUTF8);
 bp += *characterSetLen+((8-((0+ *characterSetLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetFillUps(characterSet);
 break;
}
case wxStyledTextCtrl_AutoCompSetChooseSingle: { // wxStyledTextCtrl::AutoCompSetChooseSingle
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * chooseSingle = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetChooseSingle(*chooseSingle);
 break;
}
case wxStyledTextCtrl_AutoCompGetChooseSingle: { // wxStyledTextCtrl::AutoCompGetChooseSingle
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AutoCompGetChooseSingle();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_AutoCompSetIgnoreCase: { // wxStyledTextCtrl::AutoCompSetIgnoreCase
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * ignoreCase = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetIgnoreCase(*ignoreCase);
 break;
}
case wxStyledTextCtrl_AutoCompGetIgnoreCase: { // wxStyledTextCtrl::AutoCompGetIgnoreCase
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AutoCompGetIgnoreCase();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_UserListShow: { // wxStyledTextCtrl::UserListShow
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * listType = (int *) bp; bp += 4;
 int * itemListLen = (int *) bp; bp += 4;
 wxString itemList = wxString(bp, wxConvUTF8);
 bp += *itemListLen+((8-((4+ *itemListLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->UserListShow(*listType,itemList);
 break;
}
case wxStyledTextCtrl_AutoCompSetAutoHide: { // wxStyledTextCtrl::AutoCompSetAutoHide
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * autoHide = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetAutoHide(*autoHide);
 break;
}
case wxStyledTextCtrl_AutoCompGetAutoHide: { // wxStyledTextCtrl::AutoCompGetAutoHide
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AutoCompGetAutoHide();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_AutoCompSetDropRestOfWord: { // wxStyledTextCtrl::AutoCompSetDropRestOfWord
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * dropRestOfWord = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetDropRestOfWord(*dropRestOfWord);
 break;
}
case wxStyledTextCtrl_AutoCompGetDropRestOfWord: { // wxStyledTextCtrl::AutoCompGetDropRestOfWord
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->AutoCompGetDropRestOfWord();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_RegisterImage: { // wxStyledTextCtrl::RegisterImage
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * type = (int *) bp; bp += 4;
 wxBitmap *bmp = (wxBitmap *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->RegisterImage(*type,*bmp);
 break;
}
case wxStyledTextCtrl_ClearRegisteredImages: { // wxStyledTextCtrl::ClearRegisteredImages
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ClearRegisteredImages();
 break;
}
case wxStyledTextCtrl_AutoCompGetTypeSeparator: { // wxStyledTextCtrl::AutoCompGetTypeSeparator
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->AutoCompGetTypeSeparator();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_AutoCompSetTypeSeparator: { // wxStyledTextCtrl::AutoCompSetTypeSeparator
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * separatorCharacter = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetTypeSeparator(*separatorCharacter);
 break;
}
case wxStyledTextCtrl_AutoCompSetMaxWidth: { // wxStyledTextCtrl::AutoCompSetMaxWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * characterCount = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetMaxWidth(*characterCount);
 break;
}
case wxStyledTextCtrl_AutoCompGetMaxWidth: { // wxStyledTextCtrl::AutoCompGetMaxWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->AutoCompGetMaxWidth();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_AutoCompSetMaxHeight: { // wxStyledTextCtrl::AutoCompSetMaxHeight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * rowCount = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->AutoCompSetMaxHeight(*rowCount);
 break;
}
case wxStyledTextCtrl_AutoCompGetMaxHeight: { // wxStyledTextCtrl::AutoCompGetMaxHeight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->AutoCompGetMaxHeight();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetIndent: { // wxStyledTextCtrl::SetIndent
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * indentSize = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetIndent(*indentSize);
 break;
}
case wxStyledTextCtrl_GetIndent: { // wxStyledTextCtrl::GetIndent
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetIndent();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetUseTabs: { // wxStyledTextCtrl::SetUseTabs
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * useTabs = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetUseTabs(*useTabs);
 break;
}
case wxStyledTextCtrl_GetUseTabs: { // wxStyledTextCtrl::GetUseTabs
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetUseTabs();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetLineIndentation: { // wxStyledTextCtrl::SetLineIndentation
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 int * indentSize = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetLineIndentation(*line,*indentSize);
 break;
}
case wxStyledTextCtrl_GetLineIndentation: { // wxStyledTextCtrl::GetLineIndentation
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLineIndentation(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetLineIndentPosition: { // wxStyledTextCtrl::GetLineIndentPosition
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLineIndentPosition(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetColumn: { // wxStyledTextCtrl::GetColumn
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetColumn(*pos);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetUseHorizontalScrollBar: { // wxStyledTextCtrl::SetUseHorizontalScrollBar
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetUseHorizontalScrollBar(*show);
 break;
}
case wxStyledTextCtrl_GetUseHorizontalScrollBar: { // wxStyledTextCtrl::GetUseHorizontalScrollBar
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetUseHorizontalScrollBar();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetIndentationGuides: { // wxStyledTextCtrl::SetIndentationGuides
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetIndentationGuides(*show);
 break;
}
case wxStyledTextCtrl_GetIndentationGuides: { // wxStyledTextCtrl::GetIndentationGuides
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetIndentationGuides();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetHighlightGuide: { // wxStyledTextCtrl::SetHighlightGuide
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * column = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetHighlightGuide(*column);
 break;
}
case wxStyledTextCtrl_GetHighlightGuide: { // wxStyledTextCtrl::GetHighlightGuide
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetHighlightGuide();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetLineEndPosition: { // wxStyledTextCtrl::GetLineEndPosition
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLineEndPosition(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetCodePage: { // wxStyledTextCtrl::GetCodePage
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCodePage();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetCaretForeground: { // wxStyledTextCtrl::GetCaretForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxColour Result = This->GetCaretForeground();
 rt.add(Result);
 break;
}
case wxStyledTextCtrl_GetReadOnly: { // wxStyledTextCtrl::GetReadOnly
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetReadOnly();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetCurrentPos: { // wxStyledTextCtrl::SetCurrentPos
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCurrentPos(*pos);
 break;
}
case wxStyledTextCtrl_SetSelectionStart: { // wxStyledTextCtrl::SetSelectionStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelectionStart(*pos);
 break;
}
case wxStyledTextCtrl_GetSelectionStart: { // wxStyledTextCtrl::GetSelectionStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelectionStart();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetSelectionEnd: { // wxStyledTextCtrl::SetSelectionEnd
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelectionEnd(*pos);
 break;
}
case wxStyledTextCtrl_GetSelectionEnd: { // wxStyledTextCtrl::GetSelectionEnd
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSelectionEnd();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetPrintMagnification: { // wxStyledTextCtrl::SetPrintMagnification
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * magnification = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPrintMagnification(*magnification);
 break;
}
case wxStyledTextCtrl_GetPrintMagnification: { // wxStyledTextCtrl::GetPrintMagnification
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPrintMagnification();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetPrintColourMode: { // wxStyledTextCtrl::SetPrintColourMode
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * mode = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetPrintColourMode(*mode);
 break;
}
case wxStyledTextCtrl_GetPrintColourMode: { // wxStyledTextCtrl::GetPrintColourMode
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetPrintColourMode();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_FindText: { // wxStyledTextCtrl::FindText
 int flags=0;
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * minPos = (int *) bp; bp += 4;
 int * maxPos = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 while( * (int*) bp) { switch (* (int*) bp) {
  case 1: {bp += 4;
 flags = (int)*(int *) bp; bp += 4;
  } break;
 }};
 if(!This) throw wxe_badarg(0);
 int Result = This->FindText(*minPos,*maxPos,text,flags);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_FormatRange: { // wxStyledTextCtrl::FormatRange
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * doDraw = (bool *) bp; bp += 4;
 int * startPos = (int *) bp; bp += 4;
 int * endPos = (int *) bp; bp += 4;
 wxDC *draw = (wxDC *) getPtr(bp,memenv); bp += 4;
 wxDC *target = (wxDC *) getPtr(bp,memenv); bp += 4;
 int * renderRectX = (int *) bp; bp += 4;
 int * renderRectY = (int *) bp; bp += 4;
 int * renderRectW = (int *) bp; bp += 4;
 int * renderRectH = (int *) bp; bp += 4;
 wxRect renderRect = wxRect(*renderRectX,*renderRectY,*renderRectW,*renderRectH);
 int * pageRectX = (int *) bp; bp += 4;
 int * pageRectY = (int *) bp; bp += 4;
 int * pageRectW = (int *) bp; bp += 4;
 int * pageRectH = (int *) bp; bp += 4;
 wxRect pageRect = wxRect(*pageRectX,*pageRectY,*pageRectW,*pageRectH);
 if(!This) throw wxe_badarg(0);
 int Result = This->FormatRange(*doDraw,*startPos,*endPos,draw,target,renderRect,pageRect);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetFirstVisibleLine: { // wxStyledTextCtrl::GetFirstVisibleLine
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFirstVisibleLine();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetLine: { // wxStyledTextCtrl::GetLine
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetLine(*line);
 rt.add(Result);
 break;
}
case wxStyledTextCtrl_GetLineCount: { // wxStyledTextCtrl::GetLineCount
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLineCount();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetMarginLeft: { // wxStyledTextCtrl::SetMarginLeft
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pixelWidth = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMarginLeft(*pixelWidth);
 break;
}
case wxStyledTextCtrl_GetMarginLeft: { // wxStyledTextCtrl::GetMarginLeft
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMarginLeft();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetMarginRight: { // wxStyledTextCtrl::SetMarginRight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pixelWidth = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMarginRight(*pixelWidth);
 break;
}
case wxStyledTextCtrl_GetMarginRight: { // wxStyledTextCtrl::GetMarginRight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMarginRight();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetModify: { // wxStyledTextCtrl::GetModify
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetModify();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetSelection: { // wxStyledTextCtrl::SetSelection
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * start = (int *) bp; bp += 4;
 int * end = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSelection(*start,*end);
 break;
}
case wxStyledTextCtrl_GetSelectedText: { // wxStyledTextCtrl::GetSelectedText
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetSelectedText();
 rt.add(Result);
 break;
}
case wxStyledTextCtrl_GetTextRange: { // wxStyledTextCtrl::GetTextRange
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * startPos = (int *) bp; bp += 4;
 int * endPos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetTextRange(*startPos,*endPos);
 rt.add(Result);
 break;
}
case wxStyledTextCtrl_HideSelection: { // wxStyledTextCtrl::HideSelection
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * normal = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->HideSelection(*normal);
 break;
}
case wxStyledTextCtrl_LineFromPosition: { // wxStyledTextCtrl::LineFromPosition
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->LineFromPosition(*pos);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_PositionFromLine: { // wxStyledTextCtrl::PositionFromLine
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->PositionFromLine(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_LineScroll: { // wxStyledTextCtrl::LineScroll
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * columns = (int *) bp; bp += 4;
 int * lines = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LineScroll(*columns,*lines);
 break;
}
case wxStyledTextCtrl_EnsureCaretVisible: { // wxStyledTextCtrl::EnsureCaretVisible
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnsureCaretVisible();
 break;
}
case wxStyledTextCtrl_ReplaceSelection: { // wxStyledTextCtrl::ReplaceSelection
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->ReplaceSelection(text);
 break;
}
case wxStyledTextCtrl_SetReadOnly: { // wxStyledTextCtrl::SetReadOnly
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * readOnly = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetReadOnly(*readOnly);
 break;
}
case wxStyledTextCtrl_CanPaste: { // wxStyledTextCtrl::CanPaste
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanPaste();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_CanUndo: { // wxStyledTextCtrl::CanUndo
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CanUndo();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_EmptyUndoBuffer: { // wxStyledTextCtrl::EmptyUndoBuffer
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EmptyUndoBuffer();
 break;
}
case wxStyledTextCtrl_Undo: { // wxStyledTextCtrl::Undo
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Undo();
 break;
}
case wxStyledTextCtrl_Cut: { // wxStyledTextCtrl::Cut
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Cut();
 break;
}
case wxStyledTextCtrl_Copy: { // wxStyledTextCtrl::Copy
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Copy();
 break;
}
case wxStyledTextCtrl_Paste: { // wxStyledTextCtrl::Paste
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Paste();
 break;
}
case wxStyledTextCtrl_Clear: { // wxStyledTextCtrl::Clear
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Clear();
 break;
}
case wxStyledTextCtrl_SetText: { // wxStyledTextCtrl::SetText
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->SetText(text);
 break;
}
case wxStyledTextCtrl_GetText: { // wxStyledTextCtrl::GetText
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 wxString Result = This->GetText();
 rt.add(Result);
 break;
}
case wxStyledTextCtrl_GetTextLength: { // wxStyledTextCtrl::GetTextLength
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetTextLength();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetOvertype: { // wxStyledTextCtrl::GetOvertype
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetOvertype();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetCaretWidth: { // wxStyledTextCtrl::SetCaretWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pixelWidth = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetCaretWidth(*pixelWidth);
 break;
}
case wxStyledTextCtrl_GetCaretWidth: { // wxStyledTextCtrl::GetCaretWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetCaretWidth();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetTargetStart: { // wxStyledTextCtrl::SetTargetStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTargetStart(*pos);
 break;
}
case wxStyledTextCtrl_GetTargetStart: { // wxStyledTextCtrl::GetTargetStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetTargetStart();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetTargetEnd: { // wxStyledTextCtrl::SetTargetEnd
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTargetEnd(*pos);
 break;
}
case wxStyledTextCtrl_GetTargetEnd: { // wxStyledTextCtrl::GetTargetEnd
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetTargetEnd();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_ReplaceTarget: { // wxStyledTextCtrl::ReplaceTarget
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 int Result = This->ReplaceTarget(text);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SearchInTarget: { // wxStyledTextCtrl::SearchInTarget
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 int Result = This->SearchInTarget(text);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetSearchFlags: { // wxStyledTextCtrl::SetSearchFlags
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * flags = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetSearchFlags(*flags);
 break;
}
case wxStyledTextCtrl_GetSearchFlags: { // wxStyledTextCtrl::GetSearchFlags
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetSearchFlags();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_CallTipShow: { // wxStyledTextCtrl::CallTipShow
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 int * definitionLen = (int *) bp; bp += 4;
 wxString definition = wxString(bp, wxConvUTF8);
 bp += *definitionLen+((8-((4+ *definitionLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->CallTipShow(*pos,definition);
 break;
}
case wxStyledTextCtrl_CallTipCancel: { // wxStyledTextCtrl::CallTipCancel
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CallTipCancel();
 break;
}
case wxStyledTextCtrl_CallTipActive: { // wxStyledTextCtrl::CallTipActive
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->CallTipActive();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_CallTipPosAtStart: { // wxStyledTextCtrl::CallTipPosAtStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->CallTipPosAtStart();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_CallTipSetHighlight: { // wxStyledTextCtrl::CallTipSetHighlight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * start = (int *) bp; bp += 4;
 int * end = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CallTipSetHighlight(*start,*end);
 break;
}
case wxStyledTextCtrl_CallTipSetBackground: { // wxStyledTextCtrl::CallTipSetBackground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * backR = (int *) bp; bp += 4;
 int * backG = (int *) bp; bp += 4;
 int * backB = (int *) bp; bp += 4;
 int * backA = (int *) bp; bp += 4;
 wxColour back = wxColour(*backR,*backG,*backB,*backA);
 if(!This) throw wxe_badarg(0);
 This->CallTipSetBackground(back);
 break;
}
case wxStyledTextCtrl_CallTipSetForeground: { // wxStyledTextCtrl::CallTipSetForeground
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->CallTipSetForeground(fore);
 break;
}
case wxStyledTextCtrl_CallTipSetForegroundHighlight: { // wxStyledTextCtrl::CallTipSetForegroundHighlight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->CallTipSetForegroundHighlight(fore);
 break;
}
case wxStyledTextCtrl_CallTipUseStyle: { // wxStyledTextCtrl::CallTipUseStyle
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * tabSize = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CallTipUseStyle(*tabSize);
 break;
}
case wxStyledTextCtrl_VisibleFromDocLine: { // wxStyledTextCtrl::VisibleFromDocLine
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->VisibleFromDocLine(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_DocLineFromVisible: { // wxStyledTextCtrl::DocLineFromVisible
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * lineDisplay = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->DocLineFromVisible(*lineDisplay);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_WrapCount: { // wxStyledTextCtrl::WrapCount
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->WrapCount(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetFoldLevel: { // wxStyledTextCtrl::SetFoldLevel
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 int * level = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFoldLevel(*line,*level);
 break;
}
case wxStyledTextCtrl_GetFoldLevel: { // wxStyledTextCtrl::GetFoldLevel
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFoldLevel(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetLastChild: { // wxStyledTextCtrl::GetLastChild
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 int * level = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLastChild(*line,*level);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetFoldParent: { // wxStyledTextCtrl::GetFoldParent
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetFoldParent(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_ShowLines: { // wxStyledTextCtrl::ShowLines
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * lineStart = (int *) bp; bp += 4;
 int * lineEnd = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ShowLines(*lineStart,*lineEnd);
 break;
}
case wxStyledTextCtrl_HideLines: { // wxStyledTextCtrl::HideLines
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * lineStart = (int *) bp; bp += 4;
 int * lineEnd = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->HideLines(*lineStart,*lineEnd);
 break;
}
case wxStyledTextCtrl_GetLineVisible: { // wxStyledTextCtrl::GetLineVisible
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetLineVisible(*line);
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetFoldExpanded: { // wxStyledTextCtrl::SetFoldExpanded
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 bool * expanded = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFoldExpanded(*line,*expanded);
 break;
}
case wxStyledTextCtrl_GetFoldExpanded: { // wxStyledTextCtrl::GetFoldExpanded
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetFoldExpanded(*line);
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_ToggleFold: { // wxStyledTextCtrl::ToggleFold
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->ToggleFold(*line);
 break;
}
case wxStyledTextCtrl_EnsureVisible: { // wxStyledTextCtrl::EnsureVisible
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnsureVisible(*line);
 break;
}
case wxStyledTextCtrl_SetFoldFlags: { // wxStyledTextCtrl::SetFoldFlags
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * flags = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetFoldFlags(*flags);
 break;
}
case wxStyledTextCtrl_EnsureVisibleEnforcePolicy: { // wxStyledTextCtrl::EnsureVisibleEnforcePolicy
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->EnsureVisibleEnforcePolicy(*line);
 break;
}
case wxStyledTextCtrl_SetTabIndents: { // wxStyledTextCtrl::SetTabIndents
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * tabIndents = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTabIndents(*tabIndents);
 break;
}
case wxStyledTextCtrl_GetTabIndents: { // wxStyledTextCtrl::GetTabIndents
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetTabIndents();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetBackSpaceUnIndents: { // wxStyledTextCtrl::SetBackSpaceUnIndents
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * bsUnIndents = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetBackSpaceUnIndents(*bsUnIndents);
 break;
}
case wxStyledTextCtrl_GetBackSpaceUnIndents: { // wxStyledTextCtrl::GetBackSpaceUnIndents
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetBackSpaceUnIndents();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetMouseDwellTime: { // wxStyledTextCtrl::SetMouseDwellTime
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * periodMilliseconds = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetMouseDwellTime(*periodMilliseconds);
 break;
}
case wxStyledTextCtrl_GetMouseDwellTime: { // wxStyledTextCtrl::GetMouseDwellTime
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetMouseDwellTime();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_WordStartPosition: { // wxStyledTextCtrl::WordStartPosition
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 bool * onlyWordCharacters = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->WordStartPosition(*pos,*onlyWordCharacters);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_WordEndPosition: { // wxStyledTextCtrl::WordEndPosition
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pos = (int *) bp; bp += 4;
 bool * onlyWordCharacters = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->WordEndPosition(*pos,*onlyWordCharacters);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetWrapMode: { // wxStyledTextCtrl::SetWrapMode
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * mode = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWrapMode(*mode);
 break;
}
case wxStyledTextCtrl_GetWrapMode: { // wxStyledTextCtrl::GetWrapMode
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWrapMode();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetWrapVisualFlags: { // wxStyledTextCtrl::SetWrapVisualFlags
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * wrapVisualFlags = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWrapVisualFlags(*wrapVisualFlags);
 break;
}
case wxStyledTextCtrl_GetWrapVisualFlags: { // wxStyledTextCtrl::GetWrapVisualFlags
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWrapVisualFlags();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetWrapVisualFlagsLocation: { // wxStyledTextCtrl::SetWrapVisualFlagsLocation
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * wrapVisualFlagsLocation = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWrapVisualFlagsLocation(*wrapVisualFlagsLocation);
 break;
}
case wxStyledTextCtrl_GetWrapVisualFlagsLocation: { // wxStyledTextCtrl::GetWrapVisualFlagsLocation
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWrapVisualFlagsLocation();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetWrapStartIndent: { // wxStyledTextCtrl::SetWrapStartIndent
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * indent = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetWrapStartIndent(*indent);
 break;
}
case wxStyledTextCtrl_GetWrapStartIndent: { // wxStyledTextCtrl::GetWrapStartIndent
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetWrapStartIndent();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetLayoutCache: { // wxStyledTextCtrl::SetLayoutCache
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * mode = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetLayoutCache(*mode);
 break;
}
case wxStyledTextCtrl_GetLayoutCache: { // wxStyledTextCtrl::GetLayoutCache
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetLayoutCache();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetScrollWidth: { // wxStyledTextCtrl::SetScrollWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pixelWidth = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetScrollWidth(*pixelWidth);
 break;
}
case wxStyledTextCtrl_GetScrollWidth: { // wxStyledTextCtrl::GetScrollWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->GetScrollWidth();
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_TextWidth: { // wxStyledTextCtrl::TextWidth
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * style = (int *) bp; bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((4+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 int Result = This->TextWidth(*style,text);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_GetEndAtLastLine: { // wxStyledTextCtrl::GetEndAtLastLine
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetEndAtLastLine();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_TextHeight: { // wxStyledTextCtrl::TextHeight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * line = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 int Result = This->TextHeight(*line);
 rt.addInt(Result);
 break;
}
case wxStyledTextCtrl_SetUseVerticalScrollBar: { // wxStyledTextCtrl::SetUseVerticalScrollBar
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * show = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetUseVerticalScrollBar(*show);
 break;
}
case wxStyledTextCtrl_GetUseVerticalScrollBar: { // wxStyledTextCtrl::GetUseVerticalScrollBar
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetUseVerticalScrollBar();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_AppendText: { // wxStyledTextCtrl::AppendText
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * textLen = (int *) bp; bp += 4;
 wxString text = wxString(bp, wxConvUTF8);
 bp += *textLen+((8-((0+ *textLen) & 7)) & 7);
 if(!This) throw wxe_badarg(0);
 This->AppendText(text);
 break;
}
case wxStyledTextCtrl_GetTwoPhaseDraw: { // wxStyledTextCtrl::GetTwoPhaseDraw
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 bool Result = This->GetTwoPhaseDraw();
 rt.addBool(Result);
 break;
}
case wxStyledTextCtrl_SetTwoPhaseDraw: { // wxStyledTextCtrl::SetTwoPhaseDraw
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * twoPhase = (bool *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->SetTwoPhaseDraw(*twoPhase);
 break;
}
case wxStyledTextCtrl_TargetFromSelection: { // wxStyledTextCtrl::TargetFromSelection
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->TargetFromSelection();
 break;
}
case wxStyledTextCtrl_LinesJoin: { // wxStyledTextCtrl::LinesJoin
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LinesJoin();
 break;
}
case wxStyledTextCtrl_LinesSplit: { // wxStyledTextCtrl::LinesSplit
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 int * pixelWidth = (int *) bp; bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LinesSplit(*pixelWidth);
 break;
}
case wxStyledTextCtrl_SetFoldMarginColour: { // wxStyledTextCtrl::SetFoldMarginColour
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * useSetting = (bool *) bp; bp += 4;
 int * backR = (int *) bp; bp += 4;
 int * backG = (int *) bp; bp += 4;
 int * backB = (int *) bp; bp += 4;
 int * backA = (int *) bp; bp += 4;
 wxColour back = wxColour(*backR,*backG,*backB,*backA);
 if(!This) throw wxe_badarg(0);
 This->SetFoldMarginColour(*useSetting,back);
 break;
}
case wxStyledTextCtrl_SetFoldMarginHiColour: { // wxStyledTextCtrl::SetFoldMarginHiColour
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 bool * useSetting = (bool *) bp; bp += 4;
 int * foreR = (int *) bp; bp += 4;
 int * foreG = (int *) bp; bp += 4;
 int * foreB = (int *) bp; bp += 4;
 int * foreA = (int *) bp; bp += 4;
 wxColour fore = wxColour(*foreR,*foreG,*foreB,*foreA);
 if(!This) throw wxe_badarg(0);
 This->SetFoldMarginHiColour(*useSetting,fore);
 break;
}
case wxStyledTextCtrl_LineDown: { // wxStyledTextCtrl::LineDown
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LineDown();
 break;
}
case wxStyledTextCtrl_LineDownExtend: { // wxStyledTextCtrl::LineDownExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LineDownExtend();
 break;
}
case wxStyledTextCtrl_LineUp: { // wxStyledTextCtrl::LineUp
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LineUp();
 break;
}
case wxStyledTextCtrl_LineUpExtend: { // wxStyledTextCtrl::LineUpExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LineUpExtend();
 break;
}
case wxStyledTextCtrl_CharLeft: { // wxStyledTextCtrl::CharLeft
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CharLeft();
 break;
}
case wxStyledTextCtrl_CharLeftExtend: { // wxStyledTextCtrl::CharLeftExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CharLeftExtend();
 break;
}
case wxStyledTextCtrl_CharRight: { // wxStyledTextCtrl::CharRight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CharRight();
 break;
}
case wxStyledTextCtrl_CharRightExtend: { // wxStyledTextCtrl::CharRightExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->CharRightExtend();
 break;
}
case wxStyledTextCtrl_WordLeft: { // wxStyledTextCtrl::WordLeft
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->WordLeft();
 break;
}
case wxStyledTextCtrl_WordLeftExtend: { // wxStyledTextCtrl::WordLeftExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->WordLeftExtend();
 break;
}
case wxStyledTextCtrl_WordRight: { // wxStyledTextCtrl::WordRight
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->WordRight();
 break;
}
case wxStyledTextCtrl_WordRightExtend: { // wxStyledTextCtrl::WordRightExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->WordRightExtend();
 break;
}
case wxStyledTextCtrl_Home: { // wxStyledTextCtrl::Home
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->Home();
 break;
}
case wxStyledTextCtrl_HomeExtend: { // wxStyledTextCtrl::HomeExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->HomeExtend();
 break;
}
case wxStyledTextCtrl_LineEnd: { // wxStyledTextCtrl::LineEnd
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LineEnd();
 break;
}
case wxStyledTextCtrl_LineEndExtend: { // wxStyledTextCtrl::LineEndExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->LineEndExtend();
 break;
}
case wxStyledTextCtrl_DocumentStart: { // wxStyledTextCtrl::DocumentStart
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DocumentStart();
 break;
}
case wxStyledTextCtrl_DocumentStartExtend: { // wxStyledTextCtrl::DocumentStartExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DocumentStartExtend();
 break;
}
case wxStyledTextCtrl_DocumentEnd: { // wxStyledTextCtrl::DocumentEnd
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) getPtr(bp,memenv); bp += 4;
 if(!This) throw wxe_badarg(0);
 This->DocumentEnd();
 break;
}
case wxStyledTextCtrl_DocumentEndExtend: { // wxStyledTextCtrl::DocumentEndExtend
 wxStyledTextCtrl *This = (wxStyledTextCtrl *) g