"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class QueryService {
  constructor(_client, logger) {
    this.logger = logger;
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "describeQueryInternal", async (request, format, responseFormat, context) => {
      try {
        const queryRequest = {
          query: request.body
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        let client = this.client;
        let queryResponse;
        const {
          dataSourceMDSId
        } = request.query;
        if (dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, params);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryInternal');
        this.logger.info(err);
        return {
          data: {
            ok: false,
            resp: err.response,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async (context, request) => {
      return this.describeQueryInternal(request, 'ppl.sqlQuery', 'json', context);
    });
    _defineProperty(this, "describePPLQuery", async (context, request) => {
      return this.describeQueryInternal(request, 'ppl.pplQuery', 'json', context);
    });
    this.client = _client;
  }
}
exports.QueryService = QueryService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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