"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IndexedGeometrySpatialMap = void 0;
var common_1 = require("../../../utils/common");
var d3_delaunay_1 = require("../../../utils/d3-delaunay");
var constants_1 = require("../rendering/constants");
var IndexedGeometrySpatialMap = (function () {
    function IndexedGeometrySpatialMap(points) {
        var _this = this;
        if (points === void 0) { points = []; }
        this.map = null;
        this.points = [];
        this.pointGeometries = [];
        this.searchStartIndex = 0;
        this.maxRadius = -Infinity;
        this.triangulation = function (bounds) { var _a; return (_a = _this.map) === null || _a === void 0 ? void 0 : _a.voronoi(bounds); };
        this.set(points);
    }
    Object.defineProperty(IndexedGeometrySpatialMap.prototype, "size", {
        get: function () {
            return this.points.length;
        },
        enumerable: false,
        configurable: true
    });
    IndexedGeometrySpatialMap.prototype.isSpatial = function () {
        return this.pointGeometries.length > 0;
    };
    IndexedGeometrySpatialMap.prototype.set = function (points) {
        var _a, _b;
        this.maxRadius = Math.max.apply(Math, __spread([this.maxRadius], points.map(function (_a) {
            var radius = _a.radius;
            return radius;
        })));
        (_a = this.pointGeometries).push.apply(_a, __spread(points));
        (_b = this.points).push.apply(_b, __spread(points.map(function (_a) {
            var x = _a.x, y = _a.y;
            var nonce = Math.random() * 0.000001;
            return [x + nonce, y];
        })));
        if (this.points.length > 0) {
            this.map = d3_delaunay_1.Delaunay.from(this.points);
        }
    };
    IndexedGeometrySpatialMap.prototype.getMergeData = function () {
        return __spread(this.pointGeometries);
    };
    IndexedGeometrySpatialMap.prototype.keys = function () {
        return this.pointGeometries.map(function (_a) {
            var x = _a.value.x;
            return x;
        });
    };
    IndexedGeometrySpatialMap.prototype.find = function (point) {
        var elements = [];
        if (this.map !== null) {
            var index = this.map.find(point.x, point.y, this.searchStartIndex);
            var geometry = this.pointGeometries[index];
            if (geometry) {
                this.searchStartIndex = index;
                elements.push(geometry);
                elements.push.apply(elements, __spread(this.getRadialNeighbors(index, point, new Set([index]))));
            }
        }
        return elements;
    };
    IndexedGeometrySpatialMap.prototype.getRadialNeighbors = function (selectedIndex, point, visitedIndices) {
        var _this = this;
        if (this.map === null) {
            return [];
        }
        var neighbors = __spread(this.map.neighbors(selectedIndex));
        return neighbors.reduce(function (acc, i) {
            if (visitedIndices.has(i)) {
                return acc;
            }
            visitedIndices.add(i);
            var geometry = _this.pointGeometries[i];
            if (geometry) {
                acc.push(geometry);
                if (common_1.getDistance(geometry, point) < Math.min(_this.maxRadius, constants_1.DEFAULT_HIGHLIGHT_PADDING)) {
                    acc.push.apply(acc, __spread(_this.getRadialNeighbors(i, point, visitedIndices)));
                }
            }
            return acc;
        }, []);
    };
    return IndexedGeometrySpatialMap;
}());
exports.IndexedGeometrySpatialMap = IndexedGeometrySpatialMap;
//# sourceMappingURL=indexed_geometry_spatial_map.js.map