# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::Gitea::Error
  class WebError < ::StandardError
    def initialize(message: nil)
      super(message || 'Gitea WebError')
    end
  end

  class CsrfError < WebError
    def initialize
      super(message: 'Unable to get CSRF token')
    end
  end

  class AuthenticationError < WebError
    def initialize
      super(message: 'Authentication failed')
    end
  end

  class MigrationError < WebError
    def initialize(message)
      super(message: message)
    end
  end

  class RepositoryError < WebError
    def initialize(message)
      super(message: message)
    end
  end

  class UnknownError < WebError
    def initialize(message)
      super(message: message)
    end
  end

  class VersionError < WebError
    def initialize
      super(message: 'Unable to determine Gitea version')
    end
  end
end
